/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Cercle;
import cds.aladin.Chaine;
import cds.aladin.Coord;
import cds.aladin.FilterProperties;
import cds.aladin.Forme;
import cds.aladin.FrameHeaderFits;
import cds.aladin.Legende;
import cds.aladin.Ligne;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGCat;
import cds.aladin.PlanField;
import cds.aladin.PlanFilter;
import cds.aladin.PlanFov;
import cds.aladin.PlanImage;
import cds.aladin.PlanTool;
import cds.aladin.PlaneLoadEvent;
import cds.aladin.PlaneLoadListener;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.RectangleD;
import cds.aladin.Repere;
import cds.aladin.Server;
import cds.aladin.ServerDialog;
import cds.aladin.Slide;
import cds.aladin.Source;
import cds.aladin.ViewSimple;
import cds.astro.Astropos;
import cds.astro.Astrotime;
import cds.astro.Unit;
import cds.tools.Util;
import cds.xml.TableParser;
import java.awt.Color;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class Plan
implements Runnable {
    static String NOREDUCTION;
    protected static final int STATUS_UNKNOWN = 0;
    protected static final int STATUS_INPROGRESS = 1;
    protected static final int STATUS_MOREDETAILSAVAILABLE = 2;
    protected static final int STATUS_ERROR = 4;
    protected static final int STATUS_EMPTYMOC = 8;
    protected static final int STATUS_OVERFLOW = 16;
    protected static final int STATUS_NOCALIB = 32;
    protected static final int STATUS_EMPTYCAT = 64;
    protected static final int STATUS_LOADING = 128;
    protected static final int STATUS_READY = 256;
    private static final String[] STATUS;
    static final int NO = 0;
    static final int IMAGE = 1;
    static final int IMAGERGB = 2;
    static final int IMAGEBLINK = 3;
    static final int IMAGECUBE = 4;
    static final int IMAGERSP = 5;
    static final int IMAGEMOSAIC = 6;
    static final int IMAGEALGO = 7;
    static final int CATALOG = 8;
    static final int TOOL = 9;
    static final int APERTURE = 10;
    static final int FOLDER = 11;
    static final int FILTER = 12;
    static final int FOV = 13;
    static final int X = 14;
    static final int IMAGEHUGE = 15;
    static final int ALLSKYIMG = 16;
    static final int ALLSKYPOL = 17;
    static final int ALLSKYCAT = 18;
    static final int ALLSKYMOC = 19;
    static final int IMAGECUBERGB = 20;
    static final int ALLSKYFINDEX = 21;
    static final int ALLSKYCUBE = 22;
    static String[] Tp;
    protected int type;
    protected int folder;
    protected Slide slide = null;
    protected boolean isOldPlan;
    protected boolean noBestPlacePost;
    protected boolean collapse;
    protected String objet;
    public String label;
    protected String param;
    protected String description = null;
    protected String verboseDescr = null;
    protected String ack = null;
    protected String copyright = null;
    protected String copyrightUrl = null;
    protected double coRadius;
    protected Coord co;
    protected Color c;
    protected Astrotime epoch;
    protected Projection projd;
    protected Projection projInit;
    protected Hashtable projD = null;
    protected FrameHeaderFits headerFits;
    private boolean hasSpecificCalib;
    protected String filename;
    protected Server server;
    protected float opacityLevel = 1.0f;
    protected Color colorBackground = null;
    protected String startingTaskId = null;
    boolean[] influence = new boolean[PlanFilter.LIMIT];
    protected boolean log = true;
    protected String[] filters;
    protected int filterIndex = -1;
    protected PlanFilter planFilter = null;
    boolean flagOk;
    boolean flagSkip;
    boolean flagProcessing;
    boolean flagUpdating;
    boolean flagWaitTarget;
    boolean active;
    boolean askActive;
    boolean selected;
    boolean isLastVisible;
    boolean underMouse;
    boolean ref;
    int hasPM = -1;
    protected boolean memoClinDoeil;
    Projection[] proj = new Projection[16];
    String error;
    int status;
    boolean flagLocal;
    protected boolean hasXYorig;
    protected boolean recalibrating;
    protected boolean isSelectable = true;
    protected boolean doClose = true;
    protected double initZoom = 1.0;
    protected double lastZoomView = 0.0;
    protected double lastXZoomView;
    protected double lastYZoomView;
    long statNbComputing = 0L;
    long statTimeComputing = 0L;
    long statTimeDisplay = 0L;
    long statNbItems = 0L;
    Pcat pcat;
    int sourceType = 1;
    boolean fullSource = false;
    MyInputStream dis = null;
    Thread runme;
    URL u;
    Vector<String> plasticIDs;
    Aladin aladin;
    private String bookmarkCode = null;
    protected float scalingFactor = 1.0f;
    double pourcent = -1.0;
    static final int REFFORVISIBLEVIEW = 1;
    static final int CANBETRANSP = 2;
    static final int OUTOFVIEW = 4;
    static final int VIEWABLE = 8;
    static final int ACTIVATED = 16;
    static final int ASKACTIVATED = 32;
    static final int REF = 64;
    static final int FLAGOK = 128;
    static final int FLAGPROCESSING = 256;
    static final int FLAGUPDATING = 512;
    static final int SELECTED = 1024;
    static final int UNDERIMG = 2048;
    static final int UNDERBKGD = 4096;
    static final String[] DEBUGFLAG;
    private int debugFlag = 0;
    private boolean hasCheckBox = false;
    private long startCheckBoxBlink = 0L;
    private Vector listeners = new Vector();
    protected static final String ALADINQUERY = "AladinQuery";
    private long startTime;

    protected static void createChaine(Chaine chaine) {
        NOREDUCTION = chaine.getString("NORED");
    }

    protected Plan() {
        this.type = 14;
        this.aladin = Aladin.aladin;
        this.flagOk = false;
        this.label = "";
        this.startTime = System.currentTimeMillis();
    }

    protected Plan(Aladin aladin) {
        this.aladin = aladin;
    }

    protected String getBookmarkCode() {
        return this.bookmarkCode;
    }

    protected void setBookmarkCode(String string) {
        this.bookmarkCode = string;
    }

    protected void copy(Plan plan) {
        plan.type = this.type;
        plan.folder = this.folder;
        plan.collapse = this.collapse;
        plan.objet = this.objet;
        plan.param = this.param;
        plan.label = this.label;
        plan.description = this.description;
        plan.verboseDescr = this.verboseDescr;
        plan.ack = this.ack;
        plan.copyright = this.copyright;
        plan.copyrightUrl = this.copyrightUrl;
        plan.co = this.co;
        plan.c = this.c;
        plan.projd = this.projd == null ? null : this.projd.copy();
        plan.projInit = this.projInit;
        plan.projD = this.projD;
        plan.hasSpecificCalib = this.hasSpecificCalib;
        plan.influence = new boolean[this.influence.length];
        System.arraycopy(this.influence, 0, plan.influence, 0, this.influence.length);
        plan.log = this.log;
        plan.flagOk = this.flagOk;
        plan.active = this.active;
        plan.askActive = this.askActive;
        plan.selected = this.selected;
        plan.underMouse = this.underMouse;
        plan.ref = this.ref;
        plan.proj = new Projection[this.proj.length];
        System.arraycopy(this.proj, 0, plan.proj, 0, this.proj.length);
        plan.error = this.error;
        plan.flagLocal = this.flagLocal;
        plan.hasPM = this.hasPM;
        plan.hasXYorig = this.hasXYorig;
        plan.initZoom = this.initZoom;
        plan.lastZoomView = this.lastZoomView;
        plan.lastXZoomView = this.lastXZoomView;
        plan.lastYZoomView = this.lastYZoomView;
        plan.pcat = this.pcat;
        plan.u = this.u;
        plan.filename = this.filename;
        plan.opacityLevel = this.opacityLevel;
        plan.active = this.active;
        plan.ref = this.ref;
    }

    public void finalize() throws Throwable {
        this.Free();
    }

    protected boolean isSED() {
        if (this.getCounts() == 0) {
            return false;
        }
        Obj obj = this.iterator().next();
        return obj instanceof Source && ((Source)obj).leg != null && ((Source)obj).leg.isSED();
    }

    protected boolean isOverlay() {
        return this.isCatalog() || this.isPlanBGOverlay() || this instanceof PlanTool || this instanceof PlanField || this instanceof PlanFov || this instanceof PlanFilter;
    }

    protected boolean isPixel() {
        return this.isImage() || this.type == 16;
    }

    protected final boolean isImage() {
        return this.type == 1 || this.type == 2 || this.type == 15 || this.type == 3 || this.type == 4 || this.type == 5 || this.type == 7 || this.type == 6 || this.type == 20;
    }

    protected final boolean isSimpleImage() {
        return this.type == 1 || this.type == 5 || this.type == 7 || this.type == 6 || this.type == 15;
    }

    public final boolean hasAvailablePixels() {
        return this.hasOriginalPixels();
    }

    protected boolean hasOriginalPixels() {
        return false;
    }

    protected final boolean hasNoReduction() {
        return this.error == NOREDUCTION;
    }

    protected boolean isReady() {
        return this.type != 0 && this.flagOk && (this.error == null || this.hasNoReduction());
    }

    protected String getStackStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.status != 0) {
            int n = 1;
            int n2 = 1;
            while (n2 < STATUS.length) {
                if ((n & this.status) != 0) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(Aladin.chaine.getString(STATUS[n2]));
                }
                ++n2;
                n <<= 1;
            }
        }
        if (this instanceof PlanBG) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append("HiPS order: " + ((PlanBG)this).getInfoDetails());
        }
        return stringBuilder.toString();
    }

    public boolean hasError() {
        if (!this.flagOk) {
            return false;
        }
        if (this.hasNoReduction() && this.error != null) {
            return false;
        }
        return this.error != null;
    }

    protected void setSourceType(int n) {
        Iterator<Obj> iterator = this.iterator();
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (!(obj instanceof Source)) continue;
            Source source = (Source)obj;
            source.setSourceType(n);
        }
        this.sourceType = n;
    }

    public void setSelectable(boolean bl) {
        this.isSelectable = bl;
    }

    public boolean isSelectable() {
        return this.isSelectable;
    }

    public boolean isFree() {
        return this.type == 0;
    }

    protected boolean isEmpty() {
        if (this.type == 0) {
            return false;
        }
        return this.hasError() || (this.isCatalog() || this.type == 9) && this.getCounts() == 0;
    }

    protected boolean hasFitsHeader() {
        return this.headerFits != null;
    }

    protected boolean hasSources() {
        return this.isCatalog() && this.iterator().hasNext();
    }

    protected boolean hasObj() {
        return this.pcat != null && this.pcat.hasObj();
    }

    protected boolean isPlanBGOverlay() {
        return this.type == 17 || this.type == 18;
    }

    protected boolean isOnPixel(int n, int n2) {
        return false;
    }

    protected boolean isCatalog() {
        return false;
    }

    protected boolean isCube() {
        return false;
    }

    protected void activeCubePixels(ViewSimple viewSimple) {
    }

    public int getDepth() {
        return 1;
    }

    protected double getZ(ViewSimple viewSimple) {
        return 0.0;
    }

    protected double getZ() {
        return 0.0;
    }

    protected void setZ(double d) {
    }

    protected byte getPixel8bit(int n, double d, double d2) {
        return 0;
    }

    protected void setPause(boolean bl, ViewSimple viewSimple) {
    }

    protected boolean isPause() {
        return true;
    }

    protected int getInitDelay() {
        return 400;
    }

    synchronized void changeImgID() {
    }

    protected boolean setCubeFrame(double d) {
        return false;
    }

    protected boolean isTool() {
        return this.type == 9 || this.type == 19 || this.type == 10 || this.type == 13;
    }

    protected boolean isSimpleCatalog() {
        return this.type == 8 || this.type == 9 && this.isCatalog();
    }

    protected boolean isSourceRemovable() {
        return this.pcat != null && this.pcat.removable;
    }

    protected boolean isMovable() {
        return true;
    }

    protected void setSourceRemovable(boolean bl) {
        this.pcat.removable = bl;
    }

    protected String getStats() throws Exception {
        if (!this.isCatalog()) {
            throw new Exception("Not a PlanCatalog");
        }
        int n = 0;
        int n2 = 0;
        boolean bl = PlanFilter.allFilters.length > 0;
        int n3 = 0;
        Iterator<Obj> iterator = this.iterator();
        n3 = 0;
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (obj instanceof Source) {
                Source source = (Source)obj;
                if (source.isSelected()) {
                    ++n;
                }
                if (bl && source.isSelectedInFilter()) {
                    ++n2;
                }
            }
            ++n3;
        }
        return n3 + " src" + (bl ? "/" + n2 + " filt" : "") + (n != 0 ? "/" + n + " sel" : "");
    }

    protected Legende getFirstLegende() {
        return null;
    }

    protected Vector<Legende> getLegende() {
        return null;
    }

    protected int getNbTable() {
        return 0;
    }

    protected int getCounts() {
        return 0;
    }

    protected void reallocObjetCache() {
        if (this.pcat != null) {
            this.pcat.reallocObjetCache();
        }
    }

    protected Astrotime getEpoch() {
        try {
            if (this.epoch == null) {
                this.epoch = new Astrotime("J2000");
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this.epoch;
    }

    protected void setEpoch(String string) throws Exception {
        if (Character.isDigit(string.charAt(0))) {
            string = "J" + string;
        }
        if (this.epoch == null) {
            this.epoch = new Astrotime(string);
        } else {
            this.epoch.set(string);
        }
        if (!this.recomputePosition()) {
            throw new Exception("Unknown proper motion fields !");
        }
    }

    protected Obj[] getObj() {
        return new Obj[0];
    }

    public float getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor(float f) {
        this.scalingFactor = f;
    }

    protected Vector<Obj> setMultiSelect(ViewSimple viewSimple, RectangleD rectangleD) {
        if (!this.isSelectable()) {
            return new Vector<Obj>();
        }
        if (!(this instanceof PlanBG) && this.pcat != null && !this.pcat.isDrawnInSimpleView(viewSimple.n)) {
            return new Vector<Obj>();
        }
        Vector<Obj> vector = new Vector<Obj>(5000);
        Iterator<Obj> iterator = this.iterator(viewSimple);
        while (iterator != null && iterator.hasNext()) {
            Obj obj = iterator.next();
            if (!(obj instanceof Position)) continue;
            Position position = (Position)obj;
            if (position.plan.type == 13 || position instanceof Forme || !position.inRectangle(viewSimple, rectangleD) || position instanceof Source && !((Source)position).noFilterInfluence() && !((Source)position).isSelectedInFilter()) continue;
            position.setSelect(true);
            vector.addElement(position);
        }
        return vector;
    }

    protected Vector<Obj> getObjWith(ViewSimple viewSimple, double d, double d2) {
        if (!this.isSelectable()) {
            return new Vector<Obj>();
        }
        if (this.pcat != null && !this.pcat.isDrawnInSimpleView(viewSimple.n)) {
            return new Vector<Obj>(1);
        }
        Vector<Obj> vector = new Vector<Obj>(500);
        Iterator<Obj> iterator = this.iterator(viewSimple);
        if (iterator == null) {
            return new Vector<Obj>(1);
        }
        if (this.type == 10) {
            int n = 0;
            while (iterator.hasNext()) {
                Obj obj = iterator.next();
                if (obj.in(viewSimple, d, d2)) {
                    if (n == 0 && Aladin.ROTATEFOVCENTER && ((PlanField)this).isRollable() && ((PlanField)this).isCenterRollable()) {
                        this.aladin.calque.planRotCenter = ((Repere)obj).plan;
                        vector.addElement(obj);
                    } else {
                        this.aladin.calque.planRotCenter = null;
                        Iterator<Obj> iterator2 = this.iterator(viewSimple);
                        while (iterator2.hasNext()) {
                            vector.addElement(iterator2.next());
                        }
                    }
                    break;
                }
                ++n;
            }
        } else {
            Vector<Ligne> vector2 = new Vector<Ligne>();
            while (iterator.hasNext()) {
                boolean bl;
                Obj obj = iterator.next();
                if (obj instanceof Ligne && ((Ligne)obj).inPolygon(viewSimple, (int)d, (int)d2)) {
                    vector2.addElement((Ligne)obj);
                }
                if (!(bl = obj instanceof Cercle ? obj.in(viewSimple, d, d2) : obj.inside(viewSimple, d, d2)) || obj instanceof Source && !((Source)obj).noFilterInfluence() && !((Source)obj).isSelectedInFilter()) continue;
                vector.addElement(obj);
            }
            for (Ligne ligne : vector2) {
                ligne = ligne.getFirstBout();
                while (ligne != null) {
                    if (!vector.contains(ligne)) {
                        vector.addElement(ligne);
                    }
                    ligne = ligne.finligne;
                }
            }
        }
        return vector;
    }

    public boolean hasPM() {
        if (!this.flagOk || !this.isCatalog()) {
            return false;
        }
        if (this.hasPM < 0) {
            Vector<Legende> vector = this.getLegende();
            if (vector == null) {
                return false;
            }
            for (Legende legende : vector) {
                if (legende == null || legende.getPmRa() <= 0 || legende.getPmDe() <= 0) continue;
                this.hasPM = 1;
                return true;
            }
            this.hasPM = 0;
            return false;
        }
        return this.hasPM == 1;
    }

    public boolean recomputePosition() {
        boolean bl = false;
        Vector<Legende> vector = this.getLegende();
        if (vector == null) {
            return false;
        }
        for (Legende legende : vector) {
            int n = legende.getPmRa();
            int n2 = legende.getPmDe();
            if (n <= 0 || n2 <= 0) continue;
            int n3 = legende.getRa();
            int n4 = legende.getDe();
            this.recomputePosition(this.iterator(), legende, n3, n4, n, n2);
            bl = true;
        }
        if (bl) {
            this.aladin.view.newView(1);
        }
        return bl;
    }

    public void recomputePosition(Iterator<Obj> iterator, Legende legende, int n, int n2, int n3, int n4) {
        double d = this.getEpoch().getJyr();
        int n5 = 0;
        int n6 = 0;
        double d2 = Double.NaN;
        try {
            d2 = new Astrotime("J2000").getJyr();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Astropos astropos = new Astropos();
        while (iterator.hasNext()) {
            try {
                block15: {
                    Source source = (Source)iterator.next();
                    if (source.leg != legende) continue;
                    String string = source.getValue(n);
                    String string2 = source.getValue(n2);
                    n5 = TableParser.getRaDec(astropos, string, string2, n5);
                    if (n3 > 0 && n4 > 0) {
                        try {
                            Unit unit = new Unit();
                            try {
                                unit.setUnit(source.getUnit(n3));
                                unit.setValue(source.getValue(n3));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            Unit unit2 = new Unit();
                            try {
                                unit2.setUnit(source.getUnit(n4));
                                unit2.setValue(source.getValue(n4));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            if (unit.getValue() == 0.0 && unit2.getValue() == 0.0) break block15;
                            try {
                                unit.convertTo(new Unit("mas/yr"));
                            }
                            catch (Exception exception) {
                                unit.setUnit(source.getUnit(n3));
                                unit.setValue(source.getValue(n3));
                                unit.convertTo(new Unit("ms/yr"));
                                double d3 = 15.0 * unit.getValue() * Math.cos(astropos.getLat() * Math.PI / 180.0);
                                unit = new Unit(d3 + "mas/yr");
                            }
                            double d4 = unit.getValue();
                            unit2.convertTo(new Unit("mas/yr"));
                            double d5 = unit2.getValue();
                            astropos.set(astropos.getLon(), astropos.getLat(), d2, d4, d5);
                            astropos.toEpoch(d);
                        }
                        catch (Exception exception) {
                            if (++n6 <= 100) break block15;
                            if (Aladin.levelTrace >= 3) {
                                exception.printStackTrace();
                            }
                            Aladin.warning("Too many error during proper motion computation !\n" + exception.getMessage());
                            break;
                        }
                    }
                }
                source.raj = astropos.getLon();
                source.dej = astropos.getLat();
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) continue;
                exception.printStackTrace();
            }
        }
    }

    public void modifyRaDecField(Legende legende, int n, int n2, int n3, int n4) {
        Aladin.trace(3, this.label + " new J2000 => RA pos=" + (n + 1) + " DE pos=" + (n2 + 1) + " PMRA pos=" + (n3 + 1) + " PMDE pos=" + (n4 + 1));
        this.recomputePosition(this.iterator(), legende, n, n2, n3, n4);
        if (this.hasXYorig) {
            this.hasXYorig = false;
            this.error = null;
        }
        this.aladin.view.newView(1);
        this.aladin.view.repaintAll();
        String string = "New J2000 fields for " + this.label + "\n=> RA column " + (n + 1) + " -  DE column " + (n2 + 1) + (n3 > 0 ? " -  PMRA column " + (n3 + 1) : "") + (n4 > 0 ? " -  PMDEC column " + (n4 + 1) : "");
        Aladin.trace(2, string);
        Aladin.info(this.aladin, string);
    }

    public void modifyXYField(Legende legende, int n, int n2) {
        Aladin.trace(3, this.label + " new XY coordinate fields => X pos=" + (n + 1) + " Y pos=" + (n2 + 1));
        Iterator<Obj> iterator = this.iterator();
        while (iterator.hasNext()) {
            try {
                Source source = (Source)iterator.next();
                if (source.leg != legende) continue;
                source.x = Double.parseDouble(source.getValue(n));
                source.y = Double.parseDouble(source.getValue(n2));
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) continue;
                exception.printStackTrace();
            }
        }
        if (!this.hasXYorig) {
            this.hasXYorig = true;
            this.error = NOREDUCTION;
        }
        this.aladin.view.newView(1);
        this.aladin.view.repaintAll();
        Aladin.info(this.aladin, "New XY fields for " + this.label + "\n=> X column " + (n + 1) + " -  Y column " + (n2 + 1));
    }

    protected void memoInfoZoom(ViewSimple viewSimple) {
        this.lastZoomView = viewSimple.zoom;
        this.lastXZoomView = viewSimple.xzoomView;
        this.lastYZoomView = viewSimple.yzoomView;
    }

    protected boolean initInfoZoom(ViewSimple viewSimple) {
        if (this.lastZoomView == 0.0) {
            return false;
        }
        viewSimple.zoom = this.lastZoomView;
        viewSimple.xzoomView = this.lastXZoomView;
        viewSimple.yzoomView = this.lastYZoomView;
        return true;
    }

    protected boolean theSame(int n, String string, String string2) {
        return this.theSame(n, string, string2, null);
    }

    protected boolean theSame(int n, String string, String string2, String string3) {
        if (n != this.type) {
            return false;
        }
        if (!this.egale(this.objet, string)) {
            return false;
        }
        if (!this.egale(this.param, string2)) {
            return false;
        }
        if (string3 != null) {
            String string4 = "";
            switch (n) {
                case 1: 
                case 15: {
                    PlanImage planImage = (PlanImage)this;
                    string4 = planImage.fmt + "/" + planImage.res;
                }
            }
            if (!string3.equals(string4)) {
                return false;
            }
        }
        return true;
    }

    private boolean egale(String string, String string2) {
        if (string == string2) {
            return true;
        }
        return string == null && string2 == null || string != null && string2 != null && string.equals(string2);
    }

    protected boolean equals(Plan plan) {
        if (!this.theSame(plan.type, plan.objet, plan.param)) {
            return false;
        }
        if (this instanceof PlanImage && plan instanceof PlanImage && !PlanImage.sameFmtRes(this, plan)) {
            return false;
        }
        if (this.error == null && plan.error != null || this.error != null && plan.error == null) {
            return false;
        }
        if (this.error != null && plan.error != null && !this.error.equals(plan.error)) {
            return false;
        }
        if (this.flagOk != plan.flagOk) {
            return false;
        }
        return this.projd == plan.projd;
    }

    protected double getPourcent() {
        return this.pourcent;
    }

    protected void setPourcent(double d) {
        this.pourcent = d;
    }

    protected static String throughput(double d) {
        String string = "B";
        if (d > 1024.0) {
            d /= 1024.0;
            string = "KB";
        }
        if (d > 1024.0) {
            d /= 1024.0;
            string = "MB";
        }
        return Util.myRound(d + "", 2) + " " + string + "/s";
    }

    protected void sendLog(String string, String string2) {
        string2 = string2.replace('\n', ' ');
        string2 = string2.replace('\r', ' ');
        if (this.log) {
            this.aladin.log(string, string2);
        }
    }

    void setLogMode(boolean bl) {
        this.log = bl;
    }

    protected boolean Free() {
        this.setLogMode(false);
        try {
            if (this.dis != null && (this.server == null || this.server != this.aladin.dialog.server[ServerDialog.ALADIN])) {
                this.dis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.aladin.dialog != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Plan.this.aladin.dialog.resume();
                }
            });
        }
        final Plan[] planArray = new Plan[]{this};
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Properties.disposeProperties(planArray[0]);
            }
        });
        if (this.aladin.frameCM != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Plan.this.aladin.frameCM.disposeFrameCM(planArray[0]);
                }
            });
        }
        if (this.aladin.frameNewCalib != null && this.aladin.frameNewCalib.plan == this) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Plan.this.aladin.frameNewCalib.hide();
                }
            });
        }
        if (this.server != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Plan.this.server != null) {
                        Plan.this.server.setStatus();
                    }
                    Plan.this.server = null;
                }
            });
        }
        if (this.pcat != null) {
            this.pcat.free();
        }
        if (this.headerFits != null) {
            this.headerFits.free();
        }
        this.init();
        return true;
    }

    protected void init() {
        this.type = 0;
        this.hasPM = -1;
        this.flagOk = false;
        this.isOldPlan = false;
        this.flagWaitTarget = false;
        this.hasSpecificCalib = false;
        this.copyrightUrl = null;
        this.copyright = null;
        this.ack = null;
        this.verboseDescr = null;
        this.description = null;
        this.param = null;
        this.label = null;
        this.error = null;
        this.objet = null;
        this.flagSkip = false;
        this.co = null;
        this.projInit = null;
        this.projd = null;
        this.projD = null;
        this.pcat = null;
        this.headerFits = null;
        this.recalibrating = false;
        this.underMouse = false;
        this.hasXYorig = false;
        this.ref = false;
        this.active = false;
        this.selected = false;
        this.flagOk = false;
        this.collapse = false;
        this.memoClinDoeil = false;
        this.resetProj();
        this.folder = 0;
        this.initZoom = 1.0;
        this.filename = null;
        this.dis = null;
        this.server = null;
        this.filters = null;
        this.slide = null;
    }

    protected void setXYorig(boolean bl) {
        this.hasXYorig = bl;
    }

    protected boolean hasXYorig() {
        return this.hasXYorig;
    }

    protected void setXYorig() {
        Aladin.trace(3, "create original XY from RA,DEC for plane " + this);
        Iterator<Obj> iterator = this.pcat.iterator();
        while (iterator.hasNext()) {
            ((Position)iterator.next()).setXY(this.projd);
        }
        this.hasXYorig = true;
    }

    protected String getFilterDescription() {
        if (this.filterIndex < 0 || this.filters == null) {
            return "no dedicated filter";
        }
        return Server.getFilterDescription(this.filters[this.filterIndex]);
    }

    protected PlanFilter getFilter() {
        return this.planFilter;
    }

    protected void setFilter(String string) {
        if (this.filters == null) {
            return;
        }
        int n = this.findFilter(string);
        this.setFilter(n);
    }

    protected int findFilter(String string) {
        if (this.filters == null) {
            return -1;
        }
        for (int i = 0; i < this.filters.length; ++i) {
            String string2 = Server.getFilterDescription(this.filters[i]);
            if (string2 != null && Util.indexOfIgnoreCase(string2, string) >= 0) {
                return i;
            }
            string2 = Server.getFilterName(this.filters[i]);
            if (string2 == null || Util.indexOfIgnoreCase(string2, string) < 0) continue;
            return i;
        }
        return -1;
    }

    protected void addFilter(String string) {
        int n = this.findFilter(string);
        if (n >= 0) {
            this.filters[n] = string;
            Aladin.trace(4, "Plan.addFilter(): replace:" + Server.getFilterName(string));
        } else {
            String[] stringArray;
            if (this.filters == null) {
                stringArray = new String[1];
            } else {
                stringArray = new String[this.filters.length + 1];
                System.arraycopy(this.filters, 0, stringArray, 0, this.filters.length);
            }
            stringArray[stringArray.length - 1] = string;
            this.filters = stringArray;
            Aladin.trace(4, "Plan.addFilter(): add:" + Server.getFilterName(string));
        }
        if (this.filterIndex == -1) {
            this.filterIndex = this.aladin.configuration.getFilter();
        }
    }

    protected void setFilter(int n) {
        if (this.filters == null) {
            return;
        }
        this.filterIndex = n;
        if (n < 0) {
            this.planFilter = null;
            PlanFilter.updateAllFilters(this.aladin);
            this.aladin.calque.repaintAll();
            return;
        }
        PlanFilter.updateAllFilters(this.aladin);
        String string = Server.getFilterName(this.filters[n]);
        String string2 = Server.getFilterScript(this.filters[n]);
        if (this.planFilter == null) {
            this.planFilter = new PlanFilter(this.aladin, string, string2, this);
            this.planFilter.applyFilter();
            PlanFilter.updateAllFilters(this.aladin);
        } else {
            this.planFilter.updateDefinition(string2, string, null);
        }
    }

    protected void updateDedicatedFilter() {
        if (this.planFilter == null) {
            return;
        }
        PlanFilter.updateNow();
    }

    protected void toGenericalFilter() {
        if (this.filterIndex < 0) {
            return;
        }
        int n = this.filterIndex;
        this.setFilter(-1);
        PlanFilter planFilter = this.aladin.command.createFilter(Server.getFilter(this.filters[n]));
        if (planFilter != null) {
            Properties.createProperties(planFilter);
        }
    }

    protected boolean hasDedicatedFilter() {
        return this.filterIndex >= 0;
    }

    protected void getXYRange(double[] dArray) {
        dArray[2] = Double.POSITIVE_INFINITY;
        dArray[0] = Double.POSITIVE_INFINITY;
        dArray[3] = Double.NEGATIVE_INFINITY;
        dArray[1] = Double.NEGATIVE_INFINITY;
        Iterator<Obj> iterator = this.pcat.iterator();
        while (iterator.hasNext()) {
            Position position = (Position)iterator.next();
            if (position.x < dArray[0]) {
                dArray[0] = position.x;
            }
            if (position.x > dArray[1]) {
                dArray[1] = position.x;
            }
            if (position.y < dArray[2]) {
                dArray[2] = position.y;
            }
            if (!(position.y > dArray[3])) continue;
            dArray[3] = position.y;
        }
    }

    protected void modifyProj(String string) {
        int n = Projection.getProjType(string);
        Projection projection = this.projd;
        if (projection == null || n == -1) {
            return;
        }
        this.modifyProj(null, 3, projection.alphai, projection.deltai, projection.rm1, projection.cx, projection.cy, projection.r1, projection.rot, projection.sym, n, projection.system);
        this.aladin.view.newView(1);
        this.aladin.calque.repaintAll();
    }

    protected void modifyProj(String string, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, int n2, int n3) {
        this.projd.modify(string, n, d, d2, d3, d3, d4, d5, d6, d6, d7, bl, n2, n3);
        this.syncProjLocal();
    }

    protected void syncProjLocal() {
    }

    protected void resetProj(int n) {
        this.proj[n] = null;
    }

    protected void resetProj() {
        for (int i = 0; i < 16; ++i) {
            this.resetProj(i);
        }
    }

    protected void setHasSpecificCalib() {
        this.hasSpecificCalib = true;
    }

    protected boolean hasSpecificCalib() {
        return this.hasSpecificCalib;
    }

    protected void setNewProjD(Projection projection) {
        if (this.projD == null) {
            this.projD = new Hashtable();
            this.projInit = projection;
        }
        this.projD.put(projection.label, projection);
        this.projd = projection;
        if (this.error != null && this.hasNoReduction()) {
            this.error = null;
        }
    }

    protected Plan[] getAvailablePlanRef() {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        if (this.isImage() || this instanceof PlanBG) {
            vector.addElement(this);
        } else {
            Plan[] planArray = this.aladin.calque.getPlans();
            for (int i = 0; i < planArray.length; ++i) {
                object = planArray[i];
                if (!((Plan)object).isImage() && !((Plan)object).isCatalog() || !this.aladin.calque.canBeRef((Plan)object) || !((Plan)object).flagOk || !Projection.isOk(this.projd) || !this.projd.agree(((Plan)object).projd, null)) continue;
                vector.addElement(object);
            }
        }
        int n = vector.size();
        Plan[] planArray = new Plan[n];
        object = vector.elements();
        for (int i = 0; i < n; ++i) {
            planArray[i] = (Plan)object.nextElement();
        }
        return planArray;
    }

    protected Projection[] getAvailableProj() {
        Enumeration<Object> enumeration;
        Vector<Projection> vector = new Vector<Projection>();
        if (this.projD != null) {
            enumeration = this.projD.keys();
            while (enumeration.hasMoreElements()) {
                Projection projection = (Projection)this.projD.get(enumeration.nextElement());
                vector.addElement(projection);
            }
        }
        int n = vector.size();
        Projection[] projectionArray = new Projection[n];
        enumeration = vector.elements();
        for (int i = 0; i < n; ++i) {
            projectionArray[i] = (Projection)enumeration.nextElement();
        }
        return projectionArray;
    }

    protected boolean isRefForVisibleView() {
        block3: {
            try {
                for (int i = this.aladin.view.getModeView() - 1; i >= 0; --i) {
                    ViewSimple viewSimple = this.aladin.view.viewSimple[i];
                    if (viewSimple.pref != this) continue;
                    this.setDebugFlag(1, true);
                    return true;
                }
                this.setDebugFlag(1, false);
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block3;
                exception.printStackTrace();
            }
        }
        return false;
    }

    protected boolean hasCanBeTranspState() {
        return (this.debugFlag & 2) == 2;
    }

    protected boolean isUnderImg() {
        return (this.debugFlag & 0x1800) != 0;
    }

    protected boolean isUnderImgBkgd() {
        return (this.debugFlag & 0x1000) != 0;
    }

    protected void setHasCheckBox(boolean bl) {
        this.hasCheckBox = bl;
    }

    protected boolean hasCheckBox() {
        return this.hasCheckBox;
    }

    protected void setDebugFlag(int n, boolean bl) {
        this.debugFlag = bl ? (this.debugFlag |= n) : (this.debugFlag &= ~n);
    }

    protected String getDebugFlag() {
        int n = 1;
        StringBuffer stringBuffer = new StringBuffer();
        this.setDebugFlag(16, this.active);
        this.setDebugFlag(32, this.askActive);
        this.setDebugFlag(64, this.ref);
        this.setDebugFlag(128, this.flagOk);
        this.setDebugFlag(256, this.flagProcessing);
        this.setDebugFlag(512, this.flagUpdating);
        this.setDebugFlag(1024, this.selected);
        for (int i = 1; i < 32; ++i) {
            if ((n & this.debugFlag) == n) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(DEBUGFLAG[i]);
            }
            n <<= 1;
        }
        return stringBuffer.toString();
    }

    protected boolean isViewable() {
        if (this.hasXYorig || this.isSED()) {
            this.setDebugFlag(8, true);
            return true;
        }
        if (this.type == 0 || this.type == 14 || !this.flagOk) {
            this.setDebugFlag(8, false);
            return false;
        }
        if (!(this.isCatalog() || this.isPlanBGOverlay() || this.isImage() || this.type == 16)) {
            this.setDebugFlag(8, true);
            return true;
        }
        for (int i = this.aladin.view.getModeView() - 1; i >= 0; --i) {
            ViewSimple viewSimple = this.aladin.view.viewSimple[i];
            if (viewSimple.isFree()) continue;
            if (this.projd == null) {
                if (viewSimple.pref != this) continue;
                this.setDebugFlag(8, true);
                return true;
            }
            if (!this.isCompatibleWith(viewSimple)) continue;
            this.setDebugFlag(8, true);
            return true;
        }
        this.setDebugFlag(8, false);
        return false;
    }

    protected boolean shouldHaveARefCheckBox() {
        if (!this.isReady()) {
            return false;
        }
        if (this.ref) {
            return true;
        }
        boolean bl = this.isImage();
        boolean bl2 = this.isSimpleCatalog();
        boolean bl3 = this.type == 16;
        boolean bl4 = this.isPlanBGOverlay();
        boolean bl5 = bl2;
        int n = this.aladin.calque.getIndex(this);
        Plan[] planArray = this.aladin.calque.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!planArray[i].isReady() || planArray[i] == this) continue;
            if (bl && (planArray[i].isSimpleCatalog() && !this.isCompatibleWith(planArray[i]) || planArray[i].isImage() || planArray[i].type == 16)) {
                return true;
            }
            if (bl2) {
                if (planArray[i].isImage() && this.isCompatibleWith(planArray[i]) || planArray[i] instanceof PlanBG) {
                    return false;
                }
                if (planArray[i].isSimpleCatalog() && this.isCompatibleWith(planArray[i]) && i > n) {
                    return false;
                }
            }
            if (!bl3 || !planArray[i].isImage() && planArray[i].type != 16) continue;
            return true;
        }
        return bl5;
    }

    protected boolean contains(Coord coord) {
        return false;
    }

    protected boolean setExtName() {
        block6: {
            try {
                String string;
                if (this.headerFits == null) break block6;
                try {
                    string = this.headerFits.getStringFromHeader("HDUNAME");
                }
                catch (Exception exception) {
                    string = this.headerFits.getStringFromHeader("EXTNAME");
                }
                string = string.trim();
                if (string.length() != 0) {
                    int n = this.label.lastIndexOf(91);
                    if (n >= 0) {
                        string = string + this.label.substring(n);
                    }
                    this.setLabel(string);
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    protected boolean isSync() {
        return true;
    }

    protected boolean isCompatibleWith(Plan plan) {
        return Projection.isOk(plan.projd) && plan.projd.agree(this.projd, this.aladin.view.getCurrentView());
    }

    protected boolean isCompatibleWith(ViewSimple viewSimple) {
        if (viewSimple.isFree() || !Projection.isOk(viewSimple.getProj())) {
            return false;
        }
        if (viewSimple.pref == this) {
            this.setUnderBackGroundFlag(viewSimple);
            return true;
        }
        if (!(this.aladin.view.isMultiView() && viewSimple.pref.ref || !viewSimple.pref.isImage() || this.type != 1 || this.aladin.calque.getIndex(this) <= this.aladin.calque.getIndex(viewSimple.pref))) {
            this.setDebugFlag(2048, true);
            return false;
        }
        this.setDebugFlag(2048, false);
        if (!this.setUnderBackGroundFlag(viewSimple)) {
            return false;
        }
        boolean bl = this.isOutView(viewSimple);
        return !bl;
    }

    private boolean setUnderBackGroundFlag(ViewSimple viewSimple) {
        boolean bl = false;
        if (!this.isPixel()) {
            this.setDebugFlag(4096, bl);
            return !bl;
        }
        Plan[] planArray = this.aladin.calque.getPlans();
        int n = this.aladin.calque.getIndex(planArray, this);
        for (int i = n - 1; i >= 0; --i) {
            Plan plan = planArray[i];
            if (plan.type != 16 || !plan.active || plan.getOpacityLevel() != 1.0f && !plan.isRefForVisibleView() || ((PlanImage)plan).isTransparent()) continue;
            bl = true;
            break;
        }
        if (bl && this.aladin.view.isMultiView()) {
            bl = false;
        }
        this.setDebugFlag(4096, bl);
        return !bl;
    }

    protected boolean isOutView(ViewSimple viewSimple) {
        int n = viewSimple.getWidth();
        int n2 = viewSimple.getHeight();
        if (this instanceof PlanBG) {
            this.setDebugFlag(4, false);
            return false;
        }
        if (this.isImage()) {
            double d;
            double d2;
            PointD[] pointDArray = ((PlanImage)this).getBords(viewSimple);
            if (pointDArray == null) {
                return true;
            }
            double d3 = d2 = pointDArray[0].x;
            double d4 = d = pointDArray[0].y;
            for (int i = 1; i < 4; ++i) {
                if (pointDArray[i].x < d3) {
                    d3 = pointDArray[i].x;
                } else if (pointDArray[i].x > d2) {
                    d2 = pointDArray[i].x;
                }
                if (pointDArray[i].y < d4) {
                    d4 = pointDArray[i].y;
                    continue;
                }
                if (!(pointDArray[i].y > d)) continue;
                d = pointDArray[i].y;
            }
            if (d3 < 0.0 && d2 < 0.0 || d3 >= (double)n && d2 >= (double)n || d4 < 0.0 && d < 0.0 || d4 >= (double)n2 && d >= (double)n2) {
                this.setDebugFlag(4, true);
                return true;
            }
            this.setDebugFlag(4, false);
            return false;
        }
        boolean bl = !viewSimple.getProj().agree(this.projd, this.aladin.view.getCurrentView(), false);
        this.setDebugFlag(4, bl);
        return bl;
    }

    protected String getProgress() {
        if (this.type != 0 && !this.flagOk && this.error == null) {
            return " - in progress...";
        }
        return "";
    }

    protected String getInfo() {
        return this.getInfo(false);
    }

    protected String getInfo(boolean bl) {
        try {
            String string = null;
            if (this.type == 0) {
                string = "";
            } else if (this.error != null) {
                string = this.label + " *** " + this.error;
            } else {
                String string2 = this.getFrom();
                String string3 = this.getProgress();
                if (string3.length() > 0) {
                    string = this.label + string3;
                } else {
                    try {
                        if (this.isCatalog()) {
                            string = this.label + " - " + this.getStats();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (string == null) {
                    string = this.label;
                }
                if (bl && string != null) {
                    string = string + (this.objet != null ? "\nAround " + this.objet : "");
                    string = string + (string2 != null ? "\n" + string2 : "");
                }
                int n = this.aladin.calque.plan.length - this.aladin.calque.getIndex(this);
                string = "[Plane @" + n + "] - " + string;
            }
            string = string + this.addDebugInfo();
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected String addDebugInfo() {
        String string;
        if (Aladin.levelTrace < 2) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.active) {
            if (this.statNbComputing != 0L) {
                stringBuffer.append("\n - " + this.statNbComputing + " projection" + (this.statNbComputing > 1L ? "s" : "") + " (" + this.statTimeComputing + "ms)");
            }
            if (this.statNbItems != 0L) {
                stringBuffer.append("\n - " + this.statNbItems + " object" + (this.statNbItems > 1L ? "s" : "") + " drawn (" + this.statTimeDisplay + "ms)");
            } else {
                stringBuffer.append("\n - drawn in " + this.statTimeDisplay + "ms");
            }
        }
        if ((string = this.getDebugFlag()).length() > 0) {
            stringBuffer.append("\n[" + string + "]");
        }
        return stringBuffer.toString();
    }

    protected String getLabel() {
        String string = this.label;
        int n = (int)this.getPourcent();
        if (n > 0 && n < 100) {
            string = Util.align((this.label.length() > 6 ? this.label.substring(0, 6) : this.label) + "... ", 9) + n + "%";
        } else if (this.error == null && !this.flagOk) {
            string = this.label + "...";
        }
        return string;
    }

    protected String getFrameLabel(int n) {
        return this.label;
    }

    protected double getCompletude() {
        return -1.0;
    }

    protected String getUrl() {
        return this.u == null ? null : this.u.toString();
    }

    protected boolean hasRemoteUrl() {
        return this.u != null && !this.u.toString().startsWith("file:");
    }

    public float getOpacityLevel() {
        return this.opacityLevel;
    }

    public void setOpacityLevel(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.opacityLevel = f;
    }

    protected String getLastPlasticID() {
        if (this.plasticIDs != null && this.plasticIDs.size() > 0) {
            return this.plasticIDs.get(this.plasticIDs.size() - 1);
        }
        return this.getUrl();
    }

    protected String getPlasticID() {
        if (this.plasticIDs != null && this.plasticIDs.size() > 0) {
            return this.plasticIDs.get(0);
        }
        return this.getUrl();
    }

    protected boolean hasPlasticID(String string) {
        Enumeration<String> enumeration;
        String string2;
        if (string == null) {
            return false;
        }
        try {
            if (!string.startsWith("file")) {
                string2 = string;
            } else {
                enumeration = new URL(string);
                string2 = ((URL)((Object)enumeration)).getFile();
            }
        }
        catch (MalformedURLException malformedURLException) {
            string2 = string;
        }
        if (this.plasticIDs != null) {
            enumeration = this.plasticIDs.elements();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                if (string3.startsWith("file")) {
                    try {
                        URL uRL = new URL(string3);
                        string3 = uRL.getFile();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (!string2.equals(string3)) continue;
                return true;
            }
        }
        return (enumeration = this.getUrl()) != null && string.equals(enumeration);
    }

    protected void addPlasticID(String string) {
        if (string == null) {
            return;
        }
        if (this.plasticIDs == null) {
            this.plasticIDs = new Vector();
        }
        if (this.plasticIDs.indexOf(string) < 0) {
            this.plasticIDs.addElement(string);
        }
    }

    protected void setLabel(String string) {
        String string2 = this.getUniqueLabel(string);
        if (string2 == null) {
            return;
        }
        this.label = string2;
    }

    protected String getUniqueLabel(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length > 0 && cArray[0] == '=') {
            if (cArray[1] != '@') {
                this.label = string.substring(1);
            }
            this.isOldPlan = true;
            return null;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\n') continue;
            cArray[i] = 32;
        }
        String string2 = new String(cArray);
        String string3 = string2;
        if (this.isExistingLabel(string3, false)) {
            int n = string2.indexOf(126);
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
            string3 = string2;
            int n2 = 1;
            while (this.isExistingLabel(string3, false)) {
                string3 = string2 + "~" + n2++;
            }
        }
        return string3;
    }

    protected boolean isExistingLabel(String string, boolean bl) {
        if (string.trim().length() == 0) {
            return true;
        }
        if (bl) {
            if (this.aladin.view.getNViewFromID(string) >= 0) {
                return true;
            }
            if (string.equals("ROI")) {
                return true;
            }
            if (string.equals("all")) {
                return true;
            }
        }
        Plan[] planArray = this.aladin.calque.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan = planArray[i];
            if (plan == this || plan == null || plan.label == null || !string.equals(plan.label)) continue;
            return true;
        }
        return false;
    }

    protected String getFrom() {
        if (this.copyright == null) {
            return null;
        }
        int n = this.copyright.length();
        if (n > 40) {
            int n2 = this.copyright.lastIndexOf(Util.FS, this.copyright.length() - 15);
            int n3 = this.copyright.indexOf(Util.FS, 4);
            if (n2 != -1 && n3 != -1 && n3 < n2) {
                return this.copyright.substring(0, n3 + 1) + "..." + this.copyright.substring(n2);
            }
            return this.copyright.substring(0, 40) + "...";
        }
        return this.copyright;
    }

    protected void setFrom(String string) {
        this.copyright = string;
    }

    protected String getLogInfo() {
        return (this.objet == null ? "null" : this.objet) + "/" + (this.param == null ? "null" : this.param);
    }

    protected String getTargetQuery() {
        if (this.objet != null) {
            return this.objet;
        }
        if (this.co != null) {
            return this.co.getSexa();
        }
        return "";
    }

    protected String getTarget() {
        if (this.co == null) {
            return null;
        }
        return this.co.getSexa(":");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setPropertie(String string, String string2, String string3) throws Exception {
        if (string.equalsIgnoreCase("PlaneID")) {
            if (this.isExistingLabel(string3, false)) {
                throw new Exception("PlaneID already existing");
            }
            this.setLabel(string3);
        } else if (string.equalsIgnoreCase("proj")) {
            this.modifyProj(string3);
        } else if (string.equalsIgnoreCase("epoch")) {
            if (!this.isCatalog()) {
                throw new Exception("Epoch can be modified only for catalog planes");
            }
            if (!this.hasPM()) {
                throw new Exception("Unknown proper motion fields");
            }
            this.setEpoch(string3);
            this.aladin.calque.repaintAll();
        } else if (string.equalsIgnoreCase("info")) {
            this.verboseDescr = string3;
        } else if (string.equalsIgnoreCase("ack")) {
            this.ack = string3;
        } else if (string.equalsIgnoreCase("Color")) {
            Color color = Action.getColor(string3);
            if (color == null) {
                throw new Exception("Syntax error in color function (ex: rgb(30,60,255) )");
            }
            this.c = color;
            this.aladin.calque.repaintAll();
        } else if (string.equalsIgnoreCase("Status")) {
            if (string3.indexOf("shown") >= 0) {
                this.setActivated(true);
            } else {
                if (string3.indexOf("hidden") < 0) throw new Exception("Status unknown");
                this.setActivated(false);
            }
        } else if (string.equalsIgnoreCase("Background")) {
            Color color;
            this.colorBackground = color = string3.equalsIgnoreCase("white") ? Color.white : (string3.equalsIgnoreCase("black") ? Color.black : null);
            this.aladin.calque.repaintAll();
        } else if (string.equalsIgnoreCase("Opacity")) {
            float f;
            if (!this.aladin.calque.canBeTransparent(this)) {
                throw new Exception("opacity property only applicable for images and footprints !");
            }
            try {
                f = Float.parseFloat(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception(string3 + " is not a valid value for opacity level !");
            }
            if (f > 100.0f || f < 0.0f) {
                throw new Exception("Opacity value must be between 0 and 100 !");
            }
            this.setOpacityLevel(f / 100.0f);
            this.aladin.calque.repaintAll();
        } else if (string.equalsIgnoreCase("scalingFactor") || string.equalsIgnoreCase("size")) {
            float f;
            try {
                f = Float.parseFloat(string3);
                if (f <= 0.0f) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                throw new Exception(string3 + " is not a valid value for scalingFactor ]0..5] !");
            }
            this.setScalingFactor(f);
            this.aladin.calque.repaintAll();
        } else {
            if (!string.startsWith("FITS:")) throw new Exception("Unknown plane propertie [" + string + "]");
            string = string.substring(5);
            if (this.headerFits == null) {
                this.headerFits = new FrameHeaderFits(this, string + "=" + string3);
            } else {
                if (string3.length() == 0) {
                    string3 = null;
                }
                this.headerFits.setToHeader(string, string3);
            }
            try {
                this.setNewProjD(new Projection(2, new Calib(this.headerFits.getHeaderFits())));
                this.setHasSpecificCalib();
                this.aladin.command.console("Astrometrical calibration has been modified on " + this.label);
                this.aladin.view.newView();
                this.aladin.view.repaintAll();
            }
            catch (Exception exception) {}
        }
        Properties.majProp(this);
    }

    protected void startCheckBoxBlink() {
        this.startCheckBoxBlink = System.currentTimeMillis();
    }

    protected boolean isCheckBoxBlink() {
        long l = System.currentTimeMillis();
        return l - this.startCheckBoxBlink < 4000L;
    }

    protected boolean setActivated(boolean bl) {
        this.askActive = bl;
        return this.setActivated();
    }

    protected boolean setActivated() {
        Source source;
        boolean bl = this.askActive;
        if (this.askActive && !this.isViewable()) {
            bl = false;
        }
        if (this.active == bl) {
            return this.active;
        }
        this.active = bl;
        if (!this.active) {
            this.aladin.view.deSelect(this);
        } else {
            this.aladin.view.addTaggedSource(this);
        }
        if (this.active && this.isSED() && (source = this.aladin.view.addSEDSource(this)) != null) {
            this.aladin.view.zoomview.setSED(source);
        }
        return this.active;
    }

    public synchronized void stop() {
        this.runme = null;
    }

    protected boolean waitForPlan() {
        return false;
    }

    protected synchronized void addPlaneLoadListener(PlaneLoadListener planeLoadListener) {
        this.listeners.add(planeLoadListener);
    }

    protected synchronized boolean removeListener(PlaneLoadListener planeLoadListener) {
        return this.listeners.remove(planeLoadListener);
    }

    protected void callAllListeners(PlaneLoadEvent planeLoadEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((PlaneLoadListener)enumeration.nextElement()).planeLoaded(planeLoadEvent);
        }
    }

    protected static void aladinQueryThread(Thread thread) {
        thread.setName(ALADINQUERY);
    }

    protected void threading() {
        if (Thread.currentThread().getName().equals(ALADINQUERY)) {
            this.run();
        } else {
            this.runme = new Thread((Runnable)this, "AladinQueryBis");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            Plan.aladinQueryThread(this.runme);
            this.runme.start();
        }
    }

    @Override
    public void run() {
        boolean bl;
        block4: {
            Aladin.trace(1, (this.flagSkip ? "Skipping" : "Creating") + " the " + Tp[this.type] + " plane " + this.label);
            if (this.server != null) {
                this.server.setStatus();
            }
            bl = true;
            try {
                bl = this.waitForPlan();
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block4;
                exception.printStackTrace();
            }
        }
        this.planReady(bl);
        if (this.server != null) {
            this.server.setStatus();
        }
    }

    protected void planReady(boolean bl) {
        block16: {
            if (this.flagSkip) {
                return;
            }
            if (this.doClose && this.dis != null) {
                try {
                    this.dis.close();
                }
                catch (IOException iOException) {
                    if (Aladin.levelTrace < 3) break block16;
                    iOException.printStackTrace();
                }
            }
        }
        if (this.isImage() && !this.doClose) {
            if (!bl && this.error == null) {
                this.error = Aladin.error;
                return;
            }
            this.setPourcent(-1.0);
            this.flagOk = bl;
            return;
        }
        this.aladin.endMsg();
        if (!bl) {
            if (this.error == null) {
                this.error = Aladin.error;
            }
            this.aladin.calque.select.repaint();
            this.aladin.toolBox.toolMode();
            return;
        }
        long l = System.currentTimeMillis();
        if (this.type != 11) {
            Aladin.trace(3, "Plane [" + this.label + "] load&build in " + (l - this.startTime) + "ms");
        }
        this.setPourcent(-1.0);
        this.flagOk = bl;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        bl4 = !this.isOldPlan && (this.isImage() || this.type == 16 && !(this instanceof PlanBGCat));
        if (bl4 || (bl3 = this.aladin.calque.isFreeX(this)) || (bl2 = this.isSimpleCatalog() && !this.isViewable() && !this.aladin.calque.isBackGround())) {
            this.aladin.calque.setPlanRef(this);
            if (!this.isOverlay()) {
                this.setOpacityLevel(0.0f);
            }
        } else {
            if (!this.isViewable()) {
                this.aladin.view.syncPlan(this);
            }
            this.setActivated(true);
            this.aladin.calque.unSelectAllPlan();
            this.selected = true;
        }
        if (this.isCatalog()) {
            PlanFilter.newPlan(this);
            FilterProperties.notifyNewPlan();
        }
        if (!this.isOldPlan) {
            this.aladin.calque.bestPlacePost(this);
            if (this.aladin.dialog != null) {
                this.aladin.dialog.resume();
            }
        }
        this.flagWaitTarget = false;
        this.flagProcessing = false;
        this.aladin.calque.repaintAll();
    }

    public String toString() {
        return this.label + "[" + Tp[this.type] + "]";
    }

    protected static int round(double d) {
        return (int)(d + 0.5);
    }

    protected static int floor(double d) {
        return (int)d;
    }

    protected static int top(double d) {
        return (double)((int)d) == d ? (int)d : (int)(d + 1.0);
    }

    protected Iterator<Obj> iterator() {
        return this.pcat == null ? null : this.pcat.iterator();
    }

    protected Iterator<Obj> iterator(ViewSimple viewSimple) {
        return this.iterator();
    }

    protected boolean hasAssociatedFootprints() {
        Iterator<Obj> iterator = this.iterator();
        if (iterator == null) {
            return false;
        }
        while (iterator.hasNext()) {
            Source source;
            Obj obj = iterator.next();
            if (!(obj instanceof Source) || (source = (Source)obj).getFootprint() == null) continue;
            return true;
        }
        return false;
    }

    protected void showFootprints(boolean bl) {
        Iterator<Obj> iterator = this.iterator();
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (!(obj instanceof Source)) continue;
            Source source = (Source)obj;
            source.setShowFootprint(bl, false);
        }
        this.aladin.calque.repaintAll();
    }

    protected void reallocFootprintCache() {
        if (this.pcat == null) {
            return;
        }
        Iterator<Obj> iterator = this.iterator();
        while (iterator.hasNext()) {
            PlanField planField;
            Source source;
            Obj obj = iterator.next();
            if (!(obj instanceof Source) || (source = (Source)obj).getFootprint() == null || (planField = source.getFootprint().getFootprint()) == null) continue;
            planField.pcat.reallocObjetCache();
        }
    }

    static {
        STATUS = new String[]{"STATUS_UNKNOWN", "STATUS_INPROGRESS", "STATUS_MOREDETAILSAVAILABLE", "STATUS_ERROR", "STATUS_EMPTYMOC", "STATUS_OVERFLOW", "STATUS_NOCALIB", "STATUS_EMPTYCAT", "STATUS_LOADING", "STATUS_READY"};
        Tp = new String[]{"", "Image", "RGB", "Blink", "Cube", "Resampled", "Mosaic", "Algo", "Catalog", "Tool", "Aperture", "Folder", "Filter", "Image FoV", "In progress", "ImageHuge", "HipsImage", "HipsPolarisation", "HipsCatalog", "MOC", "CubeColor", "HipsFinder", "HipsCube"};
        DEBUGFLAG = new String[]{"", "RefForVisibleView", "CanBeTransp", "OutOfView", "Viewable", "Activated", "AskActivated", "Ref", "FlagOk", "FlagProcessing", "FlagUpdating", "Selected", "UnderImg", "UnderBkg"};
    }
}

