/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Cache;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.FrameHeaderFits;
import cds.aladin.FrameHipsProperties;
import cds.aladin.HealpixAllsky;
import cds.aladin.HealpixAllskyPol;
import cds.aladin.HealpixKey;
import cds.aladin.HealpixKeyPol;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanHealpix;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanMoc;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.Repere;
import cds.aladin.TreeNodeAllsky;
import cds.aladin.ViewMemoItem;
import cds.aladin.ViewSimple;
import cds.astro.Coo;
import cds.fits.HeaderFits;
import cds.moc.HealpixMoc;
import cds.moc.MocCell;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class PlanBG
extends PlanImage {
    static final boolean NOALLSKY = false;
    static final boolean TEST = true;
    static final int DRAWPIXEL = 0;
    static final int DRAWPOLARISATION = 1;
    private float segmentLenFactor = 1.0f;
    private int segmentThickness = 1;
    private float segmentDensityFactor = 1.0f;
    private Color oc = null;
    protected int drawMode = 0;
    static final String CACHE = "Background";
    static long MAXCACHE = 0x400000L;
    protected static final int LIVETIME = 3000;
    protected MyProperties prop = null;
    protected String gluTag = null;
    protected String id = null;
    protected String survey;
    protected String version = "";
    protected String url;
    protected int minOrder = 3;
    protected int maxOrder = 14;
    protected Hashtable<String, HealpixKey> pixList;
    protected HealpixLoader loader;
    protected boolean hasDrawnSomething = false;
    protected boolean allWaitingKeysDrawn = false;
    protected boolean useCache = true;
    protected boolean cube = false;
    protected boolean color = false;
    protected boolean colorPNG = false;
    protected boolean colorUnknown = false;
    public boolean fitsGzipped = false;
    public boolean truePixels = false;
    public boolean inFits = false;
    public boolean inJPEG = false;
    public boolean inPNG = false;
    private boolean hasMoc = false;
    private boolean hasHpxFinder = false;
    protected int frameOrigin = 0;
    protected int frameDrawing;
    protected boolean local;
    protected boolean live;
    protected boolean loadMocNow;
    protected String pixelRange;
    protected String pixelCut;
    protected boolean flagNoTarget;
    private boolean flagWaitAllSky;
    private int tileOrder;
    protected int[] RGBCONTROL;
    protected int[] RGBControl;
    static volatile long cacheSize = -1L;
    private static Object cacheLock = new Object();
    private int polaScaleFactor;
    protected long memSize;
    private boolean testMoc;
    private boolean testHpxFinder;
    protected HealpixMoc moc;
    private static final int MAXCHECKSITE = 3;
    private int nbCheckSite;
    private FrameHipsProperties frameHipsProperties;
    private boolean flagClearBuf;
    protected boolean flagRecut;
    protected double flagRecutRadius;
    protected Coord flagRecutCoo;
    private String cacheName;
    private String dirCache;
    private boolean flagCache;
    protected int nbReady;
    private static Thread scanCache = null;
    private static long NBFILE = 0L;
    protected int nbFlush;
    private long lastGc;
    private long lastMemP;
    private long lastMemI;
    private static int MEMREQUIREDFORGC = 0x2800000;
    private boolean memCpt;
    private boolean firstSubtil;
    protected static String CURRENTMODE = "";
    protected static boolean DEBUGMODE = false;
    protected double[] RES;
    private int allSkyOrder;
    public static final int DIRSIZE = 10000;
    protected int[] xy2hpx;
    protected int[] hpx2xy;
    private long lastTouch;
    protected long lastIz;
    protected int lastMaxOrder;
    private int oLosangeOrder;
    private boolean hasMoreDetails;
    private long[] children;
    protected long[] pixDebugIn;
    protected final int ALLSKYORDER = 3;
    boolean first1;
    private int lastHistID;
    private double[] histRed;
    private double[] histGreen;
    private double[] histBlue;
    protected byte[] red;
    protected byte[] green;
    protected byte[] blue;
    private Timer timer;
    boolean readyAfterDraw;
    boolean readyDone;
    protected int priority;
    protected static int nDraw1 = 0;
    protected static int nOut1 = 0;
    static final int DRAWFASTMS = 100;
    private boolean computeDrawFast;
    private boolean lastMustDrawFast;
    private static final int MAXSTAT = 5;
    private int nStat;
    private long[] statTimeDisplayArray;
    private boolean first;
    private boolean fading;
    static final int M = 2;
    private long timerLastDrawBG;
    private boolean oLoading;
    private static final int MAXTIMETOBELOADFROMNET = 1000;
    protected long cumulTimeLoadNet;
    protected long cumulTimeLoadCache;
    protected long cumulTimeWriteCache;
    protected long cumulTimeDraw;
    protected long cumulTimeStream;
    protected long cumulTimeJPEG;
    protected long cumulTimePixel;
    protected int nbLoadNet;
    protected int nbLoadCache;
    protected int nbWriteCache;
    protected int nbImgDraw;
    protected long nByteReadNet;
    protected long nByteReadCache;
    protected long nByteWriteCache;
    protected int nbImgCreated;
    protected int nbImgInBuf;
    protected int nbCreated;
    protected int nbAborted;
    protected int nbFree;

    protected void setDrawMode(int n) {
        this.drawMode = n;
        if (this.drawMode == 1) {
            if ((double)this.opacityLevel < 0.1) {
                this.setOpacityLevel(1.0f);
            }
            if (this.oc == null) {
                this.oc = this.c = Couleur.getNextDefault(this.aladin.calque);
            } else {
                this.c = this.oc;
            }
        } else {
            this.c = Color.black;
        }
        this.type = n == 1 ? 17 : 16;
    }

    protected PlanBG(Aladin aladin) {
        super(aladin);
        this.frameDrawing = this.aladin != null && this.aladin.configuration != null ? this.aladin.configuration.getFrameDrawing() : 0;
        this.live = false;
        this.loadMocNow = false;
        this.pixelRange = null;
        this.pixelCut = null;
        this.flagNoTarget = false;
        this.tileOrder = -1;
        this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
        this.polaScaleFactor = 40;
        this.memSize = 0L;
        this.testMoc = false;
        this.testHpxFinder = false;
        this.nbCheckSite = 0;
        this.frameHipsProperties = null;
        this.flagClearBuf = false;
        this.flagRecut = true;
        this.flagRecutRadius = 0.0;
        this.flagRecutCoo = null;
        this.cacheName = null;
        this.dirCache = null;
        this.flagCache = false;
        this.nbReady = 0;
        this.nbFlush = 0;
        this.lastGc = 0L;
        this.lastMemP = 0L;
        this.lastMemI = 0L;
        this.memCpt = true;
        this.firstSubtil = true;
        this.RES = null;
        this.allSkyOrder = -1;
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.lastTouch = 0L;
        this.lastIz = -1L;
        this.lastMaxOrder = 3;
        this.oLosangeOrder = -1;
        this.hasMoreDetails = true;
        this.children = null;
        this.pixDebugIn = new long[0];
        this.ALLSKYORDER = 3;
        this.first1 = false;
        this.lastHistID = -1;
        this.histRed = new double[256];
        this.histGreen = new double[256];
        this.histBlue = new double[256];
        this.timer = null;
        this.readyAfterDraw = false;
        this.readyDone = false;
        this.priority = 0;
        this.computeDrawFast = true;
        this.lastMustDrawFast = true;
        this.nStat = 0;
        this.statTimeDisplayArray = new long[5];
        this.first = true;
        this.fading = false;
        this.timerLastDrawBG = 0L;
        this.oLoading = false;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeDraw = 0L;
        this.cumulTimeStream = 0L;
        this.cumulTimeJPEG = 0L;
        this.cumulTimePixel = 0L;
        this.nbLoadNet = 0;
        this.nbLoadCache = 0;
        this.nbWriteCache = 0;
        this.nbImgDraw = 0;
        this.nByteReadNet = 0L;
        this.nByteReadCache = 0L;
        this.nByteWriteCache = 0L;
        this.nbImgCreated = 0;
        this.nbImgInBuf = 0;
        this.nbCreated = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.initCache();
    }

    protected PlanBG(Aladin aladin, TreeNodeAllsky treeNodeAllsky, String string, Coord coord, double d, String string2) {
        super(aladin);
        this.frameDrawing = this.aladin != null && this.aladin.configuration != null ? this.aladin.configuration.getFrameDrawing() : 0;
        this.live = false;
        this.loadMocNow = false;
        this.pixelRange = null;
        this.pixelCut = null;
        this.flagNoTarget = false;
        this.tileOrder = -1;
        this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
        this.polaScaleFactor = 40;
        this.memSize = 0L;
        this.testMoc = false;
        this.testHpxFinder = false;
        this.nbCheckSite = 0;
        this.frameHipsProperties = null;
        this.flagClearBuf = false;
        this.flagRecut = true;
        this.flagRecutRadius = 0.0;
        this.flagRecutCoo = null;
        this.cacheName = null;
        this.dirCache = null;
        this.flagCache = false;
        this.nbReady = 0;
        this.nbFlush = 0;
        this.lastGc = 0L;
        this.lastMemP = 0L;
        this.lastMemI = 0L;
        this.memCpt = true;
        this.firstSubtil = true;
        this.RES = null;
        this.allSkyOrder = -1;
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.lastTouch = 0L;
        this.lastIz = -1L;
        this.lastMaxOrder = 3;
        this.oLosangeOrder = -1;
        this.hasMoreDetails = true;
        this.children = null;
        this.pixDebugIn = new long[0];
        this.ALLSKYORDER = 3;
        this.first1 = false;
        this.lastHistID = -1;
        this.histRed = new double[256];
        this.histGreen = new double[256];
        this.histBlue = new double[256];
        this.timer = null;
        this.readyAfterDraw = false;
        this.readyDone = false;
        this.priority = 0;
        this.computeDrawFast = true;
        this.lastMustDrawFast = true;
        this.nStat = 0;
        this.statTimeDisplayArray = new long[5];
        this.first = true;
        this.fading = false;
        this.timerLastDrawBG = 0L;
        this.oLoading = false;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeDraw = 0L;
        this.cumulTimeStream = 0L;
        this.cumulTimeJPEG = 0L;
        this.cumulTimePixel = 0L;
        this.nbLoadNet = 0;
        this.nbLoadCache = 0;
        this.nbWriteCache = 0;
        this.nbImgDraw = 0;
        this.nByteReadNet = 0L;
        this.nByteReadCache = 0L;
        this.nByteWriteCache = 0L;
        this.nbImgCreated = 0;
        this.nbImgInBuf = 0;
        this.nbCreated = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.startingTaskId = string2;
        this.initCache();
        this.gluTag = treeNodeAllsky.getID();
        this.id = treeNodeAllsky.internalId;
        this.url = treeNodeAllsky.getUrl();
        this.survey = treeNodeAllsky.label;
        this.version = treeNodeAllsky.version;
        this.minOrder = treeNodeAllsky.minOrder;
        this.maxOrder = treeNodeAllsky.maxOrder;
        this.useCache = treeNodeAllsky.useCache();
        this.local = treeNodeAllsky.local;
        this.loadMocNow = treeNodeAllsky.loadMocNow();
        this.frameOrigin = treeNodeAllsky.frame;
        this.description = treeNodeAllsky.description;
        this.verboseDescr = treeNodeAllsky.verboseDescr;
        this.ack = treeNodeAllsky.ack;
        this.copyright = treeNodeAllsky.copyright;
        this.copyrightUrl = treeNodeAllsky.copyrightUrl;
        this.co = coord;
        this.coRadius = d;
        if (string != null && string.trim().length() > 0) {
            this.setLabel(string);
        }
        this.setSpecificParams(treeNodeAllsky);
        Aladin.trace(3, "AllSky creation: " + treeNodeAllsky.toString1() + (coord != null ? " around " + coord : ""));
        this.suite();
    }

    private void resetCache() {
        String string = this.getCacheDir() + Util.FS + this.getCacheName();
        File file = new File(string);
        for (int i = 1; i < 10 && !file.renameTo(new File(this.getCacheDir() + Util.FS + this.getCacheName() + "." + i + ".old")); ++i) {
        }
        new File(this.getCacheDir() + Util.FS + this.getCacheName()).mkdir();
        Aladin.trace(3, "HEALPix local cache for " + this.getCacheName() + " is out of date => renamed => will be removed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadPropertieFile() {
        if (this.prop != null) {
            return this.prop;
        }
        String string = null;
        boolean bl = !this.url.startsWith("http:") && !this.url.startsWith("https:") && !this.url.startsWith("ftp:");
        try {
            InputStream inputStream = null;
            if (bl) {
                inputStream = new FileInputStream(new File(this.url + Util.FS + "properties"));
            } else {
                File file;
                block24: {
                    InputStream inputStream2;
                    this.checkSite(false);
                    String string2 = this.getCacheDir() + Util.FS + this.getCacheName() + Util.FS + "properties";
                    file = new File(string2);
                    String string3 = this.url + "/" + "properties";
                    HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string3).openConnection();
                    if (this.useCache && file.exists()) {
                        httpURLConnection.setIfModifiedSince(file.lastModified());
                        this.prop = new MyProperties();
                        inputStream2 = new FileInputStream(file);
                        this.prop.load(inputStream2, true);
                        inputStream2.close();
                        string = this.prop.getProperty("hips_release_date");
                        if (string == null) {
                            string = this.prop.getProperty("processingDate", "");
                        }
                    }
                    inputStream2 = null;
                    try {
                        inputStream = httpURLConnection.getInputStream();
                        int n = httpURLConnection.getResponseCode();
                        if (n == 304) {
                            throw new Exception();
                        }
                        if (!this.useCache) break block24;
                        inputStream2 = new MyInputStream(inputStream);
                        byte[] byArray = ((MyInputStream)inputStream2).readFully();
                        ((MyInputStream)inputStream2).close();
                        this.prop = new MyProperties();
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        this.prop.load(byteArrayInputStream, true);
                        ((InputStream)byteArrayInputStream).close();
                        String string4 = this.prop.getProperty("hips_release_date");
                        if (string4 == null) {
                            string4 = this.prop.getProperty("processingDate", "");
                        }
                        if (string4.equals(string)) {
                            throw new Exception();
                        }
                        RandomAccessFile randomAccessFile = null;
                        try {
                            this.resetCache();
                            file = new File(string2);
                            randomAccessFile = new RandomAccessFile(file, "rw");
                            randomAccessFile.write(byArray);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        finally {
                            if (randomAccessFile != null) {
                                randomAccessFile.close();
                            }
                        }
                    }
                    catch (Exception exception) {
                        PlanBG.touch(new File(this.getCacheDir() + Util.FS + this.getCacheName()));
                        PlanBG.touch(new File(string2));
                        Aladin.trace(3, "HEALPix local cache for " + this.survey + " is ok [" + string2 + "]");
                    }
                    finally {
                        if (inputStream2 != null) {
                            ((MyInputStream)inputStream2).close();
                        }
                    }
                }
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                }
            }
            if (inputStream == null) {
                throw new Exception();
            }
            this.prop = new MyProperties();
            this.prop.load(inputStream, true);
            ((InputStream)inputStream).close();
        }
        catch (Exception exception) {
            this.prop = null;
        }
        return this.prop;
    }

    static final void touch(File file) {
        file.setLastModified(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scanMetadata() {
        MyInputStream myInputStream = null;
        try {
            myInputStream = Util.openAnyStream(this.url + Util.FS + "metadata.txt");
            byte[] byArray = myInputStream.readFully();
            HeaderFits headerFits = new HeaderFits();
            headerFits.readFreeHeader(new String(byArray));
            this.headerFits = new FrameHeaderFits(headerFits);
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                myInputStream.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static String getHiPSID(Properties properties) {
        String string = properties.getProperty("creator_did");
        if (string == null) {
            string = properties.getProperty("publisher_did");
        }
        if (string == null && (string = properties.getProperty("obs_id")) != null) {
            String string2 = properties.getProperty("creator_id");
            if (string2 == null) {
                string2 = properties.getProperty("publisher_id");
            }
            string = string2 != null ? string2 + "?" + string : null;
        }
        if (string == null) {
            string = properties.getProperty("id");
        }
        if (string.startsWith("ivo://")) {
            string = string.substring(6);
        }
        return string;
    }

    protected boolean scanProperties() {
        try {
            String string;
            Properties properties = this.loadPropertieFile();
            if (properties == null) {
                throw new Exception();
            }
            Aladin.trace(4, "PlanBG.setSpecificParams() found a \"properties\" file");
            int n = -1;
            String string2 = properties.getProperty("hips_frame", "X");
            if (string2.equals("equatorial")) {
                n = 0;
            } else if (string2.equals("galactic")) {
                n = 3;
            } else if (string2.equals("ecliptic")) {
                n = 2;
            } else if (string2.equals("X")) {
                string2 = properties.getProperty("coordsys", "X");
                char c = string2.charAt(0);
                if (c == 'C' || c == 'Q') {
                    n = 0;
                } else if (c == 'E') {
                    n = 2;
                } else if (c == 'G') {
                    n = 3;
                }
            }
            if (n != -1 && n != this.frameOrigin) {
                Aladin.trace(1, "Coordinate frame found in properties file (" + Localisation.getFrameName(n) + ") differs from the remote information (" + Localisation.getFrameName(this.frameOrigin) + ") => assume " + Localisation.getFrameName(n));
                this.frameOrigin = n;
            }
            if ((string = properties.getProperty("obs_title")) == null) {
                string = properties.getProperty("description");
            }
            if (string != null) {
                this.description = string;
            }
            if ((string = properties.getProperty("obs_description")) == null) {
                string = properties.getProperty("verboseDescription");
            }
            if (string != null) {
                this.verboseDescr = string;
            }
            if ((string = properties.getProperty("obs_ack")) == null) {
                string = properties.getProperty("acknowledgement");
            }
            if (string != null) {
                this.ack = string;
            }
            if ((string = properties.getProperty("obs_copyright")) == null) {
                string = properties.getProperty("copyright");
            }
            if (string != null) {
                this.copyright = string;
            }
            if ((string = properties.getProperty("obs_copyright_url")) == null) {
                string = properties.getProperty("copyrightUrl");
            }
            if (string != null) {
                this.copyrightUrl = string;
            }
            if ((string = properties.getProperty("hips_data_range")) == null) {
                string = properties.getProperty("pixelRange");
            }
            if (string != null) {
                this.pixelRange = string;
            }
            if ((string = properties.getProperty("hips_pixel_cut")) == null) {
                string = properties.getProperty("pixelCut");
            }
            if (string != null) {
                this.pixelCut = string;
            }
            this.id = PlanBG.getHiPSID(properties);
            string = properties.getProperty("hips_tile_width");
            if (string != null) {
                try {
                    int n2 = Integer.parseInt(string);
                    this.tileOrder = (int)CDSHealpix.log2(n2);
                }
                catch (Exception exception) {}
            } else {
                string = properties.getProperty("tileOrder");
                if (string != null) {
                    try {
                        this.tileOrder = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if ((string = properties.getProperty("dataproduct_subtype")) != null && string.indexOf("live") >= 0) {
                this.live = true;
            }
        }
        catch (Exception exception) {
            Aladin.trace(3, "No properties file found ...");
            return false;
        }
        return true;
    }

    protected void setSpecificParams(TreeNodeAllsky treeNodeAllsky) {
        this.type = 16;
        this.video = this.aladin.configuration.getCMVideo();
        this.inFits = treeNodeAllsky.isFits();
        this.inJPEG = treeNodeAllsky.isJPEG();
        this.inPNG = treeNodeAllsky.isPNG();
        this.truePixels = treeNodeAllsky.isTruePixels();
        this.color = treeNodeAllsky.isColored();
        this.cube = treeNodeAllsky.isCube();
        this.scanProperties();
        this.scanMetadata();
        treeNodeAllsky.reset();
    }

    protected int getTileMode() {
        if (this.isTruePixels()) {
            return 1;
        }
        if (this.inPNG) {
            return 4;
        }
        return 0;
    }

    public PlanBG(Aladin aladin, String string, String string2, Coord coord, double d, String string3) {
        super(aladin);
        this.frameDrawing = this.aladin != null && this.aladin.configuration != null ? this.aladin.configuration.getFrameDrawing() : 0;
        this.live = false;
        this.loadMocNow = false;
        this.pixelRange = null;
        this.pixelCut = null;
        this.flagNoTarget = false;
        this.tileOrder = -1;
        this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
        this.polaScaleFactor = 40;
        this.memSize = 0L;
        this.testMoc = false;
        this.testHpxFinder = false;
        this.nbCheckSite = 0;
        this.frameHipsProperties = null;
        this.flagClearBuf = false;
        this.flagRecut = true;
        this.flagRecutRadius = 0.0;
        this.flagRecutCoo = null;
        this.cacheName = null;
        this.dirCache = null;
        this.flagCache = false;
        this.nbReady = 0;
        this.nbFlush = 0;
        this.lastGc = 0L;
        this.lastMemP = 0L;
        this.lastMemI = 0L;
        this.memCpt = true;
        this.firstSubtil = true;
        this.RES = null;
        this.allSkyOrder = -1;
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.lastTouch = 0L;
        this.lastIz = -1L;
        this.lastMaxOrder = 3;
        this.oLosangeOrder = -1;
        this.hasMoreDetails = true;
        this.children = null;
        this.pixDebugIn = new long[0];
        this.ALLSKYORDER = 3;
        this.first1 = false;
        this.lastHistID = -1;
        this.histRed = new double[256];
        this.histGreen = new double[256];
        this.histBlue = new double[256];
        this.timer = null;
        this.readyAfterDraw = false;
        this.readyDone = false;
        this.priority = 0;
        this.computeDrawFast = true;
        this.lastMustDrawFast = true;
        this.nStat = 0;
        this.statTimeDisplayArray = new long[5];
        this.first = true;
        this.fading = false;
        this.timerLastDrawBG = 0L;
        this.oLoading = false;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeDraw = 0L;
        this.cumulTimeStream = 0L;
        this.cumulTimeJPEG = 0L;
        this.cumulTimePixel = 0L;
        this.nbLoadNet = 0;
        this.nbLoadCache = 0;
        this.nbWriteCache = 0;
        this.nbImgDraw = 0;
        this.nByteReadNet = 0L;
        this.nByteReadCache = 0L;
        this.nByteWriteCache = 0L;
        this.nbImgCreated = 0;
        this.nbImgInBuf = 0;
        this.nbCreated = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.startingTaskId = string3;
        this.initCache();
        Aladin.trace(2, "Creating allSky directory plane [" + string + "]");
        this.type = 16;
        this.video = aladin.configuration.getCMVideo();
        File file = new File(string);
        this.url = file.getAbsolutePath();
        this.survey = file.getName();
        this.maxOrder = 3;
        this.useCache = false;
        this.label = string2;
        this.paramByTreeNode(new TreeNodeAllsky(aladin, this.url), coord, d);
        this.scanProperties();
        this.scanMetadata();
        Aladin.trace(3, "AllSky local... frame=" + Localisation.getFrameName(this.frameOrigin) + " " + this + (coord != null ? " around " + coord : ""));
        this.suite();
    }

    protected PlanBG(Aladin aladin, URL uRL, String string, Coord coord, double d, String string2) {
        super(aladin);
        this.frameDrawing = this.aladin != null && this.aladin.configuration != null ? this.aladin.configuration.getFrameDrawing() : 0;
        this.live = false;
        this.loadMocNow = false;
        this.pixelRange = null;
        this.pixelCut = null;
        this.flagNoTarget = false;
        this.tileOrder = -1;
        this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
        this.polaScaleFactor = 40;
        this.memSize = 0L;
        this.testMoc = false;
        this.testHpxFinder = false;
        this.nbCheckSite = 0;
        this.frameHipsProperties = null;
        this.flagClearBuf = false;
        this.flagRecut = true;
        this.flagRecutRadius = 0.0;
        this.flagRecutCoo = null;
        this.cacheName = null;
        this.dirCache = null;
        this.flagCache = false;
        this.nbReady = 0;
        this.nbFlush = 0;
        this.lastGc = 0L;
        this.lastMemP = 0L;
        this.lastMemI = 0L;
        this.memCpt = true;
        this.firstSubtil = true;
        this.RES = null;
        this.allSkyOrder = -1;
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.lastTouch = 0L;
        this.lastIz = -1L;
        this.lastMaxOrder = 3;
        this.oLosangeOrder = -1;
        this.hasMoreDetails = true;
        this.children = null;
        this.pixDebugIn = new long[0];
        this.ALLSKYORDER = 3;
        this.first1 = false;
        this.lastHistID = -1;
        this.histRed = new double[256];
        this.histGreen = new double[256];
        this.histBlue = new double[256];
        this.timer = null;
        this.readyAfterDraw = false;
        this.readyDone = false;
        this.priority = 0;
        this.computeDrawFast = true;
        this.lastMustDrawFast = true;
        this.nStat = 0;
        this.statTimeDisplayArray = new long[5];
        this.first = true;
        this.fading = false;
        this.timerLastDrawBG = 0L;
        this.oLoading = false;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeDraw = 0L;
        this.cumulTimeStream = 0L;
        this.cumulTimeJPEG = 0L;
        this.cumulTimePixel = 0L;
        this.nbLoadNet = 0;
        this.nbLoadCache = 0;
        this.nbWriteCache = 0;
        this.nbImgDraw = 0;
        this.nByteReadNet = 0L;
        this.nByteReadCache = 0L;
        this.nByteWriteCache = 0L;
        this.nbImgCreated = 0;
        this.nbImgInBuf = 0;
        this.nbCreated = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.startingTaskId = string2;
        this.initCache();
        Aladin.trace(2, "Creating allSky http plane [" + uRL + "]");
        this.type = 16;
        this.video = aladin.configuration.getCMVideo();
        this.url = uRL.toString();
        this.maxOrder = 3;
        this.useCache = true;
        this.local = false;
        this.co = coord;
        this.coRadius = d;
        this.paramByTreeNode(new TreeNodeAllsky(aladin, this.url), coord, d);
        int n = this.url.length();
        if (this.url.endsWith("/")) {
            --n;
        }
        this.survey = this.label != null && this.label.length() > 0 ? this.label : this.url.substring(this.url.lastIndexOf(47, n - 1) + 1, n);
        this.scanProperties();
        this.scanMetadata();
        Aladin.trace(3, "AllSky http... " + this + (coord != null ? " around " + coord : ""));
        this.suite();
    }

    protected void paramByTreeNode(TreeNodeAllsky treeNodeAllsky, Coord coord, double d) {
        if (this.label != null && this.label.trim().length() > 0) {
            this.setLabel(this.label);
        } else {
            this.setLabel(treeNodeAllsky.label);
        }
        this.maxOrder = treeNodeAllsky.getMaxOrder();
        this.inFits = treeNodeAllsky.isFits();
        this.inJPEG = treeNodeAllsky.isJPEG();
        this.inPNG = treeNodeAllsky.isPNG();
        this.truePixels = treeNodeAllsky.isTruePixels();
        this.color = treeNodeAllsky.isColored();
        this.cube = treeNodeAllsky.isCube();
        this.frameOrigin = treeNodeAllsky.getFrame();
        this.tileOrder = treeNodeAllsky.getLosangeOrder();
        this.local = treeNodeAllsky.isLocal();
        this.loadMocNow = treeNodeAllsky.loadMocNow();
        this.version = treeNodeAllsky.getVersion();
        this.useCache = !this.local && treeNodeAllsky.useCache();
        this.co = coord != null ? coord : treeNodeAllsky.getTarget();
        this.coRadius = coord != null ? d : treeNodeAllsky.getRadius();
    }

    @Override
    protected String getPixelInfoFromGrey(int n, int n2) {
        if (this.truePixels) {
            return super.getPixelInfoFromGrey(n, n2);
        }
        return "";
    }

    protected boolean hasMoc() {
        if (this.hasMoc || this.testMoc) {
            return this.hasMoc;
        }
        String string = this.getProperty("moc_access_url");
        if (string != null) {
            this.testMoc = true;
            this.hasMoc = true;
        } else {
            String string2 = this.url + "/" + "Moc.fits";
            this.hasMoc = this.local ? new File(string2).exists() : Util.isUrlResponding(string2);
            this.testMoc = true;
        }
        return this.hasMoc;
    }

    protected String getProperty(String string) {
        return this.prop == null ? null : this.prop.getProperty(string);
    }

    protected boolean hasHpxFinder() {
        if (this.hasHpxFinder || this.testHpxFinder) {
            return this.hasHpxFinder;
        }
        String string = this.getProperty("hips_progenitor_url");
        if (string != null) {
            this.testHpxFinder = true;
            this.hasHpxFinder = true;
        } else {
            String string2 = this.url + "/" + "HpxFinder" + "/" + "metadata.xml";
            this.hasHpxFinder = this.local ? new File(string2).exists() : Util.isUrlResponding(string2);
            this.testHpxFinder = true;
        }
        return this.hasHpxFinder;
    }

    protected void loadMoc() {
        if (this.moc == null) {
            try {
                this.loadInternalMoc();
            }
            catch (Exception exception) {
                if (Aladin.levelTrace >= 3) {
                    exception.printStackTrace();
                }
                return;
            }
        }
        this.aladin.calque.newPlanMOC(this.moc, this.label + " MOC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInternalMoc() throws Exception {
        String string = this.getCacheDir() + "/" + this.getCacheName() + "/" + "Moc.fits";
        if (!this.local && this.useCache && new File(string).exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                this.moc = new HealpixMoc(fileInputStream);
                this.moc.setMinLimitOrder(3);
                this.removeHealpixOutsideMoc();
            }
            finally {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            Aladin.trace(3, "Loading " + this.survey + " MOC from cache");
            return;
        }
        String string2 = this.getProperty("moc_access_url");
        if (string2 == null) {
            string2 = this.getUrl() + "/" + "Moc.fits";
        }
        MyInputStream myInputStream = null;
        try {
            myInputStream = Util.openAnyStream(string2);
            this.moc = new HealpixMoc(myInputStream);
            this.moc.setMinLimitOrder(3);
            this.removeHealpixOutsideMoc();
        }
        finally {
            if (myInputStream != null) {
                myInputStream.close();
            }
        }
        Aladin.trace(3, "Loading " + this.survey + " MOC from net");
        if (!this.local && this.useCache) {
            this.moc.write(string);
            Aladin.trace(3, "Saving " + this.survey + " MOC in cache");
        }
    }

    private void removeHealpixOutsideMoc() {
        block5: {
            Object object;
            Object object2;
            if (this.moc == null) {
                return;
            }
            Enumeration<String> enumeration = this.pixList.keys();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                object = this.pixList.get(object2);
                if (object == null || ((HealpixKey)object).npix == -1L || this.moc.isIntersecting(((HealpixKey)object).order, ((HealpixKey)object).npix)) continue;
                ((HealpixKey)object).abort();
                this.pixList.remove(object2);
            }
            if ((this.co == null || this.flagNoTarget) && this.moc.getSize() > 0 && this.frameOrigin == 0) {
                try {
                    object2 = this.moc.iterator().next();
                    object = CDSHealpix.pix2ang_nest(CDSHealpix.pow2(((MocCell)object2).getOrder()), ((MocCell)object2).getNpix());
                    double[] dArray = CDSHealpix.polarToRadec(new double[]{(double)object[0], (double)object[1]});
                    this.co = new Coord(dArray[0], dArray[1]);
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace < 3) break block5;
                    exception.printStackTrace();
                }
            }
        }
    }

    protected void loadProgen() {
        String string = this.getProperty("hips_progenitor_url");
        if (string == null) {
            string = this.url + "/" + "HpxFinder";
        }
        this.aladin.execAsyncCommand("'Details " + this.label + "'=load " + string);
    }

    protected int getFrameDrawing() {
        return this.frameDrawing;
    }

    protected void setFrameDrawing(int n) {
        this.frameDrawing = n;
        if (this.projd.frame != this.getCurrentFrameDrawing()) {
            this.projd.frame = this.getCurrentFrameDrawing();
            this.syncProjLocal();
            this.aladin.view.repaintAll();
        }
    }

    @Override
    protected void syncProjLocal() {
        Coord coord;
        Object object;
        int n;
        int n2 = this.aladin.view.getNbView();
        for (n = 0; n < n2; ++n) {
            object = this.aladin.view.viewSimple[n];
            if (((ViewSimple)object).pref != this) continue;
            coord = ((ViewSimple)object).projLocal.getProjCenter();
            ((ViewSimple)object).projLocal.frame = this.projd.frame;
            if (this.projd.frame != 0) {
                coord = Localisation.frameToFrame(coord, 0, this.projd.frame);
            }
            ((ViewSimple)object).projLocal.modify(this.projd.label, this.projd.modeCalib, coord.al, coord.del, this.projd.rm, this.projd.rm, this.projd.cx, this.projd.cy, this.projd.r, this.projd.r, this.projd.rot, this.projd.sym, this.projd.t, this.projd.system);
            ((ViewSimple)object).newView(1);
        }
        for (n = this.aladin.view.viewMemo.size() - 1; n >= 0; --n) {
            object = this.aladin.view.viewMemo.memo[n];
            if (object == null || ((ViewMemoItem)object).pref != this) continue;
            coord = ((ViewMemoItem)object).projLocal.getProjCenter();
            ((ViewMemoItem)object).projLocal.frame = this.projd.frame;
            if (this.projd.frame != 0) {
                coord = Localisation.frameToFrame(coord, 0, this.projd.frame);
            }
            ((ViewMemoItem)object).projLocal.modify(this.projd.label, this.projd.modeCalib, coord.al, coord.del, this.projd.rm, this.projd.rm, this.projd.cx, this.projd.cy, this.projd.r, this.projd.r, this.projd.rot, this.projd.sym, this.projd.t, this.projd.system);
        }
    }

    protected int getCurrentFrameDrawing() {
        if (this.frameDrawing == 0) {
            return this.aladin.localisation.getFrame();
        }
        return Util.indexInArrayOf(Localisation.FRAME[this.frameDrawing], Localisation.REPERE);
    }

    public int getFrameOrigin() {
        return this.frameOrigin;
    }

    protected static boolean isPlanHpxFinder(String string) {
        File file = new File(string);
        return file.getName().equals("HpxFinder") && file.isDirectory();
    }

    protected static boolean isPlanBG(String string) {
        if (PlanBG.isPlanHpxFinder(string)) {
            return true;
        }
        String string2 = string + Util.FS + "Norder3";
        File file = new File(string2);
        return file.isDirectory();
    }

    protected void suite() {
        if (this.label == null || this.label.trim().length() == 0) {
            this.setLabel(this.survey);
        }
        int n = this.aladin.configuration.getProjAllsky();
        if (this.co == null) {
            this.flagNoTarget = true;
            this.co = new Coord(0.0, 0.0);
            this.co = Localisation.frameToFrame(this.co, this.aladin.localisation.getFrame(), 0);
            this.coRadius = 220.0;
        }
        if (this.coRadius <= 0.0) {
            this.coRadius = 220.0;
        }
        this.objet = this.co + "";
        Plan plan = this.aladin.calque.getPlanBase();
        if (plan instanceof PlanBG) {
            n = plan.projd.t;
        }
        Projection projection = new Projection("allsky", 2, this.co.al, this.co.del, 240.0, 240.0, 250.0, 250.0, 500.0, 500.0, 0.0, false, n, Calib.FK5);
        projection.frame = this.getCurrentFrameDrawing();
        if (Aladin.OUTREACH) {
            projection.frame = 3;
        }
        this.setNewProjD(projection);
        this.typeCM = this.aladin.configuration.getCMMap();
        this.transfertFct = this.aladin.configuration.getCMFct();
        this.video = this.aladin.configuration.getCMVideo();
        this.setDefaultZoom(this.co, this.coRadius);
        this.suiteSpecific();
        this.suite1();
    }

    protected void suite1() {
        this.threading();
        this.log();
    }

    protected void suiteSpecific() {
        this.pixelMin = 0.0;
        this.dataMin = 0.0;
        this.pixelMax = 255.0;
        this.dataMax = 255.0;
        this.selected = true;
        this.active = true;
        this.isOldPlan = false;
        this.pixList = new Hashtable(1000);
        if (this.error == null) {
            this.loader = new HealpixLoader();
        }
        this.RGBControl = new int[this.RGBCONTROL.length];
        for (int i = 0; i < this.RGBCONTROL.length; ++i) {
            this.RGBControl[i] = this.RGBCONTROL[i];
        }
        this.aladin.endMsg();
        this.creatDefaultCM();
        this.resetStats();
    }

    protected void setDefaultZoom(Coord coord, double d) {
        this.setDefaultZoom(coord, d, this.aladin.view.getCurrentView().getWidth());
    }

    protected void setDefaultZoom(Coord coord, double d, int n) {
        this.initZoom = -1.0;
        if (d > 0.0 && coord != null) {
            double d2 = this.projd.rm / 60.0 / this.projd.r;
            double d3 = (double)n * d2;
            double d4 = d3 / d;
            this.initZoom = this.aladin.calque.zoom.getNearestZoomFct(d4);
        }
        if (this.initZoom == -1.0) {
            this.initZoom = coord == null ? 1.0 / (double)(Aladin.OUTREACH ? 64 : 32) : 16.0;
        }
        Aladin.trace(4, "PlanBG.setDefaultZoom(" + coord + "," + Coord.getUnit(d) + ") => zoom = " + this.initZoom);
    }

    protected void log() {
        this.aladin.log(Plan.Tp[this.type], this.label);
    }

    protected void initCache() {
        if (cacheSize == -1L) {
            cacheSize = this.aladin.configuration.getHpxCacheSize();
            Aladin.trace(3, "Cache Size => " + cacheSize);
        }
        if (Aladin.MAXMEM < 50L) {
            Aladin.warning("Full sky Aladin mode requires atleast 64MB of RAM\nWe strongly suggest to adjust the JAVA memory parameter and relaunch Aladin.\nSee the corresponding Aladin FAQ entry available via the Help menu");
        }
    }

    public boolean checkSite(boolean bl) {
        if (this.nbCheckSite >= 3) {
            return false;
        }
        if (this.gluTag == null || this.gluTag.startsWith("__")) {
            return false;
        }
        this.aladin.glu.checkIndirection(this.gluTag, "/properties");
        String string = "" + this.aladin.glu.getURL(this.gluTag, "", false, true, 1);
        if (string.equals(this.url)) {
            return false;
        }
        ++this.nbCheckSite;
        if (bl) {
            this.aladin.command.console("!!! Dynamic Web server site switching => " + string);
            Aladin.trace(2, "Plan " + this.label + " Dynamic Web server site switching: from " + this.url + " to " + string);
        }
        this.url = string;
        return true;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    protected void planReady(boolean bl) {
        super.planReady(bl);
        this.setPourcent(0.0);
        this.flagOk = bl;
        this.aladin.synchroPlan.stop(this.startingTaskId);
        if (this.co != null) {
            this.aladin.view.setRepere(this.co);
        }
        if (!(this instanceof PlanMoc)) {
            if (this.loadMocNow) {
                new Thread(){

                    @Override
                    public void run() {
                        PlanBG.this.loadMoc();
                    }
                }.start();
            } else if (this.hasMoc()) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            PlanBG.this.loadInternalMoc();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.start();
            }
        }
    }

    @Override
    protected boolean waitForPlan() {
        return this.error == null;
    }

    @Override
    protected void setCM(Object object) {
        this.cm = (ColorModel)object;
        this.changeImgID();
    }

    @Override
    protected boolean Free() {
        String string = this.getShortStats();
        if (string != null) {
            this.aladin.log("HealpixStats", string);
        }
        Aladin.trace(4, "PlanBG.Free() stat => " + (string == null ? "null" : string));
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.frameOrigin = 0;
        this.FreePixList();
        this.prop = null;
        return super.Free();
    }

    @Override
    protected void setFmt() {
    }

    protected void seeHipsProp() {
        block3: {
            try {
                if (this.frameHipsProperties == null) {
                    this.frameHipsProperties = new FrameHipsProperties(this);
                }
                this.frameHipsProperties.seeHeaderFits();
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block3;
                exception.printStackTrace();
            }
        }
    }

    protected void FreePixList() {
        try {
            if (this.pixList != null) {
                Enumeration<HealpixKey> enumeration = this.pixList.elements();
                while (enumeration.hasMoreElements()) {
                    HealpixKey healpixKey = enumeration.nextElement();
                    if (healpixKey == null) continue;
                    if (this.useCache && healpixKey.shouldBeCached()) {
                        healpixKey.write();
                    }
                    healpixKey.free();
                }
                this.pixList.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void setPropertie(String string, String string2, String string3) throws Exception {
        if (string.equalsIgnoreCase("Projection")) {
            Projection projection = this.projd;
            this.modifyProj(null, 3, projection.alphai, projection.deltai, projection.rm1, projection.cx, projection.cy, projection.r1, projection.rot, projection.sym, Projection.getProjType(string3), projection.system);
            this.aladin.view.newView(1);
            this.aladin.calque.repaintAll();
        } else {
            super.setPropertie(string, string2, string3);
        }
    }

    protected int getPolaScaleFactor() {
        return this.polaScaleFactor;
    }

    protected void setPolaScaleFactor(int n) {
        this.polaScaleFactor = n;
    }

    protected void clearBuf() {
        Enumeration<HealpixKey> enumeration = this.pixList.elements();
        while (enumeration.hasMoreElements()) {
            HealpixKey healpixKey = enumeration.nextElement();
            if (healpixKey == null) continue;
            healpixKey.clearBuf();
        }
        this.gc();
    }

    @Override
    protected boolean pixelsOriginIntoCache() {
        if (this.flagClearBuf) {
            return true;
        }
        this.clearBuf();
        this.changeImgID();
        this.flagClearBuf = true;
        return true;
    }

    @Override
    protected boolean hasOriginalPixels() {
        return this.isTruePixels();
    }

    @Override
    protected boolean recut(double d, double d2, boolean bl) {
        this.FreePixList();
        this.changeImgID();
        double d3 = this.dataMin;
        double d4 = this.dataMax;
        this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, d, d2, bl, 0, 0, 0, 0);
        if (d3 != d4) {
            this.dataMin = d3;
            this.dataMax = d4;
        }
        if (this.pixelsOrigin != null) {
            int n = this.pixelsOrigin.length / (Math.abs(this.bitpix) / 8);
            if (this.pixels == null || this.pixels.length != n) {
                this.pixels = new byte[n];
            }
            this.to8bits(this.pixels, 0, this.pixelsOrigin, n, this.bitpix, this.pixelMin, this.pixelMax, false);
            this.resetHist();
        }
        return true;
    }

    protected void setMem() {
    }

    @Override
    protected boolean setActivated(boolean bl) {
        if (bl && this.aladin.calque.hasHpxGrid()) {
            System.out.println(this.getStats());
        }
        return super.setActivated(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCacheName() {
        if (this.cacheName != null) {
            return this.cacheName;
        }
        try {
            MyProperties myProperties = new MyProperties();
            String string = this.url + "/" + "properties";
            MyInputStream myInputStream = null;
            try {
                myInputStream = Util.openAnyStream(string);
                myProperties.load(myInputStream);
            }
            finally {
                if (myInputStream != null) {
                    try {
                        ((InputStream)myInputStream).close();
                    }
                    catch (Exception exception) {}
                }
            }
            String string2 = PlanBG.getHiPSID(myProperties);
            string2 = string2.replace("/", "_");
            string2 = string2.replace("\\", "_");
            string2 = string2.replace("?", "_");
            this.cacheName = string2 = string2.replace("#", "_");
        }
        catch (Exception exception) {
            this.cacheName = this.survey + this.version;
        }
        Aladin.trace(4, "getCacheName(): Cache name = [" + this.cacheName + "]");
        return this.cacheName;
    }

    protected String getCacheDir() {
        if (this.flagCache) {
            return this.dirCache;
        }
        this.flagCache = true;
        if (!this.aladin.createCache()) {
            return null;
        }
        String string = System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + "Cache";
        File file = new File(string);
        if (!file.isDirectory() && !file.mkdir()) {
            return null;
        }
        file = new File(string = string + Util.FS + CACHE);
        if (!file.isDirectory() && !file.mkdir()) {
            return null;
        }
        this.dirCache = string;
        return string;
    }

    protected static String getCacheDirStatic() {
        return System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + "Cache" + Util.FS + CACHE;
    }

    protected static void setMaxCacheSize(long l) {
        if (l < 524288L) {
            l = 524288L;
        }
        MAXCACHE = l;
        Aladin.trace(4, "PlanBG.setMaxCacheSize() => " + MAXCACHE / 1024L + "MB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long getCacheSize() {
        Object object = cacheLock;
        synchronized (object) {
            return cacheSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addInCache(long l) {
        Object object = cacheLock;
        synchronized (object) {
            cacheSize += l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCacheSize(long l) {
        Object object = cacheLock;
        synchronized (object) {
            cacheSize = l;
        }
    }

    static synchronized void scanCache() {
        if (cacheSize != -1L && cacheSize < MAXCACHE) {
            return;
        }
        PlanBG.cleanCache();
    }

    public static synchronized void cleanCache() {
        if (scanCache != null) {
            Aladin.trace(4, "Scan cache already running !");
            return;
        }
        String string = PlanBG.getCacheDirStatic();
        if (string == null) {
            PlanBG.setCacheSize(0L);
            return;
        }
        File file = new File(Cache.getCacheDir() + Util.FS + "ScanRunning.bin");
        if (file.exists()) {
            long l = System.currentTimeMillis();
            if (l - file.lastModified() < 3600L) {
                file.setLastModified(l);
            } else {
                Aladin.trace(4, "Detect concurrent scanning HiPS cache => abort");
                return;
            }
        }
        try {
            new RandomAccessFile(file, "rw").close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        scanCache = new Thread("Scan cache"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                3.currentThread().setPriority(1);
                long l = 0L;
                long l2 = System.currentTimeMillis();
                String string = PlanBG.getCacheDirStatic();
                Aladin.trace(3, "Scanning HiPS cache...");
                File[] fileArray = new File(string).listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].isDirectory() || !fileArray[i].getName().endsWith(".old")) continue;
                    Aladin.trace(4, "PlanBG.scanCache(): removing folder " + fileArray[i].getName() + "...");
                    Util.deleteDir(fileArray[i]);
                }
                Vector<FileItem> vector = new Vector<FileItem>(2000);
                l = PlanBG.getCacheSize(new File(string), vector);
                l += PlanBG.getCacheSizePlanHealpix(new File(PlanHealpix.getCacheDirPath()), vector);
                try {
                    Collections.sort(vector, new Comparator(){

                        public int compare(Object object, Object object2) {
                            if (object == object2) {
                                return 0;
                            }
                            if (object == null) {
                                return -1;
                            }
                            if (object2 == null) {
                                return 1;
                            }
                            long l = ((FileItem)object).date;
                            long l2 = ((FileItem)object2).date;
                            return l == l2 ? 0 : (l > l2 ? 1 : -1);
                        }
                    });
                    Enumeration<FileItem> enumeration = vector.elements();
                    while (enumeration.hasMoreElements() && l > 3L * MAXCACHE / 4L) {
                        FileItem fileItem = enumeration.nextElement();
                        File file = fileItem.f;
                        if (fileItem.hasBeenModified() || l <= 3L * MAXCACHE / 4L) continue;
                        Aladin.trace(4, "PlanBG.scanCache(): removing " + file + " (" + fileItem.date + ")");
                        if (file.isFile()) {
                            l -= file.length() / 1024L;
                            if (fileItem.hasBeenModified()) {
                                throw new Exception("File :" + file.getAbsolutePath());
                            }
                            file.delete();
                            continue;
                        }
                        if (!file.isDirectory()) continue;
                        long l3 = Util.dirSize(file) / 1024L;
                        l -= l3;
                        if (fileItem.hasBeenModified()) {
                            throw new Exception("Dir :" + file.getAbsolutePath());
                        }
                        Util.deleteDir(file);
                    }
                    Aladin.trace(3, " => Cache size=" + Util.getUnitDisk(l * 1024L) + " maxCache=" + Util.getUnitDisk(MAXCACHE * 1024L) + " scan in " + (System.currentTimeMillis() - l2) + "ms");
                    PlanBG.setCacheSize(l);
                }
                catch (Exception exception) {
                    Aladin.trace(3, "Simultaneous access on cache => Clean aborted for avoiding conflict" + (exception.getMessage() != null ? " => " + exception.getMessage() : ""));
                }
                finally {
                    File file = new File(Cache.getCacheDir() + Util.FS + "ScanRunning.bin");
                    file.delete();
                    scanCache = null;
                }
            }
        };
        scanCache.start();
    }

    static void clearCache() {
        String string = PlanBG.getCacheDirStatic();
        if (string != null) {
            Util.deleteDir(new File(string));
        }
        if ((string = PlanHealpix.getCacheDirPath()) != null) {
            Util.deleteDir(new File(string));
        }
        PlanBG.setCacheSize(0L);
    }

    public static long getCacheSize(File file, Vector<FileItem> vector) {
        long l = 0L;
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (++NBFILE % 100L == 0L) {
                Util.pause(50);
            }
            if (fileArray[i].isDirectory()) {
                long l2 = PlanBG.getCacheSize(fileArray[i], vector);
                if (l2 == 0L) {
                    fileArray[i].delete();
                    continue;
                }
                l += l2;
                continue;
            }
            l += fileArray[i].length() / 1024L;
            if (vector == null) continue;
            vector.addElement(new FileItem(fileArray[i]));
        }
        return l;
    }

    private static long getCacheSizePlanHealpix(File file, Vector<FileItem> vector) {
        File[] fileArray = file.listFiles();
        long l = 0L;
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            l += Util.dirSize(fileArray[i]);
            vector.addElement(new FileItem(fileArray[i]));
            Util.pause(100);
        }
        return l / 1024L;
    }

    protected String key(HealpixKey healpixKey) {
        return this.key(healpixKey.order, healpixKey.npix, healpixKey.z);
    }

    protected String key(int n, long l) {
        return n + "/" + l;
    }

    protected String key(int n, long l, int n2) {
        return n + "/" + l + (n2 <= 0 ? "" : "_" + n2);
    }

    public HealpixKey askForHealpix(int n, long l) {
        this.readyAfterDraw = false;
        HealpixKey healpixKey = this.drawMode == 1 ? new HealpixKeyPol(this, n, l) : new HealpixKey(this, n, l);
        this.pixList.put(this.key(n, l), healpixKey);
        return healpixKey;
    }

    protected void gc() {
        long l = System.currentTimeMillis();
        if (l - this.lastGc < 1000L) {
            return;
        }
        this.lastGc = l;
        if (this.aladin.getMem() < 256.0) {
            if (this.memCpt) {
                this.lastMemP = Runtime.getRuntime().freeMemory();
            } else {
                this.lastMemI = Runtime.getRuntime().freeMemory();
            }
            if (Math.abs(this.lastMemP - this.lastMemI) < (long)MEMREQUIREDFORGC) {
                return;
            }
        }
        this.nbFlush = 0;
        this.memCpt = !this.memCpt;
        this.aladin.gcIfRequired();
    }

    protected void purge(HealpixKey healpixKey) {
        this.nbFlush += healpixKey.free();
        if (this.nbFlush > 20) {
            this.gc();
        }
        this.pixList.remove(this.key(healpixKey));
    }

    protected void tryWakeUp() {
        this.loader.wakeUp();
    }

    protected HealpixKey getHealpixLowLevel(int n, long l, int n2, int n3) {
        HealpixKey healpixKey = this.pixList.get(this.key(n, l, n2));
        if (healpixKey == null) {
            healpixKey = new HealpixKey(this, n, l, n2, n3);
            this.pixList.put(this.key(n, l, n2), healpixKey);
        }
        if (healpixKey.getStatus() != 6) {
            return null;
        }
        return healpixKey;
    }

    protected HealpixKey getHealpix(int n, long l, boolean bl) {
        return this.getHealpix(n, l, (int)this.getZ(), bl);
    }

    protected HealpixKey getHealpix(int n, long l, int n2, boolean bl) {
        HealpixKey healpixKey = this.pixList.get(this.key(n, l, n2));
        if (healpixKey != null) {
            return healpixKey;
        }
        healpixKey = this.getHealpixFromAllSky(n, l);
        if (healpixKey != null) {
            return healpixKey;
        }
        if (bl) {
            return this.askForHealpix(n, l);
        }
        return null;
    }

    protected HealpixKey getHealpixFromAllSky(int n, long l) {
        if (n != 3) {
            return null;
        }
        HealpixKey healpixKey = this.pixList.get(this.key(3, -1L));
        if (healpixKey == null || healpixKey.getStatus() != 6) {
            return null;
        }
        int n2 = this.getTileOrder();
        if (n2 > 0 && n2 <= this.getAllSkyOrder(healpixKey)) {
            HealpixKey[] healpixKeyArray = healpixKey.getPixList();
            if (healpixKeyArray == null) {
                return null;
            }
            HealpixKey healpixKey2 = healpixKeyArray[(int)l];
            if (healpixKey2 != null) {
                if (this.firstSubtil) {
                    Aladin.trace(4, "PlanBG.getHealpix " + this.label + " will use Allsky for order 3 diamonds!");
                    this.firstSubtil = false;
                }
                return healpixKey2;
            }
        }
        return null;
    }

    static long[] getNpixList(int n, Coord coord, double d) throws Exception {
        return CDSHealpix.query_disc(CDSHealpix.pow2(n), coord.al, coord.del, Math.toRadians(d));
    }

    protected Coord getCooCentre(ViewSimple viewSimple) {
        Coord coord = viewSimple.getCooCentre();
        if (coord == null) {
            return null;
        }
        coord = Localisation.frameToFrame(coord, 0, this.frameOrigin);
        return coord;
    }

    protected long[] getPixListView(ViewSimple viewSimple, int n) {
        return this.getPixList(viewSimple, null, n);
    }

    protected long[] getPixList(ViewSimple viewSimple, Coord coord, int n) {
        try {
            double d;
            if (coord == null) {
                coord = this.getCooCentre(viewSimple);
            }
            double d2 = d = Math.max(viewSimple.getTailleRA(), viewSimple.getTailleDE());
            return (long[])this.filterByMoc(PlanBG.getNpixList(n, coord, d2), n).clone();
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            return new long[0];
        }
    }

    private long[] filterByMoc(long[] lArray, int n) {
        if (this.moc == null) {
            return lArray;
        }
        int n2 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (!this.moc.isIntersecting(n, lArray[i])) continue;
            if (n2 < i) {
                lArray[n2] = lArray[i];
            }
            ++n2;
        }
        if (n2 == lArray.length) {
            return lArray;
        }
        long[] lArray2 = new long[n2];
        System.arraycopy(lArray, 0, lArray2, 0, n2);
        return lArray2;
    }

    protected int getTileOrder() {
        if (this.tileOrder == -1) {
            return 9;
        }
        return this.tileOrder;
    }

    protected void setTileOrder(int n) {
        if (this.tileOrder != -1 || n <= 0) {
            return;
        }
        this.tileOrder = n;
    }

    protected int getAllSkyOrder(HealpixKey healpixKey) {
        HealpixKey[] healpixKeyArray;
        if (this.allSkyOrder == -1 && healpixKey != null && (healpixKeyArray = healpixKey.getPixList()) != null) {
            this.allSkyOrder = healpixKeyArray[0].getLosangeOrder();
        }
        return this.allSkyOrder;
    }

    @Override
    protected boolean pixelsOriginFromDisk() {
        return this.flagOk && !this.color && this.isTruePixels();
    }

    protected int getOrder() {
        return Math.max(3, Math.min(this.maxOrder(), this.maxOrder));
    }

    protected int maxOrder() {
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        return this.maxOrder(viewSimple);
    }

    public String getSurveyDir() {
        if (this.local) {
            return this.url;
        }
        return this.getCacheDir() + Util.FS + this.getCacheName();
    }

    protected String getPixelInfo(double d, double d2, int n) {
        if (!this.pixelsOriginFromDisk() || n != 1) {
            return "";
        }
        double d3 = this.getPixelInDouble(d, d2);
        if (Double.isNaN(d3)) {
            return "";
        }
        return this.Y(d3);
    }

    @Override
    public int getPixel8(int n, int n2) {
        double d = this.getPixelInDouble(n, n2);
        return (int)((d - this.pixelMin) * 256.0 / (this.pixelMax - this.pixelMin));
    }

    @Override
    protected double getPixelOriginInDouble(int n, int n2) {
        return this.getPixelInDouble(n, n2);
    }

    @Override
    protected double getPixelInDouble(int n, int n2) {
        return this.getPixelInDouble((double)n, (double)n2);
    }

    protected double getPixelInDouble(double d, double d2) {
        if (!this.pixelsOriginFromDisk()) {
            return Double.NaN;
        }
        int n = this.getBitpix();
        int n2 = Math.abs(n) / 8;
        byte[] byArray = new byte[n2];
        if (!this.getOnePixelFromCache(byArray, d, d2)) {
            return Double.NaN;
        }
        return this.getPixVal(byArray, n, 0) * this.bScale + this.bZero;
    }

    protected boolean getOnePixelFromCache(byte[] byArray, double d, double d2) {
        return this.getOnePixelFromCache(this.projd, byArray, d, d2);
    }

    protected boolean getOnePixelFromCache(Projection projection, byte[] byArray, double d, double d2) {
        double d3 = this.getOnePixelFromCache(projection, d, d2);
        if (Double.isNaN(d3)) {
            return false;
        }
        PlanBG.setPixVal(byArray, this.getBitpix(), 0, d3);
        return true;
    }

    protected double getOnePixelFromCache(Projection projection, double d, double d2) {
        return this.getOnePixelFromCache(projection, d, d2, -1, 2);
    }

    protected double getOnePixelFromCache(Projection projection, double d, double d2, int n, int n2) {
        return this.getOnePixelFromCache(projection, d, d2, n, (int)this.getZ(), n2);
    }

    protected double getOnePixelFromCache(Projection projection, double d, double d2, int n, int n2, int n3) {
        double d3;
        block4: {
            d3 = Double.NaN;
            if (n <= 0) {
                n = this.getOrder();
            }
            int n4 = (int)CDSHealpix.pow2(n);
            try {
                Coord coord = new Coord();
                coord.x = d;
                coord.y = d2;
                projection.getCoord(coord);
                coord = Localisation.frameToFrame(coord, 0, this.frameOrigin);
                if (Double.isNaN(coord.al) || Double.isNaN(coord.del)) {
                    return Double.NaN;
                }
                double[] dArray = CDSHealpix.radecToPolar(new double[]{coord.al, coord.del});
                long l = CDSHealpix.ang2pix_nest(n4, dArray[0], dArray[1]);
                d3 = this.getHealpixPixel(n, l, dArray[0], dArray[1], n2, n3);
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block4;
                exception.printStackTrace();
            }
        }
        return d3;
    }

    protected double getHealpixPixel(int n, long l, double d, double d2, int n2, int n3) {
        HealpixKey healpixKey;
        HealpixKey healpixKey2 = n3 == 3 ? this.pixList.get(this.key(n, l, n2)) : (healpixKey = this.getHealpixLowLevel(n, l, n2, n3 == 0 ? 2 : 3));
        if (healpixKey == null || healpixKey.getStatus() != 6) {
            return Double.NaN;
        }
        long l2 = (long)healpixKey.width * CDSHealpix.pow2(healpixKey.order);
        try {
            long l3 = CDSHealpix.ang2pix_nest(l2, d, d2);
            return healpixKey.getPixelValue(l3, n3);
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    protected double getHealpixPixel(int n, long l, long l2, int n2) {
        HealpixKey healpixKey = this.getHealpixLowLevel(n, l, (int)this.getZ(), n2 == 0 ? 2 : 3);
        if (healpixKey == null) {
            return Double.NaN;
        }
        return healpixKey.getPixelValue(l2, n2);
    }

    protected double getHealpixClosestPixel(double d, double d2, int n) {
        double d3;
        block4: {
            d3 = Double.NaN;
            int n2 = (int)CDSHealpix.pow2(n);
            try {
                double[] dArray = CDSHealpix.radecToPolar(new double[]{d, d2});
                long l = CDSHealpix.ang2pix_nest(n2, dArray[0], dArray[1]);
                HealpixKey healpixKey = this.getHealpixLowLevel(n, l, (int)this.getZ(), 2);
                if (healpixKey == null) {
                    return Double.NaN;
                }
                long l2 = (long)healpixKey.width * CDSHealpix.pow2(healpixKey.order);
                long l3 = CDSHealpix.ang2pix_nest(l2, dArray[0], dArray[1]);
                HealpixKey healpixKey2 = this.getHealpixLowLevel(n, l, (int)this.getZ(), 2);
                if (healpixKey2 == null) {
                    return Double.NaN;
                }
                d3 = healpixKey2.getPixelValue(l3, 0);
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block4;
                exception.printStackTrace();
            }
        }
        return d3;
    }

    protected double getHealpixLinearPixel(double d, double d2, double d3, double d4, int n) {
        double d5;
        block9: {
            d5 = Double.NaN;
            int n2 = (int)CDSHealpix.pow2(n);
            try {
                int n3;
                double[] dArray = CDSHealpix.radecToPolar(new double[]{d, d2});
                double[] dArray2 = CDSHealpix.radecToPolar(new double[]{d3, d4});
                long l = CDSHealpix.ang2pix_nest(n2, dArray[0], dArray[1]);
                HealpixKey healpixKey = this.getHealpixLowLevel(n, l, (int)this.getZ(), 2);
                if (healpixKey == null) {
                    return Double.NaN;
                }
                long l2 = (long)healpixKey.width * CDSHealpix.pow2(healpixKey.order);
                long l3 = CDSHealpix.ang2pix_nest(l2, dArray[0], dArray[1]);
                long[] lArray = CDSHealpix.neighbours(l2, l3);
                for (int i = n3 = 4; i >= 1; --i) {
                    lArray[i] = lArray[i - 1];
                }
                lArray[0] = l3;
                double d6 = 0.0;
                double d7 = 0.0;
                for (int i = 0; i < n3; ++i) {
                    Object object;
                    HealpixKey healpixKey2 = healpixKey;
                    long l4 = lArray[i];
                    long l5 = healpixKey.npix * (long)healpixKey.width * (long)healpixKey.width;
                    long l6 = l4 - l5;
                    if (l6 < 0L || l6 >= (long)(healpixKey.width * healpixKey.width)) {
                        long l7 = l4 / (long)(healpixKey.width * healpixKey.width);
                        object = this.getHealpixLowLevel(n, l7, (int)this.getZ(), 2);
                        if (object == null) continue;
                        healpixKey2 = object;
                    }
                    try {
                        double d8 = healpixKey2.getPixelValue(l4, 0);
                        if (Double.isNaN(d8)) continue;
                        object = CDSHealpix.pix2ang_nest(l2, l4);
                        double d9 = Coo.distance(dArray2[0], dArray2[1], (double)object[0], (double)object[1]);
                        if (d9 == 0.0) {
                            return d8;
                        }
                        double d10 = 1.0 / d9;
                        d6 += d8 * d10;
                        d7 += d10;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                d5 = d6 / d7;
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block9;
                exception.printStackTrace();
            }
        }
        return d5;
    }

    public static String getFilePath(String string, int n, long l) {
        return string + Util.FS + "Norder" + n + Util.FS + "Dir" + l / 10000L * 10000L + Util.FS + "Npix" + l;
    }

    private static void fillUp(int[] nArray, int n, int[] nArray2) {
        int n2;
        int n3 = n * n;
        int[][] nArray3 = new int[4][n3 / 4];
        int[] nArray4 = new int[4];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = n2 % n < n / 2 ? 0 : 1;
            int n5 = n2 < n3 / 2 ? 1 : 0;
            int n6 = n4 << 1 | n5;
            int n7 = nArray2 == null ? n2 : nArray2[n2];
            nArray[n7] = nArray[n7] << 2 | n6;
            int n8 = n6;
            int n9 = nArray4[n8];
            nArray4[n8] = n9 + 1;
            nArray3[n6][n9] = n7;
        }
        if (n3 > 4) {
            for (n2 = 0; n2 < 4; ++n2) {
                PlanBG.fillUp(nArray, n / 2, nArray3[n2]);
            }
        }
    }

    protected void createHealpixOrder(int n) throws Exception {
        if (n == 0) {
            this.hpx2xy = new int[]{0};
            this.xy2hpx = this.hpx2xy;
            return;
        }
        int n2 = (int)CDSHealpix.pow2(n);
        if (CDSHealpix.log2(n2) != (long)n) {
            throw new Exception("Only HEALPix order power of 2 are supported");
        }
        this.xy2hpx = new int[n2 * n2];
        this.hpx2xy = new int[n2 * n2];
        PlanBG.fillUp(this.xy2hpx, n2, null);
        for (int i = 0; i < this.xy2hpx.length; ++i) {
            this.hpx2xy[this.xy2hpx[i]] = i;
        }
    }

    public final int xy2hpx(int n) {
        return this.xy2hpx[n];
    }

    public final int hpx2xy(int n) {
        return this.hpx2xy[n];
    }

    protected void touchCache() {
        long l = System.currentTimeMillis();
        if (l - this.lastTouch < 60000L) {
            return;
        }
        this.lastTouch = l;
        String string = this.getCacheDir() + Util.FS + this.getCacheName();
        new File(string).setLastModified(l);
        Date date = new Date();
        date.setTime(this.lastTouch);
        Aladin.trace(4, "PlanBG.touchCache() : Date:" + date + " => " + string);
    }

    protected int maxOrder(ViewSimple viewSimple) {
        long l = viewSimple.getIZ();
        if (this.lastIz == l) {
            return this.lastMaxOrder;
        }
        this.lastIz = l;
        int n = this.getTileOrder();
        if (this.RES == null || this.oLosangeOrder != n) {
            this.oLosangeOrder = n;
            if (this.RES == null) {
                this.RES = new double[20];
            }
            this.lastMaxOrder = 0;
            while (this.lastMaxOrder < 20) {
                long l2 = CDSHealpix.pow2(this.lastMaxOrder + n + 1);
                this.RES[this.lastMaxOrder] = CDSHealpix.pixRes(l2) / 3600.0;
                ++this.lastMaxOrder;
            }
        }
        double d = viewSimple.getPixelSize();
        this.lastMaxOrder = 1;
        while (this.lastMaxOrder < this.RES.length && this.RES[this.lastMaxOrder] > d) {
            ++this.lastMaxOrder;
        }
        this.lastMaxOrder = this.adjustMaxOrder(this.lastMaxOrder, d);
        return this.lastMaxOrder;
    }

    protected int adjustMaxOrder(int n, double d) {
        if (n <= 2 && d < 0.06) {
            n = 3;
        }
        return n;
    }

    protected String getFormat() {
        if (this.color) {
            if (this.inFits) {
                return "FITS RGB color";
            }
            return (this.colorPNG || this.inPNG ? "PNG" : "JPEG") + " color";
        }
        if (this.truePixels) {
            return "FITS true pixels (BITPIX=" + this.bitpix + ")";
        }
        return (this.colorPNG || this.inPNG ? "PNG" : "JPEG") + " 8 bits pixels";
    }

    protected void switchFormat() {
        this.truePixels = !this.truePixels;
        this.forceReload();
        if (this.aladin.frameCM != null) {
            this.aladin.frameCM.majCM(true);
        }
    }

    public void forceReload() {
        this.FreePixList();
        this.changeImgID();
        this.flagRecut = true;
        this.flagRecutCoo = new Coord(this.aladin.view.repere.raj, this.aladin.view.repere.dej);
        this.flagRecutRadius = this.aladin.view.getCurrentView().getTaille() / 2.0;
        this.resetHist();
    }

    protected String getMaxResolution() {
        return Coord.getUnit(this.getPixelResolution());
    }

    public int getMaxFileOrder() {
        return this.maxOrder;
    }

    public int getMaxHealpixOrder() {
        return this.maxOrder + this.getTileOrder();
    }

    public double getPixelResolution() {
        long l = CDSHealpix.pow2(this.getMaxHealpixOrder());
        return CDSHealpix.pixRes(l) / 3600.0;
    }

    protected boolean isFullyDrawn() {
        return this.isDrawn() && this.allWaitingKeysDrawn;
    }

    protected boolean isDrawn() {
        return this.readyDone;
    }

    protected boolean isLoading() {
        return !this.loader.isReadyForDrawing();
    }

    protected boolean hasMoreDetails() {
        return this.hasMoreDetails;
    }

    protected String getInfoDetails() {
        return this.getOrder() + "/" + this.maxOrder;
    }

    protected void setHasMoreDetails(boolean bl) {
        this.hasMoreDetails = bl;
    }

    @Override
    protected boolean isSync() {
        if (this.error != null) {
            Aladin.trace(4, "PlanBG.isSync()=true:" + this.label + " => in error (error!=null)");
            return true;
        }
        if (!this.flagOk) {
            Aladin.trace(4, "PlanBG.isSync()=false: " + this.label + " => not ready (!flagOk)");
            return false;
        }
        if (!this.active) {
            Aladin.trace(4, "PlanBG.isSync()=true: " + this.label + "=> not active (!active)");
            return true;
        }
        if (this.getOpacityLevel() == 0.0f && !this.ref) {
            Aladin.trace(4, "PlanBG.isSync()=true: " + this.label + "=> transparent (!ref && opacity=" + this.getOpacityLevel() + ")");
            return true;
        }
        if (this.flagProcessing) {
            Aladin.trace(4, "PlanBG.isSync()=false: " + this.label + "=> is processing (flagProcessing)");
            return false;
        }
        if (this.isLoading()) {
            Aladin.trace(4, "PlanBG.isSync()=false: " + this.label + "=> is loading (isLoading())");
            return false;
        }
        return true;
    }

    @Override
    public boolean isCube() {
        return this.cube;
    }

    public boolean isColored() {
        return this.color;
    }

    public boolean isTruePixels() {
        return this.truePixels;
    }

    public boolean isLocalAllSky() {
        return this.local;
    }

    private boolean childrenReady(HealpixKey healpixKey, ViewSimple viewSimple, int n) {
        int n2 = healpixKey.order + 1;
        this.children = healpixKey.getChildren(this.children);
        for (int i = 0; i < 4; ++i) {
            if (this.isOutMoc(n2, this.children[i])) continue;
            HealpixKey healpixKey2 = this.getHealpix(n2, this.children[i], healpixKey.z, false);
            if (healpixKey2 == null) {
                healpixKey2 = new HealpixKey(this, n2, this.children[i], 0);
            }
            if (healpixKey2.isOutView(viewSimple) || healpixKey2.getStatus() == 6) continue;
            if (n2 == n - 1) {
                return false;
            }
            if (n2 >= n - 1 || this.childrenReady(healpixKey2, viewSimple, n)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void modifyProj(String string, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, int n2, int n3) {
        super.modifyProj(string, n, d, d2, d3, d4, d5, d6, d7, bl, n2, n3);
    }

    protected int isDebugIn(long l) {
        if (!DEBUGMODE) {
            return 0;
        }
        int n = 0;
        if (this.pixDebugIn.length == 0) {
            return 0;
        }
        for (int i = 0; i < this.pixDebugIn.length; ++i) {
            if (l != this.pixDebugIn[i]) continue;
            ++n;
        }
        return n;
    }

    protected void loadAllSkyNow() {
        HealpixKey healpixKey = this.pixList.get(this.key(3, -1L));
        if (healpixKey == null) {
            healpixKey = new HealpixAllsky(this, 3);
            this.pixList.put(this.key(healpixKey), healpixKey);
            try {
                healpixKey.loadNow();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected boolean drawAllSky(Graphics graphics, ViewSimple viewSimple) {
        int n;
        boolean bl = false;
        int n2 = (int)this.getZ(viewSimple);
        HealpixKey healpixKey = this.pixList.get(this.key(3, -1L, n2));
        this.flagWaitAllSky = false;
        if (healpixKey == null) {
            healpixKey = this.drawMode == 1 ? new HealpixAllskyPol(this, 3) : new HealpixAllsky(this, 3, n2);
            this.pixList.put(this.key(healpixKey), healpixKey);
            if (this.local) {
                healpixKey.loadFromNet();
            } else {
                if (!this.useCache || !healpixKey.isCached()) {
                    this.tryWakeUp();
                    if (viewSimple.pref == this) {
                        this.drawBackground(graphics, viewSimple);
                    }
                    return true;
                }
                healpixKey.loadFromCache();
            }
        }
        if ((n = healpixKey.getStatus()) == 7) {
            return false;
        }
        if (n == 6) {
            boolean bl2;
            healpixKey.resetTimer();
            this.statNbItems = 0L;
            double d = Math.min(viewSimple.getTailleRA(), viewSimple.getTailleDE());
            boolean bl3 = bl2 = d < 40.0 && !viewSimple.isAllSky();
            if (bl2) {
                long[] lArray = this.getPixList(viewSimple, null, 3);
                for (int i = 0; i < lArray.length; ++i) {
                    HealpixKey healpixKey2 = healpixKey.getPixList()[(int)lArray[i]];
                    if (healpixKey2 == null || this.isOutMoc(healpixKey2.order, healpixKey2.npix) || healpixKey2.isOutView(viewSimple)) continue;
                    if (this.drawMode == 0) {
                        healpixKey2.draw(graphics, viewSimple);
                    } else if (this.drawMode == 1) {
                        ((HealpixKeyPol)healpixKey2).drawPolarisation(graphics, viewSimple);
                    }
                    ++this.statNbItems;
                    bl = true;
                }
            } else {
                HealpixKey[] healpixKeyArray = healpixKey.getPixList();
                for (int i = 0; i < healpixKeyArray.length; ++i) {
                    HealpixKey healpixKey3 = healpixKeyArray[i];
                    if (healpixKey3 == null || this.isOutMoc(healpixKey3.order, healpixKey3.npix) || healpixKey3.isOutView(viewSimple)) continue;
                    if (this.drawMode == 0) {
                        healpixKey3.draw(graphics, viewSimple);
                    } else if (this.drawMode == 1) {
                        ((HealpixKeyPol)healpixKey3).drawPolarisation(graphics, viewSimple);
                    }
                    ++this.statNbItems;
                    bl = true;
                }
            }
        } else {
            this.flagWaitAllSky = true;
        }
        return bl;
    }

    protected void getCurrentBufPixels(PlanImage planImage, RectangleD rectangleD, double d, double d2, boolean bl) {
        int n;
        int n2 = (int)Math.round(rectangleD.width * d);
        int n3 = (int)Math.round(rectangleD.height * d);
        int n4 = this.getBitpix() == -64 ? -64 : -32;
        int n5 = Math.abs(n4) / 8;
        byte[] byArray = new byte[n2 * n3 * n5];
        byte[] byArray2 = new byte[n5];
        double d3 = Double.NaN;
        boolean bl2 = false;
        boolean bl3 = false;
        int n6 = n = bl ? this.maxOrder : (int)((double)this.getOrder() * d2);
        if (n < 3) {
            n = 3;
        } else if (n > this.maxOrder) {
            n = this.maxOrder;
        }
        int n7 = 0;
        double d4 = 100.0 / (double)n3;
        Coord coord = new Coord();
        Coord coord2 = new Coord();
        block0: for (int i = n3 - 1; i >= 0; --i) {
            planImage.pourcent += d4;
            for (int j = 0; j < n2; ++j) {
                double d5;
                double d6 = rectangleD.x + ((double)j + 0.5) / d;
                double d7 = rectangleD.y + (double)i / d;
                coord.x = d6;
                coord.y = d7;
                planImage.projd.getCoord(coord);
                coord = Localisation.frameToFrame(coord, 0, this.frameOrigin);
                double d8 = rectangleD.x + (double)(j + 1) / d;
                double d9 = rectangleD.y + (double)i / d;
                coord2.x = d8;
                coord2.y = d9;
                planImage.projd.getCoord(coord2);
                coord2 = Localisation.frameToFrame(coord2, 0, this.frameOrigin);
                if (!bl3) {
                    double d10;
                    bl3 = true;
                    double d11 = Coo.distance(coord.al, coord.del, coord2.al, coord2.del) * 2.0;
                    if (d11 < (d10 = this.getPixelResolution()) / 2.0) {
                        bl2 = true;
                    }
                }
                if (Double.isNaN(d5 = Double.isNaN(coord.al) || Double.isNaN(coord.del) ? Double.NaN : (bl2 ? this.getHealpixClosestPixel(coord2.al, coord2.del, n) : this.getHealpixLinearPixel(coord.al, coord.del, coord2.al, coord2.del, n)))) {
                    PlanBG.setPixVal(byArray2, n4, 0, d3);
                    if (!planImage.isBlank) {
                        planImage.isBlank = true;
                        planImage.blank = d3;
                        if (n4 > 0 && planImage.headerFits != null) {
                            planImage.headerFits.setKeyValue("BLANK", d3 + "");
                        }
                    }
                } else {
                    d5 = d5 * this.bScale + this.bZero;
                    PlanBG.setPixVal(byArray2, n4, 0, d5);
                }
                System.arraycopy(byArray2, 0, byArray, n7, n5);
                if ((n7 += n5) > byArray.length) continue block0;
            }
        }
        planImage.bitpix = n4;
        planImage.pixelsOrigin = byArray;
        planImage.dataMin = this.dataMin * this.bScale + this.bZero;
        planImage.dataMax = this.dataMax * this.bScale + this.bZero;
        planImage.pixelMin = this.pixelMin * this.bScale + this.bZero;
        planImage.pixelMax = this.pixelMax * this.bScale + this.bZero;
        planImage.bScale = 1.0;
        planImage.bZero = 0.0;
        planImage.pixels = this.getPix8Bits(null, planImage.pixelsOrigin, planImage.bitpix, planImage.width, planImage.height, planImage.pixelMin, planImage.pixelMax, false, 0, 0, 0);
        PlanImage.invImageLine(planImage.width, planImage.height, planImage.pixels);
        planImage.colorBackground = Color.white;
    }

    protected byte[] getBufPixels8(ViewSimple viewSimple) {
        return this.getPixels8Area(viewSimple, new RectangleD(0.0, 0.0, viewSimple.rv.width, viewSimple.rv.height), true);
    }

    protected byte[] getPixels8Area(ViewSimple viewSimple, RectangleD rectangleD, boolean bl) {
        int[] nArray = this.getPixelsRGBArea(viewSimple, rectangleD, bl);
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            if ((nArray[i] >>> 24 & 0xFF) == 0) {
                byArray[i] = 0;
                continue;
            }
            int n2 = nArray[i] & 0xFF;
            if (n2 < 255) {
                ++n2;
            }
            byArray[i] = (byte)(n2 & 0xFF);
        }
        nArray = null;
        return byArray;
    }

    protected int[] getPixelsRGBArea(ViewSimple viewSimple, RectangleD rectangleD, boolean bl) {
        int n;
        if (viewSimple == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(viewSimple.rv.width, viewSimple.rv.height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        this.drawLosanges(graphics, viewSimple, bl);
        graphics.finalize();
        graphics = null;
        int n2 = (int)Math.ceil(rectangleD.width);
        int n3 = (int)Math.ceil(rectangleD.height);
        int n4 = n2 * n3;
        int[] nArray = new int[n4];
        int n5 = (int)Math.floor(rectangleD.x);
        if (n5 < 0) {
            n5 = 0;
        }
        if ((n = (int)Math.floor(rectangleD.y)) < 0) {
            n = 0;
        }
        bufferedImage.getRGB(n5, n, n2, n3, nArray, 0, n2);
        bufferedImage.flush();
        bufferedImage = null;
        return nArray;
    }

    @Override
    protected Image getImage(ViewSimple viewSimple, boolean bl) {
        if (bl) {
            BufferedImage bufferedImage = new BufferedImage(viewSimple.rv.width, viewSimple.rv.height, 3);
            Graphics graphics = bufferedImage.getGraphics();
            viewSimple.drawBackground(graphics);
            this.drawLosanges(graphics, viewSimple, bl);
            this.adjustCM(bufferedImage);
            graphics.dispose();
            return bufferedImage;
        }
        if (viewSimple.imageBG != null && viewSimple.ovizBG == viewSimple.iz && viewSimple.oImgIDBG == this.imgID && viewSimple.rv.width == viewSimple.owidthBG && viewSimple.rv.height == viewSimple.oheightBG) {
            return viewSimple.imageBG;
        }
        if (viewSimple.imageBG == null || viewSimple.rv.width != viewSimple.owidthBG || viewSimple.rv.height != viewSimple.oheightBG) {
            if (viewSimple.imageBG != null) {
                viewSimple.imageBG.flush();
            }
            if (viewSimple.g2BG != null) {
                viewSimple.g2BG.dispose();
            }
            viewSimple.imageBG = new BufferedImage(viewSimple.rv.width, viewSimple.rv.height, 3);
            viewSimple.g2BG = viewSimple.imageBG.getGraphics();
        } else {
            ((Graphics2D)viewSimple.g2BG).setComposite(AlphaComposite.Clear);
            viewSimple.g2BG.fillRect(0, 0, viewSimple.rv.width, viewSimple.rv.height);
            ((Graphics2D)viewSimple.g2BG).setComposite(AlphaComposite.Src);
        }
        viewSimple.oImgIDBG = this.imgID;
        viewSimple.owidthBG = viewSimple.rv.width;
        viewSimple.oheightBG = viewSimple.rv.height;
        viewSimple.ovizBG = viewSimple.iz;
        this.flagClearBuf = false;
        if (!this.isTransparent()) {
            this.drawBackground(viewSimple.g2BG, viewSimple);
        }
        this.drawLosanges(viewSimple.g2BG, viewSimple, bl);
        try {
            this.adjustCM(viewSimple.imageBG);
        }
        catch (Exception exception) {
            // empty catch block
        }
        viewSimple.w = viewSimple.imageBG.getWidth();
        viewSimple.h = viewSimple.imageBG.getHeight();
        return viewSimple.imageBG;
    }

    private void adjustCM(BufferedImage bufferedImage) {
        boolean bl;
        if (!this.isColored()) {
            return;
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        boolean bl2 = this.RGBControl[0] != 0 || this.RGBControl[1] != 128 || this.RGBControl[2] != 255 || this.RGBControl[3] != 0 || this.RGBControl[4] != 128 || this.RGBControl[5] != 255 || this.RGBControl[6] != 0 || this.RGBControl[7] != 128 || this.RGBControl[8] != 255 || this.video != 0;
        int n3 = n * n2;
        boolean bl3 = bl = this.lastHistID != this.imgID;
        if (bl) {
            this.lastHistID = this.imgID;
            if (this.red == null || n3 != this.red.length) {
                this.red = new byte[n3];
                this.green = new byte[n3];
                this.blue = new byte[n3];
            }
        }
        if (!bl && !bl2) {
            return;
        }
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            int n5 = (n4 & 0xFF000000) >> 24;
            int n6 = (n4 & 0xFF0000) >> 16;
            int n7 = (n4 & 0xFF00) >> 8;
            int n8 = n4 & 0xFF;
            if (bl) {
                this.red[i] = (byte)(0xFF & n6);
                this.green[i] = (byte)(0xFF & n7);
                this.blue[i] = (byte)(0xFF & n8);
            }
            if (!bl2) continue;
            n6 = PlanImageRGB.filter(this.RGBControl[0], this.RGBControl[1], this.RGBControl[2], n6 & 0xFF);
            n7 = PlanImageRGB.filter(this.RGBControl[3], this.RGBControl[4], this.RGBControl[5], n7 & 0xFF);
            n8 = PlanImageRGB.filter(this.RGBControl[6], this.RGBControl[7], this.RGBControl[8], n8 & 0xFF);
            if (this.video == 1) {
                n6 ^= 0xFFFFFFFF;
                n7 ^= 0xFFFFFFFF;
                n8 ^= 0xFFFFFFFF;
            }
            nArray[i] = (n5 & 0xFF) << 24 | (n6 & 0xFF) << 16 | (n7 & 0xFF) << 8 | n8 & 0xFF;
        }
        if (bl2) {
            bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        }
        if (bl) {
            this.resetHist();
            if (this.aladin.frameCM != null) {
                this.aladin.frameCM.repaint();
            }
        }
    }

    protected void filterRGB(int[] nArray, int n) {
        this.changeImgID();
        this.RGBControl[n * 3] = nArray[0];
        this.RGBControl[n * 3 + 1] = nArray[1];
        this.RGBControl[n * 3 + 2] = nArray[2];
    }

    @Override
    protected double[] getHistArray(int n) {
        return n == 0 ? this.histRed : (n == 1 ? this.histGreen : this.histBlue);
    }

    @Override
    protected byte[] getPixelHist(int n) {
        return n == -1 ? super.getPixelHist(n) : (n == 0 ? this.red : (n == 1 ? this.green : this.blue));
    }

    protected synchronized void redrawAsap() {
        if (this.timer != null) {
            return;
        }
        System.out.println("starting fading process");
        this.timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                System.out.println("redrawAsap now");
                PlanBG.this.changeImgID();
                PlanBG.this.aladin.view.repaintAll();
            }
        };
        this.timer.scheduleAtFixedRate(timerTask, 5L, 5L);
    }

    protected synchronized void stopRedraw() {
        if (this.timer == null) {
            return;
        }
        System.out.println("stopping fading process");
        this.timer.cancel();
        this.timer = null;
    }

    @Override
    protected void draw(Graphics graphics, ViewSimple viewSimple, int n, int n2, float f) {
        this.draw(graphics, viewSimple, n, n2, -1.0f, false);
    }

    protected void draw(Graphics graphics, ViewSimple viewSimple, int n, int n2, float f, boolean bl) {
        if (viewSimple == null) {
            return;
        }
        if (f == -1.0f) {
            f = this.getOpacityLevel();
        }
        if ((double)f <= 0.1) {
            return;
        }
        this.resetFading();
        if (graphics instanceof Graphics2D) {
            Composite composite;
            Graphics2D graphics2D;
            block16: {
                graphics2D = (Graphics2D)graphics;
                composite = graphics2D.getComposite();
                try {
                    if ((double)f < 0.9) {
                        Composite composite2 = Util.getImageComposite(f);
                        graphics2D.setComposite(composite2);
                    }
                    if (this.drawMode == 0) {
                        graphics2D.drawImage(this.getImage(viewSimple, bl), n, n2, this.aladin);
                    } else if (this.drawMode == 1) {
                        this.drawPolarisation(graphics2D, viewSimple);
                    }
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace < 3) break block16;
                    exception.printStackTrace();
                }
            }
            graphics2D.setComposite(composite);
        } else if (this.drawMode == 0) {
            graphics.drawImage(this.getImage(viewSimple, bl), n, n2, this.aladin);
        } else if (this.drawMode == 1) {
            this.drawPolarisation(graphics, viewSimple);
        }
        this.setHasMoreDetails(this.maxOrder(viewSimple) < this.maxOrder);
        if (this.fading) {
            this.redrawAsap();
        } else {
            this.stopRedraw();
        }
        this.readyDone = this.readyAfterDraw;
    }

    protected void drawHealpixMouse(Graphics graphics, ViewSimple viewSimple) {
        try {
            Coord coord = new Coord(this.aladin.localisation.getLastCoord().al, this.aladin.localisation.getLastCoord().del);
            coord = Localisation.frameToFrame(coord, 0, this.frameOrigin);
            int n = this.aladin.getOrder();
            if (n < 0) {
                return;
            }
            double[] dArray = CDSHealpix.radecToPolar(new double[]{coord.al, coord.del});
            long l = CDSHealpix.pow2(n);
            long l2 = CDSHealpix.ang2pix_nest(l, dArray[0], dArray[1]);
            HealpixKey healpixKey = new HealpixKey(this, n, l2, 0);
            healpixKey.drawCtrl(graphics, viewSimple);
            if (DEBUGMODE) {
                double[][] dArray2 = CDSHealpix.corners(l, l2);
                for (int i = 0; i < 4; ++i) {
                    coord = new Coord(dArray2[i][0], dArray2[i][1]);
                    coord = Localisation.frameToFrame(coord, this.frameOrigin, 0);
                    Repere repere = new Repere((Plan)this, coord);
                    repere.setType(6);
                    repere.setWithLabel(true);
                    repere.id = "" + i;
                    repere.projection(viewSimple);
                    repere.draw(graphics, viewSimple, 0, 0);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void resetPriority() {
        Enumeration<HealpixKey> enumeration = this.pixList.elements();
        while (enumeration.hasMoreElements()) {
            HealpixKey healpixKey = enumeration.nextElement();
            if (healpixKey.npix == -1L || healpixKey.priority >= 1000) continue;
            healpixKey.priority += 1000;
        }
        this.priority = 0;
    }

    protected void drawPolarisation(Graphics graphics, ViewSimple viewSimple) {
        long[] lArray = null;
        int n = Math.min(this.maxOrder(viewSimple), this.maxOrder);
        int n2 = 0;
        if (viewSimple.getTaille() > 20.0 && (this.hasDrawnSomething = this.drawAllSky(graphics, viewSimple))) {
            return;
        }
        this.setMem();
        this.resetPriority();
        int n3 = Math.max(3, n);
        lArray = this.getPixListView(viewSimple, n3);
        for (int i = 0; i < lArray.length; ++i) {
            HealpixKey healpixKey;
            if (new HealpixKey(this, n3, lArray[i], 0).isOutView(viewSimple) || (healpixKey = this.getHealpix(n3, lArray[i], true)) == null) continue;
            healpixKey.priority = 250 - this.priority++;
            int n4 = healpixKey.getStatus();
            if (n4 == 7) continue;
            if (n4 == 8) {
                healpixKey.setStatus(1, true);
            }
            healpixKey.resetTimer();
            if (n4 != 6) continue;
            n2 += ((HealpixKeyPol)healpixKey).drawPolarisation(graphics, viewSimple);
        }
        this.hasDrawnSomething = n2 > 0;
        this.tryWakeUp();
    }

    protected boolean mustDrawFast() {
        if (!this.computeDrawFast) {
            return this.lastMustDrawFast;
        }
        boolean bl = this.aladin.view.mustDrawFast();
        boolean bl2 = !bl ? false : (this.lastMustDrawFast = this.statTimeDisplay > 100L);
        if (this.lastMustDrawFast) {
            this.computeDrawFast = false;
        }
        return this.lastMustDrawFast;
    }

    protected void resetDrawFastDetection() {
        this.computeDrawFast = true;
    }

    protected void drawHealpixGrid(Graphics graphics, ViewSimple viewSimple) {
        int n;
        long[] lArray;
        int n2 = Math.max(3, Math.min(this.maxOrder(viewSimple), this.maxOrder));
        if (viewSimple.isAllSky()) {
            lArray = new long[12 * (int)CDSHealpix.pow2(n2) * (int)CDSHealpix.pow2(n2)];
            for (n = 0; n < lArray.length; ++n) {
                lArray[n] = n;
            }
        } else {
            lArray = this.getPixList(viewSimple, this.getCooCentre(viewSimple), n2);
        }
        for (n = 0; n < lArray.length; ++n) {
            HealpixKey healpixKey = new HealpixKey(this, n2, lArray[n], 0);
            if (this.isOutMoc(n2, lArray[n]) || healpixKey.isOutView(viewSimple)) continue;
            try {
                healpixKey.drawLosangeBorder(graphics, viewSimple);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void drawLosangesNow(Graphics graphics, ViewSimple viewSimple) {
        int n;
        long[] lArray;
        int n2 = Math.max(3, Math.min(this.maxOrder(viewSimple), this.maxOrder));
        boolean bl = viewSimple.isAllSky() && n2 == 3;
        HealpixKey healpixKey = this.pixList.get(this.key(3, -1L));
        if (bl && healpixKey == null) {
            healpixKey = new HealpixAllsky(this, 3);
            try {
                healpixKey.loadNow();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (viewSimple.isAllSky()) {
            lArray = new long[12 * (int)CDSHealpix.pow2(n2) * (int)CDSHealpix.pow2(n2)];
            for (n = 0; n < lArray.length; ++n) {
                lArray[n] = n;
            }
        } else {
            lArray = this.getPixList(viewSimple, this.getCooCentre(viewSimple), n2);
        }
        for (n = 0; n < lArray.length; ++n) {
            HealpixKey healpixKey2;
            if (this.isOutMoc(n2, lArray[n]) || new HealpixKey(this, n2, lArray[n], 0).isOutView(viewSimple)) continue;
            if (bl && healpixKey != null) {
                healpixKey2 = healpixKey.getPixList()[n];
            } else {
                healpixKey2 = this.getHealpix(n2, lArray[n], true);
                try {
                    healpixKey2.loadNow();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
            }
            if (healpixKey2.status != 6) continue;
            healpixKey2.resetTimer();
            healpixKey2.draw(graphics, viewSimple);
        }
    }

    protected synchronized void drawLosanges(Graphics graphics, ViewSimple viewSimple, boolean bl) {
        if (bl) {
            this.drawLosangesNow(graphics, viewSimple);
        } else {
            this.drawLosangesAsync(graphics, viewSimple);
        }
    }

    protected boolean isOutMoc(int n, long l) {
        if (this.moc == null) {
            return false;
        }
        boolean bl = !this.moc.isIntersecting(n, l);
        return bl;
    }

    protected void drawLosangesAsync(Graphics graphics, ViewSimple viewSimple) {
        int n;
        this.allWaitingKeysDrawn = false;
        boolean bl = true;
        long l = Util.getTime(0);
        int n2 = 0;
        long[] lArray = null;
        int n3 = (int)this.getZ(viewSimple);
        int n4 = Math.max(3, this.minOrder);
        int n5 = Math.min(this.maxOrder(viewSimple), this.maxOrder);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder stringBuilder = new StringBuilder(" order=" + n5);
        HealpixKey healpixKey = this.pixList.get(this.key(3, -1L, n3));
        if (n3 > 0) {
            stringBuilder.append(" z=" + n3);
        }
        if (n4 < 3) {
            if (this.drawAllSky(graphics, viewSimple)) {
                ++n2;
                stringBuilder.append(" allsky1");
            }
            bl4 = true;
        } else {
            boolean bl5 = this.mustDrawFast();
            if (bl5) {
                n4 = n5;
            }
            double d = 0.0;
            double d2 = 0.0;
            Coord coord = this.getCooCentre(viewSimple);
            if (coord != null) {
                d = 1.5707963267948966 - Math.toRadians(coord.del);
                d2 = Math.toRadians(coord.al);
            }
            bl2 = true;
            if (n5 < 3) {
                bl2 = false;
            } else {
                lArray = this.getPixList(viewSimple, coord, n5);
                for (int i = 0; i < lArray.length; ++i) {
                    HealpixKey healpixKey2 = this.getHealpix(n5, lArray[i], n3, false);
                    if (healpixKey2 == null) {
                        if (this.isOutMoc(n5, lArray[i]) || new HealpixKey(this, n5, lArray[i], 0).isOutView(viewSimple)) {
                            lArray[i] = -1L;
                            continue;
                        }
                        bl2 = false;
                        break;
                    }
                    if (this.isOutMoc(n5, lArray[i]) || healpixKey2.isOutView(viewSimple)) {
                        lArray[i] = -1L;
                        continue;
                    }
                    if (healpixKey2.status != 6 && healpixKey2.status != 7) {
                        bl2 = false;
                        break;
                    }
                    healpixKey2.resetTimer();
                    bl3 = true;
                }
            }
            if (n2 == 0 && n5 <= 3 && (!bl2 || !bl3 && healpixKey != null)) {
                if (this.drawAllSky(graphics, viewSimple)) {
                    ++n2;
                    stringBuilder.append(" allsky2");
                }
                bl4 = true;
            }
            this.resetPriority();
            HealpixKey healpixKey3 = null;
            int n6 = n4 < n5 && bl2 ? n5 : (n = n4 < n5 - 3 ? n5 - 3 : n4);
            if (n5 >= 3) {
                for (int i = n; (i <= n5 || !bl3 && i <= n5 + 2 && i <= this.maxOrder) && (lArray = this.getPixList(viewSimple, coord, i)).length != 0; ++i) {
                    block32: {
                        nDraw1 += lArray.length;
                        try {
                            if (coord == null) break block32;
                            long l2 = CDSHealpix.ang2pix_nest(CDSHealpix.pow2(i), d, d2);
                            for (int j = 0; j < lArray.length; ++j) {
                                if (lArray[j] != l2) continue;
                                long l3 = lArray[0];
                                lArray[0] = lArray[j];
                                lArray[j] = l3;
                                break;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    boolean bl6 = false;
                    for (int j = 0; j < lArray.length; ++j) {
                        int n7;
                        HealpixKey healpixKey4;
                        if (lArray[j] == -1L) continue;
                        healpixKey3 = this.getHealpix(i, lArray[j], n3, false);
                        HealpixKey healpixKey5 = healpixKey4 = healpixKey3 != null ? healpixKey3 : new HealpixKey(this, i, lArray[j], 0);
                        if (!bl2 && (this.isOutMoc(i, lArray[j]) || healpixKey4.isOutView(viewSimple))) {
                            ++nOut1;
                            lArray[j] = -1L;
                            continue;
                        }
                        if (healpixKey3 == null && i <= n5) {
                            healpixKey3 = this.getHealpix(i, lArray[j], n3, true);
                        }
                        if (healpixKey3 == null) {
                            HealpixKey healpixKey6 = this.getHealpixPreviousFrame(i, lArray[j]);
                            if (healpixKey6 == null) continue;
                            n2 += healpixKey6.draw(graphics, viewSimple);
                            continue;
                        }
                        if (i < n5) {
                            n7 = 500 - this.priority++;
                        } else {
                            int n8 = this.priority;
                            n7 = n8;
                            this.priority = n8 + 1;
                        }
                        healpixKey3.priority = n7;
                        int n9 = healpixKey3.status;
                        if (n9 == 7) continue;
                        if (n9 == 8) {
                            healpixKey3.setStatus(1, true);
                        }
                        healpixKey3.resetTimer();
                        if (n9 != 6) {
                            HealpixKey healpixKey7 = this.getHealpixPreviousFrame(i, lArray[j]);
                            if (healpixKey7 == null) continue;
                            n2 += healpixKey7.draw(graphics, viewSimple);
                            continue;
                        }
                        n2 += healpixKey3.draw(graphics, viewSimple);
                        this.setHealpixPreviousFrame(i, lArray[j]);
                        if (bl && !this.isColored()) {
                            bl = false;
                            this.pixels = healpixKey3.pixels;
                            this.pixelsOrigin = healpixKey3.pixelsOrigin;
                            this.resetHist();
                        }
                        if (bl6) continue;
                        stringBuilder.append(" " + i);
                        bl6 = true;
                    }
                }
            }
            boolean bl7 = this.allWaitingKeysDrawn = bl2 || n5 <= 3 && this.hasDrawnSomething;
        }
        if (this.isPause() && n2 == 0 && !bl4 && healpixKey != null && healpixKey.getStatus() == 6 && this.drawAllSky(graphics, viewSimple)) {
            ++n2;
            stringBuilder.append(" allsky3");
        }
        this.hasDrawnSomething = n2 > 0;
        this.tryWakeUp();
        long l4 = Util.getTime(0);
        long l5 = (l4 - l) / 1000000L;
        this.statTimeDisplayArray[this.nStat++] = l5;
        long l6 = l5;
        if (this.nStat == this.statTimeDisplayArray.length) {
            this.nStat = 0;
        }
        long l7 = 0L;
        int n10 = 0;
        for (n = 0; n < this.statTimeDisplayArray.length; ++n) {
            if (this.statTimeDisplayArray[n] == 0L) continue;
            l7 += this.statTimeDisplayArray[n];
            ++n10;
        }
        this.statTimeDisplay = n10 > 0 ? l7 / (long)n10 : -1L;
        this.statNbItems = n2;
    }

    protected HealpixKey getHealpixPreviousFrame(int n, long l) {
        return null;
    }

    protected void setHealpixPreviousFrame(int n, long l) {
    }

    protected double getFps() {
        return this.statTimeDisplay > 0L ? 1000.0 / (double)this.statTimeDisplay : -1.0;
    }

    protected void resetFading() {
        this.fading = false;
    }

    protected void updateFading(boolean bl) {
        this.fading |= bl;
    }

    protected void askForRepaint() {
        this.changeImgID();
        if (this.aladin.view == null) {
            return;
        }
        if (this.first) {
            this.first = false;
            this.aladin.view.setRepere(this);
        }
        this.aladin.view.repaintAll();
    }

    protected void drawForeground(Graphics graphics, ViewSimple viewSimple) {
        this.drawForeground1(graphics, viewSimple);
        if (this.flagWaitAllSky && this.drawMode == 0) {
            graphics.setColor(Color.red);
            graphics.drawString("Whole sky in progress...", 5, 30);
        }
    }

    private void drawForeground1(Graphics graphics, ViewSimple viewSimple) {
        viewSimple = viewSimple.getProjSyncView();
        if (this.aladin.calque.hasHpxGrid() || this.isOverlay()) {
            if (this.aladin.calque.hasHpxGrid()) {
                this.drawHealpixGrid(graphics, viewSimple);
            }
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        if (viewSimple.getTaille() < 15.0) {
            return;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.white);
        Stroke stroke = graphics2D.getStroke();
        int n5 = 200;
        graphics2D.setStroke(new BasicStroke(n5));
        Projection projection = viewSimple.getProj().copy();
        projection.setProjCenter(0.0, 0.0);
        projection.frame = 0;
        n3 = 0;
        int n6 = n5 / 2;
        int n7 = (int)(((double)viewSimple.getWidth() / 800.0 - 1.0) * 6.0);
        if (n7 < 0) {
            n7 = 0;
        }
        if (projection.t == 1 || projection.t == 3 || projection.t == 16 || projection.t == 5) {
            Coord coord = projection.c.getProjCenter();
            projection.getXYNative(coord);
            PointD pointD = viewSimple.getViewCoordDble(coord.x, coord.y);
            double d2 = coord.del < 0.0 ? 1.0 : -1.0;
            coord.del = coord.del + d2 * (double)(projection.t == 1 || projection.t == 16 ? 89 : 179);
            projection.getXYNative(coord);
            PointD pointD2 = viewSimple.getViewCoordDble(coord.x, coord.y);
            double d3 = pointD2.y - pointD.y;
            double d4 = pointD2.x - pointD.x;
            n3 = (int)Math.abs(Math.sqrt(d4 * d4 + d3 * d3)) - n7;
            n = (int)(pointD.x - (double)n3);
            n2 = (int)(pointD.y - (double)n3);
            graphics2D.drawOval(n - n6, n2 - n6, (n3 + n6) * 2, (n3 + n6) * 2);
        } else if (projection.t == 4 || projection.t == 11) {
            Projection projection2 = projection.copy();
            d = -projection2.c.getProjRot();
            projection2.setProjRot(0.0);
            projection2.frame = 0;
            projection2.setProjCenter(0.0, 0.1);
            Coord coord = projection2.c.getProjCenter();
            projection2.getXYNative(coord);
            PointD pointD = viewSimple.getViewCoordDble(coord.x, coord.y);
            double d5 = coord.del < 0.0 ? 1.0 : -1.0;
            double d6 = coord.del;
            coord.del += d5 * 89.0;
            projection2.getXYNative(coord);
            PointD pointD3 = viewSimple.getViewCoordDble(coord.x, coord.y);
            coord.del = d6;
            coord.al += 179.0;
            projection2.getXYNative(coord);
            PointD pointD4 = viewSimple.getViewCoordDble(coord.x, coord.y);
            n3 = (int)Math.abs(pointD3.y - pointD.y) - n7;
            n4 = (int)Math.abs(pointD4.x - pointD.x) - n7;
            n = (int)(pointD.x - (double)n4);
            n2 = (int)(pointD.y - (double)n3);
            if (d == 0.0) {
                graphics2D.drawOval(n - n6, n2 - n6, (n4 + n6) * 2, (n3 + n6) * 2);
            } else {
                Util.drawEllipse(graphics2D, n + n4, n2 + n3, n4 + n6, n3 + n6, d);
            }
        }
        graphics2D.setStroke(stroke);
        if (this.pixMode != 0 && this.pixMode != 1 && this.video == 1) {
            n6 = 0;
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(new Color(210, 220, 255));
            if (projection.t == 1 || projection.t == 3 || projection.t == 16 || projection.t == 5) {
                graphics2D.drawOval(n - n6, n2 - n6, (n3 + n6) * 2, (n3 + n6) * 2);
            } else if (projection.t == 4 || projection.t == 11) {
                if (d == 0.0) {
                    graphics2D.drawOval(n - n6, n2 - n6, (n4 + n6) * 2, (n3 + n6) * 2);
                } else {
                    Util.drawEllipse(graphics2D, n + n4, n2 + n3, n4 + n6, n3 + n6, d);
                }
            }
            graphics2D.setStroke(stroke);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void drawBackground(Graphics graphics, ViewSimple viewSimple) {
        if (this.aladin.calque.hasHpxGrid() || this.isOverlay()) {
            return;
        }
        Projection projection = viewSimple.getProjSyncView().getProj().copy();
        projection.setProjCenter(0.0, 0.0);
        projection.frame = 0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        Color color = this.color ? Color.black : (this.cm == null ? Color.white : new Color(this.cm.getRed(0), this.cm.getGreen(0), this.cm.getBlue(0)));
        graphics.setColor(color);
        n3 = 0;
        if (projection.t == 1 || projection.t == 3 || projection.t == 16 || projection.t == 5) {
            Coord coord = projection.c.getProjCenter();
            projection.getXYNative(coord);
            PointD pointD = viewSimple.getViewCoordDble(coord.x, coord.y);
            double d2 = coord.del < 0.0 ? 1.0 : -1.0;
            coord.del = coord.del + d2 * (double)(projection.t == 1 || projection.t == 16 ? 89 : 179);
            projection.getXYNative(coord);
            PointD pointD2 = viewSimple.getViewCoordDble(coord.x, coord.y);
            double d3 = pointD2.y - pointD.y;
            double d4 = pointD2.x - pointD.x;
            n3 = (int)Math.abs(Math.sqrt(d4 * d4 + d3 * d3));
            n = (int)(pointD.x - (double)n3);
            n2 = (int)(pointD.y - (double)n3);
            if (this.isTransparent()) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint = graphics2D.getPaint();
                GradientPaint gradientPaint = new GradientPaint(n, n2, new Color(0, 0, 70), n + n3 * 2, n2 + n3 * 2, new Color(180, 190, 200));
                graphics2D.setPaint(gradientPaint);
                graphics.fillOval(n, n2, n3 * 2, n3 * 2);
                graphics2D.setPaint(paint);
            } else {
                graphics.fillOval(n, n2, n3 * 2, n3 * 2);
            }
        } else if (projection.t == 4 || projection.t == 11) {
            Projection projection2 = projection.copy();
            d = -projection2.c.getProjRot();
            projection2.setProjRot(0.0);
            projection2.frame = 0;
            projection2.setProjCenter(0.0, 0.1);
            Coord coord = projection2.c.getProjCenter();
            projection2.getXYNative(coord);
            PointD pointD = viewSimple.getViewCoordDble(coord.x, coord.y);
            double d5 = coord.del < 0.0 ? 1.0 : -1.0;
            double d6 = coord.del;
            coord.del += d5 * 89.0;
            projection2.getXYNative(coord);
            PointD pointD3 = viewSimple.getViewCoordDble(coord.x, coord.y);
            coord.del = d6;
            coord.al += 179.0;
            projection2.getXYNative(coord);
            PointD pointD4 = viewSimple.getViewCoordDble(coord.x, coord.y);
            n3 = (int)Math.abs(pointD3.y - pointD.y);
            n4 = (int)Math.abs(pointD4.x - pointD.x);
            n = (int)(pointD.x - (double)n4);
            n2 = (int)(pointD.y - (double)n3);
            if (this.isTransparent()) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint = graphics2D.getPaint();
                GradientPaint gradientPaint = new GradientPaint(n + n3 / 4, n2 + n3 / 4, new Color(0, 0, 70), n + n4 * 2 - n3 / 4, n2 + n3 * 2 - n3 / 4, new Color(180, 190, 200));
                graphics2D.setPaint(gradientPaint);
                if (d == 0.0) {
                    graphics.fillOval(n, n2, n4 * 2, n3 * 2);
                } else {
                    Util.fillEllipse(graphics, n + n4, n2 + n3, n4, n3, d);
                }
                graphics2D.setPaint(paint);
            } else if (d == 0.0) {
                graphics.fillOval(n, n2, n4 * 2, n3 * 2);
            } else {
                Util.fillEllipse(graphics, n + n4, n2 + n3, n4, n3, d);
            }
        } else {
            int n5 = viewSimple.rv.width;
            int n6 = viewSimple.rv.height;
            if (this.isTransparent()) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint = graphics2D.getPaint();
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 70), n5, n6, new Color(180, 190, 200));
                graphics2D.setPaint(gradientPaint);
                graphics.fillRect(0, 0, n5, n6);
                graphics2D.setPaint(paint);
            } else {
                graphics.fillRect(0, 0, n5, n6);
            }
        }
    }

    protected float getSegmentLenFactor() {
        return this.segmentLenFactor;
    }

    protected void setSegmentLenFactor(float f) {
        this.segmentLenFactor = f;
    }

    protected int getSegmentThickness() {
        return this.segmentThickness;
    }

    protected void setSegmentThickness(int n) {
        this.segmentThickness = n;
    }

    protected float getSegmentDensityFactor() {
        return this.segmentDensityFactor;
    }

    protected void setSegmentDensityFactor(float f) {
        this.segmentDensityFactor = f;
    }

    private void shouldRefresh() {
        long l = System.currentTimeMillis();
        if (l - this.timerLastDrawBG < 500L) {
            return;
        }
        this.timerLastDrawBG = l;
        this.changeImgID();
        this.aladin.view.repaintAll();
    }

    protected boolean detectServerError(int[] nArray) {
        if (this.moc == null) {
            this.removeHealpixOutsideMoc();
        }
        return nArray[6] == 0 && nArray[7] > 5;
    }

    public void testnet() throws Exception {
        try {
            if (this.moc == null) {
                this.loadInternalMoc();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l = 0L;
        long l2 = 0L;
        int n = 3;
        long l3 = 10000L;
        long l4 = 0x1E00000L;
        long l5 = System.currentTimeMillis();
        System.out.println("Testnet HiPS " + this.label + " maxOrder=" + this.maxOrder + " from " + this.url + " :");
        int n2 = 0;
        int n3 = Aladin.levelTrace;
        Aladin.levelTrace = 0;
        while (true) {
            try {
                while (System.currentTimeMillis() - l5 <= l3 && l2 <= l4) {
                    long l6;
                    int n4 = n + (int)(Math.random() * (double)(this.maxOrder - n));
                    long[] lArray = null;
                    if (this.moc != null) {
                        int n5;
                        int n6 = 0;
                        for (n5 = 0; n5 < this.maxOrder && n6 == 0; ++n5) {
                            if (++n4 > this.maxOrder) {
                                n4 = n;
                            }
                            lArray = this.moc.getPixLevel(n4);
                            n6 = lArray.length;
                        }
                        if (n5 == this.maxOrder) {
                            return;
                        }
                        n5 = (int)(Math.random() * (double)n6);
                        if (n5 >= n6) {
                            n5 = lArray.length - 1;
                        }
                        l6 = lArray[n5];
                        int n7 = n4 + (int)(Math.random() * (double)(this.maxOrder - n4));
                        for (n5 = n4; n5 < n7; ++n5) {
                            int n8 = (int)(Math.random() * 4.0);
                            l6 = l6 * 4L + (long)n8;
                        }
                        n4 = n7;
                    } else {
                        long l7 = 12L * CDSHealpix.pow2(n4) * CDSHealpix.pow2(n4);
                        l6 = (long)(Math.random() * (double)l7);
                        if (l6 >= l7) {
                            l6 = l7 - 1L;
                        }
                    }
                    System.out.print(".Loading " + n4 + "/" + l6 + "... ");
                    HealpixKey healpixKey = new HealpixKey(this, n4, l6, 4);
                    long l8 = healpixKey.timeNet;
                    long l9 = healpixKey.sizeStream;
                    if (l9 == 0L) {
                        System.out.println(" error => " + this.url + "/" + healpixKey.getFileNet());
                    } else {
                        System.out.println(Util.getUnitDisk(l9) + " in " + Util.getTemps(l8));
                    }
                    l += l8;
                    l2 += l9;
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
        Aladin.levelTrace = n3;
        System.out.println("=> Downloaded " + n2 + " tiles in " + HealpixKey.EXT[this.getTileMode()] + " : " + Util.getUnitDisk(l2) + " in " + Util.getTemps(l));
        long l10 = (long)((double)l2 / ((double)l / 1000.0));
        String string = "=> Stream rate " + Util.getUnitDisk(l10) + "/s";
        System.out.println(string);
        this.aladin.console.printInfo(this.label + " net perf " + string);
    }

    public void center(Coord coord) {
        this.aladin.view.setRepere(coord);
        this.aladin.view.showSource();
        this.aladin.view.zoomview.repaint();
        this.aladin.calque.repaintAll();
    }

    protected void resetStats() {
        this.cumulTimeDraw = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimePixel = 0L;
        this.cumulTimeJPEG = 0L;
        this.cumulTimeStream = 0L;
        this.nbWriteCache = 0;
        this.nbLoadCache = 0;
        this.nbLoadNet = 0;
        this.nByteWriteCache = 0L;
        this.nByteReadCache = 0L;
        this.nByteReadNet = 0L;
        this.nbImgDraw = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.nbCreated = 0;
        this.nbImgInBuf = 0;
        this.nbImgCreated = 0;
    }

    @Override
    protected String getStats() {
        return "HealpixKey stats: " + this.label + ":\n.Created: " + this.nbCreated + "   Abort: " + this.nbAborted + "   Free: " + this.nbFree + "\n.Net   : " + this.nbLoadNet + " => " + Util.round((double)this.nByteReadNet / 1048576.0, 2) + "Mb in ~" + Util.round(this.avgLoadNet(), 0) + "ms " + this.streamJpegPixel() + "\n.CacheR: " + this.nbLoadCache + " => " + Util.round((double)this.nByteReadCache / 1048576.0, 2) + "Mb in ~" + Util.round(this.avgLoadCache(), 0) + "ms\n.CacheW: " + this.nbWriteCache + " => " + Util.round((double)this.nByteWriteCache / 1048576.0, 2) + "Mb in ~" + Util.round(this.avgWriteCache(), 0) + "ms\n.Img created: " + this.nbImgCreated + "    reused:" + this.nbImgInBuf + "    drawn " + this.nbImgDraw + " in ~" + Util.round(this.avgDraw(), 0) + "ms\n";
    }

    public String getCreatorFromId() {
        String string = this.id;
        if (string == null) {
            return null;
        }
        if (string.startsWith("ivo://")) {
            string = string.substring(6);
        }
        int n = string.indexOf(47);
        int n2 = string.indexOf(63);
        if (n == -1 && n2 == -1) {
            return null;
        }
        if (n == -1) {
            n = string.length();
        }
        if (n2 == -1) {
            n2 = string.length();
        }
        if (n2 < n) {
            n = n2;
        }
        return string.substring(0, n);
    }

    private String getHost() {
        int n = this.url.indexOf("//");
        if (n == -1) {
            return "?";
        }
        int n2 = this.url.indexOf("/", n + 2);
        if (n2 < 0) {
            n2 = this.url.length();
        }
        return this.url.substring(n + 2, n2);
    }

    protected String getShortStats() {
        if (this.nbLoadNet == 0 && this.nbLoadCache == 0) {
            return null;
        }
        boolean bl = this.isLocalAllSky();
        String string = this.id != null ? this.id : this.label;
        return string + (bl ? " Local:" : " Net[" + this.getHost() + "]:") + this.nbLoadNet + "/" + Util.round((double)this.nByteReadNet / 1048576.0, 2) + "Mb/" + Util.round(this.avgLoadNet(), 0) + "ms CacheR:" + this.nbLoadCache + "/" + Util.round((double)this.nByteReadCache / 1048576.0, 2) + "Mb/" + Util.round(this.avgLoadCache(), 0) + "ms CacheW:" + this.nbWriteCache + "/" + Util.round((double)this.nByteWriteCache / 1048576.0, 2) + "Mb/" + Util.round(this.avgWriteCache(), 0) + "ms";
    }

    protected String streamJpegPixel() {
        if (this.nbLoadNet == 0) {
            return "";
        }
        return "(stream=" + Util.round(this.cumulTimeStream / (long)this.nbLoadNet, 1) + "/jpeg=" + Util.round(this.cumulTimeJPEG / (long)this.nbLoadNet, 1) + "/getpix=" + Util.round(this.cumulTimePixel / (long)this.nbLoadNet, 1) + ")";
    }

    protected String getNetSpeed() {
        long l = this.rateLoadNet();
        int n = this.nbTileError();
        if (n == 0 && l == 0L) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (l != 0L) {
            stringBuilder.append(Util.getUnitDisk(l) + "/s");
        }
        if (n > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" - ");
            }
            stringBuilder.append("tile errors: " + n + "/" + this.pixList.size() + " (" + Util.myRound(100.0 * (double)n / (double)this.pixList.size()) + "%)");
        }
        return stringBuilder.toString();
    }

    protected int nbTileError() {
        if (this.moc == null) {
            return 0;
        }
        this.removeHealpixOutsideMoc();
        Enumeration<HealpixKey> enumeration = this.pixList.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            HealpixKey healpixKey = enumeration.nextElement();
            if (healpixKey.getStatus() != 7) continue;
            ++n;
            Aladin.trace(4, "Error on " + healpixKey);
        }
        return n;
    }

    protected long rateLoadNet() {
        if (this.cumulTimeLoadNet == 0L) {
            return 0L;
        }
        long l = this.nByteReadNet / this.cumulTimeLoadNet * 1000L;
        return l;
    }

    protected double avgDraw() {
        if (this.nbImgDraw == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeDraw / (double)this.nbImgDraw / 1000000.0;
    }

    protected double avgLoadNet() {
        if (this.nbLoadNet == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeLoadNet / (double)this.nbLoadNet;
    }

    protected double avgLoadCache() {
        if (this.nbLoadCache == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeLoadCache / (double)this.nbLoadCache;
    }

    protected double avgWriteCache() {
        if (this.nbWriteCache == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeWriteCache / (double)this.nbWriteCache;
    }

    class Loader
    implements Runnable {
        boolean encore;
        Thread thread;
        int type;
        String label;
        private boolean pause = false;

        Loader(int n) {
            this.type = n;
            this.label = n == 0 ? "LoaderCache" : "LoaderNet";
        }

        void start() {
            this.encore = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = new Thread((Runnable)this, this.label);
            if (!Aladin.NOGUI) {
                Util.decreasePriority(Thread.currentThread(), this.thread);
            }
            this.thread.start();
        }

        void wakeUp() {
            if (this.thread == null) {
                this.start();
            } else if (this.pause) {
                this.thread.interrupt();
            }
        }

        synchronized void setPause(boolean bl) {
            this.pause = bl;
        }

        void stop() {
            this.encore = false;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }

        @Override
        public void run() {
            while (this.encore) {
                try {
                    boolean bl;
                    block17: {
                        bl = false;
                        if (!PlanBG.this.aladin.view.mustDrawFast()) {
                            try {
                                ArrayList<HealpixKey> arrayList = new ArrayList<HealpixKey>();
                                MyEnum myEnum = new MyEnum(PlanBG.this.pixList);
                                while (myEnum.hasMoreElements()) {
                                    HealpixKey healpixKey = (HealpixKey)myEnum.nextElement();
                                    int n = healpixKey.getStatus();
                                    if (this.type == 0 && n == 2) {
                                        healpixKey.loadFromCache();
                                        if (!healpixKey.allSky) {
                                            PlanBG.this.setTileOrder(healpixKey.getLosangeOrder());
                                        }
                                        bl = true;
                                        continue;
                                    }
                                    if (this.type != 1 || n != 3) continue;
                                    arrayList.add(healpixKey);
                                }
                                long l = System.currentTimeMillis();
                                if (arrayList.size() > 0) {
                                    Collections.sort(arrayList);
                                    for (HealpixKey healpixKey : arrayList) {
                                        if (healpixKey.getStatus() != 3) continue;
                                        if (this.type == 0) {
                                            healpixKey.loadFromCache();
                                        } else {
                                            healpixKey.loadFromNet();
                                        }
                                        if (!healpixKey.allSky) {
                                            PlanBG.this.setTileOrder(healpixKey.getLosangeOrder());
                                        }
                                        if (System.currentTimeMillis() - l <= 1000L) continue;
                                        break;
                                    }
                                    bl = true;
                                }
                            }
                            catch (Exception exception) {
                                if (Aladin.levelTrace < 3) break block17;
                                exception.printStackTrace();
                            }
                        }
                    }
                    if (bl) {
                        PlanBG.this.loader.wakeUp();
                        continue;
                    }
                    try {
                        this.setPause(true);
                        Thread.currentThread();
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Throwable throwable) {
                    if (Aladin.levelTrace < 3) continue;
                    throwable.printStackTrace();
                }
            }
            this.thread = null;
        }
    }

    class MyEnum
    implements Enumeration<HealpixKey> {
        HealpixKey[] tab;
        int size;
        int pos;

        MyEnum(Hashtable<String, HealpixKey> hashtable) {
            int n;
            this.tab = new HealpixKey[hashtable.size()];
            Enumeration<HealpixKey> enumeration = hashtable.elements();
            for (n = 0; enumeration.hasMoreElements() && n < this.tab.length; ++n) {
                this.tab[n] = enumeration.nextElement();
            }
            this.size = n;
            try {
                Arrays.sort(this.tab, 0, this.size);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pos = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.pos < this.size;
        }

        @Override
        public HealpixKey nextElement() {
            return this.tab[this.pos++];
        }
    }

    class HealpixLoader
    implements Runnable {
        static final int DELAI = 1000;
        private boolean loading = false;
        private boolean purging = false;
        private Thread thread = null;
        private Loader cacheLoader;
        private Loader netLoader;
        private volatile boolean sleep;
        private boolean isSleeping = false;
        private Object lockSleep = new Object();
        private long ot = -1L;

        HealpixLoader() {
            this.cacheLoader = new Loader(0);
            this.netLoader = new Loader(1);
            this.wakeUp();
        }

        protected boolean isReadyForDrawing() {
            return PlanBG.this.readyAfterDraw;
        }

        protected boolean isLoading() {
            return this.loading;
        }

        protected boolean isPurging() {
            return this.purging;
        }

        protected void wakeUp() {
            if (this.thread != null) {
                this.loading = true;
                this.noSleep();
                if (this.isSleeping()) {
                    this.thread.interrupt();
                }
            } else {
                this.thread = new Thread((Runnable)this, "HealpixLoader");
                Util.decreasePriority(Thread.currentThread(), this.thread);
                this.thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void noSleep() {
            Object object = this.lockSleep;
            synchronized (object) {
                this.sleep = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isSleeping() {
            Object object = this.lockSleep;
            synchronized (object) {
                return this.isSleeping;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSleep(boolean bl) {
            Object object = this.lockSleep;
            synchronized (object) {
                this.isSleeping = bl;
            }
        }

        private boolean shouldRun() {
            return this.isLoading() || this.isPurging();
        }

        @Override
        public void run() {
            Util.pause(100);
            if (PlanBG.this.useCache) {
                this.cacheLoader.start();
            }
            this.netLoader.start();
            do {
                this.sleep = true;
                try {
                    try {
                        this.launchJob();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (PlanBG.this.useCache) {
                        PlanBG.scanCache();
                    }
                    if (!this.sleep) continue;
                    this.setSleep(true);
                    Aladin.trace(5, "PlanBG.HealpixLoader sleeping");
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        Aladin.trace(5, "PlanBG.HealpixLoader wake up !");
                    }
                    this.setSleep(false);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            } while (this.shouldRun());
            if (PlanBG.this.useCache) {
                this.cacheLoader.stop();
            }
            this.netLoader.stop();
            this.thread = null;
            Aladin.trace(5, "PlanBG.HealpixLoader died");
            PlanBG.this.nbFlush = 0;
            PlanBG.this.aladin.gcIfRequired();
        }

        private void launchJob() throws Exception {
            int n;
            Object object;
            Object object2;
            Object object3;
            boolean bl = false;
            boolean bl2 = false;
            int[] nArray = new int[HealpixKey.NBSTATUS];
            Aladin cfr_ignored_0 = PlanBG.this.aladin;
            boolean bl3 = Aladin.levelTrace >= 5;
            boolean bl4 = true;
            int n2 = 0;
            try {
                object3 = new ArrayList<HealpixKey>();
                object2 = PlanBG.this.pixList.elements();
                while (object2.hasMoreElements()) {
                    ((ArrayList)object3).add(object2.nextElement());
                }
                try {
                    Collections.sort(object3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Iterator iterator = ((ArrayList)object3).iterator();
                while (iterator.hasNext()) {
                    object = (HealpixKey)iterator.next();
                    int n3 = ((HealpixKey)object).getStatus();
                    if (bl3 && n3 != 7) {
                        System.out.println((bl4 ? "\n" : "") + object);
                        bl4 = false;
                    }
                    if ((n = ((HealpixKey)object).getLive()) == -1) {
                        PlanBG.this.purge((HealpixKey)object);
                    } else if (n == -2) {
                        bl2 = true;
                        bl = true;
                    } else if (n3 == 6) {
                        ((HealpixKey)object).purgeFils();
                    }
                    switch (n3) {
                        case 1: {
                            if (!((HealpixKey)object).allSky && ((HealpixKey)object).priority >= 1000) {
                                ((HealpixKey)object).setOld();
                                break;
                            }
                            if (PlanBG.this.useCache && ((HealpixKey)object).isCached()) {
                                n3 = 2;
                                ((HealpixKey)object).setStatus(2);
                                break;
                            }
                            n3 = 3;
                            ((HealpixKey)object).setStatus(3);
                            break;
                        }
                        case 6: {
                            if (!PlanBG.this.useCache) break;
                            ((HealpixKey)object).write();
                        }
                    }
                    int n4 = n3;
                    nArray[n4] = nArray[n4] + 1;
                    if (((HealpixKey)object).priority < 250 && n3 != 6 && n3 != 7) {
                        ++n2;
                        continue;
                    }
                    if (((HealpixKey)object).npix != -1L || n3 == 6 || n3 == 7) continue;
                    n2 += 10;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            this.loading = nArray[1] > 0 || nArray[2] > 0 || nArray[3] > 0 || nArray[4] > 0 || nArray[5] > 0;
            boolean bl5 = this.purging = bl || nArray[9] > 0;
            PlanBG.this.pourcent = n2 == 0 ? -2.0 : (n2 >= 10 ? 1.0 : (double)(10 - n2) * 10.0);
            PlanBG.this.readyAfterDraw = n2 == 0;
            PlanBG.this.nbReady = nArray[6];
            if (PlanBG.this.detectServerError(nArray)) {
                PlanBG.this.error = "Server not available";
            }
            object3 = null;
            object2 = null;
            int n5 = Integer.MAX_VALUE;
            object = PlanBG.this.pixList.elements();
            while (object.hasMoreElements()) {
                HealpixKey healpixKey = (HealpixKey)object.nextElement();
                n = healpixKey.getStatus();
                if (n != 3 && n != 5) continue;
                if (n == 5) {
                    object2 = healpixKey;
                }
                if (healpixKey.priority >= n5) continue;
                n5 = healpixKey.priority;
                object3 = healpixKey;
            }
            if (object2 != null && object2 != object3) {
                ((HealpixKey)object2).abort();
            }
            if (nArray[2] > 0) {
                this.cacheLoader.wakeUp();
            }
            if (nArray[3] > 0) {
                this.netLoader.wakeUp();
            }
            if (PlanBG.this.aladin.calque != null && PlanBG.this.oLoading != this.loading) {
                PlanBG.this.oLoading = this.loading;
                PlanBG.this.aladin.calque.select.repaint();
            }
            if (bl2) {
                PlanBG.this.shouldRefresh();
            }
        }
    }

    static class FileItem {
        File f;
        long date;

        FileItem(File file) {
            this.f = file;
            this.date = file.lastModified();
        }

        boolean hasBeenModified() {
            return this.date != this.f.lastModified();
        }
    }
}

