/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.FilterProperties;
import cds.aladin.HealpixAllskyCat;
import cds.aladin.HealpixKey;
import cds.aladin.HealpixKeyCat;
import cds.aladin.Legende;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.Source;
import cds.aladin.TreeNodeAllsky;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class PlanBGCat
extends PlanBG {
    protected static final int MAXGAPORDER = 3;
    private int gapOrder = 0;
    protected int allskyExt = 3;
    private HealpixAllskyCat[] allsky = new HealpixAllskyCat[4];
    protected double completude = 0.0;
    protected Legende leg;

    protected PlanBGCat(Aladin aladin) {
        super(aladin);
    }

    protected PlanBGCat(Aladin aladin, TreeNodeAllsky treeNodeAllsky, String string, Coord coord, double d, String string2) {
        super(aladin, treeNodeAllsky, string, coord, d, string2);
        aladin.log(Plan.Tp[this.type], string);
        this.setAllskyExt();
    }

    @Override
    protected int getTileMode() {
        return 2;
    }

    protected int getGapOrder() {
        return this.gapOrder;
    }

    protected void setGapOrder(int n) {
        if (Math.abs(n) > 3) {
            return;
        }
        this.gapOrder = n;
    }

    @Override
    protected void setSpecificParams(TreeNodeAllsky treeNodeAllsky) {
        this.type = 18;
        this.c = Couleur.getNextDefault(this.aladin.calque);
        this.setOpacityLevel(1.0f);
        this.frameOrigin = treeNodeAllsky.getFrame();
        this.scanProperties();
        this.loadGenericLegende();
    }

    @Override
    protected boolean isCatalog() {
        return true;
    }

    @Override
    protected boolean isSync() {
        boolean bl = super.isSync();
        bl = bl && (this.planFilter == null || this.planFilter.isSync());
        return bl;
    }

    @Override
    protected void suiteSpecific() {
        this.isOldPlan = false;
        this.pixList = new Hashtable(1000);
        this.allsky = null;
        if (this.error == null) {
            this.loader = new PlanBG.HealpixLoader();
        }
    }

    @Override
    protected void log() {
    }

    @Override
    protected boolean isFullyDrawn() {
        return this.readyDone && this.allWaitingKeysDrawn;
    }

    @Override
    protected void draw(Graphics graphics, ViewSimple viewSimple, int n, int n2, float f, boolean bl) {
        if (viewSimple == null) {
            return;
        }
        if (f == -1.0f) {
            f = this.getOpacityLevel();
        }
        if ((double)f <= 0.1) {
            return;
        }
        if (graphics instanceof Graphics2D) {
            Composite composite;
            Graphics2D graphics2D;
            block8: {
                graphics2D = (Graphics2D)graphics;
                composite = graphics2D.getComposite();
                try {
                    if ((double)f < 0.9) {
                        Composite composite2 = Util.getImageComposite(f);
                        graphics2D.setComposite(composite2);
                    }
                    this.draw(graphics2D, viewSimple);
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace < 3) break block8;
                    exception.printStackTrace();
                }
            }
            graphics2D.setComposite(composite);
        } else {
            this.draw(graphics, viewSimple);
        }
        this.readyDone = this.readyAfterDraw;
    }

    @Override
    protected void clearBuf() {
    }

    @Override
    protected HealpixKey getHealpixFromAllSky(int n, long l) {
        return null;
    }

    @Override
    public HealpixKey askForHealpix(int n, long l) {
        this.readyAfterDraw = false;
        HealpixKeyCat healpixKeyCat = new HealpixKeyCat(this, n, l);
        this.pixList.put(this.key(n, l), healpixKeyCat);
        return healpixKeyCat;
    }

    @Override
    protected int getTileOrder() {
        return 9;
    }

    protected boolean drawAllSky(Graphics graphics, ViewSimple viewSimple, int n) {
        boolean bl = false;
        if (this.allsky[n] == null) {
            this.allsky[n] = new HealpixAllskyCat((PlanBG)this, n, this.allskyExt);
            this.pixList.put(this.key(n, -1L), this.allsky[n]);
            if (this.local) {
                this.allsky[n].loadFromNet();
            } else {
                if (!this.useCache || !this.allsky[n].isCached()) {
                    this.tryWakeUp();
                    return true;
                }
                this.allsky[n].loadFromCache();
                this.pourcent = -1.0;
            }
        }
        if (this.allsky[n].getStatus() == 6) {
            bl = this.allsky[n].draw(graphics, viewSimple) > 0;
        }
        return bl;
    }

    @Override
    protected int adjustMaxOrder(int n, double d) {
        return n;
    }

    protected int getCurrentMaxOrder(ViewSimple viewSimple) {
        return Math.max(1, Math.min(this.maxOrder(viewSimple) + this.gapOrder, this.maxOrder));
    }

    private void resetDrawnInView(ViewSimple viewSimple) {
        Enumeration enumeration = this.pixList.elements();
        while (enumeration.hasMoreElements()) {
            HealpixKeyCat healpixKeyCat = (HealpixKeyCat)enumeration.nextElement();
            if (healpixKeyCat == null) continue;
            healpixKeyCat.resetDrawnInView(viewSimple);
        }
    }

    protected void draw(Graphics graphics, ViewSimple viewSimple) {
        int n;
        long[] lArray = null;
        int n2 = this.getCurrentMaxOrder(viewSimple);
        int n3 = 0;
        boolean bl = true;
        long l = 0L;
        long l2 = 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = this.allskyExt == 3;
        StringBuilder stringBuilder = new StringBuilder();
        this.resetDrawnInView(viewSimple);
        if (!bl5) {
            bl2 = this.drawAllSky(graphics, viewSimple, 1);
        }
        if (bl5 || n2 >= 2) {
            bl3 = this.drawAllSky(graphics, viewSimple, 2);
        }
        if (n2 >= 3) {
            bl4 = this.drawAllSky(graphics, viewSimple, 3);
        }
        this.hasDrawnSomething = bl2 || bl3 || bl4;
        this.setMem();
        this.resetPriority();
        boolean bl6 = n2 <= 3;
        lArray = this.getPixListView(viewSimple, 3);
        int n4 = lArray.length;
        long[] lArray2 = null;
        int n5 = 0;
        int n6 = n = bl5 ? 3 : 1;
        while (n <= n2) {
            if (!(!bl5 && (n == 1 && this.allsky[1].getStatus() != 7 || n == 2 && this.allsky[2].getStatus() != 7 || n == 3 && this.allsky[3].getStatus() != 7))) {
                if (n < n2) {
                    lArray2 = new long[lArray.length * 4];
                    n5 = 0;
                } else {
                    lArray2 = null;
                }
                for (int i = 0; i < n4; ++i) {
                    int n7;
                    if (this.isOutMoc(n, lArray[i]) || new HealpixKey(this, n, lArray[i], 0).isOutView(viewSimple)) continue;
                    HealpixKeyCat healpixKeyCat = (HealpixKeyCat)this.getHealpix(n, lArray[i], true);
                    if (lArray2 != null) {
                        lArray2[n5++] = lArray[i] * 4L;
                        lArray2[n5++] = lArray[i] * 4L + 1L;
                        lArray2[n5++] = lArray[i] * 4L + 2L;
                        lArray2[n5++] = lArray[i] * 4L + 3L;
                    }
                    if (healpixKeyCat == null || (n7 = healpixKeyCat.getStatus()) == 7) continue;
                    if (n7 == 8) {
                        healpixKeyCat.setStatus(1, true);
                    }
                    healpixKeyCat.priority = 250 - this.priority++;
                    healpixKeyCat.resetTimer();
                    if (n == n2 && n7 != 6) {
                        bl = false;
                    }
                    if (n7 != 6) {
                        bl6 = true;
                        continue;
                    }
                    n3 += healpixKeyCat.draw(graphics, viewSimple);
                    if (healpixKeyCat.isLast()) {
                        n5 -= 4;
                    }
                    if (n2 != n) continue;
                    HealpixKeyCat healpixKeyCat2 = healpixKeyCat;
                    if (!bl6 && !healpixKeyCat2.isReallyLast(viewSimple)) {
                        bl6 = true;
                    }
                    l += (long)healpixKeyCat2.nLoaded;
                    l2 += (long)healpixKeyCat2.nTotal;
                }
                lArray = lArray2;
                n4 = n5;
            }
            ++n;
        }
        this.drawTilesWithSelection(graphics, viewSimple, n2);
        if (bl) {
            double d;
            double d2 = this.completude = l2 != 0L && l == l2 ? 100.0 : 100.0 * ((double)n2 / (double)this.maxOrder);
            if (l2 != 0L && (d = 100.0 * ((double)l / (double)l2)) > this.completude) {
                this.completude = d;
            }
        }
        if (!bl6) {
            this.completude = 100.0;
        }
        this.setHasMoreDetails(n2 >= this.getMaxFileOrder() ? false : bl6);
        this.allWaitingKeysDrawn = bl;
        boolean bl7 = this.hasDrawnSomething = this.hasDrawnSomething || n3 > 0;
        if (bl6) {
            this.tryWakeUp();
        }
    }

    private int drawTilesWithSelection(Graphics graphics, ViewSimple viewSimple, int n) {
        int n2 = 0;
        for (HealpixKey healpixKey : this.pixList.values()) {
            if (healpixKey.order <= n || healpixKey.getStatus() != 6 || !((HealpixKeyCat)healpixKey).pcat.hasSelectedOrTaggedObj() || healpixKey.isOutView(viewSimple)) continue;
            n2 += ((HealpixKeyCat)healpixKey).drawOnlySelected(graphics, viewSimple);
        }
        return n2;
    }

    @Override
    protected double getCompletude() {
        return this.completude;
    }

    @Override
    protected void askForRepaint() {
        this.updateFilter();
        this.aladin.view.repaintAll();
    }

    @Override
    protected void planReady(boolean bl) {
        super.planReady(bl);
        this.askForRepaint();
    }

    protected void updateFilter() {
        PlanBGCat planBGCat = this;
        planBGCat.planFilter.updateNow();
    }

    @Override
    protected boolean Free() {
        this.aladin.view.deSelect(this);
        super.Free();
        FilterProperties.notifyNewPlan();
        return true;
    }

    @Override
    protected void purge(HealpixKey healpixKey) {
        int n = ((HealpixKeyCat)healpixKey).free(false);
        if (n == 0) {
            return;
        }
        this.nbFlush += n;
        if (this.nbFlush > 2000) {
            this.gc();
        }
        this.pixList.remove(this.key(healpixKey));
    }

    @Override
    protected void resetProj(int n) {
        this.proj[n] = null;
        Enumeration enumeration = this.pixList.elements();
        while (enumeration.hasMoreElements()) {
            HealpixKeyCat healpixKeyCat = (HealpixKeyCat)enumeration.nextElement();
            if (healpixKeyCat.getStatus() != 6 || healpixKeyCat.pcat == null) continue;
            healpixKeyCat.pcat.projpcat[n] = null;
        }
    }

    @Override
    protected void reallocObjetCache() {
        Enumeration enumeration = this.pixList.elements();
        while (enumeration.hasMoreElements()) {
            HealpixKeyCat healpixKeyCat = (HealpixKeyCat)enumeration.nextElement();
            if (healpixKeyCat.getStatus() != 6 || healpixKeyCat.pcat == null) continue;
            healpixKeyCat.pcat.reallocObjetCache();
        }
    }

    @Override
    protected int getNbTable() {
        return 1;
    }

    @Override
    protected Vector<Legende> getLegende() {
        Vector<Legende> vector = new Vector<Legende>();
        vector.addElement(this.getFirstLegende());
        return vector;
    }

    protected void setLegende(Legende legende) {
        this.leg = legende;
        this.setFilter(this.filterIndex);
    }

    @Override
    protected Legende getFirstLegende() {
        return this.leg;
    }

    protected void setPattern(Source source) throws Exception {
        if (this.leg == null) {
            throw new Exception("cannot store pattern in null leg !");
        }
        String[] stringArray = source.getValues();
        for (int i = 0; i < this.leg.field.length; ++i) {
            if (stringArray[i].trim().length() == 0) continue;
            this.leg.field[i].hpxFinderPattern = stringArray[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadGenericLegende() {
        String string = this.getUrl() + "/" + "metadata.xml";
        Pcat pcat = new Pcat(this);
        MyInputStream myInputStream = null;
        try {
            myInputStream = Util.openAnyStream(string);
            pcat.tableParsing(myInputStream, null);
            this.setLegende(pcat.leg);
            if (pcat.hasObj()) {
                this.setPattern((Source)pcat.iterator().next());
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (myInputStream != null) {
                try {
                    myInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAllskyExt() {
        String string = this.getUrl() + "/Norder1/Allsky.tsv";
        MyInputStream myInputStream = null;
        try {
            myInputStream = Util.openAnyStream(string);
            this.allskyExt = 2;
        }
        catch (Exception exception) {
        }
        finally {
            if (myInputStream != null) {
                try {
                    myInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected boolean hasObj() {
        return this.hasSources();
    }

    @Override
    protected boolean hasSources() {
        return this.pixList != null && this.pixList.size() > 0;
    }

    @Override
    protected int getCounts() {
        int n = 0;
        Enumeration enumeration = this.pixList.elements();
        while (enumeration.hasMoreElements()) {
            HealpixKeyCat healpixKeyCat = (HealpixKeyCat)enumeration.nextElement();
            if (healpixKeyCat.getStatus() != 6) continue;
            n += healpixKeyCat.pcat != null ? healpixKeyCat.pcat.getCount() : 0;
        }
        return n;
    }

    @Override
    protected Obj[] getObj() {
        int n;
        int n2 = this.getCounts();
        Obj[] objArray = new Obj[n2];
        Iterator<Obj> iterator = this.iterator();
        for (n = 0; iterator.hasNext() && n < objArray.length; ++n) {
            objArray[n] = iterator.next();
        }
        if (n < objArray.length) {
            Obj[] objArray2 = new Obj[n];
            System.arraycopy(objArray, 0, objArray2, 0, n);
            objArray = objArray2;
        }
        return objArray;
    }

    @Override
    protected Iterator<Obj> iterator() {
        return new ObjIterator(null);
    }

    @Override
    protected Iterator<Obj> iterator(ViewSimple viewSimple) {
        return new ObjIterator(viewSimple);
    }

    class ObjIterator
    implements Iterator<Obj> {
        Enumeration<HealpixKey> e = null;
        Iterator<Obj> it = null;
        int order;
        ViewSimple v;

        ObjIterator(ViewSimple viewSimple) {
            this.v = viewSimple;
            int n = this.order = viewSimple != null ? PlanBGCat.this.getCurrentMaxOrder(viewSimple) : -1;
            if (this.order == 1) {
                this.order = 2;
            }
        }

        @Override
        public boolean hasNext() {
            while (this.it == null || !this.it.hasNext()) {
                if (this.e == null) {
                    if (PlanBGCat.this.pixList == null) {
                        return false;
                    }
                    this.e = PlanBGCat.this.pixList.elements();
                }
                if (!this.e.hasMoreElements()) {
                    return false;
                }
                HealpixKeyCat healpixKeyCat = (HealpixKeyCat)this.e.nextElement();
                if (healpixKeyCat.getStatus() != 6 || this.order != -1 && healpixKeyCat.order > this.order) continue;
                this.it = healpixKeyCat.pcat.iterator(this.v);
            }
            return this.it.hasNext();
        }

        @Override
        public void remove() {
        }

        @Override
        public Obj next() {
            while (this.it == null || !this.it.hasNext()) {
                if (this.e == null) {
                    this.e = PlanBGCat.this.pixList.elements();
                }
                if (!this.e.hasMoreElements()) {
                    return null;
                }
                HealpixKeyCat healpixKeyCat = (HealpixKeyCat)this.e.nextElement();
                if (healpixKeyCat.getStatus() != 6 || this.order != -1 && healpixKeyCat.order > this.order) continue;
                this.it = healpixKeyCat.pcat.iterator(this.v);
            }
            return this.it.next();
        }
    }
}

