/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.HealpixAllsky;
import cds.aladin.HealpixKey;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PointD;
import cds.aladin.TreeNodeAllsky;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.util.Hashtable;
import java.util.Properties;

public class PlanBGCube
extends PlanBG {
    public int depth;
    protected double z = 0.0;
    protected int zInit;
    protected boolean pause;
    private double crval3;
    private double crpix3;
    private double cdelt3;
    private String bunit3;
    protected boolean fromCanal;
    private int precision = -1;
    private double ox = -1.0;
    private double oy = -1.0;
    private double[] bit8 = new double[10000];
    private Hashtable<String, Integer> previousWorkingFrame = new Hashtable();
    private LoadingImmediatelyThread loadingThread = null;

    protected PlanBGCube(Aladin aladin) {
        super(aladin);
    }

    protected PlanBGCube(Aladin aladin, TreeNodeAllsky treeNodeAllsky, String string, Coord coord, double d, String string2) {
        super(aladin, treeNodeAllsky, string, coord, d, string2);
        aladin.log(Plan.Tp[this.type], string);
    }

    @Override
    protected void setSpecificParams(TreeNodeAllsky treeNodeAllsky) {
        super.setSpecificParams(treeNodeAllsky);
        this.depth = treeNodeAllsky.cubeDepth;
        this.zInit = treeNodeAllsky.cubeFirstFrame;
        this.z = this.zInit;
        this.pause = true;
        this.scanCubeProperties();
    }

    @Override
    protected String getFrameLabel(int n) {
        if (!this.active) {
            return this.label;
        }
        if (this.fromCanal) {
            return this.getCanalValue(n);
        }
        String string = this.prop.getProperty("label_" + n);
        if (string == null) {
            string = this.prop.getProperty("obs_collection_" + n);
        }
        return string != null ? string : this.label;
    }

    protected String getCanalValue(int n) {
        if (this.precision == -1) {
            double d = Math.abs(this.cdelt3);
            this.precision = d < 0.001 ? 3 : (d < 0.01 ? 2 : (d < 100.0 ? 1 : 0));
        }
        return "" + (double)((int)Math.round(1000.0 * (((double)(n + 1) - this.crpix3) * this.cdelt3 + this.crval3))) / 1000.0 + (this.bunit3 != null ? " " + this.bunit3 : "");
    }

    @Override
    protected boolean Free() {
        this.stopLoadingImmediately();
        return super.Free();
    }

    protected boolean scanCubeProperties() {
        try {
            Properties properties = this.loadPropertieFile();
            if (properties == null) {
                throw new Exception();
            }
            String string = properties.getProperty("hips_cube_depth");
            if (string == null) {
                string = properties.getProperty("cubeDepth");
            }
            if (string != null) {
                try {
                    this.depth = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    Aladin.trace(3, "PlanBGCube error on cubeDepth property [" + string + "]");
                }
            }
            if ((string = properties.getProperty("hips_cube_firstframe")) == null) {
                string = properties.getProperty("cubeFirstFrame");
            }
            if (string != null) {
                try {
                    this.zInit = Integer.parseInt(string);
                    this.z = this.zInit;
                }
                catch (Exception exception) {
                    Aladin.trace(3, "PlanBGCube error on cubeFirstFrame property [" + string + "]");
                }
            }
            try {
                string = properties.getProperty("data_cube_crpix3");
                this.crpix3 = Double.parseDouble(string);
                string = properties.getProperty("data_cube_crval3");
                this.crval3 = Double.parseDouble(string);
                string = properties.getProperty("data_cube_cdelt3");
                this.cdelt3 = Double.parseDouble(string);
                this.fromCanal = true;
                this.bunit3 = properties.getProperty("data_cube_bunit3");
            }
            catch (Exception exception) {
                this.fromCanal = false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    protected void paramByTreeNode(TreeNodeAllsky treeNodeAllsky, Coord coord, double d) {
        super.paramByTreeNode(treeNodeAllsky, coord, d);
        this.depth = treeNodeAllsky.cubeDepth;
        this.z = treeNodeAllsky.cubeFirstFrame;
    }

    @Override
    protected void activeCubePixels(ViewSimple viewSimple) {
        if (!this.setCubeFrame(viewSimple.cubeControl.lastFrame)) {
            return;
        }
        viewSimple.cubeControl.startTime = System.currentTimeMillis();
        this.askForRepaint();
    }

    @Override
    protected boolean setCubeFrame(double d) {
        if (this.z == d) {
            return false;
        }
        this.z = d;
        return true;
    }

    public void setDepth(int n) {
        this.depth = n;
        int[] nArray = this.aladin.view.getNumView(this);
        if (nArray != null) {
            for (int n2 : nArray) {
                this.aladin.view.viewSimple[nArray[n2]].cubeControl.nbFrame = n;
            }
        }
    }

    @Override
    protected void setZ(double d) {
        this.z = d;
    }

    @Override
    protected double getZ() {
        return this.z;
    }

    @Override
    protected double getZ(ViewSimple viewSimple) {
        if (viewSimple.pref == this) {
            int n = viewSimple.cubeControl.getCurrentFrameIndex();
            if (n == -1) {
                n = viewSimple.cubeControl.lastFrame = this.zInit;
            }
            return n;
        }
        return this.z;
    }

    @Override
    protected void setPause(boolean bl, ViewSimple viewSimple) {
        if (bl == this.pause) {
            return;
        }
        this.pause = bl;
        if (!this.pause) {
            this.loadingImmediately(viewSimple);
        }
    }

    @Override
    protected boolean isPause() {
        return this.pause;
    }

    @Override
    public int getDepth() {
        return this.depth == -1 ? 1 : this.depth;
    }

    @Override
    protected int getInitDelay() {
        return 500;
    }

    @Override
    protected byte getPixel8bit(int n, double d, double d2) {
        double d3;
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        PointD pointD = viewSimple.getPosition(d, d2);
        if (pointD.x != this.ox || pointD.y != this.oy) {
            for (int i = 0; i < this.bit8.length; ++i) {
                this.bit8[i] = Double.NaN;
            }
            this.ox = pointD.x;
            this.oy = pointD.y;
        }
        if (!Double.isNaN(this.bit8[n])) {
            d3 = this.bit8[n];
            System.out.println(d3 + " (from cache)");
        } else {
            d3 = this.bit8[n] = this.getOnePixelFromCache(this.projd, pointD.x, pointD.y, -1, n, 3);
        }
        if (Double.isNaN(d3)) {
            d3 = 0.0;
        }
        return (byte)((int)d3 & 0xFF);
    }

    @Override
    protected String key(HealpixKey healpixKey) {
        return this.key(healpixKey.order, healpixKey.npix, healpixKey.z);
    }

    @Override
    protected String key(int n, long l) {
        return this.key(n, l, (int)this.z);
    }

    @Override
    public HealpixKey askForHealpix(int n, long l) {
        if (this.isPause()) {
            return super.askForHealpix(n, l);
        }
        this.readyAfterDraw = false;
        HealpixKey healpixKey = new HealpixKey(this, n, l, 3);
        this.pixList.put(this.key(n, l), healpixKey);
        return healpixKey;
    }

    @Override
    protected HealpixKey getHealpixPreviousFrame(int n, long l) {
        String string = super.key(n, l);
        Integer n2 = this.previousWorkingFrame.get(string);
        if (n2 == null) {
            return null;
        }
        int n3 = n2;
        HealpixKey healpixKey = (HealpixKey)this.pixList.get(this.key(n, l, n3));
        if (healpixKey == null || healpixKey.getStatus() != 6) {
            this.previousWorkingFrame.remove(string);
            return null;
        }
        return healpixKey;
    }

    @Override
    protected void setHealpixPreviousFrame(int n, long l) {
        int n2 = (int)this.getZ();
        String string = super.key(n, l);
        this.previousWorkingFrame.put(string, new Integer(n2));
    }

    protected void loadingImmediately(ViewSimple viewSimple) {
        this.loadingThread = new LoadingImmediatelyThread(this, viewSimple, (int)this.getZ() + 1);
        this.loadingThread.start();
    }

    protected void stopLoadingImmediately() {
        if (this.loadingThread != null) {
            this.loadingThread.abort();
        }
    }

    protected int getCurrentFrameReady() {
        if (this.isPause() || this.loadingThread == null) {
            return -1;
        }
        return this.loadingThread.getZ();
    }

    class LoadingImmediatelyThread
    extends Thread {
        private int initZ;
        private int z1 = 0;
        private boolean encore;
        private PlanBGCube plan;
        private ViewSimple v;
        int initOrder;
        Coord center;

        LoadingImmediatelyThread(PlanBGCube planBGCube2, ViewSimple viewSimple, int n) {
            this.plan = planBGCube2;
            this.v = viewSimple;
            this.z1 = n;
        }

        void abort() {
            this.encore = false;
        }

        int getZ() {
            return this.z1 - 1;
        }

        private boolean onZone() {
            int n = Math.min(PlanBGCube.this.maxOrder(this.v), PlanBGCube.this.maxOrder);
            if (n != this.initOrder) {
                return false;
            }
            if (n < 3 || this.v.isAllSky()) {
                return true;
            }
            Coord coord = PlanBGCube.this.getCooCentre(this.v);
            return coord.al == this.center.al && coord.del == this.center.del;
        }

        @Override
        public void run() {
            this.encore = true;
            block0: while (this.encore) {
                int n;
                boolean bl;
                int n2;
                this.initZ = this.z1 = (int)this.plan.getZ(this.v) + 1;
                this.center = PlanBGCube.this.getCooCentre(this.v);
                this.initOrder = n2 = Math.min(PlanBGCube.this.maxOrder(this.v), PlanBGCube.this.maxOrder);
                long[] lArray = null;
                boolean bl2 = bl = this.v.isAllSky() || n2 <= 3;
                if (!bl) {
                    lArray = PlanBGCube.this.getPixList(this.v, this.center, n2);
                    for (n = 0; n < lArray.length; ++n) {
                        if (PlanBGCube.this.moc != null && !PlanBGCube.this.moc.isIntersecting(n2, lArray[n])) {
                            lArray[n] = -1L;
                            continue;
                        }
                        if (!new HealpixKey(this.plan, n2, lArray[n], 0).isOutView(this.v)) continue;
                        lArray[n] = -1L;
                    }
                }
                n = 0;
                while (n < PlanBGCube.this.depth && this.encore) {
                    if (PlanBGCube.this.isPause()) {
                        this.encore = false;
                        break;
                    }
                    if (this.z1 >= PlanBGCube.this.depth) {
                        this.z1 = 0;
                    }
                    if (!this.onZone()) break;
                    if (lArray == null) {
                        HealpixAllsky healpixAllsky = new HealpixAllsky((PlanBG)this.plan, 3, this.z1, 2);
                    } else {
                        for (int i = 0; i < lArray.length; ++i) {
                            String string;
                            if (lArray[i] == -1L || PlanBGCube.this.pixList.get(string = PlanBGCube.this.key(n2, lArray[i], this.z1)) != null) continue;
                            HealpixKey healpixKey = new HealpixKey(this.plan, n2, lArray[i], this.z1, 2);
                            PlanBGCube.this.pixList.put(string, healpixKey);
                        }
                    }
                    if (PlanBGCube.this.ox != -1.0) {
                        ((PlanBGCube)PlanBGCube.this).bit8[this.z1] = PlanBGCube.this.getOnePixelFromCache(PlanBGCube.this.projd, PlanBGCube.this.ox, PlanBGCube.this.oy, -1, this.z1, 3);
                    }
                    ++n;
                    ++this.z1;
                }
                while (this.encore && this.onZone()) {
                    this.z1 = 0;
                    if (PlanBGCube.this.isPause()) {
                        this.encore = false;
                        continue block0;
                    }
                    Util.pause(1000);
                }
            }
        }
    }
}

