/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.HealpixAllskyProgen;
import cds.aladin.HealpixKey;
import cds.aladin.HealpixKeyProgen;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.PlanBGCat;
import cds.aladin.Source;
import cds.aladin.TreeNodeAllsky;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.TreeMap;

public class PlanBGProgen
extends PlanBGCat {
    private HealpixAllskyProgen allsky;
    private boolean showFootprint = false;

    protected PlanBGProgen(Aladin aladin) {
        super(aladin);
    }

    protected PlanBGProgen(Aladin aladin, TreeNodeAllsky treeNodeAllsky, String string, Coord coord, double d, String string2) {
        super(aladin, treeNodeAllsky, string, coord, d, string2);
    }

    @Override
    protected void setSpecificParams(TreeNodeAllsky treeNodeAllsky) {
        this.type = 18;
        this.c = Couleur.getNextDefault(this.aladin.calque);
        this.setOpacityLevel(1.0f);
        this.scanProperties();
        if (this.prop != null) {
            String string = this.prop.getProperty("hips_order_min");
            if (string == null) {
                string = this.prop.getProperty("minOrder");
            }
            if (string != null) {
                try {
                    this.minOrder = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.frameOrigin = 0;
        this.url = treeNodeAllsky.getUrl();
        this.local = treeNodeAllsky.isLocal();
        if (this.survey.equals("HpxFinder")) {
            this.survey = this.getAssociatedSurvey() + Util.FS + this.survey;
        }
        this.loadGenericLegende();
    }

    private String getAssociatedSurvey() {
        String string = this.getAssociatedSurveyByProperties();
        if (string == null) {
            string = this.getAssociatedSurveByUrl();
        }
        Aladin.trace(3, "Associated HiPS survey [" + string + "]");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAssociatedSurveyByProperties() {
        String string = this.url.replace('\\', '/');
        int n = string.lastIndexOf("/HpxFinder");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n) + "/" + "properties";
        MyInputStream myInputStream = null;
        try {
            myInputStream = Util.openStream(string2);
            this.prop = new MyProperties();
            this.prop.load(myInputStream);
            String string3 = this.prop.getProperty("label");
            if (string3 != null) {
                String string4 = string3;
                return string4;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (myInputStream != null) {
                try {
                    myInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private String getAssociatedSurveByUrl() {
        String string = this.url.replace('\\', '/');
        int n = string.lastIndexOf("/HpxFinder");
        int n2 = string.lastIndexOf(47, n - 1);
        String string2 = string.substring(n2 + 1, n);
        return string2;
    }

    @Override
    protected int getTileMode() {
        return 5;
    }

    @Override
    protected boolean hasAssociatedFootprints() {
        return true;
    }

    @Override
    public HealpixKey askForHealpix(int n, long l) {
        this.readyAfterDraw = false;
        HealpixKeyProgen healpixKeyProgen = new HealpixKeyProgen(this, n, l);
        this.pixList.put(this.key(n, l), healpixKeyProgen);
        return healpixKeyProgen;
    }

    @Override
    protected void draw(Graphics graphics, ViewSimple viewSimple) {
        this.prepareDraw(viewSimple);
        if (this.pcat == null || !this.pcat.hasObj()) {
            return;
        }
        this.pcat.draw(graphics, null, viewSimple, true, false, 0, 0);
    }

    protected boolean drawAllSky(ViewSimple viewSimple, TreeMap<String, Source> treeMap, int n) {
        boolean bl = false;
        if (this.allsky == null) {
            this.allsky = new HealpixAllskyProgen(this, n);
            this.pixList.put(this.key(n, -1L), this.allsky);
            if (this.local) {
                this.allsky.loadFromNet();
            } else {
                if (!this.useCache || !this.allsky.isCached()) {
                    this.tryWakeUp();
                    return true;
                }
                this.allsky.loadFromCache();
                this.pourcent = -1.0;
            }
        }
        if (this.allsky.getStatus() == 6) {
            boolean bl2 = bl = this.allsky.draw(treeMap) > 0;
            if (bl) {
                this.fusion(treeMap);
            }
        }
        return this.allsky.getStatus() != 7;
    }

    private boolean prepareDraw(ViewSimple viewSimple) {
        long[] lArray = null;
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        TreeMap<String, Source> treeMap = new TreeMap<String, Source>();
        this.setHasMoreDetails(true);
        int n2 = this.maxOrder(viewSimple) + 1;
        if (n2 < 3) {
            n2 = 3;
        }
        if ((n2 < 3 || n2 < this.minOrder) && this.maxOrder >= 3) {
            return false;
        }
        if (n2 > this.maxOrder) {
            n2 = this.maxOrder;
        }
        this.hasDrawnSomething = false;
        if (this.drawAllSky(viewSimple, treeMap, 3)) {
            return this.hasDrawnSomething;
        }
        this.setMem();
        this.resetPriority();
        lArray = this.getPixListView(viewSimple, n2);
        boolean bl = false;
        for (int i = 0; i < lArray.length; ++i) {
            int n3;
            if (this.isOutMoc(n2, lArray[i]) || new HealpixKey(this, n2, lArray[i], 0).isOutView(viewSimple)) continue;
            ++l2;
            HealpixKeyProgen healpixKeyProgen = (HealpixKeyProgen)this.getHealpix(n2, lArray[i], true);
            if (healpixKeyProgen == null || (n3 = healpixKeyProgen.getStatus()) == 7) continue;
            healpixKeyProgen.priority = 250 - this.priority++;
            if (n3 == 8) {
                healpixKeyProgen.setStatus(1, true);
            }
            if (n3 != 6) {
                bl = true;
                continue;
            }
            if ((n += healpixKeyProgen.draw(treeMap)) > 0) {
                healpixKeyProgen.resetTimer();
            }
            ++l;
        }
        this.setHasMoreDetails(bl);
        this.allWaitingKeysDrawn = l2 == l;
        this.fusion(treeMap);
        this.hasDrawnSomething = this.hasObj();
        if (lArray != null && lArray.length > 0) {
            this.tryWakeUp();
        }
        return this.hasDrawnSomething;
    }

    private void fusion(TreeMap<String, Source> treeMap) {
        Pcat pcat = new Pcat(this);
        if (this.pcat != null && this.pcat.hasObj()) {
            Iterator<Obj> iterator = this.pcat.iterator();
            while (iterator.hasNext()) {
                Source source = (Source)iterator.next();
                String string = source.id + source.raj + source.dej;
                boolean bl = treeMap.containsKey(string);
                if (!bl && !source.isSelected()) continue;
                treeMap.put(string, source);
            }
        }
        for (Source source : treeMap.values()) {
            if (this.showFootprint) {
                source.setShowFootprint(true, false);
            }
            pcat.setObjetFast(source);
        }
        this.pcat = pcat;
    }

    protected void setShowFootprint(boolean bl) {
        this.showFootprint = bl;
    }

    @Override
    protected void resetProj(int n) {
        if (this.pcat != null) {
            this.pcat.projpcat[n] = null;
        }
    }

    @Override
    protected void reallocObjetCache() {
        if (this.pcat != null) {
            this.pcat.reallocObjetCache();
        }
    }

    @Override
    protected int getNbTable() {
        return 1;
    }

    @Override
    protected boolean hasObj() {
        return this.pcat == null ? false : this.pcat.hasObj();
    }

    @Override
    protected boolean hasSources() {
        return this.hasObj();
    }

    @Override
    protected int getCounts() {
        return this.pcat == null ? 0 : this.pcat.getCount();
    }

    @Override
    protected Iterator<Obj> iterator() {
        return this.pcat == null ? null : this.pcat.iterator();
    }

    @Override
    protected Iterator<Obj> iterator(ViewSimple viewSimple) {
        return this.iterator();
    }

    @Override
    protected boolean detectServerError(int[] nArray) {
        this.completude = -1.0;
        this.pourcent = -1.0;
        return false;
    }
}

