/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Couleur;
import cds.aladin.FilterProperties;
import cds.aladin.Legende;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlaneLoadEvent;
import cds.aladin.Server;
import cds.aladin.Source;
import cds.tools.Util;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;

public class PlanCatalog
extends Plan {
    URL url = null;
    private long lastFilterLock = -1L;
    static String TEST_TSV_TITLE = "TSV/1_header_line";
    static String TEST_TSV_RESULT = "row=1 col=18 ra=77.405544 de=-63.777272 id=J050937.33-634638.1";
    static String TEST_TSV = "globalSourceID\tsourceCatalog\tepoch\tdesignation\ttmass_designation\tra\tdec\tmagJ\tmagH\tmagK\tmag3_6\tdmag3_6\tmag4_5\tdmag4_5\tmag5_8\tdmag5_8\tmag8_0\tdmag8_0\n1531664539\tiracc\tSMP SSTISAGEMC\tJ050937.33-634638.1\t05093732-6346387\t77.405544\t-63.777272\t6.976\t6.785\t\t6.715\t0.084\t6.719\t0.045\t6.743\t0.029\t6.716\t0.027";
    static String TEST_VOTABLE_TITLE = "VOTABLE/classic_TABLEDATA";
    static String TEST_VOTABLE_RESULT = "row=1 col=18 ra=1.2999999999999998 de=67.83333333333333 id=1";
    static String TEST_VOTABLE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<VOTABLE version=\"1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxmlns=\"http://www.ivoa.net/xml/VOTable/v1.1\"\nxsi:schemaLocation=\"http://www.ivoa.net/xml/VOTable/v1.1 http://www.ivoa.net/xml/VOTable/v1.1\">\n<DESCRIPTION>\nVizieR Astronomical Server: vizier.u-strasbg.fr  2010-07-01T11:59:16\nExplanations and Statistics of UCDs:         See LINK below\nIn case of problem, please report to:    cds-question@unistra.fr\n</DESCRIPTION>\n<!-- VOTable description at http://www.ivoa.net/Documents/latest/VOT.html -->\n<DEFINITIONS>\n<COOSYS ID=\"J2000\" system=\"eq_FK5\" equinox=\"J2000\"/>\n</DEFINITIONS>\n<INFO ID=\"Ref\" name=\"-ref\" value=\"VIZ4c2c829613a3\"/>\n<INFO ID=\"MaxTuples\" name=\"-out.max\" value=\"50\"/>\n<INFO name=\"CatalogsExamined\" value=\"2\">\n2 catalogues with potential matches were examined.\n</INFO>\n<INFO ID=\"Target\" name=\"-c\" value=\"001.286805+67.840004,rm=2.\"/>\n<RESOURCE ID=\"yCat_3135\" name=\"III/135A\">\n<DESCRIPTION>Henry Draper Catalogue and Extension (Cannon+ 1918-1924; ADC 1989)</DESCRIPTION>\n<COOSYS ID=\"B1900_1900.000\" system=\"eq_FK4\" equinox=\"B1900\" epoch=\"1900.000\"/>\n<TABLE ID=\"III_135A_catalog\" name=\"III/135A/catalog\">\n<DESCRIPTION>The catalogue</DESCRIPTION>\n<!-- RowName:  ${HD} -->\n<!-- Now comes the definition of each field -->\n<FIELD name=\"_r\" ucd=\"pos.angDistance\" datatype=\"float\" width=\"3\" precision=\"1\" unit=\"arcmin\"><!-- ucd=\"POS_ANG_DIST_GENERAL\" -->\n<DESCRIPTION>Distance from center (RAB1900=24 00.0, DEB1900=+67 17) at Epoch=J1900.0</DESCRIPTION>\n</FIELD>\n<FIELD name=\"_RAJ2000\" ucd=\"pos.eq.ra;meta.main\" ref=\"J2000\" datatype=\"char\" arraysize=\"7\" unit=\"&quot;h:m:s&quot;\"><!-- ucd=\"POS_EQ_RA_MAIN\" -->\n<DESCRIPTION>Right ascension (FK5) Equinox=J2000.0 Epoch=J1900. (computed by VizieR, not part of the original data)</DESCRIPTION>\n</FIELD>\n<FIELD name=\"_DEJ2000\" ucd=\"pos.eq.dec;meta.main\" ref=\"J2000\" datatype=\"char\" arraysize=\"6\" unit=\"&quot;d:m:s&quot;\"><!-- ucd=\"POS_EQ_DEC_MAIN\" -->\n<DESCRIPTION>Declination (FK5) Equinox=J2000.0 Epoch=J1900. (computed by VizieR, not part of the original data)</DESCRIPTION>\n</FIELD>\n<FIELD name=\"HD\" ucd=\"meta.id;meta.main\" datatype=\"int\" width=\"6\"><!-- ucd=\"ID_MAIN\" -->\n<DESCRIPTION>[1/272150]+ Henry Draper Catalog (HD) number</DESCRIPTION>\n</FIELD>\n<FIELD name=\"DM\" ucd=\"meta.id\" datatype=\"char\" arraysize=\"12*\"><!-- ucd=\"ID_ALTERNATIVE\" -->\n<DESCRIPTION>Durchmusterung identification (1)</DESCRIPTION>\n</FIELD>\n<FIELD name=\"RAB1900\" ucd=\"pos.eq.ra\" ref=\"B1900_1900.000\" datatype=\"char\" arraysize=\"7\" unit=\"&quot;h:m:s&quot;\"><!-- ucd=\"POS_EQ_RA\" -->\n<DESCRIPTION>Hours RA, equinox B1900, epoch 1900.0</DESCRIPTION>\n</FIELD>\n<FIELD name=\"DEB1900\" ucd=\"pos.eq.dec\" ref=\"B1900_1900.000\" datatype=\"char\" arraysize=\"6\" unit=\"&quot;d:m:s&quot;\"><!-- ucd=\"POS_EQ_DEC\" -->\n<DESCRIPTION>Degrees Dec, equinox B1900, epoch 1900.0</DESCRIPTION>\n</FIELD>\n<FIELD name=\"q_Ptm\" ucd=\"meta.code.qual\" datatype=\"unsignedByte\" width=\"1\"><!-- ucd=\"CODE_QUALITY\" -->\n<DESCRIPTION>[0/1]? Code for Ptm: 0 = measured, 1 = value inferred from Ptg and spectral type</DESCRIPTION>\n<VALUES null=\" \" />\n</FIELD>\n<FIELD name=\"Ptm\" ucd=\"phot.mag;em.opt.V\" datatype=\"float\" width=\"5\" precision=\"2\" unit=\"mag\"><!-- ucd=\"PHOT_PHG_V\" -->\n<DESCRIPTION>? Photovisual magnitude (2)</DESCRIPTION>\n<VALUES null=\" \" />\n</FIELD>\n<FIELD name=\"n_Ptm\" ucd=\"meta.note\" datatype=\"char\" arraysize=\"1\"><!-- ucd=\"NOTE\" -->\n<DESCRIPTION>[C] 'C' if Ptm is combined value with Ptg</DESCRIPTION>\n</FIELD>\n<FIELD name=\"q_Ptg\" ucd=\"meta.code.qual\" datatype=\"unsignedByte\" width=\"1\"><!-- ucd=\"CODE_QUALITY\" -->\n<DESCRIPTION>[0/1]? Code for Ptg: 0 = measured, 1 = value inferred from Ptm and spectral type</DESCRIPTION>\n<VALUES null=\" \" />\n</FIELD>\n<FIELD name=\"Ptg\" ucd=\"phot.mag;em.opt\" datatype=\"float\" width=\"5\" precision=\"2\" unit=\"mag\"><!-- ucd=\"PHOT_PHG_MAG\" -->\n<DESCRIPTION>? Photographic magnitude (2)</DESCRIPTION>\n<VALUES null=\" \" />\n</FIELD>\n<FIELD name=\"n_Ptg\" ucd=\"meta.note\" datatype=\"char\" arraysize=\"1\"><!-- ucd=\"NOTE\" -->\n<DESCRIPTION>[C] 'C' if Ptg is combined value for this entry and the following or preceding entry</DESCRIPTION>\n</FIELD>\n<FIELD name=\"SpT\" ucd=\"src.spType\" datatype=\"char\" arraysize=\"3\"><!-- ucd=\"SPECT_TYPE_GENERAL\" -->\n<DESCRIPTION>Spectral type spectral types P are generally nebulae)</DESCRIPTION>\n</FIELD>\n<FIELD name=\"Int\" ucd=\"phot.count;em.opt\" datatype=\"char\" arraysize=\"2\"><!-- ucd=\"PHOT_INTENSITY_ESTIMATED\" -->\n<DESCRIPTION>[ 0-9B] Photographic intensity of spectrum (3)</DESCRIPTION>\n</FIELD>\n<FIELD name=\"Rem\" ucd=\"meta.note\" datatype=\"char\" arraysize=\"1\"><!-- ucd=\"REMARKS\" -->\n<DESCRIPTION>[DEGMR*] Remarks, see note (4)</DESCRIPTION>\n</FIELD>\n<FIELD name=\"Simbad\" ucd=\"DATA_LINK\" datatype=\"char\" arraysize=\"6*\"><!-- ucd=\"(unassigned)\" -->\n<DESCRIPTION>ask the FireBrick Simbad data-base about this object</DESCRIPTION>\n</FIELD>\n<FIELD name=\"Tycho\" ucd=\"meta.ref.url\" datatype=\"char\" arraysize=\"5*\"><!-- ucd=\"DATA_LINK\" -->\n<DESCRIPTION>Cross-identification with Tycho-2 (Cat. IV/25)</DESCRIPTION>\n</FIELD>\n<DATA>      <TABLEDATA>\n<TR><TD>0.2</TD><TD>00 05.2</TD><TD>+67 50</TD><TD>1</TD><TD>BD+67 1599</TD><TD>00 00.0</TD><TD></TD><TD>0</TD><TD/><TD> </TD><TD>1</TD><TD>8.70</TD><TD> </TD><TD>K0 </TD><TD> 3</TD><TD> </TD><TD>Simbad</TD><TD>Tycho</TD></TR>\n</TABLEDATA></DATA>\n</TABLE>\n</RESOURCE>\n</VOTABLE>\n";

    protected PlanCatalog(Aladin aladin, String string, MyInputStream myInputStream, boolean bl, boolean bl2) {
        this.doClose = bl2;
        this.flagSkip = bl;
        String string2 = "Cat";
        this.dis = myInputStream;
        try {
            this.url = new URL("file:" + new File(string).getCanonicalPath());
        }
        catch (Exception exception) {
            String string3 = string + " not found";
            Aladin.warning(string3, 1);
            return;
        }
        if (string != null) {
            int n = string.lastIndexOf(Util.FS);
            string2 = n >= 0 ? string.substring(n + 1) : string;
        }
        this.flagLocal = true;
        this.flagWaitTarget = true;
        this.Suite(aladin, string2, "", "", null, null);
    }

    protected PlanCatalog(Aladin aladin, MyInputStream myInputStream, String string, String string2) {
        this.dis = myInputStream;
        if (string == null) {
            string = "VOApp";
        }
        this.flagWaitTarget = true;
        this.Suite(aladin, string, "", "", string2, null);
    }

    protected PlanCatalog(Aladin aladin, MyInputStream myInputStream, String string) {
        this(aladin, myInputStream, string, null);
    }

    protected PlanCatalog(Aladin aladin) {
        this.aladin = aladin;
        this.type = 8;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        this.flagOk = true;
    }

    public PlanCatalog() {
    }

    protected PlanCatalog(Aladin aladin, URL uRL, MyInputStream myInputStream, String string, String string2, String string3, String string4, Server server) {
        this.dis = myInputStream;
        this.u = uRL;
        this.flagLocal = false;
        this.Suite(aladin, string, string2, string3, string4, server);
    }

    protected void Suite(Aladin aladin, String string, String string2, String string3, String string4, Server server) {
        this.setLogMode(true);
        this.aladin = aladin;
        this.type = 8;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setLabel(string);
        this.objet = string2;
        this.param = string3;
        this.copyright = string4;
        this.headerFits = null;
        this.server = server;
        if (server != null) {
            this.filters = server.filters;
            this.filterIndex = aladin.configuration.getFilter() == 0 ? server.getFilterChoiceIndex() : -1;
        }
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        aladin.calque.unSelectAllPlan();
        this.selected = true;
        this.threading();
    }

    protected String getTableName(Source source) {
        String string;
        String string2 = string = source.leg == null ? null : source.leg.name;
        if (string == null) {
            if (source.info == null) {
                return "Table";
            }
            int n = source.info.indexOf(124);
            int n2 = source.info.indexOf(62);
            if (n == -1 || n2 == -1) {
                return "Table";
            }
            string = source.info.substring(n + 1, n2);
        }
        if (string.endsWith("/out")) {
            string = string.substring(0, string.length() - 4);
        }
        return string;
    }

    protected String getFirstTableName() {
        Iterator<Obj> iterator = this.iterator();
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (!(obj instanceof Source)) continue;
            return this.getTableName((Source)obj);
        }
        return null;
    }

    @Override
    protected boolean isSync() {
        boolean bl = this.hasSources();
        boolean bl2 = this.flagOk && this.error == null || this.flagOk && this.pcat != null && (bl || this.error != null && !bl) || this.pcat != null && this.error != null && !bl;
        bl2 = bl2 && (this.planFilter == null || this.planFilter.isSync());
        return bl2;
    }

    @Override
    protected boolean Free() {
        this.aladin.view.deSelect(this);
        super.Free();
        this.aladin.view.free(this);
        this.headerFits = null;
        FilterProperties.notifyNewPlan();
        return true;
    }

    @Override
    protected boolean isCatalog() {
        return true;
    }

    protected String getDescription() {
        if (this.pcat.description == null) {
            return null;
        }
        return this.pcat.description.toString();
    }

    @Override
    protected int getCounts() {
        return this.pcat == null ? 0 : this.pcat.getCount();
    }

    @Override
    protected Obj[] getObj() {
        return this.pcat.o;
    }

    @Override
    protected void setPropertie(String string, String string2, String string3) throws Exception {
        if (string.equalsIgnoreCase("Shape")) {
            int n = Source.getShapeIndex(string3);
            if (n == -1) {
                throw new Exception("Shape unknown");
            }
            this.setSourceType(n);
            this.aladin.calque.repaintAll();
        } else if (string.equalsIgnoreCase("Filter")) {
            this.setFilter(string3);
        } else {
            super.setPropertie(string, string2, string3);
        }
    }

    @Override
    protected boolean setActivated() {
        if (!this.hasSources()) {
            return false;
        }
        return super.setActivated();
    }

    @Override
    protected boolean waitForPlan() {
        int n = 0;
        n = this.dis != null ? this.pcat.setPlanCat(this, this.dis, null, true) : (this.flagLocal ? this.pcat.setPlanCat(this, this.url, true) : this.pcat.setPlanCat(this, this.u, true));
        if (n == 0) {
            this.error = "No object found in the field!";
            Aladin.error = "No object found in the field!";
        }
        if (n <= 0) {
            this.callAllListeners(new PlaneLoadEvent(this, PlaneLoadEvent.ERROR, Aladin.error));
            return false;
        }
        if ((this.objet == null || this.objet.length() == 0) && this.co != null) {
            this.objet = this.co.getSexa();
            this.aladin.dialog.setDefaultTarget(this.objet);
            this.aladin.dialog.setDefaultTaille(this);
        }
        this.setExtName();
        this.setFilter(this.filterIndex);
        if (this.getNbTable() > 1) {
            this.aladin.calque.splitCatalog(this);
        }
        this.callAllListeners(new PlaneLoadEvent(this, PlaneLoadEvent.SUCCESS, null));
        return true;
    }

    protected static void desactivateAllDedicatedFilters(Aladin aladin) {
        Plan[] planArray = aladin.calque.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan = planArray[i];
            if (!plan.isSimpleCatalog()) continue;
            ((PlanCatalog)plan).setFilter(-1);
        }
    }

    @Override
    protected int getNbTable() {
        return this.pcat.nbTable;
    }

    void increaseSourceSize(int n) {
        Iterator<Obj> iterator = this.iterator();
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (!(obj instanceof Source)) continue;
            ((Source)obj).increaseSourceSize(n);
        }
    }

    @Override
    protected Vector<Legende> getLegende() {
        Vector<Legende> vector = new Vector<Legende>(10);
        Iterator<Obj> iterator = this.iterator();
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (!(obj instanceof Source)) continue;
            Source source = (Source)obj;
            if (source.leg == null || vector.contains(source.leg)) continue;
            vector.addElement(source.leg);
        }
        return vector;
    }

    @Override
    protected Legende getFirstLegende() {
        Iterator<Obj> iterator = this.iterator();
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (!(obj instanceof Source)) continue;
            Source source = (Source)obj;
            if (source.leg == null) continue;
            return source.leg;
        }
        return null;
    }

    @Override
    protected String getProgress() {
        if (!this.flagOk && this.error == null) {
            return " - " + this.pcat.getCount() + " object" + (this.pcat.getCount() <= 1 ? "" : "s") + " - in progress...";
        }
        return super.getProgress();
    }

    @Override
    protected boolean hasSources() {
        return this.pcat != null && this.pcat.hasObj();
    }

    private static boolean test1(Aladin aladin, String string, String string2, String string3) {
        System.out.print("> PlanCatalog test : " + string + "...");
        int n = Aladin.levelTrace;
        Aladin.levelTrace = 0;
        try {
            MyByteArrayStream myByteArrayStream = new MyByteArrayStream();
            myByteArrayStream.write(string2);
            MyInputStream myInputStream = new MyInputStream(myByteArrayStream.getInputStream());
            PlanCatalog planCatalog = new PlanCatalog(aladin, myInputStream, string);
            while (!planCatalog.isReady()) {
                Util.pause(1000);
            }
            Source source = (Source)planCatalog.iterator().next();
            String string4 = "row=" + planCatalog.getCounts() + " col=" + planCatalog.getFirstLegende().getSize() + " ra=" + source.raj + " de=" + source.dej + " id=" + source.id;
            if (!string4.equals(string3)) {
                throw new Exception("respond test [" + string4 + "] should be [" + string3 + "]");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Aladin.levelTrace = n;
            System.out.println(" Error: " + exception.getMessage());
            return false;
        }
        Aladin.levelTrace = n;
        System.out.println(" OK");
        return true;
    }

    protected static boolean test(Aladin aladin) {
        boolean bl = true;
        bl &= PlanCatalog.test1(aladin, TEST_TSV_TITLE, TEST_TSV, TEST_TSV_RESULT);
        return bl &= PlanCatalog.test1(aladin, TEST_VOTABLE_TITLE, TEST_VOTABLE, TEST_VOTABLE_RESULT);
    }

    public void test() throws Exception {
        Aladin.STANDALONE = true;
        Aladin.NOGUI = true;
        Aladin aladin = new Aladin();
        Aladin.startInFrame(aladin);
        assert (PlanCatalog.test(aladin));
    }
}

