/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.ContourAlgorithm;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Ligne;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanTool;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Rectangle;

public final class PlanContour
extends PlanTool {
    static final String OutOfMemoryMESSAGE = "\n\n Either the image is too big \n or there are too many control points.\n Try to zoom in the part of the picture you are interested in \n(and select Consider current zoom only) \n and/or reduce the number of contour levels";
    static final int MAXLEVELS = 20;
    static final Color[] couleursBase = new Color[]{new Color(250, 51, 51), new Color(51, 51, 250), new Color(153, 51, 255), new Color(255, 51, 153), new Color(51, 153, 255), new Color(51, 255, 153)};
    static int icouleursBase = 0;
    boolean mustAdjustContour = false;
    double[] adjustTab = null;
    Calque calque;
    Plan p;
    boolean reduceNoise = true;
    boolean useOnlyCurrentZoom = false;
    private Ligne[][] lines;
    private double partDessin = 0.15;
    private int xShift = 0;
    private int yShift = 0;
    Rectangle zoomv;
    boolean useSmoothing = false;
    int smoothingLevel = 2;
    byte[] orgPixels;
    short[] pixels;
    int width = -1;
    int height = -1;
    int orgWidth = -1;
    int orgHeight = -1;
    int max;
    int min;
    private PlanImage pimg = null;
    private double[] levels = null;
    private double[] orgLevels = null;
    PointD[][] contours = null;
    Color[] couleursContours;
    protected ContourAlgorithm cAlgo = null;
    protected int nbLevels;
    private int nbLevelsComputed = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlanContour(Aladin aladin, String string, PlanImage planImage, double[] dArray, ContourAlgorithm contourAlgorithm, boolean bl, int n, boolean bl2, boolean bl3, Color[] colorArray, Color color) {
        this(aladin, string);
        this.hasXYorig = aladin.calque.getPlanRef() == null;
        this.askActive = false;
        this.flagOk = false;
        contourAlgorithm.pc = this;
        this.pimg = planImage;
        this.levels = dArray;
        this.orgLevels = (double[])this.levels.clone();
        this.nbLevels = dArray.length;
        this.cAlgo = contourAlgorithm;
        this.useSmoothing = bl;
        this.smoothingLevel = n;
        this.useOnlyCurrentZoom = bl2;
        this.reduceNoise = bl3;
        this.initCouleurs(colorArray);
        this.c = color;
        PlanContour planContour = this;
        synchronized (planContour) {
            this.runme = new Thread((Runnable)this, "AladinContour");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    protected PlanContour(Aladin aladin, String string) {
        super(aladin, string);
        this.calque = aladin.calque;
        this.setPourcent(-1.0);
    }

    protected PlanContour(Aladin aladin) {
        this(aladin, "");
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public boolean isMovable() {
        return false;
    }

    @Override
    protected boolean waitForPlan() {
        try {
            this.setPourcent(-1.0);
            if (this.mustAdjustContour) {
                for (int i = 0; i < this.orgLevels.length; ++i) {
                    if (this.adjustTab[i] == this.orgLevels[i]) continue;
                    this.doAdjustContour(this.adjustTab[i], i);
                }
                this.mustAdjustContour = false;
                this.adjustTab = null;
                return true;
            }
            while (!this.calque.zoom.zoomView.zoomok) {
                Util.pause(10);
            }
            this.zoomv = this.aladin.calque.zoom.getZoom();
            this.setPourcent(0.0);
            if (!this.getAllContours()) {
                Aladin.warning(Aladin.error + OutOfMemoryMESSAGE);
                return false;
            }
            this.drawAllContours();
            this.setPourcent(-1.0);
            return true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Aladin.error = outOfMemoryError.toString();
            Aladin.warning(outOfMemoryError + OutOfMemoryMESSAGE);
            return false;
        }
        catch (Exception exception) {
            Aladin.error = exception.toString();
            Aladin.warning(Aladin.error);
            return false;
        }
    }

    protected boolean getPixels() {
        Plan plan = this.p = this.pimg == null ? this.calque.getPlanBase() : this.pimg;
        if (this.p == null) {
            return false;
        }
        this.objet = this.p.objet;
        this.orgWidth = ((PlanImage)this.p).width;
        this.orgHeight = ((PlanImage)this.p).height;
        this.zoomv.x = this.zoomv.x > 0 ? this.zoomv.x : 0;
        this.zoomv.y = this.zoomv.y > 0 ? this.zoomv.y : 0;
        this.zoomv.width = this.zoomv.width > this.orgWidth ? this.orgWidth : this.zoomv.width;
        int n = this.zoomv.height = this.zoomv.height > this.orgHeight ? this.orgHeight : this.zoomv.height;
        if (this.zoomv.x + this.zoomv.width > this.orgWidth) {
            this.zoomv.width = this.orgWidth - this.zoomv.x;
        }
        if (this.zoomv.y + this.zoomv.height > this.orgHeight) {
            this.zoomv.height = this.orgHeight - this.zoomv.y;
        }
        try {
            int n2;
            this.orgPixels = ((PlanImage)this.p).getBufPixels8();
            short[] sArray = new short[this.orgPixels.length];
            for (n2 = sArray.length - 1; n2 >= 0; --n2) {
                sArray[n2] = (short)(this.orgPixels[n2] < 0 ? 256 + this.orgPixels[n2] : this.orgPixels[n2]);
            }
            if (this.useOnlyCurrentZoom) {
                this.width = this.zoomv.width;
                this.height = this.zoomv.height;
                if (this.useSmoothing) {
                    this.width /= this.smoothingLevel;
                    this.height /= this.smoothingLevel;
                    this.pixels = new short[this.width * this.height];
                    this.makeSmoothing(sArray, this.pixels, this.width, this.height, this.orgWidth, this.orgHeight, this.zoomv.x, this.zoomv.y, this.smoothingLevel);
                } else {
                    this.pixels = new short[this.width * this.height];
                    for (n2 = this.height - 1; n2 >= 0; --n2) {
                        for (int i = this.width - 1; i >= 0; --i) {
                            this.pixels[n2 * this.width + i] = sArray[n2 * this.orgWidth + i + this.zoomv.x + this.orgWidth * this.zoomv.y];
                        }
                    }
                }
            } else {
                this.width = this.orgWidth;
                this.height = this.orgHeight;
                if (this.useSmoothing) {
                    this.width /= this.smoothingLevel;
                    this.height /= this.smoothingLevel;
                    this.pixels = new short[this.width * this.height];
                    this.makeSmoothing(sArray, this.pixels, this.width, this.height, this.orgWidth, this.orgHeight, 0, 0, this.smoothingLevel);
                } else {
                    this.pixels = new short[this.width * this.height];
                    this.pixels = sArray;
                }
            }
            if (this.reduceNoise) {
                this.pixels = this.moyenne(this.pixels, this.width, this.height);
                --this.width;
                --this.height;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Aladin.error = outOfMemoryError.toString();
            this.aladin.gc();
            return false;
        }
        catch (Exception exception) {
            Aladin.error = exception.toString();
            return false;
        }
        this.p.sendLog("Contour", "[" + this.p.getLogInfo() + "]");
        return true;
    }

    protected boolean getAllContours() {
        this.contours = new PointD[this.levels.length][];
        if (!this.getPixels()) {
            return false;
        }
        this.adjustLevels();
        this.cAlgo.setData(this.pixels);
        this.cAlgo.setDimension(this.width, this.height);
        try {
            for (int i = 0; i < this.levels.length; ++i) {
                PointD[] pointDArray = this.getContour(this.levels[i]);
                this.contours[i] = pointDArray;
                ++this.nbLevelsComputed;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Aladin.error = outOfMemoryError.toString();
            return false;
        }
        return true;
    }

    private void adjustLevels() {
        if (this.useSmoothing) {
            for (int i = 0; i < this.orgLevels.length; ++i) {
                this.levels[i] = (double)(this.smoothingLevel * this.smoothingLevel) * this.orgLevels[i];
            }
        }
    }

    private PointD[] getContour(double d) {
        this.cAlgo.setLevel(d);
        return this.cAlgo.getContours();
    }

    protected void drawContour(int n) {
        Object object;
        int n2 = 0;
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        Plan plan = viewSimple.pref;
        Projection projection = viewSimple.getProj();
        if (plan == null) {
            plan = this;
        }
        int n3 = 1;
        if (this.useSmoothing) {
            n3 = this.smoothingLevel;
        }
        if (this.useOnlyCurrentZoom) {
            this.xShift += this.zoomv.x;
            this.yShift += this.zoomv.y;
        }
        if (this.useSmoothing) {
            if (this.reduceNoise) {
                this.xShift += this.smoothingLevel;
                this.yShift += this.smoothingLevel;
            } else {
                this.xShift += this.smoothingLevel / 2 + this.smoothingLevel % 2;
                this.yShift += this.smoothingLevel / 2 + this.smoothingLevel % 2;
            }
        } else if (this.reduceNoise) {
            ++this.xShift;
            ++this.yShift;
        }
        PointD[] pointDArray = this.contours[n];
        Ligne[] ligneArray = new Ligne[pointDArray.length];
        int n4 = 0;
        Coord coord = new Coord();
        while (n4 < pointDArray.length - 1) {
            PointD pointD;
            if ((object = pointDArray[++n4]) == null) continue;
            coord.x = (double)n3 * object.x + (double)this.xShift;
            coord.y = (double)n3 * object.y + (double)this.yShift;
            double d = coord.x;
            double d2 = coord.y;
            if (this.p.projd != projection) {
                coord.x = viewSimple.HItoI(coord.x);
                coord.y = viewSimple.HItoI(coord.y);
                this.p.projd.getCoord(coord);
                projection.getXY(coord);
                d = viewSimple.ItoHI(coord.x);
                d2 = viewSimple.ItoHI(coord.y);
            }
            Ligne ligne = new Ligne((Plan)this, viewSimple, viewSimple.HItoI(d), viewSimple.HItoI(d2), this.couleursContours[n]);
            this.pcat.setObjet(ligne);
            ligneArray[n2] = ligne;
            ++n2;
            int n5 = 1;
            while (n4 + n5 < pointDArray.length && (pointD = pointDArray[n4 + n5]) != null) {
                coord.x = (double)n3 * pointD.x + (double)this.xShift;
                coord.y = (double)n3 * pointD.y + (double)this.yShift;
                d = coord.x;
                d2 = coord.y;
                if (this.p.projd != projection) {
                    coord.x = viewSimple.HItoI(coord.x);
                    coord.y = viewSimple.HItoI(coord.y);
                    this.p.projd.getCoord(coord);
                    projection.getXY(coord);
                    d = viewSimple.ItoHI(coord.x);
                    d2 = viewSimple.ItoHI(coord.y);
                }
                Ligne ligne2 = new Ligne((Plan)this, viewSimple, viewSimple.HItoI(d), viewSimple.HItoI(d2), ligne, this.couleursContours[n]);
                this.pcat.setObjet(ligne2);
                ligneArray[n2] = ligne2;
                ++n2;
                ligne = ligne2;
                ++n5;
            }
            n4 += n5;
        }
        object = new Ligne[n2];
        System.arraycopy(ligneArray, 0, object, 0, n2);
        this.lines[n] = object;
        this.xShift = 0;
        this.yShift = 0;
    }

    protected void drawAllContours() {
        if (this.couleursContours == null) {
            this.couleursContours = new Color[this.levels.length];
            Color[] colorArray = Couleur.getBrighterColors(this.c, 4);
            for (int i = 0; i < this.couleursContours.length; ++i) {
                this.couleursContours[i] = colorArray[i % colorArray.length];
            }
        }
        this.lines = new Ligne[this.levels.length][];
        for (int i = 0; i < this.levels.length; ++i) {
            this.drawContour(i);
        }
        this.calque.repaint();
    }

    @Override
    protected boolean isSync() {
        return this.flagOk && (this.error != null || !this.mustAdjustContour);
    }

    @Override
    protected boolean Free() {
        this.pixels = null;
        this.orgPixels = null;
        this.couleursContours = null;
        this.adjustTab = null;
        this.levels = null;
        this.orgLevels = null;
        this.contours = null;
        this.lines = null;
        this.zoomv = null;
        this.p = null;
        this.pimg = null;
        this.cAlgo = null;
        return super.Free();
    }

    protected void useSmoothing(boolean bl) {
        this.useSmoothing = bl;
    }

    protected boolean isViewable(int n) {
        if (this.lines == null) {
            return true;
        }
        Ligne[] ligneArray = this.lines[n];
        if (ligneArray.length != 0) {
            Ligne ligne = ligneArray[0];
            return !ligne.hidden;
        }
        return true;
    }

    protected void setViewable(int n, boolean bl) {
        if (this.lines == null) {
            return;
        }
        Ligne[] ligneArray = this.lines[n];
        for (int i = 0; i < ligneArray.length; ++i) {
            Ligne ligne = ligneArray[i];
            ligne.hidden = !bl;
        }
    }

    @Override
    protected void setPropertie(String string, String string2, String string3) throws Exception {
        if (string.equalsIgnoreCase("Color")) {
            Color color = Action.getColor(string3);
            if (color == null) {
                throw new Exception("Syntax error in color function (ex: rgb(30,60,255) )");
            }
            this.updateColorIfNeeded(color);
            Properties.majProp(this);
            this.aladin.calque.repaintAll();
        } else {
            super.setPropertie(string, string2, string3);
        }
    }

    protected void updateColorIfNeeded(Color color) {
        if (color != null && !color.equals(this.c)) {
            this.c = color;
            Color[] colorArray = Couleur.getBrighterColors(this.c, 4);
            for (int i = 0; i < this.nbLevels; ++i) {
                this.adjustColor(new Color(colorArray[i % colorArray.length].getRGB()), i);
            }
        }
    }

    protected void adjustColor(Color color, int n) {
        if (!this.couleursContours[n].equals(color)) {
            this.couleursContours[n] = new Color(color.getRGB());
            Ligne[] ligneArray = this.lines[n];
            for (int i = 0; i < ligneArray.length; ++i) {
                Ligne ligne = ligneArray[i];
                ligne.couleur = new Color(color.getRGB());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustContour(double[] dArray) {
        this.adjustTab = dArray;
        this.mustAdjustContour = true;
        PlanContour planContour = this;
        synchronized (planContour) {
            this.runme = new Thread((Runnable)this, "AladinContourAdjust"){};
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    protected void updatePourcent(double d) {
        if (this.mustAdjustContour) {
            return;
        }
        this.setPourcent((1.0 - this.partDessin) * 100.0 * (((double)this.nbLevelsComputed + d) / (double)this.orgLevels.length));
    }

    protected static Color getNextColor(Calque calque) {
        int n;
        for (n = 0; n < couleursBase.length; ++n) {
            int n2;
            for (n2 = 0; n2 < calque.plan.length && (calque.plan[n2].type == 0 || couleursBase[n] != calque.plan[n2].c); ++n2) {
            }
            if (n2 == calque.plan.length) break;
        }
        if (n == couleursBase.length) {
            if (++icouleursBase == couleursBase.length) {
                icouleursBase = 0;
            }
            n = icouleursBase;
        }
        return couleursBase[n];
    }

    protected int[] getIntLevels() {
        int[] nArray = new int[this.orgLevels.length];
        for (int i = 0; i < this.orgLevels.length; ++i) {
            nArray[i] = this.adjustTab != null ? (int)this.adjustTab[i] : (int)this.orgLevels[i];
        }
        return nArray;
    }

    private synchronized void doAdjustContour(double d, int n) {
        Aladin.trace(3, "Level adjusted for index " + n);
        this.mustAdjustContour = true;
        this.orgLevels[n] = d;
        this.levels[n] = d;
        this.adjustLevels();
        PointD[] pointDArray = this.getContour(this.levels[n]);
        this.contours[n] = pointDArray;
        Ligne[] ligneArray = this.lines[n];
        boolean bl = true;
        for (int i = 0; i < ligneArray.length; ++i) {
            Ligne ligne = ligneArray[i];
            if (i == 0) {
                bl = !ligne.hidden;
            }
            this.pcat.delObjet(ligne);
        }
        this.drawContour(n);
        this.setViewable(n, bl);
        this.calque.repaintAll();
    }

    private void initCouleurs(Color[] colorArray) {
        if (colorArray != null) {
            this.couleursContours = new Color[this.orgLevels.length];
            for (int i = 0; i < this.couleursContours.length; ++i) {
                this.couleursContours[i] = colorArray[i];
            }
        } else {
            this.couleursContours = null;
        }
    }

    private void makeSmoothing(short[] sArray, short[] sArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n7 * n7;
        int[] nArray = new int[n8];
        int[] nArray2 = new int[n8];
        for (int i = n2 - 1; i >= 0; --i) {
            int n9 = i * n;
            for (int j = n - 1; j >= 0; --j) {
                int n10;
                if ((n9 + j) % 4000 == 0) {
                    if (Aladin.isSlow) {
                        Util.pause(10);
                    }
                }
                int n11 = n7 * i * n3 + n7 * j + n5 + n6 * n3;
                for (n10 = n7 - 1; n10 >= 0; --n10) {
                    nArray[n10] = n11 + n10;
                    nArray2[n10] = sArray[nArray[n10]];
                    for (int k = n7 - 1; k >= 1; --k) {
                        int n12 = k * n7;
                        nArray[n10 + n12] = nArray[n10] + k * n3;
                        nArray2[n10 + n12] = sArray[nArray[n10 + n12]];
                    }
                }
                int n13 = 0;
                for (n10 = n8 - 1; n10 >= 0; --n10) {
                    n13 += nArray2[n10];
                }
                sArray2[n9 + j] = (short)n13;
            }
        }
    }

    private short[] moyenne(short[] sArray, int n, int n2) {
        short[] sArray2 = new short[(n - 1) * (n2 - 1)];
        for (int i = n2 - 2; i >= 0; --i) {
            int n3 = i * n;
            for (int j = n - 2; j >= 0; --j) {
                if (Aladin.isSlow && (n3 + j) % 4000 == 0) {
                    Util.pause(10);
                }
                short s = sArray[n3 + j];
                short s2 = sArray[n3 + j + 1];
                short s3 = sArray[n3 + j + n];
                short s4 = sArray[n3 + j + n + 1];
                sArray2[i * (n - 1) + j] = (short)((s + s2 + s3 + s4) / 4);
            }
        }
        return sArray2;
    }
}

