/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Cercle;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.FootprintBean;
import cds.aladin.Forme;
import cds.aladin.Ligne;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Pickle;
import cds.aladin.Plan;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.Repere;
import cds.aladin.SubFootprintBean;
import cds.aladin.Tag;
import cds.aladin.Tok;
import cds.aladin.View;
import cds.astro.AstroMath;
import cds.astro.Astrocoo;
import cds.astro.Coo;
import cds.astro.ICRS;
import cds.astro.Proj3;
import cds.tools.Util;
import cds.tools.VOApp;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public final class PlanField
extends Plan {
    private static final int CFH12K = 0;
    private static final int EPICMOS = 1;
    private static final int EPICPN = 2;
    private static final int MEGACAM = 3;
    private static final int MEGAPRIME = 4;
    private static final int WIRCAM = 5;
    private static final int ESPADONS = 6;
    private static String[] INSTR = new String[]{"CFH12K", "EPICMOS", "EPICpn", "MEGACAM", "MEGAPRIME", "WIRCAM", "ESPADONS"};
    private int instr;
    private boolean flagRoll = true;
    private boolean flagCenterRoll = false;
    private boolean flagMove = true;
    private double roll;
    protected boolean needTarget;
    private boolean almaFP = false;
    private FootprintBean fpBean;
    private static final double EPICMOS_RA = 0.18166666666666667;
    private static final double EPICMOS_DE = 0.18166666666666667;
    private static final double[] EPICMOS_DRA = new double[]{-1.5, -1.5, -0.5, -0.5, -0.5, 0.5, 0.5};
    private static final double[] EPICMOS_DDE = new double[]{-1.0, 0.0, -1.5, -0.5, 0.5, -1.0, 0.0};
    private static final double EPICPN_RA = 0.07333333333333333;
    private static final double EPICPN_DE = 0.22666666666666666;
    private static final double[] EPICPN_DRA = new double[]{-3.0, -2.0, -1.0, 0.0, 1.0, 2.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0};
    private static final double[] EPICPN_DDE = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final double CFH12K_RA = 0.11719111111111111;
    private static final double CFH12K_DE = 0.23438222222222221;
    private static final double[] CFH12K_DRA = new double[]{-3.0, -2.0, -1.0, 0.0, 1.0, 2.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0};
    private static final double[] CFH12K_DDE = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final double[] CFH12K_GAPRA = new double[]{-15.0, -9.0, -3.0, 3.0, 9.0, 15.0, -15.0, -9.0, -3.0, 3.0, 9.0, 15.0};
    private static final double[] CFH12K_GAPDE = new double[]{-3.0, -3.0, -3.0, -3.0, -3.0, -3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0};
    private static final double CFH12K_ORA = -0.004166666666666667;
    private static final double CFH12K_ODE = 0.008333333333333333;
    private static final String[] CFH12K_CCD = new String[]{"06", "07", "08", "09", "10", "11", "00", "01", "02", "03", "04", "05"};
    private static final double MEGACAM_RA = 0.10638222222222223;
    private static final double MEGACAM_DE = 0.23956777777777777;
    private static final double[] MEGACAM_DRA = new double[]{-4.5, -3.5, -2.5, -1.5, -0.5, 0.5, 1.5, 2.5, 3.5, -4.5, -3.5, -2.5, -1.5, -0.5, 0.5, 1.5, 2.5, 3.5, -4.5, -3.5, -2.5, -1.5, -0.5, 0.5, 1.5, 2.5, 3.5, -4.5, -3.5, -2.5, -1.5, -0.5, 0.5, 1.5, 2.5, 3.5};
    private static final double[] MEGACAM_DDE = new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private static final double[] MEGACAM_GAPRA = new double[]{-56.0, -42.0, -28.0, -14.0, 0.0, 14.0, 28.0, 42.0, 56.0, -56.0, -42.0, -28.0, -14.0, 0.0, 14.0, 28.0, 42.0, 56.0, -56.0, -42.0, -28.0, -14.0, 0.0, 14.0, 28.0, 42.0, 56.0, -56.0, -42.0, -28.0, -14.0, 0.0, 14.0, 28.0, 42.0, 56.0};
    private static final double[] MEGACAM_GAPDE = new double[]{-88.5, -88.5, -88.5, -88.5, -88.5, -88.5, -88.5, -88.5, -88.5, -5.5, -5.5, -5.5, -5.5, -5.5, -5.5, -5.5, -5.5, -5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 88.5, 88.5, 88.5, 88.5, 88.5, 88.5, 88.5, 88.5, 88.5};
    private static final double MEGACAM_ORA = 0.004166666666666667;
    private static final double MEGACAM_ODE = -0.005694444444444445;
    private static final String[] MEGACAM_CCD = new String[]{"35", "34", "33", "32", "31", "30", "29", "28", "27", "26", "25", "24", "23", "22", "21", "20", "19", "18", "17", "16", "15", "14", "13", "12", "11", "10", "09", "08", "07", "06", "05", "04", "03", "02", "01", "00"};
    private static final double MEGAGUI_RA = 0.3425;
    private static final double MEGAGUI_DE = 0.24736111111111111;
    private static final double[] MEGAGUI_DRA = new double[]{-0.5, -0.5};
    private static final double[] MEGAGUI_DDE = new double[]{-1.0, 0.0};
    private static final double[] MEGAGUI_GAPRA = new double[]{0.0, 0.0};
    private static final double[] MEGAGUI_GAPDE = new double[]{-1739.9, 1739.9};
    private static final String[] MEGAGUI_BOX = new String[]{"S", "N"};
    private static final double WIRCAM_RA = 0.17066666666666666;
    private static final double WIRCAM_DE = 0.17066666666666666;
    private static final double[] WIRCAM_DRA = new double[]{-1.0, 0.0, -1.0, 0.0};
    private static final double[] WIRCAM_DDE = new double[]{-1.0, -1.0, 0.0, 0.0};
    private static final double[] WIRCAM_GAPRA = new double[]{-45.0, 0.0, -45.0, 0.0};
    private static final double[] WIRCAM_GAPDE = new double[]{-45.0, -45.0, 0.0, 0.0};
    private static final double WIRCAM_ORA = 0.008333333333333333;
    private static final double WIRCAM_ODE = 0.008333333333333333;
    private static final String[] WIRCAM_CCD = new String[]{"52", "54", "77", "60"};
    private static final double WIRCAM_RD = 0.0;
    private static final double ESPADONS_RA = 0.03333333333333333;
    private static final double ESPADONS_DE = 0.03333333333333333;
    private static final double[] ESPADONS_DRA = new double[]{-0.5};
    private static final double[] ESPADONS_DDE = new double[]{-0.5};
    private static final double[] ESPADONS_GAPRA = new double[]{0.0};
    private static final double[] ESPADONS_GAPDE = new double[]{0.0};
    private static final double ESPADONS_ORA = 0.0;
    private static final double ESPADONS_ODE = 0.0;
    private static final String[] ESPADONS_CCD = new String[]{""};
    private static final double ESPADONS_RD = 0.0;
    private boolean showSubFPInProperties = true;
    protected VOApp observer = null;
    private Astrocoo afs = new Astrocoo(new ICRS());
    protected Vector subFoV = null;
    protected JCheckBox[] cbSubFoV;

    public static final double tand(double d) {
        return Math.tan(d * (Math.PI / 180));
    }

    protected PlanField(Aladin aladin, String string, double d, String string2, String string3) {
        this.aladin = aladin;
        this.type = 10;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setLabel(string2);
        this.setOpacityLevel(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        aladin.calque.selectPlan(this);
        this.objet = null;
        this.setInstr(string3);
        if (string.length() == 0 || View.notCoord(string)) {
            this.needTarget = true;
            this.setActivated(false);
            this.roll = d;
            if (string.length() > 0) {
                this.objet = string;
            }
        } else {
            Coord coord;
            try {
                coord = new Coord(string);
            }
            catch (Exception exception) {
                Aladin.error = "Unknown object";
                this.error = "Unknown object";
                return;
            }
            this.needTarget = false;
            this.setActivated(true);
            this.make(coord.al, coord.del, d);
        }
    }

    protected PlanField(Aladin aladin, String string, Coord coord, double d, boolean bl, boolean bl2) {
        this.aladin = aladin;
        this.type = 10;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setLabel(string);
        this.setOpacityLevel(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        this.selected = true;
        this.flagOk = true;
        this.askActive = true;
        this.flagRoll = bl;
        this.flagMove = bl2;
        this.instr = -1;
        this.roll = d;
        this.co = coord != null ? coord : new Coord(0.0, 0.0);
        Repere repere = new Repere((Plan)this, this.co);
        repere.setType(4);
        Repere repere2 = new Repere((Plan)this, this.co);
        repere2.setRotCenterType(repere);
        this.pcat.setObjetFast(repere2);
        this.pcat.setObjetFast(repere);
        this.needTarget = false;
        this.make(this.co.al, this.co.del, this.roll);
    }

    protected PlanField(Aladin aladin, FootprintBean footprintBean, String string) {
        this.aladin = aladin;
        this.type = 10;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setLabel(string);
        this.setOpacityLevel(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        aladin.calque.selectPlan(this);
        this.objet = null;
        this.instr = -1;
        this.fpBean = footprintBean;
        this.setObjects(footprintBean);
        this.needTarget = false;
    }

    protected PlanField(Aladin aladin, String string, FootprintBean footprintBean, String string2, double d) {
        this.aladin = aladin;
        this.type = 10;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setLabel(string2);
        this.setOpacityLevel(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        aladin.calque.selectPlan(this);
        this.objet = null;
        this.instr = -1;
        this.fpBean = footprintBean;
        this.setObjects(footprintBean);
        if (string == null || string.length() == 0 || View.notCoord(string)) {
            this.needTarget = true;
            this.setActivated(false);
            this.roll = d;
            if (string.length() > 0) {
                this.objet = string;
            }
        } else {
            Coord coord;
            try {
                coord = new Coord(string);
            }
            catch (Exception exception) {
                Aladin.error = "Unknown object";
                this.error = "Unknown object";
                return;
            }
            this.needTarget = false;
            this.setActivated(true);
            this.make(coord.al, coord.del, d);
        }
    }

    @Override
    protected void setLabel(String string) {
        if (string == null) {
            string = "FoV";
        }
        super.setLabel(string);
    }

    protected boolean resolveTarget(double d, double d2) {
        this.needTarget = false;
        this.make(d, d2, this.roll);
        this.planReady(true);
        return true;
    }

    @Override
    protected boolean setActivated() {
        boolean bl = super.setActivated();
        if (!bl) {
            this.aladin.view.unSelectObjetPlanField(this);
        }
        return bl;
    }

    protected void make(double d, double d2, double d3) {
        this.make(d, d2, d, d2, d3);
    }

    protected void make(double d, double d2, double d3, double d4, double d5) {
        this.projd = new Projection(null, 3, d, d2, this.instr == 3 || this.instr == 4 ? 100.0 : 45.0, 250.0, 250.0, 500.0, 0.0, false, 2, Calib.FK5);
        switch (this.instr) {
            case 3: {
                this.setRollable(false);
                this.makeCCDs(0.004166666666666667, -0.005694444444444445, 0.10638222222222223, 0.23956777777777777, MEGACAM_DRA, MEGACAM_DDE, MEGACAM_GAPRA, MEGACAM_GAPDE, MEGACAM_CCD);
                break;
            }
            case 4: {
                this.setRollable(false);
                this.makeCCDs(0.004166666666666667, -0.005694444444444445, 0.10638222222222223, 0.23956777777777777, MEGACAM_DRA, MEGACAM_DDE, MEGACAM_GAPRA, MEGACAM_GAPDE, MEGACAM_CCD);
                this.makeCCDs(0.004166666666666667, -0.005694444444444445, 0.3425, 0.24736111111111111, MEGAGUI_DRA, MEGAGUI_DDE, MEGAGUI_GAPRA, MEGAGUI_GAPDE, MEGAGUI_BOX);
                break;
            }
            case 0: {
                this.setRollable(false);
                this.makeCCDs(-0.004166666666666667, 0.008333333333333333, 0.11719111111111111, 0.23438222222222221, CFH12K_DRA, CFH12K_DDE, CFH12K_GAPRA, CFH12K_GAPDE, CFH12K_CCD);
                break;
            }
            case 5: {
                this.setRollable(false);
                this.makeCCDs(0.008333333333333333, 0.008333333333333333, 0.17066666666666666, 0.17066666666666666, WIRCAM_DRA, WIRCAM_DDE, WIRCAM_GAPRA, WIRCAM_GAPDE, WIRCAM_CCD);
                break;
            }
            case 6: {
                this.setRollable(false);
                this.makeCCDs(0.0, 0.0, 0.03333333333333333, 0.03333333333333333, ESPADONS_DRA, ESPADONS_DDE, ESPADONS_GAPRA, ESPADONS_GAPDE, ESPADONS_CCD);
                break;
            }
            case 1: {
                this.setRollable(true);
                this.makeCCDs(0.0, 0.0, 0.18166666666666667, 0.18166666666666667, EPICMOS_DRA, EPICMOS_DDE, null, null, null);
                break;
            }
            case 2: {
                this.setRollable(true);
                this.makeCCDs(0.0, 0.0, 0.07333333333333333, 0.22666666666666666, EPICPN_DRA, EPICPN_DDE, null, null, null);
            }
        }
        this.setTarget(d, d2, d3, d4, d5);
    }

    private void makeCCDs(double d, double d2, double d3, double d4, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, String[] stringArray) {
        Position position;
        Object object;
        int n = 0;
        if (this.pcat.o != null) {
            object = this.pcat.o;
            this.pcat.nb_o = ((Obj[])object).length + dArray.length * 5 + (stringArray == null ? 0 : stringArray.length);
            this.pcat.o = new Obj[this.pcat.nb_o];
            System.arraycopy(object, 0, this.pcat.o, 0, ((Object)object).length);
            n = ((Object)object).length;
        } else {
            this.pcat.nb_o = dArray.length * 5 + 2 + (stringArray == null ? 0 : stringArray.length);
            this.pcat.o = new Obj[this.pcat.nb_o];
            n = 2;
            object = new Repere(this);
            ((Repere)object).setType(4);
            this.pcat.o[1] = object;
            position = new Repere(this);
            position.setRotCenterType((Position)object);
            this.pcat.o[0] = position;
        }
        for (int i = 0; i < dArray.length; ++i) {
            position = null;
            int n2 = 0;
            while (n2 < 5) {
                position = new Ligne(this);
                this.pcat.o[n] = position;
                double d5 = dArray3 == null ? 0.0 : dArray3[i] / 3600.0;
                double d6 = dArray4 == null ? 0.0 : dArray4[i] / 3600.0;
                ((Ligne)position).x = Util.tand((dArray[i] + (n2 == 1 || n2 == 2 ? 1.0 : 0.0)) * d3 + d5 - d);
                ((Ligne)position).y = Util.tand((dArray2[i] + (n2 == 2 || n2 == 3 ? 1.0 : 0.0)) * d4 + d6 - d2);
                if (n2 > 0) {
                    ((Ligne)position).debligne = (Ligne)this.pcat.o[n - 1];
                }
                if (n2 < 4) {
                    ((Ligne)position).finligne = (Ligne)this.pcat.o[n + 1];
                }
                ++n2;
                ++n;
            }
            if (stringArray == null) continue;
            Tag tag = new Tag(this, null, 0.0, 0.0, stringArray[i]);
            tag.x = ((Ligne)position).x + Util.tand(d3 / 3.0 - d);
            tag.y = ((Ligne)position).y + Util.tand(0.016666666666666666 - d2);
            this.pcat.o[n++] = tag;
        }
    }

    protected void setParameters(double d, double d2, double d3, double d4, double d5) {
        Position position = this.getProjCenterObjet();
        if (!this.flagMove || Double.isNaN(d) || Double.isNaN(d2)) {
            d = position.raj;
            d2 = position.dej;
        }
        if (!this.flagRoll || Double.isNaN(d3) || Double.isNaN(d4)) {
            d5 = this.roll;
            d3 = d;
            d4 = d2;
        } else {
            d5 = this.angle(d5);
        }
        this.setTarget(d, d2, d3, d4, d5);
    }

    private synchronized void setTarget(double d, double d2, double d3, double d4, double d5) {
        double d6 = 1.0;
        double d7 = 0.0;
        if (this.co == null) {
            this.co = new Coord();
        }
        this.co.al = d;
        this.co.del = d2;
        this.objet = this.co.getSexa();
        Proj3 proj3 = new Proj3(1, d, d2);
        Position position = this.getRotCenterObjet();
        proj3.set(new Coo(d3, d4));
        double d8 = proj3.getX();
        double d9 = proj3.getY();
        position.x = d8;
        position.y = d9;
        position.raj = d3;
        position.dej = d4;
        this.roll = d5;
        if (d5 != 0.0) {
            d6 = AstroMath.cosd(d5);
            d7 = AstroMath.sind(d5);
        }
        for (int i = 1; i < this.pcat.nb_o; ++i) {
            double d10;
            double d11;
            double d12;
            Position position2 = (Position)this.pcat.o[i];
            if (position2 instanceof Forme) {
                Forme forme = (Forme)position2;
                for (int j = 0; j < forme.o.length; ++j) {
                    position2 = forme.o[j];
                    d12 = position2.x;
                    d11 = position2.y;
                    if (d5 != 0.0) {
                        d10 = (d12 -= d8) * d6 + (d11 -= d9) * d7;
                        double d13 = -d12 * d7 + d11 * d6;
                        d12 = d10 + d8;
                        d11 = d13 + d9;
                    }
                    proj3.set(d12, d11);
                    position2.raj = proj3.getLon();
                    position2.dej = proj3.getLat();
                }
                continue;
            }
            d12 = position2.x;
            d11 = position2.y;
            if (d5 != 0.0) {
                double d14 = (d12 -= d8) * d6 + (d11 -= d9) * d7;
                d10 = -d12 * d7 + d11 * d6;
                d12 = d14 + d8;
                d11 = d10 + d9;
            }
            proj3.set(d12, d11);
            position2.raj = proj3.getLon();
            position2.dej = proj3.getLat();
        }
        Properties.majProp(this);
    }

    protected void reset(int n) {
        Position position = this.getProjCenterObjet();
        Position position2 = this.getRotCenterObjet();
        if (position != null) {
            this.setTarget(position.raj, position.dej, position2.raj, position2.dej, this.roll);
            if ((n & 1) != 0) {
                this.sendTargetObserver(false);
            }
            if ((n & 2) != 0) {
                this.sendRollObserver(false);
            }
            if ((n & 4) != 0) {
                this.sendRotCenterObserver(false);
            }
        }
        this.aladin.view.newView();
    }

    protected void changeRoll(double d) {
        Position position = this.getProjCenterObjet();
        Position position2 = this.getRotCenterObjet();
        this.setTarget(position.raj, position.dej, position2.raj, position2.dej, d);
    }

    protected void changeTarget(double d, double d2) {
        Position position = this.getProjCenterObjet();
        Position position2 = this.getRotCenterObjet();
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            d = position.raj;
            d2 = position.dej;
        }
        double d3 = d - position.raj;
        double d4 = d2 - position.dej;
        this.setTarget(d, d2, position2.raj + d3, position2.dej + d4, this.roll);
    }

    protected void changeRotCenter(double d, double d2) {
        Position position = this.getProjCenterObjet();
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            d = position.raj;
            d2 = position.dej;
        }
        this.setTarget(position.raj, position.dej, d, d2, this.roll);
    }

    protected void addObserver(VOApp vOApp) {
        this.observer = vOApp;
    }

    protected void sendTargetObserver(boolean bl) {
        if (this.observer == null) {
            return;
        }
        this.observer.execCommand("set " + Tok.quote(this.label) + " Target=" + this.getTarget() + (bl ? " ..." : ""));
    }

    protected void sendRotCenterObserver(boolean bl) {
        if (this.observer == null) {
            return;
        }
        this.observer.execCommand("set " + Tok.quote(this.label) + " RotCenter=" + this.getRotCenter() + (bl ? " ..." : ""));
    }

    protected void sendRollObserver(boolean bl) {
        if (this.observer == null) {
            return;
        }
        this.observer.execCommand("set " + Tok.quote(this.label) + " Roll=" + this.roll + (bl ? " ..." : ""));
    }

    protected void sendSubFovObserver(String string, boolean bl) {
        if (this.observer == null) {
            return;
        }
        this.observer.execCommand("set " + Tok.quote(this.label + "/" + string) + " Status=" + (bl ? "shown" : "hidden"));
    }

    private void setObjects(FootprintBean footprintBean) {
        SubFootprintBean[] subFootprintBeanArray = footprintBean.getBeans();
        int n = 0;
        int n2 = subFootprintBeanArray.length;
        Obj[][] objArrayArray = new Obj[n2][];
        for (int i = 0; i < n2; ++i) {
            objArrayArray[i] = subFootprintBeanArray[i].buildObjets(this);
            n += objArrayArray[i].length;
        }
        this.pcat.nb_o = n + 2;
        this.pcat.o = new Obj[this.pcat.nb_o];
        Repere repere = new Repere(this);
        repere.setType(4);
        this.pcat.o[1] = repere;
        Repere repere2 = new Repere(this);
        repere2.setRotCenterType(repere);
        this.pcat.o[0] = repere2;
        int n3 = 2;
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(objArrayArray[i], 0, this.pcat.o, n3, objArrayArray[i].length);
            this.addSubFoV(subFootprintBeanArray[i].getName(), subFootprintBeanArray[i].getDesc(), n3, n3 + objArrayArray[i].length - 1, true, subFootprintBeanArray[i].getColor());
            n3 += objArrayArray[i].length;
        }
    }

    private void setInstr(String string) {
        for (int i = 0; i < INSTR.length; ++i) {
            if (!INSTR[i].equalsIgnoreCase(string)) continue;
            this.instr = i;
            return;
        }
        this.instr = -1;
    }

    protected void memTarget() {
    }

    @Override
    protected boolean setActivated(boolean bl) {
        this.askActive = bl;
        boolean bl2 = this.setActivated();
        if (bl2 == bl && this.observer != null) {
            this.observer.execCommand("set " + Tok.quote(this.label) + " Status=" + (bl ? "shown" : "hidden"));
        }
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void setPropertie(String string, String string2, String string3) throws Exception {
        if (string.equalsIgnoreCase("Target")) {
            if (!this.isMovable()) {
                throw new Exception("Not movable aperture");
            }
            Coord coord = new Coord(string3);
            this.changeTarget(coord.al, coord.del);
        } else if (string.equalsIgnoreCase("Roll")) {
            if (!this.isRollable()) {
                throw new Exception("Not rollable aperture");
            }
            double d = Double.valueOf(string3);
            this.changeRoll(d);
        } else if (string.equalsIgnoreCase("RotCenter")) {
            if (!this.isRollable()) {
                throw new Exception("Not rollable aperture");
            }
            if (string3.trim().length() == 0) {
                Position position = this.getProjCenterObjet();
                this.changeRotCenter(position.raj, position.dej);
            } else {
                Coord coord = new Coord(string3);
                this.changeRotCenter(coord.al, coord.del);
            }
        } else if (string.equalsIgnoreCase("Rollable")) {
            if (string3.equalsIgnoreCase("True")) {
                this.setRollable(true);
            } else {
                if (!string3.equalsIgnoreCase("False")) throw new Exception("Rollable propertie should be \"true\" or \"false\" !");
                this.setRollable(false);
            }
        } else if (string.equalsIgnoreCase("Movable")) {
            if (string3.equalsIgnoreCase("True")) {
                this.setMovable(true);
            } else {
                if (!string3.equalsIgnoreCase("False")) throw new Exception("Movable propertie should be \"true\" or \"false\" !");
                this.setMovable(false);
            }
        } else if (string.equalsIgnoreCase("Status") && string2 != null) {
            boolean bl;
            int[] nArray = this.findSubFoVs(string2);
            if (nArray.length == 0) {
                throw new Exception("Unknown " + this.label + " FoV [" + string2 + "]");
            }
            if (string3.indexOf("shown") >= 0) {
                bl = true;
            } else {
                if (string3.indexOf("hidden") < 0) throw new Exception("Unknown FoV status [" + string3 + "]");
                bl = false;
            }
            for (int i = 0; i < nArray.length; ++i) {
                this.setVisibleSubFoV(nArray[i], bl);
            }
        } else {
            super.setPropertie(string, null, string3);
        }
        if (this.observer != null && !string.equals("Status")) {
            this.observer.execCommand("set " + Tok.quote(this.label) + " " + string + "=" + string3);
        }
        Properties.majProp(this);
        this.aladin.view.resetClip();
        this.aladin.view.newView(1);
    }

    @Override
    protected String getInfo() {
        return this.label + super.addDebugInfo();
    }

    protected Coord getCenter() {
        Position position = this.getProjCenterObjet();
        return new Coord(position.raj, position.dej);
    }

    protected Position getProjCenterObjet() {
        try {
            return (Position)this.pcat.o[1];
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Position getRotCenterObjet() {
        try {
            return (Position)this.pcat.o[0];
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void resetRotCenterObjet() {
        try {
            this.pcat.o[0].raj = this.pcat.o[1].raj;
            this.pcat.o[0].dej = this.pcat.o[1].dej;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getProjCenter() {
        Position position = this.getProjCenterObjet();
        if (position == null) {
            return "";
        }
        return this.aladin.localisation.J2000ToString(position.raj, position.dej, 11);
    }

    protected String getRotCenter() {
        Position position = this.getRotCenterObjet();
        if (position == null) {
            return "";
        }
        return this.aladin.localisation.J2000ToString(position.raj, position.dej, 11);
    }

    @Override
    protected String getTarget() {
        Position position = this.getProjCenterObjet();
        if (position == null) {
            return null;
        }
        this.afs.setPrecision(9);
        this.afs.set(position.raj, position.dej);
        return this.afs.toString("2:");
    }

    protected String getRoll() {
        return (double)((int)Math.round(this.roll * 10.0)) / 10.0 + "";
    }

    protected boolean isNewRoll(double d) {
        return this.roll != this.angle(d);
    }

    private double angle(double d) {
        if ((d %= 360.0) < 0.0) {
            d += 360.0;
        }
        return d;
    }

    protected void deltaRoll(double d) {
        this.setRoll(this.roll + d);
    }

    private void setRoll(double d) {
        if (!this.flagRoll) {
            return;
        }
        this.roll = this.angle(d);
    }

    protected boolean isRollable() {
        return this.flagRoll;
    }

    protected void setRollable(boolean bl) {
        this.flagRoll = bl;
    }

    protected boolean isCenterRollable() {
        return this.flagCenterRoll;
    }

    protected void setCenterRollable(boolean bl) {
        this.flagCenterRoll = bl;
    }

    protected void setMovable(boolean bl) {
        this.flagMove = bl;
    }

    @Override
    protected boolean isMovable() {
        return this.flagMove;
    }

    protected boolean switchCheckbox(JCheckBox jCheckBox) {
        if (this.cbSubFoV == null) {
            return false;
        }
        for (int i = 0; i < this.cbSubFoV.length; ++i) {
            if (jCheckBox != this.cbSubFoV[i]) continue;
            this.setVisibleSubFoV(i, jCheckBox.isSelected());
            return true;
        }
        return false;
    }

    protected JPanel getPanelSubFov(ActionListener actionListener) {
        if (this.subFoV == null || this.subFoV.size() == 0 || this.isAlmaFP()) {
            return null;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        int n = this.subFoV.size();
        this.cbSubFoV = new JCheckBox[n];
        for (int i = 0; i < n; ++i) {
            PlanFieldSub planFieldSub = this.getSubFoV(i);
            this.cbSubFoV[i] = new JCheckBox(i + 1 + ".- " + planFieldSub.ID + " " + planFieldSub.desc, planFieldSub.visible);
            this.cbSubFoV[i].addActionListener(actionListener);
            jPanel.add(this.cbSubFoV[i]);
        }
        return jPanel;
    }

    protected void exportAlmaPointings() {
        ArrayList<Forme> arrayList = new ArrayList<Forme>();
        for (Obj obj : this.pcat.o) {
            if (!(obj instanceof Cercle) || obj instanceof Pickle) continue;
            arrayList.add((Forme)obj);
        }
        String string = Util.createVOTable(arrayList);
        this.aladin.calque.newPlanCatalog(new MyInputStream(new BufferedInputStream(new ByteArrayInputStream(string.getBytes()))), "Pointings");
    }

    protected boolean isAlmaFP() {
        return this.almaFP;
    }

    protected void setIsAlmaFP(boolean bl) {
        this.almaFP = bl;
    }

    protected String getStatusSubFov() {
        if (this.subFoV == null || this.subFoV.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = this.subFoV.size();
        for (int i = 0; i < n; ++i) {
            PlanFieldSub planFieldSub = this.getSubFoV(i);
            stringBuffer.append("FoV      " + Tok.quote(planFieldSub.ID) + " Status=" + (planFieldSub.visible ? "shown" : "hidden") + "\n");
        }
        return stringBuffer.toString();
    }

    protected void addSubFoV(String string, String string2, int n, int n2, boolean bl, Color color) {
        PlanFieldSub planFieldSub = new PlanFieldSub(string, string2, n, n2, bl, color);
        if (this.subFoV == null) {
            this.subFoV = new Vector(10);
        }
        this.subFoV.addElement(planFieldSub);
    }

    protected int[] findSubFoVs(String string) {
        int n = this.subFoV.size();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!Util.matchMask(string, ((PlanFieldSub)this.subFoV.elementAt((int)i)).ID)) continue;
            nArray[n2++] = i;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    protected int findSubFoV(String string) {
        if (this.subFoV == null) {
            return -1;
        }
        for (int i = this.subFoV.size() - 1; i >= 0; --i) {
            if (!((PlanFieldSub)this.subFoV.elementAt((int)i)).ID.equals(string)) continue;
            return i;
        }
        return -1;
    }

    protected int findSubFoV(int n) {
        if (this.subFoV == null) {
            return -1;
        }
        for (int i = this.subFoV.size() - 1; i >= 0; --i) {
            PlanFieldSub planFieldSub = (PlanFieldSub)this.subFoV.elementAt(i);
            if (planFieldSub.first > n || n > planFieldSub.last) continue;
            return i;
        }
        return -1;
    }

    protected PlanFieldSub getSubFoV(int n) {
        return (PlanFieldSub)this.subFoV.elementAt(n);
    }

    protected void setVisibleSubFoV(int n, boolean bl) {
        PlanFieldSub planFieldSub = this.getSubFoV(n);
        if (planFieldSub == null || planFieldSub.visible == bl) {
            return;
        }
        planFieldSub.visible = bl;
        for (int i = planFieldSub.first; i <= planFieldSub.last; ++i) {
            this.pcat.o[i].setVisibleGenerique(bl);
        }
        this.aladin.view.repaintAll();
        this.sendSubFovObserver(planFieldSub.ID, bl);
    }

    protected Color getColor(Obj obj) {
        int n = this.pcat.getIndex(obj);
        if (n < 0) {
            return null;
        }
        int n2 = this.findSubFoV(n);
        if (n2 < 0) {
            return null;
        }
        Color color = this.getSubFoV((int)n2).color;
        return color;
    }

    protected String getInstrumentName() {
        if (this.fpBean != null) {
            return this.fpBean.getInstrumentName();
        }
        return "";
    }

    protected String getInstrumentDesc() {
        if (this.fpBean != null) {
            return this.fpBean.getInstrumentDesc();
        }
        return "";
    }

    protected String getTelescopeName() {
        if (this.fpBean != null) {
            return this.fpBean.getTelescopeName();
        }
        return "";
    }

    protected String getOrigine() {
        if (this.fpBean != null) {
            return this.fpBean.getOrigin();
        }
        return "";
    }

    private class PlanFieldSub {
        protected String ID;
        protected String desc;
        protected int first;
        protected int last;
        protected boolean visible;
        protected Color color;

        private PlanFieldSub(String string, String string2, int n, int n2, boolean bl, Color color) {
            this.ID = string.replace('/', '.');
            this.desc = string2;
            this.first = n;
            this.last = n2;
            this.visible = bl;
            this.color = color;
        }
    }
}

