/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.FilterProperties;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.Source;
import cds.aladin.UCDFilter;
import cds.tools.Util;
import java.awt.Color;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public final class PlanFilter
extends Plan {
    private static final int INCREMENT = 4;
    protected static int LIMIT = 4;
    static final String[] PREDEFFILTERS = new String[]{"# Mag.Circle\n# This filter draws for each source a circle \n# whose radius is proportional to the magnitude\n{draw circle(-$[phot.mag*])}", "# Ellipses\n# This example shows how to draw \n# an ellipse associated with a source\n\n# The first action draws the source itself,\n# the second action draws the ellipse ; \n# parameters are semi-major axis, semi-minor axis, and position angle\n{\ndraw\ndraw ellipse(0.5*$[phys.angSize.smajAxis],0.5*$[phys.angSize.sminAxis],$[pos.posAng])\n}", "# Mag.Cut\n# Only sources with a magnitude \n# brighter than 16 are displayed\n$[phot.mag*]<16 {draw}\n", "# Disp.Text\n# This filter draws for each source the content\n# of the column tagged by the UCD \"src.class\"\n{\ndraw $[src.class]\n}", "# Param.Colors\n# In this filter, the green and blue components\n# of the color of each source are defined\n# according to the value of the magnitude\n{\ndraw rgb(255,-$[phot.mag*],$[phot.mag*]) square\n}", "# Obj.Type\n# We draw a different symbol according to\n# the object type (value of the column with UCD \"src.class\")\n$[src.class]=\"Star\" {draw red square}\n$[src.class]=\"Radio\" {draw blue rhomb}\n$[src.class]=\"Galaxy\" || $[src.class]=\"Seyfert\" {draw green plus}\n# etc ...\n", "# Prop.motions\n# Draws an arrow representing\n# the proper motion of the source\n\n# Remark : You are suggested to modify the factor \n# if the arrows are too small or too long\n{draw pm(5*$[pos.pm;pos.eq.ra],5*$[pos.pm;pos.eq.dec])}\n", "# Color.Index\n# This filters aims to visualize the color of stars\n# according to their color index B-V.\n# The optional parameters -0.3 and 1 mean that :\n# - any source with a color index lesser than -0.3\n#   is displayed in blue\n# - any source with a color index greater than 1\n#    is displayed in red\n{draw rainbow($[phot.color;em.opt.B;em.opt.V],-0.3,1)}", "# Spec.Types\n# This filter assigns colors related\n# to the spectral type of sources.\n# The association spectral type --> color\n# is the following:\n# O : violet\n# B : blue/violet\n# A : blue\n# F : green/yellow\n# G : yellow\n# K : orange\n# M R N S C : red\n# T L : brown\n# W : violet\n# D : gray\n\n$[src.spType*] = \"*B*\" {draw #8a2be2}\n$[src.spType*] = \"*A*\" {draw blue}\n$[src.spType*] = \"*F*\" {draw #adff2f}\n$[src.spType*] = \"*G*\" {draw yellow}\n$[src.spType*] = \"*K*\" {draw orange}\n$[src.spType*] = \"*M*\" || \n$[src.spType*] = \"*R*\" || \n$[src.spType*] = \"*N*\" || \n$[src.spType*] = \"*S*\" || \n$[src.spType*] = \"*C*\" {draw red}\n$[src.spType*] = \"*T*\" || \n$[src.spType*] = \"*L*\" {draw #a52a2a}\n$[src.spType*] = \"*O*\" {draw #ee82ee}\n$[src.spType*] = \"*W*\" {draw #ee82ee}\n$[src.spType*] = \"*D*\" {draw gray}\n", "# Unit.Conversion\n# You can specify a unit when writing a constraint\n# Unit conversion is automatically computed (when possible)\n$[phot.flux;em.X-ray]>10^-8 erg/m^2/s {\ndraw circle($[phot.flux;em.X-ray])\n}"};
    static final String[] PREDEFLABELS = new String[]{"Magnitude circle", "Ellipses", "Magnitude cut", "Display text", "Parameterized colors", "Select object type", "Proper motions", "Color index", "Spectral types", "Unit conversion"};
    static String[] saveFilters = new String[LIMIT];
    static String[] saveLabels = new String[LIMIT];
    String script;
    static int num = -1;
    static PlanFilter[] allFilters = new PlanFilter[0];
    int numero;
    private UCDFilter filter;
    private Vector<Plan> memPlan;
    private Vector<Plan> omemPlan;
    private boolean mustUpdate = true;
    boolean mustRepaint = true;
    boolean initPlanMem = true;
    protected Plan plan;
    private long lastFilterLock = -1L;
    private boolean relaunchDone = false;

    protected PlanFilter(Aladin aladin, String string, String string2) {
        this(aladin, string, string2, null);
    }

    protected PlanFilter(Aladin aladin, String string, String string2, Plan plan) {
        this.plan = plan;
        this.aladin = aladin;
        this.flagOk = true;
        this.type = 12;
        this.c = Color.black;
        this.askActive = true;
        this.selected = true;
        this.numero = ++num;
        this.memPlan = new Vector();
        this.omemPlan = new Vector();
        if (num >= LIMIT) {
            this.realloc();
        }
        if (string2 != null) {
            this.createFilter(string2, string);
        } else {
            this.createFilter("", "Filter" + num);
        }
        this.script = this.filter.definition;
        this.label = this.filter.name;
        String string3 = this.filter.name;
        this.uniqueName(string3);
        this.saveDef();
        if (string2 != null) {
            this.doLog();
        }
    }

    private void uniqueName(String string) {
        int n = 1;
        String string2 = string;
        while (PlanFilter.getFilterByName(string2, this.aladin) != null) {
            string2 = string + n++;
        }
        this.label = string2;
    }

    private void saveDef() {
        PlanFilter.saveFilters[this.numero] = this.script;
        PlanFilter.saveLabels[this.numero] = this.label;
    }

    protected void updateDefinition(String string, String string2, FilterProperties filterProperties) {
        String string3 = this.script;
        if (string2 != null) {
            string2 = UCDFilter.skipSpaces(string2);
        }
        this.script = string;
        this.createFilter(string, string2);
        this.script = this.filter.definition;
        String string4 = this.label = this.filter.name.length() == 0 ? this.label : this.filter.name;
        this.label = "";
        this.uniqueName(string4);
        this.saveDef();
        this.doLog();
        if (!UCDFilter.skipSpaces(this.script).equals(UCDFilter.skipSpaces(string3))) {
            this.setPlanMemory();
            this.updateInfluence();
            this.mustUpdate = true;
        }
        if (!this.isValid()) {
            if (filterProperties == null || !filterProperties.isShowing()) {
                Aladin.warning(Aladin.chaine.getString("BADFILTER"), 1);
            }
            this.setActivated(false);
            this.aladin.calque.select.repaint();
            this.aladin.view.setMesure();
            return;
        }
        if (this.isOn()) {
            this.applyFilter();
        }
    }

    private void doLog() {
        this.sendLog("Filter", "Label: " + this.label);
    }

    private void createFilter(String string, String string2) {
        this.filter = string2 == null ? new UCDFilter(string, this.aladin, this) : new UCDFilter(string2, string, this.aladin, this);
        this.filter.setNumero(this.numero);
        this.error = !this.isValid() ? "ERROR" : null;
    }

    protected void updateState() {
        if (this.isOn()) {
            if (!this.isValid()) {
                Aladin.warning(Aladin.chaine.getString("BADFILTER"), 1);
                this.setActivated(false);
                this.aladin.calque.select.repaint();
                this.aladin.view.setMesure();
                return;
            }
            this.mustRepaint = true;
            this.applyFilter();
        } else {
            this.aladin.view.setMesure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyFilter() {
        if (this.mustUpdate) {
            this.flagOk = false;
        }
        if (this.initPlanMem) {
            this.setPlanMemory();
            this.updateInfluence();
            this.initPlanMem = false;
        }
        this.stopFilterThread();
        PlanFilter planFilter = this;
        synchronized (planFilter) {
            this.runme = new Thread((Runnable)this, "AladinFilterApply");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    private synchronized void stopFilterThread() {
        block4: {
            if (this.runme == null) {
                return;
            }
            Thread thread = this.runme;
            this.runme = null;
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block4;
                exception.printStackTrace();
            }
        }
    }

    @Override
    protected boolean isSync() {
        if (this.isSync1()) {
            this.lastFilterLock = -1L;
            return true;
        }
        long l = System.currentTimeMillis();
        if (this.lastFilterLock == -1L) {
            this.lastFilterLock = l;
        } else if (l - this.lastFilterLock > 4000L) {
            if (this.relaunchDone) {
                if (Aladin.levelTrace >= 3) {
                    System.err.println("PlanFilter.isSync()=false, last manual relaunch did not work => assume isSync()=true");
                }
                this.lastFilterLock = -1L;
                this.relaunchDone = false;
                return true;
            }
            if (Aladin.levelTrace >= 3) {
                System.err.println("PlanFilter.isSync()=false but delay exceed 4s => relaunch filter manually...");
            }
            this.relaunchDone = true;
            this.doApplyFilter();
            this.lastFilterLock = l;
        }
        return false;
    }

    private boolean isSync1() {
        return this.flagOk && (this.error != null || !this.mustUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void doApplyFilter(boolean bl) {
        Source[] sourceArray;
        if (this.mustUpdate) {
            Aladin.trace(1, "Updating filter results");
            if (!this.isValid()) {
                this.setActivated(false);
                this.flagOk = true;
                return;
            }
            this.flagOk = false;
            this.aladin.calque.repaintAll();
            sourceArray = this.getSources(this.aladin, bl);
            if (bl && this.runme == null) {
                return;
            }
            this.resetFlags();
            this.filter.getFilteredSources(sourceArray, bl);
            if (bl && this.runme == null) {
                return;
            }
            this.flagOk = true;
            this.setPourcent(-1.0);
        }
        if (this.mustRepaint) {
            sourceArray = this.aladin.mesure;
            // MONITORENTER : this.aladin.mesure
            this.aladin.view.setMesure();
            // MONITOREXIT : sourceArray
        }
        this.mustUpdate = false;
    }

    protected void doApplyFilter() {
        this.doApplyFilter(false);
    }

    protected Source[] getSources(Aladin aladin, boolean bl) {
        Object object;
        Plan plan = null;
        Vector<Source> vector = new Vector<Source>();
        Plan[] planArray = this.getConcernedPlans();
        int n = 1;
        block0: for (int i = planArray.length - 1; i >= 0; --i) {
            plan = planArray[i];
            object = plan.iterator();
            while (object.hasNext()) {
                Obj obj = (Obj)object.next();
                if (bl && n % 1000 == 0 && this.runme == null) continue block0;
                if (!(obj instanceof Source) || obj == null) continue;
                vector.addElement((Source)obj);
                ++n;
            }
        }
        object = new Source[vector.size()];
        vector.copyInto((Object[])object);
        vector = null;
        return object;
    }

    protected Source[] getSources(Aladin aladin) {
        return this.getSources(aladin, false);
    }

    private Plan getFolder() {
        Plan[] planArray = this.aladin.calque.getPlans();
        for (int i = planArray.length - 1; i >= 0; --i) {
            Plan plan = planArray[i];
            if (plan.type != 11) continue;
            Plan[] planArray2 = this.aladin.calque.getFolderPlan(plan);
            for (int j = 0; j < planArray2.length; ++j) {
                if (planArray2[j] != this) continue;
                return plan;
            }
        }
        return null;
    }

    private Vector<Plan> getAllPlansOfFolder(Plan plan) {
        Vector<Plan> vector = new Vector<Plan>(10);
        this.getAllPlansOfFolder(plan, vector);
        return vector;
    }

    private void getAllPlansOfFolder(Plan plan, Vector<Plan> vector) {
        Plan[] planArray = this.aladin.calque.getFolderPlan(plan);
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan2 = planArray[i];
            if (plan2.type == 11) {
                this.getAllPlansOfFolder(plan2, vector);
                continue;
            }
            vector.addElement(plan2);
        }
    }

    private boolean morePlans(Vector vector, Vector vector2) {
        if (vector2.size() > vector.size()) {
            return true;
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            if (vector.contains(enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    private void setPlanMemory() {
        Plan[] planArray = this.getConcernedPlans();
        this.omemPlan = this.memPlan;
        this.memPlan = new Vector();
        for (int i = 0; i < planArray.length; ++i) {
            this.memPlan.addElement(planArray[i]);
        }
    }

    protected void setMustUpdate() {
        this.setPlanMemory();
        this.updateInfluence();
        if (this.morePlans(this.omemPlan, this.memPlan)) {
            this.mustUpdate = true;
            this.filter.resetActions();
        }
    }

    private void updateInfluence() {
        for (int i = this.aladin.calque.plan.length - 1; i >= 0; --i) {
            Plan plan = this.aladin.calque.plan[i];
            if (!plan.isCatalog()) continue;
            plan.influence[this.numero] = this.memPlan.contains(plan);
        }
    }

    protected Plan[] getConcernedPlans() {
        if (this.plan != null) {
            return new Plan[]{this.plan};
        }
        int n = this.getPositionOfPlan(this);
        Vector<Plan> vector = new Vector<Plan>();
        Plan plan = this.getFolder();
        Vector<Plan> vector2 = null;
        if (plan != null) {
            vector2 = this.getAllPlansOfFolder(this.getFolder());
        }
        for (int i = this.aladin.calque.plan.length - 1; i >= n; --i) {
            Plan plan2 = this.aladin.calque.plan[i];
            if (!plan2.isCatalog() || !plan2.flagOk || !plan2.active || plan != null && !vector2.contains(plan2)) continue;
            vector.addElement(plan2);
        }
        Object[] objectArray = new Plan[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private int getPositionOfPlan(Plan plan) {
        for (int i = this.aladin.calque.plan.length - 1; i >= 0; --i) {
            Plan plan2 = this.aladin.calque.plan[i];
            if (plan2 != plan) continue;
            return i;
        }
        return -1;
    }

    private void resetFlags() {
        Plan plan = null;
        for (int i = this.aladin.calque.plan.length - 1; i >= 0; --i) {
            plan = this.aladin.calque.plan[i];
            if (!plan.isCatalog() || !plan.flagOk) continue;
            Iterator<Obj> iterator = plan.iterator();
            while (iterator.hasNext()) {
                Source source;
                Obj obj = iterator.next();
                if (!(obj instanceof Source) || (source = (Source)obj) == null) continue;
                if (source.isSelected == null) {
                    source.isSelected = new boolean[LIMIT];
                }
                source.isSelected[this.numero] = false;
            }
        }
    }

    protected void select() {
        this.filter.select(this.getSources(this.aladin));
        this.aladin.view.setMesure();
    }

    protected void export() {
        Source[] sourceArray = this.filter.getFilteredSources(this.getSources(this.aladin));
        PlanCatalog planCatalog = this.aladin.calque.newPlanCatalogBySources(new Vector<Source>(Arrays.asList(sourceArray)), "Filter.src", false);
        if (planCatalog != null) {
            this.aladin.view.selectAllInPlan(planCatalog);
        }
        this.setPourcent(-1.0);
        this.aladin.view.repaintAll();
    }

    protected void positionChange() {
        PlanFilter.updateAllFilters(this.aladin);
        this.setMustUpdate();
        if (this.isOn()) {
            this.applyFilter();
        }
    }

    protected boolean isOn() {
        if (this.plan != null) {
            return true;
        }
        return this.active;
    }

    protected boolean isValid() {
        return !this.filter.badSyntax;
    }

    @Override
    protected void planReady(boolean bl) {
    }

    @Override
    protected boolean waitForPlan() {
        this.doApplyFilter(true);
        return true;
    }

    private void realloc() {
        LIMIT += 4;
        for (int i = this.aladin.calque.plan.length - 1; i >= 0; --i) {
            Plan plan = this.aladin.calque.plan[i];
            if (!plan.isCatalog()) continue;
            boolean[] blArray = new boolean[LIMIT];
            System.arraycopy(plan.influence, 0, blArray, 0, plan.influence.length);
            plan.influence = blArray;
            Iterator<Obj> iterator = plan.iterator();
            while (iterator.hasNext()) {
                Obj obj = iterator.next();
                if (!(obj instanceof Source)) continue;
                Source source = (Source)obj;
                boolean[] blArray2 = new boolean[LIMIT];
                if (source.isSelected == null) {
                    source.isSelected = new boolean[LIMIT];
                }
                System.arraycopy(source.isSelected, 0, blArray2, 0, source.isSelected.length);
                source.isSelected = blArray2;
                if (source.actions == null) {
                    source.actions = new Action[LIMIT][];
                }
                Action[][] actionArrayArray = new Action[LIMIT][];
                for (int j = 0; j < LIMIT - 4; ++j) {
                    actionArrayArray[j] = source.actions[j];
                }
                source.actions = actionArrayArray;
                if (source.values == null) {
                    source.values = new double[LIMIT][][];
                }
                double[][][] dArrayArray = new double[LIMIT][][];
                for (int j = 0; j < LIMIT - 4; ++j) {
                    dArrayArray[j] = source.values[j];
                }
                source.values = dArrayArray;
            }
        }
        String[] stringArray = new String[LIMIT];
        System.arraycopy(saveFilters, 0, stringArray, 0, saveFilters.length);
        saveFilters = stringArray;
        stringArray = new String[LIMIT];
        System.arraycopy(saveLabels, 0, stringArray, 0, saveLabels.length);
        saveLabels = stringArray;
    }

    public UCDFilter getUCDFilter() {
        return this.filter;
    }

    protected static void updateAllFilters(Aladin aladin) {
        allFilters = PlanFilter.getAllFilters(aladin);
    }

    static void activateAllFilters() {
        PlanFilter planFilter = null;
        if (allFilters == null) {
            return;
        }
        for (int i = 0; i < allFilters.length; ++i) {
            planFilter = allFilters[i];
            planFilter.mustRepaint = false;
            planFilter.applyFilter();
            planFilter.setActivated(true);
        }
        if (planFilter != null) {
            planFilter.aladin.view.setMesure();
            planFilter.aladin.calque.select.repaint();
            planFilter.mustRepaint = true;
        }
    }

    static void desactivateAllFilters() {
        PlanFilter planFilter = null;
        if (allFilters == null) {
            return;
        }
        for (int i = 0; i < allFilters.length; ++i) {
            planFilter = allFilters[i];
            planFilter.setActivated(false);
        }
        if (planFilter != null) {
            planFilter.aladin.view.setMesure();
            planFilter.aladin.calque.select.repaint();
        }
    }

    private static PlanFilter[] getAllFilters(Aladin aladin) {
        Vector<Plan> vector = new Vector<Plan>();
        for (int i = aladin.calque.plan.length - 1; i >= 0; --i) {
            PlanFilter planFilter;
            Plan plan = aladin.calque.plan[i];
            if (plan.type == 12) {
                vector.addElement(plan);
            }
            if (!plan.isCatalog() || (planFilter = plan.getFilter()) == null) continue;
            vector.addElement(planFilter);
        }
        Object[] objectArray = new PlanFilter[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    @Override
    protected boolean Free() {
        this.stopFilterThread();
        this.memPlan = null;
        this.omemPlan = null;
        this.filter.Free();
        super.Free();
        PlanFilter.updateAllFilters(this.aladin);
        FilterProperties.majFilterProp(true, false);
        return true;
    }

    protected static PlanFilter getFilterByName(String string, Aladin aladin) {
        for (int i = aladin.calque.plan.length - 1; i >= 0; --i) {
            Plan plan = aladin.calque.plan[i];
            if (plan.type != 12 || !plan.label.equals(string)) continue;
            return (PlanFilter)plan;
        }
        return null;
    }

    static void updatePlan(Plan plan, int n, int n2) {
        PlanFilter planFilter = null;
        if (allFilters == null) {
            return;
        }
        for (int i = 0; i < allFilters.length; ++i) {
            planFilter = allFilters[i];
            planFilter.setMustUpdate();
            if (!planFilter.isOn()) continue;
            planFilter.applyFilter();
        }
    }

    static void updatePlan(Plan plan) {
        PlanFilter planFilter = null;
        if (allFilters == null) {
            return;
        }
        for (int i = 0; i < allFilters.length; ++i) {
            planFilter = allFilters[i];
            planFilter.setMustUpdate();
            if (!planFilter.isOn()) continue;
            planFilter.applyFilter();
        }
    }

    static void newPlan(Plan plan) {
        PlanFilter planFilter = null;
        if (allFilters == null) {
            return;
        }
        for (int i = 0; i < allFilters.length; ++i) {
            planFilter = allFilters[i];
            planFilter.setMustUpdate();
            if (!planFilter.isOn()) continue;
            planFilter.applyFilter();
        }
    }

    static void updateNow() {
        PlanFilter planFilter = null;
        if (allFilters == null) {
            return;
        }
        for (int i = 0; i < allFilters.length; ++i) {
            planFilter = allFilters[i];
            planFilter.setMustUpdate();
            planFilter.setPlanMemory();
            planFilter.mustUpdate = true;
            if (!planFilter.isOn()) continue;
            planFilter.applyFilter();
        }
    }
}

