/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Couleur;
import cds.aladin.Fov;
import cds.aladin.Ligne;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanField;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCPolygon;
import java.util.ArrayList;

public class PlanFov
extends Plan {
    private Fov[] fov;

    PlanFov(Aladin aladin, String string, Fov[] fovArray) {
        this.aladin = aladin;
        this.type = 13;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setLabel(string);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        this.selected = true;
        this.fov = fovArray;
        this.suite();
        this.flagOk = true;
        this.askActive = true;
        aladin.view.repaintAll();
        aladin.calque.repaintAll();
    }

    private static double max(double d, double d2) {
        return d > d2 ? d : d2;
    }

    private static double min(double d, double d2) {
        return d < d2 ? d : d2;
    }

    private static double abs(double d) {
        return d < 0.0 ? -d : d;
    }

    protected static Projection getProjection(Fov[] fovArray) {
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = d2 = fovArray[0].alpha;
        double d6 = d = fovArray[0].delta;
        int n = 0;
        for (int i = 0; i < fovArray.length; ++i) {
            double d7;
            double d8;
            if (fovArray[i] == null) continue;
            double d9 = fovArray[i].alpha;
            double d10 = fovArray[i].delta;
            if (d9 > 180.0) {
                d9 = -360.0 + d9;
            }
            if (d10 > 180.0) {
                d10 = -360.0 + d10;
            }
            d4 += d9;
            d3 += d10;
            if (fovArray[i].spectrumFov) {
                d8 = 0.0;
                d7 = 0.02;
            } else {
                d8 = fovArray[i].x;
                d7 = fovArray[i].y;
            }
            d5 = PlanFov.min(d5, d9 - d8);
            d2 = PlanFov.max(d2, d9 + d8);
            d6 = PlanFov.min(d6, d10 - d7);
            d = PlanFov.max(d, d10 + d7);
            ++n;
        }
        double[] dArray = new double[]{PlanFov.abs((d3 /= (double)n) - (d6 %= 360.0)), PlanFov.abs(d3 - (d %= 360.0)), PlanFov.abs((d4 /= (double)n) - (d5 %= 360.0)), PlanFov.abs(d4 - (d2 %= 360.0))};
        for (int i = 0; i < 4; ++i) {
            if (!(dArray[i] > 180.0)) continue;
            dArray[i] = PlanFov.abs(-360.0 + dArray[i]);
        }
        double d11 = PlanFov.max(PlanFov.max(dArray[0], dArray[1]), PlanFov.max(dArray[2], dArray[3]));
        return new Projection(null, 3, d4, d3, d11 * 60.0 * 2.0, 250.0, 250.0, 500.0, 0.0, false, 2, Calib.FK5);
    }

    private void suite() {
        this.setOpacityLevel(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL);
        Plan plan = this.aladin.calque.getPlanRef();
        if (this.fov == null || this.fov.length == 0) {
            return;
        }
        this.projd = plan == null || !Projection.isOk(plan.projd) ? PlanFov.getProjection(this.fov) : plan.projd;
        for (int i = 0; i < this.fov.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            Fov fov = this.fov[i];
            if (fov == null) continue;
            if (fov.pf != null) {
                PlanField planField = new PlanField(this.aladin, fov.fpBean, fov.key);
                planField.make(fov.alpha, fov.delta, fov.angle);
                object3 = planField.pcat.iterator();
                while (object3.hasNext()) {
                    object2 = (Obj)object3.next();
                    if (object2 instanceof Position) {
                        ((Position)object2).plan = this;
                    }
                    this.pcat.setObjet((Obj)object2);
                }
            }
            object3 = new ArrayList<PointD[]>();
            if (fov.getStcObjects() != null) {
                for (STCObj sTCObj : fov.getStcObjects()) {
                    if (sTCObj.getShapeType() != STCObj.ShapeType.POLYGON) continue;
                    STCPolygon sTCPolygon = (STCPolygon)sTCObj;
                    object = new PointD[sTCPolygon.getxCorners().size()];
                    for (int j = 0; j < ((PointD[])object).length; ++j) {
                        object[j] = new PointD(sTCPolygon.getxCorners().get(j), sTCPolygon.getyCorners().get(j));
                    }
                    ((ArrayList)object3).add(object);
                }
            } else {
                ((ArrayList)object3).add(fov.getPoints());
            }
            object2 = ((ArrayList)object3).iterator();
            while (object2.hasNext()) {
                PointD[] pointDArray = (PointD[])object2.next();
                PointD pointD = pointDArray[pointDArray.length - 1];
                if (pointD == null) continue;
                Object object4 = new Ligne(this);
                object4.raj = pointD.x;
                object4.dej = pointD.y;
                this.pcat.setObjet((Obj)object4);
                for (int j = 0; j < pointDArray.length; ++j) {
                    pointD = pointDArray[j];
                    object = new Ligne(this);
                    object.raj = pointD.x;
                    object.dej = pointD.y;
                    object.debligne = object4;
                    this.pcat.setObjet((Obj)object);
                    object4 = object;
                }
            }
        }
    }

    @Override
    protected boolean Free() {
        this.fov = null;
        return super.Free();
    }
}

