/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.FrameHeaderFits;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.Projection;
import cds.aladin.TreeNodeAllsky;
import cds.aladin.ViewSimple;
import cds.allsky.Constante;
import cds.allsky.Context;
import cds.fits.Fits;
import cds.fits.HeaderFits;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Graphics;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class PlanHealpix
extends PlanBG {
    static final int POLA_SEGMENT_MAGIC_CODE = -42;
    static final int POLA_AMPLITUDE_MAGIC_CODE = -41;
    static final int POLA_ANGLE_MAGIC_CODE = -40;
    static Object lock = new Object();
    private char coordsys;
    private int nSideFile;
    private int sizeRecord;
    private int nRecord;
    private int nField;
    private char[] typeHpx;
    private int[] lenHpx;
    private String dirName;
    private String ordering;
    private double badData;
    private boolean hasBadData;
    protected int idxTFormToRead;
    protected String[] tfieldNames;
    private int newNSideImage;
    private int newNSideFile;
    private int hpxOrderGeneratedImgs;
    private boolean isLocal;
    private boolean isGZ;
    private boolean isPartial;
    private boolean isARGB;
    private double[] partialHpxPixIdx;
    private int nbRecordsPartial;
    private String originalPath;
    private String pixelPath;
    private String tempFilePath;
    private int nbPixGeneratedImage;
    private int curTFormBitpix;
    private boolean fromProperties;
    private String dirCache;
    private boolean flagCache;
    static final String CACHEHPX = "HPX";
    HashMap partialValues;
    private double[] ringValues;
    private RandomAccessFile rafHpx;
    private long initialOffsetHpx;

    public PlanHealpix(Aladin aladin, String string, MyInputStream myInputStream, String string2, int n, int n2, boolean bl, Coord coord, double d) {
        super(aladin);
        this.hasBadData = false;
        this.idxTFormToRead = 0;
        this.isGZ = false;
        this.isPartial = false;
        this.isARGB = false;
        this.dirCache = null;
        this.flagCache = false;
        this.initialOffsetHpx = Long.MIN_VALUE;
        this.fromProperties = bl;
        this.co = coord;
        this.coRadius = d;
        this.init(string, myInputStream, string2, n2);
        this.setDrawMode(n);
        this.threading();
    }

    public PlanHealpix(Aladin aladin, TreeNodeAllsky treeNodeAllsky, String string, Coord coord, double d, String string2) {
        MyInputStream myInputStream;
        String string3;
        block3: {
            super(aladin);
            this.hasBadData = false;
            this.idxTFormToRead = 0;
            this.isGZ = false;
            this.isPartial = false;
            this.isARGB = false;
            this.dirCache = null;
            this.flagCache = false;
            this.initialOffsetHpx = Long.MIN_VALUE;
            this.startingTaskId = string2;
            this.fromProperties = false;
            this.gluTag = treeNodeAllsky.getID();
            this.id = treeNodeAllsky.internalId;
            string3 = treeNodeAllsky.getUrl();
            myInputStream = null;
            try {
                myInputStream = Util.openAnyStream(string3);
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block3;
                exception.printStackTrace();
            }
        }
        if (string == null) {
            string = treeNodeAllsky.label;
        }
        this.co = coord;
        this.coRadius = d;
        this.init(string3, myInputStream, string, 0);
        this.setDrawMode(0);
        this.threading();
    }

    public PlanHealpix(Aladin aladin) {
        super(aladin);
        this.hasBadData = false;
        this.idxTFormToRead = 0;
        this.isGZ = false;
        this.isPartial = false;
        this.isARGB = false;
        this.dirCache = null;
        this.flagCache = false;
        this.initialOffsetHpx = Long.MIN_VALUE;
    }

    @Override
    protected void log() {
    }

    protected void init(String string, MyInputStream myInputStream, String string2, int n) {
        this.isLocal = string == null || !string.startsWith("http") && !string.startsWith("ftp");
        this.idxTFormToRead = n;
        this.video = this.aladin.configuration.getCMVideo();
        this.flagOk = false;
        this.isOldPlan = false;
        this.type = 16;
        this.frameOrigin = 3;
        this.dis = myInputStream;
        this.filename = string;
        this.cacheID = this.survey = string;
        this.originalPath = string;
        this.maxOrder = 3;
        int n2 = string.lastIndexOf(Util.FS);
        if (n2 > 0) {
            this.survey = this.survey.substring(n2 + 1);
        }
        this.setLabel(string2 == null ? this.survey : string2);
        this.survey = this.dirName = this.getDirname() + Util.FS + this.dirNameForIdx(n);
        this.aladin.log("AllskyMap", string2);
    }

    private String getDirname() {
        String string = null;
        if (this.isLocal) {
            File file = new File(this.originalPath);
            try {
                string = file.getCanonicalPath().replace('/', '_').replace('\\', '_').replace(':', '_').replace('.', '_').replace('?', '_');
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            string = this.originalPath.replace('/', '_').replace('\\', '_').replace(':', '_').replace('.', '_').replace('?', '_');
        }
        return string;
    }

    private String dirNameForIdx(int n) {
        switch (n) {
            case -42: {
                return "polarisation";
            }
            case -41: {
                return "polarisation_amplitude";
            }
            case -40: {
                return "polarisation_angle";
            }
        }
        return "TFIELD" + (n + 1);
    }

    @Override
    protected boolean Free() {
        this.ringValues = null;
        return super.Free();
    }

    private void cleanup() {
        if (this.tempFilePath != null) {
            try {
                new File(this.tempFilePath).delete();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.tempFilePath = null;
        }
        this.partialValues = null;
        this.partialHpxPixIdx = null;
    }

    @Override
    protected int getTileOrder() {
        return (int)PlanHealpix.log2(this.nbPixGeneratedImage);
    }

    private boolean dumpStreamToFile(InputStream inputStream, File file) {
        BufferedOutputStream bufferedOutputStream;
        Aladin.trace(2, "Dumping input stream to temp file: " + file.getName());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        byte[] byArray = new byte[1024];
        try {
            int n;
            while ((n = bufferedInputStream.read(byArray)) > 0) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    private void setPixelPath() throws IOException {
        if (this.isLocal && !this.isGZ) {
            this.pixelPath = this.originalPath;
        } else {
            this.tempFilePath = this.aladin.createTempFile("PlanHealpix", ".hpx").getCanonicalPath();
            this.dumpStreamToFile(this.dis, new File(this.tempFilePath));
            this.pixelPath = this.tempFilePath;
        }
        Aladin.trace(2, "isLocal: " + this.isLocal + ", isGZ: " + this.isGZ + ", originalPath: " + this.originalPath + ", pixelPath: " + this.pixelPath);
    }

    @Override
    protected boolean waitForPlan() {
        super.waitForPlan();
        try {
            boolean bl = this.needProcessing(this.dirName, true);
            if (bl) {
                try {
                    this.isGZ = this.dis.isGZ();
                    this.isARGB = (this.dis.getType() & 0x400000000L) != 0L;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.setPixelPath();
            this.startHealpixCreation();
            if (bl) {
                this.writePropertiesFile(this.dirName);
            }
            this.suiteSpecif();
            return true;
        }
        catch (Exception exception) {
            this.error = "HEALPix error " + (exception.getMessage() != null ? ": " + exception.getMessage() : "");
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            return false;
        }
    }

    private String getCoordSys(char c) {
        if (c == 'C' || c == 'Q') {
            return "equatorial";
        }
        if (c == 'E') {
            return "ecliptic";
        }
        return "galactic";
    }

    private boolean writePropertiesFile(String string) {
        MyProperties myProperties = new MyProperties();
        myProperties.setProperty("dataPath", this.originalPath);
        if (this.isLocal) {
            try {
                String string2 = new File(this.originalPath).lastModified() + "";
                myProperties.setProperty("lastModified", string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        myProperties.setProperty("hips_release_date", Constante.getDate());
        myProperties.setProperty("hips_order", this.maxOrder + "");
        myProperties.setProperty("nsideFile", this.newNSideImage + "");
        myProperties.setProperty("nsidePixel", this.newNSideFile + "");
        myProperties.setProperty("hips_tile_width", CDSHealpix.pow2(this.hpxOrderGeneratedImgs) + "");
        myProperties.setProperty("ordering", this.ordering);
        myProperties.setProperty("tfields", this.nField + "");
        myProperties.setProperty("ttypes", Util.join(this.tfieldNames, ','));
        myProperties.setProperty("localData", this.isLocal + "");
        myProperties.setProperty("gzipped", this.isGZ + "");
        myProperties.setProperty("offset", this.initialOffsetHpx + "");
        myProperties.setProperty("sizeRecord", this.sizeRecord + "");
        myProperties.setProperty("isPartial", this.isPartial + "");
        myProperties.setProperty("ARGB", this.isARGB + "");
        myProperties.setProperty("nbPixGeneratedImage", this.nbPixGeneratedImage + "");
        myProperties.setProperty("curTFormBitpix", this.curTFormBitpix + "");
        myProperties.setProperty("hips_frame", this.getCoordSys(this.coordsys));
        myProperties.setProperty("lenhpx", Util.join(this.lenHpx, ','));
        myProperties.setProperty("typehpx", Util.join(this.typeHpx, ','));
        myProperties.setProperty("aladinVersion", "v9.033a");
        try {
            myProperties.store(new FileOutputStream(this.propertiesFile(string)), null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void suiteSpecif() {
        this.url = this.getCacheDir() + Util.FS + this.survey;
        this.minOrder = 3;
        this.useCache = false;
        this.inFits = true;
        this.truePixels = true;
        this.inJPEG = false;
        this.inPNG = false;
        this.color = this.isARGB;
        Aladin.trace(3, this + "");
        if (this.co == null) {
            this.co = new Coord(0.0, 0.0);
            this.co = Localisation.frameToFrame(this.co, this.aladin.localisation.getFrame(), 0);
            this.coRadius = 220.0;
        }
        if (this.coRadius <= 0.0) {
            this.coRadius = 220.0;
        }
        this.objet = this.co + "";
        this.selected = true;
        this.active = true;
        this.pixList = new Hashtable(1000);
        this.loader = new PlanBG.HealpixLoader();
        this.scanMetadata();
        this.postProd();
    }

    protected void postProd() {
        int n = this.aladin.configuration.getProjAllsky();
        Plan plan = this.aladin.calque.getPlanBase();
        if (plan instanceof PlanBG) {
            n = plan.projd.t;
        }
        Projection projection = new Projection("allsky", 2, this.co.al, this.co.del, 240.0, 240.0, 250.0, 250.0, 500.0, 500.0, 0.0, false, n, Calib.FK5);
        projection.frame = this.getCurrentFrameDrawing();
        if (Aladin.OUTREACH) {
            projection.frame = 3;
        }
        this.setNewProjD(projection);
        this.typeCM = this.aladin.configuration.getCMMap();
        this.transfertFct = this.aladin.configuration.getCMFct();
        this.video = this.aladin.configuration.getCMVideo();
        this.setDefaultZoom(this.co, this.coRadius);
        this.creatDefaultCM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHealpixCreation() throws Exception {
        double d;
        int n;
        int n2;
        Aladin.trace(2, "Loading HEALPIX FITS image");
        File file = new File(this.getCacheDir() + Util.FS + this.dirName);
        if (!this.needProcessing(this.dirName, true)) {
            return;
        }
        Util.createPath(file + "");
        file.mkdir();
        int n3 = 0;
        this.ordering = null;
        double d2 = System.currentTimeMillis();
        MyInputStream myInputStream = null;
        try {
            myInputStream = new MyInputStream(new FileInputStream(this.pixelPath));
            this.headerFits = new FrameHeaderFits((Plan)this, myInputStream);
            n2 = this.headerFits.getIntFromHeader("NAXIS");
            if (n2 <= 1 && this.headerFits.getStringFromHeader("EXTEND") != null) {
                try {
                    n3 = this.headerFits.getIntFromHeader("NSIDE");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.ordering = this.headerFits.getStringFromHeader("ORDERING");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
                    myInputStream.skip(this.naxis1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                myInputStream.skipOnNext2880();
                this.headerFits = new FrameHeaderFits((Plan)this, myInputStream);
            }
            this.initialOffsetHpx = myInputStream.getPos();
        }
        finally {
            if (myInputStream != null) {
                myInputStream.close();
            }
        }
        n2 = 0;
        int n4 = 3;
        if (n3 == 0) {
            n3 = this.headerFits.getIntFromHeader("NSIDE");
        }
        if (n3 < (n = 512)) {
            n = n3;
        }
        Aladin.trace(3, "maxSizeGeneratedImage: " + n);
        this.nbPixGeneratedImage = 2 * n;
        this.nSideFile = n3;
        do {
            this.nbPixGeneratedImage /= 2;
        } while ((d = this.getLevelImage(n3, this.nbPixGeneratedImage)) < (double)n4);
        n2 = (int)CDSHealpix.pow2((long)d);
        Aladin.trace(3, "NSIDE image: " + n2);
        Aladin.trace(3, "Level image : " + d);
        Aladin.trace(3, "nb pixels generated image : " + this.nbPixGeneratedImage);
        this.naxis1 = this.sizeRecord = this.headerFits.getIntFromHeader("NAXIS1");
        this.naxis2 = this.nRecord = this.headerFits.getIntFromHeader("NAXIS2");
        this.nField = this.headerFits.getIntFromHeader("TFIELDS");
        if (this.ordering == null) {
            this.ordering = this.headerFits.getStringFromHeader("ORDERING");
        }
        Aladin.trace(3, "sizeRecord: " + this.sizeRecord);
        Aladin.trace(3, "nRecord: " + this.nRecord);
        Aladin.trace(3, "ordering: " + this.ordering);
        try {
            this.badData = Double.parseDouble(this.headerFits.getStringFromHeader("BAD_DATA"));
            this.hasBadData = true;
            System.out.println("BAD_DATA: " + this.badData);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string = this.headerFits.getStringFromHeader("COORDSYS");
            this.coordsys = string.charAt(0);
        }
        catch (Exception exception) {
            this.coordsys = (char)71;
        }
        finally {
            this.frameOrigin = this.coordsysToFrame(this.coordsys);
        }
        Aladin.trace(3, "COORDSYS vaut " + this.coordsys);
        this.blank = Double.NaN;
        this.loadFitsHeaderParam(this.headerFits);
        this.typeHpx = new char[this.nField];
        this.lenHpx = new int[this.nField];
        this.tfieldNames = new String[this.nField];
        for (int i = 0; i < this.nField; ++i) {
            int n5;
            String string = this.headerFits.getStringFromHeader("TTYPE" + (i + 1));
            if (string == null) {
                string = "TTYPE" + (i + 1);
            }
            this.tfieldNames[i] = string;
            String string2 = null;
            try {
                string2 = this.headerFits.getStringFromHeader("TFORM" + (i + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lenHpx[i] = 0;
            for (n5 = 0; n5 < string2.length() && Character.isDigit(string2.charAt(n5)); ++n5) {
                this.lenHpx[i] = this.lenHpx[i] * 10 + (string2.charAt(n5) - 48);
            }
            if (n5 == 0) {
                this.lenHpx[i] = 1;
            }
            this.typeHpx[i] = string2.charAt(n5);
        }
        try {
            this.rafHpx = new RandomAccessFile(this.pixelPath, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
        this.hpxOrderGeneratedImgs = (int)PlanHealpix.log2(this.nbPixGeneratedImage);
        Aladin.trace(3, "hpxOrderGeneratedImgs: " + this.hpxOrderGeneratedImgs);
        this.createHealpixOrder(this.hpxOrderGeneratedImgs);
        this.newNSideImage = n2;
        this.maxOrder = (int)PlanHealpix.log2(this.newNSideImage);
        Aladin.trace(3, "MAXORDER: " + this.maxOrder);
        this.newNSideFile = n3;
        this.generateHierarchy(this.idxTFormToRead);
        double d3 = System.currentTimeMillis();
        Context.writeMetadataFits(this.getSurveyDir(), this.headerFits.getHeaderFits());
        Aladin.trace(3, "TOTAL TIME: " + (d3 - d2) / 1000.0 + " s");
    }

    private void generateHierarchy(int n) {
        Fits[] fitsArray;
        int n2;
        if (n < 0) {
            this.generatePolarisationData();
            long l = Util.dirSize(new File(this.getCacheDir() + Util.FS + this.getDirname() + Util.FS + this.dirNameForIdx(n)));
            PlanHealpix.addInCache(l / 1024L);
            return;
        }
        int n3 = 12 * this.newNSideImage * this.newNSideImage;
        Aladin.trace(3, "Nb images to generate: " + n3);
        Aladin.trace(3, "nbPixGeneratedImage : " + this.nbPixGeneratedImage);
        if (this.ordering.equals("RING")) {
            this.fillRingValues(0, 12 * this.newNSideFile * this.newNSideFile, n);
        }
        if (this.tfieldNames.length > 0 && this.tfieldNames[0].equals("PIXEL")) {
            this.isPartial = true;
            if (n == 0 && !this.fromProperties) {
                n = 1;
                this.idxTFormToRead = 1;
                this.survey = this.dirName = this.getDirname() + Util.FS + this.dirNameForIdx(this.idxTFormToRead);
            }
            int n4 = 0;
            for (int i = 0; i < this.typeHpx.length; ++i) {
                n4 += Util.binSizeOf(this.typeHpx[i], this.lenHpx[i]);
            }
            this.nbRecordsPartial = this.naxis1 * this.naxis2 / n4;
            Aladin.trace(3, "nbRecordsPartial: " + this.nbRecordsPartial);
            this.partialHpxPixIdx = this.ordering.equals("NESTED") ? this.getValuesNested(0L, this.nbRecordsPartial, this.rafHpx, this.initialOffsetHpx, 0L) : this.getValuesRing(0L, this.nbRecordsPartial, this.newNSideFile);
            this.fillPartialValues(n);
        }
        this.curTFormBitpix = this.getBitpixFromFormat(this.typeHpx[n]);
        String string = this.getDirname() + Util.FS + this.dirNameForIdx(n);
        double d = 85.0 / (double)n3;
        for (n2 = 0; n2 < n3; ++n2) {
            this.pourcent += this.idxTFormToRead >= 0 ? d : d / 3.0;
            fitsArray = new Fits(this.nbPixGeneratedImage, this.nbPixGeneratedImage, this.curTFormBitpix);
            this.buildDoubleHealpix(this.newNSideImage, n2, this.newNSideFile, (Fits)fitsArray, n, string);
        }
        this.ringValues = null;
        n2 = (int)PlanHealpix.log2(this.newNSideImage);
        fitsArray = new Fits[4];
        Aladin.trace(3, "curNorder: " + n2);
        for (int i = n2 - 1; i >= 3; --i) {
            int n5 = (int)(12.0 * Math.pow(CDSHealpix.pow2(i), 2.0));
            for (long j = 0L; j < (long)n5; ++j) {
                for (int k = 0; k < 4; ++k) {
                    try {
                        String string2 = PlanHealpix.getFilePath(this.getCacheDir() + Util.FS + string, i + 1, j * 4L + (long)k) + ".fits";
                        fitsArray[k] = null;
                        if (!new File(string2).exists()) continue;
                        fitsArray[k] = new Fits();
                        fitsArray[k].loadFITS(string2);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                try {
                    this.createNodeHpx(PlanHealpix.getFilePath(this.getCacheDir() + Util.FS + string, i, j) + ".fits", i, j, fitsArray, this.curTFormBitpix, this.blank);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        try {
            this.createAllSky(this.getCacheDir(), string, 3, 64);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string3 = this.getCacheDir() + Util.FS + this.getDirname() + Util.FS + this.dirNameForIdx(n);
        long l = Util.dirSize(new File(string3));
        PlanHealpix.addInCache(l / 1024L);
        this.cleanup();
    }

    private boolean needProcessing(String string, boolean bl) {
        String string2;
        File file = new File(this.getCacheDir() + Util.FS + string + Util.FS + "Norder3" + Util.FS + "Allsky.fits");
        if (!file.exists() || file.length() <= 0L) {
            boolean bl2;
            if (string.endsWith("TFIELD1") && !(bl2 = this.needProcessing(string.substring(0, string.length() - 1) + "2", bl)) && this.isPartial) {
                this.idxTFormToRead = 1;
                this.survey = this.dirName = this.getDirname() + Util.FS + this.dirNameForIdx(this.idxTFormToRead);
                return false;
            }
            return true;
        }
        File file2 = this.propertiesFile(string);
        MyProperties myProperties = new MyProperties();
        try {
            myProperties.load(new FileInputStream(file2));
        }
        catch (Exception exception) {
            File file3 = new File(this.getCacheDir() + Util.FS + this.getDirname());
            Util.deleteDir(file3);
            return true;
        }
        if (this.isLocal) {
            double d;
            string2 = myProperties.getProperty("lastModified");
            try {
                d = Double.valueOf(string2);
            }
            catch (Exception exception) {
                return true;
            }
            if (string2 == null || d == 0.0 || d != (double)new File(this.originalPath).lastModified()) {
                return true;
            }
        }
        if (!bl) {
            return false;
        }
        Util.touch(new File(this.getCacheDir() + Util.FS + this.getDirname()), false);
        try {
            block18: {
                block17: {
                    string2 = myProperties.getProperty("aladinVersion");
                    if (string2 == null) break block17;
                    if (string2.equals("v9.033a")) break block18;
                }
                Aladin.trace(3, "Detected a different version of Aladin, recreate the Healpix files");
                File file4 = new File(this.getCacheDir() + Util.FS + this.getDirname());
                Util.deleteDir(file4);
                return true;
            }
            String string3 = myProperties.getProperty("hips_frame");
            if (string3 == null) {
                string3 = myProperties.getProperty("coordsys");
            }
            if (string3 == null) {
                string3 = "galactic";
            }
            this.coordsys = this.coordsys(string3);
            this.frameOrigin = this.coordsysToFrame(this.coordsys);
            this.isLocal = new Boolean(myProperties.getProperty("localData"));
            this.isGZ = new Boolean(myProperties.getProperty("gzipped"));
            this.isARGB = new Boolean(myProperties.getProperty("ARGB"));
            this.originalPath = myProperties.getProperty("dataPath");
            this.initialOffsetHpx = new Long(myProperties.getProperty("offset"));
            this.sizeRecord = new Integer(myProperties.getProperty("sizeRecord"));
            this.newNSideImage = Integer.parseInt(myProperties.getProperty("nsideFile"));
            this.maxOrder = (int)PlanHealpix.log2(this.newNSideImage);
            this.newNSideFile = Integer.parseInt(myProperties.getProperty("nsidePixel"));
            string3 = myProperties.getProperty("hips_tile_width");
            this.hpxOrderGeneratedImgs = string3 != null ? (int)CDSHealpix.log2(Integer.parseInt(string3)) : Integer.parseInt(myProperties.getProperty("tileOrder"));
            this.ordering = myProperties.getProperty("ordering");
            this.nField = Integer.parseInt(myProperties.getProperty("tfields"));
            this.tfieldNames = Util.split(myProperties.getProperty("ttypes"), ",");
            this.isPartial = new Boolean(myProperties.getProperty("isPartial"));
            this.nbPixGeneratedImage = Integer.parseInt(myProperties.getProperty("nbPixGeneratedImage"));
            this.curTFormBitpix = Integer.parseInt(myProperties.getProperty("curTFormBitpix"));
            this.lenHpx = Util.splitAsInt(myProperties.getProperty("lenhpx"), ",");
            this.typeHpx = Util.splitAschar(myProperties.getProperty("typehpx"), ",");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            File file5 = new File(this.getCacheDir() + Util.FS + this.getDirname());
            Aladin.trace(3, "Exception while reading properties file, remove directory " + file5 + " and recreate Healpix files");
            Util.deleteDir(file5);
            return true;
        }
        return false;
    }

    private File propertiesFile(String string) {
        return new File(this.getCacheDir() + Util.FS + string + Util.FS + "properties");
    }

    private int getBitpixFromFormat(char c) {
        switch (c) {
            case 'B': {
                return 8;
            }
            case 'I': {
                return 16;
            }
            case 'J': {
                return 32;
            }
            case 'K': {
                return 64;
            }
            case 'E': {
                return -32;
            }
            case 'D': {
                return -64;
            }
        }
        return -1;
    }

    @Override
    public String getCacheDir() {
        if (this.flagCache) {
            return this.dirCache;
        }
        this.flagCache = true;
        String string = System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + "Cache";
        File file = new File(string = string + Util.FS + CACHEHPX);
        if (!file.isDirectory() && !file.mkdirs()) {
            return null;
        }
        this.dirCache = string;
        return string;
    }

    protected static String getCacheDirPath() {
        return System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + "Cache" + Util.FS + CACHEHPX;
    }

    private double[] getValues(long l, long l2, RandomAccessFile randomAccessFile, long l3, long l4) {
        if (this.isPartial && this.ordering.equals("NESTED")) {
            return this.getValuesPartialNested(l, l2);
        }
        if (this.isPartial && this.ordering.equals("RING")) {
            return this.getValuesPartialRing(l, l2);
        }
        if (this.ordering.equals("RING")) {
            return this.getValuesRing(l, l2, this.nSideFile);
        }
        return this.getValuesNested(l, l2, randomAccessFile, l3, l4);
    }

    private double[] getValuesRing(long l, long l2, int n) {
        return this.fillRingBuffer((int)l, (int)l2, n);
    }

    private double[] getValuesNested(long l, long l2, RandomAccessFile randomAccessFile, long l3, long l4) {
        double d = 0.0;
        int n = (int)(l2 - l);
        double[] dArray = new double[n];
        int n2 = n / this.lenHpx[(int)l4];
        if (n2 == 0) {
            n2 = 1;
        }
        int n3 = n2 * this.sizeRecord;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        if (n < this.lenHpx[(int)l4]) {
            n4 = (int)l % this.lenHpx[(int)l4] * Util.binSizeOf(this.typeHpx[(int)l4], 1);
        }
        int n5 = (int)l / this.lenHpx[(int)l4];
        try {
            randomAccessFile.seek(l3 + (long)(n5 * this.sizeRecord) + (long)n4);
            try {
                randomAccessFile.readFully(byArray);
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n2) {
            int n9 = 0;
            for (int i = 0; i < this.nField; ++i) {
                if ((long)i != l4) {
                    n9 += Util.binSizeOf(this.typeHpx[i], this.lenHpx[i]);
                    continue;
                }
                int n10 = n7 + n9;
                for (int j = 0; j < this.lenHpx[i] && n6 < dArray.length; ++j, ++n6) {
                    int n11 = Util.binSizeOf(this.typeHpx[i], j);
                    if (j == 0) {
                        // empty if block
                    }
                    switch (this.typeHpx[i]) {
                        case 'B': {
                            d = PlanHealpix.getByte(byArray, n10 + n11);
                            break;
                        }
                        case 'I': {
                            d = PlanHealpix.getShort(byArray, n10 + n11);
                            break;
                        }
                        case 'J': {
                            d = PlanHealpix.getInt(byArray, n10 + n11);
                            break;
                        }
                        case 'K': {
                            d = (long)PlanHealpix.getInt(byArray, n10 + n11) << 32 | (long)PlanHealpix.getInt(byArray, n10 + n11 + 4) & 0xFFFFFFFFL;
                            break;
                        }
                        case 'E': {
                            d = Float.intBitsToFloat(PlanHealpix.getInt(byArray, n10 + n11));
                            break;
                        }
                        case 'D': {
                            long l5 = (long)PlanHealpix.getInt(byArray, n10 + n11) << 32 | (long)PlanHealpix.getInt(byArray, n10 + n11 + 4) & 0xFFFFFFFFL;
                            d = Double.longBitsToDouble(l5);
                            break;
                        }
                        default: {
                            d = -1.0;
                        }
                    }
                    dArray[n6] = d;
                }
            }
            ++n8;
            n7 += this.sizeRecord;
        }
        return dArray;
    }

    public static long getHealpixMin(int n, long l, int n2, boolean bl) {
        if (bl) {
            return l * (long)Math.pow(4.0, (PlanHealpix.log2(n2) - PlanHealpix.log2(n)) / PlanHealpix.log2(2L));
        }
        return l * (long)Math.pow(4.0, (long)(n2 - n) / PlanHealpix.log2(2L));
    }

    public static long log2(long l) {
        return CDSHealpix.log2(l);
    }

    public static long getFather(long l) {
        return l / 4L;
    }

    private void fillPartialValues(long l) {
        this.partialValues = new HashMap();
        double[] dArray = this.ordering.equals("NESTED") ? this.getValuesNested(0L, this.nbRecordsPartial, this.rafHpx, this.initialOffsetHpx, l) : this.getValuesRing(0L, this.nbRecordsPartial, this.newNSideFile);
        for (int i = 0; i < this.partialHpxPixIdx.length; ++i) {
            this.partialValues.put((long)this.partialHpxPixIdx[i], dArray[i]);
        }
    }

    private double[] getValuesPartialRing(long l, long l2) {
        int n = (int)(l2 - l);
        double[] dArray = new double[n];
        try {
            for (int i = 0; i < n; ++i) {
                Double d = (Double)this.partialValues.get(CDSHealpix.nest2ring(this.nSideFile, l + (long)i));
                dArray[i] = d == null ? Double.NaN : d;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return dArray;
    }

    private double[] getValuesPartialNested(long l, long l2) {
        int n = (int)(l2 - l);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            Double d = (Double)this.partialValues.get(l + (long)i);
            dArray[i] = d == null ? Double.NaN : d;
        }
        return dArray;
    }

    private void fillRingValues(int n, int n2, long l) {
        int n3 = n2 - n + 1;
        this.ringValues = new double[n3];
        int n4 = Math.max(this.nbPixGeneratedImage * this.nbPixGeneratedImage, this.lenHpx[(int)l]);
        int n5 = n;
        int n6 = Math.min(n5 + n4, n2);
        while (n5 < n2) {
            System.arraycopy(this.getValuesNested(n5, n6, this.rafHpx, this.initialOffsetHpx, l), 0, this.ringValues, n5 - n, n6 - n5);
            n6 = Math.min((n5 += n4) + n4, n2);
        }
    }

    private double[] fillRingBuffer(int n, int n2, int n3) {
        int n4 = n2 - n;
        double[] dArray = new double[n4];
        try {
            for (int i = 0; i < n4; ++i) {
                dArray[i] = this.ringValues[(int)CDSHealpix.nest2ring(n3, n + i)];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return dArray;
    }

    boolean buildDoubleHealpix(int n, long l, int n2, Fits fits, long l2, String string) {
        return this.buildDoubleHealpix(n, l, n2, fits, true, l2, string);
    }

    boolean buildDoubleHealpix(int n, long l, int n2, Fits fits, boolean bl, long l2, String string) {
        boolean bl2 = true;
        long l3 = PlanHealpix.getHealpixMin(n, l, n2, true);
        long l4 = l3 + (long)(fits.width * fits.height);
        double[] dArray = this.getValues(l3, l4, this.rafHpx, this.initialOffsetHpx, l2);
        for (int i = 0; i < fits.height; ++i) {
            for (int j = 0; j < fits.width; ++j) {
                long l5 = l3 + (long)this.xy2hpx(i * fits.width + j);
                double d = dArray[(int)(l5 - l3)];
                if (bl2 && !Double.isNaN(d)) {
                    bl2 = false;
                }
                fits.setPixelDouble(j, i, d);
            }
        }
        if (this.isARGB) {
            fits.setARGB();
        }
        if (bl) {
            try {
                String string2 = PlanHealpix.getFilePath(this.getCacheDir() + Util.FS + string, (int)PlanHealpix.log2(n), l) + ".fits";
                if (!bl2) {
                    fits.writeFITS(string2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return !bl2;
    }

    @Override
    protected int getBitpix() {
        return this.curTFormBitpix;
    }

    @Override
    public String getSurveyDir() {
        return this.getCacheDir() + Util.FS + this.dirName;
    }

    public String getFilePath(int n, int n2, long l) {
        return this.getCacheDir() + Util.FS + this.getDirname() + Util.FS + this.dirNameForIdx(n) + Util.FS + "Norder" + n2 + Util.FS + "Dir" + l / 10000L * 10000L + Util.FS + "Npix" + l;
    }

    protected String getAllskyFilePath(int n, int n2) {
        return this.getCacheDir() + Util.FS + this.getDirname() + Util.FS + this.dirNameForIdx(n) + Util.FS + "Norder" + n2 + Util.FS + "Allsky.fits";
    }

    private double getLevelImage(int n, int n2) {
        long l = 12L * (long)n * (long)n;
        long l2 = l / (long)(n2 * n2);
        if (l2 < 1L) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = Math.sqrt(l2 / 12L);
        return Math.log(d) / Math.log(2.0);
    }

    protected boolean hasPolarisationData() {
        if (this.tfieldNames == null) {
            return false;
        }
        List<String> list = Arrays.asList(this.tfieldNames);
        return !(!list.contains("U-POLARISATION") && !list.contains("U_POLARISATION") && !list.contains("U_Stokes") || !list.contains("Q-POLARISATION") && !list.contains("Q_POLARISATION") && !list.contains("Q_Stokes"));
    }

    protected boolean isPartial() {
        return this.isPartial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void displayPolarisation(int n) {
        String string;
        Object object;
        Plan plan;
        block16: {
            plan = null;
            object = this;
            synchronized (object) {
                int n2;
                block15: {
                    if (this.folder != 0) break block15;
                    string = this.label;
                    this.label = this.labelForField(this.idxTFormToRead);
                    n2 = this.aladin.calque.newFolder(string, 0, false);
                    if (n2 < 0) break block16;
                    plan = this.aladin.calque.plan[n2];
                    this.aladin.calque.permute(this, plan);
                    this.aladin.view.newView(1);
                    this.aladin.calque.repaintAll();
                    break block16;
                }
                boolean bl = false;
                for (n2 = this.aladin.calque.plan.length - 1; n2 >= 0; --n2) {
                    if (this.aladin.calque.plan[n2] == this) {
                        bl = true;
                        continue;
                    }
                    if (!bl || this.aladin.calque.plan[n2].type != 11) continue;
                    plan = this.aladin.calque.plan[n2];
                    break;
                }
            }
        }
        object = null;
        try {
            object = this.isLocal ? new MyInputStream(new FileInputStream(this.originalPath)) : new MyInputStream(Util.openStream(this.originalPath));
            object = ((MyInputStream)object).startRead();
            ((MyInputStream)object).getType();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        string = this.labelForField(n);
        PlanHealpix planHealpix = this;
        synchronized (planHealpix) {
            int n3 = this.aladin.calque.newPlanHealpix(this.originalPath, (MyInputStream)object, string, n == -42 ? 1 : 0, n, false);
            Plan plan2 = this.aladin.calque.plan[n3];
            if (plan != null) {
                int n4 = this.aladin.calque.getIndex(plan);
                if (this.aladin.calque.plan[n4 + 1].type == 17) {
                    ++n4;
                }
                this.aladin.calque.permute(plan2, this.aladin.calque.plan[n4]);
                this.aladin.view.newView(1);
                this.aladin.calque.repaintAll();
            }
            if (n == -40) {
                n3 = this.aladin.calque.getIndex(plan2);
                this.aladin.execAsyncCommand("cm @" + n3 + " polarisation");
            } else if (n == -41) {
                n3 = this.aladin.calque.getIndex(plan2);
                this.aladin.execAsyncCommand("cm @" + n3 + " log");
            }
        }
    }

    protected static double[] getPolaAmpMinMax(Fits fits, Fits fits2, boolean bl) {
        String string = "DATAMIN";
        String string2 = "DATAMAX";
        double d = Double.parseDouble(fits2.headerFits.getStringFromHeader(string));
        double d2 = Double.parseDouble(fits2.headerFits.getStringFromHeader(string2));
        double d3 = Double.parseDouble(fits.headerFits.getStringFromHeader(string));
        double d4 = Double.parseDouble(fits.headerFits.getStringFromHeader(string2));
        double d5 = Math.max(Math.abs(d), Math.abs(d2));
        double d6 = Math.max(Math.abs(d3), Math.abs(d4));
        double d7 = 0.0;
        double d8 = Math.sqrt(d5 * d5 + d6 * d6);
        return new double[]{d7, d8};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePolarisationData() {
        Object object = lock;
        synchronized (object) {
            block29: {
                try {
                    long l;
                    File file = new File(this.getCacheDir() + Util.FS + this.getDirname() + Util.FS + this.dirNameForIdx(this.idxTFormToRead) + Util.FS + "Norder3" + Util.FS + "Allsky.fits");
                    if (file.exists() && file.length() > 0L) break block29;
                    File file2 = new File(this.getCacheDir() + Util.FS + this.getDirname() + Util.FS + this.dirNameForIdx(this.idxTFormToRead));
                    if (!file2.exists() && !file2.mkdir()) {
                        System.err.println("Can't create directory " + file2);
                        return;
                    }
                    List<String> list = Arrays.asList(this.tfieldNames);
                    int n = list.indexOf("U-POLARISATION");
                    int n2 = list.indexOf("Q-POLARISATION");
                    if (n < 0) {
                        n = list.indexOf("U_POLARISATION");
                    }
                    if (n2 < 0) {
                        n2 = list.indexOf("Q_POLARISATION");
                    }
                    if (n < 0) {
                        n = list.indexOf("U_Stokes");
                    }
                    if (n2 < 0) {
                        n2 = list.indexOf("Q_Stokes");
                    }
                    if (n < 0 || n2 < 0) {
                        System.err.println("Can't find polarisation indexes");
                        return;
                    }
                    String string = this.getDirname() + Util.FS + this.dirNameForIdx(n);
                    String string2 = this.getDirname() + Util.FS + this.dirNameForIdx(n2);
                    if (this.needProcessing(string, false)) {
                        this.generateHierarchy(n);
                        l = Util.dirSize(new File(string));
                        PlanHealpix.addInCache(l / 1024L);
                        this.writePropertiesFile(string);
                    }
                    if (this.needProcessing(string2, false)) {
                        this.generateHierarchy(n2);
                        l = Util.dirSize(new File(string));
                        PlanHealpix.addInCache(l / 1024L);
                        this.writePropertiesFile(string2);
                    }
                    Fits fits = null;
                    Fits fits2 = new Fits();
                    Fits fits3 = new Fits();
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 1.0;
                    double d4 = 1.0;
                    try {
                        fits3.loadFITS(this.getAllskyFilePath(n, 3));
                        fits2.loadFITS(this.getAllskyFilePath(n2, 3));
                        if (this.idxTFormToRead == -41) {
                            double[] dArray = PlanHealpix.getPolaAmpMinMax(fits2, fits3, true);
                            d2 = dArray[0];
                            d4 = dArray[1];
                            double[] dArray2 = PlanHealpix.getPolaAmpMinMax(fits2, fits3, false);
                            d = dArray2[0];
                            d3 = dArray2[1];
                        } else if (this.idxTFormToRead == -40) {
                            d = -90.0;
                            d2 = -90.0;
                            d3 = 90.0;
                            d4 = 90.0;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    try {
                        if (this.idxTFormToRead != -42) {
                            fits = new Fits(fits3.width, fits3.height, -32);
                        }
                        this.computePolarisation(fits, fits2, fits3, 3, this.npix, true, d2, d4, d, d3, this.idxTFormToRead);
                        fits = null;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    int n3 = (int)PlanHealpix.log2(this.newNSideImage);
                    for (int i = 3; i <= n3; ++i) {
                        int n4 = (int)(12.0 * Math.pow(CDSHealpix.pow2(i), 2.0));
                        for (int j = 0; j < n4; ++j) {
                            try {
                                fits3.loadFITS(this.getFilePath(n, i, j) + ".fits");
                                fits2.loadFITS(this.getFilePath(n2, i, j) + ".fits");
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                continue;
                            }
                            try {
                                if (fits == null && this.idxTFormToRead != -42) {
                                    fits = new Fits(fits3.width, fits3.heightCell, -32);
                                }
                                this.computePolarisation(fits, fits2, fits3, i, j, false, d2, d4, d, d3, this.idxTFormToRead);
                                continue;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    if (this.idxTFormToRead != -42) {
                        this.curTFormBitpix = -32;
                    }
                    this.writePropertiesFile(this.getDirname() + Util.FS + this.dirNameForIdx(this.idxTFormToRead));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void computePolarisation(Fits fits, Fits fits2, Fits fits3, int n, int n2, boolean bl, double d, double d2, double d3, double d4, int n3) throws Exception {
        HeaderFits headerFits;
        String string;
        int n4 = -32;
        int n5 = fits2.width;
        int n6 = fits2.height;
        try {
            string = "XTENSION=IMAGE\nBITPIX=" + n4 + "\nNAXIS=2\nNAXIS1=" + n5 + "\nNAXIS2=" + n6;
            if (n3 != -42) {
                string = string + "\nPIXELMIN=" + d3 + "\nPIXELMAX=" + d4;
                string = string + "\nDATAMIN=" + d + "\nDATAMAX=" + d2;
            }
            headerFits = new HeaderFits(string);
            if (bl) {
                Aladin.trace(3, "Allsky header:\n" + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        if (n3 == -42) {
            fits2.clearExtensions();
            fits2.addFitsExtension(headerFits, fits3.pixels);
            string = bl ? this.getAllskyFilePath(-42, n) : this.getFilePath(-42, n, n2) + ".fits";
            fits2.writeFITS(string);
            return;
        }
        fits.clearExtensions();
        fits.headerFits = headerFits;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                double d5 = fits3.getPixelFull(i, j);
                double d6 = fits2.getPixelFull(i, j);
                double d7 = n3 == -41 ? Math.sqrt(d5 * d5 + d6 * d6) : Math.toDegrees(0.5 * Math.atan2(d5, d6));
                fits.setPixelDouble(i, j, d7);
            }
        }
        String string2 = bl ? this.getAllskyFilePath(n3, n) : this.getFilePath(n3, n, n2) + ".fits";
        fits.writeFITS(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadNewField(int n) {
        int n2;
        Object object;
        Plan plan;
        block12: {
            if (n >= this.nField) {
                return false;
            }
            plan = null;
            object = this;
            synchronized (object) {
                block11: {
                    if (this.folder != 0) break block11;
                    String string = this.label;
                    this.label = this.labelForField(this.idxTFormToRead);
                    n2 = this.aladin.calque.newFolder(string, 0, false);
                    if (n2 < 0) break block12;
                    plan = this.aladin.calque.plan[n2];
                    this.aladin.calque.permute(this, plan);
                    this.aladin.view.newView(1);
                    this.aladin.calque.repaintAll();
                    break block12;
                }
                boolean bl = false;
                for (n2 = this.aladin.calque.plan.length - 1; n2 >= 0; --n2) {
                    if (this.aladin.calque.plan[n2] == this) {
                        bl = true;
                        continue;
                    }
                    if (!bl || this.aladin.calque.plan[n2].type != 11) continue;
                    plan = this.aladin.calque.plan[n2];
                    break;
                }
            }
        }
        object = null;
        try {
            object = this.isLocal ? new MyInputStream(new FileInputStream(this.originalPath)) : new MyInputStream(Util.openStream(this.originalPath));
            object = ((MyInputStream)object).startRead();
            ((MyInputStream)object).getType();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        int n3 = this.aladin.calque.newPlanHealpix(this.originalPath, (MyInputStream)object, this.tfieldNames[n], 0, n, true);
        if (n3 < 0) {
            return false;
        }
        if (plan != null) {
            n2 = this.aladin.calque.getIndex(plan);
            if (this.aladin.calque.plan[n2 + 1].type == 17) {
                ++n2;
            }
            this.aladin.calque.permute(this.aladin.calque.plan[n3], this.aladin.calque.plan[n2]);
            this.aladin.view.newView(1);
            this.aladin.calque.repaintAll();
        }
        return true;
    }

    private String labelForField(int n) {
        if (n == -42) {
            return "Polarisation";
        }
        if (n == -41) {
            return "Amplitude";
        }
        if (n == -40) {
            return "Angle";
        }
        return this.tfieldNames[this.idxTFormToRead];
    }

    public void createAllSky(String string, String string2, int n, int n2) throws Exception {
        Object object;
        int n3;
        int n4;
        long l = System.currentTimeMillis();
        int n5 = (int)CDSHealpix.pow2(n);
        int n6 = 12 * n5 * n5;
        if ((double)n6 / (double)(n4 = (int)Math.sqrt(n6)) != (double)(n3 = (int)((double)n6 / (double)n4))) {
            ++n3;
        }
        int n7 = n2 * n4;
        Aladin.trace(3, "Cr\u00e9ation Allsky " + (this.isARGB ? "ARB " : "") + "order=" + n + ": " + n6 + " losanges (" + n4 + "x" + n3 + " de " + n2 + "x" + n2 + " soit " + n7 + "x" + n3 * n2 + " pixels)...");
        Fits fits = null;
        double d = this.hasBadData ? this.badData : this.blank;
        double d2 = 15.0 / (double)n6;
        for (int i = 0; i < n6; ++i) {
            String string3 = PlanHealpix.getFilePath(string2, n, i);
            object = new Fits();
            String string4 = string + Util.FS + string3;
            this.pourcent += d2;
            try {
                int n8;
                int n9;
                if (!new File(string4 + ".fits").exists()) continue;
                ((Fits)object).loadFITS(string4 + ".fits");
                if (fits == null) {
                    fits = new Fits(n7, n3 * n2, ((Fits)object).bitpix);
                    fits.setBlank(d);
                    fits.setBzero(this.bZero);
                    fits.setBscale(this.bScale);
                    for (n9 = 0; n9 < fits.height; ++n9) {
                        for (n8 = 0; n8 < fits.width; ++n8) {
                            fits.setPixelDouble(n8, fits.height - 1 - n9, d);
                        }
                    }
                }
                n9 = i / n4;
                n8 = i % n4;
                int n10 = ((Fits)object).width / n2;
                if (n10 == 0) {
                    this.createAllSky(string, string2, n, ((Fits)object).width);
                    return;
                }
                for (int j = 0; j < ((Fits)object).width / n10; ++j) {
                    for (int k = 0; k < ((Fits)object).width / n10; ++k) {
                        int n11 = this.isARGB ? j * n10 : ((Fits)object).heightCell - 1 - j * n10;
                        double d3 = ((Fits)object).getPixelDouble(k * n10, n11);
                        if (d3 < this.dataMin) {
                            this.dataMin = d3;
                        } else if (d3 > this.dataMax) {
                            this.dataMax = d3;
                        }
                        int n12 = n8 * n2 + k;
                        int n13 = n9 * n2 + j;
                        fits.setPixelDouble(n12, fits.heightCell - 1 - n13, d3);
                    }
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        String string5 = string + Util.FS + string2 + Util.FS + "Norder" + n + Util.FS + "Allsky";
        if (this.isARGB) {
            fits.setARGB();
        } else {
            int n14 = fits.bitpix;
            object = fits.findAutocutRange();
            fits.headerFits.setKeyValue("PIXELMIN", (double)(n14 > 0 ? (double)((long)object[0]) : object[0]) + "");
            fits.headerFits.setKeyValue("PIXELMAX", (double)(n14 > 0 ? (double)((long)object[1]) : object[1]) + "");
            if (!(object[2] < object[3] && object[2] <= object[0] && object[3] >= object[1])) {
                object[2] = n14 == -64 ? -1.7976931348623157E308 : (n14 == -32 ? -3.4028234663852886E38 : (n14 == 64 ? -9.223372036854776E18 : (n14 == 32 ? -2.147483647E9 : (n14 == 16 ? -32767.0 : 1.0))));
                object[3] = n14 == -64 ? Double.MAX_VALUE : (n14 == -32 ? 3.4028234663852886E38 : (n14 == 64 ? 9.223372036854776E18 : (n14 == 32 ? 2.147483647E9 : (n14 == 16 ? 32767.0 : 255.0))));
                Aladin.trace(1, "createAllSky() data range [DATAMMIN..DATAMAX] not consistante => max possible range");
            }
            fits.headerFits.setKeyValue("DATAMIN", (double)(n14 > 0 ? (double)((long)object[2]) : object[2]) + "");
            fits.headerFits.setKeyValue("DATAMAX", (double)(n14 > 0 ? (double)((long)object[3]) : object[3]) + "");
            Aladin.trace(3, "PIXELMINMAX = [" + (double)object[0] + " " + (double)object[1] + "] DATAMINMAX=[" + (double)object[2] + " " + (double)object[3] + "]");
        }
        fits.writeFITS(string5 + ".fits");
        Aladin.trace(3, "\nConstruction " + string2 + Util.FS + "Norder" + n + Util.FS + "Allsky en " + (int)((System.currentTimeMillis() - l) / 1000L) + "s");
    }

    private int coordsysToFrame(char c) {
        switch (c) {
            case 'C': 
            case 'Q': {
                return 0;
            }
            case 'G': {
                return 3;
            }
            case 'E': {
                return 2;
            }
        }
        return 3;
    }

    private char coordsys(String string) {
        if (string.equals("equatorial")) {
            return 'C';
        }
        if (string.equals("galactic")) {
            return 'G';
        }
        if (string.equals("ecliptic")) {
            return 'E';
        }
        return string.charAt(0);
    }

    @Override
    protected boolean drawAllSky(Graphics graphics, ViewSimple viewSimple) {
        this.local = true;
        return super.drawAllSky(graphics, viewSimple);
    }

    Fits createNodeHpx(String string, int n, long l, Fits[] fitsArray, int n2, double d) throws Exception {
        int n3 = this.nbPixGeneratedImage;
        Fits fits = new Fits(n3, n3, n2);
        fits.setBlank(d);
        fits.setBzero(this.bZero);
        fits.setBscale(this.bScale);
        boolean bl = true;
        double[] dArray = new double[4];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                int n4 = i << 1 | j;
                Fits fits2 = fitsArray[n4];
                int n5 = i * n3 >>> 1;
                int n6 = (1 - j) * n3 >>> 1;
                for (int k = 0; k < n3; k += 2) {
                    for (int i2 = 0; i2 < n3; i2 += 2) {
                        int n7;
                        double d2 = 0.0;
                        int n8 = 0;
                        if (fits2 != null) {
                            for (n7 = 0; n7 < 4; ++n7) {
                                int n9 = n7 == 1 || n7 == 3 ? 1 : 0;
                                int n10 = n7 > 1 ? 1 : 0;
                                dArray[n7] = fits2.getPixelDouble(i2 + n9, k + n10);
                                if (Double.isNaN(dArray[n7]) || dArray[n7] == d) continue;
                                ++n8;
                            }
                        }
                        for (n7 = 0; n7 < 4; ++n7) {
                            if (Double.isNaN(dArray[n7]) || dArray[n7] == d) continue;
                            d2 += dArray[n7] / (double)n8;
                        }
                        if (n8 == 0) {
                            d2 = d;
                        } else {
                            bl = false;
                        }
                        fits.setPixelDouble(n5 + (i2 >>> 1), n6 + (k >>> 1), d2);
                    }
                }
            }
        }
        if (bl) {
            fits = null;
        } else {
            fits.writeFITS(string);
        }
        return fits;
    }

    protected char getCoordsys() {
        return this.coordsys;
    }

    protected int getNSideFile() {
        return this.newNSideFile;
    }
}

