/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.CanvasColorMap;
import cds.aladin.Chaine;
import cds.aladin.Coord;
import cds.aladin.FrameColorMap;
import cds.aladin.FrameHeaderFits;
import cds.aladin.FrameHeaderPDS;
import cds.aladin.GreyMemory;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImageAlgo;
import cds.aladin.PlanImageColor;
import cds.aladin.PlanImageCube;
import cds.aladin.PlanImageHuge;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanImageResamp;
import cds.aladin.PlanMultiCCD;
import cds.aladin.PlaneLoadEvent;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.ResourceNode;
import cds.aladin.ServerAladin;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import cds.image.Hdecomp;
import cds.image.Iqefunc;
import cds.tools.Util;
import healpix.essentials.FastMath;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.zip.Inflater;

public class PlanImage
extends Plan {
    protected static final int PIX_ARGB = 0;
    protected static final int PIX_RGB = 1;
    protected static final int PIX_TRUE = 2;
    protected static final int PIX_256 = 3;
    protected static final int PIX_255 = 4;
    public static final String[] PIX_MODE = new String[]{"RGB composite & transparency", "RGB composite", "true pixel mode & transparency", "256 grey levels", "255 grey levels & transparency"};
    protected int pixMode = -1;
    protected static int LASTID = 0;
    private static float DEFAULT_OPACITITY = 1.0f;
    static String DEFIMG;
    static String LOOKCALIB;
    static String INPROGRESS;
    static String OK;
    static String FAIL;
    static String IMGERR;
    static String ERROR;
    static String CALIBERR;
    static String IMGERR1;
    static String LOADIMG;
    static String HTTPERR;
    static String UNK;
    static String ONEDIM;
    static String NAXIS2;
    static String LOCFILE;
    static String VOAPP;
    public static final int CMGRAY = 0;
    public static final int CMBB = 1;
    public static final int CMA = 2;
    public static final int CMSTERN = 3;
    public static final int VIDEO_NORMAL = 0;
    public static final int VIDEO_INVERSE = 1;
    protected static final int ALADIN = 0;
    protected static final int LOCAL = 1;
    protected static final int OTHER = 2;
    protected static final int COMPUTED = 3;
    protected static final int UNDEF = 0;
    protected static final int FULL = 1;
    protected static final int LOW = 2;
    protected static final int PLATE = 3;
    protected static final int STAND = 4;
    protected static final int UNKNOWN = 0;
    protected static final int JPEG = 1;
    protected static final int FITS = 2;
    protected static final int HFITS = 3;
    protected static final int GFITS = 4;
    protected static final int MRCOMP = 5;
    protected static final int RGB = 6;
    protected static final int NATIVE = 7;
    protected static final int PDS = 8;
    public static final int ASINH = 0;
    public static final int LOG = 1;
    public static final int SQRT = 2;
    public static final int LINEAR = 3;
    public static final int SQR = 4;
    public static final int MULTFCT = 5;
    public static final String[] TRANSFERTFCT;
    protected RandomAccessFile fCache;
    protected byte[] pixels;
    protected byte[] pixelsZoom;
    protected byte[] pixelsOrigin;
    protected ColorModel cm;
    public int typeCM;
    public int[] cmControl;
    public int transfertFct;
    protected double[] hist = new double[256];
    protected boolean flagHist;
    protected int width;
    protected int height;
    public int video;
    protected int bitpix;
    protected int naxis1;
    protected int naxis2;
    protected int npix;
    protected double dataMinFits = 0.0;
    protected double dataMaxFits = 0.0;
    protected double dataMin;
    protected double dataMax;
    protected double pixelMin;
    protected double pixelMax;
    protected boolean isBlank = false;
    protected double blank;
    public double bZero;
    public double bScale = 1.0;
    Obj o = null;
    protected int fmt = 0;
    protected int res = 0;
    protected int orig = 0;
    protected int imgID = -1;
    String status;
    String progress;
    protected ResourceNode imgNode;
    protected PlanMultiCCD planMultiCCD;
    protected Plan forPourcent;
    private InputStream inputStream;
    static int id;
    protected int histID = 0;
    protected int[] lastHistID = new int[]{-1, -1, -1};
    protected String cacheID = null;
    protected boolean cacheFromOriginalFile = false;
    protected long cacheOffset = 0L;
    protected String cacheFileName = null;
    private static int MAXCACHEID;
    private boolean cache = true;
    private boolean lockCacheFree = false;
    protected Image image;
    protected int oImgID = -2;
    protected byte[] onePixelOrigin = null;
    static byte[] tmp_inv;
    protected int offsetLoad = -1;
    protected long tailleLoad = -1L;

    protected PlanImage() {
    }

    protected PlanImage(Aladin aladin, String string, MyInputStream myInputStream) {
        int n = 2;
        int n2 = string.lastIndexOf(Util.FS);
        String string2 = n2 >= 0 ? string.substring(n2 + 1) : string;
        try {
            this.filename = new File(string).getCanonicalPath();
            this.u = new URL("file:" + new File(string).getCanonicalPath());
            this.dis = myInputStream;
        }
        catch (Exception exception) {
            String string3 = string + " " + ERROR + " !\n" + exception;
            Aladin.warning(string3, 1);
            return;
        }
        this.Suite(aladin, 1, string2, null, "", LOCFILE + " [" + string + "]", n, 0, null);
    }

    protected PlanImage(Aladin aladin, MyInputStream myInputStream, String string) {
        int n = 2;
        if (string == null) {
            string = "VOApp";
        }
        this.dis = myInputStream;
        this.Suite(aladin, 1, string, null, "", VOAPP, n, 0, null);
    }

    protected PlanImage(Aladin aladin, InputStream inputStream, String string, String string2) {
        int n = 2;
        if (string == null) {
            string = "";
        }
        this.inputStream = inputStream;
        this.Suite(aladin, 1, string, null, "", string2, n, 0, null);
    }

    protected PlanImage(Aladin aladin, String string, MyInputStream myInputStream, String string2, String string3, Obj obj, ResourceNode resourceNode, boolean bl, boolean bl2, Plan plan) {
        this.doClose = bl2;
        int n = 2;
        this.imgNode = resourceNode;
        this.flagSkip = bl;
        this.forPourcent = plan;
        if (plan != null) {
            this.noBestPlacePost = true;
        }
        this.flagWaitTarget = true;
        if (string != null) {
            int n2 = string.lastIndexOf(Util.FS);
            if (string2 == null) {
                this.setLabel(n2 >= 0 ? string.substring(n2 + 1) : string);
            }
            if (string3 == null) {
                string3 = string;
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        try {
            if (string != null) {
                if (string.startsWith("http:") || string.startsWith("https:") || string.startsWith("ftp:")) {
                    this.u = new URL(string);
                } else {
                    this.filename = new File(string).getCanonicalPath();
                    this.u = new URL("file:" + new File(string).getCanonicalPath());
                }
            } else {
                this.u = null;
            }
            this.dis = myInputStream;
        }
        catch (Exception exception) {
            this.error = "_END_XFITS_";
            String string4 = string + " error !\n" + exception;
            Aladin.warning(string4, 1);
            return;
        }
        this.Suite(aladin, 1, string2, null, "", string3, n, 0, obj);
    }

    protected static void createChaine(Chaine chaine) {
        DEFIMG = "";
        LOOKCALIB = chaine.getString("PILOOKCALIB");
        INPROGRESS = chaine.getString("PIINPROGRESS");
        OK = chaine.getString("PIOK");
        FAIL = chaine.getString("PIFAIL");
        IMGERR = chaine.getString("PIIMGERR");
        ERROR = chaine.getString("PIERROR");
        CALIBERR = chaine.getString("PICALIBERR");
        IMGERR1 = chaine.getString("PIIMGERR1");
        LOADIMG = chaine.getString("PILOADIMG");
        HTTPERR = chaine.getString("PIHTTPERR");
        UNK = chaine.getString("PIUNK");
        ONEDIM = chaine.getString("PIONEDIM");
        NAXIS2 = chaine.getString("PINAXIS2");
        LOCFILE = chaine.getString("PILOCFILE");
        VOAPP = chaine.getString("PIVOAPP");
    }

    protected PlanImage(Aladin aladin, MyInputStream myInputStream, int n, URL uRL, String string, String string2, String string3, String string4, int n2, int n3, Obj obj) {
        this.u = uRL;
        this.dis = myInputStream;
        this.Suite(aladin, n, string, string2, string3, string4, n2, n3, obj);
    }

    protected PlanImage(Aladin aladin, MyInputStream myInputStream, int n, URL uRL, String string, String string2, String string3, String string4, int n2, int n3, Obj obj, ResourceNode resourceNode) {
        this.imgNode = resourceNode;
        this.server = this.server != null ? resourceNode.server : null;
        this.u = uRL;
        this.dis = myInputStream;
        this.Suite(aladin, n, string, string2, string3, string4, n2, n3, obj);
    }

    protected PlanImage(Aladin aladin) {
        this.initImage(aladin);
    }

    protected void initImage(Aladin aladin) {
        this.aladin = aladin;
        this.type = 1;
        this.c = Color.black;
        this.askActive = true;
        this.isOldPlan = true;
        this.cmControl = new int[3];
        this.cmControl[0] = 0;
        this.cmControl[1] = 128;
        this.cmControl[2] = 255;
        this.transfertFct = 3;
        this.opacityLevel = DEFAULT_OPACITITY;
    }

    protected PlanImage(Aladin aladin, PlanImage planImage) {
        this(aladin);
        planImage.copy(this);
    }

    protected void Suite(Aladin aladin, int n, String string, String string2, String string3, String string4, int n2, int n3, Obj obj) {
        this.setLogMode(true);
        this.aladin = aladin;
        this.orig = n;
        this.objet = string2;
        this.param = string3;
        this.fmt = n2;
        this.res = n3;
        this.copyright = string4;
        this.opacityLevel = DEFAULT_OPACITITY;
        this.type = 1;
        this.setLabel(string);
        this.c = Color.black;
        aladin.calque.selectPlan(this);
        this.isBlank = false;
        this.video = aladin.configuration.getCMVideo();
        this.transfertFct = aladin.configuration.getCMFct();
        this.typeCM = aladin.configuration.getCMMap();
        this.o = obj;
        if (this.cmControl == null) {
            this.cmControl = new int[3];
        }
        this.cmControl[0] = 0;
        this.cmControl[1] = 128;
        this.cmControl[2] = 255;
        if (this.dis != null) {
            this.setFmt();
        } else if (n3 == 4) {
            this.fmt = 2;
        }
        if (this.u == null && this.dis == null && this.inputStream == null) {
            return;
        }
        this.threading();
    }

    protected boolean setCacheFromFile(MyInputStream myInputStream) {
        this.cacheOffset = 0L;
        try {
            if (this.filename == null) {
                return false;
            }
            long l = myInputStream.getType();
            if ((l & 1L) == 0L) {
                return false;
            }
            if ((l & 0x30L) != 0L) {
                return false;
            }
            File file = new File(this.filename);
            if (file.isFile() && file.canRead()) {
                this.cacheID = this.filename;
                this.cacheFromOriginalFile = true;
                this.cacheOffset = myInputStream.getPos();
                Aladin.trace(3, "Direct pixel file access [" + this.cacheID + "] pos=" + this.cacheOffset);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    protected void copy(Plan plan) {
        this.copy(plan, false);
    }

    protected void copy(Plan plan, boolean bl) {
        super.copy(plan);
        PlanImage planImage = (PlanImage)plan;
        if (bl) {
            planImage.pixels = this.pixels;
            planImage.cmControl = this.cmControl;
            planImage.cm = this.cm;
        } else {
            try {
                if (this.pixels != null) {
                    planImage.pixels = new byte[this.pixels.length];
                    System.arraycopy(this.pixels, 0, planImage.pixels, 0, this.pixels.length);
                } else {
                    planImage.pixels = null;
                }
            }
            catch (Exception exception) {
                planImage.pixels = null;
            }
            System.arraycopy(this.cmControl, 0, planImage.cmControl, 0, 3);
            planImage.cm = CanvasColorMap.getCM(planImage.cmControl[0], planImage.cmControl[1], planImage.cmControl[2], planImage.video == 1, planImage.typeCM, planImage.transfertFct, planImage.isTransparent());
        }
        planImage.pixMode = this.pixMode;
        planImage.pixelsOrigin = this.pixelsOrigin;
        planImage.projD = null;
        planImage.projInit = null;
        planImage.projd = null;
        if (this.projd != null) {
            planImage.setNewProjD(this.projd.copy());
        }
        planImage.transfertFct = this.transfertFct;
        planImage.headerFits = this.headerFits;
        planImage.width = this.width;
        planImage.height = this.height;
        planImage.naxis1 = this.naxis1;
        planImage.naxis2 = this.naxis2;
        planImage.video = this.video;
        planImage.bitpix = this.bitpix;
        planImage.npix = this.npix;
        planImage.dataMin = this.dataMin;
        planImage.dataMax = this.dataMax;
        planImage.pixelMin = this.pixelMin;
        planImage.pixelMax = this.pixelMax;
        planImage.dataMinFits = this.dataMinFits;
        planImage.dataMaxFits = this.dataMaxFits;
        planImage.isBlank = this.isBlank;
        planImage.blank = this.blank;
        planImage.bZero = this.bZero;
        planImage.bScale = this.bScale;
        planImage.o = this.o;
        planImage.fmt = this.fmt;
        planImage.res = this.res;
        planImage.orig = this.orig;
        planImage.cacheID = this.cacheID;
        planImage.fCache = null;
        planImage.cacheOffset = this.cacheOffset;
        planImage.cacheFromOriginalFile = this.cacheFromOriginalFile;
        planImage.typeCM = this.typeCM;
        planImage.opacityLevel = this.opacityLevel;
    }

    protected boolean crop(double d, double d2, double d3, double d4, boolean bl) {
        int n = 0;
        if (d <= 0.0) {
            d3 += d;
            d = 0.0;
            ++n;
        }
        if (d2 <= 0.0) {
            d4 += d2;
            d2 = 0.0;
            ++n;
        }
        if (d + d3 >= (double)this.width) {
            d3 = (double)this.width - d;
            ++n;
        }
        if (d2 + d4 >= (double)this.height) {
            d4 = (double)this.height - d2;
            ++n;
        }
        if (n == 4) {
            return false;
        }
        int n2 = (int)Math.ceil(d3);
        int n3 = (int)Math.ceil(d4);
        int n4 = (int)Math.floor(d);
        int n5 = (int)Math.floor(d2);
        byte[] byArray = new byte[n2 * n3];
        this.getPixels(byArray, n4, n5, n2, n3);
        this.setBufPixels8(byArray);
        if (this.hasOriginalPixels()) {
            byte[] byArray2 = new byte[n2 * n3 * this.npix];
            if (this.pixelsOrigin == null) {
                this.getPixelsFromCache(byArray2, this.npix, n4, n5, n2, n3);
            } else {
                this.getPixelsOrigin(byArray2, this.npix, n4, n5, n2, n3);
            }
            this.pixelsOrigin = byArray2;
            this.cacheID = null;
            this.noCacheFromOriginalFile();
        }
        this.crop1(d, d2, d3, d4, bl);
        return true;
    }

    protected boolean cropHuge(double d, double d2, double d3, double d4, boolean bl) {
        double d5 = 256.0 / (this.pixelMax - this.pixelMin);
        try {
            int n = (int)Math.ceil(d3);
            int n2 = (int)Math.ceil(d4);
            int n3 = (int)Math.floor(d);
            int n4 = (int)Math.floor(d2);
            int n5 = n * n2;
            this.setBufPixels8(new byte[n5]);
            this.pixelsOrigin = new byte[n5 * this.npix];
            byte[] byArray = new byte[n * this.npix];
            int n6 = n;
            int n7 = 0;
            int n8 = 0;
            this.openCache();
            int n9 = this.naxis2 - (n4 + n2);
            int n10 = 0;
            while ((double)n9 < (double)this.naxis2 - d2) {
                this.fCache.seek(this.cacheOffset + ((long)n9 * (long)this.naxis1 + (long)n3) * (long)this.npix);
                this.fCache.readFully(byArray);
                System.arraycopy(byArray, 0, this.pixelsOrigin, n8, byArray.length);
                n8 += byArray.length;
                for (int i = 0; i < n6; ++i) {
                    double d6 = this.getPixVal(byArray, this.bitpix, i);
                    if (Double.isNaN(d6)) {
                        this.getBufPixels8()[n7++] = 0;
                        continue;
                    }
                    this.getBufPixels8()[n7++] = (byte)(d6 <= this.pixelMin ? 0 : (d6 >= this.pixelMax ? 255 : (int)((d6 - this.pixelMin) * d5) & 0xFF));
                }
                this.setPourcent(99.0 * (double)n10 / d4);
                ++n9;
                ++n10;
            }
            PlanImage.invImageLine(n, n2, this.getBufPixels8());
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            return false;
        }
        this.cacheID = null;
        this.noCacheFromOriginalFile();
        this.crop1(d, d2, d3, d4, bl);
        return true;
    }

    protected void crop1(double d, double d2, double d3, double d4, boolean bl) {
        if (Projection.isOk(this.projd)) {
            this.projd.crop(d, d2, d3, d4);
        }
        this.naxis1 = this.width = (int)Math.ceil(d3);
        this.naxis2 = this.height = (int)Math.ceil(d4);
        this.setHasSpecificCalib();
        this.changeImgID();
        if (bl) {
            this.aladin.view.newView(1);
            this.aladin.calque.repaintAll();
        }
    }

    @Override
    protected String getLogInfo() {
        return (this.transfertFct != 3 ? TRANSFERTFCT[this.transfertFct] + "/" : "") + super.getLogInfo();
    }

    @Override
    protected boolean contains(Coord coord) {
        try {
            this.projd.getXY(coord);
            if (Double.isNaN(coord.x)) {
                return false;
            }
            return !(coord.x < 0.0 || coord.x >= (double)this.naxis1 || coord.y < 0.0) && !(coord.y >= (double)this.naxis2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static boolean sameFmtRes(Plan plan, Plan plan2) {
        PlanImage planImage;
        PlanImage planImage2;
        try {
            planImage2 = (PlanImage)plan;
            planImage = (PlanImage)plan2;
        }
        catch (Exception exception) {
            return false;
        }
        if (planImage2 == null && planImage == null) {
            return true;
        }
        if (planImage2 == null || planImage == null) {
            return false;
        }
        return planImage2.fmt == planImage.fmt && planImage2.res == planImage.res;
    }

    protected String survey() {
        if (this.orig == 0 && (this.param == null || this.param.trim().length() == 0)) {
            return DEFIMG;
        }
        if (this.orig == 0) {
            return ServerAladin.whichQualifier(this.param).trim();
        }
        return this.param;
    }

    protected static String describeFmtRes(MyInputStream myInputStream, int n) {
        String string = null;
        try {
            string = MyInputStream.decodeType(myInputStream.getType());
        }
        catch (Exception exception) {
            string = null;
        }
        String string2 = n == 1 ? "Full resolution" : (n == 2 ? "Low resolution" : (n == 3 ? "Plate view" : (n == 4 ? "(Aladin standalone image)" : null)));
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string + " ");
        }
        if (string2 != null) {
            stringBuffer.append("- " + string2);
        }
        return stringBuffer.toString();
    }

    @Override
    protected String getUrl() {
        if (this.u == null) {
            return null;
        }
        String string = this.u.toString();
        if (this.isAladinJpeg()) {
            string = ServerAladin.change2FITS(string);
        }
        return string;
    }

    protected Color getBackGroundColor() {
        if (this.colorBackground != null) {
            return this.colorBackground;
        }
        return this.isPixel() && this.active && this.video == 0 ? Color.black : Color.white;
    }

    public ColorModel getCM() {
        return this.cm;
    }

    public void restoreCM() {
        IndexColorModel indexColorModel = CanvasColorMap.getCM(this.cmControl[0], this.cmControl[1], this.cmControl[2], this.video == 1, this.typeCM, this.transfertFct, this.isTransparent());
        this.setCM(indexColorModel);
    }

    protected double[] getPixelSize() {
        if (!Projection.isOk(this.projd)) {
            return null;
        }
        try {
            double d = this.projd.getPixResAlpha();
            double d2 = this.projd.getPixResDelta();
            return new double[]{d, d2};
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean isAladinJpeg() {
        return this.orig == 0 && this.fmt == 1;
    }

    protected static String getFormat(int n) {
        return n == 1 ? "JPEG" : (n == 2 ? "FITS" : (n == 4 ? "GFITS" : (n == 3 ? "HFITS" : (n == 5 ? "MRCOMP" : "UNKNOWN"))));
    }

    protected static String getResolution(int n) {
        return n == 1 ? "FULL" : (n == 2 ? "LOW" : (n == 3 ? "PLATE" : (n == 4 ? "STAND" : "UNDEF")));
    }

    protected static int getFmt(String string) {
        return string.equalsIgnoreCase("FITS") ? 2 : (string.equalsIgnoreCase("GFITS") ? 4 : (string.equalsIgnoreCase("HFITS") ? 3 : (string.equalsIgnoreCase("MRCOMP") ? 5 : (string.equalsIgnoreCase("JPEG") ? 1 : 0))));
    }

    protected static int getRes(String string) {
        return string.equalsIgnoreCase("FULL") ? 1 : (string.equalsIgnoreCase("LOW") ? 2 : (string.equalsIgnoreCase("PLATE") ? 3 : (string.equalsIgnoreCase("STAND") ? 4 : 0)));
    }

    protected void resetHist() {
        ++this.histID;
    }

    protected byte[] getPixelHist(int n) {
        return this.pixels;
    }

    protected double[] getHistArray(int n) {
        return this.hist;
    }

    protected long getHistID() {
        return this.histID;
    }

    protected double[] getHist(int n) {
        double d = 0.0;
        double[] dArray = this.getHistArray(n);
        if (this.histID != this.lastHistID[n < 0 ? 0 : n]) {
            int n2;
            this.lastHistID[n < 0 ? 0 : n] = this.histID;
            double[] dArray2 = new double[dArray.length];
            byte[] byArray = this.getPixelHist(n);
            if (byArray == null) {
                return dArray;
            }
            for (n2 = 0; n2 < byArray.length; ++n2) {
                double d2;
                int n3;
                int n4 = n3 = byArray[n2] & 0xFF;
                dArray2[n4] = dArray2[n4] + 1.0;
                if (!(d2 > d)) continue;
                d = d2;
            }
            d = Math.log(d + 1.0);
            for (n2 = 0; n2 < dArray.length; ++n2) {
                dArray[n2] = n2 > 0 && dArray2[n2] == 0.0 ? 0.0 : Math.log(dArray2[n2] + 1.0);
            }
            d += d / 5.0;
            double d3 = byArray.length;
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = dArray[i] * 120.0 / d;
                dArray2[i] = dArray2[i] / d3;
            }
        }
        return dArray;
    }

    @Override
    protected void setPourcent(double d) {
        if (this.forPourcent != null) {
            this.forPourcent.setPourcent(d);
        }
        this.pourcent = d;
    }

    @Override
    protected boolean isSync() {
        return this.flagOk && !this.flagProcessing && !this.flagUpdating || this.error != null;
    }

    @Override
    protected boolean Free() {
        this.aladin.view.free(this);
        super.Free();
        if (this.dis != null) {
            try {
                this.dis.close();
                this.dis = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fCache != null) {
            try {
                this.fCache.close();
                this.fCache = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dataMaxFits = 0.0;
        this.dataMinFits = 0.0;
        this.headerFits = null;
        this.setBufPixels8(null);
        this.pixelsOrigin = null;
        this.pixMode = -1;
        this.removeFromCache();
        this.cacheFromOriginalFile = false;
        this.cacheID = null;
        this.cacheOffset = 0L;
        this.height = -1;
        this.width = -1;
        this.naxis2 = -1;
        this.naxis1 = -1;
        this.setPourcent(-1.0);
        this.tailleLoad = -1L;
        this.cm = null;
        this.res = 0;
        this.fmt = 0;
        this.video = this.aladin.configuration.getCMVideo();
        this.typeCM = this.aladin.configuration.getCMFct();
        this.resetHist();
        this.isBlank = false;
        this.forPourcent = null;
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
        this.forPourcent = null;
        this.planMultiCCD = null;
        this.changeImgID();
        return true;
    }

    private static String getNextCacheID() {
        return "f" + MAXCACHEID++ + ".tmp";
    }

    protected void cacheAvailable(boolean bl) {
        this.cache = bl;
    }

    protected void noCacheFromOriginalFile() {
        this.cacheFromOriginalFile = false;
        this.cacheOffset = 0L;
        this.cacheID = null;
    }

    protected boolean rewriteInCache(byte[] byArray) {
        return this.setInCache(1, byArray);
    }

    private boolean setInCache(byte[] byArray) {
        return this.setInCache(0, byArray);
    }

    private boolean setInCache(int n, byte[] byArray) {
        if (!Aladin.STANDALONE || !this.cache || this.cacheFromOriginalFile) {
            return false;
        }
        if (n != 1 && this.cacheID != null) {
            return true;
        }
        this.cacheOffset = 0L;
        RandomAccessFile randomAccessFile = this.beginInCache(byArray);
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    protected synchronized RandomAccessFile beginInCache(byte[] byArray) {
        if (!Aladin.STANDALONE || !this.cache || this.cacheFromOriginalFile) {
            return null;
        }
        if (byArray == null || !this.aladin.createCache()) {
            return null;
        }
        try {
            if (this.cacheID == null) {
                this.cacheID = Aladin.CACHEDIR + Util.FS + PlanImage.getNextCacheID();
            }
            if (this.fCache != null) {
                try {
                    this.fCache.close();
                    this.fCache = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            File file = new File(this.cacheID);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            int n = 0x400000;
            int n2 = 0;
            for (int i = 0; i < byArray.length; i += n2) {
                n2 = byArray.length - i < n ? byArray.length - i : n;
                randomAccessFile.write(byArray, i, n2);
            }
            this.aladin.setInCache(byArray.length);
            Aladin.trace(3, "Original pixels saved in cache [" + this.cacheID + "]");
            return randomAccessFile;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.cacheID = null;
            return null;
        }
    }

    protected boolean getFromCache() {
        if (!Aladin.STANDALONE) {
            return false;
        }
        if (this.pixelsOrigin != null) {
            return true;
        }
        if (this.cacheID == null) {
            return false;
        }
        try {
            this.openCache();
            this.fCache.seek(this.cacheOffset);
            byte[] byArray = new byte[this.width * this.height * this.npix];
            int n = 0x400000;
            int n2 = 0;
            for (int i = 0; i < byArray.length; i += n2) {
                n2 = byArray.length - i < n ? byArray.length - i : n;
                this.fCache.readFully(byArray, i, n2);
            }
            this.pixelsOrigin = byArray;
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.trace(3, "Original pixels lost [" + this.cacheID + "]");
            this.cacheID = null;
            this.pixelsOrigin = null;
            this.bitpix = 8;
            return false;
        }
        Aladin.trace(3, "Original pixels reloaded " + (this.cacheOffset != 0L ? "offset=" + this.cacheOffset + " " : "") + (this.cacheFromOriginalFile ? "" : "from cache ") + "[" + this.cacheID + "]");
        return true;
    }

    protected boolean getPixelsFromCache(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        if (!Aladin.STANDALONE) {
            return false;
        }
        if (this.cacheID == null) {
            return false;
        }
        try {
            this.openCache();
            int n6 = n4 * n;
            int n7 = this.naxis2 - n3 - n5;
            int n8 = 0;
            while (n7 < this.naxis2 - n3) {
                this.fCache.seek(this.cacheOffset + ((long)n7 * (long)this.naxis1 + (long)n2) * (long)n);
                this.fCache.readFully(byArray, n8 * n4 * n, n6);
                ++n7;
                ++n8;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        Aladin.trace(3, "Original pixel sub-image (" + n2 + "," + n3 + "," + n4 + "," + n5 + ") extracted" + (this.cacheOffset != 0L ? "offset=" + this.cacheOffset + " " : "") + (this.cacheFromOriginalFile ? "" : "from cache ") + "[" + this.cacheID + "]");
        return true;
    }

    protected boolean pixelsOriginFromDisk() {
        if (this.cacheID == null) {
            return false;
        }
        if (this.aladin.view.getPixelMode() == 2) {
            return false;
        }
        return this.naxis1 * this.naxis2 * this.npix > 0x800000;
    }

    protected void openCache() {
        if (this.fCache == null && this.cacheID != null) {
            try {
                File file = new File(this.cacheID);
                this.fCache = new RandomAccessFile(file, "r");
            }
            catch (Exception exception) {
                this.fCache = null;
                this.cacheID = null;
                this.cacheOffset = 0L;
            }
        }
    }

    protected boolean getOnePixelFromCache(byte[] byArray, int n, int n2, int n3) {
        if (!Aladin.STANDALONE) {
            return false;
        }
        if (this.cacheID == null) {
            return false;
        }
        try {
            this.openCache();
            this.fCache.seek(this.cacheOffset + ((long)(this.naxis2 - n3 - 1) * (long)this.naxis1 + (long)n2) * (long)n);
            this.fCache.readFully(byArray, 0, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean cacheCanBeFree() {
        if (this.lockCacheFree) {
            return false;
        }
        Plan[] planArray = this.aladin.calque.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i] == this || !(planArray[i] instanceof PlanImage) || ((PlanImage)planArray[i]).cacheID == null || !((PlanImage)planArray[i]).cacheID.equals(this.cacheID)) continue;
            return false;
        }
        return true;
    }

    protected void setLockCacheFree(boolean bl) {
        this.lockCacheFree = bl;
    }

    private void removeFromCache() {
        block7: {
            block6: {
                if (this.cacheFromOriginalFile || this.cacheID == null) break block6;
                if (Aladin.CACHEDIR == null) break block6;
                if (this.cacheID.startsWith(Aladin.CACHEDIR)) break block7;
            }
            return;
        }
        if (this.cacheCanBeFree()) {
            try {
                File file = new File(this.cacheID);
                this.aladin.setInCache(-file.length());
                file.delete();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Aladin.trace(3, "Original pixels removed from cache [" + this.cacheID + "]");
        }
        this.cacheID = null;
    }

    protected boolean pixelsOriginIntoCache() {
        if (this.pixelsOrigin != null && (this.cacheFromOriginalFile || this.setInCache(this.pixelsOrigin))) {
            Aladin.trace(3, "Original pixels RAM free for " + this.label);
            this.pixelsOrigin = null;
            return true;
        }
        return false;
    }

    protected boolean pixelsOriginFromCache() {
        return this.getFromCache();
    }

    @Override
    synchronized void changeImgID() {
        this.imgID = LASTID++;
        this.pixelsZoom = null;
    }

    synchronized void nextImgID() {
        this.imgID = LASTID++;
    }

    protected int getImgID() {
        return this.imgID;
    }

    protected Image getImage(ViewSimple viewSimple, boolean bl) {
        if (this.oImgID == this.imgID) {
            return this.image;
        }
        this.image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, this.cm, this.getBufPixels8(), 0, this.width));
        this.oImgID = this.imgID;
        return this.image;
    }

    protected void getPixels(byte[] byArray, int n, int n2, int n3, int n4) {
        this.getPixels(byArray, this.pixels, this.width, this.height, n, n2, n3, n4);
    }

    protected void getPixels(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (n3 + n5 > n) {
            n9 = n3 + n5 - n;
            n5 -= n9;
        }
        if (n4 + n6 > n2) {
            n8 = n4 + n6 - n2;
            n6 -= n8;
        }
        int n10 = n4 + n6;
        for (int i = n4; i < n10; ++i) {
            System.arraycopy(byArray2, i * n + n3, byArray, n7, n5);
            n7 += n5 + n9;
        }
    }

    protected void getPixelsOrigin(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = this.height - n3 - n5;
        int n7 = 0;
        while (n6 < this.height - n3) {
            System.arraycopy(this.pixelsOrigin, (n6 * this.width + n2) * n, byArray, n7 * n4 * n, n4 * n);
            ++n6;
            ++n7;
        }
    }

    protected double[][] getPixels() {
        double[][] dArray = new double[this.width][this.height];
        this.getPixels(dArray, 0, 0, this.width, this.height);
        return dArray;
    }

    protected void setPixels(double[][] dArray) {
        this.setPixels(dArray, this.bitpix == 0 ? -32 : this.bitpix);
    }

    protected void setPixels(double[][] dArray, int n) {
        this.naxis1 = this.width = dArray.length;
        this.height = this.width == 0 ? 0 : dArray[0].length;
        this.naxis2 = this.height;
        this.bitpix = n;
        this.npix = Math.abs(n) / 8;
        if (this.pixelsOrigin == null || this.pixelsOrigin.length != this.width * this.height * this.npix) {
            this.pixelsOrigin = new byte[this.width * this.height * this.npix];
        }
        if (this.getBufPixels8() == null || this.getBufPixels8().length != this.width * this.height) {
            this.setBufPixels8(new byte[this.width * this.height]);
        }
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.setPixelOriginInDouble(j, i, dArray[j][i]);
            }
        }
        this.npix = Math.abs(n) / 8;
    }

    protected void reUseOriginalPixels() {
        this.noCacheFromOriginalFile();
        this.rewriteInCache(this.pixelsOrigin);
        this.recut(0.0, 0.0, this.aladin.configuration.getCMCut());
    }

    protected void getPixelsCentroid(double[] dArray, Point point, int n) {
        this.getPixels(dArray, point.x - n / 2, point.y - n / 2, n, n);
        int n2 = n / 2 * n + n / 2;
        double d = dArray[n2];
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] <= d) continue;
            n2 = i;
            d = dArray[i];
        }
        point.y = point.y - n / 2 + n2 / n;
        point.x = point.x - n / 2 + n2 % n;
        this.getPixels(dArray, point.x - n / 2, point.y - n / 2, n, n);
    }

    protected void getPixels(double[] dArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        if (n + n3 > this.width) {
            n6 = n + n3 - this.width;
            n3 -= n6;
        }
        if (n2 + n4 > this.height) {
            n5 = n2 + n4 - this.height;
            n4 -= n5;
        }
        if (this.pixelsOriginFromDisk()) {
            byte[] byArray = new byte[this.npix];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    this.getOnePixelFromCache(byArray, this.npix, j + n, i + n2);
                    dArray[i * n3 + j] = this.getPixVal(this.onePixelOrigin, this.bitpix, 0) * this.bScale + this.bZero;
                }
            }
        } else if (this.hasOriginalPixels() && this.getFromCache()) {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    dArray[i * n3 + j] = this.getPixelOriginInDouble(j + n, i + n2);
                }
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    dArray[i * n3 + j] = this.getBufPixels8()[(this.height - (i + n2) - 1) * this.width + j + n] & 0xFF;
                }
            }
        }
    }

    protected void getPixels(double[][] dArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        if (n + n3 > this.width) {
            n6 = n + n3 - this.width;
            n3 -= n6;
        }
        if (n2 + n4 > this.height) {
            n5 = n2 + n4 - this.height;
            n4 -= n5;
        }
        if (this.hasOriginalPixels() && this.getFromCache()) {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    dArray[j][i] = this.getPixelOriginInDouble(j + n, i + n2);
                }
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    dArray[j][i] = this.getBufPixels8()[(this.height - (i + n2) - 1) * this.width + j + n] & 0xFF;
                }
            }
        }
    }

    protected String getStatus() {
        return this.status + ": " + this.progress;
    }

    protected void close() {
        if (this.dis == null) {
            return;
        }
        try {
            if ((this.dis.getType() & 0x20000L) != 0L) {
                return;
            }
            this.dis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getGluTabCalib(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(2), " >");
        StringBuffer stringBuffer = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("FITS") >= 0 || string2.indexOf("JPEG") >= 0) continue;
            if (string2.indexOf("Image,") == 0) {
                string2 = "Calibration," + string2.substring("Image,".length());
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer("<&");
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string2);
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    private boolean openUrlImage() {
        this.status = LOADIMG;
        this.progress = INPROGRESS;
        Aladin.trace(3, "Load the image at: " + this.u);
        try {
            this.dis = Util.openStream(this.u);
        }
        catch (Exception exception) {
            if (this.orig == 1) {
                // empty if block
            }
            Aladin.trace(3, "Second try for opening the stream due to: " + exception + "...");
            try {
                this.dis = Util.openStream(this.u);
            }
            catch (Exception exception2) {
                if (this.u != null) {
                    System.err.println("Pb with: " + this.u);
                }
                this.error = Aladin.error = HTTPERR;
                Aladin.warning(this.error, 1);
                this.close();
                return false;
            }
        }
        this.setFmt();
        return true;
    }

    protected void setFmt() {
        try {
            long l = this.dis.getType();
            this.fmt = (l & 0x20L) != 0L ? 4 : ((l & 0x10L) != 0L ? 3 : ((l & 8L) != 0L ? 5 : ((l & 0x800000000L) != 0L ? 8 : ((l & MyInputStream.NativeImage()) != 0L ? 1 : 2))));
            this.pixMode = this.fmt == 1 ? 3 : 2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected boolean waitForPlan() {
        if (this.dis == null && this.inputStream != null) {
            try {
                this.dis = new MyInputStream(this.inputStream);
                this.dis = this.dis.startRead();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.callAllListeners(new PlaneLoadEvent(this, PlaneLoadEvent.ERROR, "error"));
                return false;
            }
        }
        try {
            boolean bl;
            if (this.type == 5) {
                return ((PlanImageResamp)this).resample();
            }
            if (this.type == 7) {
                return ((PlanImageAlgo)this).compute();
            }
            Calib calib = null;
            if (this.orig == 1) {
                this.status = LOADIMG;
                this.progress = INPROGRESS;
            }
            if (this.fmt != 5 && this.dis == null && !this.openUrlImage()) {
                this.callAllListeners(new PlaneLoadEvent(this, PlaneLoadEvent.ERROR, "error"));
                return false;
            }
            if (this.fmt == 1 || this instanceof PlanImageColor) {
                bl = this.cacheImageNatif(this.dis);
            } else if (this.fmt == 8) {
                bl = this.cacheImagePDS(this.dis);
            } else if (this.fmt == 2 || this.fmt == 3 || this.fmt == 4) {
                bl = this.cacheImageFits(this.dis);
            } else {
                this.close();
                return false;
            }
            if (!this.flagSkip) {
                if (!bl) {
                    this.status = this.status + ": " + FAIL + "\n";
                    this.progress = "";
                    this.close();
                    return false;
                }
                this.status = this.status + ": " + OK + "\n";
                this.progress = "";
                try {
                    if (this.fmt == 1 || this.fmt == 6) {
                        if (this.dis.hasCommentCalib()) {
                            try {
                                this.headerFits = this.dis.createFrameHeaderFitsFromCommentCalib(this);
                                calib = new Calib(this.headerFits.getHeaderFits());
                            }
                            catch (Exception exception) {
                                this.dis.jpegCalibAddNAXIS(this.width, this.height);
                                this.headerFits = this.dis.createFrameHeaderFitsFromCommentCalib(this);
                                calib = new Calib(this.headerFits.getHeaderFits());
                            }
                            if (calib != null) {
                                Aladin.trace(3, "Reading FITS key words embedded in the comment segment");
                            }
                        }
                        if (calib == null && this.imgNode != null) {
                            calib = this.imgNode.getCalib();
                            if (calib == null) {
                                throw new Exception();
                            }
                            this.setHasSpecificCalib();
                            Aladin.trace(3, "Creating calibration from SIA metadata");
                        }
                        if (calib == null && this.fmt == 1) {
                            try {
                                this.headerFits = this.DSShhh();
                                calib = new Calib(this.headerFits.getHeaderFits());
                                Aladin.trace(3, "Creating calibration from hhh additional file");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (calib == null) {
                            throw new Exception();
                        }
                    } else {
                        calib = new Calib(this.headerFits.getHeaderFits());
                    }
                    if (calib != null) {
                        this.co = calib.getImgCenter();
                        this.setNewProjD(new Projection(2, calib));
                        if (this.objet == null) {
                            this.objet = this.co.getSexa();
                            this.aladin.dialog.setDefaultTarget(this.objet);
                            this.aladin.dialog.setDefaultTaille(this);
                        } else {
                            this.co = null;
                        }
                    }
                }
                catch (Exception exception) {
                    this.error = NOREDUCTION;
                    this.progress = "";
                }
            }
            this.close();
            if (!this.flagSkip) {
                this.setExtName();
                this.changeImgID();
                this.aladin.view.setRepere(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            long l = 0L;
            try {
                l = this.dis.getType();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if ((l & 0x20000L) != 0L) {
                this.error = "_END_XFITS_";
                return false;
            }
            exception.printStackTrace();
            this.error = Aladin.error != null ? Aladin.error : exception.toString();
            Aladin.warning(this.error, 1);
            this.close();
            this.callAllListeners(new PlaneLoadEvent(this, PlaneLoadEvent.ERROR, this.error));
            return false;
        }
        catch (Error error) {
            error.printStackTrace();
            this.error = Aladin.error = error.toString();
            Aladin.warning(this.error + " ", 1);
            this.close();
            this.callAllListeners(new PlaneLoadEvent(this, PlaneLoadEvent.ERROR, this.error));
            return false;
        }
        this.callAllListeners(new PlaneLoadEvent(this, PlaneLoadEvent.SUCCESS, null));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameHeaderFits DSShhh() throws Exception {
        FrameHeaderFits frameHeaderFits;
        RandomAccessFile randomAccessFile = null;
        String string = this.filename;
        string = string.substring(0, string.lastIndexOf(46)) + ".hhh";
        if (!new File(string).exists()) {
            FrameHeaderFits frameHeaderFits2 = null;
            return frameHeaderFits2;
        }
        randomAccessFile = new RandomAccessFile(new File(string), "r");
        byte[] byArray = new byte[(int)randomAccessFile.length()];
        randomAccessFile.readFully(byArray);
        FrameHeaderFits frameHeaderFits3 = frameHeaderFits = new FrameHeaderFits(this, new String(byArray), true);
        return frameHeaderFits3;
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private int[] getMinMaxBean(int[] nArray) {
        int n;
        double d = 0.003;
        double d2 = 0.9995;
        int[] nArray2 = new int[2];
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            n2 += nArray[n];
        }
        nArray2[1] = -1;
        nArray2[0] = -1;
        int n3 = 0;
        for (n = 0; n < nArray.length; ++n) {
            double d3 = (double)(n3 += nArray[n]) / (double)n2;
            if (nArray2[0] == -1) {
                if (!(d3 > d)) continue;
                nArray2[0] = n;
                continue;
            }
            if (!(d3 > d2)) continue;
            nArray2[1] = n;
            break;
        }
        return nArray2;
    }

    public static final int getByte(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    public static final int getShort(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    public static final int getShortLSB(byte[] byArray, int n) {
        return (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static final int getInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static final int getIntLSB(byte[] byArray, int n) {
        return byArray[n + 3] << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static final long getLong(byte[] byArray, int n) {
        return (long)(byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF) << 32 | (long)(byArray[n + 4] << 24 | (byArray[n + 5] & 0xFF) << 16 | (byArray[n + 6] & 0xFF) << 8 | byArray[n + 7] & 0xFF) & 0xFFFFFFFFL;
    }

    public static final long getLongLSB(byte[] byArray, int n) {
        return (long)(byArray[n + 7] << 24 | (byArray[n + 6] & 0xFF) << 16 | (byArray[n + 5] & 0xFF) << 8 | byArray[n + 4] & 0xFF) << 32 | (long)(byArray[n + 3] << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF) & 0xFFFFFFFFL;
    }

    public static final double getFloat(byte[] byArray, int n) {
        return Float.intBitsToFloat(byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF);
    }

    public static final double getDouble(byte[] byArray, int n) {
        long l = (long)(byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF) << 32 | (long)(byArray[n + 4] << 24 | (byArray[n + 5] & 0xFF) << 16 | (byArray[n + 6] & 0xFF) << 8 | byArray[n + 7] & 0xFF) & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l);
    }

    public static final double getPixVal1(byte[] byArray, int n, int n2) {
        try {
            switch (n) {
                case 8: {
                    return PlanImage.getByte(byArray, n2);
                }
                case 16: {
                    return PlanImage.getShort(byArray, n2 * 2);
                }
                case 32: {
                    return PlanImage.getInt(byArray, n2 * 4);
                }
                case 64: {
                    return PlanImage.getLong(byArray, n2 * 8);
                }
                case -32: {
                    return PlanImage.getFloat(byArray, n2 * 4);
                }
                case -64: {
                    return PlanImage.getDouble(byArray, n2 * 8);
                }
                case 17: {
                    return PlanImage.getShortLSB(byArray, n2 * 2);
                }
                case 33: {
                    return PlanImage.getIntLSB(byArray, n2 * 2);
                }
                case 65: {
                    return PlanImage.getLongLSB(byArray, n2 * 2);
                }
            }
            return Double.NaN;
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    protected final double getPixVal(byte[] byArray, int n, int n2) {
        double d = PlanImage.getPixVal1(byArray, n, n2);
        if (this.isBlank && d == this.blank) {
            return Double.NaN;
        }
        return d;
    }

    public static final void setInt(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(0xFF & n2 >>> 24);
        byArray[n + 1] = (byte)(0xFF & n2 >>> 16);
        byArray[n + 2] = (byte)(0xFF & n2 >>> 8);
        byArray[n + 3] = (byte)(0xFF & n2);
    }

    protected static final void setIntLSB(byte[] byArray, int n, int n2) {
        byArray[n + 3] = (byte)(0xFF & n2 >>> 24);
        byArray[n + 2] = (byte)(0xFF & n2 >>> 16);
        byArray[n + 1] = (byte)(0xFF & n2 >>> 8);
        byArray[n] = (byte)(0xFF & n2);
    }

    public static final void setPixVal(byte[] byArray, int n, int n2, double d) {
        switch (n) {
            case 8: {
                byArray[n2] = (byte)(0xFF & (int)d);
                break;
            }
            case 16: {
                int n3 = (int)d;
                byArray[n2 *= 2] = (byte)(0xFF & n3 >>> 8);
                byArray[n2 + 1] = (byte)(0xFF & n3);
                break;
            }
            case 32: {
                PlanImage.setInt(byArray, n2 *= 4, (int)d);
                break;
            }
            case 64: {
                long l = (long)d;
                int n4 = (int)(0xFFFFFFFFL & l >>> 32);
                PlanImage.setInt(byArray, n2 *= 8, n4);
                n4 = (int)(0xFFFFFFFFL & l);
                PlanImage.setInt(byArray, n2 + 4, n4);
                break;
            }
            case -32: {
                int n5 = Float.floatToIntBits((float)d);
                PlanImage.setInt(byArray, n2 *= 4, n5);
                break;
            }
            case -64: {
                long l = Double.doubleToLongBits(d);
                int n6 = (int)(0xFFFFFFFFL & l >>> 32);
                PlanImage.setInt(byArray, n2 *= 8, n6);
                n6 = (int)(0xFFFFFFFFL & l);
                PlanImage.setInt(byArray, n2 + 4, n6);
                break;
            }
            case 17: {
                int n7 = (int)d;
                byArray[(n2 *= 2) + 1] = (byte)(0xFF & n7 >>> 8);
                byArray[n2] = (byte)(0xFF & n7);
                break;
            }
            case 33: {
                PlanImage.setIntLSB(byArray, n2 *= 4, (int)d);
                break;
            }
            case 65: {
                long l = (long)d;
                int n8 = (int)(0xFFFFFFFFL & l >>> 32);
                PlanImage.setIntLSB(byArray, n2 *= 8, n8);
                n8 = (int)(0xFFFFFFFFL & l);
                PlanImage.setIntLSB(byArray, n2 + 4, n8);
            }
        }
    }

    protected void copyPixVal(byte[] byArray, int n, byte[] byArray2, int n2) {
        System.arraycopy(byArray, n * this.npix, byArray2, n2 * this.npix, this.npix);
    }

    protected final boolean setTransfertFct(int n) {
        return this.setTransfertFct(n, false);
    }

    protected final boolean setTransfertFct(int n, boolean bl) {
        int n2 = this.transfertFct;
        boolean bl2 = true;
        this.transfertFct = n;
        if (!bl2) {
            this.transfertFct = n2;
        }
        return bl2;
    }

    protected double getInvPixel(double d) {
        return this.pixelMin + d * (this.pixelMax - this.pixelMin) / 256.0;
    }

    protected double getGreyPixel(double d) {
        return (d - this.pixelMin) * 256.0 / (this.pixelMax - this.pixelMin);
    }

    protected byte[] getPix8Bits(byte[] byArray, byte[] byArray2, int n, int n2, int n3, double d, double d2, boolean bl, int n4, int n5, int n6) {
        this.findMinMax(byArray2, n, n2, n3, d, d2, bl, n4, n5, n6, 0);
        if (byArray == null) {
            byArray = new byte[n2 * n3];
        }
        int n7 = Math.abs(n / 8);
        this.to8bits(byArray, 0, byArray2, byArray2.length / n7, n, this.pixelMin, this.pixelMax, true);
        return byArray;
    }

    @Override
    protected boolean isOnPixel(int n, int n2) {
        byte by = this.getPixel8Byte(n, n2);
        return by >= 20;
    }

    protected boolean isBlank(int n) {
        return this.isBlank && (double)n == this.blank;
    }

    protected boolean isBlank(double d) {
        return this.isBlank && d == this.blank || Double.isNaN(d);
    }

    protected boolean isInside(int n, int n2) {
        return n >= 0 && n < this.naxis1 && n2 >= 0 && n2 < this.naxis2;
    }

    protected void findMinMax(byte[] byArray, int n, int n2, int n3, double d, double d2, boolean bl, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        boolean bl2;
        boolean bl3 = bl2 = n7 > 0 || d != 0.0 && d2 != 0.0;
        if (!(this instanceof PlanImageCube) && !(this instanceof PlanImageRGB)) {
            this.setPourcent(75.0);
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (n6 <= 0) {
            int n15 = (int)((double)n2 * 0.05);
            int n16 = (int)((double)n3 * 0.05);
            if (n2 - 2 * n15 > 1000) {
                n15 = (n2 - 1000) / 2;
            }
            if (n3 - 2 * n16 > 1000) {
                n16 = (n3 - 1000) / 2;
            }
            n14 = n16;
            n13 = n3 - n16;
            n12 = n15;
            n11 = n2 - n15;
        } else {
            n12 = n4 - n6 / 2;
            n11 = n4 + n6;
            n14 = n5 - n6 / 2;
            n13 = n5 + n6;
            if (n12 < 0) {
                n12 = 0;
            }
            if (n11 >= n2) {
                n11 = n2 - 1;
            }
            if (n14 < 0) {
                n14 = 0;
            }
            if (n13 >= n3) {
                n13 = n3 - 1;
            }
        }
        if (!(bl || d == 0.0 && d2 == 0.0)) {
            d3 = d2;
            d5 = d;
        } else {
            n10 = 1;
            for (n9 = n14; n9 < n13; ++n9) {
                for (n8 = n12; n8 < n11; ++n8) {
                    double d7 = this.getPixVal(byArray, n, n9 * n2 + n8);
                    if (this.isBlank(d7) || bl2 && (d7 < d || d7 > d2)) continue;
                    if (n10 != 0) {
                        d5 = d6 = d7;
                        d4 = d6;
                        d3 = d6;
                        n10 = 0;
                    }
                    if (d5 > d7) {
                        d5 = d7;
                    } else if (d3 < d7) {
                        d3 = d7;
                    }
                    if (d7 < d6 && d7 > d5 || d6 == d5 && d7 < d4) {
                        d6 = d7;
                        continue;
                    }
                    if (!(d7 > d4 && d7 < d3) && (d4 != d3 || !(d7 > d6))) continue;
                    d4 = d7;
                }
            }
            if (bl && d3 - d5 > 256.0) {
                if (d6 - d5 > d4 - d6 && d6 != Double.MAX_VALUE && d6 != d3) {
                    d5 = d6;
                }
                if (d3 - d4 > d4 - d6 && d4 != -1.7976931348623157E308 && d4 != d5) {
                    d3 = d4;
                }
            }
        }
        if (bl) {
            if (!(this instanceof PlanImageCube || this instanceof PlanImageHuge || this instanceof PlanImageRGB)) {
                this.setPourcent(80.0);
            }
            n10 = 10000;
            double d8 = (d3 - d5) / (double)n10;
            int[] nArray = new int[n10];
            for (n9 = n14; n9 < n13; ++n9) {
                for (int i = n12; i < n11; ++i) {
                    double d9 = this.getPixVal(byArray, n, n9 * n2 + i);
                    if (this.isBlank(d9)) continue;
                    n8 = (int)((d9 - d5) / d8);
                    if (n8 == nArray.length) {
                        --n8;
                    }
                    if (n8 >= nArray.length || n8 < 0) continue;
                    int n17 = n8;
                    nArray[n17] = nArray[n17] + 1;
                }
            }
            int[] nArray2 = this.getMinMaxBean(nArray);
            if (nArray2[0] == -1 || nArray2[1] == -1) {
                d6 = this.dataMinFits;
                d4 = this.dataMaxFits;
            } else {
                d6 = d5;
                d4 = (double)nArray2[1] * d8 + d6;
                d6 += (double)nArray2[0] * d8;
            }
            if (nArray2[0] != -1 && nArray2[0] > nArray2[1] - 5 && n7 < 3) {
                if (d6 > d5) {
                    d5 = d6;
                }
                if (d4 < d3) {
                    d3 = d4;
                }
                this.findMinMax(byArray, n, n2, n3, d5, d3, bl, n4, n5, n6, n7 + 1);
                return;
            }
            d5 = d6;
            d3 = d4;
        }
        if (Aladin.levelTrace >= 4 && (!(this instanceof PlanImageCube) || bl)) {
            Aladin.trace(4, "PlanImage.findMinMax(minCut=" + d + ",maxCut" + d2 + ",autocut=" + bl + ",ntest=" + n7 + ") => min=" + d5 + " max=" + d3);
        }
        this.pixelMin = d5;
        this.pixelMax = d3;
        if (!bl) {
            this.dataMin = this.pixelMin;
            this.dataMax = this.pixelMax;
        }
    }

    public boolean isTransparent() {
        return this.pixMode != 3 && this.pixMode != 1;
    }

    protected final void to8bits(byte[] byArray, int n, byte[] byArray2, int n2, int n3, double d, double d2, boolean bl) {
        int n4;
        int n5 = this.isTransparent() ? 255 : 256;
        int n6 = n4 = this.isTransparent() ? 1 : 0;
        if (bl) {
            this.dataMin = Double.MAX_VALUE;
            this.dataMax = -1.7976931348623157E308;
        }
        double d3 = (double)n5 / (d2 - d);
        --n5;
        for (int i = 0; i < n2; ++i) {
            double d4 = this.getPixVal(byArray2, n3, i);
            if (this.isBlank(d4)) {
                byArray[i + n] = 0;
                continue;
            }
            if (bl) {
                if (d4 > this.dataMax) {
                    this.dataMax = d4;
                } else if (d4 < this.dataMin) {
                    this.dataMin = d4;
                }
            }
            byArray[i + n] = (byte)(n4 + (d4 <= d ? 0 : (d4 >= d2 ? n5 : (int)((d4 - d) * d3))) & 0xFF);
        }
    }

    protected void calculPixelsZoom() {
        this.calculPixelsZoom(this.getBufPixels8());
    }

    protected void calculPixelsZoom(byte[] byArray) {
        int n = this.aladin.calque.zoom.zoomView.getWidth();
        int n2 = this.aladin.calque.zoom.zoomView.getHeight();
        if (this.pixelsZoom == null || this.pixelsZoom.length != n * n) {
            this.pixelsZoom = new byte[n * n2];
        }
        double d = Math.max((double)this.width / (double)n, (double)this.height / (double)n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = (int)((double)j * d + 0.5);
                int n4 = (int)((double)i * d + 0.5);
                this.pixelsZoom[i * n + j] = n3 >= this.width || n4 >= this.height ? (byte)0 : byArray[n4 * this.width + n3];
            }
        }
    }

    protected String X(double d) {
        if (Double.isNaN(d)) {
            return "";
        }
        if (this.bitpix > 0) {
            return Util.myRound(d + "");
        }
        return this.Y(d);
    }

    protected String Y(double d) {
        if (Double.isNaN(d)) {
            return "";
        }
        return Util.myRound(d);
    }

    protected String getPixelCodingInfo(int n) {
        String string = n == -64 ? "double" : (n == -32 ? "float" : (n == 64 ? "long" : (n == 65 ? "LSB-long" : (n == 32 ? "integer" : (n == 32 ? "LSB-integer" : (n == 16 ? "short" : (n == 17 ? "LSB-short" : (n == 8 ? "byte" : "unknown"))))))));
        return string + (n % 2 == 0 ? " (bitpix=" + n + ")" : "");
    }

    protected String getPixModeInfo() {
        return PIX_MODE[this.pixMode];
    }

    protected String getSizeInfo() {
        return this.naxis1 + "x" + this.naxis2 + " / encoding:" + this.getPixelCodingInfo(this.bitpix) + " / " + Util.getUnitDisk(this.naxis1 * this.naxis2 * this.npix);
    }

    protected String getPixelInfo(int n, int n2, int n3) {
        if (!this.flagOk || n2 < 0 || n2 >= this.height || n < 0 || n >= this.width) {
            return "";
        }
        switch (n3) {
            case 0: {
                return Util.align3(this.getBufPixels8()[n2 * this.width + n] & 0xFF);
            }
            case 2: {
                return this.pixelsOrigin == null ? UNK : this.X(this.getPixVal(this.pixelsOrigin, this.bitpix, (this.height - n2 - 1) * this.width + n));
            }
            case 1: 
            case 3: {
                if (this.fmt == 1) {
                    return UNK;
                }
                if (this.type != 16 && this.pixelsOrigin != null) {
                    double d = this.getPixVal(this.pixelsOrigin, this.bitpix, (this.height - n2 - 1) * this.width + n) * this.bScale + this.bZero;
                    if (Aladin.levelTrace < 4 || n3 == 3) {
                        return this.Y(d);
                    }
                    double d2 = PlanImage.getPixVal1(this.pixelsOrigin, this.bitpix, (this.height - n2 - 1) * this.width + n);
                    return this.Y(d) + (Double.isNaN(d2) || d != d2 ? "(" + d2 + ")" : "") + (this.isBlank && d2 == this.blank ? " BLANK" : "");
                }
                if (!this.pixelsOriginFromDisk()) {
                    return UNK;
                }
                if (this.onePixelOrigin == null) {
                    this.onePixelOrigin = new byte[this.npix];
                }
                if (!this.getOnePixelFromCache(this.onePixelOrigin, this.npix, n, n2)) {
                    return UNK;
                }
                double d = this.getPixVal(this.onePixelOrigin, this.bitpix, 0) * this.bScale + this.bZero;
                if (Aladin.levelTrace < 4 || n3 == 3) {
                    return this.Y(d);
                }
                double d3 = PlanImage.getPixVal1(this.onePixelOrigin, this.bitpix, 0);
                return this.Y(d) + (Double.isNaN(d3) || d != d3 ? "(" + d3 + ")" : "") + (this.isBlank && d3 == this.blank ? " BLANK" : "");
            }
        }
        return null;
    }

    protected double getPixel(int n, int n2) {
        if (this.pixelsOrigin == null && !this.isBigImage() || this.fmt == 1) {
            return this.getBufPixels8()[(this.height - n2 - 1) * this.width + n] & 0xFF;
        }
        try {
            double d = this.getPixVal(this.pixelsOrigin, this.bitpix, n2 * this.width + n);
            if (Double.isNaN(d)) {
                return Double.NaN;
            }
            return d * this.bScale + this.bZero;
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    protected double[] getPixelStats(Point point) {
        int n = 32;
        double[] dArray = new double[n * n];
        int n2 = 0;
        for (int i = point.y - n / 2; i < point.y + n / 2; ++i) {
            for (int j = point.x - n / 2; j < point.x + n / 2; ++j) {
                dArray[n2++] = this.getPixelInDouble(j, i);
            }
        }
        double[] dArray2 = new double[8];
        double[] dArray3 = new double[8];
        int n3 = Iqefunc.iqe(dArray, n, n, dArray2, dArray3);
        if (n3 != 0) {
            Aladin.trace(4, "PlanImage.getPixelStats(" + point.x + "," + point.y + ") : Iqefunc error: code " + n3);
            return null;
        }
        Aladin.trace(4, "PlanImage.getPixelStats(" + point.x + "," + point.y + ") : mean=(" + dArray2[0] + "," + dArray2[2] + " fwhm=" + dArray2[1] + "," + dArray2[3] + " symetryAngle=" + dArray2[4] + " objectPeak=" + dArray2[5] + " meanBackground=" + dArray2[6]);
        dArray2[0] = (float)((double)point.x + 0.5 + (dArray2[0] - (double)(n / 2)));
        dArray2[2] = (float)((double)point.y + 0.5 + (dArray2[2] - (double)(n / 2)));
        return dArray2;
    }

    protected boolean isIn(int n, int n2) {
        return n >= 0 && n < this.width && n2 >= 0 && n2 <= this.height;
    }

    protected double getPixelInDouble(int n, int n2) {
        if (this.pixelsOrigin == null && !this.isBigImage() || this.fmt == 1) {
            return this.getBufPixels8()[n2 * this.width + n] & 0xFF;
        }
        if (this.pixelsOriginFromDisk()) {
            if (this.onePixelOrigin == null) {
                this.onePixelOrigin = new byte[this.npix];
            }
            if (!this.getOnePixelFromCache(this.onePixelOrigin, this.npix, n, n2)) {
                return Double.NaN;
            }
            return this.getPixVal(this.onePixelOrigin, this.bitpix, 0) * this.bScale + this.bZero;
        }
        return this.getPixVal(this.pixelsOrigin, this.bitpix, (this.height - n2 - 1) * this.width + n) * this.bScale + this.bZero;
    }

    protected double getPixelOriginInDouble(int n, int n2) {
        if (this.pixelsOrigin == null || this.fmt == 1) {
            return Double.NaN;
        }
        try {
            return this.getPixVal(this.pixelsOrigin, this.bitpix, n2 * this.width + n) * this.bScale + this.bZero;
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    protected void setPixelOriginInDouble(int n, int n2, double d) {
        PlanImage.setPixVal(this.pixelsOrigin, this.bitpix, n2 * this.width + n, (d - this.bZero) / this.bScale);
    }

    public static String getTransfertFctInfo(int n) {
        return TRANSFERTFCT[n];
    }

    public String getTransfertFctInfo() {
        return PlanImage.getTransfertFctInfo(this.transfertFct);
    }

    public static int getTransfertFct(String string) {
        return Util.indexInArrayOf(string, TRANSFERTFCT, true);
    }

    public String getDataMinInfo() {
        return this.hasAvailablePixels() ? this.getSpecialPixel(this.dataMin) : "???";
    }

    public String getDataMaxInfo() {
        return this.hasAvailablePixels() ? this.getSpecialPixel(this.dataMax) : "???";
    }

    public String getPixelMinInfo() {
        return this.hasAvailablePixels() ? this.getSpecialPixel(this.pixelMin) : "???";
    }

    public String getPixelMaxInfo() {
        return this.hasAvailablePixels() ? this.getSpecialPixel(this.pixelMax) : "???";
    }

    protected String getSpecialPixel(double d) {
        if (this.aladin.view.getPixelMode() == 2) {
            return this.X(d);
        }
        return this.Y(d * this.bScale + this.bZero);
    }

    protected int getTransfertFct() {
        return this.transfertFct;
    }

    public double getPixelMin() {
        return this.pixelMin * this.bScale + this.bZero;
    }

    public double getPixelMax() {
        return this.pixelMax * this.bScale + this.bZero;
    }

    public double getPixelMiddle() {
        return this.getInvPixel(this.cmControl[1]) * this.bScale + this.bZero;
    }

    protected int getBitpix() {
        return this.bitpix;
    }

    public double getCutMin() {
        return this.pixelMin;
    }

    public double getCutMax() {
        return this.pixelMax;
    }

    public double getDataMin() {
        return this.dataMin;
    }

    public double getDataMax() {
        return this.dataMax;
    }

    protected String getPixelInfoFromGrey(int n) {
        return this.getPixelInfoFromGrey(n, this.aladin.view.getPixelMode());
    }

    protected String getPixelInfoFromGrey(int n, int n2) {
        if (n < 0 || n > 255) {
            return "";
        }
        switch (n2) {
            case 0: {
                return n + "";
            }
            case 2: {
                return this.X(this.getInvPixel(n));
            }
            case 1: {
                return this.Y(this.getInvPixel(n) * this.bScale + this.bZero);
            }
        }
        return null;
    }

    protected double getPixelValue(String string) {
        double d = Double.valueOf(string);
        d = (d - this.bZero) / this.bScale;
        return d;
    }

    public int getPixel8(int n, int n2) {
        return this.pixels[n2 * this.width + n] & 0xFF;
    }

    protected byte getPixel8Byte(int n, int n2) {
        return this.pixels == null ? (byte)0 : this.pixels[n2 * this.width + n];
    }

    protected String getDateObs() {
        if (!this.hasFitsHeader()) {
            return null;
        }
        String string = this.headerFits.getStringFromHeader("EPOCH");
        if (string == null) {
            this.headerFits.getStringFromHeader("DATE-OBS");
        } else {
            string = "J" + string;
        }
        return string;
    }

    @Override
    protected boolean hasFitsHeader() {
        return this.headerFits != null;
    }

    @Override
    protected boolean hasOriginalPixels() {
        return this.fmt != 1 && (this.pixelsOrigin != null || this.cacheID != null);
    }

    protected void noOriginalPixels() {
        this.pixelsOrigin = null;
        this.cacheID = null;
    }

    protected byte[] getFits8Pixels() {
        byte[] byArray = new byte[this.getBufPixels8().length];
        System.arraycopy(this.getBufPixels8(), 0, byArray, 0, this.getBufPixels8().length);
        PlanImage.invImageLine(this.width, this.height, byArray);
        return byArray;
    }

    protected synchronized byte[] getFitsPixels() {
        if (!this.hasOriginalPixels()) {
            return null;
        }
        boolean bl = false;
        if (this.pixelsOrigin == null) {
            this.getFromCache();
            bl = true;
        }
        byte[] byArray = this.pixelsOrigin;
        if (bl) {
            this.pixelsOrigin = null;
        }
        return byArray;
    }

    protected void flip(int n) {
        this.setLockCacheFree(true);
        try {
            this.pixelsOriginFromCache();
            if (n == 0 || n == 2) {
                PlanImage.invImageLine(this.width, this.height, this.getBufPixels8());
                if (this.pixelsOrigin != null) {
                    PlanImage.invImageLine(this.width, this.height, this.pixelsOrigin, this.npix);
                }
            }
            if (n == 1 || n == 2) {
                PlanImage.invImageRow(this.width, this.height, this.getBufPixels8());
                if (this.pixelsOrigin != null) {
                    PlanImage.invImageRow(this.width, this.height, this.pixelsOrigin, this.npix);
                }
            }
            if (this.pixelsOrigin != null) {
                this.reUseOriginalPixels();
            }
        }
        finally {
            this.setLockCacheFree(false);
        }
        this.calculPixelsZoom();
        this.aladin.calque.zoom.zoomView.repaint();
        if (Projection.isOk(this.projd)) {
            this.projd.flip(n);
        }
        this.changeImgID();
    }

    public static void invImageLine(int n, int n2, byte[] byArray) {
        PlanImage.invImageLine(n, n2, byArray, 1);
    }

    public static void invImageLine(int n, int n2, byte[] byArray, int n3) {
        byte[] byArray2 = new byte[n * n3];
        for (int i = n2 / 2 - 1; i >= 0; --i) {
            int n4 = i * n * n3;
            int n5 = (n2 - i - 1) * n * n3;
            System.arraycopy(byArray, n4, byArray2, 0, n * n3);
            System.arraycopy(byArray, n5, byArray, n4, n * n3);
            System.arraycopy(byArray2, 0, byArray, n5, n * n3);
        }
        byArray2 = null;
    }

    protected static void invImageRow(int n, int n2, byte[] byArray) {
        PlanImage.invImageRow(n, n2, byArray, 1);
    }

    protected static void invImageRow(int n, int n2, byte[] byArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            int n4 = i * n * n3;
            for (int j = n / 2 - 1; j >= 0; --j) {
                int n5 = n4 + (n - j - 1) * n3;
                System.arraycopy(byArray, n4 + j * n3, tmp_inv, 0, n3);
                System.arraycopy(byArray, n5, byArray, n4 + j * n3, n3);
                System.arraycopy(tmp_inv, 0, byArray, n5, n3);
            }
        }
    }

    protected boolean cacheImageNatif(MyInputStream myInputStream) {
        ImageProducer imageProducer = null;
        Date date = new Date();
        Aladin.trace(2, "Loading Native image");
        Image image = this.aladin.getToolkit().createImage(myInputStream.readFully());
        this.aladin.waitImage(image);
        if (this.width == 0) {
            this.naxis1 = this.width = image.getWidth(this.aladin);
            this.naxis2 = this.height = image.getHeight(this.aladin);
        }
        imageProducer = image.getSource();
        Date date2 = new Date();
        int n = (int)(date2.getTime() - date.getTime());
        date = date2;
        Aladin.trace(3, " => Waiting for server during " + n + " ms");
        this.setPourcent(10.0);
        this.pixelsOrigin = new byte[this.width * this.height];
        GreyMemory greyMemory = new GreyMemory(imageProducer, this.pixelsOrigin);
        if (!greyMemory.waitImage()) {
            return false;
        }
        this.setPourcent(66.0);
        date2 = new Date();
        n = (int)(date2.getTime() - date.getTime());
        date = date2;
        Aladin.trace(3, " => Loading in " + n + " ms");
        this.bitpix = 8;
        this.npix = 1;
        this.setBufPixels8(this.getPix8Bits(null, this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, this.aladin.configuration.getCMCut(), 0, 0, 0));
        date2 = new Date();
        n = (int)(date2.getTime() - date.getTime());
        date = date2;
        Aladin.trace(3, " => Autocutting in " + n + " ms");
        this.creatDefaultCM();
        this.setPourcent(99.0);
        this.calculPixelsZoom();
        return true;
    }

    protected boolean cacheImageFits(URL uRL) throws Exception {
        Date date = new Date();
        try {
            this.dis = Util.openStream(uRL);
        }
        catch (Exception exception) {
            this.sendLog("Error", "cacheImageFits(" + (uRL == null ? "null" : uRL.toString()) + ") [" + exception + "]");
            return false;
        }
        Date date2 = new Date();
        int n = (int)(date2.getTime() - date.getTime());
        date = date2;
        Aladin.trace(3, " => Waiting for server during " + n + " ms");
        this.setFmt();
        return this.cacheImageFits(this.dis);
    }

    @Override
    protected String getProgress() {
        if (!this.flagOk && this.error == null && this.pourcent >= 0.0 && this.tailleLoad > 0L) {
            return "  - " + (int)this.pourcent + "% of " + this.tailleLoad / 1024L + "KB ...";
        }
        return super.getProgress();
    }

    protected String getBlankString() {
        return !this.isBlank ? "--" : (Double.isNaN(this.blank) ? "NaN" : "" + this.blank);
    }

    protected void setBlankString(String string) {
        block3: {
            try {
                String string2 = string.trim();
                this.blank = string2.equalsIgnoreCase("NaN") ? Double.NaN : Double.parseDouble(string2);
                this.isBlank = true;
                if (this.pixMode == 3) {
                    this.pixMode = 4;
                }
            }
            catch (Exception exception) {
                this.isBlank = false;
                this.blank = Double.NaN;
                if (this.pixMode != 4) break block3;
                this.pixMode = 3;
            }
        }
        this.recut(this.pixelMin, this.pixelMax, false);
        this.restoreCM();
        this.changeImgID();
    }

    protected boolean recut() {
        return this.recut(this.pixelMin, this.pixelMax, false);
    }

    protected boolean recut(double d, double d2, boolean bl) {
        if (d == -1.0 && d2 == -1.0) {
            d = this.dataMinFits;
            d2 = this.dataMaxFits;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (bl && Projection.isOk(this.projd)) {
            Coord coord = new Coord(this.aladin.view.repere.raj, this.aladin.view.repere.dej);
            this.projd.getXY(coord);
            n = (int)coord.x;
            n2 = n3 = (int)coord.y;
            ViewSimple viewSimple = this.aladin.view.getCurrentView();
            if (viewSimple.pref == this) {
                try {
                    n4 = (int)(viewSimple.getTaille() / this.projd.getPixResDelta()) / 2;
                    n2 = ((PlanImage)viewSimple.pref).height - n2 - 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.pixelsOrigin == null && this.isBigImage()) {
            byte[] byArray;
            int n5 = this.width * this.height * this.npix;
            int n6 = 0;
            int n7 = 512;
            this.flagUpdating = true;
            this.flagOk = false;
            this.aladin.calque.select.repaint();
            try {
                int n8 = this.width / 2 - Math.min(1024, this.width) / 2;
                int n9 = Math.min(1024, this.height);
                int n10 = this.width / 2 - n8 / 2;
                int n11 = this.height / 2 - n9 / 2;
                if (n4 > 0) {
                    n8 = n9 = Math.min(1024, n4);
                    n10 = n - n8 / 2;
                    n11 = n3 - n8 / 2;
                }
                double d3 = this.dataMin;
                double d4 = this.dataMax;
                byArray = new byte[n8 * n9 * this.npix];
                this.getPixelsFromCache(byArray, this.npix, n10, n11, n8, n9);
                this.findMinMax(byArray, this.bitpix, n8, n9, d, d2, bl, 0, 0, 0, 0);
                d = this.pixelMin;
                d2 = this.pixelMax;
                this.dataMin = d3;
                this.dataMax = d4;
                Aladin.trace(4, "PlanImage.recut(" + d + "," + d2 + "," + bl + ") on [" + n10 + "," + n11 + "-" + n8 + "x" + n9 + "] => min=" + d + " max=" + d2);
                byArray = new byte[n7];
                this.openCache();
                this.fCache.seek(this.cacheOffset);
                byte[] byArray2 = this.getBufPixels8();
                while (n6 < n5) {
                    if (n5 - n6 < n7) {
                        n7 = n5 - n6;
                    }
                    this.fCache.readFully(byArray, 0, n7);
                    this.to8bits(byArray2, n6 / this.npix, byArray, n7 / this.npix, this.bitpix, d, d2, false);
                    this.setPourcent((double)(n6 += n7) * 100.0 / (double)n5);
                }
                this.setBufPixels8(byArray2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.flagUpdating = false;
            this.flagOk = true;
            byArray = null;
            this.aladin.gc();
        } else {
            if (!this.pixelsOriginFromCache()) {
                return false;
            }
            this.setBufPixels8(this.getPix8Bits(this.getBufPixels8(), this.pixelsOrigin, this.bitpix, this.width, this.height, d, d2, bl, n, n2, n4));
        }
        if (this.fmt != 1) {
            PlanImage.invImageLine(this.width, this.height, this.getBufPixels8());
        }
        this.changeImgID();
        this.resetHist();
        this.setPourcent(-1.0);
        return true;
    }

    protected void loadFitsHeaderParam(FrameHeaderFits frameHeaderFits) {
        try {
            int n = this.headerFits.getIntFromHeader("BLANK");
            this.blank = n;
            this.isBlank = true;
            Aladin.trace(3, " => BLANK value = " + this.blank);
        }
        catch (Exception exception) {
            this.isBlank = false;
        }
        try {
            this.bZero = this.headerFits.getDoubleFromHeader("BZERO");
            Aladin.trace(3, " => BZERO = " + this.bZero);
        }
        catch (Exception exception) {
            this.bZero = 0.0;
        }
        try {
            this.bScale = this.headerFits.getDoubleFromHeader("BSCALE");
            Aladin.trace(3, " => BZERO = " + this.bZero + " BSCALE = " + this.bScale);
        }
        catch (Exception exception) {
            this.bScale = 1.0;
        }
        try {
            this.dataMinFits = this.headerFits.getDoubleFromHeader("GOODMIN");
            this.dataMaxFits = this.headerFits.getDoubleFromHeader("GOODMAX");
            this.dataMaxFits = 150000.0;
            Aladin.trace(3, " => GOODMIN = " + this.dataMinFits + " GOODMAX = " + this.dataMaxFits);
            this.dataMinFits = (this.dataMinFits - this.bZero) / this.bScale;
            this.dataMaxFits = (this.dataMaxFits - this.bZero) / this.bScale;
        }
        catch (Exception exception) {
            this.dataMaxFits = 0.0;
            this.dataMinFits = 0.0;
        }
        if (this.label == null || this.label.length() == 0) {
            try {
                String string = this.headerFits.getStringFromHeader("EXTNAME");
                if (string != null && string.length() > 0) {
                    this.setLabel(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean isBigImage() {
        return this.width * this.height * this.npix > 0x800000 && this.cacheID != null;
    }

    protected boolean cacheImageFits(MyInputStream myInputStream) throws Exception {
        int n;
        int n2;
        Date date;
        int n3;
        int n4;
        block27: {
            n4 = 2;
            Aladin.trace(2, "Loading FITS image");
            if (this.headerFits == null) {
                this.headerFits = new FrameHeaderFits((Plan)this, myInputStream);
            }
            n4 = this.headerFits.getIntFromHeader("NAXIS");
            this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
            if (n4 <= 1) {
                this.error = "_HEAD_XFITS_";
                if (n4 == 1) {
                    try {
                        this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
                        myInputStream.skip(this.naxis1 * Math.abs(this.bitpix) / 8);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return false;
            }
            try {
                this.width = this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
                this.height = this.naxis2 = this.headerFits.getIntFromHeader("NAXIS2");
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block27;
                exception.printStackTrace();
            }
        }
        if (n4 <= 1 || this.width <= 0 || this.height <= 0) {
            this.error = Aladin.error = ONEDIM;
            Aladin.warning(this.error, 1);
            this.close();
            return false;
        }
        if (this.bitpix == 0) {
            Aladin.error = "FITS format error: BITPIX=0 !";
            this.error = "FITS format error: BITPIX=0 !";
            Aladin.warning(this.error, 1);
            this.close();
            return false;
        }
        this.npix = n3 = Math.abs(this.bitpix) / 8;
        int n5 = this.width * this.height * n3;
        this.setPourcent(0.0);
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " BITPIX=" + this.bitpix + " => size=" + n5);
        this.loadFitsHeaderParam(this.headerFits);
        this.setCacheFromFile(myInputStream);
        Date date2 = new Date();
        this.tailleLoad = n5;
        boolean bl = this.aladin.configuration.getCMCut();
        this.setBufPixels8(new byte[this.width * this.height]);
        if ((myInputStream.getType() & 0x10L) != 0L) {
            Aladin.trace(2, "Hdecompressing");
            this.fmt = 3;
            this.pixelsOrigin = Hdecomp.decomp(myInputStream);
            date = new Date();
            n2 = (int)(date.getTime() - date2.getTime());
            date2 = date;
            Aladin.trace(3, " => Hdecompressing in " + n2 + " ms");
            this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, bl, 0, 0, 0, 0);
            this.to8bits(this.getBufPixels8(), this.offsetLoad / this.npix, this.pixelsOrigin, this.width * this.height, this.bitpix, this.pixelMin, this.pixelMax, true);
        } else if (this.flagSkip) {
            myInputStream.skip(n5);
        } else if (this.isBigImage()) {
            n = Math.min(1024, this.width);
            int n6 = Math.min(1024, this.height);
            int n7 = this.width / 2 - n / 2;
            int n8 = this.height / 2 - n6 / 2;
            byte[] byArray = new byte[n * n6 * this.npix];
            this.getPixelsFromCache(byArray, this.npix, n7, n8, n, n6);
            this.findMinMax(byArray, this.bitpix, n, n6, this.dataMinFits, this.dataMaxFits, bl, 0, 0, 0, 0);
            this.offsetLoad = 0;
            int n9 = 512;
            byArray = new byte[n9];
            while (this.offsetLoad < n5) {
                if (n5 - this.offsetLoad < n9) {
                    n9 = n5 - this.offsetLoad;
                }
                myInputStream.readFully(byArray, 0, n9);
                this.to8bits(this.getBufPixels8(), this.offsetLoad / this.npix, byArray, n9 / this.npix, this.bitpix, this.pixelMin, this.pixelMax, true);
                this.offsetLoad += n9;
                this.setPourcent((double)this.offsetLoad * 99.0 / (double)n5);
            }
        } else {
            this.pixelsOrigin = new byte[n5];
            this.offsetLoad = 0;
            n = n5 / 100;
            if (n < 512) {
                n = 512;
            }
            try {
                while (this.offsetLoad < n5) {
                    if (n5 - this.offsetLoad < n) {
                        n = n5 - this.offsetLoad;
                    }
                    myInputStream.readFully(this.pixelsOrigin, this.offsetLoad, n);
                    this.offsetLoad += n;
                    this.setPourcent((double)this.offsetLoad * 85.0 / (double)n5);
                }
            }
            catch (Exception exception) {
                this.error = Aladin.error = "Loading error: " + exception.getMessage();
                exception.printStackTrace();
                this.close();
                return false;
            }
            this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, bl, 0, 0, 0, 0);
            this.to8bits(this.getBufPixels8(), 0, this.pixelsOrigin, this.width * this.height, this.bitpix, this.pixelMin, this.pixelMax, true);
        }
        if (n4 > 2) {
            try {
                long l = n3 * this.naxis1 * this.naxis2;
                for (int i = 2; i < n4; ++i) {
                    l *= (long)this.headerFits.getIntFromHeader("NAXIS" + (i + 1));
                }
                myInputStream.skip(l -= (long)(n3 * this.naxis1 * this.naxis2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        if (this.flagSkip) {
            return true;
        }
        date = new Date();
        n2 = (int)(date.getTime() - date2.getTime());
        date2 = date;
        Aladin.trace(3, " => Reading " + (bl ? "and autocutting " : "") + "in " + Util.round((double)n2 / 1000.0, 3) + " s => " + Util.round((double)this.offsetLoad / (double)n2 / 1048.576, 2) + " Mbyte/s");
        PlanImage.invImageLine(this.width, this.height, this.getBufPixels8());
        this.creatDefaultCM();
        this.setPourcent(99.0);
        return true;
    }

    private void mocDecode(byte[] byArray, byte[] byArray2) throws Exception {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        inflater.inflate(byArray2);
        inflater.end();
    }

    protected boolean cacheImagePDS(MyInputStream myInputStream) throws Exception {
        boolean bl;
        int n;
        int n2;
        int n3;
        Aladin.trace(2, "Loading PDS image");
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderPDS((Plan)this, myInputStream);
        }
        this.width = this.naxis1 = this.headerFits.getIntFromHeader("LINE_SAMPLES");
        this.height = this.naxis2 = this.headerFits.getIntFromHeader("LINES");
        this.npix = this.headerFits.getIntFromHeader("SAMPLE_BITS") / 8;
        this.bitpix = this.npix * 8;
        String string = this.headerFits.getStringFromHeader("SAMPLE_TYPE");
        if (string.indexOf("REAL") >= 0) {
            this.bitpix = -this.bitpix;
        }
        int n4 = n3 = this.width * this.height * this.npix;
        if (string.indexOf("LSB") >= 0) {
            ++this.bitpix;
        }
        try {
            this.bScale = this.headerFits.getDoubleFromHeader("SCALING_FACTOR");
        }
        catch (Exception exception) {
            this.bScale = 1.0;
        }
        try {
            this.bZero = this.headerFits.getDoubleFromHeader("OFFSET");
        }
        catch (Exception exception) {
            this.bZero = 0.0;
        }
        int n5 = this.headerFits.getIntFromHeader("RECORD_BYTES");
        String string2 = this.headerFits.getStringFromHeader("^IMAGE");
        int n6 = string2.indexOf("BYTE");
        int n7 = n6 > 0 ? Integer.parseInt(string2.substring(0, n6)) : (this.headerFits.getIntFromHeader("^IMAGE") - 1) * n5;
        myInputStream.skip((long)n7 - myInputStream.getPos());
        try {
            n2 = this.headerFits.getIntFromHeader("LINE_PREFIX_BYTES");
        }
        catch (Exception exception) {
            n2 = 0;
        }
        try {
            n = this.headerFits.getIntFromHeader("LINE_SUFFIX_BYTES");
        }
        catch (Exception exception) {
            n = 0;
        }
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " BITPIX=" + this.bitpix + " => size=" + n4 + (n2 > 0 ? " PREFIX_BYTES=" + n2 : "") + (n > 0 ? " SUFFIX_BYTES=" + n : "") + " image offset=" + n7);
        this.setPourcent(0.0);
        boolean bl2 = bl = this.headerFits.getStringFromHeader("ENCODING_TYPE") != null;
        if (bl) {
            int n8 = this.headerFits.getIntFromHeader("FILE_RECORDS") * n5;
            n4 = n8 - n7;
        } else {
            this.setCacheFromFile(myInputStream);
        }
        Date date = new Date();
        this.tailleLoad = n4;
        boolean bl3 = this.aladin.configuration.getCMCut();
        this.offsetLoad = 0;
        this.setBufPixels8(new byte[this.width * this.height]);
        this.pixelsOrigin = new byte[n4];
        try {
            for (int i = 0; i < this.height; ++i) {
                if (n2 > 0) {
                    myInputStream.skip(n2);
                }
                myInputStream.readFully(this.pixelsOrigin, i * this.width * this.npix, this.width * this.npix);
                if (n > 0) {
                    myInputStream.skip(n);
                }
                this.setPourcent((double)(i * this.width * this.npix) * 85.0 / (double)n4);
            }
        }
        catch (Exception exception) {
            this.error = Aladin.error = "Loading error: " + exception.getMessage();
            exception.printStackTrace();
            this.close();
            return false;
        }
        if (bl) {
            byte[] byArray = new byte[n3];
            this.mocDecode(this.pixelsOrigin, byArray);
            this.setPourcent(92.0);
            this.pixelsOrigin = byArray;
        }
        this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, bl3, 0, 0, 0, 0);
        this.to8bits(this.getBufPixels8(), 0, this.pixelsOrigin, this.width * this.height, this.bitpix, this.pixelMin, this.pixelMax, true);
        PlanImage.invImageLine(this.width, this.height, this.getBufPixels8());
        Date date2 = new Date();
        int n9 = (int)(date2.getTime() - date.getTime());
        date = date2;
        Aladin.trace(3, " => Reading " + (bl ? ", uncompressing " : "") + (bl3 ? ", autocutting " : "") + "in " + Util.round((double)n9 / 1000.0, 3) + " s => " + Util.round((double)this.offsetLoad / (double)n9 / 1048.576, 2) + " Mbyte/s");
        this.creatDefaultCM();
        this.setPourcent(99.0);
        return true;
    }

    protected void creatDefaultCM() {
        this.cm = CanvasColorMap.getCM(0, 128, 255, this.aladin.configuration.getCMVideo() == 1, this.aladin.configuration.getCMMap(), this.aladin.configuration.getCMFct(), this.isTransparent());
    }

    protected void setCM(Object object) {
        this.cm = (ColorModel)object;
        this.changeImgID();
        if (Aladin.ISLINUX) {
            this.aladin.view.recreateMemoryBufferFor(this);
        }
    }

    public boolean setCmParam(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        double d = this.pixelMin;
        double d2 = this.pixelMax;
        boolean bl4 = false;
        Tok tok = new Tok(string);
        while (tok.hasMoreTokens()) {
            string = tok.nextToken();
            int n = Util.indexInArrayOf(string, FrameColorMap.CMA, true);
            if (n != -1) {
                if (n == this.typeCM) continue;
                this.typeCM = n;
                bl = true;
                continue;
            }
            if (CanvasColorMap.customCMName != null && (n = CanvasColorMap.customCMName.indexOf(string)) >= 0) {
                if (this.typeCM == 4 + n) continue;
                this.typeCM = 4 + n;
                bl = true;
                continue;
            }
            n = Util.indexInArrayOf(string, TRANSFERTFCT, true);
            if (n >= 0) {
                if (n == this.transfertFct) continue;
                this.transfertFct = n;
                bl = true;
                continue;
            }
            if (string.equalsIgnoreCase("reverse") || string.equalsIgnoreCase("inverse")) {
                if (this.video == 1) continue;
                this.video = 1;
                bl = true;
                continue;
            }
            if (string.equalsIgnoreCase("noreverse")) {
                if (this.video == 0) continue;
                this.video = 0;
                bl = true;
                continue;
            }
            if (string.equalsIgnoreCase("autocut") || string.equalsIgnoreCase("cut")) {
                bl4 = true;
                bl2 = true;
                continue;
            }
            if (string.equalsIgnoreCase("noautocut") || string.equalsIgnoreCase("nocut")) {
                bl4 = false;
                bl2 = true;
                continue;
            }
            if (string.equalsIgnoreCase("rescan") || string.equalsIgnoreCase("localcut")) {
                bl3 = true;
                continue;
            }
            if (string.equalsIgnoreCase("all")) {
                d = this.dataMin;
                d2 = this.dataMax;
                bl2 = true;
                continue;
            }
            n = string.indexOf("..");
            if (n <= 0) continue;
            try {
                int n2 = 1;
                int n3 = 0;
                if (string.charAt(n3) == '-') {
                    ++n3;
                    n2 = -1;
                }
                d = (double)n2 * Double.parseDouble(string.substring(n3, n));
                d = (d - this.bZero) / this.bScale;
                n2 = 1;
                n3 = n + 2;
                if (string.charAt(n3) == '-') {
                    ++n3;
                    n2 = -1;
                }
                d2 = (double)n2 * Double.parseDouble(string.substring(n3));
                bl2 = true;
                d2 = (d2 - this.bZero) / this.bScale;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            IndexColorModel indexColorModel = CanvasColorMap.getCM(this.cmControl[0], this.cmControl[1], this.cmControl[2], this.video == 1, this.typeCM, this.transfertFct);
            this.setCM(indexColorModel);
        }
        if (bl3) {
            if (!(this instanceof PlanBG) || !((PlanBG)this).isTruePixels()) {
                return false;
            }
            ((PlanBG)this).forceReload();
        } else if (bl2) {
            this.recut(d, d2, bl4);
        }
        if (!(bl || bl2 || bl3)) {
            return false;
        }
        if (this.aladin.frameCM != null) {
            this.aladin.frameCM.majCMByScript(this);
        }
        this.changeImgID();
        return true;
    }

    public void reverse() {
        if (!(this.cm instanceof IndexColorModel)) {
            return;
        }
        this.video = this.video == 1 ? 0 : 1;
        IndexColorModel indexColorModel = CanvasColorMap.getCM(this.cmControl[0], this.cmControl[1], this.cmControl[2], this.video == 1, this.typeCM, this.transfertFct);
        this.setCM(indexColorModel);
    }

    protected boolean isPlanBase() {
        return this.aladin.calque.getPlanBase() == this;
    }

    protected void drawBord(Graphics graphics, ViewSimple viewSimple, int n, int n2, float f, boolean bl) {
        Coord coord;
        Projection projection;
        if (viewSimple.isFree() || !Projection.isOk(projection = viewSimple.getProj())) {
            return;
        }
        graphics.setColor(Color.red);
        try {
            coord = this.projd.c.getImgCenter();
        }
        catch (Exception exception) {
            return;
        }
        double d = coord.x;
        double d2 = coord.y;
        Coord coord2 = new Coord();
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        for (int i = 0; i < 4; ++i) {
            int n3 = i < 2 ? -1 : 1;
            int n4 = i == 1 || i == 2 ? 1 : -1;
            coord2.x = coord.x + (double)n3 * d;
            coord2.y = coord.y + (double)n4 * d2;
            this.projd.getCoord(coord2);
            if (Double.isNaN(coord2.al)) {
                return;
            }
            projection.getXY(coord2);
            if (Double.isNaN(coord2.x)) {
                return;
            }
            Point point = viewSimple.getViewCoord(coord2.x, coord2.y);
            if (point == null) {
                return;
            }
            nArray[i] = point.x + n;
            nArray2[i] = point.y + n2;
            if (i != 0) continue;
            graphics.setFont(Aladin.SSPLAIN);
            graphics.drawString(this.label, point.x + n, point.y - 2 + n2);
        }
        if (bl && f != 0.0f && Aladin.ENABLE_FOOTPRINT_OPACITY && graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            Composite composite2 = Util.getFootprintComposite(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL * f);
            graphics2D.setComposite(composite2);
            graphics2D.fillPolygon(nArray, nArray2, 4);
            graphics2D.setComposite(composite);
        }
        graphics.drawPolygon(nArray, nArray2, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(Graphics graphics, ViewSimple viewSimple, int n, int n2, float f) {
        block23: {
            if (viewSimple == null) {
                return;
            }
            long l = Util.getTime();
            if (f == -1.0f) {
                f = this.getOpacityLevel();
            }
            Graphics2D graphics2D = null;
            Composite composite = null;
            AffineTransform affineTransform = null;
            try {
                Object object;
                if ((double)f <= 0.1) {
                    return;
                }
                if (!this.projd.agree(this.projd, viewSimple)) {
                    return;
                }
                if (!(graphics instanceof Graphics2D)) {
                    return;
                }
                graphics2D = (Graphics2D)graphics;
                composite = graphics2D.getComposite();
                affineTransform = graphics2D.getTransform();
                if ((double)f < 0.9) {
                    object = Util.getImageComposite(f);
                    graphics2D.setComposite((Composite)object);
                }
                if ((object = this.getAffineTransform(viewSimple)) == null) {
                    graphics2D.setComposite(composite);
                    if (graphics2D != null && composite != null) {
                        graphics2D.setComposite(composite);
                    }
                    if (graphics2D != null && affineTransform != null) {
                        graphics2D.setTransform(affineTransform);
                    }
                    return;
                }
                graphics2D.setTransform((AffineTransform)object);
                graphics2D.drawImage(this.getImage(viewSimple, false), n, n2, this.aladin);
                long l2 = Util.getTime();
                this.statTimeDisplay = l2 - l;
            }
            catch (Exception exception) {
                if (Aladin.levelTrace >= 3) {
                    exception.printStackTrace();
                }
                break block23;
            }
            finally {
                if (graphics2D != null && composite != null) {
                    graphics2D.setComposite(composite);
                }
                if (graphics2D != null && affineTransform != null) {
                    graphics2D.setTransform(affineTransform);
                }
            }
            if (graphics2D != null && composite != null) {
                graphics2D.setComposite(composite);
            }
            if (graphics2D != null && affineTransform != null) {
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    protected AffineTransform getAffineTransform(ViewSimple viewSimple) {
        if (viewSimple == null) {
            return null;
        }
        PointD[] pointDArray = this.getBords(viewSimple);
        if (pointDArray == null) {
            return null;
        }
        double d = pointDArray[3].x - pointDArray[0].x;
        double d2 = pointDArray[3].y - pointDArray[0].y;
        double d3 = FastMath.atan2(d2, d);
        double d4 = Math.sqrt(d * d + d2 * d2);
        double d5 = d4 / (double)this.width;
        double d6 = pointDArray[1].x - pointDArray[0].x;
        double d7 = pointDArray[1].y - pointDArray[0].y;
        double d8 = Math.sqrt(d6 * d6 + d7 * d7);
        double d9 = FastMath.atan2(d7, d6) - d3;
        double d10 = d8 * FastMath.sin(d9) / (double)this.height;
        double d11 = d8 * Math.cos(d9) / d4;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(pointDArray[0].x, pointDArray[0].y);
        affineTransform.rotate(d3);
        affineTransform.scale(d5, d10);
        affineTransform.shear(d11, 0.0);
        return affineTransform;
    }

    protected PointD[] getBords(ViewSimple viewSimple) {
        Coord coord;
        Projection projection;
        if (viewSimple.isFree() || !Projection.isOk(projection = viewSimple.getProj())) {
            return null;
        }
        try {
            coord = this.projd.c.getImgCenter();
        }
        catch (Exception exception) {
            return null;
        }
        double d = coord.x;
        double d2 = coord.y;
        Coord coord2 = new Coord();
        PointD[] pointDArray = new PointD[4];
        for (int i = 0; i < 4; ++i) {
            int n = i < 2 ? -1 : 1;
            int n2 = i == 1 || i == 2 ? 1 : -1;
            coord2.x = coord.x + (double)n * d;
            coord2.y = coord.y + (double)n2 * d2;
            this.projd.getCoord(coord2);
            if (Double.isNaN(coord2.al)) {
                return null;
            }
            projection.getXY(coord2);
            if (Double.isNaN(coord2.x)) {
                return null;
            }
            pointDArray[i] = viewSimple.getViewCoordDble(coord2.x, coord2.y);
        }
        return pointDArray;
    }

    protected Point getCenter(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        Coord coord;
        Plan plan = viewSimple.pref;
        if (plan == null || !Projection.isOk(plan.projd)) {
            return null;
        }
        Projection projection = plan.projd;
        graphics.setColor(viewSimple.getInfoColor());
        try {
            coord = this.projd.c.getImgCenter();
        }
        catch (Exception exception) {
            return null;
        }
        this.projd.getCoord(coord);
        projection.getXY(coord);
        return viewSimple.getViewCoord(coord.x, coord.y);
    }

    protected void setBufPixels8(byte[] byArray) {
        this.pixels = byArray;
    }

    protected byte[] getBufPixels8() {
        return this.pixels;
    }

    protected void setPixels(byte[] byArray) {
        this.pixels = byArray;
    }

    @Override
    protected String getBookmarkCode() {
        String string = super.getBookmarkCode();
        if (string == null) {
            return null;
        }
        if (this.typeCM != 0) {
            string = string + "\ncm " + CanvasColorMap.getCMName(this.typeCM);
            if (this.video == 0) {
                string = string + " noreverse";
            }
            if (this.transfertFct != 3) {
                string = string + " " + TRANSFERTFCT[this.transfertFct];
            }
        }
        return string;
    }

    protected byte[] getLinearPixels8() {
        return this.getLinearPixels8(null);
    }

    protected byte[] getLinearPixels8(byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[this.width * this.height];
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = PlanImage.getGreyPixel8(this.cm, this.pixels[i]);
        }
        return byArray;
    }

    public static byte getGreyPixel8(ColorModel colorModel, byte by) {
        int n = 0xFF & by;
        int n2 = colorModel.getRed(n);
        int n3 = colorModel.getGreen(n);
        int n4 = colorModel.getBlue(n);
        return (byte)((double)n2 * 0.299 + (double)n3 * 0.587 + (double)n4 * 0.114);
    }

    public void setBitpix(int n) {
        this.bitpix = n;
    }

    static {
        TRANSFERTFCT = new String[]{"Asinh", "Log", "Sqrt", "Linear", "Pow2", " -- "};
        id = 0;
        MAXCACHEID = 1;
        tmp_inv = new byte[8];
    }
}

