/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.Coord;
import cds.aladin.Kernel;
import cds.aladin.PlanImage;
import cds.aladin.Projection;
import cds.tools.Util;

public class PlanImageAlgo
extends PlanImage {
    protected static final int PPV = 0;
    protected static final int BILINEAIRE = 1;
    protected static final int ADD = 0;
    protected static final int SUB = 1;
    protected static final int MUL = 2;
    protected static final int DIV = 3;
    protected static final int NORM = 4;
    protected static final int NORMCUT = 5;
    protected static final int CONV = 6;
    protected static final int CONVG = 7;
    protected static final int BITPIX = 8;
    protected static final int BITPIXCUT = 9;
    protected static String[] NAME = new String[]{"Add", "Sub", "Mul", "Div", "Norm", "NormC", "Conv", "ConvG", "Bitpix", "BitpixC"};
    private PlanImage p1 = null;
    private PlanImage p2 = null;
    private int fct;
    private double coef;
    private String param;
    protected int methode;
    private boolean askNewView = false;
    private static final String FCT = "+-*/~#";

    protected PlanImageAlgo(Aladin aladin, String string, PlanImage planImage, PlanImage planImage2, int n, double d, String string2, int n2) {
        super(aladin, planImage);
        this.type = 7;
        this.askNewView = true;
        Calque cfr_ignored_0 = aladin.calque;
        this.isOldPlan = !Calque.isNewPlan(string);
        this.setLabel(string == null ? "conv[" + string + "]" : string);
        this.launchAlgo(planImage, planImage2, n, d, string2, n2);
    }

    protected PlanImageAlgo(Aladin aladin, PlanImage planImage) {
        super(aladin, planImage);
        this.type = 7;
    }

    protected PlanImageAlgo() {
    }

    protected PlanImageAlgo(Aladin aladin) {
        super(aladin);
        this.type = 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launchAlgo(PlanImage planImage, PlanImage planImage2, int n, double d, String string, int n2) {
        this.methode = n2;
        this.p1 = planImage == null ? null : new PlanImage(this.aladin, planImage);
        this.p2 = planImage2 == null ? null : new PlanImage(this.aladin, planImage2);
        this.p1 = planImage;
        this.p2 = planImage2;
        this.fct = n;
        this.coef = d;
        this.param = string;
        this.copyright = "Computed by Aladin";
        string = "Computed: " + this.getFonction();
        this.setHasSpecificCalib();
        this.flagOk = false;
        this.flagProcessing = true;
        this.aladin.calque.select.repaint();
        this.sendLog("Compute", " [" + this + " = " + this.getFonction() + (n2 == 1 ? "/bilinear" : "") + "]");
        PlanImageAlgo planImageAlgo = this;
        synchronized (planImageAlgo) {
            this.runme = new Thread((Runnable)this, "AladinBuildAlgo");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    protected String getFonction() {
        return (this.p1 != null ? this.p1.label : (this.p2 != null ? this.coef + "" : "")) + " " + (this.fct == 6 ? "conv " + this.param + "" : (this.fct == 8 ? "bitpix " + this.param + "" : (this.fct == 9 ? "bitpix -cut " + this.param + "" : PlanImageAlgo.getFct(this.fct) + (this.p2 != null ? this.p2.label : this.coef + "")))) + " ";
    }

    protected static String getFct(int n) {
        return FCT.charAt(n) + "";
    }

    @Override
    protected void planReady(boolean bl) {
        if (!bl || this.askNewView) {
            super.planReady(bl);
            return;
        }
        this.setActivated(true);
        this.pourcent = -1.0;
        this.flagOk = true;
        this.aladin.calque.repaintAll();
    }

    protected static PlanImage normalise(PlanImage planImage) {
        PlanImageAlgo planImageAlgo = new PlanImageAlgo(planImage.aladin, null, planImage, null, 4, 0.0, null, 0);
        while (planImageAlgo != null && !planImageAlgo.isSync()) {
            Util.pause(500);
            Aladin.trace(4, "PlanImageAlgo.normalise:  waiting " + planImage + "...");
        }
        return planImageAlgo;
    }

    protected boolean compute() {
        int n;
        int n2;
        int n3;
        this.flagProcessing = true;
        this.aladin.calque.select.repaint();
        if (this.p1 != null) {
            this.p1.setLockCacheFree(true);
            this.p1.pixelsOriginFromCache();
        }
        if (this.p2 != null) {
            this.p2.setLockCacheFree(true);
            this.p2.pixelsOriginFromCache();
        }
        Aladin.trace(3, "Computing " + this.getFonction() + "...");
        Coord coord = new Coord();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = false;
        if (this.fct == 4 || this.fct == 5) {
            bl = true;
            d2 = this.fct == 4 ? this.dataMin : this.pixelMin;
            d3 = this.fct == 4 ? this.dataMax : this.pixelMax;
            d2 = d2 * this.bScale + this.bZero;
            d3 = d3 * this.bScale + this.bZero;
            this.coef = d3 - d2;
            if (this.fct == 5) {
                this.transfertFct = 3;
            }
            for (n3 = 0; n3 < this.height; ++n3) {
                n2 = 0;
                double d5 = 0.0;
                for (n = 0; n < this.width; ++n) {
                    try {
                        double d6 = this.p1.getPixel(n, n3);
                        if (this.p1.isBlank(d6)) continue;
                        d5 += d6;
                        ++n2;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                d4 += n2 == 0 ? 0.0 : d5 / (double)n2;
            }
            d4 /= (double)this.height;
        }
        n2 = this.p1 == null ? 8 : this.p1.bitpix;
        int n4 = this.p2 == null ? 8 : this.p2.bitpix;
        this.bitpix = Math.max(Math.abs(n2), Math.abs(n4));
        if (n2 < 0 || n4 < 0) {
            this.bitpix = -this.bitpix;
        }
        if (this.fct == 6 && this.bitpix != -64) {
            this.bitpix = -32;
        }
        if ((this.p1 != null && (this.p1.bScale != 1.0 || this.p1.bZero != 0.0) || this.p2 != null && (this.p2.bScale != 1.0 || this.p2.bZero != 0.0)) && this.bitpix != -64) {
            this.bitpix = -32;
        }
        if (this.fct == 8 || this.fct == 9) {
            this.bitpix = Integer.parseInt(this.param);
        }
        this.npix = Math.abs(this.bitpix) / 8;
        this.bZero = 0.0;
        this.bScale = 1.0;
        this.isBlank = false;
        this.dataMaxFits = 0.0;
        this.dataMinFits = 0.0;
        Aladin.trace(4, "PlanImageAlgo.compute(): Target image: " + this.width + "x" + this.height + " bitpix=" + this.bitpix);
        this.pixelsOrigin = new byte[this.width * this.height * this.npix];
        if (this.fct == 8 || this.fct == 9) {
            double d7;
            double d8 = this.bitpix == -64 ? Double.MAX_VALUE : (this.bitpix == -32 ? 3.4028234663852886E38 : (this.bitpix == 64 ? 9.223372036854776E18 : (this.bitpix == 32 ? 2.147483647E9 : (d7 = this.bitpix == 16 ? 32767.0 : 255.0))));
            double d9 = this.bitpix == -64 ? -1.7976931348623157E308 : (this.bitpix == -32 ? -3.4028234663852886E38 : (this.bitpix == 64 ? -9.223372036854776E18 : (this.bitpix == 32 ? -2.147483648E9 : (this.bitpix == 16 ? -32768.0 : 0.0))));
            double d10 = this.p1.getPixelMin();
            double d11 = this.p1.getPixelMax();
            double d12 = (d7 - d9) / (d11 - d10);
            for (n3 = 0; n3 < this.height; ++n3) {
                for (n = 0; n < this.width; ++n) {
                    double d13 = this.p1.getPixel(n, n3);
                    if (this.fct == 9) {
                        if (d13 < d10) {
                            d13 = d10;
                        } else if (d13 > d11) {
                            d13 = d11;
                        }
                        d13 = (d13 - d10) * d12 + d9;
                    } else if (d13 > d7) {
                        d13 = d7;
                    } else if (d13 < d9) {
                        d13 = d9;
                    }
                    this.setPixelOriginInDouble(n, n3, d13);
                }
                if (n3 % 100 != 0) continue;
                if (this.type == 0) break;
                this.pourcent = n * n3 * 100 / this.p1.getBufPixels8().length;
                if (!Aladin.isSlow) continue;
                Util.pause(10);
            }
            this.bZero = d10 - d9;
            this.bScale = 1.0 / d12;
            this.pixelMin = this.dataMin = d9;
            this.pixelMax = this.dataMax = d7;
        } else if (this.fct == 6) {
            Kernel kernel;
            block88: {
                double d14 = 2.777777777777778E-4;
                try {
                    d14 = this.projd.getPixResDelta();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                kernel = null;
                try {
                    kernel = this.aladin.kernelList.getKernel(this.param, d14);
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace >= 3) {
                        exception.printStackTrace();
                    }
                    this.error = exception.getMessage();
                    if (this.error != null) break block88;
                    this.error = "conv error";
                }
            }
            if (kernel == null) {
                Aladin.warning(this.error);
                this.flagOk = true;
                return false;
            }
            int n5 = kernel.matrix.length;
            int n6 = n5 / 2;
            double[] dArray = new double[this.width * this.height];
            int n7 = 0;
            for (n3 = 0; n3 < this.height; ++n3) {
                for (n = 0; n < this.width; ++n) {
                    double d15 = this.p1.getPixelOriginInDouble(n, n3);
                    dArray[n7++] = d15;
                }
            }
            if (kernel.gaussian != null) {
                double[] dArray2 = new double[this.width * this.height];
                this.convolveAndTranspose(kernel, dArray, dArray2, this.width, this.height, 0);
                this.convolveAndTranspose(kernel, dArray2, dArray, this.height, this.width, this.width * this.height / 2);
                n7 = 0;
                for (n3 = 0; n3 < this.height; ++n3) {
                    for (n = 0; n < this.width; ++n) {
                        this.setPixelOriginInDouble(n, n3, dArray[n7++]);
                    }
                }
            } else {
                for (n3 = 0; n3 < this.height; ++n3) {
                    for (n = 0; n < this.width; ++n) {
                        double d16 = 0.0;
                        for (int i = -n6; i <= n6; ++i) {
                            for (int j = -n6; j <= n6; ++j) {
                                int n8 = n + j;
                                int n9 = n3 + i;
                                if (n8 < 0) {
                                    n8 = 0;
                                } else if (n8 >= this.width) {
                                    n8 = this.width - 1;
                                }
                                if (n9 < 0) {
                                    n9 = 0;
                                } else if (n9 >= this.height) {
                                    n9 = this.height - 1;
                                }
                                d16 += dArray[n9 * this.width + n8] * kernel.matrix[j + n6][i + n6];
                            }
                        }
                        this.setPixelOriginInDouble(n, n3, d16);
                    }
                    if (n3 % 100 != 0) continue;
                    if (this.type != 0) {
                        this.pourcent = n * n3 * 100 / this.p1.getBufPixels8().length;
                        if (!Aladin.isSlow) continue;
                        Util.pause(10);
                        continue;
                    }
                    break;
                }
            }
        } else {
            boolean bl2 = false;
            if (this.p1 != null && !Projection.isOk(this.p1.projd) && this.p2 != null && !Projection.isOk(this.p2.projd)) {
                bl2 = true;
            } else if (this.p1 != null && this.p2 != null) {
                bl2 = this.p1.projd.c.TheSame(this.p2.projd.c);
            }
            boolean bl3 = false;
            if (this.p1 != null && !Projection.isOk(this.p1.projd) && this.p2 != null && !Projection.isOk(this.p2.projd)) {
                bl3 = true;
            }
            if (bl2) {
                this.methode = 0;
            }
            this.dataMin = Double.MAX_VALUE;
            this.dataMax = -1.7976931348623157E308;
            for (n3 = 0; n3 < this.height; ++n3) {
                for (n = 0; n < this.width; ++n) {
                    double d17 = Double.NaN;
                    try {
                        d17 = this.p1.getPixel(n, n3);
                        if (bl) {
                            if (d17 < d2) {
                                d17 = d2;
                            }
                            if (d17 > d3) {
                                d17 = d3;
                            }
                            d17 /= d4;
                        } else {
                            if (this.p2 == null || this.fct == 4) {
                                d = this.coef;
                            } else {
                                coord.x = n;
                                coord.y = n3;
                                if (!bl2 && !bl3) {
                                    coord.y = (double)this.height - coord.y - 1.0;
                                    this.p1.projd.getCoord(coord);
                                    if (Double.isNaN(coord.al)) continue;
                                    this.p2.projd.getXY(coord);
                                    coord.y = (double)this.p2.height - coord.y - 1.0;
                                }
                                if (!Double.isNaN(coord.x)) {
                                    switch (this.methode) {
                                        case 0: {
                                            int n10 = (int)Math.round(coord.x);
                                            int n11 = (int)Math.round(coord.y);
                                            if (n10 < 0 || n10 >= this.p2.width || n11 < 0 || n11 >= this.p2.height) {
                                                d = Double.NaN;
                                                break;
                                            }
                                            d = this.p2.getPixel(n10, n11);
                                            break;
                                        }
                                        case 1: {
                                            double d18;
                                            double d19;
                                            double d20;
                                            double d21;
                                            int n10 = (int)Math.round(coord.x - 0.5);
                                            int n11 = (int)Math.round(coord.y - 0.5);
                                            int n12 = n10 + 1;
                                            int n13 = n11 + 1;
                                            if (n10 < 0 || n12 >= this.p2.width || n11 < 0 || n13 >= this.p2.height) {
                                                d = Double.NaN;
                                                break;
                                            }
                                            double d22 = this.p2.getPixel(n10, n11);
                                            double d23 = this.p2.getPixel(n12, n11);
                                            double d24 = this.p2.getPixel(n10, n13);
                                            double d25 = this.p2.getPixel(n12, n13);
                                            if (coord.x == (double)n10) {
                                                d21 = 1.0;
                                                d20 = 0.0;
                                            } else if (coord.x == (double)n12) {
                                                d21 = 0.0;
                                                d20 = 1.0;
                                            } else {
                                                d21 = 1.0 / (coord.x - (double)n10);
                                                d20 = 1.0 / ((double)n12 - coord.x);
                                            }
                                            if (coord.y == (double)n11) {
                                                d19 = 1.0;
                                                d18 = 0.0;
                                            } else if (coord.y == (double)n13) {
                                                d19 = 0.0;
                                                d18 = 1.0;
                                            } else {
                                                d19 = 1.0 / (coord.y - (double)n11);
                                                d18 = 1.0 / ((double)n13 - coord.y);
                                            }
                                            double d26 = (d22 * d21 + d23 * d20) / (d21 + d20);
                                            double d27 = (d24 * d21 + d25 * d20) / (d21 + d20);
                                            d = (d26 * d19 + d27 * d18) / (d19 + d18);
                                        }
                                    }
                                }
                            }
                            if (!Double.isNaN(d)) {
                                double d28 = this.fct == 0 ? d17 + d : (this.fct == 1 ? d17 - d : (d17 = this.fct == 2 ? d17 * d : d17 / d));
                                if (d17 < this.dataMin) {
                                    this.dataMin = d17;
                                }
                                if (d17 > this.dataMax) {
                                    this.dataMax = d17;
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return false;
                    }
                    this.setPixelOriginInDouble(n, n3, d17);
                }
                if (n3 % 100 != 0) continue;
                if (this.type != 0) {
                    this.pourcent = n * n3 * 100 / this.p1.getBufPixels8().length;
                    if (!Aladin.isSlow) continue;
                    Util.pause(10);
                    continue;
                }
                break;
            }
        }
        this.flagProcessing = false;
        if (this.fmt == 1) {
            this.fmt = 0;
        }
        if (this.headerFits != null) {
            this.headerFits.setKeyValue("BSCALE", this.bScale + "");
            this.headerFits.setKeyValue("BZERO", this.bZero + "");
        }
        this.reUseOriginalPixels();
        this.active = true;
        this.selected = true;
        Aladin.trace(3, "Algo achieved...");
        this.pourcent = -1.0;
        this.changeImgID();
        if (this.p1 != null) {
            this.p1.setLockCacheFree(false);
        }
        if (this.p2 != null) {
            this.p2.setLockCacheFree(false);
        }
        this.p2 = null;
        this.p1 = null;
        return true;
    }

    protected void convolveAndTranspose(Kernel kernel, double[] dArray, double[] dArray2, int n, int n2, int n3) {
        int n4 = kernel.matrix.length;
        int n5 = n4 / 2;
        for (int i = 0; i < n2; ++i) {
            int n6 = i;
            int n7 = i * n;
            for (int j = 0; j < n; ++j) {
                double d = 0.0;
                for (int k = -n5; k <= n5; ++k) {
                    int n8 = j + k;
                    if (n8 < 0) {
                        n8 = 0;
                    } else if (n8 >= n) {
                        n8 = n - 1;
                    }
                    d += dArray[n7 + n8] * kernel.gaussian[k + n5];
                }
                dArray2[n6] = d;
                n6 += n2;
            }
            if (i % 100 != 0) continue;
            if (this.type == 0) break;
            this.pourcent = (n3 + i * n / 2) * 100 / dArray.length;
            if (!Aladin.isSlow) continue;
            Util.pause(10);
        }
    }
}

