/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.CanvasColorMap;
import cds.aladin.Coord;
import cds.aladin.CubeControl;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageBlinkItem;
import cds.aladin.PlanImageCube;
import cds.aladin.Projection;
import cds.aladin.ResourceNode;
import cds.aladin.ViewSimple;
import cds.fits.HeaderFits;
import cds.tools.Util;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class PlanImageBlink
extends PlanImage {
    protected PlanImage pRef;
    protected int initDelay;
    protected boolean flagPause;
    protected double z;
    protected Vector<PlanImageBlinkItem> vFrames;
    protected int depth;
    private PlanImage[] tmpP;
    protected boolean flagAppend;
    public static final int PERM0 = 0;
    public static final int PERM1 = 1;
    public static final int PERM2 = 2;
    public static final int W2D = 0;
    public static final int H2D = 1;
    public static final int CP = 2;
    public static final int CM = 3;
    private int modePerm = 0;
    private boolean flagRecut = false;
    private double _min;
    private double _max;
    private boolean _autocut;
    private boolean _restart;
    protected Thread threadRecut = null;
    private boolean lock;
    private RandomAccessFile fCacheBis = null;
    private String cacheIDBis = null;
    private byte[] bufCache = null;
    private boolean loadInRamInProgress = false;
    private boolean loadInRamAborting = false;
    long t;
    long t1;
    private int ooLastFrame = -1;
    private int oLastFrame = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlanImageBlink(Aladin aladin, PlanImage[] planImageArray, String string, int n) {
        super(aladin);
        this.type = 3;
        this.initDelay = n;
        this.flagPause = false;
        this.z = 0.0;
        this.isOldPlan = false;
        this.pRef = planImageArray[0];
        this.vFrames = new Vector();
        Aladin.trace(3, "Blink ref plane: " + this.pRef.label);
        this.init(string, this.pRef);
        this.tmpP = new PlanImage[planImageArray.length - 1];
        System.arraycopy(planImageArray, 1, this.tmpP, 0, planImageArray.length - 1);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < planImageArray.length; ++i) {
            stringBuffer.append((i > 0 ? "/" : "") + planImageArray[i]);
        }
        this.sendLog("Blink", "[" + stringBuffer + "]");
        this.flagAppend = false;
        PlanImageBlink planImageBlink = this;
        synchronized (planImageBlink) {
            this.runme = new Thread((Runnable)this, "AladinBuildBlink");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    @Override
    protected int getInitDelay() {
        return this.initDelay;
    }

    @Override
    protected void setPause(boolean bl, ViewSimple viewSimple) {
        this.flagPause = bl;
    }

    @Override
    protected boolean isPause() {
        return this.flagPause;
    }

    @Override
    protected void setZ(double d) {
        this.z = d;
    }

    @Override
    protected double getZ() {
        return this.z;
    }

    protected PlanImageBlink(Aladin aladin, String string, MyInputStream myInputStream, String string2, String string3, Obj obj, ResourceNode resourceNode, boolean bl, boolean bl2, Plan plan) {
        super(aladin, string, myInputStream, string2, string3, obj, resourceNode, bl, bl2, plan);
    }

    @Override
    protected boolean Free() {
        if (!super.Free()) {
            return false;
        }
        this.freeRam();
        this.pRef = null;
        this.vFrames = null;
        if (this.fCacheBis != null) {
            try {
                this.fCacheBis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cacheIDBis = null;
        return true;
    }

    protected void init(String string, PlanImage planImage) {
        planImage.copy(this);
        this.type = 3;
        this.flagOk = false;
        this.askActive = true;
        this.headerFits = null;
        this.pixelsZoom = null;
        this.fmt = 0;
        this.res = 0;
        this.orig = 3;
        this.status = "Re-sampling...";
        this.progress = "computing...";
        if (string == null) {
            string = "Blk img";
        }
        this.setLabel(string);
        this.copyright = "Blink sequence by Aladin";
        this.param = "";
        this.transfertFct = 3;
        this.video = 0;
        this.typeCM = planImage.typeCM;
        this.cmControl[0] = 0;
        this.cmControl[1] = 128;
        this.cmControl[2] = 255;
        this.cm = CanvasColorMap.getCM(0, 128, 255, false, this.typeCM, this.transfertFct);
        this.vFrames.addElement(new PlanImageBlinkItem(planImage));
        this.pixelMin = 0.0;
        this.dataMin = 0.0;
        this.pixelMax = 255.0;
        this.dataMax = 255.0;
        this.bZero = 0.0;
        this.bScale = 1.0;
    }

    public int getPermutation() {
        return this.modePerm;
    }

    public void permutation(int n) {
        int n2 = -1;
        if (n == this.modePerm) {
            return;
        }
        if (this.modePerm == 0 && n == 1 || this.modePerm == 1 && n == 0) {
            n2 = 1;
        } else if (this.modePerm == 0 && n == 2 || this.modePerm == 2 && n == 0) {
            n2 = 0;
        } else if (this.modePerm == 1 && n == 2) {
            n2 = 2;
        } else if (this.modePerm == 2 && n == 1) {
            n2 = 3;
        }
        boolean bl = this.modePerm == 0 ? this.loadInRam(0, this.depth) : this.isFullyInRam(0, this.depth);
        this.flagProcessing = true;
        this.pourcent = -1.0;
        this.aladin.calque.repaintAll();
        new ThreadPermute(n, n2, bl).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPermute(int n, boolean bl) {
        int n2;
        Object object;
        int n22;
        int n3;
        int n4 = n == 0 || n == 2 ? this.depth : (n3 = n == 3 ? this.height : this.width);
        int n5 = n == 1 || n == 3 ? this.depth : (n == 2 ? this.width : this.height);
        int n6 = n == 2 || n == 1 ? this.height : this.width;
        ArrayList<PlanImageBlinkItem> arrayList = null;
        int n7 = n22 = bl ? 1 : 0;
        while (n22 < 2) {
            if (!bl) {
                for (PlanImageBlinkItem object2 : this.vFrames) {
                    object2.pixelsOrigin = null;
                }
                this.aladin.gc();
            }
            try {
                arrayList = new ArrayList<PlanImageBlinkItem>(n6);
                for (int i = 0; i < n6; ++i) {
                    byte[] vector = new byte[n3 * n5];
                    object = bl ? new byte[n3 * n5 * this.npix] : null;
                    arrayList.add(new PlanImageBlinkItem(this.label, vector, (byte[])object, false, null, 0L));
                }
                break;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.aladin.console.printError("!!! Not enough memory => trying Cube permutation without true pixels...");
                bl = false;
                arrayList = null;
                System.gc();
                ++n22;
            }
        }
        double d = 100.0 / (double)this.depth;
        boolean bl2 = false;
        while (n2 < this.depth) {
            this.pourcent += d;
            object = this.vFrames.get(n2);
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    PlanImageBlinkItem planImageBlinkItem = (PlanImageBlinkItem)arrayList.get(n == 2 || n == 1 ? i : j);
                    int n8 = i * this.width + j;
                    void var15_26 = (n == 1 || n == 3 ? n2 : (n == 2 ? j : i)) * n3 + (n == 0 || n == 2 ? n2 : (n == 3 ? i : j));
                    planImageBlinkItem.pixels[var15_26] = ((PlanImageBlinkItem)object).pixels[n8];
                    if (!bl) continue;
                    System.arraycopy(((PlanImageBlinkItem)object).pixelsOrigin, n8 * this.npix, planImageBlinkItem.pixelsOrigin, (int)(var15_26 * this.npix), this.npix);
                }
            }
            ++n2;
        }
        Vector<PlanImageBlinkItem> vector = new Vector<PlanImageBlinkItem>(n6);
        for (PlanImageBlinkItem planImageBlinkItem : arrayList) {
            vector.add(planImageBlinkItem);
        }
        object = this;
        synchronized (object) {
            this.vFrames = vector;
            this.naxis1 = this.width = n3;
            this.naxis2 = this.height = n5;
            this.depth = n6;
            this.oLastFrame = -1;
            this.setCubeFrame(0.0);
        }
    }

    private void permuteCalib(int n) {
        try {
            if (this.headerFits == null) {
                return;
            }
            String string = this.headerFits.getOriginalHeaderFits();
            if (n == 1) {
                string = this.modifCalib(string, new String[]{"2-3", "3-2"});
            } else if (n == 2) {
                string = this.modifCalib(string, new String[]{"1-3", "3-1"});
            }
            Projection projection = new Projection(2, new Calib(new HeaderFits(string)));
            this.setNewProjD(projection);
            this.setHasSpecificCalib();
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            this.projd = null;
            this.projD = null;
            return;
        }
    }

    private String modifCalib(String string, String[] stringArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            if (!string2.startsWith("COMMENT") && !string2.startsWith("HISTORY") && (n = string2.indexOf(61)) != -1) {
                char c = ' ';
                --n;
                while (n > 0 && Character.isWhitespace(c = string2.charAt(n))) {
                    --n;
                }
                if (n > 0 && Character.isDigit(c)) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        char c2 = stringArray[i].charAt(0);
                        char c3 = stringArray[i].charAt(stringArray[i].length() - 1);
                        if (c != c2) continue;
                        string2 = string2.substring(0, n) + c3 + string2.substring(n + 1);
                        break;
                    }
                }
            }
            stringBuffer.append(string2 + "\n");
        }
        return stringBuffer.toString();
    }

    @Override
    protected boolean setActivated(boolean bl) {
        if (bl = super.setActivated(bl)) {
            this.aladin.view.startTimer();
        }
        return bl;
    }

    @Override
    protected boolean waitForPlan() {
        this.addFrame(this.tmpP);
        return true;
    }

    @Override
    public void run() {
        if (this.flagRecut) {
            this.flagRecut = false;
            this.runRecut();
            return;
        }
        if (!this.flagAppend) {
            Aladin.trace(1, "Creating the " + Tp[this.type] + " plane " + this.label);
            if (this instanceof PlanImageCube) {
                this.planReady(super.waitForPlan());
            } else {
                this.planReady(this.waitForPlan());
                this.pRef = null;
            }
            this.flagAppend = true;
        } else {
            Aladin.trace(1, "Adding planes to " + this.label);
            this.addFrame(this.tmpP);
            this.flagOk = true;
        }
        this.aladin.view.startTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addPlan(PlanImage planImage) {
        this.flagOk = false;
        this.flagProcessing = true;
        this.tmpP = new PlanImage[1];
        this.tmpP[0] = planImage;
        this.aladin.calque.select.repaint();
        PlanImageBlink planImageBlink = this;
        synchronized (planImageBlink) {
            this.runme = new Thread((Runnable)this, "AladinBlinkAdd");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    protected synchronized void addFrame(String string, byte[] byArray, byte[] byArray2, boolean bl, String string2, long l) {
        if (this.vFrames == null) {
            this.vFrames = new Vector();
        }
        this.vFrames.addElement(new PlanImageBlinkItem(string, byArray, byArray2, bl, string2, l));
    }

    protected synchronized void addFrame(PlanImage[] planImageArray) {
        PlanImage planImage;
        int n;
        Aladin.trace(3, "Adding " + planImageArray.length + " frame(s)...");
        Coord coord = new Coord();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.width;
        int n5 = this.width * this.height;
        byte[][] byArray = new byte[planImageArray.length][n5];
        boolean[] blArray = new boolean[planImageArray.length];
        boolean bl = true;
        for (n = 0; n < planImageArray.length; ++n) {
            blArray[n] = !Projection.isOk(this.projd) && !Projection.isOk(planImageArray[n].projd);
            if (blArray[n] || (blArray[n] = this.projd.c.TheSame(planImageArray[n].projd.c))) {
                planImageArray[n].getLinearPixels8(byArray[n]);
                Aladin.trace(4, "PlanImageBlink.addFrame() : " + planImageArray[n].label);
                continue;
            }
            Aladin.trace(4, "PlanImageBlink.addFrame() : " + planImageArray[n].label + " (resampled)");
            bl = false;
        }
        if (!bl) {
            for (int i = 0; i < n5; ++i) {
                coord.x = i % n4;
                coord.y = i / n4;
                this.projd.getCoord(coord);
                if (Double.isNaN(coord.al)) continue;
                for (n = 0; n < planImageArray.length; ++n) {
                    if (blArray[n]) continue;
                    planImage = planImageArray[n];
                    planImage.projd.getXY(coord);
                    if (!Double.isNaN(coord.x)) {
                        n2 = (int)Math.round(coord.x);
                        n3 = (int)Math.round(coord.y);
                        if (n2 >= 0 && n2 < planImage.width && n3 >= 0 && n3 < planImage.height) {
                            int n6 = 0xFF & planImage.getBufPixels8()[n3 * planImage.width + n2];
                            byArray[n][i] = (byte)planImage.cm.getBlue(n6);
                        }
                    }
                    if (i * planImageArray.length % 10000 != 0) continue;
                    this.setPourcent(i * 100 / n5);
                    if (!Aladin.isSlow) continue;
                    Util.pause(10);
                }
            }
        }
        for (n = 0; n < planImageArray.length; ++n) {
            planImage = planImageArray[n];
            this.vFrames.addElement(new PlanImageBlinkItem(planImage.label, byArray[n], null, planImage.cacheFromOriginalFile, planImage.cacheID, planImage.cacheOffset));
        }
        this.setPourcent(-1.0);
        this.flagOk = true;
        this.flagProcessing = false;
        Aladin.trace(3, "Adding a frame achieved...");
        this.changeImgID();
        this.aladin.view.repaintAll();
    }

    @Override
    protected boolean hasOriginalPixels() {
        PlanImageBlinkItem planImageBlinkItem = this.vFrames.elementAt(0);
        return planImageBlinkItem.pixelsOrigin != null || planImageBlinkItem.cacheID != null;
    }

    @Override
    protected boolean recut(double d, double d2, boolean bl) {
        if (!this.hasOriginalPixels()) {
            return false;
        }
        this.getLock();
        this.flagUpdating = true;
        if (d == -1.0 && d2 == -1.0) {
            d = this.dataMinFits;
            d2 = this.dataMaxFits;
        }
        this._min = d;
        this._max = d2;
        this._autocut = bl;
        this.flagRecut = true;
        this._restart = false;
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        int n = viewSimple.cubeControl.lastFrame;
        this.activePixelsOrigin(n);
        PlanImageBlinkItem planImageBlinkItem = this.vFrames.elementAt(n);
        this.pixelsOriginFromCache();
        this.getPix8Bits(planImageBlinkItem.pixels, this.pixelsOrigin, this.bitpix, this.width, this.height, d, d2, bl, 0, 0, 0);
        PlanImageBlink.invImageLine(this.width, this.height, planImageBlinkItem.pixels);
        this.changeImgID();
        this.calculPixelsZoom(planImageBlinkItem.pixels);
        this.aladin.calque.select.repaint();
        this.aladin.calque.zoom.zoomView.repaint();
        viewSimple.repaint();
        this._autocut = false;
        this._min = this.pixelMin;
        this._max = this.pixelMax;
        if (!this.isThreadingRecut()) {
            this.setThreadRecut(new Thread((Runnable)this, "AladinBlinkRecut")).start();
        } else {
            this.recutCubeAgain();
        }
        return true;
    }

    synchronized Thread setThreadRecut(Thread thread) {
        this.threadRecut = thread;
        return thread;
    }

    synchronized boolean isThreadingRecut() {
        return this.threadRecut != null;
    }

    private synchronized void setLock(boolean bl) {
        this.lock = bl;
    }

    private synchronized boolean isLocked() {
        return this.lock;
    }

    private void getLock() {
        while (this.isLocked()) {
            Util.pause(10);
        }
    }

    synchronized void setRestart(boolean bl) {
        this._restart = bl;
    }

    synchronized boolean isRestart() {
        return this._restart;
    }

    private void recutCubeAgain() {
        this.setRestart(true);
    }

    private void runRecut() {
        this.recutCube(this._min, this._max, this._autocut);
    }

    protected boolean recutCube(double d, double d2, boolean bl) {
        this.setRestart(false);
        this.setLock(false);
        Date date = new Date();
        String string = null;
        byte[] byArray = new byte[this.width * this.height * this.npix];
        byte[] byArray2 = null;
        RandomAccessFile randomAccessFile = null;
        Aladin.trace(3, "Original cube pixels reloaded frame by frame");
        for (int i = 0; i < this.depth; ++i) {
            if (i % 5 == 0) {
                Util.pause(10);
            }
            try {
                if (this.isRestart()) {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    byArray = null;
                    return this.recutCube(this._min, this._max, this._autocut);
                }
                PlanImageBlinkItem planImageBlinkItem = this.vFrames.elementAt(i);
                if (planImageBlinkItem.pixelsOrigin != null) {
                    byArray2 = planImageBlinkItem.pixelsOrigin;
                } else {
                    if (string != planImageBlinkItem.cacheID) {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                        randomAccessFile = new RandomAccessFile(new File(planImageBlinkItem.cacheID), "r");
                        string = planImageBlinkItem.cacheID;
                    }
                    randomAccessFile.seek(planImageBlinkItem.cacheOffset);
                    randomAccessFile.readFully(byArray);
                    byArray2 = byArray;
                }
                this.getPix8Bits(planImageBlinkItem.pixels, byArray2, this.bitpix, this.width, this.height, d, d2, bl, 0, 0, 0);
                PlanImageBlink.invImageLine(this.width, this.height, planImageBlinkItem.pixels);
                this.setPourcent(99.0 * (double)i / (double)this.depth);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Error on frame " + i);
                exception.printStackTrace();
            }
        }
        try {
            randomAccessFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date date2 = new Date();
        long l = (int)(date2.getTime() - date.getTime());
        date = date2;
        Aladin.trace(3, " => Full cube contrast adjustement in " + l + " ms");
        byArray = null;
        this.flagOk = true;
        this.flagUpdating = false;
        this.changeImgID();
        this.setPourcent(-1.0);
        this.aladin.view.repaintAll();
        Util.pause(1000);
        if (this._restart) {
            return this.recutCube(this._min, this._max, this._autocut);
        }
        this.getLock();
        this.setThreadRecut(null);
        this.setLock(false);
        return true;
    }

    @Override
    protected boolean getFromCache() {
        if (this.pixelsOrigin != null) {
            return true;
        }
        if (this.oLastFrame != -1) {
            PlanImageBlinkItem planImageBlinkItem = this.vFrames.elementAt(this.oLastFrame);
            if (planImageBlinkItem.pixelsOrigin != null) {
                this.pixelsOrigin = planImageBlinkItem.pixelsOrigin;
                return true;
            }
        }
        return super.getFromCache();
    }

    protected synchronized boolean freeRam() {
        if (this.loadInRamInProgress) {
            this.loadInRamAborting = true;
        }
        return this.freeRam(-1L) > 0L;
    }

    protected synchronized long freeRam(long l) {
        long l2 = 0L;
        if (this.vFrames == null) {
            return 0L;
        }
        Enumeration<PlanImageBlinkItem> enumeration = this.vFrames.elements();
        while (enumeration.hasMoreElements()) {
            PlanImageBlinkItem planImageBlinkItem = enumeration.nextElement();
            if (planImageBlinkItem.pixelsOrigin == null) continue;
            planImageBlinkItem.pixelsOrigin = null;
            if (l == -1L || (l2 += (long)planImageBlinkItem.pixelsOrigin.length) <= l) continue;
            break;
        }
        if (l2 > 0L) {
            Aladin.trace(4, "PlanImageBlink.freeRam(" + l + ") [" + this.label + "] (free " + (double)l2 / 1048576.0 + "MB) ...");
        }
        return l2;
    }

    @Override
    protected boolean isCube() {
        return true;
    }

    synchronized boolean isFullyInRam(int n, int n2) {
        for (int i = n; i < this.depth && i < n + n2; ++i) {
            if (this.vFrames.elementAt((int)i).pixelsOrigin != null) continue;
            return false;
        }
        return true;
    }

    private synchronized boolean loadInRam(int n, int n2) {
        if (this.isFullyInRam(n, n2)) {
            Aladin.trace(4, "PlanImageBlink.loadInRam(" + n + "," + n2 + "): reloading not required (fully in Ram)");
            return true;
        }
        try {
            boolean bl;
            long l = (long)this.width * (long)this.height * (long)n2 * (long)this.npix;
            if (l >= Integer.MAX_VALUE) {
                return false;
            }
            if (this.loadInRamInProgress) {
                Aladin.trace(4, "PlanImageBlink.loadInRam(" + n + "," + n2 + "): loading still in progress => no launch new one");
                return false;
            }
            this.loadInRamAborting = false;
            this.loadInRamInProgress = true;
            double d = (double)this.width * (double)this.height * (double)n2 * (double)(this.npix + 1) / 1048576.0;
            boolean bl2 = bl = this.aladin.getMem() - d > (double)Aladin.MARGERAM;
            if (!bl && this.aladin.freeSomeRam((long)(d * 1024.0 * 1024.0), this) > 0L) {
                bl = this.aladin.getMem() - d > (double)Aladin.MARGERAM;
            }
            Aladin.trace(4, "PlanImageBlink.loadInRam(" + n + "," + n2 + "): ask for " + d + "Mo : " + (bl ? "enough space => loading..." : "Not enough space => ignored"));
            if (!bl) {
                this.loadInRamInProgress = false;
                return false;
            }
            int n3 = this.width * this.height * this.npix;
            for (int i = n; i < this.depth && i < n + n2; ++i) {
                PlanImageBlinkItem planImageBlinkItem = this.vFrames.elementAt(i);
                if (planImageBlinkItem.pixelsOrigin != null) continue;
                planImageBlinkItem.pixelsOrigin = new byte[n3];
                if (this.cacheIDBis != planImageBlinkItem.cacheID) {
                    if (this.fCacheBis != null) {
                        try {
                            this.fCacheBis.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.cacheIDBis = planImageBlinkItem.cacheID;
                    this.fCacheBis = new RandomAccessFile(new File(this.cacheIDBis), "r");
                }
                if (this.loadInRamAborting) {
                    throw new Exception("LoadInRam abort by freeRam call");
                }
                this.seekAndRead(this.fCacheBis, planImageBlinkItem.cacheOffset, planImageBlinkItem.pixelsOrigin, 0, n3);
            }
            this.loadInRamInProgress = false;
            return true;
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            this.loadInRamInProgress = false;
            return false;
        }
    }

    protected double getPixel(int n, int n2, int n3) throws Exception {
        PlanImageBlinkItem planImageBlinkItem = this.vFrames.elementAt(n3);
        byte[] byArray = planImageBlinkItem.pixelsOrigin;
        if (planImageBlinkItem.pixelsOrigin != null) {
            return this.getPixVal(byArray, this.bitpix, n2 * this.width + n) * this.bScale + this.bZero;
        }
        if (this.cacheIDBis != planImageBlinkItem.cacheID) {
            if (this.fCacheBis != null) {
                try {
                    this.fCacheBis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cacheIDBis = planImageBlinkItem.cacheID;
            this.fCacheBis = new RandomAccessFile(new File(this.cacheIDBis), "r");
        }
        if (this.bufCache == null) {
            this.bufCache = new byte[this.npix];
        }
        this.seekAndRead(this.fCacheBis, planImageBlinkItem.cacheOffset + (long)(this.npix * (n2 * this.width + n)), this.bufCache, 0, this.bufCache.length);
        return this.getPixVal(this.bufCache, this.bitpix, n) * this.bScale + this.bZero;
    }

    private synchronized void seekAndRead(RandomAccessFile randomAccessFile, long l, byte[] byArray, int n, int n2) throws Exception {
        randomAccessFile.seek(l);
        randomAccessFile.readFully(byArray, n, n2);
    }

    protected double[][][] getCube(int n, int n2, int n3, int n4, int n5, int n6) throws Exception {
        return this.getCube(null, n, n2, n3, n4, n5, n6);
    }

    protected double[][][] getCube(double[][][] dArray, int n, int n2, int n3, int n4, int n5, int n6) throws Exception {
        if (dArray == null) {
            dArray = new double[n4][n5][n6];
        }
        this.loadInRam(n3, n6);
        byte[] byArray = new byte[n4 * this.npix];
        for (int i = n3; i < n3 + n6; ++i) {
            int n7;
            int n8;
            PlanImageBlinkItem planImageBlinkItem = this.vFrames.elementAt(i);
            byte[] byArray2 = planImageBlinkItem.pixelsOrigin;
            if (planImageBlinkItem.pixelsOrigin != null) {
                for (n8 = n2; n8 < n2 + n5; ++n8) {
                    for (n7 = n; n7 < n + n4; ++n7) {
                        dArray[n7 - n][n8 - n2][i - n3] = this.getPixVal(byArray2, this.bitpix, n8 * this.width + n7) * this.bScale + this.bZero;
                    }
                }
                continue;
            }
            if (this.cacheIDBis != planImageBlinkItem.cacheID) {
                if (this.fCacheBis != null) {
                    try {
                        this.fCacheBis.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.cacheIDBis = planImageBlinkItem.cacheID;
                this.fCacheBis = new RandomAccessFile(new File(this.cacheIDBis), "r");
            }
            for (n8 = n2; n8 < n2 + n5; ++n8) {
                this.seekAndRead(this.fCacheBis, planImageBlinkItem.cacheOffset + (long)(this.npix * (n8 * this.width + n)), byArray, 0, byArray.length);
                for (n7 = 0; n7 < n4; ++n7) {
                    dArray[n7][n8 - n2][i - n3] = this.getPixVal(byArray, this.bitpix, n7) * this.bScale + this.bZero;
                }
            }
        }
        return dArray;
    }

    @Override
    protected String getSizeInfo() {
        return this.width + "x" + this.height + " pixels (8bits kept)";
    }

    @Override
    public int getDepth() {
        return this.vFrames == null ? 0 : this.vFrames.size();
    }

    @Override
    protected String getFrameLabel(int n) {
        if (!this.active) {
            return this.label;
        }
        return this.vFrames.elementAt((int)n).label;
    }

    protected byte[] getFrame(int n) {
        return this.vFrames.elementAt((int)n).pixels;
    }

    @Override
    protected byte getPixel8bit(int n, double d, double d2) {
        return this.vFrames.elementAt((int)n).pixels[(int)d2 * this.width + (int)d];
    }

    @Override
    protected void activeCubePixels(ViewSimple viewSimple) {
        if (this.flagUpdating) {
            return;
        }
        if (this.ooLastFrame == viewSimple.cubeControl.lastFrame) {
            return;
        }
        if (viewSimple.cubeControl.mode == CubeControl.PAUSE) {
            this.activePixelsOrigin(viewSimple);
        } else {
            ((PlanImage)viewSimple.pref).noOriginalPixels();
        }
        if (this.oLastFrame == viewSimple.cubeControl.lastFrame) {
            return;
        }
        this.oLastFrame = viewSimple.cubeControl.lastFrame;
        PlanImageBlinkItem planImageBlinkItem = this.vFrames.elementAt(this.oLastFrame);
        this.setBufPixels8(planImageBlinkItem.pixels);
        this.pixelsOrigin = planImageBlinkItem.pixelsOrigin;
        this.aladin.calque.zoom.zoomView.resetImgID();
        this.aladin.calque.zoom.zoomView.repaint();
    }

    @Override
    protected boolean setCubeFrame(double d) {
        int n = (int)d;
        if (this.flagUpdating) {
            return false;
        }
        if (this.oLastFrame == n) {
            return false;
        }
        this.oLastFrame = n;
        this.z = this.oLastFrame;
        PlanImageBlinkItem planImageBlinkItem = this.vFrames.elementAt(this.oLastFrame);
        this.setBufPixels8(planImageBlinkItem.pixels);
        this.pixelsOrigin = planImageBlinkItem.pixelsOrigin;
        return true;
    }

    protected void activePixelsOrigin(ViewSimple viewSimple) {
        this.activePixelsOrigin(viewSimple, this);
    }

    protected void activePixelsOrigin(int n) {
        this.activePixelsOrigin(this, n);
    }

    protected void activePixelsOrigin(ViewSimple viewSimple, PlanImage planImage) {
        this.activePixelsOrigin(planImage, viewSimple.cubeControl.lastFrame);
    }

    private void activePixelsOrigin(PlanImage planImage, int n) {
        this.ooLastFrame = n;
        PlanImageBlinkItem planImageBlinkItem = this.vFrames.elementAt(n);
        planImage.cacheID = planImageBlinkItem.cacheID;
        planImage.cacheOffset = planImageBlinkItem.cacheOffset;
        planImage.cacheFromOriginalFile = planImageBlinkItem.cacheFromOriginalFile;
        planImage.pixelsOrigin = planImageBlinkItem.pixelsOrigin;
    }

    protected void getPixels(byte[] byArray, int n, int n2, int n3, int n4, int n5, double d) {
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (n + n3 > this.width) {
            n8 = n + n3 - this.width;
            n3 -= n8;
        }
        if (n2 + n4 > this.height) {
            n7 = n2 + n4 - this.height;
            n4 -= n7;
        }
        if (d == -1.0 || d == 0.0 || this.getDepth() == 1) {
            byte[] byArray2 = this.getFrame(n5);
            int n9 = n2 + n4;
            for (int i = n2; i < n9; ++i) {
                System.arraycopy(byArray2, i * this.width + n, byArray, n6, n3);
                n6 += n3 + n8;
            }
            return;
        }
        byte[] byArray3 = this.getFrame(n5);
        byte[] byArray4 = this.getFrame(n5 == this.getDepth() - 1 ? 0 : n5 + 1);
        double d2 = 1.0 - d;
        int n10 = n2 + n4;
        for (int i = n2; i < n10; ++i) {
            int n11 = n + n3;
            for (int j = n; j < n11; ++j) {
                int n12 = i * this.width + j;
                double d3 = (double)(byArray3[n12] & 0xFF) * d2 + (double)(byArray4[n12] & 0xFF) * d;
                byArray[n6++] = (byte)((int)d3 & 0xFF);
            }
            if (n8 == 0) continue;
            n6 += n8;
        }
    }

    class ThreadPermute
    extends Thread {
        int m;
        int action;
        boolean full;

        public ThreadPermute(int n, int n2, boolean bl) {
            this.m = n;
            this.action = n2;
            this.full = bl;
        }

        @Override
        public void run() {
            PlanImageBlink.this.doPermute(this.action, this.full);
            PlanImageBlink.this.permuteCalib(this.m);
            PlanImageBlink.this.modePerm = this.m;
            PlanImageBlink.this.flagProcessing = false;
            PlanImageBlink.this.pourcent = -1.0;
            PlanImageBlink.this.changeImgID();
            PlanImageBlink.this.aladin.calque.repaintAll();
        }
    }
}

