/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.PlanImageRGB;
import cds.aladin.ResourceNode;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class PlanImageColor
extends PlanImageRGB {
    protected PlanImageColor(Aladin aladin, String string, URL uRL, MyInputStream myInputStream) {
        super(aladin, string, uRL, myInputStream);
    }

    protected PlanImageColor(Aladin aladin, String string, URL uRL, MyInputStream myInputStream, ResourceNode resourceNode) {
        super(aladin, string, uRL, myInputStream, resourceNode);
    }

    protected PlanImageColor(Aladin aladin, MyInputStream myInputStream, int n, URL uRL, String string, String string2, String string3, String string4, int n2, int n3, Obj obj, ResourceNode resourceNode) {
        super(aladin, myInputStream, n, uRL, string, string2, string3, string4, n2, n3, obj, resourceNode);
        this.flagBlue = true;
        this.flagGreen = true;
        this.flagRed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean cacheImageNatif(MyInputStream myInputStream) {
        Date date = new Date();
        this.setPourcent(1.0);
        Aladin.trace(2, "Loading colored image");
        long l = System.currentTimeMillis();
        ImageInputStream imageInputStream = null;
        try {
            long l2 = myInputStream.getType();
            String string = (l2 & 2L) != 0L ? "jpeg" : ((l2 & 0x10000L) != 0L ? "png" : "gif");
            this.pixMode = (l2 & 2L) != 0L ? 1 : 0;
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
            ImageReader imageReader = iterator.next();
            imageInputStream = ImageIO.createImageInputStream(myInputStream);
            imageReader.setInput(imageInputStream, true);
            this.naxis1 = this.width = imageReader.getWidth(0);
            this.naxis2 = this.height = imageReader.getHeight(0);
            long l3 = System.currentTimeMillis();
            Aladin.trace(3, "image (" + string + ") " + this.width + "x" + this.height + " created&loaded in " + (l3 - l) + " ms");
            l = l3;
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            double d = this.aladin.getMem();
            double d2 = (double)(this.width * this.height) * 4.0 / 1048576.0;
            Aladin.trace(4, "PlanImageColor.cacheImageNatif()... RAM=" + d + "MB imageSize=" + d2 + "MB");
            if (d < d2) {
                throw new Exception("Not enough memory for this image => required " + d2 + "MB !");
            }
            Aladin.trace(4, "PlanImageColor.cacheImageNatif()... loading huge image piece by piece...");
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
            Graphics graphics = bufferedImage.getGraphics();
            int n = 1024;
            double d3 = 98.0 / ((double)this.width * (double)this.height / (double)(n * n));
            double d4 = 0.0;
            for (int i = 0; i < this.height; i += n) {
                for (int j = 0; j < this.width; j += n) {
                    this.setPourcent(d4 += d3);
                    int n2 = j + n > this.width ? this.width - j : n;
                    int n3 = i + n > this.height ? this.height - i : n;
                    Rectangle rectangle = new Rectangle(j, i, n2, n3);
                    imageReadParam.setSourceRegion(rectangle);
                    BufferedImage bufferedImage2 = imageReader.read(0, imageReadParam);
                    graphics.drawImage(bufferedImage2, j, i, this.aladin);
                }
            }
            graphics.finalize();
            graphics = null;
            this.pixelsRGB = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            bufferedImage.flush();
            bufferedImage = null;
            l3 = System.currentTimeMillis();
            Aladin.trace(3, "RGB pixels extracted in " + (l3 - l) + " ms");
            l = l3;
            Date date2 = new Date();
            int n4 = (int)(date2.getTime() - date.getTime());
            date = date2;
            Aladin.trace(3, " => Loading in " + n4 + " ms");
            this.cm = ColorModel.getRGBdefault();
            this.setPourcent(99.0);
            this.video = 0;
        }
        catch (Exception exception) {
            this.setPourcent(-1.0);
            Aladin.error = exception.getMessage();
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (imageInputStream != null) {
                try {
                    imageInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }
}

