/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImageBlink;
import cds.aladin.ResourceNode;
import cds.tools.Util;
import java.io.RandomAccessFile;
import java.util.Date;

public class PlanImageCube
extends PlanImageBlink {
    private double crval3;
    private double crpix3;
    private double cdelt3;
    protected boolean fromCanal;
    private int precision = -1;

    protected PlanImageCube(Aladin aladin, String string, MyInputStream myInputStream, String string2, String string3, Obj obj, ResourceNode resourceNode, boolean bl, boolean bl2, Plan plan) {
        super(aladin, string, myInputStream, string2, string3, obj, resourceNode, bl, bl2, plan);
        this.type = 4;
        this.initDelay = 400;
    }

    protected String getCanalValue(int n) {
        if (this.precision == -1) {
            double d = Math.abs(this.cdelt3);
            this.precision = d < 0.001 ? 3 : (d < 0.01 ? 2 : (d < 100.0 ? 1 : 0));
        }
        return "" + (double)((int)Math.round(1000.0 * (((double)(n + 1) - this.crpix3) * this.cdelt3 + this.crval3))) / 1000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean cacheImageFits(MyInputStream myInputStream) throws Exception {
        int n;
        int n2;
        Aladin.trace(2, "Loading FITS " + Tp[this.type]);
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderFits((Plan)this, myInputStream);
        }
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        int n3 = this.headerFits.getIntFromHeader("NAXIS");
        if (n3 <= 1 && this.headerFits.getStringFromHeader("EXTEND") != null) {
            this.error = "_HEAD_XFITS_";
            if (n3 == 1) {
                try {
                    this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
                    myInputStream.skip(this.naxis1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return false;
        }
        this.naxis1 = this.width = this.headerFits.getIntFromHeader("NAXIS1");
        this.naxis2 = this.height = this.headerFits.getIntFromHeader("NAXIS2");
        this.depth = this.headerFits.getIntFromHeader("NAXIS3");
        this.pixMode = 2;
        this.npix = n2 = Math.abs(this.bitpix) / 8;
        long l = (long)this.width * (long)this.height * (long)this.depth * (long)n2;
        this.setPourcent(0.0);
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " NAXIS3=" + this.depth + " BITPIX=" + this.bitpix + " => size=" + l);
        this.loadFitsHeaderParam(this.headerFits);
        try {
            this.crpix3 = this.headerFits.getDoubleFromHeader("CRPIX3");
            this.crval3 = this.headerFits.getDoubleFromHeader("CRVAL3");
            this.cdelt3 = this.headerFits.getDoubleFromHeader("CDELT3");
            this.fromCanal = true;
        }
        catch (Exception exception) {
            this.fromCanal = false;
        }
        if (this.flagSkip) {
            myInputStream.skip(l);
        } else {
            Date date = new Date();
            boolean bl = false;
            int n4 = this.depth;
            double d = (double)this.width * (double)this.height * (double)this.depth * (double)(this.npix + 1) / 1048576.0;
            boolean bl2 = this.aladin.getMem() - d > (double)Aladin.MARGERAM;
            boolean bl3 = false;
            Aladin.trace(4, "PlanImageCube.loadImageFits() ask for " + d + "MB " + (bl2 ? "try in Ram" : "=> not enough space in RAM"));
            if (!bl2) {
                this.aladin.freeSomeRam((long)(d * 1024.0 * 1024.0), this);
                bl2 = this.aladin.getMem() - d / 10.0 > (double)Aladin.MARGERAM;
                double d2 = (double)this.width * (double)this.height * (double)this.npix;
                double d3 = (this.aladin.getMem() - (double)Aladin.MARGERAM) * 1024.0 * 1024.0 - (double)(this.width * this.height * this.depth);
                n4 = (int)(d3 / d2);
                Aladin.trace(4, "PlanImageCube.loadImageFits() [2nd test]  ask for " + d + "MB " + (bl2 ? "try in Ram " + n4 + " frames" : "not in RAM") + " freeRAM=" + d3 / 1048576.0 + "MB, one frame=" + d2 / 1048576.0 + "MB");
            }
            this.cacheFromOriginalFile = this.setCacheFromFile(myInputStream);
            RandomAccessFile randomAccessFile = null;
            int n5 = PlanImageCube.floor(l / (long)this.depth);
            this.pixelsOrigin = new byte[n5];
            int n6 = this.depth / 2 + 1;
            byte[] byArray = null;
            long l2 = 0L;
            try {
                int n7;
                if (!Aladin.STANDALONE) {
                    bl = true;
                    n7 = PlanImageCube.floor(l / 4L / (long)n5);
                    if (n6 > n7) {
                        n6 = n7;
                    }
                    byArray = new byte[PlanImageCube.round(n5 * n6)];
                    myInputStream.readFully(byArray);
                    System.arraycopy(byArray, (n6 - 1) * n5, this.pixelsOrigin, 0, n5);
                } else {
                    bl = false;
                    byArray = this.pixelsOrigin;
                    if (!this.cacheFromOriginalFile) {
                        for (n7 = 0; n7 < n6; n7 += 1) {
                            myInputStream.readFully(byArray);
                            if (!n7) {
                                randomAccessFile = this.beginInCache(byArray);
                                continue;
                            }
                            randomAccessFile.write(byArray);
                        }
                    } else {
                        l2 = myInputStream.getPos();
                        myInputStream.skip((long)(n6 - 1) * (long)n5);
                        myInputStream.readFully(byArray);
                    }
                }
                Aladin.trace(3, " => Cube autocut uses the frame " + n6);
                n7 = this.aladin.configuration.getCMCut() ? 1 : 0;
                this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, n7 != 0, 0, 0, 0, 0);
                double d4 = 0.0;
                double d5 = 0.0;
                for (int i = 0; i < this.depth; ++i) {
                    if (Aladin.levelTrace == 4) {
                        double d6 = this.aladin.getMem();
                        double d7 = d4 - d6;
                        if (Math.abs(d5 - d7) > 0.2 || d6 < (double)(Aladin.MARGERAM - 1)) {
                            Aladin.trace(4, "PlanImageCube.cacheImageFits(): frame " + i + " freeRam=" + d6 + "MB delta=" + d7 + "MB");
                        }
                        d4 = d6;
                        d5 = d7;
                    }
                    try {
                        this.setBufPixels8(new byte[this.width * this.height]);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        outOfMemoryError.printStackTrace();
                        Aladin.trace(4, "PlanImageCube.loadImageFits(): out of memory1 freeRam=" + this.aladin.getMem() + "MB => inRam=false...");
                        bl2 = false;
                        this.freeRam();
                        this.setBufPixels8(new byte[this.width * this.height]);
                    }
                    if (i < n6) {
                        if (bl) {
                            System.arraycopy(byArray, i * n5, this.pixelsOrigin, 0, n5);
                        } else {
                            if (i == 0) {
                                if (l2 != 0L) {
                                    randomAccessFile = new RandomAccessFile(this.cacheID, "r");
                                }
                                randomAccessFile.seek(l2);
                            }
                            randomAccessFile.readFully(this.pixelsOrigin);
                        }
                    } else {
                        myInputStream.readFully(this.pixelsOrigin);
                        if (randomAccessFile != null && !this.cacheFromOriginalFile) {
                            randomAccessFile.write(this.pixelsOrigin);
                        }
                    }
                    this.to8bits(this.getBufPixels8(), 0, this.pixelsOrigin, this.pixelsOrigin.length / this.npix, this.bitpix, this.pixelMin, this.pixelMax, true);
                    PlanImageCube.invImageLine(this.width, this.height, this.getBufPixels8());
                    String string = this.fromCanal ? this.getCanalValue(i) : this.label;
                    try {
                        if (bl2 && n4 < 0) {
                            Aladin.trace(4, "PlanImageCube.loadImageFits(): low memory2 (frame=" + i + ") => other frames not in RAM...");
                            bl3 = true;
                            bl2 = false;
                        }
                        this.addFrame(string, this.getBufPixels8(), bl2 ? this.pixelsOrigin : null, this.cacheFromOriginalFile, this.cacheID, this.cacheOffset);
                        if (bl2) {
                            this.pixelsOrigin = new byte[n5];
                            --n4;
                        }
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        outOfMemoryError.printStackTrace();
                        Aladin.trace(4, "PlanImageCube.loadImageFits(): out of memory freeRam=" + this.aladin.getMem() + "MB => inRam=false...");
                        bl2 = false;
                        this.freeRam();
                        this.addFrame(string, this.getBufPixels8(), null, this.cacheFromOriginalFile, this.cacheID, this.cacheOffset);
                    }
                    this.cacheOffset += (long)this.pixelsOrigin.length;
                    this.setPourcent(99.0 * (double)i / (double)this.depth);
                    if (i != 0) continue;
                    this.calculPixelsZoom();
                }
            }
            finally {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            byArray = null;
            this.noOriginalPixels();
            Date date2 = new Date();
            n = (int)(date2.getTime() - date.getTime());
            date = date2;
            Aladin.trace(3, " => Reading " + (!bl ? "(2 pass) " : "") + "and analyzing " + this.getDepth() + " frames in " + Util.round((double)n / 0.001, 3) + " s => " + (n != 0 ? Util.round((double)(l / (long)n / 1024L) * 1.024, 2) + " Mbyte/s" : "--") + (bl2 ? " (fully in RAM)" : (bl3 ? " (partially in RAM)" : "")));
        }
        if (n3 > 3) {
            try {
                long l3 = n2 * this.width * this.height;
                for (n = 3; n < n3; ++n) {
                    l3 *= (long)this.headerFits.getIntFromHeader("NAXIS" + (n + 1));
                }
                myInputStream.skip(l3 -= (long)(n2 * this.width * this.height));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        if (this.flagSkip) {
            return true;
        }
        this.creatDefaultCM();
        this.setPourcent(-1.0);
        return true;
    }
}

