/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImageBlinkItem;
import cds.aladin.PlanImageCube;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanRGBInterface;
import cds.aladin.ResourceNode;
import java.awt.image.ColorModel;
import java.util.Vector;

public final class PlanImageCubeRGB
extends PlanImageCube
implements PlanRGBInterface {
    private int[] pixelsZoomRGB = null;

    protected PlanImageCubeRGB(Aladin aladin, String string, MyInputStream myInputStream, String string2, String string3, Obj obj, ResourceNode resourceNode, boolean bl, boolean bl2, Plan plan) {
        super(aladin, string, myInputStream, string2, string3, obj, resourceNode, bl, bl2, plan);
        this.type = 20;
        this.initDelay = 400;
    }

    @Override
    protected void copy(Plan plan) {
        super.copy(plan);
        if (!(plan instanceof PlanImageRGB)) {
            return;
        }
        PlanImageRGB planImageRGB = (PlanImageRGB)plan;
        planImageRGB.pixelsRGB = this.getPixelsRGB();
    }

    protected int[] getFrameRGB(int n) {
        return ((PlanImageBlinkItem)this.vFrames.elementAt((int)n)).pixelsRGB;
    }

    @Override
    protected boolean cacheImageFits(MyInputStream myInputStream) throws Exception {
        int n;
        int n2;
        Aladin.trace(2, "Loading FITS " + Tp[this.type]);
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderFits((Plan)this, myInputStream);
        }
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        if (this.bitpix != 32 && this.bitpix != 24) {
            this.error = "BITPIX must be 24 or 32 for RGB or ARGB FITS cube !";
            return false;
        }
        this.pixMode = this.bitpix == 32 ? 0 : 1;
        int n3 = this.headerFits.getIntFromHeader("NAXIS");
        if (n3 <= 1 && this.headerFits.getStringFromHeader("EXTEND") != null) {
            this.error = "_HEAD_XFITS_";
            if (n3 == 1) {
                try {
                    this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
                    myInputStream.skip(this.naxis1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return false;
        }
        this.naxis1 = this.width = this.headerFits.getIntFromHeader("NAXIS1");
        this.naxis2 = this.height = this.headerFits.getIntFromHeader("NAXIS2");
        this.depth = this.headerFits.getIntFromHeader("NAXIS3");
        this.npix = n2 = this.bitpix / 8;
        long l = (long)this.width * (long)this.height * (long)this.depth * (long)n2;
        this.setPourcent(0.0);
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " NAXIS3=" + this.depth + " BITPIX=" + this.bitpix + " => size=" + l);
        this.loadFitsHeaderParam(this.headerFits);
        if (this.flagSkip) {
            myInputStream.skip(l);
        } else {
            double d = (double)l / 1048576.0;
            n = this.aladin.getMem() - d > 10.0 ? 1 : 0;
            Aladin.trace(4, "PlanImageCubeColor.loadImageFits() required " + d + "MB " + (n != 0 ? "" : "=> not enough space in RAM"));
            if (n == 0) {
                this.error = "Not enough RAM space";
                return false;
            }
            byte[] byArray = new byte[this.width * this.height * n2];
            for (int i = 0; i < this.depth; ++i) {
                myInputStream.readFully(byArray);
                int[] nArray = this.extractImageRGB(byArray, this.width, this.height, n2, i);
                this.addFrame(this.label, nArray);
                this.setPourcent(99.0 * (double)i / (double)this.depth);
            }
            this.noOriginalPixels();
        }
        if (n3 > 3) {
            try {
                long l2 = n2 * this.width * this.height;
                for (n = 3; n < n3; ++n) {
                    l2 *= (long)this.headerFits.getIntFromHeader("NAXIS" + (n + 1));
                }
                myInputStream.skip(l2 -= (long)(n2 * this.width * this.height));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        if (this.flagSkip) {
            return true;
        }
        this.cm = ColorModel.getRGBdefault();
        this.setPourcent(-1.0);
        return true;
    }

    private int[] extractImageRGB(byte[] byArray, int n, int n2, int n3, int n4) {
        int[] nArray = new int[n * n2];
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n6 = 0;
                for (int k = 0; k < n3; ++k) {
                    int n7 = 0xFF & byArray[n5++];
                    n6 = n6 << 8 | n7;
                }
                nArray[(n2 - i - 1) * n + j] = 0xFF000000 | n6;
            }
        }
        return nArray;
    }

    protected synchronized void addFrame(String string, int[] nArray) {
        if (this.vFrames == null) {
            this.vFrames = new Vector();
        }
        this.vFrames.addElement(new PlanImageBlinkItem(string, nArray));
    }

    @Override
    public int[] getPixelsRGB() {
        double d = this.aladin.view.getCurrentView().getCurrentFrameLevel();
        return this.getFrameRGB((int)d);
    }

    @Override
    public int getPixel8(int n, int n2) {
        int[] nArray = this.getPixelsRGB();
        return nArray[n2 * this.width + n];
    }

    public void getPixels(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int[] nArray2 = this.getFrameRGB(n5);
        int n7 = 0;
        int n8 = 0;
        if (n + n3 > this.width) {
            n8 = n + n3 - this.width;
            n3 -= n8;
        }
        if (n2 + n4 > this.height) {
            n7 = n2 + n4 - this.height;
            n4 -= n7;
        }
        int n9 = n2 + n4;
        for (int i = n2; i < n9; ++i) {
            System.arraycopy(nArray2, i * this.width + n, nArray, n6, n3);
            n6 += n3 + n8;
        }
    }

    @Override
    public void getPixels(int[] nArray, int n, int n2, int n3, int n4) {
        double d = this.aladin.view.getCurrentView().getCurrentFrameLevel();
        this.getPixels(nArray, n, n2, n3, n4, (int)d);
    }

    @Override
    public int[] getPixelsZoomRGB() {
        return this.pixelsZoomRGB;
    }

    @Override
    public void calculPixelsZoomRGB() {
        int[] nArray = this.getPixelsRGB();
        this.pixelsZoomRGB = PlanImageRGB.calculPixelsZoomRGB1(this.pixelsZoomRGB, nArray, this.width, this.height);
    }
}

