/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.Projection;
import cds.aladin.ResourceNode;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.io.RandomAccessFile;
import java.util.Date;

public class PlanImageHuge
extends PlanImage
implements Runnable {
    static final int LIMIT = 4096;
    protected int step;
    protected byte[] pixelsSub;
    protected int ox;
    protected int oy;
    protected int ow;
    protected int oh;
    private boolean restart;
    private boolean lock;
    private Thread thread;
    protected boolean isExtracting;
    private boolean toSubImage;
    private PixelsSub[] vPixelsSub = new PixelsSub[17];
    private int nbPixelsSub = 0;
    private int nextPixelsSub = 0;
    private int _x;
    private int _y;
    private int _w;
    private int _h;
    private byte[] pixelsWork;
    private byte[] buf;

    protected PlanImageHuge(Aladin aladin, String string, MyInputStream myInputStream, String string2, String string3, Obj obj, ResourceNode resourceNode, boolean bl, boolean bl2, Plan plan) {
        super(aladin, string, myInputStream, string2, string3, obj, resourceNode, bl, bl2, plan);
        this.type = 15;
    }

    @Override
    protected boolean isSync() {
        return super.isSync() && !this.isExtracting;
    }

    protected int getStep() {
        return this.step;
    }

    protected boolean fromSubImage(double d, int n, int n2) {
        return (double)(n * this.step) / d < 4096.0 && (double)(n2 * this.step) / d < 4096.0;
    }

    protected byte[] cropPixels(int n, int n2, int n3, int n4) {
        int n5 = (n - this.ox) * this.step;
        int n6 = (n2 - this.oy) * this.step;
        int n7 = n3 * this.step;
        int n8 = n4 * this.step;
        byte[] byArray = new byte[n7 * n8];
        this.getPixels(byArray, this.pixelsSub, this.ow * this.step, this.oh * this.step, n5, n6, n7, n8);
        return byArray;
    }

    protected boolean loadSubImage(int n, int n2, int n3, int n4) {
        int n5 = 128 / this.step;
        n2 -= n5;
        n3 += 2 * n5;
        n4 += 2 * n5;
        if ((n -= n5) < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n + n3) * this.step >= this.naxis1) {
            n3 = this.naxis1 / this.step - n - 1;
        }
        if ((n2 + n4) * this.step >= this.naxis2) {
            n4 = this.naxis2 / this.step - n2 - 1;
        }
        return this.getSubImage(n, n2, n3, n4);
    }

    private void waitLock() {
        while (!this.getLock()) {
            Util.pause(10);
        }
    }

    private synchronized boolean getLock() {
        if (this.lock) {
            return false;
        }
        this.lock = true;
        return true;
    }

    private synchronized void unlock() {
        this.lock = false;
    }

    protected boolean inSubImage(int n, int n2, int n3, int n4) {
        return this.selectPixelsSub(n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addPixelsSub(byte[] byArray, int n, int n2, int n3, int n4) {
        PixelsSub[] pixelsSubArray = this.vPixelsSub;
        synchronized (this.vPixelsSub) {
            if (this.nbPixelsSub < this.vPixelsSub.length) {
                this.nextPixelsSub = this.nbPixelsSub++;
            } else {
                this.nextPixelsSub = 0;
                block3: for (int i = 0; i < this.vPixelsSub.length; ++i) {
                    PixelsSub pixelsSub = this.vPixelsSub[i];
                    for (int j = 0; j < this.aladin.view.getModeView(); ++j) {
                        ViewSimple viewSimple = this.aladin.view.viewSimple[j];
                        if (viewSimple.isFree() || viewSimple.pref != this || !viewSimple.flagHuge || pixelsSub.agree(viewSimple.xHuge, viewSimple.yHuge, viewSimple.wHuge, viewSimple.hHuge)) continue;
                        this.nextPixelsSub = j;
                        continue block3;
                    }
                }
            }
            this.vPixelsSub[this.nextPixelsSub] = new PixelsSub(byArray, n, n2, n3, n4);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return this.nextPixelsSub;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPixelSub() {
        PixelsSub[] pixelsSubArray = this.vPixelsSub;
        synchronized (this.vPixelsSub) {
            for (int i = 0; i < this.nbPixelsSub; ++i) {
                this.vPixelsSub[i] = null;
            }
            this.nbPixelsSub = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean selectPixelsSub(int n, int n2, int n3, int n4) {
        PixelsSub[] pixelsSubArray = this.vPixelsSub;
        synchronized (this.vPixelsSub) {
            for (int i = 0; i < this.nbPixelsSub; ++i) {
                PixelsSub pixelsSub = this.vPixelsSub[i];
                if (!pixelsSub.agree(n, n2, n3, n4)) continue;
                this.pixelsSub = pixelsSub.pixels;
                this.ox = pixelsSub.ox;
                this.oy = pixelsSub.oy;
                this.ow = pixelsSub.ow;
                this.oh = pixelsSub.oh;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return false;
        }
    }

    private boolean getSubImage(int n, int n2, int n3, int n4) {
        if (this.inSubImage(n, n2, n3, n4)) {
            return true;
        }
        this.flagUpdating = true;
        this.aladin.calque.select.repaint();
        this.waitLock();
        this._x = n;
        this._y = n2;
        this._w = n3;
        this._h = n4;
        if (this.isExtracting) {
            this.restart = true;
        } else {
            this.toSubImage = true;
            this.thread = new Thread((Runnable)this, "HugeSubImage");
            this.thread.start();
        }
        return false;
    }

    @Override
    public void run() {
        if (!this.toSubImage) {
            super.run();
            return;
        }
        this.toSubImage = false;
        this.isExtracting = true;
        this.aladin.calque.select.repaint();
        this.getSubImageThread();
    }

    private void getSubImageThread() {
        int n = this._x;
        int n2 = this._y;
        int n3 = this._w;
        int n4 = this._h;
        this.ox = n;
        this.oy = n2;
        this.ow = n3;
        this.oh = n4;
        this.restart = false;
        this.unlock();
        long l = System.currentTimeMillis();
        double d = 255.0 / (this.pixelMax - this.pixelMin);
        try {
            int n5;
            int n6 = n3 * n4 * this.step * this.step;
            this.pixelsWork = new byte[n6];
            this.buf = new byte[n3 * this.step * this.npix];
            int n7 = n3 * this.step;
            int n8 = 0;
            for (n5 = this.naxis2 - (n2 + n4) * this.step; n5 < this.naxis2 - n2 * this.step; ++n5) {
                this.fCache.seek(this.cacheOffset + ((long)n5 * (long)this.naxis1 + (long)(n * this.step)) * (long)this.npix);
                this.fCache.readFully(this.buf);
                for (int i = 0; i < n7; ++i) {
                    double d2 = this.getPixVal(this.buf, this.bitpix, i);
                    if (Double.isNaN(d2) || this.isBlank && d2 == this.blank) {
                        this.pixelsWork[n8++] = 0;
                        continue;
                    }
                    this.pixelsWork[n8++] = (byte)(1 + (d2 <= this.pixelMin ? 0 : (d2 >= this.pixelMax ? 254 : (int)((d2 - this.pixelMin) * d))) & 0xFF);
                }
                if (!this.restart) continue;
                this.restart = false;
                this.getSubImageThread();
                return;
            }
            this.isExtracting = false;
            PlanImageHuge.invImageLine(n3 * this.step, n4 * this.step, this.pixelsWork);
            this.pixelsSub = this.pixelsWork;
            n5 = this.addPixelsSub(this.pixelsSub, this.ox, this.oy, this.ow, this.oh);
            Aladin.trace(3, "getSubImage[" + n5 + "] from " + this.label + " (" + n * this.step + "," + n2 * this.step + " " + n3 * this.step + "x" + n4 * this.step + ") in " + (System.currentTimeMillis() - l) + "ms");
            this.nextImgID();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.flagUpdating = false;
        this.aladin.view.repaintAll();
    }

    @Override
    public int getPixel8(int n, int n2) {
        if (this.inSubImage(n / this.step, n2 / this.step, 1, 1)) {
            return this.pixelsSub[(n2 - this.oy * this.step) * this.ow * this.step + (n - this.ox * this.step)] & 0xFF;
        }
        return this.getBufPixels8()[n2 / this.step * this.width + n / this.step];
    }

    @Override
    protected String getPixelInfo(int n, int n2, int n3) {
        if (!this.flagOk || n2 < 0 || n2 >= this.naxis2 || n < 0 || n >= this.naxis1) {
            return "";
        }
        switch (n3) {
            case 0: {
                byte by = this.inSubImage(n / this.step, n2 / this.step, 1, 1) ? this.pixelsSub[(n2 - this.oy * this.step) * this.ow * this.step + (n - this.ox * this.step)] : this.getBufPixels8()[n2 / this.step * this.width + n / this.step];
                return Util.align3(by & 0xFF) + " / 255";
            }
            case 2: {
                if (this.onePixelOrigin == null) {
                    this.onePixelOrigin = new byte[this.npix];
                }
                if (!this.getOnePixelFromCache(this.onePixelOrigin, this.npix, n, n2)) {
                    return UNK;
                }
                return this.Y(this.getPixVal(this.onePixelOrigin, this.bitpix, 0));
            }
            case 1: {
                if (this.onePixelOrigin == null) {
                    this.onePixelOrigin = new byte[this.npix];
                }
                if (!this.getOnePixelFromCache(this.onePixelOrigin, this.npix, n, n2)) {
                    return UNK;
                }
                double d = this.getPixVal(this.onePixelOrigin, this.bitpix, 0) * this.bScale + this.bZero;
                if (Aladin.levelTrace < 4) {
                    return this.Y(d);
                }
                double d2 = PlanImageHuge.getPixVal1(this.onePixelOrigin, this.bitpix, 0);
                return this.Y(d) + (Double.isNaN(d2) || d != d2 ? "(" + d2 + ")" : "") + (this.isBlank && d2 == this.blank ? " BLANK" : "");
            }
        }
        return null;
    }

    @Override
    protected boolean recut(double d, double d2, boolean bl) {
        if (d == -1.0 && d2 == -1.0) {
            d = this.dataMinFits;
            d2 = this.dataMaxFits;
        }
        this.flagUpdating = true;
        this.flagOk = false;
        this.aladin.calque.select.repaint();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (bl && Projection.isOk(this.projd)) {
            Coord coord = new Coord(this.aladin.view.repere.raj, this.aladin.view.repere.dej);
            this.projd.getXY(coord);
            n = (int)coord.x;
            n2 = (int)coord.y;
            ViewSimple viewSimple = this.aladin.view.getCurrentView();
            if (viewSimple.pref == this) {
                try {
                    n3 = (int)(viewSimple.getTaille() / this.projd.getPixResDelta()) / 2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            int n4 = Math.min(1024, this.width);
            int n5 = Math.min(1024, this.height);
            int n6 = this.width / 2 - n4 / 2;
            int n7 = this.height / 2 - n5 / 2;
            if (n3 > 0) {
                n4 = n5 = Math.min(1024, n3);
                n6 = n - n4 / 2;
                n7 = n2 - n4 / 2;
            }
            byte[] byArray = new byte[n4 * n5 * this.npix];
            this.getPixelsFromCache(byArray, this.npix, n6, n7, n4, n5);
            this.findMinMax(byArray, this.bitpix, n4, n5, d, d2, bl, 0, 0, 0, 0);
            d = this.pixelMin;
            d2 = this.pixelMax;
            this.loadHugeImage();
            this.resetPixelSub();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        this.setPourcent(-1.0);
        this.ow = -1;
        this.flagUpdating = false;
        this.flagOk = true;
        this.resetHist();
        return true;
    }

    private void loadHugeImage() throws Exception {
        byte[] byArray = new byte[512];
        long l = (long)this.width * (long)this.height * (long)this.npix;
        int n = 0;
        this.offsetLoad = 0;
        try {
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    this.fCache.seek(this.cacheOffset + ((long)(i * this.step + this.step / 2) * (long)this.naxis1 + (long)(j * this.step + this.step / 2)) * (long)this.npix);
                    this.fCache.readFully(byArray, n, this.npix);
                    if ((n += this.npix) != byArray.length) continue;
                    this.to8bits(this.getBufPixels8(), this.offsetLoad / this.npix, byArray, n / this.npix, this.bitpix, this.pixelMin, this.pixelMax, true);
                    this.offsetLoad += n;
                    n = 0;
                    this.setPourcent((double)this.offsetLoad * 99.0 / (double)l);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n > 0) {
            this.to8bits(this.getBufPixels8(), this.offsetLoad / this.npix, byArray, n / this.npix, this.bitpix, this.pixelMin, this.pixelMax, true);
            this.offsetLoad += n;
            this.setPourcent((double)this.offsetLoad * 99.0 / (double)l);
        }
        PlanImageHuge.invImageLine(this.width, this.height, this.getBufPixels8());
    }

    @Override
    protected boolean cacheImageFits(MyInputStream myInputStream) throws Exception {
        int n;
        int n2 = 2;
        Aladin.trace(2, "Loading Huge FITS image");
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderFits((Plan)this, myInputStream);
        }
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        n2 = this.headerFits.getIntFromHeader("NAXIS");
        if (n2 <= 1 && this.headerFits.getStringFromHeader("EXTEND") != null) {
            this.error = "_HEAD_XFITS_";
            if (n2 == 1) {
                try {
                    this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
                    myInputStream.skip(this.naxis1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return false;
        }
        this.width = this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
        this.height = this.naxis2 = this.headerFits.getIntFromHeader("NAXIS2");
        this.npix = n = Math.abs(this.bitpix) / 8;
        long l = (long)this.width * (long)this.height * (long)n;
        this.setPourcent(0.0);
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " BITPIX=" + this.bitpix + " => size=" + l);
        this.loadFitsHeaderParam(this.headerFits);
        Date date = new Date();
        if (!this.setCacheFromFile(myInputStream)) {
            Aladin.trace(2, "Dumping huge image in local cache...");
            int bl = 512;
            byte[] byArray = new byte[bl];
            long l2 = 0L;
            RandomAccessFile randomAccessFile = null;
            try {
                while (l2 < l) {
                    int n3;
                    if (l - l2 < (long)n3) {
                        n3 = (int)(l - l2);
                    }
                    myInputStream.readFully(byArray, 0, n3);
                    if (l2 == 0L) {
                        randomAccessFile = this.beginInCache(byArray);
                    } else {
                        randomAccessFile.write(byArray, 0, n3);
                    }
                    this.setPourcent((double)(l2 += (long)n3) * 85.0 / (double)l);
                }
                this.fCache = randomAccessFile;
            }
            catch (Exception exception) {
                this.error = Aladin.error = "Loading error: " + exception.getMessage();
                exception.printStackTrace();
                this.close();
                return false;
            }
        }
        this.tailleLoad = l;
        boolean bl = this.aladin.configuration.getCMCut();
        int n4 = Math.min(1024, this.width);
        int n5 = Math.min(1024, this.height);
        int n6 = this.width / 2 - n4 / 2;
        int n7 = this.height / 2 - n5 / 2;
        byte[] byArray = new byte[n4 * n5 * this.npix];
        this.getPixelsFromCache(byArray, this.npix, n6, n7, n4, n5);
        this.findMinMax(byArray, this.bitpix, n4, n5, this.dataMinFits, this.dataMaxFits, bl, 0, 0, 0, 0);
        int n8 = 512;
        byArray = new byte[n8];
        int n9 = Math.max(this.width, this.height);
        this.step = 1;
        while (n9 / this.step > 2048) {
            this.step *= 2;
        }
        this.width = PlanImageHuge.top((double)this.width / (double)this.step);
        this.height = PlanImageHuge.top((double)this.height / (double)this.step);
        Aladin.trace(3, "Huge image (" + this.naxis1 + "x" + this.naxis2 + ") step=" + this.step + " => (" + this.width + "x" + this.height + ")");
        this.setBufPixels8(new byte[this.width * this.height]);
        this.loadHugeImage();
        if (n2 > 2) {
            try {
                myInputStream.skip(l);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        if (this.flagSkip) {
            return true;
        }
        Date date2 = new Date();
        int n10 = (int)(date2.getTime() - date.getTime());
        date = date2;
        Aladin.trace(3, " => Reading " + (bl ? "and autocutting " : "") + "in " + Util.round((double)n10 / 1000.0, 3) + " s => " + Util.round((double)this.offsetLoad / (double)n10 / 1048.576, 2) + " Mbyte/s");
        this.calculPixelsZoom();
        this.creatDefaultCM();
        this.setPourcent(99.0);
        return true;
    }

    class PixelsSub {
        int ox;
        int oy;
        int ow;
        int oh;
        byte[] pixels;

        PixelsSub(byte[] byArray, int n, int n2, int n3, int n4) {
            this.pixels = byArray;
            this.ox = n;
            this.oy = n2;
            this.ow = n3;
            this.oh = n4;
        }

        boolean agree(int n, int n2, int n3, int n4) {
            return n >= this.ox && n2 >= this.oy && n + n3 <= this.ox + this.ow && n2 + n4 <= this.oy + this.oh;
        }
    }
}

