/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.PlanImage;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.tools.Util;

public class PlanImageMosaic
extends PlanImage {
    protected PlanImage Ref;
    private PlanImage[] tmpP;
    private boolean flagCreat;
    private boolean firstMosaic;
    private ViewSimple v;

    protected PlanImageMosaic(Aladin aladin, PlanImage planImage) {
        super(aladin, planImage);
        this.type = 6;
    }

    protected PlanImageMosaic(Aladin aladin) {
        super(aladin);
        this.type = 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlanImageMosaic(Aladin aladin, PlanImage[] planImageArray, String string, ViewSimple viewSimple) {
        super(aladin);
        this.type = 6;
        this.Ref = planImageArray[0];
        this.firstMosaic = true;
        this.v = viewSimple;
        Aladin.trace(3, "Mosaic ref plane: " + this.Ref.label);
        this.init(string, this.Ref);
        this.tmpP = new PlanImage[planImageArray.length - 1];
        System.arraycopy(planImageArray, 1, this.tmpP, 0, planImageArray.length - 1);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < planImageArray.length; ++i) {
            stringBuffer.append((i > 0 ? "/" : "") + planImageArray[i]);
        }
        this.sendLog("Mosaic", "[" + stringBuffer + "]");
        this.flagCreat = true;
        PlanImageMosaic planImageMosaic = this;
        synchronized (planImageMosaic) {
            this.runme = new Thread((Runnable)this, "AladinBuildMosaic");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    protected void init(String string, PlanImage planImage) {
        planImage.copy(this);
        this.flagOk = false;
        this.isOldPlan = false;
        this.askActive = true;
        this.type = 6;
        this.headerFits = null;
        this.fmt = 6;
        this.res = 0;
        this.orig = 3;
        this.status = "Mosaic in progress...";
        this.progress = "computing...";
        if (string == null) {
            string = "Msc img";
        }
        this.setLabel(string);
        this.copyright = "Mosaic";
        this.param = "";
        this.bitpix = 8;
        this.npix = 1;
        try {
            RectangleD rectangleD = this.getPixelBox(new PlanImage[]{planImage});
            Aladin.trace(3, "Mosaic bounding box pos=" + rectangleD.x + "," + rectangleD.y + " size=" + rectangleD.width + "x" + rectangleD.height);
            this.projd = this.shiftProjection(rectangleD);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected boolean waitForPlan() {
        try {
            this.addFrame(this.tmpP);
            this.calculPixelsZoom();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        if (this.flagCreat) {
            this.flagCreat = false;
            Aladin.trace(1, "Creating the " + Tp[this.type] + " plane " + this.label);
            if (this.v == null) {
                this.planReady(this.waitForPlan());
            } else {
                this.flagProcessing = true;
                this.v.pref = this;
                this.aladin.view.setSelect(this.v);
                this.waitForPlan();
                this.v.repaint();
            }
        } else {
            Aladin.trace(1, "Adding planes to " + this.label);
            try {
                this.addFrame(this.tmpP);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            this.flagOk = true;
        }
    }

    protected synchronized void addPlan(PlanImage planImage) {
        this.flagOk = false;
        this.flagProcessing = true;
        this.tmpP = new PlanImage[1];
        this.tmpP[0] = planImage;
        this.aladin.calque.select.repaint();
        this.runme = new Thread((Runnable)this, "AladinMosaicAdd");
        Util.decreasePriority(Thread.currentThread(), this.runme);
        this.runme.start();
    }

    private RectangleD getPixelBox(PlanImage[] planImageArray) throws Exception {
        RectangleD rectangleD = new RectangleD(0.0, 0.0, this.width - 1, this.height - 1);
        Coord coord = new Coord();
        for (int i = 0; i < planImageArray.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                switch (j) {
                    case 0: {
                        coord.x = 0.0;
                        coord.y = 0.0;
                        break;
                    }
                    case 1: {
                        coord.x = 0.0;
                        coord.y = planImageArray[i].height - 1;
                        break;
                    }
                    case 2: {
                        coord.x = planImageArray[i].width - 1;
                        coord.y = planImageArray[i].height - 1;
                        break;
                    }
                    case 3: {
                        coord.x = planImageArray[i].width - 1;
                        coord.y = 0.0;
                    }
                }
                planImageArray[i].projd.getCoord(coord);
                if (Double.isNaN(coord.al)) continue;
                this.projd.getXY(coord);
                if (Double.isNaN(coord.x)) continue;
                if (coord.x < rectangleD.x) {
                    rectangleD.x = coord.x;
                }
                if (coord.x > rectangleD.width) {
                    rectangleD.width = coord.x;
                }
                if (coord.y < rectangleD.y) {
                    rectangleD.y = coord.y;
                }
                if (!(coord.y > rectangleD.height)) continue;
                rectangleD.height = coord.y;
            }
        }
        rectangleD.width -= rectangleD.x;
        rectangleD.height -= rectangleD.y;
        return rectangleD;
    }

    private Projection shiftProjection(RectangleD rectangleD) {
        Projection projection = this.projd.copy();
        projection.crop((int)rectangleD.x, (int)rectangleD.y, (int)rectangleD.width, (int)rectangleD.height);
        return projection;
    }

    private void setFrom(PlanImage[] planImageArray) {
        String string = "";
        for (int i = 0; i < planImageArray.length; ++i) {
            string = string + " [" + planImageArray[i] + "]";
        }
        this.copyright = this.firstMosaic ? "Mosaic from [" + this.Ref + "]" + string : this.copyright + string;
    }

    protected synchronized void addFrame(PlanImage[] planImageArray) throws Exception {
        this.noOriginalPixels();
        Coord coord = new Coord();
        this.setFrom(planImageArray);
        Aladin.trace(3, "Mosaicing " + this.param + "...");
        RectangleD rectangleD = this.getPixelBox(planImageArray);
        Aladin.trace(3, "Mosaic bounding box pos=" + rectangleD.x + "," + rectangleD.y + " size=" + rectangleD.width + "x" + rectangleD.height);
        int n = (int)(rectangleD.width + 1.0);
        int n2 = (int)(rectangleD.height + 1.0);
        byte[] byArray = new byte[n * n2];
        Projection projection = this.shiftProjection(rectangleD);
        this.setHasSpecificCalib();
        for (int i = 0; i < byArray.length; ++i) {
            coord.x = i % n;
            coord.y = i / n;
            projection.getCoord(coord);
            if (Double.isNaN(coord.al)) continue;
            int n3 = 0;
            int n4 = 0;
            for (int j = -1; j < planImageArray.length; ++j) {
                PlanImageMosaic planImageMosaic = j == -1 ? this : planImageArray[j];
                planImageMosaic.projd.getXY(coord);
                if (!Double.isNaN(coord.x)) {
                    int n5 = (int)Math.round(coord.x);
                    int n6 = (int)Math.round(coord.y);
                    if (n5 >= 0 && n5 < planImageMosaic.width && n6 >= 0 && n6 < planImageMosaic.height) {
                        if (!this.firstMosaic && planImageMosaic == this && planImageMosaic.getBufPixels8()[n6 * planImageMosaic.width + n5] == 0) continue;
                        n3 += 0xFF & planImageMosaic.getBufPixels8()[n6 * planImageMosaic.width + n5];
                        ++n4;
                    }
                }
                if (i * planImageArray.length % 10000 != 0) continue;
                this.setPourcent(i * 100 / byArray.length);
                if (!Aladin.isSlow) continue;
                Util.pause(10);
            }
            if (n4 == 0) continue;
            byArray[i] = (byte)(n3 / n4 & 0xFF);
        }
        this.setBufPixels8(byArray);
        this.naxis1 = this.width = n;
        this.naxis2 = this.height = n2;
        this.projd = projection;
        this.setPourcent(-1.0);
        this.flagProcessing = false;
        this.flagOk = true;
        if (this.firstMosaic) {
            this.cm = this.Ref.cm;
        }
        this.firstMosaic = false;
        Aladin.trace(3, "Mosaic achieved...");
        this.calculPixelsZoom();
        this.changeImgID();
        this.aladin.view.repaintAll();
        this.aladin.calque.zoom.zoomView.repaint();
    }
}

