/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanRGBInterface;
import cds.aladin.Projection;
import cds.aladin.ResourceNode;
import cds.aladin.ViewSimple;
import cds.aladin.ZoomView;
import cds.tools.Util;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;

public class PlanImageRGB
extends PlanImage
implements PlanRGBInterface {
    protected int[] pixelsRGB;
    protected int[] pixelsZoomRGB;
    protected byte[] red;
    protected byte[] green;
    protected byte[] blue;
    protected boolean twoColors;
    protected int[] RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
    protected int[] RGBControl;
    protected int[] pi = new int[3];
    protected String[] labels = new String[3];
    protected String labelRed;
    protected String labelGreen;
    protected String labelBlue;
    protected PlanImage planRed;
    protected PlanImage planGreen;
    protected PlanImage planBlue;
    protected PlanImage pRef;
    protected boolean flagRed;
    protected boolean flagGreen;
    protected boolean flagBlue;
    protected boolean diff;
    private boolean mustResample = false;
    private double[] histRed = new double[256];
    private double[] histGreen = new double[256];
    private double[] histBlue = new double[256];
    private boolean postAJDone = false;

    protected PlanImageRGB(Aladin aladin) {
        super(aladin);
        this.type = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlanImageRGB(Aladin aladin, PlanImage planImage, PlanImage planImage2, PlanImage planImage3, PlanImage planImage4, String string, boolean bl) {
        super(aladin);
        this.mustResample = true;
        this.type = 2;
        this.isOldPlan = false;
        this.pixMode = 1;
        if (!(planImage != null && !planImage.isTransparent() || planImage2 != null && !planImage2.isTransparent() || planImage2 != null && !planImage2.isTransparent())) {
            this.pixMode = 0;
        }
        this.planRed = planImage;
        this.planGreen = planImage2;
        this.planBlue = planImage3;
        this.flagRed = this.planRed != null;
        this.flagGreen = this.planGreen != null;
        this.flagBlue = this.planBlue != null;
        double d = Double.MAX_VALUE;
        if (planImage4 == null) {
            if (!(Projection.isOk(planImage.projd) && Projection.isOk(planImage.projd) && Projection.isOk(planImage.projd))) {
                planImage4 = planImage != null ? planImage : (planImage2 != null ? planImage2 : planImage3);
            } else {
                if (planImage != null && Math.abs(planImage.projd.c.incA) < d) {
                    planImage4 = planImage;
                    d = Math.abs(planImage.projd.c.incA);
                }
                if (planImage2 != null && Math.abs(planImage2.projd.c.incA) < d) {
                    planImage4 = planImage2;
                    d = Math.abs(planImage2.projd.c.incA);
                }
                if (planImage3 != null && Math.abs(planImage3.projd.c.incA) < d) {
                    planImage4 = planImage3;
                    d = Math.abs(planImage3.projd.c.incA);
                }
            }
        }
        this.pRef = planImage4;
        this.diff = bl;
        this.init(string, this.pRef);
        PlanImageRGB planImageRGB = this;
        synchronized (planImageRGB) {
            this.runme = new Thread((Runnable)this, "AladinBuildRGB");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    protected PlanImageRGB(Aladin aladin, String string, URL uRL, MyInputStream myInputStream, ResourceNode resourceNode) {
        this(aladin, string, uRL, myInputStream);
        this.imgNode = resourceNode;
    }

    protected PlanImageRGB(Aladin aladin, String string, URL uRL, MyInputStream myInputStream) {
        super(aladin, string, myInputStream);
        if (uRL != null) {
            this.u = uRL;
        }
        this.type = 2;
        this.pixMode = 1;
        this.active = true;
        this.flagBlue = true;
        this.flagGreen = true;
        this.flagRed = true;
        this.initCMControl();
        this.labels[0] = "red";
        this.labels[1] = "green";
        this.labels[2] = "blue";
        this.flagOk = false;
    }

    protected PlanImageRGB(Aladin aladin, MyInputStream myInputStream, int n, URL uRL, String string, String string2, String string3, String string4, int n2, int n3, Obj obj, ResourceNode resourceNode) {
        super(aladin, myInputStream, n, uRL, string, string2, string3, string4, n2, n3, obj, resourceNode);
        this.type = 2;
        this.active = true;
        this.flagBlue = true;
        this.flagGreen = true;
        this.flagRed = true;
        this.initCMControl();
        this.labels[0] = "red";
        this.labels[1] = "green";
        this.labels[2] = "blue";
    }

    protected void initCMControl() {
        this.RGBControl = new int[this.RGBCONTROL.length];
        for (int i = 0; i < this.RGBCONTROL.length; ++i) {
            this.RGBControl[i] = this.RGBCONTROL[i];
        }
    }

    protected PlanImageRGB(Aladin aladin, PlanImage planImage) {
        super(aladin, planImage);
        this.type = 2;
    }

    @Override
    public int[] getPixelsRGB() {
        return this.pixelsRGB;
    }

    @Override
    public int[] getPixelsZoomRGB() {
        return this.pixelsZoomRGB;
    }

    @Override
    protected void copy(Plan plan) {
        super.copy(plan);
        if (!(plan instanceof PlanImageRGB)) {
            return;
        }
        PlanImageRGB planImageRGB = (PlanImageRGB)plan;
        planImageRGB.pixelsRGB = this.getPixelsRGB();
        planImageRGB.red = this.red;
        planImageRGB.green = this.green;
        planImageRGB.blue = this.blue;
        planImageRGB.twoColors = this.twoColors;
        planImageRGB.RGBControl = new int[this.RGBCONTROL.length];
        System.arraycopy(this.RGBControl, 0, planImageRGB.RGBControl, 0, this.RGBControl.length);
        planImageRGB.pi = new int[this.pi.length];
        System.arraycopy(this.pi, 0, planImageRGB.pi, 0, this.pi.length);
        planImageRGB.planRed = this.planRed;
        planImageRGB.planGreen = this.planGreen;
        planImageRGB.planBlue = this.planBlue;
        planImageRGB.labels = this.labels;
        planImageRGB.flagRed = this.flagRed;
        planImageRGB.flagGreen = this.flagGreen;
        planImageRGB.flagBlue = this.flagBlue;
        planImageRGB.diff = this.diff;
        planImageRGB.mustResample = this.mustResample;
        planImageRGB.cm = this.cm;
    }

    @Override
    protected boolean crop(double d, double d2, double d3, double d4, boolean bl) {
        int n = 0;
        if (d <= 0.0) {
            d3 += d;
            d = 0.0;
            ++n;
        }
        if (d2 <= 0.0) {
            d4 += d2;
            d2 = 0.0;
            ++n;
        }
        if (d + d3 >= (double)this.width) {
            d3 = (double)this.width - d;
            ++n;
        }
        if (d2 + d4 >= (double)this.height) {
            d4 = (double)this.height - d2;
            ++n;
        }
        if (n == 4) {
            return false;
        }
        int[] nArray = new int[(int)(d3 * d4)];
        int n2 = 0;
        while ((double)n2 < d4) {
            int n3 = (int)((d2 + (double)n2) * (double)this.width + d);
            int n4 = (int)((double)n2 * d3);
            System.arraycopy(this.pixelsRGB, n3, nArray, n4, (int)d3);
            ++n2;
        }
        this.pixelsRGB = nArray;
        this.blue = null;
        this.green = null;
        this.red = null;
        this.crop1(d, d2, d3, d4, bl);
        return true;
    }

    @Override
    protected boolean cacheImageFits(MyInputStream myInputStream) throws Exception {
        boolean bl = (myInputStream.getType() & 0x400000000L) != 0L;
        Aladin.trace(2, "Loading " + (bl ? "A" : "") + "RGB FITS image");
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderFits((Plan)this, myInputStream);
        }
        this.pixMode = bl ? 0 : 1;
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        if (this.bitpix == 0) {
            this.aladin.command.printConsole("!!! RGB BITPIX=0 => assuming BITPIX=8 !\n");
            this.bitpix = 8;
        }
        if (this.bitpix != 8 && !bl) {
            this.aladin.command.printConsole("!! RGB BITPIX!=8 => autocutting each color component !\n");
        }
        this.naxis1 = this.width = this.headerFits.getIntFromHeader("NAXIS1");
        if (this.width <= 0) {
            return false;
        }
        this.naxis2 = this.height = this.headerFits.getIntFromHeader("NAXIS2");
        if (this.height <= 0) {
            return false;
        }
        this.npix = Math.abs(this.bitpix) / 8;
        int n = this.width * this.height * 3;
        this.setPourcent(0.0);
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " NAXIS3=3 BITPIX=" + this.bitpix + " => size=" + n);
        Date date = new Date();
        this.video = 0;
        this.red = new byte[this.width * this.height];
        this.green = new byte[this.width * this.height];
        this.blue = new byte[this.width * this.height];
        Date date2 = new Date();
        int n2 = (int)(date2.getTime() - date.getTime());
        date = date2;
        Aladin.trace(3, " => Allocating (" + n + "b) in " + n2 + " ms");
        if (bl) {
            byte[] byArray = new byte[this.width * 4];
            int n3 = 0;
            int n4 = 0;
            while (n3 < this.width * this.height * 4) {
                myInputStream.readFully(byArray);
                this.setPourcent((double)((n3 += byArray.length) / (this.width * this.height * 4)) * 0.8);
                int n5 = 0;
                while (n5 < byArray.length) {
                    int n6 = n4 % 4;
                    int n7 = n4 / 4;
                    switch (n6) {
                        case 1: {
                            this.red[n7] = byArray[n5];
                            break;
                        }
                        case 2: {
                            this.green[n7] = byArray[n5];
                            break;
                        }
                        case 3: {
                            this.blue[n7] = byArray[n5];
                        }
                    }
                    ++n5;
                    ++n4;
                }
            }
            byArray = null;
        } else {
            for (int i = 0; i < 3; ++i) {
                byte[] byArray = i == 0 ? this.red : (i == 1 ? this.green : this.blue);
                this.readColor(byArray, myInputStream, this.width, this.height, this.bitpix);
                this.setPourcent(this.pourcent + 33.0);
            }
        }
        date2 = new Date();
        n2 = (int)(date2.getTime() - date.getTime());
        date = date2;
        Aladin.trace(3, " => Reading in " + n2 + " ms");
        PlanImageRGB.invImageLine(this.width, this.height, this.red);
        PlanImageRGB.invImageLine(this.width, this.height, this.green);
        PlanImageRGB.invImageLine(this.width, this.height, this.blue);
        this.createImgRGB();
        this.cm = ColorModel.getRGBdefault();
        this.setPourcent(99.0);
        return true;
    }

    private void readColor(byte[] byArray, MyInputStream myInputStream, int n, int n2, int n3) throws Exception {
        if (n3 == 8) {
            myInputStream.readFully(byArray);
        } else {
            int n4 = n * n2 * Math.abs(n3) / 8;
            byte[] byArray2 = new byte[n4];
            myInputStream.readFully(byArray2);
            this.getPix8Bits(byArray, byArray2, n3, n, n2, 0.0, 0.0, true, 0, 0, 0);
            byArray2 = null;
        }
    }

    @Override
    public void calculPixelsZoomRGB() {
        this.pixelsZoomRGB = PlanImageRGB.calculPixelsZoomRGB1(this.pixelsZoomRGB, this.pixelsRGB, this.width, this.height);
    }

    public static int[] calculPixelsZoomRGB1(int[] nArray, int[] nArray2, int n, int n2) {
        int n3;
        int n4 = (int)((double)ZoomView.SIZE / (double)n * (double)n2);
        int n5 = ZoomView.SIZE;
        if (n4 > n5) {
            n5 = (int)((double)n5 * (double)n5 / (double)n4);
            n4 = ZoomView.SIZE;
        }
        double d = (double)n / (double)n5;
        double d2 = (double)n2 / (double)n4;
        if (nArray == null) {
            nArray = new int[ZoomView.SIZE * ZoomView.SIZE];
        } else {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray[n3] = 0;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = n3 * ZoomView.SIZE;
            int n7 = (int)((double)n3 * d2);
            for (int i = 0; i < n5; ++i) {
                nArray[n6++] = nArray2[n7 * n + (int)((double)i * d)];
            }
        }
        return nArray;
    }

    @Override
    synchronized void changeImgID() {
        super.changeImgID();
        this.pixelsZoomRGB = null;
    }

    protected byte[] getGreyPixels() {
        byte[] byArray = new byte[this.pixelsRGB.length];
        for (int i = 0; i < this.pixelsRGB.length; ++i) {
            byArray[i] = (byte)PlanImageRGB.getGreyPixel(this.pixelsRGB[i]);
        }
        return byArray;
    }

    public static double getGreyPixel(int n) {
        int n2 = PlanImageRGB.getPixRGB(n, 0);
        int n3 = PlanImageRGB.getPixRGB(n, 1);
        int n4 = PlanImageRGB.getPixRGB(n, 2);
        return (double)n2 * 0.299 + (double)n3 * 0.587 + (double)n4 * 0.114;
    }

    @Override
    protected double getPixelInDouble(int n, int n2) {
        int n3 = this.pixelsRGB[(this.height - n2 - 1) * this.width + n];
        return PlanImageRGB.getGreyPixel(n3);
    }

    @Override
    protected String getSizeInfo() {
        return this.width + "x" + this.height + "x3 pixels";
    }

    protected void createRGB() {
        if (this.pixelsRGB == null) {
            return;
        }
        if (this.red != null && this.red.length == this.pixelsRGB.length) {
            return;
        }
        int n = this.pixelsRGB.length;
        this.red = new byte[n];
        this.green = new byte[n];
        this.blue = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.red[i] = (byte)(this.pixelsRGB[i] >> 16 & 0xFF);
            this.green[i] = (byte)(this.pixelsRGB[i] >> 8 & 0xFF);
            this.blue[i] = (byte)(this.pixelsRGB[i] & 0xFF);
        }
    }

    protected byte[] getByteRGB() {
        if (this.pixelsRGB == null) {
            return null;
        }
        int n = this.pixelsRGB.length * 3;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += 3) {
            int n2 = this.pixelsRGB[i / 3];
            byArray[i] = (byte)(n2 >> 16 & 0xFF);
            byArray[i + 1] = (byte)(n2 >> 8 & 0xFF);
            byArray[i + 2] = (byte)(n2 & 0xFF);
        }
        return byArray;
    }

    protected void setByteRGB(byte[] byArray) {
        int n = byArray.length;
        this.pixelsRGB = new int[n / 3];
        for (int i = 0; i < n; i += 3) {
            this.pixelsRGB[i / 3] = (byArray[i] & 0xFF) << 16 | (byArray[i + 1] & 0xFF) << 8 | byArray[i + 2] & 0xFF;
        }
    }

    protected byte[] getColor(byte[] byArray, int n) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(0xFF & PlanImageRGB.getPixRGB(this.pixelsRGB, i, n));
        }
        return byArray;
    }

    protected byte[] getRed() {
        if (this.red == null || this.red.length != this.pixelsRGB.length) {
            this.createRGB();
        }
        return this.red;
    }

    protected byte[] getBlue() {
        if (this.blue == null || this.blue.length != this.pixelsRGB.length) {
            this.createRGB();
        }
        return this.blue;
    }

    protected byte[] getGreen() {
        if (this.green == null || this.green.length != this.pixelsRGB.length) {
            this.createRGB();
        }
        return this.green;
    }

    @Override
    protected double[] getHistArray(int n) {
        return n == 0 ? this.histRed : (n == 1 ? this.histGreen : this.histBlue);
    }

    @Override
    protected byte[] getPixelHist(int n) {
        return n == 0 ? this.getRed() : (n == 1 ? this.getGreen() : this.getBlue());
    }

    @Override
    protected byte[] getBufPixels8() {
        return this.getGreyPixels();
    }

    @Override
    protected boolean Free() {
        if (!super.Free()) {
            return false;
        }
        this.pixelsRGB = null;
        this.blue = null;
        this.green = null;
        this.red = null;
        this.planBlue = null;
        this.planGreen = null;
        this.planRed = null;
        this.flagBlue = false;
        this.flagGreen = false;
        this.flagRed = false;
        this.pi[2] = -1;
        this.pi[1] = -1;
        this.pi[0] = -1;
        return true;
    }

    protected void init(String string, PlanImage planImage) {
        this.flagOk = false;
        this.askActive = true;
        this.headerFits = null;
        if (Projection.isOk(planImage.projd)) {
            this.setHasSpecificCalib();
        }
        this.naxis1 = this.width = planImage.width;
        this.naxis2 = this.height = planImage.height;
        this.video = 0;
        this.fmt = 6;
        this.transfertFct = 3;
        this.res = 0;
        this.orig = 3;
        this.status = "Re-sampling (at the nearest pixel):";
        this.progress = "computing...";
        this.objet = planImage.objet;
        if (string == null) {
            string = "RGB img";
        }
        this.setLabel(string);
        this.co = planImage.co;
        this.c = planImage.c;
        this.projd = planImage.projd.copy();
        this.projD = planImage.projD == null ? null : (Hashtable)planImage.projD.clone();
        this.copyright = "Colored composition by Aladin";
        this.pi[0] = this.flagRed ? this.planRed.hashCode() : 0;
        this.pi[1] = this.flagGreen ? this.planGreen.hashCode() : 0;
        this.pi[2] = this.flagBlue ? this.planBlue.hashCode() : 0;
        this.labels[0] = this.planRed != null ? this.planRed.label : "none";
        this.labels[1] = this.planGreen != null ? this.planGreen.label : "none";
        this.labels[2] = this.planBlue != null ? this.planBlue.label : "none";
        this.RGBControl = new int[this.RGBCONTROL.length];
        for (int i = 0; i < this.RGBCONTROL.length; ++i) {
            this.RGBControl[i] = this.RGBCONTROL[i];
        }
        this.param = "R:" + this.labels[0] + " G:" + this.labels[1] + " B:" + this.labels[2];
    }

    private void setPixRGB(int[] nArray, int n, int n2, int n3) {
        switch (n2) {
            case 0: {
                int n4 = n;
                nArray[n4] = nArray[n4] & 0xFF00FFFF;
                int n5 = n;
                nArray[n5] = nArray[n5] | 0xFF0000 & n3 << 16;
                break;
            }
            case 1: {
                int n6 = n;
                nArray[n6] = nArray[n6] & 0xFFFF00FF;
                int n7 = n;
                nArray[n7] = nArray[n7] | 0xFF00 & n3 << 8;
                break;
            }
            case 2: {
                int n8 = n;
                nArray[n8] = nArray[n8] & 0xFFFFFF00;
                int n9 = n;
                nArray[n9] = nArray[n9] | 0xFF & n3;
            }
        }
    }

    protected static int getPixRGB(int[] nArray, int n, int n2) {
        return PlanImageRGB.getPixRGB(nArray[n], n2);
    }

    private static int getPixRGB(int n, int n2) {
        switch (n2) {
            case 0: {
                return 0xFF & n >> 16;
            }
            case 1: {
                return 0xFF & n >> 8;
            }
        }
        return 0xFF & n;
    }

    @Override
    protected boolean waitForPlan() {
        int n;
        if (!this.mustResample) {
            if (!super.waitForPlan()) {
                return false;
            }
            this.calculPixelsZoomRGB();
            return true;
        }
        Aladin.trace(3, "Resampling (R:" + this.labels[0] + ",G:" + this.labels[1] + ",B:" + this.labels[2] + " astro from " + this.pRef.label + ")...");
        int n2 = 0;
        int n3 = 1;
        int n4 = 2;
        PlanImage planImage = null;
        PlanImage planImage2 = null;
        if (this.pRef == this.planRed) {
            planImage = this.planGreen;
            planImage2 = this.planBlue;
            n2 = 0;
            n3 = 1;
            n4 = 2;
        } else if (this.pRef == this.planGreen) {
            planImage = this.planRed;
            planImage2 = this.planBlue;
            n2 = 1;
            n3 = 0;
            n4 = 2;
        } else if (this.pRef == this.planBlue) {
            planImage = this.planRed;
            planImage2 = this.planGreen;
            n2 = 2;
            n3 = 0;
            n4 = 1;
        }
        Coord coord = new Coord();
        int n5 = 0;
        int n6 = 0;
        int n7 = this.pRef.width;
        this.pixelsRGB = new int[this.pRef.width * this.pRef.height];
        for (n = 0; n < this.pixelsRGB.length; ++n) {
            this.pixelsRGB[n] = -16777216;
        }
        boolean bl = true;
        boolean bl2 = true;
        if ((planImage == null || Projection.isOk(planImage.projd)) && (planImage2 == null || Projection.isOk(planImage2.projd)) && Projection.isOk(this.pRef.projd)) {
            bl = planImage != null && this.pRef.projd.c.TheSame(planImage.projd.c);
            bl2 = planImage2 != null && this.pRef.projd.c.TheSame(planImage2.projd.c);
        }
        boolean bl3 = this.pRef.video == 1;
        boolean bl4 = planImage != null && planImage.video == 1;
        boolean bl5 = planImage2 != null && planImage2.video == 1;
        byte[] byArray = this.pRef == null ? null : Util.getTableCM(this.pRef.cm, 2);
        byte[] byArray2 = planImage == null ? null : Util.getTableCM(planImage.cm, 2);
        byte[] byArray3 = planImage2 == null ? null : Util.getTableCM(planImage2.cm, 2);
        for (n = 0; n < this.pRef.pixels.length; ++n) {
            this.setPixRGB(this.pixelsRGB, n, n2, bl3 ? 255 - byArray[0xFF & this.pRef.pixels[n]] : byArray[0xFF & this.pRef.pixels[n]]);
        }
        if (bl && planImage != null) {
            for (n = 0; n < planImage.pixels.length; ++n) {
                this.setPixRGB(this.pixelsRGB, n, n3, bl4 ? 255 - byArray2[0xFF & planImage.pixels[n]] : byArray2[0xFF & planImage.pixels[n]]);
            }
        }
        if (bl2 && planImage2 != null) {
            for (n = 0; n < planImage2.pixels.length; ++n) {
                this.setPixRGB(this.pixelsRGB, n, n4, bl5 ? 255 - byArray3[0xFF & planImage2.pixels[n]] : byArray3[0xFF & planImage2.pixels[n]]);
            }
        }
        if (!bl || !bl2) {
            for (n = 0; n < this.pRef.pixels.length; ++n) {
                coord.x = n % n7;
                coord.y = n / n7;
                this.pRef.projd.getCoord(coord);
                if (Double.isNaN(coord.al)) continue;
                if (!bl && planImage != null) {
                    planImage.projd.getXY(coord);
                    if (!Double.isNaN(coord.x)) {
                        n5 = (int)Math.round(coord.x);
                        n6 = (int)Math.round(coord.y);
                        if (n5 >= 0 && n5 < planImage.width && n6 >= 0 && n6 < planImage.height) {
                            this.setPixRGB(this.pixelsRGB, n, n3, bl4 ? 255 - byArray2[0xFF & planImage.pixels[n6 * planImage.width + n5]] : byArray2[0xFF & planImage.pixels[n6 * planImage.width + n5]]);
                        }
                    }
                }
                if (!bl2 && planImage2 != null) {
                    planImage2.projd.getXY(coord);
                    if (!Double.isNaN(coord.x)) {
                        n5 = (int)Math.round(coord.x);
                        n6 = (int)Math.round(coord.y);
                        if (n5 >= 0 && n5 < planImage2.width && n6 >= 0 && n6 < planImage2.height) {
                            this.setPixRGB(this.pixelsRGB, n, n4, bl5 ? 255 - byArray3[0xFF & planImage2.pixels[n6 * planImage2.width + n5]] : byArray3[0xFF & planImage2.pixels[n6 * planImage2.width + n5]]);
                        }
                    }
                }
                if (n % 10000 != 0) continue;
                this.setPourcent((long)n * 100L / (long)this.pRef.pixels.length);
                if (!Aladin.isSlow) continue;
                Util.pause(10);
            }
        }
        this.setPourcent(-1.0);
        Aladin.trace(3, "Resampling achieved...");
        this.cm = ColorModel.getRGBdefault();
        this.bitpix = 8;
        boolean bl6 = this.twoColors = this.planRed == null || this.planGreen == null || this.planBlue == null;
        if (this.planRed == null) {
            this.createLastColor(this.pixelsRGB, 0);
        } else if (this.planGreen == null) {
            this.createLastColor(this.pixelsRGB, 1);
        } else if (this.planBlue == null) {
            this.createLastColor(this.pixelsRGB, 2);
        }
        this.calculPixelsZoomRGB();
        this.changeImgID();
        this.sendLog("RGB", " [R:" + this.labels[0] + ",G:" + this.labels[1] + ",B:" + this.labels[2] + "]");
        return true;
    }

    protected void createImgRGB() {
        this.createRGB();
        int n = this.width * this.height;
        this.pixelsRGB = new int[n];
        for (int i = 0; i < n; ++i) {
            this.pixelsRGB[i] = 0xFF000000 | (this.red[i] & 0xFF) << 16 | (this.green[i] & 0xFF) << 8 | this.blue[i] & 0xFF;
        }
        this.calculPixelsZoomRGB();
        this.changeImgID();
    }

    protected void createLastColor(int[] nArray, int n) {
        int n2;
        int n3;
        if (n == 0) {
            n3 = 1;
            n2 = 2;
        } else if (n == 1) {
            n3 = 0;
            n2 = 2;
        } else {
            n3 = 0;
            n2 = 1;
        }
        int n4 = this.width * this.height;
        for (int i = 0; i < n4; ++i) {
            int n5 = PlanImageRGB.getPixRGB(nArray, i, n3);
            int n6 = PlanImageRGB.getPixRGB(nArray, i, n2);
            if (this.diff) {
                if (n5 == n6) {
                    nArray[i] = -16777216;
                    continue;
                }
                if (n5 - n6 > 0) {
                    this.setPixRGB(nArray, i, n3, n5 - n6);
                    this.setPixRGB(nArray, i, n2, 0);
                    this.setPixRGB(nArray, i, n, 0);
                    continue;
                }
                this.setPixRGB(nArray, i, n2, n6 - n5);
                this.setPixRGB(nArray, i, n3, 0);
                this.setPixRGB(nArray, i, n, 0);
                continue;
            }
            this.setPixRGB(nArray, i, n, (n5 + n6) / 2);
        }
    }

    private void normalisation(byte[] byArray, byte[] byArray2) {
        double d;
        int n;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < 2; ++i) {
            byte[] byArray3 = i == 0 ? byArray : byArray2;
            for (n = 0; n < byArray3.length; ++n) {
                d = byArray3[n] & 0xFF;
                if (d < d2) {
                    d2 = d;
                }
                if (!(d > d3)) continue;
                d3 = d;
            }
        }
        double d4 = 256.0 / (d3 - d2);
        for (n = 0; n < 2; ++n) {
            byte[] byArray4 = n == 0 ? byArray : byArray2;
            for (int i = 0; i < byArray4.length; ++i) {
                d = byArray4[i] & 0xFF;
                byArray4[i] = (byte)(d <= d2 ? 0 : (d >= d3 ? 255 : (int)((d - d2) * d4) & 0xFF));
            }
        }
    }

    protected void inverseRGB() {
        int n = this.width * this.height;
        for (int i = 0; i < n; ++i) {
            this.pixelsRGB[i] = this.pixelsRGB[i] ^ 0xFFFFFF;
        }
        this.changeImgID();
        this.aladin.calque.select.repaint();
    }

    public void filterRGB(int[] nArray, int n) {
        this.changeImgID();
        if (this.red == null) {
            this.createRGB();
        }
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = this.width * this.height;
        for (int i = 0; i < n5; ++i) {
            int n6 = (this.pixelsRGB[i] & 0xFF0000) >> 16;
            int n7 = (this.pixelsRGB[i] & 0xFF00) >> 8;
            int n8 = this.pixelsRGB[i] & 0xFF;
            if (n == 0) {
                n6 = PlanImageRGB.filter(n2, n3, n4, this.red[i] & 0xFF);
            } else if (n == 1) {
                n7 = PlanImageRGB.filter(n2, n3, n4, this.green[i] & 0xFF);
            } else {
                n8 = PlanImageRGB.filter(n2, n3, n4, this.blue[i] & 0xFF);
            }
            if (this.video == 1) {
                if (n == 0) {
                    n6 ^= 0xFFFFFFFF;
                } else if (n == 1) {
                    n7 ^= 0xFFFFFFFF;
                } else {
                    n8 ^= 0xFFFFFFFF;
                }
                if (this.twoColors) {
                    if (!this.flagRed) {
                        n6 = Math.max(n7 & 0xFF, n8 & 0xFF);
                    } else if (!this.flagGreen) {
                        n7 = Math.max(n6 & 0xFF, n8 & 0xFF);
                    } else {
                        n8 = Math.max(n6 & 0xFF, n7 & 0xFF);
                    }
                }
            } else if (this.twoColors) {
                if (!this.flagRed) {
                    n6 = ((n7 & 0xFF) + (n8 & 0xFF)) / 2;
                } else if (!this.flagGreen) {
                    n7 = ((n6 & 0xFF) + (n8 & 0xFF)) / 2;
                } else {
                    n8 = ((n6 & 0xFF) + (n7 & 0xFF)) / 2;
                }
            }
            this.pixelsRGB[i] = 0xFF000000 | (n6 & 0xFF) << 16 | (n7 & 0xFF) << 8 | n8 & 0xFF;
        }
    }

    protected static final int filter(int n, int n2, int n3, int n4) {
        double d = 128.0;
        if (n4 <= n) {
            return 0;
        }
        if (n4 >= n3) {
            return 255;
        }
        if (n4 > n && n4 <= n2) {
            double d2 = n2 - n;
            if (d2 > 0.0) {
                double d3 = d / d2;
                double d4 = -d3 * (double)n;
                return (byte)((double)n4 * d3 + d4);
            }
        } else {
            double d5 = n3 - n2;
            if (d5 > 0.0) {
                double d6 = d / d5;
                double d7 = 128.0 - d6 * (double)n2;
                return (byte)((double)n4 * d6 + d7);
            }
        }
        return n4;
    }

    @Override
    protected void flip(int n) {
        this.createRGB();
        if (n == 0 || n == 2) {
            PlanImageRGB.invImageLine(this.width, this.height, this.pixelsRGB);
        }
        if (n == 1 || n == 2) {
            PlanImageRGB.invImageRow(this.width, this.height, this.pixelsRGB);
        }
        for (int i = 0; i < 3; ++i) {
            byte[] byArray;
            byte[] byArray2 = i == 0 ? this.red : (byArray = i == 1 ? this.green : this.blue);
            if (n == 0 || n == 2) {
                PlanImageRGB.invImageLine(this.width, this.height, byArray);
            }
            if (n != 1 && n != 2) continue;
            PlanImageRGB.invImageRow(this.width, this.height, byArray);
        }
        if (Projection.isOk(this.projd)) {
            this.projd.flip(n);
        }
        this.changeImgID();
        this.calculPixelsZoomRGB();
        this.aladin.calque.zoom.zoomView.repaint();
        this.aladin.view.newView(1);
        this.aladin.view.repaintAll();
    }

    protected static void invImageRow(int n, int n2, int[] nArray) {
        for (int i = 0; i < n2; ++i) {
            int n3 = i * n;
            for (int j = n / 2 - 1; j >= 0; --j) {
                int n4 = n3 + n - j - 1;
                int n5 = nArray[n3 + j];
                nArray[n3 + j] = nArray[n4];
                nArray[n4] = n5;
            }
        }
    }

    protected static void invImageLine(int n, int n2, int[] nArray) {
        int[] nArray2 = new int[n];
        for (int i = n2 / 2 - 1; i >= 0; --i) {
            int n3 = i * n;
            int n4 = (n2 - i - 1) * n;
            System.arraycopy(nArray, n3, nArray2, 0, n);
            System.arraycopy(nArray, n4, nArray, n3, n);
            System.arraycopy(nArray2, 0, nArray, n4, n);
        }
    }

    @Override
    protected Image getImage(ViewSimple viewSimple, boolean bl) {
        if (this.oImgID == this.imgID) {
            return this.image;
        }
        this.image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, this.cm, this.pixelsRGB, 0, this.width));
        this.oImgID = this.imgID;
        return this.image;
    }

    @Override
    public int getPixel8(int n, int n2) {
        return this.pixelsRGB[n2 * this.width + n];
    }

    @Override
    protected byte getPixel8Byte(int n, int n2) {
        return this.pixelsRGB == null ? (byte)0 : (byte)PlanImageRGB.getGreyPixel(this.getPixel8(n, n2));
    }

    private void postAJLoad() {
        block8: {
            this.postAJDone = true;
            try {
                if (this.labelRed != null) {
                    this.planRed = (PlanImage)this.aladin.calque.getPlan(this.labelRed, 1);
                    boolean bl = this.flagRed = this.planRed != null;
                    if (this.flagRed) {
                        this.pi[0] = this.planRed.hashCode();
                    }
                }
                if (this.labelGreen != null) {
                    this.planGreen = (PlanImage)this.aladin.calque.getPlan(this.labelGreen, 1);
                    boolean bl = this.flagGreen = this.planGreen != null;
                    if (this.flagGreen) {
                        this.pi[1] = this.planGreen.hashCode();
                    }
                }
                if (this.labelBlue != null) {
                    this.planBlue = (PlanImage)this.aladin.calque.getPlan(this.labelBlue, 1);
                    boolean bl = this.flagBlue = this.planBlue != null;
                    if (this.flagBlue) {
                        this.pi[2] = this.planBlue.hashCode();
                    }
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block8;
                exception.printStackTrace();
            }
        }
    }

    @Override
    protected boolean hasOriginalPixels() {
        return true;
    }

    @Override
    protected String getPixelInfo(int n, int n2, int n3) {
        if (!Projection.isOk(this.projd) || n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return "";
        }
        if (!this.postAJDone) {
            this.postAJLoad();
        }
        Coord coord = new Coord();
        coord.x = n;
        coord.y = n2;
        this.projd.getCoord(coord);
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        for (int i = 0; i < 3; ++i) {
            String string;
            PlanImage planImage;
            PlanImage planImage2 = i == 0 ? this.planRed : (planImage = i == 1 ? this.planGreen : this.planBlue);
            if (planImage == null || planImage.type == 0) {
                string = "";
            } else {
                planImage.projd.getXY(coord);
                planImage.pixelsOriginFromCache();
                string = planImage.getPixelInfo((int)coord.x, (int)coord.y, n3);
                ++n4;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append((i == 0 ? "R" : (i == 1 ? "G" : "B")) + ":" + Util.align(string, 6));
        }
        return n4 == 0 ? "" : stringBuffer.toString();
    }

    @Override
    protected void getPixels(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n + n3 > this.width) {
            n7 = n + n3 - this.width;
            n3 -= n7;
        }
        if (n2 + n4 > this.height) {
            n6 = n2 + n4 - this.height;
            n4 -= n6;
        }
        int n8 = n2 + n4;
        for (int i = n2; i < n8; ++i) {
            int n9 = 0;
            while (n9 < n3) {
                int n10 = this.pixelsRGB[i * this.width + n + n9];
                byArray[n5] = (byte)(0xFF & ((n10 & 0xFF0000) >> 16 + (n10 & 0xFF00) >> 8 + (n10 & 0xFF)) / 3);
                ++n9;
                ++n5;
            }
        }
    }

    @Override
    protected void getPixels(double[] dArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        if (n + n3 > this.width) {
            n6 = n + n3 - this.width;
            n3 -= n6;
        }
        if (n2 + n4 > this.height) {
            n5 = n2 + n4 - this.height;
            n4 -= n5;
        }
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n7 = this.pixelsRGB[(this.height - (i + n2) - 1) * this.width + j + n];
                dArray[i * n3 + j] = ((0xFF & n7 >> 24) + (0xFF & n7 >> 16) + (0xFF & n7)) / 3;
            }
        }
    }

    @Override
    public void getPixels(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n + n3 > this.width) {
            n7 = n + n3 - this.width;
            n3 -= n7;
        }
        if (n2 + n4 > this.height) {
            n6 = n2 + n4 - this.height;
            n4 -= n6;
        }
        int n8 = n2 + n4;
        for (int i = n2; i < n8; ++i) {
            System.arraycopy(this.pixelsRGB, i * this.width + n, nArray, n5, n3);
            n5 += n3 + n7;
        }
    }
}

