/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.PlanImage;
import cds.tools.Util;

public class PlanImageResamp
extends PlanImage {
    protected static final int PPV = 0;
    protected static final int BILINEAIRE = 1;
    private byte[] pixelsOriginInit = null;
    private byte[] pixelsInit = null;
    private int widthInit;
    private int heightInit;
    private PlanImage prefResample = null;
    protected boolean fullPixel = false;
    protected int methode;

    protected PlanImageResamp(Aladin aladin, PlanImage planImage) {
        super(aladin, planImage);
        this.type = 5;
    }

    protected PlanImageResamp(Aladin aladin) {
        super(aladin);
        this.type = 5;
    }

    protected boolean isResample() {
        return this.pixelsInit != null;
    }

    @Override
    protected void planReady(boolean bl) {
        if (!bl) {
            super.planReady(bl);
            return;
        }
        this.setActivated(true);
        this.setPourcent(-1.0);
        this.flagOk = true;
        this.aladin.calque.repaintAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launchResampleBy(PlanImage planImage, int n, boolean bl) {
        this.fullPixel = bl;
        this.methode = n;
        if (this.fullPixel) {
            this.pixelsOriginFromCache();
            this.cacheAvailable(false);
            this.noCacheFromOriginalFile();
        } else {
            this.noOriginalPixels();
        }
        if (planImage == null || planImage == this) {
            if (this.isResample()) {
                this.setBufPixels8(this.pixelsInit);
                if (this.fullPixel) {
                    this.pixelsOrigin = this.pixelsOriginInit;
                }
                this.naxis1 = this.width = this.widthInit;
                this.naxis2 = this.height = this.heightInit;
                this.projd = this.projInit;
                this.changeImgID();
                this.aladin.view.repaintAll();
            }
            return;
        }
        this.prefResample = planImage;
        this.flagOk = false;
        this.flagProcessing = true;
        this.aladin.calque.select.repaint();
        this.sendLog("Resample", " [" + this + " with " + planImage + (n == 1 ? "/bilinear" : "") + (this.fullPixel ? "/fullPix" : "") + "]");
        PlanImageResamp planImageResamp = this;
        synchronized (planImageResamp) {
            this.runme = new Thread((Runnable)this, "AladinBuildResamp");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    @Override
    protected boolean Free() {
        this.pixelsInit = null;
        this.pixelsOriginInit = null;
        return super.Free();
    }

    protected boolean resample() {
        boolean bl;
        PlanImage planImage = this.prefResample;
        Aladin.trace(3, "Resampling " + this + " with " + planImage + " method=" + this.methode);
        Coord coord = new Coord();
        int n = 0;
        int n2 = 0;
        int n3 = planImage.width;
        if (this.isResample()) {
            this.setBufPixels8(this.pixelsInit);
            if (this.fullPixel) {
                this.pixelsOrigin = this.pixelsOriginInit;
            }
        } else {
            this.pixelsInit = this.getBufPixels8();
            if (this.fullPixel) {
                this.pixelsOriginInit = this.pixelsOrigin;
            }
            this.widthInit = this.width;
            this.heightInit = this.height;
        }
        boolean bl2 = bl = this.pixelsOriginInit != null;
        if (!planImage.projd.c.TheSame(this.projInit.c)) {
            this.setBufPixels8(new byte[planImage.getBufPixels8().length]);
            if (bl) {
                this.pixelsOrigin = new byte[planImage.getBufPixels8().length * this.npix];
            }
            for (int i = 0; i < planImage.getBufPixels8().length; ++i) {
                coord.x = i % n3;
                coord.y = i / n3;
                planImage.projd.getCoord(coord);
                if (Double.isNaN(coord.al)) continue;
                this.projInit.getXY(coord);
                if (!Double.isNaN(coord.x)) {
                    switch (this.methode) {
                        case 0: {
                            n = (int)Math.round(coord.x);
                            n2 = (int)Math.round(coord.y);
                            if (n < 0 || n >= this.widthInit || n2 < 0 || n2 >= this.heightInit) break;
                            this.getBufPixels8()[i] = this.pixelsInit[n2 * this.widthInit + n];
                            if (!bl) break;
                            int n4 = (this.heightInit - n2 - 1) * this.widthInit + n;
                            int n5 = this.getBufPixels8().length - planImage.width * (i / planImage.width + 1) + i % planImage.width;
                            this.copyPixVal(this.pixelsOriginInit, n4, this.pixelsOrigin, n5);
                            break;
                        }
                        case 1: {
                            double d;
                            double d2;
                            double d3;
                            double d4;
                            int n6 = (int)Math.round(coord.x - 0.5);
                            int n7 = (int)Math.round(coord.y - 0.5);
                            int n8 = n6 + 1;
                            int n9 = n7 + 1;
                            if (n6 < 0 || n8 >= this.widthInit || n7 < 0 || n9 >= this.heightInit) break;
                            double d5 = 0xFF & this.pixelsInit[n7 * this.widthInit + n6];
                            double d6 = 0xFF & this.pixelsInit[n7 * this.widthInit + n8];
                            double d7 = 0xFF & this.pixelsInit[n9 * this.widthInit + n6];
                            double d8 = 0xFF & this.pixelsInit[n9 * this.widthInit + n8];
                            try {
                                d4 = 1.0 / (coord.x - (double)n6);
                                try {
                                    d3 = 1.0 / ((double)n8 - coord.x);
                                }
                                catch (Exception exception) {
                                    d4 = 0.0;
                                    d3 = 1.0;
                                }
                            }
                            catch (Exception exception) {
                                d4 = 1.0;
                                d3 = 0.0;
                            }
                            double d9 = (d5 * d4 + d6 * d3) / (d4 + d3);
                            double d10 = (d7 * d4 + d8 * d3) / (d4 + d3);
                            try {
                                d2 = 1.0 / (coord.y - (double)n7);
                                try {
                                    d = 1.0 / ((double)n9 - coord.y);
                                }
                                catch (Exception exception) {
                                    d2 = 0.0;
                                    d = 1.0;
                                }
                            }
                            catch (Exception exception) {
                                d2 = 1.0;
                                d = 0.0;
                            }
                            this.getBufPixels8()[i] = (byte)(0xFF & (int)((d9 * d2 + d10 * d) / (d2 + d)));
                            if (!bl) break;
                            d5 = this.getPixVal(this.pixelsOriginInit, this.bitpix, (this.heightInit - n7 - 1) * this.widthInit + n6);
                            d6 = this.getPixVal(this.pixelsOriginInit, this.bitpix, (this.heightInit - n7 - 1) * this.widthInit + n8);
                            d7 = this.getPixVal(this.pixelsOriginInit, this.bitpix, (this.heightInit - n9 - 1) * this.widthInit + n6);
                            d8 = this.getPixVal(this.pixelsOriginInit, this.bitpix, (this.heightInit - n9 - 1) * this.widthInit + n8);
                            d9 = (d5 * d4 + d6 * d3) / (d4 + d3);
                            d10 = (d7 * d4 + d8 * d3) / (d4 + d3);
                            PlanImageResamp.setPixVal(this.pixelsOrigin, this.bitpix, this.getBufPixels8().length - planImage.width * (i / planImage.width + 1) + i % planImage.width, (d9 * d2 + d10 * d) / (d2 + d));
                        }
                    }
                }
                if (i % 10000 != 0) continue;
                this.setPourcent(i * 100 / planImage.getBufPixels8().length);
                if (!Aladin.isSlow) continue;
                Util.pause(10);
            }
        }
        this.naxis1 = this.width = planImage.width;
        this.naxis2 = this.height = planImage.height;
        this.projInit = this.projd.copy();
        this.projd = planImage.projd.copy();
        this.setHasSpecificCalib();
        this.setPourcent(-1.0);
        Aladin.trace(3, "Resampling achieved...");
        this.flagProcessing = false;
        this.calculPixelsZoom();
        this.changeImgID();
        this.aladin.view.repaintAll();
        this.aladin.calque.zoom.zoomView.repaint();
        return true;
    }
}

