/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.ResourceNode;
import cds.tools.Util;
import java.util.Date;

public class PlanImageRice
extends PlanImage {
    static int[] nonzero_count = null;
    static byte[] b = new byte[1];

    protected PlanImageRice(Aladin aladin, String string, MyInputStream myInputStream, String string2, String string3, Obj obj, ResourceNode resourceNode, boolean bl, boolean bl2, Plan plan) {
        super(aladin, string, myInputStream, string2, string3, obj, resourceNode, bl, bl2, plan);
    }

    @Override
    protected boolean cacheImageFits(MyInputStream myInputStream) throws Exception {
        int n;
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderFits((Plan)this, myInputStream);
        }
        this.bitpix = this.headerFits.getIntFromHeader("ZBITPIX");
        this.width = this.naxis1 = this.headerFits.getIntFromHeader("ZNAXIS1");
        this.height = this.naxis2 = this.headerFits.getIntFromHeader("ZNAXIS2");
        this.npix = n = Math.abs(this.bitpix) / 8;
        int n2 = this.width * this.height * n;
        this.setPourcent(0.0);
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " BITPIX=" + this.bitpix + " => size=" + n2);
        this.loadFitsHeaderParam(this.headerFits);
        Date date = new Date();
        int n3 = this.headerFits.getIntFromHeader("NAXIS1");
        int n4 = this.headerFits.getIntFromHeader("NAXIS2");
        int n5 = n3 * n4;
        try {
            n5 = this.headerFits.getIntFromHeader("THEAP");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n6 = this.headerFits.getIntFromHeader("PCOUNT");
        int n7 = this.headerFits.getIntFromHeader("ZTILE1");
        boolean bl = this.aladin.configuration.getCMCut();
        int n8 = 32;
        try {
            n8 = this.headerFits.getIntFromHeader("ZVAL1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n9 = 4;
        try {
            n9 = this.headerFits.getIntFromHeader("ZVAL2");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setBufPixels8(new byte[this.width * this.height]);
        if (this.flagSkip) {
            myInputStream.skip(n5 + n6);
        } else {
            Aladin.trace(2, "Loading RICE FITS image extension (NBLOCK=" + n8 + " BSIZE=" + n9 + ")");
            int n10 = 0;
            int n11 = -1;
            int n12 = -1;
            int n13 = -1;
            int n14 = this.headerFits.getIntFromHeader("TFIELDS");
            int n15 = 0;
            for (int i = 1; i <= n14; ++i) {
                String string = this.headerFits.getStringFromHeader("TTYPE" + i);
                if (string.equals("COMPRESSED_DATA")) {
                    n10 = n15;
                }
                if (string.equals("ZSCALE")) {
                    n11 = n15;
                }
                if (string.equals("ZZERO")) {
                    n12 = n15;
                }
                if (string.equals("UNCOMPRESSED_DATA")) {
                    n13 = n15;
                }
                String string2 = this.headerFits.getStringFromHeader("TFORM" + i);
                n15 += Util.binSizeOf(string2);
            }
            Aladin.trace(2, "Loading RICE FITS image extension (TFIELDS=" + n14 + " NBLOCK=" + n8 + " BSIZE=" + n9 + ")");
            this.pixelsOrigin = new byte[n2];
            byte[] byArray = new byte[n3 * n4];
            byte[] byArray2 = new byte[n6];
            try {
                myInputStream.readFully(byArray);
                myInputStream.skip(n5 - n3 * n4);
                myInputStream.readFully(byArray2);
                int n16 = 0;
                for (int i = 0; i < n4; ++i) {
                    double d;
                    int n17 = i * n3;
                    int n18 = PlanImageRice.getInt(byArray, n17 + n10);
                    int n19 = PlanImageRice.getInt(byArray, n17 + n10 + 4);
                    double d2 = n11 < 0 ? 0.0 : PlanImageRice.getDouble(byArray, n17 + n12);
                    double d3 = d = n11 < 0 ? 1.0 : PlanImageRice.getDouble(byArray, n17 + n11);
                    if (n18 == 0 && n13 >= 0) {
                        n18 = PlanImageRice.getInt(byArray, n17 + n13);
                        n19 = PlanImageRice.getInt(byArray, n17 + n13);
                        PlanImageRice.direct(byArray2, n19, this.pixelsOrigin, n16, n7, this.bitpix, d2, d);
                    } else {
                        PlanImageRice.decomp(byArray2, n19, this.pixelsOrigin, n16, n7, n9, n8, this.bitpix, d2, d);
                    }
                    n16 += n7;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, bl, 0, 0, 0, 0);
            this.to8bits(this.getBufPixels8(), 0, this.pixelsOrigin, this.width * this.height, this.bitpix, this.pixelMin, this.pixelMax, true);
        }
        if (this.flagSkip) {
            return true;
        }
        this.headerFits.setKeyword("BITPIX", this.bitpix + "");
        this.headerFits.setKeyword("NAXIS1", this.width + "");
        this.headerFits.setKeyword("NAXIS2", this.height + "");
        this.headerFits.setKeyword("NAXIS", "2");
        Date date2 = new Date();
        int n20 = (int)(date2.getTime() - date.getTime());
        date = date2;
        Aladin.trace(3, " => Reading, uncompressing " + (bl ? "and autocutting " : "") + "in " + Util.round((double)n20 / 1000.0, 3) + " s => " + Util.round((double)this.offsetLoad / (double)n20 / 1048.576, 2) + " Mbyte/s");
        PlanImageRice.invImageLine(this.width, this.height, this.getBufPixels8());
        this.creatDefaultCM();
        this.setPourcent(99.0);
        return true;
    }

    protected static final void setPixVal(byte[] byArray, int n, int n2, int n3) {
        switch (n) {
            case 8: {
                byArray[n2] = (byte)(0xFF & n3);
                break;
            }
            case 16: {
                byArray[n2 *= 2] = (byte)(0xFF & n3 >>> 8);
                byArray[n2 + 1] = (byte)(0xFF & n3);
                break;
            }
            case 32: {
                PlanImageRice.setInt(byArray, n2 *= 4, n3);
                break;
            }
            case -32: {
                n3 = Float.floatToIntBits(n3);
                PlanImageRice.setInt(byArray, n2 *= 4, n3);
                break;
            }
            case -64: {
                long l = Double.doubleToLongBits(n3);
                n3 = (int)(0xFFFFFFFFL & l >>> 32);
                PlanImageRice.setInt(byArray, n2 *= 8, n3);
                n3 = (int)(0xFFFFFFFFL & l);
                PlanImageRice.setInt(byArray, n2 + 4, n3);
            }
        }
    }

    public static void direct(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4, double d, double d2) throws Exception {
        int n5 = Math.abs(n4) / 8;
        for (int i = 0; i < n3; i += n5) {
            double d3 = PlanImageRice.getPixVal1(byArray, n4, n + i);
            PlanImageRice.setPixVal(byArray2, n4, n2 + i, d3 * d2 + d);
        }
    }

    public static void decomp(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4, int n5, int n6, double d, double d2) throws Exception {
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        switch (n4) {
            case 1: {
                n11 = 3;
                n10 = 6;
                break;
            }
            case 2: {
                n11 = 4;
                n10 = 14;
                break;
            }
            case 4: {
                n11 = 5;
                n10 = 25;
                break;
            }
            default: {
                throw new Exception("Rice.decomp error: bitpix must be 8, 16 or 32");
            }
        }
        int n12 = 1 << n11;
        if (nonzero_count == null) {
            nonzero_count = new int[256];
            n9 = 8;
            n8 = 128;
            n7 = 255;
            while (n7 >= 0) {
                while (n7 >= n8) {
                    PlanImageRice.nonzero_count[n7] = n9;
                    --n7;
                }
                n8 /= 2;
                --n9;
            }
        }
        int n13 = 0;
        for (n7 = 0; n7 < n4; ++n7) {
            int n14 = 0xFF & byArray[n++];
            n13 = n13 << 8 | n14;
        }
        int n15 = 0xFF & byArray[n++];
        int n16 = 8;
        n7 = 0;
        while (n7 < n3) {
            int n17;
            n16 -= n11;
            while (n16 < 0) {
                n15 = n15 << 8 | 0xFF & byArray[n++];
                n16 += 8;
            }
            int n18 = (n15 >>> n16) - 1;
            n15 &= (1 << n16) - 1;
            int n19 = n7 + n5;
            if (n19 > n3) {
                n19 = n3;
            }
            if (n18 < 0) {
                while (n7 < n19) {
                    PlanImageRice.setPixVal(byArray2, n6, n7 + n2, (double)n13 * d2 + d);
                    ++n7;
                }
                continue;
            }
            if (n18 == n10) {
                while (n7 < n19) {
                    n8 = n12 - n16;
                    n17 = n15 << n8;
                    n8 -= 8;
                    while (n8 >= 0) {
                        n15 = 0xFF & byArray[n++];
                        n17 |= n15 << n8;
                        n8 -= 8;
                    }
                    if (n16 > 0) {
                        n15 = 0xFF & byArray[n++];
                        n17 |= n15 >>> -n8;
                        n15 &= (1 << n16) - 1;
                    } else {
                        n15 = 0;
                    }
                    n17 = (n17 & 1) == 0 ? (n17 >>>= 1) : ~(n17 >>> 1);
                    n13 = n17 + n13;
                    PlanImageRice.setPixVal(byArray2, n6, n7 + n2, (double)n13 * d2 + d);
                    ++n7;
                }
                continue;
            }
            while (n7 < n19) {
                while (n15 == 0) {
                    n16 += 8;
                    n15 = 0xFF & byArray[n++];
                }
                n9 = n16 - nonzero_count[n15];
                n15 ^= 1 << (n16 -= n9 + 1);
                n16 -= n18;
                while (n16 < 0) {
                    n15 = n15 << 8 | 0xFF & byArray[n++];
                    n16 += 8;
                }
                n17 = n9 << n18 | n15 >>> n16;
                n15 &= (1 << n16) - 1;
                n17 = (n17 & 1) == 0 ? (n17 >>>= 1) : ~(n17 >>> 1);
                n13 = n17 + n13;
                PlanImageRice.setPixVal(byArray2, n6, n7 + n2, (double)n13 * d2 + d);
                ++n7;
            }
        }
    }
}

