/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBGCat;
import cds.aladin.ViewSimple;
import cds.moc.Healpix;
import cds.moc.HealpixMoc;
import cds.moc.MocCell;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Hpix;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Iterator;

public class PlanMoc
extends PlanBGCat {
    public static final int DRAW_BORDER = 1;
    public static final int DRAW_FILLIN = 4;
    protected HealpixMoc moc = null;
    private int wireFrame = 5;
    private Hpix[][] arrayHpix = null;
    static int MAXGAPORDER = 3;
    private int gapOrder = 0;
    private boolean isLoading = false;
    private int lastOrderDrawn = -1;

    public PlanMoc(Aladin aladin) {
        super(aladin);
    }

    protected PlanMoc(Aladin aladin, HealpixMoc healpixMoc, String string, Coord coord, double d) {
        this(aladin, null, healpixMoc, string, coord, d);
    }

    protected PlanMoc(Aladin aladin, MyInputStream myInputStream, String string, Coord coord, double d) {
        this(aladin, myInputStream, null, string, coord, d);
    }

    protected PlanMoc(Aladin aladin, MyInputStream myInputStream, HealpixMoc healpixMoc, String string, Coord coord, double d) {
        super(aladin);
        this.arrayHpix = new Hpix[30][];
        this.dis = myInputStream;
        this.moc = healpixMoc;
        this.useCache = false;
        this.frameOrigin = 0;
        if (healpixMoc != null) {
            String string2 = healpixMoc.getCoordSys();
            this.frameOrigin = string2.equals("E") ? 2 : (string2.equals("G") ? 3 : 0);
        }
        this.type = 19;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        if (string == null) {
            string = "MOC";
        }
        this.setLabel(string);
        this.co = coord;
        this.coRadius = d;
        Aladin.trace(3, "AllSky creation: " + Plan.Tp[this.type] + (coord != null ? " around " + coord : ""));
        this.suite();
    }

    @Override
    protected void copy(Plan plan) {
        super.copy(plan);
        PlanMoc planMoc = (PlanMoc)plan;
        planMoc.frameOrigin = this.frameOrigin;
        planMoc.moc = (HealpixMoc)this.moc.clone();
        planMoc.wireFrame = this.wireFrame;
        planMoc.gapOrder = this.gapOrder;
        planMoc.arrayHpix = new Hpix[30][];
    }

    public HealpixMoc toReferenceFrame(String string) throws Exception {
        HealpixMoc healpixMoc = PlanMoc.convertTo(this.moc, string);
        if (this.moc != healpixMoc) {
            Aladin.trace(2, "Moc reference frame conversion: " + this.moc.getCoordSys() + " => " + healpixMoc.getCoordSys());
        }
        return healpixMoc;
    }

    public static HealpixMoc convertTo(HealpixMoc healpixMoc, String string) throws Exception {
        int n;
        if (string.equals(healpixMoc.getCoordSys())) {
            return healpixMoc;
        }
        char c = healpixMoc.getCoordSys().charAt(0);
        char c2 = string.charAt(0);
        int n2 = c == 'G' ? 3 : (n = c == 'E' ? 2 : 0);
        int n3 = c2 == 'G' ? 3 : (c2 == 'E' ? 2 : 0);
        Healpix healpix = new Healpix();
        int n4 = healpixMoc.getMaxOrder();
        HealpixMoc healpixMoc2 = new HealpixMoc(string, healpixMoc.getMinLimitOrder(), healpixMoc.getMocOrder());
        healpixMoc2.setCheckConsistencyFlag(false);
        long l = -1L;
        Iterator<Long> iterator = healpixMoc.pixelIterator();
        while (iterator.hasNext()) {
            long l2 = iterator.next();
            for (int i = 0; i < 4; ++i) {
                double[] dArray = healpix.pix2ang(n4 + 1, l2 * 4L + (long)i);
                Coord coord = new Coord(dArray[0], dArray[1]);
                coord = Localisation.frameToFrame(coord, n, n3);
                long l3 = healpix.ang2pix(n4 + 1, coord.al, coord.del);
                if (l3 == l) continue;
                l = l3;
                healpixMoc2.add(n4, l3 / 4L);
            }
        }
        healpixMoc2.setCheckConsistencyFlag(true);
        return healpixMoc2;
    }

    protected int getMocOrder() {
        return this.moc.getMocOrder();
    }

    protected HealpixMoc getMoc() {
        return this.moc;
    }

    @Override
    protected void suiteSpecific() {
        this.isOldPlan = false;
    }

    @Override
    protected boolean isSync() {
        return this.isReady();
    }

    @Override
    protected void reallocObjetCache() {
    }

    public void setWireFrame(int n) {
        this.wireFrame = n;
    }

    public void switchWireFrame(int n) {
        this.wireFrame &= ~n;
    }

    public int getWireFrame() {
        return this.wireFrame;
    }

    public boolean isDrawingBorder() {
        return (this.wireFrame & 1) != 0;
    }

    public boolean isDrawingFillIn() {
        return (this.wireFrame & 4) != 0;
    }

    public void setDrawingBorder(boolean bl) {
        this.wireFrame = bl ? (this.wireFrame |= 1) : (this.wireFrame &= 0xFFFFFFFE);
    }

    public void setDrawingFillIn(boolean bl) {
        this.wireFrame = bl ? (this.wireFrame |= 4) : (this.wireFrame &= 0xFFFFFFFB);
    }

    @Override
    protected boolean hasSources() {
        return false;
    }

    @Override
    protected int getCounts() {
        return 0;
    }

    @Override
    protected boolean waitForPlan() {
        block15: {
            Object object;
            if (this.dis != null) {
                super.waitForPlan();
                try {
                    if (this.moc == null && this.dis != null) {
                        this.moc = new HealpixMoc();
                        if ((this.dis.getType() & 1L) != 0L) {
                            this.moc.readFits(this.dis);
                        } else {
                            this.moc.readASCII(this.dis);
                        }
                    }
                    int n = this.frameOrigin = (object = this.moc.getCoordSys()) == null || ((String)object).charAt(0) == 'G' ? 3 : 0;
                    if (this.moc.getSize() == 0) {
                        this.error = "Empty MOC";
                    }
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace >= 3) {
                        exception.printStackTrace();
                    }
                    return false;
                }
            }
            if ((this.co == null || this.flagNoTarget) && this.moc.getSize() > 0 && this.frameOrigin == 0) {
                try {
                    object = this.moc.iterator().next();
                    double[] dArray = CDSHealpix.pix2ang_nest(CDSHealpix.pow2(((MocCell)object).getOrder()), ((MocCell)object).getNpix());
                    double[] dArray2 = CDSHealpix.polarToRadec(new double[]{dArray[0], dArray[1]});
                    this.co = new Coord(dArray2[0], dArray2[1]);
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace < 3) break block15;
                    exception.printStackTrace();
                }
            }
        }
        if (this.moc != null && this.moc.getMinLimitOrder() < 3) {
            try {
                this.moc.setMinLimitOrder(3);
            }
            catch (Exception exception) {
                if (Aladin.levelTrace >= 3) {
                    exception.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected Iterator<Obj> iterator() {
        return null;
    }

    @Override
    protected void resetProj(int n) {
    }

    @Override
    protected boolean isDrawn() {
        return true;
    }

    private HealpixMoc getViewMoc(ViewSimple viewSimple, int n) throws Exception {
        Coord coord = this.getCooCentre(viewSimple);
        long[] lArray = this.getPixList(viewSimple, coord, n);
        HealpixMoc healpixMoc = new HealpixMoc();
        healpixMoc.setCoordSys(this.moc.getCoordSys());
        for (int i = 0; i < lArray.length; ++i) {
            healpixMoc.add(n, lArray[i]);
        }
        healpixMoc.sort();
        return healpixMoc;
    }

    @Override
    protected int getGapOrder() {
        return this.gapOrder;
    }

    @Override
    protected void setGapOrder(int n) {
        if (Math.abs(n) > MAXGAPORDER) {
            return;
        }
        this.gapOrder = n;
    }

    private Hpix[] getHpixListProg(int n) {
        int n2;
        int n3 = this.moc.getMaxOrder();
        if (n3 < 3) {
            n3 = 3;
        }
        if ((n += 5) < 7) {
            n = 7;
        }
        if ((n += this.gapOrder) < 5) {
            n = 5;
        }
        if (n > n3) {
            n = n3;
        }
        if (this.arrayHpix[n] == null) {
            this.arrayHpix[n] = new Hpix[0];
            n2 = n;
            final int n4 = n3;
            new Thread("PlanMoc building order=" + n){

                @Override
                public void run() {
                    Aladin.trace(4, "PlanMoc.getHpixListProg(" + n2 + ") running...");
                    HealpixMoc healpixMoc = n2 == n4 ? PlanMoc.this.moc : (HealpixMoc)PlanMoc.this.moc.clone();
                    try {
                        healpixMoc.setMocOrder(n2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Hpix[] hpixArray = new Hpix[PlanMoc.this.moc.getSize()];
                    int n = 0;
                    for (MocCell mocCell : healpixMoc) {
                        hpixArray[n++] = new Hpix(mocCell.order, mocCell.npix, PlanMoc.this.frameOrigin);
                    }
                    ((PlanMoc)PlanMoc.this).arrayHpix[n2] = hpixArray;
                    Aladin.trace(4, "PlanMoc.getHpixListProg(" + n2 + ") done !");
                    PlanMoc.this.askForRepaint();
                }
            }.start();
        }
        if (this.arrayHpix[n].length == 0) {
            this.isLoading = true;
            for (n2 = n; n2 >= 5 && (this.arrayHpix[n2] == null || this.arrayHpix[n2].length == 0); --n2) {
            }
            if (n2 >= 5) {
                n = n2;
            }
        } else {
            this.isLoading = false;
        }
        this.lastOrderDrawn = n;
        return this.arrayHpix[n];
    }

    @Override
    protected boolean isLoading() {
        return this.isLoading;
    }

    @Override
    protected boolean hasMoreDetails() {
        return this.moc != null && this.lastOrderDrawn < this.moc.getMaxOrder();
    }

    @Override
    protected double getCompletude() {
        return -1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void draw(Graphics graphics, ViewSimple viewSimple) {
        block9: {
            long l = Util.getTime();
            graphics.setColor(this.c);
            int n = Math.min(this.maxOrder(viewSimple), this.maxOrder) + 1;
            try {
                Hpix hpix;
                HealpixMoc healpixMoc = viewSimple.isAllSky() ? null : this.getViewMoc(viewSimple, n);
                int n2 = 0;
                long l2 = 0L;
                Hpix[] hpixArray = this.getHpixListProg(n + (viewSimple.isAllSky() ? 0 : 1));
                for (int i = 0; i < hpixArray.length && (hpix = hpixArray[i]) != null; ++i) {
                    boolean bl;
                    n2 = hpix.getOrder();
                    if (healpixMoc != null && !healpixMoc.isIntersecting(n2, hpix.getNpix()) || hpix.isOutView(viewSimple)) continue;
                    boolean bl2 = bl = hpix.getDiag2(viewSimple) < 25.0 && this.isDrawingBorder();
                    if (this.isDrawingFillIn() && !bl) {
                        if (graphics instanceof Graphics2D) {
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            Composite composite = graphics2D.getComposite();
                            try {
                                graphics2D.setComposite(Util.getImageComposite(this.getOpacityLevel() / 5.0f));
                                hpix.fill(graphics, viewSimple);
                            }
                            finally {
                                graphics2D.setComposite(composite);
                            }
                        } else {
                            hpix.fill(graphics, viewSimple);
                        }
                    }
                    if (!this.isDrawingBorder()) continue;
                    hpix.draw(graphics, viewSimple, this.isDrawingBorder());
                }
                l2 = Util.getTime();
                this.statTimeDisplay = l2 - l;
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block9;
                exception.printStackTrace();
            }
        }
    }
}

