/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Plan;
import cds.aladin.PlanMoc;
import cds.moc.Healpix;
import cds.moc.HealpixMoc;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.util.ArrayList;

public class PlanMocAlgo
extends PlanMoc {
    static final int UNION = 0;
    static final int INTERSECTION = 1;
    static final int SUBTRACTION = 2;
    static final int DIFFERENCE = 3;
    static final int COMPLEMENT = 4;
    static final int TOORDER = 5;
    private static final String[] OPERATION = new String[]{"union", "inter", "sub", "diff", "compl", "ord"};

    protected static String getOpName(int n) {
        return OPERATION[n];
    }

    static int getOp(String string) {
        if (string.startsWith("-")) {
            string = string.substring(1);
        }
        return Util.indexInArrayOf(string, OPERATION, true);
    }

    public PlanMocAlgo(Aladin aladin, String string, PlanMoc[] planMocArray, int n, int n2) {
        super(aladin);
        PlanMoc planMoc = planMocArray[0];
        planMoc.copy(this);
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        String string2 = this.getFonction(planMoc, planMocArray, n, n2);
        if (string == null) {
            string = string2;
        }
        this.setLabel(string);
        Aladin.trace(3, "AllSky computation: " + Plan.Tp[this.type] + " => " + string2);
        try {
            this.moc = (HealpixMoc)planMoc.getMoc().clone();
            if (n == 4) {
                this.moc = this.moc.complement();
            } else if (n == 5) {
                this.moc.setMocOrder(n2);
            } else {
                block8: for (int i = 1; i < planMocArray.length; ++i) {
                    HealpixMoc healpixMoc = this.moc;
                    HealpixMoc healpixMoc2 = planMocArray[i].toReferenceFrame(healpixMoc.getCoordSys());
                    switch (n) {
                        case 0: {
                            this.moc = healpixMoc.union(healpixMoc2);
                            continue block8;
                        }
                        case 1: {
                            this.moc = healpixMoc.intersection(healpixMoc2);
                            continue block8;
                        }
                        case 2: {
                            this.moc = healpixMoc.subtraction(healpixMoc2);
                            continue block8;
                        }
                        case 3: {
                            this.moc = healpixMoc.difference(healpixMoc2);
                        }
                    }
                }
            }
            this.moc.setMinLimitOrder(3);
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            this.moc.clear();
            Aladin.error = this.error = exception.getMessage();
            this.flagOk = false;
        }
        this.copyright = "Computed by Aladin";
        this.flagProcessing = false;
        if (this.moc.getSize() == 0) {
            this.error = "Empty MOC";
            this.flagOk = true;
        } else {
            this.flagOk = true;
        }
        this.setActivated(this.flagOk);
        aladin.calque.repaintAll();
        this.sendLog("Compute", " [" + this + " = " + string2 + "]");
    }

    protected PlanMocAlgo(Aladin aladin, String string, PlanMoc planMoc, Coord[] coordArray) {
        super(aladin);
        planMoc.copy(this);
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        String string2 = "crop";
        if (string == null) {
            string = string2;
        }
        this.setLabel(string);
        Aladin.trace(3, "MOC cropping: " + Plan.Tp[this.type] + " => " + string2);
        try {
            CDSHealpix cDSHealpix = new CDSHealpix();
            int n = planMoc.moc.getMaxOrder();
            long l = Healpix.pow2(n);
            ArrayList<double[]> arrayList = new ArrayList<double[]>();
            for (Coord coord : coordArray) {
                arrayList.add(new double[]{coord.al, coord.del});
            }
            long[] lArray = CDSHealpix.query_polygon(l, arrayList);
            this.moc.clear();
            this.moc.setCheckConsistencyFlag(false);
            for (long l2 : lArray) {
                this.moc.add(n, l2);
            }
            this.moc.setCheckConsistencyFlag(true);
            this.moc = this.moc.intersection(planMoc.moc);
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            this.moc.clear();
            Aladin.error = this.error = exception.getMessage();
            this.flagOk = false;
        }
        this.copyright = "Computed by Aladin";
        this.flagProcessing = false;
        if (this.moc.getSize() == 0) {
            this.error = "Empty MOC";
            this.flagOk = true;
        } else {
            this.flagOk = true;
        }
        this.setActivated(this.flagOk);
        aladin.calque.repaintAll();
        this.sendLog("Compute", " [" + this + " = " + string2 + "]");
    }

    @Override
    protected void suite1() {
        System.out.println("Je fais rien");
    }

    private String getFonction(PlanMoc planMoc, PlanMoc[] planMocArray, int n, int n2) {
        if (n == 5) {
            return planMoc.label + ":" + n2;
        }
        String string = planMocArray.length > 1 ? planMocArray[1].label : null;
        String string2 = planMocArray.length > 2 ? planMocArray[2].label : null;
        return planMoc.label + " " + PlanMocAlgo.getOpName(n) + (string == null ? " " : string + (string2 == null ? "" : " ..."));
    }
}

