/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.HealpixKey;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PlanMoc;
import cds.aladin.Position;
import cds.moc.Healpix;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.CDSHealpix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class PlanMocGen
extends PlanMoc {
    private Plan[] p;
    private double radius;
    private double pixMin;
    private double pixMax;
    private double threshold;
    private int order;
    private double gapPourcent;

    protected PlanMocGen(Aladin aladin, String string, Plan[] planArray, int n, double d, double d2, double d3, double d4) {
        super(aladin, null, null, string, planArray[0].co, 30.0);
        this.p = planArray;
        this.order = n;
        this.radius = d;
        this.pixMin = d2;
        this.pixMax = d3;
        this.threshold = d4;
        this.pourcent = 0.0;
        this.gapPourcent = 100 / planArray.length;
        this.suiteSpecific();
        this.threading();
        this.log();
    }

    @Override
    protected void suite1() {
    }

    private void addMocFromCatalog(Plan plan, double d) {
        Iterator<Obj> iterator = plan.iterator();
        Healpix healpix = new Healpix();
        int n = this.order;
        Coord coord = new Coord();
        int n2 = 0;
        int n3 = plan.getCounts();
        double d2 = this.gapPourcent / (double)n3;
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (!(obj instanceof Position)) continue;
            if (n3 < 100 || n2 % 100 == 0) {
                this.pourcent += d2;
            }
            try {
                coord.al = ((Position)obj).raj;
                coord.del = ((Position)obj).dej;
                long[] lArray = d == 0.0 ? new long[]{healpix.ang2pix(n, coord.al, coord.del)} : healpix.queryDisc(n, coord.al, coord.del, d);
                for (long l : lArray) {
                    this.moc.add(n, l);
                }
                if ((n2 += lArray.length) <= 10000) continue;
                this.moc.checkAndFix();
                n2 = 0;
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) continue;
                exception.printStackTrace();
            }
        }
    }

    private void addMocFromImage(Plan plan, double d, double d2) {
        boolean bl = !Double.isNaN(d) || !Double.isNaN(d2);
        PlanImage planImage = (PlanImage)plan;
        Healpix healpix = new Healpix();
        int n = this.order;
        Coord coord = new Coord();
        double d3 = 1.0;
        double d4 = 0.0;
        double d5 = 0.0;
        try {
            d4 = Math.min(plan.projd.getPixResAlpha(), plan.projd.getPixResDelta());
            n = this.order;
            while (CDSHealpix.pixRes(CDSHealpix.pow2(n)) / 3600.0 <= d4 * 2.0) {
                --n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        d5 = CDSHealpix.pixRes(CDSHealpix.pow2(n)) / 3600.0;
        planImage.setLockCacheFree(true);
        planImage.pixelsOriginFromCache();
        double d6 = this.gapPourcent / (double)planImage.naxis2;
        long l = -1L;
        for (double d7 = 0.0; d7 < (double)planImage.naxis2; d7 += d3) {
            this.pourcent += d6;
            for (double d8 = 0.0; d8 < (double)planImage.naxis1; d8 += d3) {
                try {
                    coord.x = d8;
                    coord.y = (double)planImage.naxis2 - d7 - 1.0;
                    if (planImage.getPixel8Byte((int)d8, (int)coord.y) == 0 && Double.isNaN(planImage.getPixel((int)d8, (int)d7))) continue;
                    if (bl) {
                        double d9 = planImage.getPixel((int)d8, (int)d7);
                        if (!Double.isNaN(d) && d9 < d || !Double.isNaN(d2) && d9 > d2) continue;
                    }
                    planImage.projd.getCoord(coord);
                    long l2 = 0L;
                    l2 = healpix.ang2pix(n, coord.al, coord.del);
                    if (l2 == l) continue;
                    this.moc.add(n, l2);
                    l = l2;
                    continue;
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace < 3) continue;
                    exception.printStackTrace();
                }
            }
        }
        planImage.setLockCacheFree(false);
    }

    private void addMocFromPlanBG(Plan plan, int n, double d, double d2) {
        boolean bl = !Double.isNaN(d) || !Double.isNaN(d2);
        PlanBG planBG = (PlanBG)plan;
        int n2 = planBG.getTileOrder();
        int n3 = (int)planBG.getZ();
        int n4 = 0;
        int n5 = n - n2;
        if (n5 < 3) {
            n4 = (3 - n5) * 2;
            n5 = 3;
        }
        if (n5 > planBG.getMaxFileOrder()) {
            n5 = planBG.getMaxFileOrder();
            n = n5 + n2;
        }
        this.moc.setCoordSys(planBG.frameOrigin == 3 ? "G" : (planBG.frameOrigin == 2 ? "E" : "C"));
        this.frameOrigin = planBG.frameOrigin;
        try {
            this.moc.setCheckConsistencyFlag(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n6 = (int)CDSHealpix.pow2(n5);
        n6 = 12 * n6 * n6;
        try {
            planBG.createHealpixOrder(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        long l = CDSHealpix.pow2(n2);
        double d3 = this.gapPourcent / (double)n6;
        for (int i = 0; i < n6; ++i) {
            this.pourcent += d3;
            HealpixKey healpixKey = planBG.getHealpixLowLevel(n5, i, n3, 2);
            if (healpixKey == null) continue;
            long l2 = l * l * (long)i;
            try {
                int n7 = 0;
                long l3 = -1L;
                for (int j = 0; j < healpixKey.height; ++j) {
                    for (int k = 0; k < healpixKey.width; ++k) {
                        try {
                            long l4;
                            int n8 = j * healpixKey.width + k;
                            double d4 = healpixKey.getPixel(n8, 0);
                            if (Double.isNaN(d4) || d4 == this.blank || bl && (!Double.isNaN(d) && d4 < d || !Double.isNaN(d2) && d4 > d2) || (l4 = l2 + (long)planBG.xy2hpx(n8)) == l3) continue;
                            this.moc.add(n, l4 >>> n4);
                            l3 = i;
                            ++n7;
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                if (n7 <= 10000) continue;
                this.moc.checkAndFix();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.moc.setCheckConsistencyFlag(true);
            this.moc = this.toReferenceFrame("C");
            this.frameOrigin = 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addMocFromPlanBG(Plan plan, double d) throws Exception {
        int n;
        ArrayList<PixCum> arrayList;
        PlanBG planBG = (PlanBG)plan;
        this.order = planBG.getMaxHealpixOrder();
        int n2 = planBG.getTileOrder();
        int n3 = (int)planBG.getZ();
        int n4 = 0;
        int n5 = this.order - n2;
        if (n5 < 3) {
            n4 = (3 - n5) * 2;
            n5 = 3;
        }
        if (n5 > planBG.getMaxFileOrder()) {
            n5 = planBG.getMaxFileOrder();
            this.order = n5 + n2;
        }
        this.moc.setMaxLimitOrder(this.order);
        this.moc.setCoordSys(planBG.frameOrigin == 3 ? "G" : (planBG.frameOrigin == 2 ? "E" : "C"));
        this.frameOrigin = planBG.frameOrigin;
        int n6 = (int)CDSHealpix.pow2(n5);
        n6 = 12 * n6 * n6;
        try {
            planBG.createHealpixOrder(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        long l = CDSHealpix.pow2(n2);
        double d2 = this.gapPourcent / (double)n6;
        try {
            arrayList = new ArrayList<PixCum>((int)((long)n6 * l * l));
        }
        catch (Exception exception) {
            throw new Exception("Sorry! too large probability sky map !");
        }
        double d3 = 0.0;
        for (n = 0; n < n6; ++n) {
            this.pourcent += d2;
            HealpixKey object = planBG.getHealpixLowLevel(n5, n, n3, 2);
            if (object == null) continue;
            long l2 = l * l * (long)n;
            try {
                for (int i = 0; i < object.height; ++i) {
                    for (int j = 0; j < object.width; ++j) {
                        try {
                            int n7 = i * object.width + j;
                            double d4 = object.getPixel(n7, 0);
                            if (Double.isNaN(d4) || d4 == this.blank) continue;
                            long l3 = l2 + (long)planBG.xy2hpx(n7);
                            arrayList.add(new PixCum(l3, d4));
                            d3 += d4;
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Collections.sort(arrayList);
        if (Math.abs(1.0 - d3) > 1.0E-8) {
            for (PixCum pixCum : arrayList) {
                pixCum.val /= d3;
            }
        }
        d3 = 0.0;
        try {
            this.moc.setCheckConsistencyFlag(false);
            n = 0;
            for (PixCum pixCum : arrayList) {
                long l4 = pixCum.npix;
                if ((d3 += pixCum.val) > d) break;
                this.moc.add(this.order, l4 >>> n4);
                if (++n <= 10000) continue;
                this.moc.checkAndFix();
                n = 0;
            }
            this.moc.setCheckConsistencyFlag(true);
            this.moc = this.toReferenceFrame("C");
            this.frameOrigin = 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected boolean waitForPlan() {
        try {
            this.moc = new HealpixMoc();
            this.moc.setMinLimitOrder(3);
            if (this.order != -1) {
                this.moc.setMaxLimitOrder(this.order);
            }
            this.moc.setCoordSys("C");
            this.frameOrigin = 0;
            this.moc.setCheckConsistencyFlag(false);
            for (Plan plan : this.p) {
                if (plan.isCatalog()) {
                    this.addMocFromCatalog(plan, this.radius);
                    continue;
                }
                if (plan.isImage()) {
                    this.addMocFromImage(plan, this.pixMin, this.pixMax);
                    continue;
                }
                if (plan instanceof PlanBG && !Double.isNaN(this.threshold)) {
                    this.addMocFromPlanBG(plan, this.threshold);
                    continue;
                }
                if (!(plan instanceof PlanBG)) continue;
                this.addMocFromPlanBG(plan, this.order, this.pixMin, this.pixMax);
            }
            this.moc.setCheckConsistencyFlag(true);
        }
        catch (Exception exception) {
            this.error = exception.getMessage();
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            this.flagProcessing = false;
            return false;
        }
        this.flagProcessing = false;
        if (this.moc.getSize() == 0) {
            this.error = "Empty MOC";
        }
        this.flagOk = true;
        return true;
    }

    class PixCum
    implements Comparable {
        long npix;
        double val;

        PixCum(long l, double d) {
            this.npix = l;
            this.val = d;
        }

        public int compareTo(Object object) {
            if (this.val == ((PixCum)object).val) {
                return this.npix == ((PixCum)object).npix ? 0 : (this.npix < ((PixCum)object).npix ? 1 : -1);
            }
            return this.val < ((PixCum)object).val ? 1 : -1;
        }
    }
}

