/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.ViewSimple;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

public class PlanMultiCCD
extends PlanImage {
    PlanImage[] ccd;
    int ref;
    String labelBase;

    protected PlanMultiCCD(Aladin aladin, String string, Vector<Plan> vector) {
        super(aladin);
        this.labelBase = string;
        this.setCCD(vector);
        this.setRef(0);
    }

    @Override
    protected void setLabel(String string) {
        this.labelBase = string;
    }

    protected void setCCD(Vector<Plan> vector) {
        HashSet<String> hashSet = new HashSet<String>(vector.size());
        this.ccd = new PlanImage[vector.size()];
        Enumeration<Plan> enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            PlanImage planImage;
            this.ccd[n] = planImage = (PlanImage)enumeration.nextElement();
            planImage.planMultiCCD = this;
            if (hashSet != null) {
                String string = planImage.headerFits.getStringFromHeader("EXTNAME");
                if (string == null || hashSet.contains(string)) {
                    hashSet = null;
                }
                if (hashSet != null) {
                    hashSet.add(string);
                }
            }
            ++n;
        }
        if (hashSet != null) {
            for (PlanImage planImage : this.ccd) {
                planImage.setLabel(this.labelBase + " - " + planImage.headerFits.getStringFromHeader("EXTNAME"));
            }
        }
    }

    protected Vector<PlanImage> getCCD() {
        Vector<PlanImage> vector = new Vector<PlanImage>(this.ccd.length);
        for (PlanImage planImage : this.ccd) {
            vector.add(planImage);
        }
        return vector;
    }

    protected int getSize() {
        return this.ccd.length;
    }

    protected PlanImage getSelectedCCD() {
        return this.ccd[this.ref];
    }

    protected void setRef(int n) {
        this.ref = n;
        this.ccd[n].copy(this, true);
        this.setActivated(true);
        this.selected = true;
        if (this.aladin.frameCM != null) {
            this.aladin.frameCM.majCM();
        }
    }

    protected boolean setRef(Coord coord) {
        int n = this.getRef(coord);
        if (n == this.ref || n == -1) {
            return false;
        }
        this.setRef(n);
        return true;
    }

    private int getRef(Coord coord) {
        for (int i = 0; i < this.ccd.length; ++i) {
            if (!this.ccd[i].contains(coord)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void setCM(Object object) {
        super.setCM(object);
        this.ccd[this.ref].setCM(object);
    }

    @Override
    public void setOpacityLevel(float f) {
        super.setOpacityLevel(f);
        for (PlanImage planImage : this.ccd) {
            planImage.setOpacityLevel(f);
        }
    }

    @Override
    protected PointD[] getBords(ViewSimple viewSimple) {
        PointD[] pointDArray = null;
        for (PlanImage planImage : this.ccd) {
            PointD[] pointDArray2 = planImage.getBords(viewSimple);
            if (pointDArray == null) {
                pointDArray = pointDArray2;
                continue;
            }
            if (pointDArray2[0].x < pointDArray[0].x) {
                pointDArray[0].x = pointDArray2[0].x;
            }
            if (pointDArray2[0].y < pointDArray[0].y) {
                pointDArray[0].y = pointDArray2[0].y;
            }
            if (pointDArray2[3].x > pointDArray[3].x) {
                pointDArray[3].x = pointDArray2[3].x;
            }
            if (pointDArray2[3].y < pointDArray[3].y) {
                pointDArray[3].y = pointDArray2[3].y;
            }
            if (pointDArray2[2].x > pointDArray[2].x) {
                pointDArray[2].x = pointDArray2[2].x;
            }
            if (pointDArray2[2].y > pointDArray[2].y) {
                pointDArray[2].y = pointDArray2[2].y;
            }
            if (pointDArray2[1].x < pointDArray[1].x) {
                pointDArray[1].x = pointDArray2[1].x;
            }
            if (!(pointDArray2[1].y > pointDArray[1].y)) continue;
            pointDArray[1].y = pointDArray2[1].y;
        }
        return pointDArray;
    }

    @Override
    protected void setBufPixels8(byte[] byArray) {
        super.setBufPixels8(byArray);
        this.ccd[this.ref].setBufPixels8(byArray);
    }

    @Override
    protected boolean Free() {
        boolean bl = true;
        for (PlanImage planImage : this.ccd) {
            bl &= planImage.Free();
        }
        return bl;
    }

    @Override
    protected void draw(Graphics graphics, ViewSimple viewSimple, int n, int n2, float f) {
        for (PlanImage planImage : this.ccd) {
            planImage.draw(graphics, viewSimple, n, n2, f);
        }
    }

    protected static boolean isMultiCCD(Vector<Plan> vector) {
        long l = 0L;
        int n = 10;
        try {
            if (vector.size() < 2) {
                return false;
            }
            HealpixMoc healpixMoc = null;
            Enumeration<Plan> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object object;
                Plan plan = enumeration.nextElement();
                if (!plan.isImage()) {
                    return false;
                }
                if (healpixMoc == null) {
                    int n2 = Math.max(((PlanImage)plan).naxis1, ((PlanImage)plan).naxis2);
                    object = plan.projd.c.GetResol();
                    double d = Math.max((double)object[0], (double)object[1]) * (double)n2;
                    n = Aladin.getAppropriateOrder(d);
                }
                HealpixMoc healpixMoc2 = PlanMultiCCD.buildMoc(plan.projd, n);
                if (healpixMoc == null) {
                    healpixMoc = healpixMoc2;
                    l = (long)((double)healpixMoc.getUsedArea() * 0.2);
                    continue;
                }
                object = healpixMoc.intersection(healpixMoc2);
                if (((HealpixMoc)object).getUsedArea() > l) {
                    return false;
                }
                healpixMoc = healpixMoc.union(healpixMoc2);
            }
            return true;
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            return false;
        }
    }

    private static HealpixMoc buildMoc(Projection projection, int n) throws Exception {
        long[] lArray;
        HealpixMoc healpixMoc = new HealpixMoc(0, n);
        Coord coord = new Coord();
        ArrayList<double[]> arrayList = new ArrayList<double[]>(10);
        Dimension dimension = projection.c.getImgSize();
        for (int i = 0; i < 4; ++i) {
            coord.x = i == 0 || i == 3 ? 0 : dimension.width;
            coord.y = i < 2 ? 0 : dimension.height;
            projection.c.GetCoord(coord);
            arrayList.add(new double[]{coord.al, coord.del});
        }
        for (long l : lArray = CDSHealpix.query_polygon(CDSHealpix.pow2(n), arrayList)) {
            healpixMoc.add(n, l);
        }
        return healpixMoc;
    }
}

