/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.Projection;
import cds.aladin.Repere;
import cds.aladin.SourcePhot;
import cds.aladin.SourceStat;
import cds.aladin.SourceTag;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import cds.tools.VOApp;
import java.util.Enumeration;
import java.util.Iterator;

public class PlanTool
extends PlanCatalog {
    protected boolean movable = true;

    protected PlanTool(Aladin aladin, String string) {
        this.setLogMode(true);
        this.aladin = aladin;
        this.type = 9;
        this.c = Couleur.getNextDefault(aladin.calque);
        if (string == null) {
            string = "Drawing";
        }
        this.setLabel(string);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        this.flagOk = true;
        this.askActive = true;
        aladin.calque.selectPlan(this);
        Plan plan = aladin.calque.getPlanRef();
        if (plan == null || !Projection.isOk(plan.projd)) {
            this.projd = new Projection();
            this.hasXYorig = true;
        } else {
            this.hasXYorig = false;
        }
    }

    protected PlanTool(Aladin aladin) {
        this.setLogMode(true);
        this.aladin = aladin;
        this.type = 9;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        this.flagOk = true;
        this.askActive = true;
    }

    @Override
    protected boolean Free() {
        if (this.aladin.view.zoomview.flagCut || this.aladin.view.zoomview.flagHist) {
            Iterator<Obj> iterator = this.iterator();
            while (iterator.hasNext()) {
                Obj obj = iterator.next();
                if (!obj.isSelected()) continue;
                obj.remove();
            }
        }
        return super.Free();
    }

    public SourceTag addTag(ViewSimple viewSimple, double d, double d2) {
        SourceTag sourceTag = new SourceTag(this, viewSimple, new Coord(d, d2), null);
        this.pcat.insertSource(sourceTag);
        this.aladin.view.newView(1);
        this.setSourceRemovable(true);
        return sourceTag;
    }

    public SourcePhot addPhot(ViewSimple viewSimple, double d, double d2, double[] dArray) {
        SourcePhot sourcePhot = new SourcePhot((Plan)this, viewSimple, new Coord(d, d2), dArray);
        this.pcat.insertSource(sourcePhot);
        this.aladin.view.newView(1);
        this.setSourceRemovable(true);
        return sourcePhot;
    }

    @Override
    protected String getInfo() {
        if (this.type == 0) {
            return super.getInfo();
        }
        return this.label + super.addDebugInfo();
    }

    @Override
    protected void setPropertie(String string, String string2, String string3) throws Exception {
        if (string.equalsIgnoreCase("movable")) {
            this.setMovable(string3);
        } else {
            super.setPropertie(string, string2, string3);
        }
    }

    @Override
    protected boolean isMovable() {
        return this.movable;
    }

    @Override
    protected boolean isCatalog() {
        return this.hasTag();
    }

    protected boolean hasTag() {
        if (this.pcat == null) {
            return false;
        }
        Iterator<Obj> iterator = this.iterator();
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (!(obj instanceof SourceTag)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasPhot() {
        if (this.pcat == null) {
            return false;
        }
        Iterator<Obj> iterator = this.iterator();
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (!(obj instanceof SourceStat)) continue;
            return true;
        }
        return false;
    }

    protected void setMovable(String string) throws Exception {
        if (string.equalsIgnoreCase("On")) {
            this.movable = true;
        } else if (string.equalsIgnoreCase("Off")) {
            this.movable = false;
        } else {
            throw new Exception("Syntax error => movable=on|off");
        }
    }

    protected void setIdAgain() {
        if (this.pcat == null) {
            return;
        }
        Iterator<Obj> iterator = this.iterator();
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (!(obj instanceof Repere)) continue;
            ((Repere)obj).setId();
        }
    }

    protected void sendMesureObserver(Obj obj, boolean bl) {
        if (this.aladin.VOObsMes == null || this.aladin.VOObsMes.size() == 0) {
            return;
        }
        int n = this.pcat.getIndex(obj);
        String string = "set " + Tok.quote(this.label + "/" + n) + " measure=" + obj.id + (bl ? " ..." : "");
        Aladin.trace(4, "sendMesureObserver(): [" + string + "]");
        Enumeration enumeration = this.aladin.VOObsMes.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((VOApp)enumeration.nextElement()).execCommand(string);
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) continue;
                exception.printStackTrace();
            }
        }
    }
}

