/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AppMessagingInterface;
import cds.aladin.Coord;
import cds.aladin.FrameServer;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanImage;
import cds.aladin.PlasticWidget;
import cds.aladin.SAMPUtil;
import cds.aladin.Save;
import cds.aladin.Source;
import cds.aladin.VOResource;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.ladypleaser.rmilite.Client;
import org.votech.plastic.PlasticHubListener;
import org.votech.plastic.PlasticListener;
import uk.ac.starlink.plastic.MinimalHub;
import uk.ac.starlink.plastic.ServerSet;

public class PlasticManager
implements PlasticListener,
AppMessagingInterface {
    protected static final URI MSG_ECHO = URI.create("ivo://votech.org/test/echo");
    protected static final URI MSG_APP_REGISTERED = URI.create("ivo://votech.org/hub/event/ApplicationRegistered");
    protected static final URI MSG_APP_UNREGISTERED = URI.create("ivo://votech.org/hub/event/ApplicationUnregistered");
    protected static final URI MSG_GETNAME = URI.create("ivo://votech.org/info/getName");
    protected static final URI MSG_GETIVORN = URI.create("ivo://votech.org/info/getIVORN");
    protected static final URI MSG_GETVERSION = URI.create("ivo://votech.org/info/getVersion");
    protected static final URI MSG_HUBSTOPPING = URI.create("ivo://votech.org/hub/event/HubStopping");
    protected static final URI MSG_EXCEPTION = URI.create("ivo://votech.org/hub/Exception");
    protected static final URI MSG_LOAD_VOT = URI.create("ivo://votech.org/votable/load");
    protected static final URI MSG_LOAD_VOT_FROM_URL = URI.create("ivo://votech.org/votable/loadFromURL");
    protected static final URI MSG_SELECT_OBJECTS = URI.create("ivo://votech.org/votable/showObjects");
    protected static final URI MSG_HIGHLIGHT_OBJECT = URI.create("ivo://votech.org/votable/highlightObject");
    protected static final URI MSG_GET_ICON_URL = URI.create("ivo://votech.org/info/getIconURL");
    protected static final URI MSG_LOAD_FITS = URI.create("ivo://votech.org/fits/image/loadFromURL");
    protected static final URI MSG_POINT_AT_COORDS = URI.create("ivo://votech.org/sky/pointAtCoords");
    protected static final URI MSG_GET_DESC = URI.create("ivo://votech.org/info/getDescription");
    protected static final URI MSG_LOAD_FITS_LINE_FROM_URL = URI.create("ivo://votech.org/fits/line/loadFromURL");
    protected static final URI MSG_LOAD_SPECTRUM_FROM_URL = URI.create("ivo://votech.org/spectrum/loadFromURL");
    protected static final URI MSG_SEND_ALADIN_SCRIPT_CMD = URI.create("ivo://votech.org/aladin/sendScript");
    protected static final URI MSG_LOAD_VORESOURCE = URI.create("ivo://votech.org/voresource/load");
    protected static final URI MSG_LOAD_VORESOURCE_LIST = URI.create("ivo://votech.org/voresource/loadList");
    protected static final URI MSG_LOAD_CHARAC_FROM_URL = URI.create("ivo://votech.org/charac/loadFromURL");
    protected static final URI[] SUPPORTED_MESSAGES = new URI[]{MSG_ECHO, MSG_GETNAME, MSG_GETIVORN, MSG_GETVERSION, MSG_HUBSTOPPING, MSG_EXCEPTION, MSG_LOAD_VOT, MSG_LOAD_VOT_FROM_URL, MSG_SELECT_OBJECTS, MSG_GET_ICON_URL, MSG_LOAD_FITS, MSG_APP_REGISTERED, MSG_APP_UNREGISTERED, MSG_POINT_AT_COORDS, MSG_GET_DESC, MSG_HIGHLIGHT_OBJECT, MSG_SEND_ALADIN_SCRIPT_CMD, MSG_LOAD_VORESOURCE, MSG_LOAD_VORESOURCE_LIST};
    protected static final String SUPPORTED_VERSION = "0.4";
    protected static final String ALADIN_NAME = "Aladin";
    protected static final String ALADIN_IVORN = "ivo://CDS/Aladin";
    protected static final String PLASTIC_CONF_FILE = ".plastic";
    private int curState = 0;
    protected static final String ALADIN_DESC = "ALADIN is an interactive software sky atlas developed by the CDS, allowing one to visualize digitized imagesof any part of the sky, to superimpose entries from astronomical catalogs,and to interactively access related data and information.";
    static String LAUNCH_INTERNAL_HUB;
    static String CANT_CONNECT;
    static String CANT_LAUNCH_HUB;
    static String HUB_STOP;
    static String EXCEPTION;
    static String CONFIRM_STOP_HUB;
    private Aladin a;
    protected static boolean callToPlastic;
    private PlasticHubListener plasticHubListener;
    private boolean isRegistered = false;
    private URI aladinID;
    private PlasticWidget widget;
    private static MinimalHub internalHub;
    private Hashtable appNamesToURI;
    private Vector appNames;
    private static final Object VOID;
    private static final Object TRUE;
    private static final Object FALSE;
    Integer oidx;
    String oid;
    ResourceChooser resourceChooser;
    private Plan lastPlaneWithSelectedSrc;
    private boolean plasticTrace = false;

    protected PlasticManager(Aladin aladin) {
        this.a = aladin;
        callToPlastic = true;
        this.createChaine();
    }

    private void createChaine() {
        String string = this.getProtocolName();
        LAUNCH_INTERNAL_HUB = Aladin.chaine.getString("PMLAUNCHHUB").replaceAll("SAMP", string);
        CANT_CONNECT = Aladin.chaine.getString("PMCANTCONNECT").replaceAll("SAMP", string);
        CANT_LAUNCH_HUB = Aladin.chaine.getString("PMCANTLAUNCHHUB").replaceAll("SAMP", string);
        HUB_STOP = Aladin.chaine.getString("PMHUBWILLSTOP").replaceAll("SAMP", string);
        EXCEPTION = Aladin.chaine.getString("PMEXCEPTION").replaceAll("SAMP", string);
        CONFIRM_STOP_HUB = Aladin.chaine.getString("PMCONFIRMSTOPHUB").replaceAll("SAMP", string);
    }

    @Override
    public boolean register(boolean bl, boolean bl2) {
        this.trace("Try to register Aladin with the plastic hub");
        if (this.isRegistered()) {
            this.trace("Aladin was already registered !");
            return true;
        }
        if (!this.getHubListener(bl, bl2)) {
            this.trace("Could not register to the Plastic hub");
            return false;
        }
        boolean bl3 = false;
        try {
            this.aladinID = this.plasticHubListener.registerRMI(ALADIN_NAME, Arrays.asList(SUPPORTED_MESSAGES), this);
        }
        catch (Exception exception) {
            bl3 = true;
        }
        if (bl3) {
            this.isRegistered = false;
        } else {
            this.isRegistered = true;
            Aladin.trace(3, "Successful registration with the plastic hub with application ID " + this.aladinID);
        }
        if (this.widget != null) {
            this.widget.updateStatus(this.isRegistered());
        }
        this.updateState();
        return true;
    }

    private boolean isSupporting(URI uRI) {
        for (int i = 0; i < SUPPORTED_MESSAGES.length; ++i) {
            if (!SUPPORTED_MESSAGES[i].equals(uRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean unregister() {
        return this.unregister(false);
    }

    @Override
    public boolean unregister(boolean bl) {
        return this.unregister(bl, true);
    }

    @Override
    public boolean unregister(boolean bl, boolean bl2) {
        block6: {
            this.trace("Try to unregister Aladin from the plastic hub");
            if (!this.isRegistered()) {
                this.trace("Aladin is not registered with the hub, no need to unregister !");
                return true;
            }
            if (!this.getHubListener(false)) {
                this.trace("Could not unregister from the Plastic hub");
                return false;
            }
            try {
                this.plasticHubListener.unregister(this.aladinID);
            }
            catch (Exception exception) {
                this.trace("Error while trying to unregister : " + exception.getMessage());
                if (bl) break block6;
                return false;
            }
        }
        this.isRegistered = false;
        this.plasticHubListener = null;
        this.aladinID = null;
        if (bl2) {
            this.stopInternalHub(bl);
        }
        if (this.widget != null) {
            this.widget.animateWidgetReceive(true, false);
        }
        this.updateState();
        Aladin.trace(3, "Successful unregistration from the plastic hub");
        return true;
    }

    @Override
    public boolean isRegistered() {
        return this.isRegistered;
    }

    @Override
    public synchronized boolean startInternalHub() {
        Aladin.trace(1, "Starting an internal PlasKit hub");
        try {
            ServerSet serverSet = new ServerSet(new File(System.getProperty("user.home"), PLASTIC_CONF_FILE));
            internalHub = new MinimalHub(serverSet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        this.updateState();
        return true;
    }

    @Override
    public synchronized void stopInternalHub(boolean bl) {
        if (internalHub == null) {
            return;
        }
        List list = internalHub.getRegisteredIds();
        if (!(bl || list.size() == 0 || list.size() == 1 && list.get(0).equals(internalHub.getHubId()) || Aladin.confirmation(this.widget, CONFIRM_STOP_HUB))) {
            return;
        }
        Aladin.trace(1, "Stopping internal PlasKit hub");
        internalHub.stop();
        internalHub = null;
        this.updateState();
    }

    private boolean getHubListener(boolean bl) {
        return this.getHubListener(bl, false);
    }

    private boolean getHubListener(boolean bl, boolean bl2) {
        int n;
        if (this.plasticHubListener != null) {
            return true;
        }
        this.trace("Looking for an existing .plastic file");
        File file = PlasticManager.getLockFile();
        if (!file.exists()) {
            this.trace("Can't find .plastic file, can't registrate with a PLASTIC hub");
            if (bl2) {
                boolean bl3 = false;
                if (!bl) {
                    bl3 = Aladin.confirmation(this.a, LAUNCH_INTERNAL_HUB);
                    if (!bl3) {
                        return false;
                    }
                } else {
                    bl3 = true;
                }
                if (bl3) {
                    if (!this.startInternalHub() && !bl) {
                        Aladin.warning(CANT_LAUNCH_HUB);
                    } else {
                        Util.pause(1000);
                        return this.getHubListener(true);
                    }
                }
            }
            return false;
        }
        this.trace("Reading the .plastic conf file to retrieve the RMI port number");
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            return false;
        }
        String string = properties.getProperty("plastic.rmi.port");
        if (string == null) {
            this.trace("Can not find property 'plastic.rmi.port' !");
            if (!bl) {
                Aladin.warning(CANT_CONNECT);
            }
            return false;
        }
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.trace("Can not convert the property 'plastic.rmi.port' to integer !");
            if (!bl) {
                Aladin.warning(CANT_CONNECT);
            }
            return false;
        }
        try {
            Client client = new Client("localhost", n);
            client.exportInterface(PlasticListener.class);
            this.trace("Get the PlasticHubListener object through RMI");
            this.plasticHubListener = (PlasticHubListener)client.lookup(PlasticHubListener.class);
        }
        catch (ConnectException connectException) {
            Aladin.trace(3, "Unable to connect to the hub, deleting the .plastic file");
            try {
                if (file.delete()) {
                    this.updateState();
                    return this.getHubListener(bl, bl2);
                }
                if (!bl) {
                    Aladin.warning(CANT_CONNECT);
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.trace("Unable to create the PlasticHubListener object");
            if (!bl) {
                Aladin.warning(CANT_CONNECT);
            }
            return false;
        }
        return true;
    }

    @Override
    public Object getAppWithName(String string) {
        return this.appNamesToURI.get(string);
    }

    private String getNameForApp(URI uRI) {
        this.getAppsSupporting(MSG_GETNAME);
        Enumeration enumeration = this.appNamesToURI.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!uRI.equals(this.appNamesToURI.get(k))) continue;
            return (String)k;
        }
        return "Unknown";
    }

    @Override
    public void sendMessageLoadImage(String string, String string2, List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string);
        arrayList.add(string2);
        this.sendAsyncMessage(MSG_LOAD_FITS, arrayList, list);
    }

    @Override
    public void sendMessageLoadVOTable(String string, String string2, String string3, Map map, List list) {
    }

    @Override
    public void sendMessageLoadSpectrum(String string, String string2, String string3, Map map, List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add(map);
        this.sendAsyncMessage(MSG_LOAD_SPECTRUM_FROM_URL, arrayList, list == null ? null : list);
    }

    @Override
    public void sendMessageLoadCharac(String string, String string2, List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        this.sendAsyncMessage(MSG_LOAD_CHARAC_FROM_URL, arrayList, list);
    }

    private URI getMessage(AppMessagingInterface.AbstractMessage abstractMessage) {
        if (abstractMessage.equals(ABSTRACT_MSG_LOAD_FITS)) {
            return MSG_LOAD_FITS;
        }
        if (abstractMessage.equals(ABSTRACT_MSG_LOAD_VOT_FROM_URL)) {
            return MSG_LOAD_VOT_FROM_URL;
        }
        if (abstractMessage.equals(ABSTRACT_MSG_LOAD_SPECTRUM_FROM_URL)) {
            return MSG_LOAD_SPECTRUM_FROM_URL;
        }
        if (abstractMessage.equals(ABSTRACT_MSG_LOAD_CHARAC_FROM_URL)) {
            return MSG_LOAD_CHARAC_FROM_URL;
        }
        return null;
    }

    @Override
    public ArrayList<String> getAppsSupportingTables() {
        return this.getAppsSupporting(ABSTRACT_MSG_LOAD_VOT_FROM_URL);
    }

    @Override
    public synchronized ArrayList<String> getAppsSupporting(AppMessagingInterface.AbstractMessage abstractMessage) {
        URI uRI = this.getMessage(abstractMessage);
        return this.getAppsSupporting(uRI);
    }

    private synchronized ArrayList<String> getAppsSupporting(URI uRI) {
        if (uRI == null) {
            return null;
        }
        if (!this.isRegistered() || uRI == null) {
            return null;
        }
        Object[] objectArray = this.plasticHubListener.getMessageRegisteredIds(uRI).toArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.isSupporting(uRI) && objectArray.length > 0 ? objectArray.length - 1 : objectArray.length;
        if (n == 0) {
            return new ArrayList<String>();
        }
        if (this.appNamesToURI == null) {
            this.appNamesToURI = new Hashtable();
        }
        if (this.appNames == null) {
            this.appNames = new Vector();
        }
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            URI uRI2 = (URI)objectArray[i];
            if (uRI2.equals(this.aladinID)) continue;
            String string = null;
            Enumeration enumeration = this.appNamesToURI.keys();
            while (string == null && enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!this.appNamesToURI.get(string2).equals(uRI2)) continue;
                string = string2;
            }
            if (string == null) {
                string = this.plasticHubListener.getName(uRI2);
                int n2 = 1;
                String string3 = new String(string);
                while (this.appNames.contains(string)) {
                    string = string3 + "-" + n2++;
                }
                this.appNames.addElement(string);
                this.appNamesToURI.put(string, uRI2);
            }
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    protected static File getLockFile() {
        File file = new File(System.getProperty("user.home"));
        return new File(file, PLASTIC_CONF_FILE);
    }

    private Object processMessage(URI uRI, URI uRI2, List list) {
        int n;
        this.trace("Plastic message : sender is : " + uRI);
        this.trace("Plastic message : message is : " + uRI2);
        Object[] objectArray = list.toArray();
        for (n = 0; n < objectArray.length; ++n) {
            this.trace("argument " + n + " is: " + objectArray[n]);
        }
        n = objectArray.length;
        if (!this.supportMessage(uRI2)) {
            this.trace("Aladin is not supporting message " + uRI2);
            return VOID;
        }
        if (!this.mustProcessMessage(uRI, uRI2)) {
            this.trace("According to plastic preferences, the message " + uRI2 + " coming from app " + uRI + " should not be processed");
            return VOID;
        }
        if (uRI2.equals(MSG_ECHO)) {
            return objectArray[0];
        }
        if (uRI2.equals(MSG_GETNAME)) {
            return ALADIN_NAME;
        }
        if (uRI2.equals(MSG_GETIVORN)) {
            return ALADIN_IVORN;
        }
        if (uRI2.equals(MSG_GET_ICON_URL)) {
            return "http://aladin.u-strasbg.fr/aladin_large.gif";
        }
        if (uRI2.equals(MSG_GET_DESC)) {
            return ALADIN_DESC;
        }
        if (uRI2.equals(MSG_GETVERSION)) {
            return SUPPORTED_VERSION;
        }
        if (uRI2.equals(MSG_APP_REGISTERED)) {
            this.updateState();
            return VOID;
        }
        if (uRI2.equals(MSG_APP_UNREGISTERED)) {
            this.updateState();
            return VOID;
        }
        if (uRI2.equals(MSG_HUBSTOPPING)) {
            this.unregister(true);
            this.isRegistered = false;
            return VOID;
        }
        if (uRI2.equals(MSG_EXCEPTION)) {
            Aladin.warning(EXCEPTION + ":\nID: " + (n > 0 ? objectArray[0].toString() : "") + "\nMessage: " + (n > 1 ? objectArray[1].toString() : ""), 1);
            return VOID;
        }
        if (uRI2.equals(MSG_LOAD_VOT)) {
            if (n < 1) {
                return FALSE;
            }
            String string = objectArray[0].toString();
            String string2 = n >= 2 ? objectArray[1].toString() : "PLASTIC table";
            int n2 = this.loadVOT(string, string2, uRI);
            Aladin.trace(3, "Receiving table " + string2);
            this.a.log("PLASTIC", "receiving table");
            return n2 >= 0 ? TRUE : FALSE;
        }
        if (uRI2.equals(MSG_LOAD_VOT_FROM_URL)) {
            if (n < 1) {
                return FALSE;
            }
            String string = objectArray[0].toString();
            String string3 = n >= 2 ? objectArray[1].toString() : string;
            int n3 = this.loadVOTFromURL(string, string3, uRI);
            Aladin.trace(3, "Receiving table " + string);
            this.a.log("PLASTIC", "receiving table");
            return n3 >= 0 ? TRUE : FALSE;
        }
        if (uRI2.equals(MSG_LOAD_FITS)) {
            if (n < 1) {
                return FALSE;
            }
            String string = objectArray[0].toString();
            String string4 = n >= 2 ? objectArray[1].toString() : string;
            int n4 = this.loadFitsImageFromURL(string, string4, uRI);
            Aladin.trace(3, "Receiving image " + string);
            this.a.log("PLASTIC", "receiving image");
            return n4 >= 0 ? TRUE : FALSE;
        }
        if (uRI2.equals(MSG_SELECT_OBJECTS)) {
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = objectArray[i].toString();
            }
            this.selectObjects(stringArray, objectArray);
            return VOID;
        }
        if (uRI2.equals(MSG_HIGHLIGHT_OBJECT)) {
            this.highlightObject(objectArray[0].toString(), (Integer)objectArray[1]);
            return TRUE;
        }
        if (uRI2.equals(MSG_POINT_AT_COORDS)) {
            double d;
            double d2;
            if (n < 2) {
                return FALSE;
            }
            try {
                d2 = (Double)objectArray[0];
                d = (Double)objectArray[1];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return FALSE;
            }
            this.a.execCommand(Coord.getSexa(d2, d));
            return TRUE;
        }
        if (uRI2.equals(MSG_SEND_ALADIN_SCRIPT_CMD)) {
            if (n < 1) {
                return FALSE;
            }
            String string = objectArray[0].toString();
            this.a.execCommand(string);
            return TRUE;
        }
        if (uRI2.equals(MSG_LOAD_VORESOURCE)) {
            if (n < 1) {
                return FALSE;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(objectArray[0]);
            return this.loadVOResources(new Object[]{arrayList}, uRI) ? TRUE : FALSE;
        }
        if (uRI2.equals(MSG_LOAD_VORESOURCE_LIST)) {
            if (n < 1) {
                return FALSE;
            }
            return this.loadVOResources(objectArray, uRI) ? TRUE : FALSE;
        }
        Aladin.trace(3, "The message " + uRI2 + " has not been processed (unknown message) !");
        System.out.println("***" + uRI2 + "*** not processed");
        return VOID;
    }

    private synchronized void selectObjects(String[] stringArray, Object[] objectArray) {
        this.selectSources(objectArray);
    }

    private void selectSources(Object[] objectArray) {
        if (objectArray == null || objectArray[0] == null) {
            this.trace("selectSources : argument is null, can't do anything !");
            return;
        }
        String string = objectArray[0].toString();
        Plan plan = this.findPlaneByPlasticID(string);
        if (plan == null) {
            this.trace("Could not find plane with plastic ID " + string);
            return;
        }
        if (objectArray[1] == null) {
            this.trace("selectSources : second parameter is null, can't do anything !");
            return;
        }
        if (!(objectArray[1] instanceof List)) {
            this.trace("selectSources : second parameter is not of type List, can't do anything !");
            return;
        }
        Object[] objectArray2 = ((List)objectArray[1]).toArray();
        int[] nArray = new int[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            nArray[i] = objectArray2[i] instanceof Integer ? ((Integer)objectArray2[i]).intValue() : ((Long)objectArray2[i]).intValue();
        }
        this.a.view.selectSourcesByRowNumber((PlanCatalog)plan, nArray);
    }

    private synchronized void highlightObject(String string, Integer n) {
        this.oid = string;
        this.oidx = n;
        Plan plan = this.findPlaneByPlasticID(string);
        if (plan == null) {
            this.trace("Could not find plane with plastic ID " + string);
            return;
        }
        this.a.view.showSource((Source)plan.pcat.getObj(n));
    }

    private int loadVOTFromURL(String string, String string2, URI uRI) {
        InputStream inputStream;
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.trace("The provided URL string is malformed, can not load VOTable file !");
            return -1;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            this.trace("IOException occured when getting stream from VOTable URL, loading is aborted");
            return -1;
        }
        int n = this.a.calque.newPlan(inputStream, "PLASTIC", uRI.toString());
        if (n >= 0) {
            this.a.calque.plan[n].addPlasticID(string2);
        }
        return n;
    }

    @Override
    public String getProtocolName() {
        return "PLASTIC";
    }

    private int loadFitsImageFromURL(String string, String string2, URI uRI) {
        try {
            URL uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.trace("The provided URL string is malformed, can not load FITS file !");
            return -1;
        }
        int n = this.a.calque.newPlan(string, "PLASTIC", uRI.toString());
        if (n >= 0) {
            this.a.calque.plan[n].addPlasticID(string2);
        }
        return n;
    }

    private int loadVOT(String string, String string2, URI uRI) {
        int n = this.a.calque.newPlan(new ByteArrayInputStream(string.getBytes()), "PLASTIC", uRI.toString());
        if (n >= 0) {
            this.a.calque.plan[n].addPlasticID(string2);
        }
        return n;
    }

    @Override
    public boolean ping() {
        if (this.plasticHubListener == null) {
            return false;
        }
        try {
            this.plasticHubListener.getHubId();
        }
        catch (Exception exception) {
            this.unregister(true);
            this.isRegistered = false;
            return false;
        }
        return true;
    }

    private boolean supportMessage(URI uRI) {
        return true;
    }

    private boolean mustProcessMessage(URI uRI, URI uRI2) {
        return true;
    }

    @Override
    public boolean broadcastTable(final Plan plan, final String[] stringArray) {
        File file;
        Aladin.trace(3, "Broadcasting table " + plan.getLabel() + " to " + (stringArray == null ? "everyone" : stringArray.length + " applications"));
        if (this.widget != null) {
            this.widget.animateWidgetSend();
        }
        if ((file = this.a.createTempFile("plastic" + SAMPUtil.sanitizeFilename(plan.getLabel()), ".xml")) == null) {
            this.trace("Couldn't create temporary file, can't broadcast table !");
            return false;
        }
        new Thread("AladinPlasticSendTable"){

            @Override
            public void run() {
                if (((PlasticManager)PlasticManager.this).a.save == null) {
                    ((PlasticManager)PlasticManager.this).a.save = new Save(PlasticManager.this.a);
                }
                ((PlasticManager)PlasticManager.this).a.save.saveCatVOTable(file, plan, false);
                URL uRL = SAMPUtil.getURLForFile(file);
                String string = uRL.toString();
                String string2 = plan.getPlasticID();
                if (string2 == null) {
                    string2 = string;
                    plan.addPlasticID(string2);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                arrayList.add(string2);
                PlasticManager.this.trace("Broadcast table with URL: " + string);
                ArrayList<URI> arrayList2 = null;
                if (stringArray != null) {
                    arrayList2 = new ArrayList<URI>();
                    for (int i = 0; i < stringArray.length; ++i) {
                        URI uRI = (URI)PlasticManager.this.appNamesToURI.get(stringArray[i]);
                        if (uRI != null) {
                            arrayList2.add(uRI);
                            PlasticManager.this.trace("Adding " + uRI + " to list of recipients");
                            continue;
                        }
                        PlasticManager.this.trace("Couldn't find URI of application " + stringArray[i]);
                    }
                }
                PlasticManager.this.sendAsyncMessage(MSG_LOAD_VOT_FROM_URL, arrayList, arrayList2);
                PlasticManager.this.a.log("PLASTIC", "broadcast table");
            }
        }.start();
        return true;
    }

    @Override
    public boolean broadcastImage(final Plan plan, final String[] stringArray) {
        File file;
        Aladin.trace(3, "Broadcasting image " + plan.getLabel() + " to " + (stringArray == null ? "everyone" : stringArray.length + " applications"));
        if (plan == null || !(plan instanceof PlanImage)) {
            return false;
        }
        if (this.widget != null) {
            this.widget.animateWidgetSend();
        }
        if ((file = this.a.createTempFile("plastic" + SAMPUtil.sanitizeFilename(plan.getLabel()), ".fits")) == null) {
            this.trace("Couldn't create temporary file, can't broadcast image !");
            return false;
        }
        new Thread("AladinPlasticSendImage"){

            @Override
            public void run() {
                if (((PlasticManager)PlasticManager.this).a.save == null) {
                    ((PlasticManager)PlasticManager.this).a.save = new Save(PlasticManager.this.a);
                }
                ((PlasticManager)PlasticManager.this).a.save.saveImageFITS(file, (PlanImage)plan);
                URL uRL = SAMPUtil.getURLForFile(file);
                String string = uRL.toString();
                String string2 = plan.getPlasticID();
                if (string2 == null) {
                    string2 = string;
                    plan.addPlasticID(string2);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                arrayList.add(string2);
                ArrayList<URI> arrayList2 = null;
                if (stringArray != null) {
                    arrayList2 = new ArrayList<URI>();
                    for (int i = 0; i < stringArray.length; ++i) {
                        URI uRI = (URI)PlasticManager.this.appNamesToURI.get(stringArray[i]);
                        if (uRI != null) {
                            arrayList2.add(uRI);
                            PlasticManager.this.trace("Adding " + uRI + " to list of recipients");
                            continue;
                        }
                        PlasticManager.this.trace("Couldn't find URI of application " + stringArray[i]);
                    }
                }
                PlasticManager.this.sendAsyncMessage(MSG_LOAD_FITS, arrayList, arrayList2);
                PlasticManager.this.a.log("PLASTIC", "broadcast image");
            }
        }.start();
        return true;
    }

    private boolean loadVOResources(Object[] objectArray, URI uRI) {
        if (this.resourceChooser == null) {
            this.resourceChooser = new ResourceChooser();
        }
        if (objectArray[0] == null) {
            this.trace("loadVOResources : first parameter is null, can't do anything !");
            return false;
        }
        if (!(objectArray[0] instanceof List)) {
            this.trace("loadVOResources : first parameter is not of type List, can't do anything !");
        }
        String[] stringArray = ((List)objectArray[0]).toArray(new String[((List)objectArray[0]).size()]);
        this.resourceChooser.updateFrame(stringArray, uRI);
        return true;
    }

    @Override
    public void sendSelectObjectsMsg() {
        if (!this.a.plasticPrefs.getBooleanValue("PlasticSelect")) {
            return;
        }
        if (!this.isRegistered()) {
            return;
        }
        new Thread("AladinPlasticSendSelect"){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                Plan plan;
                Source[] sourceArray;
                block10: {
                    sourceArray = ((PlasticManager)PlasticManager.this).a.view.getSelectedSources();
                    if (sourceArray == null) {
                        return;
                    }
                    ArrayList arrayList = PlasticManager.this.getAppsSupporting(MSG_SELECT_OBJECTS);
                    if (arrayList == null || arrayList.size() == 0) {
                        PlasticManager.this.trace("None of the connected applications supports the 'select objects' message");
                        return;
                    }
                    PlasticManager.this.trace("Sending message " + MSG_SELECT_OBJECTS);
                    if (Aladin.levelTrace >= 3) {
                        for (int i = 0; i < sourceArray.length && i < 3; ++i) {
                            Aladin.trace(3, "select object : " + sourceArray[i]);
                        }
                    }
                    if ((plan = PlasticManager.this.findPlaneForSources(sourceArray)) == null) {
                        if (sourceArray.length == 0 && PlasticManager.this.lastPlaneWithSelectedSrc != null) {
                            PlasticManager.this.trace("0 object selected, will send a 'deselection' message");
                            plan = PlasticManager.this.lastPlaneWithSelectedSrc;
                            PlasticManager.this.lastPlaneWithSelectedSrc = null;
                            break block10;
                        } else {
                            PlasticManager.this.lastPlaneWithSelectedSrc = plan;
                            return;
                        }
                    }
                    PlasticManager.this.lastPlaneWithSelectedSrc = plan;
                }
                if (plan.getPlasticID() == null) {
                    return;
                }
                Vector vector = PlasticManager.this.getSequenceNumber(plan, sourceArray);
                Integer[] integerArray = new Integer[vector.size()];
                Enumeration enumeration = vector.elements();
                int n = 0;
                while (true) {
                    if (!enumeration.hasMoreElements()) {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.add(plan.getPlasticID());
                        arrayList.add(Arrays.asList(integerArray));
                        PlasticManager.this.sendAsyncMessage(MSG_SELECT_OBJECTS, arrayList, null);
                        return;
                    }
                    integerArray[n] = (Integer)enumeration.nextElement();
                    ++n;
                }
            }
        }.start();
    }

    private Plan findPlaneForSources(Source[] sourceArray) {
        return sourceArray == null || sourceArray.length == 0 ? null : sourceArray[0].plan;
    }

    @Override
    public void pointAtCoords(double d, double d2) {
    }

    private Plan findPlaneByPlasticID(String string) {
        Plan plan = null;
        Plan[] planArray = this.a.calque.plan;
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i] == null || !planArray[i].isSimpleCatalog() || !planArray[i].hasPlasticID(string)) continue;
            plan = planArray[i];
        }
        return plan;
    }

    private Vector getSequenceNumber(Plan plan, Source[] sourceArray) {
        Vector<Integer> vector = new Vector<Integer>();
        Iterator<Obj> iterator = plan.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (obj != null) {
                for (int i = 0; i < sourceArray.length; ++i) {
                    Source source = (Source)obj;
                    if (!source.equals(sourceArray[i])) continue;
                    vector.addElement(new Integer(n));
                    break;
                }
            }
            ++n;
        }
        return vector;
    }

    @Override
    public boolean internalHubRunning() {
        return internalHub != null;
    }

    @Override
    public void updateState() {
        new Thread("AladinPlasticUpdate"){

            @Override
            public void run() {
                block9: {
                    try {
                        if (PlasticManager.this.isRegistered()) {
                            if (PlasticManager.this.getAppsConnected().length > 0) {
                                PlasticManager.this.curState = 3;
                            } else {
                                PlasticManager.this.curState = 2;
                            }
                        } else if (PlasticManager.getLockFile().exists()) {
                            PlasticManager.this.curState = 1;
                        } else {
                            PlasticManager.this.curState = 0;
                        }
                    }
                    catch (Exception exception) {
                        if (Aladin.levelTrace < 3) break block9;
                        exception.printStackTrace();
                    }
                }
                if (PlasticManager.this.widget != null) {
                    PlasticManager.this.widget.updateStatus(PlasticManager.this.curState);
                }
            }
        }.start();
    }

    private String[] getAppsConnected() {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        try {
            objectArray = this.plasticHubListener.getRegisteredIds().iterator();
            String string = this.plasticHubListener.getHubId().toString();
            while (objectArray.hasNext()) {
                String string2 = objectArray.next().toString();
                if (string2.equals(this.aladinID.toString()) || string2.equals(string)) continue;
                vector.addElement(string2);
            }
        }
        catch (Exception exception) {
            return new String[0];
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        return objectArray;
    }

    @Override
    public void sendHighlightObjectsMsg(Source source) {
        if (!this.a.plasticPrefs.getBooleanValue("PlasticHighlight")) {
            return;
        }
        if (source == null) {
            return;
        }
        if (!this.isRegistered()) {
            return;
        }
        Source[] sourceArray = new Source[]{source};
        Plan plan = this.findPlaneForSources(sourceArray);
        if (plan == null) {
            this.trace("Could not find plane, can't send PLASTIC message");
            return;
        }
        Vector vector = this.getSequenceNumber(plan, sourceArray);
        if (vector.size() == 0) {
            this.trace("Could not find sequence number for source " + source);
            return;
        }
        Integer n = (Integer)vector.elementAt(0);
        if (this.oidx != null && this.oid != null && this.oid.equals(plan.getPlasticID()) && this.oidx.equals(n)) {
            return;
        }
        this.oidx = n;
        this.oid = plan.getPlasticID();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(plan.getPlasticID());
        arrayList.add(n);
        this.sendAsyncMessage(MSG_HIGHLIGHT_OBJECT, arrayList, null);
    }

    private Object sendMessage(URI uRI, URI uRI2, List list, List list2) {
        if (!this.isRegistered) {
            return null;
        }
        if (list2 == null) {
            return this.plasticHubListener.request(uRI, uRI2, list);
        }
        return this.plasticHubListener.requestToSubset(uRI, uRI2, list, list2);
    }

    private Object sendMessage(URI uRI, List list, List list2) {
        return this.sendMessage(this.aladinID, uRI, list, list2);
    }

    private void sendAsyncMessage(URI uRI, URI uRI2, List list, List list2) {
        if (!this.isRegistered) {
            return;
        }
        if (list2 == null) {
            this.plasticHubListener.requestAsynch(uRI, uRI2, list);
        } else {
            this.plasticHubListener.requestToSubsetAsynch(uRI, uRI2, list, list2);
        }
    }

    private void sendAsyncMessage(URI uRI, List list, List list2) {
        this.sendAsyncMessage(this.aladinID, uRI, list, list2);
    }

    @Override
    public void setPlasticWidget(PlasticWidget plasticWidget) {
        this.widget = plasticWidget;
    }

    @Override
    public PlasticWidget getPlasticWidget() {
        return this.widget;
    }

    @Override
    public Object perform(URI uRI, URI uRI2, List list) {
        if (!Aladin.PLASTIC_SUPPORT) {
            return null;
        }
        if (this.widget != null) {
            this.widget.animateWidgetReceive();
        }
        return this.processMessage(uRI, uRI2, list);
    }

    @Override
    public void trace(String string) {
        if (!this.plasticTrace) {
            return;
        }
        System.out.println("** PLASTIC : " + string);
    }

    @Override
    public boolean getPlasticTrace() {
        return this.plasticTrace;
    }

    @Override
    public void setPlasticTrace(boolean bl) {
        this.plasticTrace = bl;
    }

    static {
        callToPlastic = false;
        VOID = "";
        TRUE = Boolean.TRUE;
        FALSE = Boolean.FALSE;
    }

    class ResourceChooser
    extends JFrame
    implements ActionListener {
        JList list;
        DefaultListModel model;
        private boolean firstShow;
        String[] uris;
        VOResource[] resources;

        ResourceChooser() {
            super("Choose resources to keep");
            this.firstShow = true;
            Util.setCloseShortcut(this, false);
            this.getContentPane().setLayout(new BorderLayout());
        }

        void updateFrame(final String[] stringArray, URI uRI) {
            this.uris = stringArray;
            this.getContentPane().removeAll();
            ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel("<html><b>" + PlasticManager.this.getNameForApp(uRI) + "</b> has sent some registry resources.<br>Select resources you want to keep:<br></html>");
            jPanel.add(jLabel);
            this.getContentPane().add((Component)jPanel, "North");
            JPanel jPanel2 = new JPanel();
            DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
            this.list = new JList();
            this.list.setSelectionModel(defaultListSelectionModel);
            JScrollPane jScrollPane = new JScrollPane(this.list);
            this.model = new DefaultListModel();
            for (int i = 0; i < stringArray.length; ++i) {
                this.model.addElement(stringArray[i]);
            }
            this.list.setModel(this.model);
            jPanel2.add(jScrollPane);
            this.list.setPreferredSize(new Dimension(550, 200));
            jScrollPane.setPreferredSize(new Dimension(550, 200));
            this.getContentPane().add((Component)jPanel2, "Center");
            JPanel jPanel3 = new JPanel(new FlowLayout());
            JButton jButton = new JButton("OK");
            jButton.addActionListener(this);
            jButton.setFont(Aladin.BOLD);
            jPanel3.add(jButton);
            JButton jButton2 = new JButton("Close");
            jButton2.addActionListener(this);
            jPanel3.add(jButton2);
            this.getContentPane().add((Component)jPanel3, "South");
            this.pack();
            if (this.firstShow) {
                this.firstShow = false;
                this.setSize(new Dimension(600, 300));
                this.setLocation(200, 200);
            }
            this.setVisible(true);
            this.toFront();
            new Thread("PlasticManager:resolveIVORN"){

                @Override
                public void run() {
                    ResourceChooser.this.resolveIVORN(stringArray);
                }
            }.start();
        }

        private void resolveIVORN(String[] stringArray) {
            this.list.getSelectionModel().clearSelection();
            this.resources = new VOResource[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                VOResource vOResource;
                this.resources[i] = vOResource = FrameServer.getIvorn(stringArray[i]);
                if (vOResource == null) continue;
                this.model.setElementAt(stringArray[i] + " - " + (vOResource == null ? "" : vOResource.desc), i);
                if (vOResource == null || vOResource.type == null || !vOResource.type.equals("siap") && !vOResource.type.equals("ssap") && !vOResource.type.equals("cs")) continue;
                this.list.getSelectionModel().addSelectionInterval(i, i);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

