/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.prop.PropPanel;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PlasticPreferences
extends JFrame
implements ActionListener {
    protected static final String PREF_AUTOCONNECT = "PlasticAutoconnect";
    protected static final String PREF_LAUNCHHUB = "PlasticLaunchHub";
    protected static final String PREF_SENDPOS = "PlasticSendPos";
    protected static final String PREF_SELECT = "PlasticSelect";
    protected static final String PREF_HIGHLIGHT = "PlasticHighlight";
    static String TITLE;
    static String DEFAUTOCONNECT;
    static String AUTOCONNECT;
    static String DEFLAUNCHHUB;
    static String LAUNCHHUB;
    static String DEFSELECTOBJECTS;
    static String SELECTOBJECTS;
    static String DEFHIGHLIGHTOBJECT;
    static String HIGHLIGHTOBJECT;
    static String DEFSENDPOSITION;
    static String SENDPOSITION;
    static String APPLY;
    static String CLOSE;
    private JCheckBox autoconnectCb;
    private JCheckBox launchhubCb;
    private JCheckBox selectobjectsCb;
    private JCheckBox highlightCb;
    private JCheckBox sendpositionCb;
    private Aladin a;

    public PlasticPreferences(Aladin aladin) {
        this.a = aladin;
        Aladin.setIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PlasticPreferences.this.setVisible(false);
            }
        });
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 7, 5, 7));
        this.buildFrame();
    }

    private void buildFrame() {
        this.createChaine();
        this.setTitle(TITLE);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JLabel jLabel = new JLabel(TITLE, 0);
        jLabel.setFont(Aladin.LITALIC);
        Aladin.makeAdd(this.getContentPane(), jLabel, "North");
        Aladin.makeAdd(this.getContentPane(), this.createPanel(), "Center");
        Aladin.makeAdd(this.getContentPane(), this.getValidPanel(), "South");
        this.pack();
    }

    private JPanel createPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
        PropPanel.addSectionTitle(jPanel, DEFAUTOCONNECT, gridBagLayout, gridBagConstraints);
        this.autoconnectCb = new JCheckBox(AUTOCONNECT);
        PropPanel.addCouple(jPanel, "", this.autoconnectCb, gridBagLayout, gridBagConstraints);
        PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
        PropPanel.addSectionTitle(jPanel, DEFLAUNCHHUB, gridBagLayout, gridBagConstraints);
        this.launchhubCb = new JCheckBox(LAUNCHHUB);
        PropPanel.addCouple(jPanel, "", this.launchhubCb, gridBagLayout, gridBagConstraints);
        PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
        PropPanel.addSectionTitle(jPanel, DEFSELECTOBJECTS, gridBagLayout, gridBagConstraints);
        this.selectobjectsCb = new JCheckBox(SELECTOBJECTS);
        PropPanel.addCouple(jPanel, "", this.selectobjectsCb, gridBagLayout, gridBagConstraints);
        PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
        PropPanel.addSectionTitle(jPanel, DEFHIGHLIGHTOBJECT, gridBagLayout, gridBagConstraints);
        this.highlightCb = new JCheckBox(HIGHLIGHTOBJECT);
        PropPanel.addCouple(jPanel, "", this.highlightCb, gridBagLayout, gridBagConstraints);
        PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
        PropPanel.addSectionTitle(jPanel, DEFSENDPOSITION, gridBagLayout, gridBagConstraints);
        this.sendpositionCb = new JCheckBox(SENDPOSITION);
        PropPanel.addCouple(jPanel, "", this.sendpositionCb, gridBagLayout, gridBagConstraints);
        PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    private JPanel getValidPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.setFont(Aladin.LBOLD);
        JButton jButton = new JButton(APPLY);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton = new JButton(CLOSE);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (CLOSE.equals(string)) {
            this.setVisible(false);
        } else if (APPLY.equals(string)) {
            try {
                if (this.apply()) {
                    this.setVisible(false);
                }
            }
            catch (Exception exception) {
                Aladin.warning(this, " " + exception.getMessage(), 1);
            }
        }
    }

    public boolean apply() {
        this.a.configuration.set(PREF_AUTOCONNECT, String.valueOf(this.autoconnectCb.isSelected()));
        this.a.configuration.set(PREF_LAUNCHHUB, String.valueOf(this.launchhubCb.isSelected()));
        this.a.configuration.set(PREF_SELECT, String.valueOf(this.selectobjectsCb.isSelected()));
        this.a.configuration.set(PREF_HIGHLIGHT, String.valueOf(this.highlightCb.isSelected()));
        this.a.configuration.set(PREF_SENDPOS, String.valueOf(this.sendpositionCb.isSelected()));
        this.a.saveConfig();
        return true;
    }

    protected void showPrefs() {
        this.updateCbState();
        this.setVisible(true);
        this.toFront();
    }

    protected boolean getBooleanValue(String string) {
        String string2 = this.a.configuration.get(string);
        return string2 == null ? this.getDefaultValue(string) : new Boolean(string2).booleanValue();
    }

    private boolean getDefaultValue(String string) {
        return true;
    }

    private void updateCbState() {
        String string = this.a.configuration.get(PREF_AUTOCONNECT);
        boolean bl = string == null ? this.getDefaultValue(PREF_AUTOCONNECT) : new Boolean(string).booleanValue();
        this.autoconnectCb.setSelected(bl);
        string = this.a.configuration.get(PREF_LAUNCHHUB);
        bl = string == null ? this.getDefaultValue(PREF_LAUNCHHUB) : new Boolean(string).booleanValue();
        this.launchhubCb.setSelected(bl);
        string = this.a.configuration.get(PREF_SELECT);
        bl = string == null ? this.getDefaultValue(PREF_SELECT) : new Boolean(string).booleanValue();
        this.selectobjectsCb.setSelected(bl);
        string = this.a.configuration.get(PREF_HIGHLIGHT);
        bl = string == null ? this.getDefaultValue(PREF_HIGHLIGHT) : new Boolean(string).booleanValue();
        this.highlightCb.setSelected(bl);
        string = this.a.configuration.get(PREF_SENDPOS);
        bl = string == null ? this.getDefaultValue(PREF_SENDPOS) : new Boolean(string).booleanValue();
        this.sendpositionCb.setSelected(bl);
    }

    private void createChaine() {
        TITLE = Aladin.chaine.getString("PPTITLE");
        DEFAUTOCONNECT = Aladin.chaine.getString("PPDEFAUTOCONNECT");
        AUTOCONNECT = Aladin.chaine.getString("PPAUTOCONNECT");
        DEFLAUNCHHUB = Aladin.chaine.getString("PPDEFLAUNCHHUB");
        LAUNCHHUB = Aladin.chaine.getString("PPLAUNCHHUB");
        DEFSELECTOBJECTS = Aladin.chaine.getString("PPDEFSELECTOBJECTS");
        SELECTOBJECTS = Aladin.chaine.getString("PPSELECTOBJECTS");
        DEFHIGHLIGHTOBJECT = Aladin.chaine.getString("PPDEFHIGHLIGHTOBJECT");
        HIGHLIGHTOBJECT = Aladin.chaine.getString("PPHIGHLIGHTOBJECT");
        DEFSENDPOSITION = Aladin.chaine.getString("PPDEFSENDPOSITION");
        SENDPOSITION = Aladin.chaine.getString("PPSENDPOSITION");
        APPLY = Aladin.chaine.getString("UPAPPLY");
        CLOSE = Aladin.chaine.getString("UPCLOSE");
    }
}

