/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AppMessagingInterface;
import cds.aladin.Plan;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class PlasticWidget
extends JComponent
implements MouseMotionListener,
MouseListener,
KeyListener,
ActionListener {
    static String DISCONNECTED;
    static String CONNECTED_ALONE;
    static String CAN_TRANSMIT;
    static String TRANSMITTING;
    static final Color WAVE_OFF_COLOR;
    static final Color WAVE_ON_COLOR;
    static final int[] TOWER_LINES;
    static final int[] WAVE_LINES;
    static final int W = 23;
    static final int H = 23;
    JPopupMenu popup;
    static String REGISTER;
    static String UNREGISTER;
    static String BROADCAST;
    static String PREFS;
    static String STARTINTERNALHUB;
    static String STOPINTERNALHUB;
    private boolean isConnected = false;
    private boolean isIn = false;
    private JMenuItem registerItem;
    private JMenuItem unregisterItem;
    private JMenuItem broadcastItem;
    private JMenuItem startInternalHubItem;
    private JMenuItem stopInternalHubItem;
    private Aladin aladin;
    private int nbWavesToShow = 0;
    private static int[] waveColBoundaries;
    private static Point waveStartPoint;
    private static int[][] RH;
    private static int[][] RV;
    private static int[][] RB;
    private int state;
    private Thread animationThread;
    private static long sleepTime;

    protected PlasticWidget(Aladin aladin) {
        this.aladin = aladin;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.createChaine();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(23, 23);
    }

    private void createChaine() {
        String string = this.aladin.getMessagingMgr().getProtocolName();
        DISCONNECTED = Aladin.chaine.getString("PWDISCONNECTED").replaceAll("SAMP", string);
        CONNECTED_ALONE = Aladin.chaine.getString("PWCONNECTED").replaceAll("SAMP", string);
        CAN_TRANSMIT = Aladin.chaine.getString("PWCANTRANSMIT").replaceAll("SAMP", string);
        TRANSMITTING = Aladin.chaine.getString("PWTRANSMITTING").replaceAll("SAMP", string);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.popup == null) {
            this.createPopup();
        }
        this.updatePopupStatus();
        this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Aladin.makeCursor(this, 0);
        this.isIn = false;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Aladin.makeCursor(this, 2);
        this.requestFocus();
        Util.toolTip(this, this.getDescription());
        this.aladin.getMessagingMgr().updateState();
        this.isIn = true;
        this.repaint();
    }

    private String getDescription() {
        switch (this.state) {
            case 0: {
                return DISCONNECTED;
            }
            case 1: {
                return DISCONNECTED;
            }
            case 2: {
                return CONNECTED_ALONE;
            }
            case 3: {
                if (this.animationThread != null && this.animationThread.isAlive()) {
                    return TRANSMITTING;
                }
                return CAN_TRANSMIT;
            }
        }
        return "";
    }

    private void createPopup() {
        this.popup = new JPopupMenu();
        String string = this.aladin.getMessagingMgr().getProtocolName();
        REGISTER = Aladin.chaine.getString("PWREGISTER").replaceAll("SAMP", string);
        UNREGISTER = Aladin.chaine.getString("PWUNREGISTER").replaceAll("SAMP", string);
        BROADCAST = Aladin.chaine.getString("PWBROADCAST");
        PREFS = Aladin.chaine.getString("PWPREFS").replaceAll("SAMP", string);
        if (Aladin.BETA) {
            STARTINTERNALHUB = Aladin.chaine.getString("PWSTARTINTERNALHUB");
            STOPINTERNALHUB = Aladin.chaine.getString("PWSTOPINTERNALHUB");
        }
        this.registerItem = new JMenuItem(REGISTER);
        this.popup.add(this.registerItem);
        this.registerItem.addActionListener(this);
        this.unregisterItem = new JMenuItem(UNREGISTER);
        this.popup.add(this.unregisterItem);
        this.unregisterItem.addActionListener(this);
        this.popup.addSeparator();
        if (Aladin.BETA) {
            this.startInternalHubItem = new JMenuItem(STARTINTERNALHUB);
            this.popup.add(this.startInternalHubItem);
            this.startInternalHubItem.addActionListener(this);
            this.stopInternalHubItem = new JMenuItem(STOPINTERNALHUB);
            this.popup.add(this.stopInternalHubItem);
            this.stopInternalHubItem.addActionListener(this);
            this.popup.addSeparator();
        }
        this.broadcastItem = new JMenuItem(BROADCAST);
        this.popup.add(this.broadcastItem);
        this.broadcastItem.addActionListener(this);
        this.popup.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(PREFS);
        this.popup.add(jMenuItem);
        jMenuItem.addActionListener(this);
        this.updatePopupStatus();
        super.add(this.popup);
    }

    protected void showPrefs() {
        this.aladin.plasticPrefs.showPrefs();
        this.aladin.plasticPrefs.toFront();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.drawWidget(graphics);
    }

    private Color getWaveColor(int n) {
        return this.mustBeHighilighted(n) ? WAVE_ON_COLOR : WAVE_OFF_COLOR;
    }

    private boolean mustBeHighilighted(int n) {
        return waveColBoundaries[this.nbWavesToShow] > n;
    }

    private void drawWidget(Graphics graphics) {
        int n;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, 23, 23);
        graphics.setColor(this.isConnected || this.isIn || this.state == 1 ? Color.black : Color.gray);
        for (n = 0; n < RH.length; ++n) {
            graphics.drawLine(RH[n][1] - 2, RH[n][0] + 2, RH[n][2] - 2, RH[n][0] + 2);
        }
        for (n = 0; n < RV.length; ++n) {
            graphics.drawLine(RV[n][0] - 2, RV[n][1] + 2, RV[n][0] - 2, RV[n][2] + 2);
        }
        graphics.setColor(this.isIn ? Aladin.DARKBLUE : Color.white);
        for (n = 0; n < RB.length; ++n) {
            graphics.drawLine(RB[n][1] - 2, RB[n][0] + 2, RB[n][2] - 2, RB[n][0] + 2);
        }
        if (!this.isConnected) {
            Color color = this.isIn ? Color.red.darker() : Color.red.darker().darker();
            graphics.setColor(color);
            graphics.drawLine(16, 15, 22, 21);
            graphics.drawLine(16, 21, 22, 15);
            color = this.isIn ? Color.red : Color.red.darker();
            graphics.setColor(color);
            graphics.drawLine(14, 15, 20, 21);
            graphics.drawLine(15, 15, 21, 21);
            graphics.drawLine(14, 21, 20, 15);
            graphics.drawLine(15, 21, 21, 15);
        } else if (this.state != 2) {
            for (n = 0; n < WAVE_LINES.length; ++n) {
                graphics.setColor(this.getWaveColor(n));
                this.drawWaveLine(n, WAVE_LINES[n], graphics);
                if (!this.mustBeHighilighted(n)) continue;
                this.drawWaveLine(n - 1, WAVE_LINES[n], graphics);
            }
        }
    }

    private void drawWaveLine(int n, int n2, Graphics graphics) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 12; i >= 0; --i) {
            if ((1 << i & n2) != 0) {
                ++n3;
            } else if (n4 != n3) {
                graphics.drawLine(n + PlasticWidget.waveStartPoint.x, n4 + PlasticWidget.waveStartPoint.y, n + PlasticWidget.waveStartPoint.x, n3 - 1 + PlasticWidget.waveStartPoint.y);
                n4 = n3 = n5 + 1;
            } else {
                ++n4;
                ++n3;
            }
            ++n5;
        }
        if (n4 != n3) {
            graphics.drawLine(n + PlasticWidget.waveStartPoint.x, n4 + PlasticWidget.waveStartPoint.y, n + PlasticWidget.waveStartPoint.x, n3 - 1 + PlasticWidget.waveStartPoint.y);
        }
    }

    protected void updateStatus(boolean bl) {
        if (this.isConnected != bl) {
            this.isConnected = bl;
            this.updatePopupStatus();
            this.repaint();
        }
    }

    protected void updateStatus(int n) {
        if (this.state != n) {
            this.state = n;
            this.updatePopupStatus();
            this.repaint();
        }
    }

    private void updatePopupStatus() {
        Object object;
        if (this.popup == null) {
            return;
        }
        AppMessagingInterface appMessagingInterface = this.aladin.getMessagingMgr();
        int n = 0;
        int n2 = 0;
        Plan[] planArray = this.aladin.calque.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            object = planArray[i];
            if (!((Plan)object).selected) continue;
            if (((Plan)object).isSimpleCatalog() && ((Plan)object).flagOk) {
                ++n;
            }
            if (((Plan)object).type == 1 && ((Plan)object).flagOk) {
                ++n2;
            }
            if (((Plan)object).type != 15 || !((Plan)object).flagOk) continue;
            ++n2;
        }
        ArrayList<String> arrayList = appMessagingInterface.getAppsSupporting(AppMessagingInterface.ABSTRACT_MSG_LOAD_FITS);
        object = appMessagingInterface.getAppsSupporting(AppMessagingInterface.ABSTRACT_MSG_LOAD_VOT_FROM_URL);
        this.registerItem.setEnabled(!this.isConnected);
        this.unregisterItem.setEnabled(this.isConnected);
        this.broadcastItem.setEnabled(!(!this.isConnected || n <= 0 && n2 <= 0 || arrayList.size() <= 0 && ((ArrayList)object).size() <= 0));
        if (Aladin.BETA) {
            boolean bl = this.aladin.getMessagingMgr().internalHubRunning();
            this.startInternalHubItem.setEnabled(!bl);
            this.stopInternalHubItem.setEnabled(bl);
        }
    }

    protected void animateWidgetSend() {
        this.animationThread = new Thread("AladinPlasticWidget"){

            @Override
            public void run() {
                int n = waveColBoundaries.length;
                for (int i = 0; i < 2; ++i) {
                    for (int j = 1; j < n && this == PlasticWidget.this.animationThread; ++j) {
                        PlasticWidget.this.nbWavesToShow = j;
                        PlasticWidget.this.repaint();
                        try {
                            Thread.currentThread();
                            Thread.sleep(sleepTime);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                PlasticWidget.this.nbWavesToShow = 0;
                PlasticWidget.this.repaint();
            }
        };
        this.animationThread.start();
    }

    protected void animateWidgetReceive(final boolean bl, final boolean bl2) {
        this.animationThread = new Thread("AladinPlasticWidget"){

            @Override
            public void run() {
                for (int i = 0; i < 4 && this == PlasticWidget.this.animationThread; ++i) {
                    PlasticWidget.this.nbWavesToShow = i % 2 == 0 ? waveColBoundaries.length - 1 : 0;
                    PlasticWidget.this.repaint();
                    try {
                        Thread.currentThread();
                        Thread.sleep(sleepTime);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (bl) {
                    PlasticWidget.this.updateStatus(bl2);
                }
            }
        };
        this.animationThread.start();
    }

    protected void animateWidgetReceive() {
        this.animateWidgetReceive(false, true);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == 'd') {
            boolean bl = !this.aladin.appMessagingMgr.getPlasticTrace();
            this.aladin.appMessagingMgr.setPlasticTrace(bl);
            String string = this.aladin.appMessagingMgr.getProtocolName();
            this.aladin.command.println(bl ? "Activating " + string + " trace" : "Desactivating " + string + " trace");
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!(actionEvent.getSource() instanceof JMenuItem)) {
            return;
        }
        String string = ((JMenuItem)actionEvent.getSource()).getText();
        if (REGISTER.equals(string)) {
            this.aladin.getMessagingMgr().register(false, true);
        } else if (UNREGISTER.equals(string)) {
            if (this.aladin.getMessagingMgr().unregister()) {
                this.aladin.dontReconnectAutomatically = true;
            }
        } else if (BROADCAST.equals(string)) {
            this.aladin.broadcastSelectedPlanes(null);
        } else if (PREFS.equals(string)) {
            this.showPrefs();
        } else if (STARTINTERNALHUB.equals(string)) {
            this.aladin.getMessagingMgr().startInternalHub();
        } else if (STOPINTERNALHUB.equals(string)) {
            this.aladin.getMessagingMgr().stopInternalHub(false);
        }
    }

    static {
        WAVE_OFF_COLOR = new Color(111, 12, 187);
        WAVE_ON_COLOR = Color.red;
        TOWER_LINES = new int[]{64, 224, 64, 224, 64, 224, 160, 224, 496, 160, 496, 496, 336, 1016, 1016, 680, 1820, 1300, 2044, 1820, 3598, 3598, 7175};
        WAVE_LINES = new int[]{160, 64, 272, 224, 520, 272, 224, 1028, 792, 224, 6147, 1548, 496};
        waveColBoundaries = new int[]{0, 2, 4, 7, 10, 13};
        waveStartPoint = new Point(10, 3);
        RH = new int[][]{{0, 3, 4}, {3, 12, 12}, {4, 8, 11}, {5, 9, 11}, {6, 10, 11}, {12, 13, 15}, {17, 2, 3}, {17, 8, 12}, {18, 0, 14}, {19, 0, 14}};
        RV = new int[][]{{3, 1, 4}, {4, 3, 8}, {4, 12, 17}, {5, 1, 1}, {5, 4, 17}, {6, 2, 2}, {6, 5, 17}, {7, 3, 3}, {7, 6, 11}, {7, 15, 17}, {8, 7, 11}, {8, 16, 16}, {9, 8, 11}, {10, 9, 12}, {11, 10, 12}, {11, 7, 7}, {12, 8, 8}, {12, 11, 12}, {13, 9, 9}, {14, 10, 10}, {15, 11, 11}};
        RB = new int[][]{{1, 4, 4}, {2, 4, 5}, {3, 5, 6}, {4, 6, 7}, {5, 7, 8}, {6, 8, 9}, {7, 9, 10}, {8, 10, 11}, {9, 11, 12}, {10, 12, 13}, {11, 13, 14}};
        sleepTime = 500L;
    }
}

