/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Legende;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.Source;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Plot {
    private Aladin aladin;
    private ViewSimple viewSimple;
    private Vector<PlotItem> plotTable = null;
    private Projection plotProj = null;
    private Coord c = new Coord();

    public Plot(ViewSimple viewSimple) {
        this.aladin = viewSimple.aladin;
        this.viewSimple = viewSimple;
    }

    public Projection getProj() {
        return this.plotProj;
    }

    public String getPlotLabel() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 2 && i < this.plotTable.size(); ++i) {
            PlotItem plotItem = this.plotTable.elementAt(i);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" + ");
            }
            Legende legende = plotItem.plan.getFirstLegende();
            stringBuffer.append(plotItem.plan.label + "(" + legende.getName(plotItem.index[0]) + "," + legende.getName(plotItem.index[1]) + ")");
        }
        if (this.plotTable.size() > 2) {
            stringBuffer.append("...");
        }
        return stringBuffer.toString();
    }

    public void free() {
        this.plotTable = null;
        this.plotProj = null;
        this.viewSimple.newView(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Properties.majProp(2);
            }
        });
    }

    private void initPlot() {
        if (this.plotTable == null) {
            this.plotTable = new Vector(10);
        }
        this.plotProj = new Projection(0.0, 0.0, 0.0, 0.0, 500.0, 500.0, 500.0, 500.0, false, false, false, false);
    }

    protected Plot copyIn(ViewSimple viewSimple) {
        Plot plot = new Plot(viewSimple);
        plot.plotProj = this.plotProj;
        plot.plotTable = (Vector)this.plotTable.clone();
        return plot;
    }

    public void rmPlotTable(Plan plan) {
        PlotItem plotItem = this.findPlotTable(plan);
        if (plotItem == null) {
            return;
        }
        this.plotTable.remove(plotItem);
        if (this.plotTable.size() == 0) {
            this.viewSimple.free();
        } else {
            this.viewSimple.newView(1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Properties.majProp(2);
            }
        });
    }

    public void addPlotTable(final Plan plan, int n, int n2, boolean bl) {
        if (this.plotTable == null) {
            this.initPlot();
        }
        if (plan.getLegende().size() > 1) {
            Aladin.warning("Only the first table of this plane\ncan be drawn in a scatter plot.");
        }
        PlotItem plotItem = this.findPlotTable(plan);
        boolean bl2 = true;
        if (plotItem == null) {
            plotItem = new PlotItem();
            this.plotTable.addElement(plotItem);
            bl2 = false;
        }
        plotItem.index[0] = n;
        plotItem.index[1] = n2;
        plotItem.plan = plan;
        Aladin.trace(4, "ViewSimple.addPlotTable: " + (bl2 ? "modify" : "add") + " plan=" + plan.label + " indexX=" + n + " indexY=" + n2);
        if (this.isMainPlot(plotItem)) {
            this.adjustPlot(plotItem);
        }
        this.viewSimple.newView(1);
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Properties.createProperties(plan);
                    Properties.majProp(2);
                }
            });
        }
    }

    private boolean isMainPlot(PlotItem plotItem) {
        return plotItem == this.plotTable.elementAt(0);
    }

    public double[] getXY(Source source) {
        return this.getXY(null, source);
    }

    public double[] getXY(double[] dArray, Source source) {
        if (dArray == null) {
            dArray = new double[2];
        }
        if (Double.isNaN((dArray = this.getValues(dArray, source))[0])) {
            return dArray;
        }
        try {
            this.c.al = dArray[0];
            this.c.del = dArray[1];
            this.plotProj.getXY(this.c);
            dArray[0] = this.c.x;
            dArray[1] = this.c.y;
        }
        catch (Exception exception) {
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
        }
        return dArray;
    }

    public double[] getValues(Source source) {
        return this.getValues(null, source);
    }

    public double[] getValues(double[] dArray, Source source) {
        if (dArray == null) {
            dArray = new double[2];
        }
        try {
            int[] nArray = this.getPlotIndex(source.plan);
            String string = source.getValue(nArray[0]).trim();
            String string2 = source.getValue(nArray[1]).trim();
            dArray[0] = Double.parseDouble(string);
            dArray[1] = Double.parseDouble(string2);
        }
        catch (Exception exception) {
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
        }
        return dArray;
    }

    public void adjustPlot(PlotItem plotItem) {
        try {
            if (plotItem == null) {
                plotItem = this.plotTable.elementAt(0);
            }
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            int n = 0;
            boolean bl = true;
            Iterator<Obj> iterator = plotItem.plan.iterator();
            double[] dArray = null;
            while (iterator.hasNext()) {
                Source source;
                Obj obj = iterator.next();
                if (!(obj instanceof Source) || Double.isNaN((dArray = this.getValues(dArray, source = (Source)obj))[0]) || Double.isNaN(dArray[1])) continue;
                double d9 = dArray[0];
                double d10 = dArray[1];
                ++n;
                if (bl) {
                    d6 = d5 = d9;
                    d7 = d5;
                    d8 = d5;
                    d2 = d = d10;
                    d3 = d;
                    d4 = d;
                    bl = false;
                }
                if (d6 > d9) {
                    d6 = d9;
                } else if (d8 < d9) {
                    d8 = d9;
                }
                if (d9 < d5 && d9 > d6 || d5 == d6 && d9 < d7) {
                    d5 = d9;
                } else if (d9 > d7 && d9 < d8 || d7 == d8 && d9 > d5) {
                    d7 = d9;
                }
                if (d2 > d10) {
                    d2 = d10;
                } else if (d4 < d10) {
                    d4 = d10;
                }
                if (d10 < d && d10 > d2 || d == d2 && d10 < d3) {
                    d = d10;
                    continue;
                }
                if (!(d10 > d3 && d10 < d4) && (d3 != d4 || !(d10 > d))) continue;
                d3 = d10;
            }
            d5 = d6;
            d7 = d8;
            d = d2;
            d3 = d4;
            Aladin.trace(4, "ViewSimple.adjustPlot: nsrc=" + n + " X=[" + d6 + " (" + d5 + ") .. (" + d7 + ") " + d8 + "] Y=[" + d2 + " (" + d + ") .. (" + d3 + ") " + d4 + "]");
            int n2 = this.viewSimple.getWidth();
            int n3 = this.viewSimple.getHeight();
            this.plotProj = new Projection(d5, d, 0.0, 0.0, d7 - d5, d3 - d, (double)n2, (double)n3, this.plotProj.isFlipXPlot(), this.plotProj.isFlipYPlot(), this.plotProj.isLogXPlot(), this.plotProj.isLogYPlot());
            this.viewSimple.newView(1);
            this.viewSimple.setZoomRaDec(1.0, (d5 + d7) / 2.0, (d + d3) / 2.0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int nbRound(double d) {
        int n;
        if (d == 0.0) {
            return 0;
        }
        if ((d = Math.abs(d)) > 1.0) {
            return 0;
        }
        for (n = 0; d < 1.0 && n < 10; d *= 10.0, ++n) {
        }
        return n;
    }

    private double getIncr(double d, int n, int n2, int n3) {
        double d2 = n == 0 ? this.plotProj.getFctXPlot() : this.plotProj.getFctYPlot();
        double d3 = d * d2 * this.viewSimple.getZoom();
        if (n3 > 20) {
            return 0.0;
        }
        if (d3 >= 50.0 && d3 <= 200.0) {
            return d;
        }
        if (d3 < 50.0) {
            if (n2 == -1) {
                return d * 2.0;
            }
            return this.getIncr(d * 10.0, n, 1, ++n3);
        }
        if (n2 == 1) {
            return d / 2.0;
        }
        return this.getIncr(d / 10.0, n, -1, ++n3);
    }

    private double getIncrX() {
        return this.getIncr(1.0, 0, 0, 0);
    }

    private double getIncrY() {
        return this.getIncr(1.0, 1, 0, 0);
    }

    public void drawPlotGrid(Graphics graphics, int n, int n2) {
        try {
            String string;
            Point point;
            int n3;
            double d;
            double d2 = this.plotProj.isLogXPlot() ? 1.0E-10 : this.getIncrX();
            double d3 = d = this.plotProj.isLogYPlot() ? 1.0E-10 : this.getIncrY();
            if (d2 == 0.0 || d == 0.0) {
                return;
            }
            int n4 = this.viewSimple.getWidth();
            int n5 = this.viewSimple.getHeight();
            Coord coord = new Coord();
            PointD pointD = this.viewSimple.getPosition(0.0, 0.0);
            coord.x = pointD.x;
            coord.y = pointD.y;
            this.plotProj.getCoord(coord);
            Coord coord2 = new Coord();
            pointD = this.viewSimple.getPosition((double)n4, (double)n5);
            coord2.x = pointD.x;
            coord2.y = pointD.y;
            this.plotProj.getCoord(coord2);
            double d4 = this.plotProj.isLogXPlot() ? 0.0 : (double)((int)(coord.al / d2)) * d2;
            double d5 = this.plotProj.isLogYPlot() ? 0.0 : (double)((int)(coord.del / d)) * d;
            int n6 = this.nbRound(d2);
            int n7 = this.nbRound(d);
            Coord coord3 = new Coord();
            coord3.del = this.plotProj.isLogYPlot() ? 0.1 : d5;
            coord3.al = d4;
            for (n3 = -10; n3 < 10; ++n3) {
                this.plotProj.getXY(coord3);
                point = this.viewSimple.getViewCoord(coord3.x, coord3.y);
                if (point != null) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(point.x + n, 0 + n2, point.x + n, n5 + n2);
                    graphics.setColor(Color.black);
                    string = this.plotProj.isLogXPlot() ? (n3 < 0 ? "1e" + n3 : (n3 == 0 ? "1" : "1e+" + n3)) : coord3.al + "";
                    graphics.drawString(Util.myRound(string, n6), point.x + 2 + n, n5 - 5 + n2);
                }
                if (this.plotProj.isLogXPlot()) {
                    d2 *= 10.0;
                }
                coord3.al += d2;
            }
            coord3.al = this.plotProj.isLogXPlot() ? 0.1 : d4;
            coord3.del = d5;
            for (n3 = -10; n3 < 10; ++n3) {
                this.plotProj.getXY(coord3);
                point = this.viewSimple.getViewCoord(coord3.x, coord3.y);
                if (point != null) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(0 + n, point.y + n2, n4 + n, point.y + n2);
                    graphics.setColor(Color.black);
                    string = this.plotProj.isLogYPlot() ? (n3 < 0 ? "1e" + n3 : (n3 == 0 ? "1" : "1e+" + n3)) : coord3.del + "";
                    graphics.drawString(Util.myRound(string, n7), 4 + n, point.y - 5 + n2);
                }
                if (this.plotProj.isLogYPlot()) {
                    d *= 10.0;
                }
                coord3.del = coord3.del + (this.plotProj.isLogYPlot() ? d : -d);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int[] getPlotIndex(Plan plan) {
        PlotItem plotItem = this.findPlotTable(plan);
        return plotItem.index;
    }

    private PlotItem findPlotTable(Plan plan) {
        Enumeration<PlotItem> enumeration = this.plotTable.elements();
        while (enumeration.hasMoreElements()) {
            PlotItem plotItem = enumeration.nextElement();
            if (plotItem.plan != plan) continue;
            return plotItem;
        }
        return null;
    }

    public JPanel getPlotControlPanelForPlan(Plan plan) {
        PlotItem plotItem = this.findPlotTable(plan);
        if (plotItem == null) {
            return null;
        }
        return this.getPlotControlPanelForOneTable(plotItem);
    }

    private JPanel getPlotControlPanelForOneTable(PlotItem plotItem) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)this.getPlotControlPanelForOneIndex(plotItem, 0), "North");
        jPanel.add((Component)this.getPlotControlPanelForOneIndex(plotItem, 1), "Center");
        jPanel.add((Component)this.getPlotButtonPanel(plotItem), "South");
        return jPanel;
    }

    private JPanel getPlotButtonPanel(final PlotItem plotItem) {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("zoom all");
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Plot.this.adjustPlot(plotItem);
                Plot.this.viewSimple.repaint();
            }
        });
        jPanel.add(jButton);
        jButton = new JButton("delete");
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Plot.this.rmPlotTable(plotItem.plan);
                Plot.this.viewSimple.repaint();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel getPlotControlPanelForOneIndex(final PlotItem plotItem, final int n) {
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(n == 0 ? "X: " : "Y: "));
        final Plan plan = plotItem.plan;
        final JComboBox jComboBox = plan.getFirstLegende().createCombo();
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlotItem plotItem = Plot.this.findPlotTable(plan);
                int n2 = jComboBox.getSelectedIndex();
                if (n2 == plotItem.index[n]) {
                    return;
                }
                plotItem.index[n] = n2;
                Plot.this.adjustPlot(plotItem);
                Plot.this.viewSimple.repaint();
            }
        });
        jComboBox.setSelectedIndex(plotItem.index[n]);
        jPanel.add(jComboBox);
        final JCheckBox jCheckBox = new JCheckBox("Flip");
        jCheckBox.setSelected(n == 0 ? this.plotProj.isFlipXPlot() : this.plotProj.isFlipYPlot());
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Plot.this.aladin;
                Aladin.trace(4, "Plot.getPlotControlPanelForOneIndex: flipPlot(" + n + " => " + jCheckBox.isSelected());
                Plot.this.plotProj.flipPlot(n, jCheckBox.isSelected());
                Plot.this.adjustPlot(plotItem);
                Plot.this.viewSimple.repaint();
            }
        });
        jPanel.add(jCheckBox);
        final JCheckBox jCheckBox2 = new JCheckBox("Log");
        jCheckBox2.setSelected(n == 0 ? this.plotProj.isLogXPlot() : this.plotProj.isLogYPlot());
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Plot.this.aladin;
                Aladin.trace(4, "Plot.getPlotControlPanelForOneIndex: flipLog(" + n + " => " + jCheckBox2.isSelected());
                Plot.this.plotProj.logPlot(n, jCheckBox2.isSelected());
                Plot.this.adjustPlot(plotItem);
                Plot.this.viewSimple.repaint();
            }
        });
        jPanel.add(jCheckBox2);
        return jPanel;
    }

    private class PlotItem {
        Plan plan;
        int[] index = new int[2];

        private PlotItem() {
        }
    }
}

