/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinException;
import cds.aladin.AladinPlugin;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PluginDescription
extends JPanel {
    private static String AUTHOR;
    private static String VERSION;
    private static String CAT;
    private static String ORIGIN;
    private static String STATE;
    private static String SCRIPT;
    private static String NOSUPPORT;
    private static String SCRIPTHELP;
    private static String THREAD;
    private static String RUNNING;
    private static String ACTIVE;
    private static String SUSPENDED;
    private static String IDLE;
    private static String START;
    private static String STOP;
    private static String SUSPEND;
    private static String RESUME;
    private Aladin aladin;
    private AladinPlugin ap;
    private JLabel name;
    private JLabel author;
    private JLabel version;
    private JLabel cat;
    private JLabel state;
    private JLabel script;
    private JLabel thread;
    private JLabel url;
    private JTextArea descr;
    private JButton start;
    private JButton stop;
    private JButton suspend;
    private JButton resume;
    private JButton help;
    private static final Dimension DIM;

    protected PluginDescription(Aladin aladin) {
        this.aladin = aladin;
        AUTHOR = "Author";
        VERSION = "Version";
        CAT = "Category";
        STATE = "State";
        ORIGIN = "Origin";
        SCRIPT = "Scripting";
        SCRIPTHELP = "Script usage?";
        NOSUPPORT = "Not supported";
        THREAD = "Threaded";
        RUNNING = "running";
        ACTIVE = "active";
        IDLE = "idle";
        START = "Start";
        STOP = "Stop";
        SUSPEND = "Suspend";
        SUSPENDED = "Sleeping";
        RESUME = "Resume";
        this.createPanel();
    }

    private String getInfo(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        return string;
    }

    private void createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
        gridBagConstraints.anchor = 17;
        Insets insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.bottom += 5;
        JLabel jLabel = this.name = new JLabel();
        jPanel.add((Component)this.name, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(3, jLabel.getFont().getSize2D() + 2.0f));
        jLabel.setForeground(Aladin.GREEN);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.bottom -= 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(AUTHOR + " : ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        ++gridBagConstraints.gridx;
        jLabel = this.author = new JLabel();
        jPanel.add((Component)this.author, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(VERSION + " : ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        ++gridBagConstraints.gridx;
        jLabel = this.version = new JLabel();
        jPanel.add((Component)this.version, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(CAT + " : ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        ++gridBagConstraints.gridx;
        jLabel = this.cat = new JLabel();
        jPanel.add((Component)this.cat, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(ORIGIN + " : ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        ++gridBagConstraints.gridx;
        jLabel = this.url = new JLabel();
        jPanel.add((Component)this.url, gridBagConstraints);
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (((JLabel)mouseEvent.getSource()).getToolTipText() == null) {
                    return;
                }
                ((PluginDescription)PluginDescription.this).aladin.glu.showDocument("Http", ((JLabel)mouseEvent.getSource()).getToolTipText(), true);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (((JLabel)mouseEvent.getSource()).getToolTipText() == null) {
                    return;
                }
                PluginDescription.this.url.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (((JLabel)mouseEvent.getSource()).getToolTipText() == null) {
                    return;
                }
                PluginDescription.this.url.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (((JLabel)mouseEvent.getSource()).getToolTipText() == null) {
                    return;
                }
                PluginDescription.this.url.setForeground(new Color(128, 0, 128));
            }
        });
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.top += 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        JTextArea jTextArea = this.descr = new JTextArea();
        jPanel.add((Component)new JScrollPane(this.descr), gridBagConstraints);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top -= 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(SCRIPT + " : ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        ++gridBagConstraints.gridx;
        jLabel = this.script = new JLabel();
        jPanel.add((Component)this.script, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(THREAD + " : ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        ++gridBagConstraints.gridx;
        jLabel = this.thread = new JLabel();
        jPanel.add((Component)this.thread, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(STATE + " : ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        ++gridBagConstraints.gridx;
        this.state = jLabel = new JLabel();
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)jPanel, "Center");
        jPanel = new JPanel();
        JButton jButton = this.help = new JButton(SCRIPTHELP);
        jPanel.add(this.help);
        jButton.setMargin(insets);
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PluginDescription.this.ap.scriptHelp() == null) {
                    return;
                }
                ((PluginDescription)PluginDescription.this).aladin.command.execHelpCmd(PluginDescription.this.ap.scriptHelp());
                ((PluginDescription)PluginDescription.this).aladin.f.toFront();
            }
        });
        this.start = jButton = new JButton(START);
        jPanel.add(jButton);
        jButton.setEnabled(false);
        jButton.setMargin(insets);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PluginDescription.this.ap.start();
                }
                catch (AladinException aladinException) {
                    aladinException.printStackTrace();
                    PluginDescription.this.aladin;
                    Aladin aladin = PluginDescription.this.aladin;
                    StringBuilder stringBuilder = new StringBuilder();
                    PluginDescription.this.aladin;
                    Aladin.warning(aladin, stringBuilder.append(Aladin.chaine.getString("PLUGERROR")).append("\n\n").append(aladinException.getMessage()).toString());
                }
                Util.pause(100);
                PluginDescription.this.resume();
            }
        });
        this.stop = jButton = new JButton(STOP);
        jPanel.add(jButton);
        jButton.setEnabled(false);
        jButton.setMargin(insets);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginDescription.this.ap.stop();
                Util.pause(100);
                PluginDescription.this.resume();
            }
        });
        this.suspend = jButton = new JButton(SUSPEND);
        jPanel.add(jButton);
        jButton.setEnabled(false);
        jButton.setMargin(insets);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginDescription.this.ap.suspend();
                Util.pause(100);
                PluginDescription.this.resume();
            }
        });
        this.resume = jButton = new JButton(RESUME);
        jPanel.add(jButton);
        jButton.setEnabled(false);
        jButton.setMargin(insets);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginDescription.this.ap.resume();
                Util.pause(100);
                PluginDescription.this.resume();
            }
        });
        this.add((Component)jPanel, "South");
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    public Dimension getPreferredSize() {
        return DIM;
    }

    protected void setPlugin(AladinPlugin aladinPlugin) {
        this.ap = aladinPlugin;
        this.name.setText(aladinPlugin == null ? "" : this.getInfo(aladinPlugin.menu()));
        this.author.setText(aladinPlugin == null ? "" : this.getInfo(aladinPlugin.author()));
        this.version.setText(aladinPlugin == null ? "" : this.getInfo(aladinPlugin.version()));
        this.descr.setText(aladinPlugin == null ? "" : this.getInfo(aladinPlugin.description()));
        this.script.setText(aladinPlugin == null ? "" : (aladinPlugin.scriptCommand() == null ? NOSUPPORT : aladinPlugin.scriptCommand()) + "   ");
        if (aladinPlugin != null) {
            this.script.setFont(this.script.getFont().deriveFont(aladinPlugin.scriptCommand() == null ? 0 : 1));
        }
        this.thread.setText(aladinPlugin == null ? "" : (aladinPlugin.inSeparatedThread() ? "true" : "false"));
        this.cat.setText(aladinPlugin == null ? "" : this.getInfo(aladinPlugin.category()));
        this.help.setEnabled(aladinPlugin == null ? false : aladinPlugin.scriptHelp() != null);
        this.url.setText(aladinPlugin == null ? "" : this.getInfo(aladinPlugin.url()));
        if (aladinPlugin == null) {
            this.url.setText("");
        } else if (aladinPlugin.url() != null) {
            this.url.setForeground(Color.blue);
            Util.toolTip(this.url, aladinPlugin.url());
            this.url.setText(PluginDescription.cut(aladinPlugin.url(), 60));
        } else {
            Util.toolTip(this.url, null);
        }
        this.resume();
    }

    protected void resume() {
        boolean bl;
        if (this.ap == null) {
            this.state.setText("");
            this.start.setEnabled(false);
            this.stop.setEnabled(false);
            this.resume.setEnabled(false);
            this.suspend.setEnabled(false);
            return;
        }
        boolean bl2 = this.ap.inSeparatedThread();
        boolean bl3 = bl = this.ap.isSuspended();
        this.state.setText(bl ? SUSPENDED : (!(bl3 = this.ap.isRunning()) ? IDLE : (bl2 ? RUNNING : ACTIVE)));
        this.state.setForeground(bl ? Color.orange : (bl3 ? Color.red : Aladin.GREEN));
        this.start.setEnabled(!bl3);
        this.stop.setEnabled(bl3);
        this.resume.setEnabled(bl2 && bl3 && bl);
        this.suspend.setEnabled(bl2 && bl3 && !bl);
    }

    static String cut(String string, int n) {
        int n2 = string.length();
        if (n2 <= n) {
            return string;
        }
        return string.substring(0, n - 2) + "...";
    }

    static {
        DIM = new Dimension(400, 400);
    }
}

