/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinException;
import cds.aladin.AladinPlugin;
import cds.aladin.PluginDescription;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class Plugins
extends ClassLoader
implements Runnable,
ListModel,
Comparator,
DropTargetListener,
DragSourceListener,
DragGestureListener {
    private Aladin aladin;
    protected Vector plugs;
    private boolean flagErrorDir = false;
    private static char FS = Util.FS.charAt(0);
    static JFrame controleur = null;
    private PluginDescription plugDesc;
    private JButton removePlug;
    private JList listPlugs;
    private Thread thread = null;
    private ListDataListener listListener;

    public Plugins(Aladin aladin) {
        this.aladin = aladin;
        this.plugs = new Vector();
        this.scanDir(this.getPlugPath());
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDropEvent.acceptDrop(3);
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : list) {
                    this.copyInPlug(file);
                }
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
            this.reload();
        }
        catch (Exception exception) {
            dropTargetDropEvent.rejectDrop();
        }
    }

    private void copyInPlug(File file) throws Exception {
        int n;
        String string = file.getName();
        File file2 = new File(this.getPlugPath() + FS + string);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        RandomAccessFile randomAccessFile2 = new RandomAccessFile(file2, "rw");
        byte[] byArray = new byte[512];
        for (long i = randomAccessFile.length(); i > 0L; i -= (long)n) {
            n = randomAccessFile.read(byArray);
            randomAccessFile2.write(byArray, 0, n);
        }
        randomAccessFile.close();
        randomAccessFile2.close();
    }

    private void scanDir(String string) {
        try {
            this.addInClassPath(string);
            this.scan(new File(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void addInClassPath(String string) throws Exception {
        URL uRL = new File(string).toURL();
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)uRLClassLoader, uRL);
    }

    protected String getPlugPath() {
        String string;
        block3: {
            string = System.getProperty("user.home") + FS + Aladin.CACHE + FS + "Plugins";
            try {
                File file = new File(string);
                if (!file.isDirectory() && !file.mkdir()) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                this.flagErrorDir = true;
                if (Aladin.levelTrace < 3) break block3;
                exception.printStackTrace();
            }
        }
        return string;
    }

    protected void showFrame() {
        if (controleur == null) {
            controleur = new JFrame(Aladin.chaine.getString("PLUGINFO"));
            Aladin.setIcon(controleur);
            controleur.setLocation(50, 100);
            controleur.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    controleur.setVisible(false);
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout(5, 5));
            controleur.getContentPane().add(jPanel);
            this.listPlugs = new JList(this);
            this.listPlugs.setVisibleRowCount(10);
            this.listPlugs.setFixedCellWidth(200);
            this.listPlugs.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    Plugins.this.selectionne();
                }
            });
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JTextArea jTextArea = new JTextArea(Aladin.chaine.getString("PLUGWARNING"));
            jPanel2.add((Component)jTextArea, "North");
            jTextArea.setWrapStyleWord(true);
            jTextArea.setLineWrap(true);
            jTextArea.setEditable(false);
            jTextArea.setFont(jTextArea.getFont().deriveFont(2));
            jTextArea.setBackground(controleur.getContentPane().getBackground());
            JPanel jPanel3 = new JPanel();
            jPanel3.add(new JLabel(Aladin.chaine.getString("PLUGLOC")));
            JTextField jTextField = new JTextField(this.getPlugPath(), 35);
            jPanel3.add(jTextField);
            jTextField.setEditable(false);
            JButton jButton = new JButton(Aladin.chaine.getString("PLUGRELOAD"));
            jPanel3.add(jButton);
            jButton.setToolTipText(Aladin.chaine.getString("PLUGRELOADTIP"));
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setFont(jButton.getFont().deriveFont(0));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Plugins.this.reload();
                }
            });
            jPanel2.add((Component)jPanel3, "South");
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)new JScrollPane(this.listPlugs), "West");
            this.plugDesc = new PluginDescription(this.aladin);
            jPanel.add((Component)this.plugDesc, "Center");
            jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jButton = new JButton(Aladin.chaine.getString("PLUGDOWNLOAD"));
            jPanel2.add(jButton);
            jButton.setToolTipText(Aladin.chaine.getString("PLUGDOWNLOADTIP"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((Plugins)Plugins.this).aladin.glu.showDocument("Http", "http://aladin.u-strasbg.fr/java/nph-aladin.pl?frame=plugRep", true);
                }
            });
            jButton = new JButton(Aladin.chaine.getString("PLUGUPLOAD"));
            jPanel2.add(jButton);
            jButton.setToolTipText(Aladin.chaine.getString("PLUGUPLOADTIP"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((Plugins)Plugins.this).aladin.glu.showDocument("mailto:plugin@aladin.u-strasbg.fr?Subject=Aladin plugin&Body=%0A%0ADear Aladin team,%0A%0AYou will find, joined to this mail, my Aladin plugin source code%0A%0ABy this letter, I certify that this code does not content any spyware or other  malicious code. I certify the content of the author lists and other descriptions in the source code.%0A%0ABy this letter, I accept that the CDS team compiles this plugin and distributes the resulting compiled code [with/without] the source version.%0A%0A[***DO NOT FORGET TO ATTACH YOUR PLUGIN SOURCE CODE ***]");
                }
            });
            jButton = new JButton(Aladin.chaine.getString("PLUGADD"));
            jPanel2.add(jButton);
            jButton.setToolTipText(Aladin.chaine.getString("PLUGADDTIP"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Plugins.this.addPlugin();
                }
            });
            jButton = this.removePlug = new JButton(Aladin.chaine.getString("PLUGREMOVE"));
            jPanel2.add(this.removePlug);
            jButton.setToolTipText(Aladin.chaine.getString("PLUGREMOVETIP"));
            jButton.setEnabled(false);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Plugins.this.removePlugin();
                }
            });
            jButton = new JButton(Aladin.chaine.getString("PLUGMOREINFO"));
            jPanel2.add(jButton);
            jButton.setToolTipText(Aladin.chaine.getString("PLUGMOREINFOTIP"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((Plugins)Plugins.this).aladin.glu.showDocument("Http", "http://aladin.u-strasbg.fr/java/nph-aladin.pl?frame=plugins", true);
                }
            });
            jButton = new JButton(Aladin.chaine.getString("CLOSE"));
            jPanel2.add(jButton);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    controleur.setVisible(false);
                }
            });
            jPanel.add((Component)jPanel2, "South");
            new DropTarget(this.listPlugs, this);
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.listPlugs, 3, this);
            this.aladin.log("PluginControl", this.getSize() + " plugin" + (this.getSize() > 1 ? "s" : ""));
        }
        controleur.pack();
        controleur.setVisible(true);
        if (this.thread == null) {
            this.setThread(new Thread((Runnable)this, "AladinPluginControl")).start();
        }
    }

    @Override
    public void run() {
        Util.pause(1000);
        while (controleur != null && controleur.isVisible()) {
            this.plugDesc.resume();
            Util.pause(1000);
        }
        this.setThread(null);
    }

    private synchronized Thread setThread(Thread thread) {
        this.thread = thread;
        return this.thread;
    }

    private void selectionne() {
        String string = (String)this.listPlugs.getSelectedValue();
        AladinPlugin aladinPlugin = this.find(string);
        this.plugDesc.setPlugin(aladinPlugin);
        this.removePlug.setEnabled(this.listPlugs.getSelectedValue() != null);
    }

    private void removePlugin() {
        if (!Aladin.confirmation(controleur, Aladin.chaine.getString("PLUGCONF"))) {
            return;
        }
        Object[] objectArray = this.listPlugs.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                AladinPlugin aladinPlugin = this.find((String)objectArray[i]);
                String string = aladinPlugin.getClass().getName();
                File file = new File(this.getPlugPath() + FS + string + ".class");
                boolean bl = file.delete();
                if (!bl) {
                    int n = string.indexOf(46);
                    if (n > 0) {
                        string = string.substring(n + 1);
                    }
                    file = new File(this.getPlugPath() + FS + string + ".jar");
                    bl = file.delete();
                }
                if (bl) {
                    Aladin.trace(3, "Remove " + file.getCanonicalPath());
                    continue;
                }
                Aladin.warning("Cannot arrive to remove [" + file.getCanonicalPath() + "]");
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.reload();
    }

    private void addPlugin() {
        try {
            FileDialog fileDialog = new FileDialog((Frame)controleur, "Plugin");
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null) {
                return;
            }
            File file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            this.copyInPlug(file);
            Aladin.trace(3, "Copy " + file.getCanonicalPath());
            this.reload();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void reload() {
        if (this.flagErrorDir) {
            Aladin.warning(controleur, "No access to the Aladin plugin directory !");
            return;
        }
        this.plugDesc.setPlugin(null);
        this.plugs.clear();
        this.scanDir(this.getPlugPath());
        this.listListener.contentsChanged(new ListDataEvent(this, 0, 0, this.plugs.size()));
        if (this.plugs.size() > 0) {
            this.listPlugs.setSelectedIndex(0);
            this.selectionne();
        }
        this.aladin.pluginReload();
    }

    private void scan(File file) {
        Aladin.trace(3, "Scanning plugs in [" + file + "]");
        this.scan(file, 0);
        Collections.sort(this.plugs, this);
    }

    public int compare(Object object, Object object2) {
        int n;
        AladinPlugin aladinPlugin = (AladinPlugin)object;
        AladinPlugin aladinPlugin2 = (AladinPlugin)object2;
        int n2 = aladinPlugin.category() == null ? 0 : 1;
        int n3 = n = aladinPlugin2.category() == null ? 0 : 1;
        if (n2 == n) {
            return aladinPlugin.menu().compareTo(aladinPlugin2.menu());
        }
        return n - n2;
    }

    private void scan(File file, int n) {
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.scan(fileArray[i], n + 1);
                continue;
            }
            String string = fileArray[i].getAbsolutePath();
            if (string.endsWith(".jar")) {
                this.scanJar(string);
                continue;
            }
            if (!string.endsWith(".class") || string.indexOf(36) >= 0) continue;
            int n2 = string.length() + 1;
            for (int j = n; j >= 0; --j) {
                n2 = string.lastIndexOf(FS, n2 - 1);
            }
            String string2 = string.substring(n2 >= 0 ? n2 + 1 : 0, string.length() - 6).replace(FS, '.');
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                this.tryToAdd(string2, clazz);
                continue;
            }
            catch (Throwable throwable) {
                System.err.println("Cannot load plugin " + string + "\n ==> " + throwable.getMessage());
            }
        }
    }

    private boolean testVersion(AladinPlugin aladinPlugin) {
        String string = aladinPlugin.version();
        if (string == null) {
            return true;
        }
        int n = Util.indexOfIgnoreCase(string, "Aladin v", 0);
        if (n < 0) {
            return true;
        }
        return !(this.aladin.realNumVersion("v9.033a") < this.aladin.realNumVersion(string.substring(n + 7)));
    }

    private boolean tryToAdd(String string, Class clazz) throws Throwable {
        if (!string.equals("cds.aladin.AladinPlugin") && AladinPlugin.class.isAssignableFrom(clazz)) {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            AladinPlugin aladinPlugin = (AladinPlugin)constructor.newInstance(new Object[0]);
            if (!this.testVersion(aladinPlugin)) {
                throw new Exception("Too old Aladin version for this plugin [" + aladinPlugin.menu() + "=> " + aladinPlugin.version() + "]");
            }
            aladinPlugin.setAladin(this.aladin);
            if (this.find(aladinPlugin.menu()) != null) {
                throw new Exception("Duplicated plugin [" + aladinPlugin.menu() + "]");
            }
            Aladin.trace(3, "Plugin [" + string + "] loaded => " + aladinPlugin.menu());
            this.plugs.add(aladinPlugin);
            return true;
        }
        return false;
    }

    private void scanJar(String string) {
        boolean bl = false;
        try {
            this.addInClassPath(string);
            ZipFile zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (!string2.endsWith(".class") || string2.indexOf(36) >= 0) continue;
                string2 = string2.substring(0, string2.length() - 6);
                string2 = string2.replace('/', '.');
                try {
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                    bl = bl || this.tryToAdd(string2, clazz);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    System.err.println("Cannot load plugin " + string2 + "\n ==> " + throwable.getMessage());
                }
            }
            zipFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected String[] getNames() {
        String[] stringArray = new String[this.plugs.size()];
        Enumeration enumeration = this.plugs.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            AladinPlugin aladinPlugin = (AladinPlugin)enumeration.nextElement();
            stringArray[n] = (aladinPlugin.category() != null ? aladinPlugin.category() + "/" : "") + aladinPlugin.menu();
            ++n;
        }
        return stringArray;
    }

    protected AladinPlugin find(String string) {
        Enumeration enumeration = this.plugs.elements();
        while (enumeration.hasMoreElements()) {
            AladinPlugin aladinPlugin = (AladinPlugin)enumeration.nextElement();
            if (!aladinPlugin.menu().equals(string)) continue;
            return aladinPlugin;
        }
        return null;
    }

    protected AladinPlugin findScript(String string) {
        Enumeration enumeration = this.plugs.elements();
        while (enumeration.hasMoreElements()) {
            AladinPlugin aladinPlugin = (AladinPlugin)enumeration.nextElement();
            String string2 = aladinPlugin.scriptCommand();
            if (string2 == null || !string2.equals(string)) continue;
            return aladinPlugin;
        }
        return null;
    }

    protected boolean execPlugin(String string) throws AladinException {
        AladinPlugin aladinPlugin = this.find(string);
        if (aladinPlugin == null) {
            return false;
        }
        boolean bl = aladinPlugin.inSeparatedThread();
        Aladin.trace(1, "Exec plugin " + (bl ? "asynchroneously " : "") + " [" + string + "]...");
        if (bl) {
            aladinPlugin.start();
        } else {
            aladinPlugin.exec();
        }
        return true;
    }

    protected String execPluginByScript(String string, String[] stringArray) {
        AladinPlugin aladinPlugin = this.findScript(string);
        if (aladinPlugin == null) {
            return "Plugin " + string + " not found";
        }
        Aladin.trace(1, "Exec plugin by script [" + string + "]...");
        return aladinPlugin.execScriptCommand(stringArray);
    }

    protected void cleanup() {
        Enumeration enumeration = this.plugs.elements();
        while (enumeration.hasMoreElements()) {
            AladinPlugin aladinPlugin = (AladinPlugin)enumeration.nextElement();
            try {
                aladinPlugin.cleanup();
            }
            catch (Exception exception) {}
        }
    }

    protected boolean isSync() {
        Enumeration enumeration = this.plugs.elements();
        while (enumeration.hasMoreElements()) {
            AladinPlugin aladinPlugin = (AladinPlugin)enumeration.nextElement();
            if (!aladinPlugin.hasBeenStarted() || aladinPlugin.isSync()) continue;
            return false;
        }
        return true;
    }

    public Object getElementAt(int n) {
        return ((AladinPlugin)this.plugs.elementAt(n)).menu();
    }

    @Override
    public int getSize() {
        return this.plugs.size();
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listListener = listDataListener;
    }
}

