/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Hist;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanTool;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.SourceStat;
import cds.aladin.View;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import healpix.essentials.FastMath;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.OutputStream;

public class Position
extends Obj {
    static final int DS = 4;
    static final int DDS = 8;
    static final int HF = Aladin.SSIZE;
    static final Font DF = Aladin.SBOLD;
    protected double x;
    protected double y;
    protected double[] xv;
    protected double[] yv;
    static double minx;
    static double maxx;
    static double miny;
    static double maxy;
    static double posx;
    static double posy;
    static double total;
    static double carre;
    static int nombre;
    static double surface;
    static double moyenne;
    static double variance;
    static double sigma;
    static double minimum;
    static double maximum;
    static double mediane;
    static final int MAXMEDIANE = 10000;
    static int medianeArrayNb;
    static double[] medianeArray;
    static final int STATDY = 13;
    static final int HAUTSTAT = 117;
    static final int LARGSTAT = 120;

    protected void createCacheXYVP() {
        this.createCacheXYVP(this.plan == null ? 16 : this.plan.aladin.view.getNbView());
    }

    protected void createCacheXYVP(int n) {
        if (n == 0) {
            return;
        }
        this.xv = new double[n];
        this.yv = new double[n];
    }

    public Position() {
    }

    protected Position(Plan plan) {
        this.plan = plan;
        this.createCacheXYVP();
    }

    protected Position(Plan plan, ViewSimple viewSimple, double d, double d2, double d3, double d4, int n, String string) {
        this.id = string;
        this.plan = plan;
        this.createCacheXYVP();
        if ((n & 1) != 0) {
            if (viewSimple != null) {
                this.xv[viewSimple.n] = d;
                this.yv[viewSimple.n] = d2;
            }
            if (viewSimple == null || viewSimple.pref == null || !Projection.isOk(viewSimple.getProj())) {
                this.x = d;
                this.y = viewSimple == null ? d2 : (double)viewSimple.getPRefDimension().height - d2;
            } else if ((n & 4) != 0) {
                this.setCoord(viewSimple);
            }
        }
        if ((n & 2) != 0) {
            this.raj = d3;
            this.dej = d4;
            if ((n & 8) != 0) {
                try {
                    this.projection(viewSimple);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected Position(Plan plan, String string) {
        this.id = string;
        this.plan = plan;
        this.createCacheXYVP();
    }

    public String getLocalisation() {
        String string = this.plan.aladin.localisation.getLocalisation(this);
        if (string == null) {
            return "null,null";
        }
        string = string.replace(' ', ',');
        return string;
    }

    protected void syncPos(ViewSimple viewSimple, ViewSimple viewSimple2) {
        this.xv[viewSimple2.n] = this.xv[viewSimple.n];
        this.yv[viewSimple2.n] = this.yv[viewSimple.n];
    }

    protected final void setVisible(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    protected final boolean isVisible() {
        return (this.flags & 4) != 0;
    }

    protected final void setWithLabel(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 8) : (byte)(this.flags & 0xFFFFFFF7);
    }

    protected final void setWithStat(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 0x20) : (byte)(this.flags & 0xFFFFFFDF);
    }

    protected final void setLocked(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 0x40) : (byte)(this.flags & 0xFFFFFFBF);
    }

    protected final boolean isWithLabel() {
        return (this.flags & 8) != 0;
    }

    protected final boolean isWithStat() {
        return (this.flags & 0x20) != 0;
    }

    protected final boolean isLocked() {
        return (this.flags & 0x40) != 0;
    }

    protected void setCoord(ViewSimple viewSimple) {
        Coord coord = new Coord();
        boolean bl = false;
        Projection projection = viewSimple.getProj();
        if (Projection.isOk(projection)) {
            coord.x = this.xv[viewSimple.n];
            coord.y = this.yv[viewSimple.n];
            projection.getCoord(coord);
            this.raj = coord.al;
            this.dej = coord.del;
            bl = true;
        }
        if (!bl && this.plan instanceof PlanTool) {
            ((PlanTool)this.plan).setXYorig(true);
        }
        if (bl) {
            View view = this.plan.aladin.view;
            int n = view.getNbView();
            for (int i = 0; i < n; ++i) {
                ViewSimple viewSimple2 = view.viewSimple[i];
                if (viewSimple2 == viewSimple || viewSimple2.isFree()) continue;
                this.projection(viewSimple2);
            }
        }
    }

    protected void setCoord(ViewSimple viewSimple, Projection projection) {
        Coord coord = new Coord();
        coord.x = this.xv[viewSimple.n];
        coord.y = this.yv[viewSimple.n];
        projection.getCoord(coord);
        this.raj = coord.al;
        this.dej = coord.del;
    }

    protected void setXY(Projection projection) {
        Coord coord = new Coord();
        coord.al = this.raj;
        coord.del = this.dej;
        projection.getXY(coord);
        if (!Double.isNaN(coord.x)) {
            this.x = (double)Math.round(coord.x * 1000.0) / 1000.0;
            this.y = projection.r1 - (double)Math.round(coord.y * 1000.0) / 1000.0;
        }
    }

    protected void setXYTan(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    protected void setXYTan(Coord coord) {
        this.x = Math.toRadians(Math.cos(Math.toRadians(coord.del)) * (this.raj - coord.al));
        this.y = Math.toRadians(this.dej - coord.del);
    }

    @Override
    protected void projection(ViewSimple viewSimple) {
        Projection projection;
        Coord coord = new Coord();
        if (this.plan != null && this.plan.hasXYorig || !Projection.isOk(projection = viewSimple.getProj())) {
            this.xv[viewSimple.n] = this.x - 0.5;
            this.yv[viewSimple.n] = (double)viewSimple.getPRefDimension().height - this.y + 0.5;
        } else {
            if (this.raj == Double.NaN && this.xv[viewSimple.n] != 0.0) {
                this.setCoord(viewSimple, projection);
            }
            coord.al = this.raj;
            coord.del = this.dej;
            projection.getXY(coord);
            this.xv[viewSimple.n] = coord.x;
            this.yv[viewSimple.n] = coord.y;
        }
    }

    @Override
    protected Plan getPlan() {
        return this.plan;
    }

    @Override
    protected void setPosition(ViewSimple viewSimple, double d, double d2) {
        this.setPosition1(viewSimple, d, d2);
    }

    protected void setPosition1(ViewSimple viewSimple, double d, double d2) {
        if (this.raj == Double.NaN) {
            this.x = d;
            this.y = (double)viewSimple.getPRefDimension().height - d2;
        }
        this.xv[viewSimple.n] = d;
        this.yv[viewSimple.n] = d2;
        this.setCoord(viewSimple);
    }

    @Override
    protected void deltaPosition(ViewSimple viewSimple, double d, double d2) {
        this.deltaPosition1(viewSimple, d, d2);
    }

    protected void deltaPosition1(ViewSimple viewSimple, double d, double d2) {
        if (this.raj == Double.NaN) {
            this.x += d;
            this.y -= d2;
        }
        int n = viewSimple.n;
        this.xv[n] = this.xv[n] + d;
        int n2 = viewSimple.n;
        this.yv[n2] = this.yv[n2] + d2;
        this.setCoord(viewSimple);
    }

    @Override
    protected void deltaRaDec(double d, double d2) {
        this.deltaRaDec1(d, d2);
    }

    protected void deltaRaDec1(double d, double d2) {
        this.raj += d;
        this.dej += d2;
        View view = this.plan.aladin.view;
        int n = view.getNbView();
        for (int i = 0; i < n; ++i) {
            ViewSimple viewSimple = view.viewSimple[i];
            if (viewSimple.isFree()) continue;
            this.projection(viewSimple);
        }
    }

    protected void rotatePosition(ViewSimple viewSimple, double d, double d2, double d3) {
        double d4 = this.xv[viewSimple.n] - d2;
        double d5 = this.yv[viewSimple.n] - d3;
        double d6 = FastMath.cos(d);
        double d7 = FastMath.sin(d);
        this.xv[viewSimple.n] = d2 + d4 * d6 - d5 * d7;
        this.yv[viewSimple.n] = d3 + d4 * d7 + d5 * d6;
        this.setCoord(viewSimple);
    }

    @Override
    protected void setText(String string) {
        this.id = string;
    }

    @Override
    protected void switchSelect() {
        this.setSelect(!this.isSelected());
    }

    @Override
    protected void setVisibleGenerique(boolean bl) {
        this.setVisible(bl);
    }

    @Override
    protected Point getViewCoord(ViewSimple viewSimple, int n, int n2) {
        if (Double.isNaN(this.xv[viewSimple.n])) {
            return null;
        }
        return viewSimple.getViewCoordWithMarge(null, this.xv[viewSimple.n], this.yv[viewSimple.n], n, n2);
    }

    protected PointD getViewCoordDouble(ViewSimple viewSimple, int n, int n2) {
        if (Double.isNaN(this.xv[viewSimple.n])) {
            return null;
        }
        return viewSimple.getViewCoordDoubleWithMarge(null, this.xv[viewSimple.n], this.yv[viewSimple.n], n, n2);
    }

    @Override
    protected boolean inside(ViewSimple viewSimple, double d, double d2) {
        return this.inBout(viewSimple, d, d2);
    }

    @Override
    protected boolean inBout(ViewSimple viewSimple, double d, double d2) {
        PointD pointD = viewSimple.getViewCoordDble(d, d2);
        PointD pointD2 = viewSimple.getViewCoordDble(this.xv[viewSimple.n], this.yv[viewSimple.n]);
        double d3 = this.mouseDist(viewSimple);
        return pointD2.x * pointD2.x + pointD.x * pointD.y < d3 * d3;
    }

    @Override
    protected boolean in(ViewSimple viewSimple, double d, double d2) {
        return this.inside(viewSimple, d, d2);
    }

    protected boolean inRectangle(ViewSimple viewSimple, RectangleD rectangleD) {
        return rectangleD.contains(this.xv[viewSimple.n], this.yv[viewSimple.n]);
    }

    @Override
    protected Rectangle extendClip(ViewSimple viewSimple, Rectangle rectangle) {
        if (!this.isVisible()) {
            return rectangle;
        }
        Point point = this.getViewCoord(viewSimple, 0, 0);
        if (point == null) {
            return rectangle;
        }
        if (this.isSelected()) {
            return Position.unionRect(rectangle, point.x - 4, point.y - 4, 9, 9);
        }
        return Position.unionRect(rectangle, point.x, point.y, 1, 1);
    }

    @Override
    protected void info(Aladin aladin) {
    }

    @Override
    protected void status(Aladin aladin) {
        aladin.status.setText(this.id);
    }

    @Override
    protected void writeLink(OutputStream outputStream, ViewSimple viewSimple) throws Exception {
    }

    @Override
    protected boolean draw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        if (!this.isVisible()) {
            return false;
        }
        Point point = this.getViewCoord(viewSimple, 0, 0);
        if (point == null) {
            return false;
        }
        graphics.setColor(this.plan.c);
        point.x += n;
        point.y += n2;
        graphics.drawLine(point.x, point.y, 1 + n, 1 + n2);
        if (this.isSelected()) {
            graphics.setColor(Color.green);
            this.drawSelect(graphics, viewSimple);
        }
        return true;
    }

    @Override
    protected void drawSelect(Graphics graphics, ViewSimple viewSimple) {
        this.drawSelect(graphics, this.getClip(viewSimple));
    }

    protected void drawSelect(Graphics graphics, Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    n = rectangle.x;
                    n2 = rectangle.y + rectangle.height - 4 - 1;
                    break;
                }
                case 1: {
                    n = rectangle.x;
                    n2 = rectangle.y;
                    break;
                }
                case 2: {
                    n = rectangle.x + rectangle.width - 4 - 1;
                    n2 = rectangle.y;
                    break;
                }
                case 3: {
                    n = rectangle.x + rectangle.width - 4 - 1;
                    n2 = rectangle.y + rectangle.height - 4 - 1;
                }
            }
            this.drawPoignee(graphics, n, n2);
        }
    }

    protected void drawPoignee(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.green);
        graphics.fillRect(n + 1, n2 + 1, 4, 4);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, 4, 4);
    }

    @Override
    protected boolean cutOn() {
        return false;
    }

    protected void histOn() {
        this.plan.aladin.calque.zoom.zoomView.activeHistPixel(this.id);
    }

    protected void statInit() {
        nombre = 0;
        total = 0.0;
        carre = 0.0;
        medianeArrayNb = 0;
        posy = -1.0;
        posx = -1.0;
        minimum = Double.MAX_VALUE;
        maximum = -1.7976931348623157E308;
    }

    protected double statPixel(Graphics graphics, int n, int n2, ViewSimple viewSimple, Hist.HistItem histItem) {
        Point point;
        PlanImage planImage = (PlanImage)viewSimple.pref;
        Color color = graphics.getColor();
        double d = !(this.plan instanceof PlanBG) && (n2 < 0 || n2 >= planImage.naxis2 || n < 0 || n >= planImage.naxis1 || planImage.fmt == 1 || planImage.pixelsOrigin == null && !planImage.isBigImage()) ? Double.NaN : planImage.getPixelInDouble(n, n2);
        double d2 = viewSimple.getZoom();
        if (graphics != null && histItem != null && histItem.contains(d) && (point = viewSimple.getViewCoord((double)n + 0.5, (double)n2 + 0.5)) != null) {
            graphics.setColor(Color.cyan);
            int n3 = (int)d2;
            if (n3 < 1) {
                n3 = 2;
            }
            graphics.fillRect(point.x - n3 / 2, point.y - n3 / 2, n3, n3);
        }
        if (d2 > 2.0) {
            point = viewSimple.getViewCoord((double)n + 0.5, (double)n2 + 0.5);
            if (Double.isNaN(d)) {
                graphics.setColor(Color.orange);
            } else {
                graphics.setColor(Color.red);
            }
            if (d2 > 4.0) {
                Util.fillCircle5(graphics, point.x, point.y);
            } else {
                Util.fillCircle2(graphics, point.x, point.y);
            }
        }
        graphics.setColor(color);
        return this.statPixel(d);
    }

    protected double statPixel(Graphics graphics, double d, double d2, double d3, ViewSimple viewSimple, Hist.HistItem histItem) {
        Point point;
        Coord coord = new Coord(d2, d3);
        viewSimple.getProj().getXY(coord);
        Color color = graphics.getColor();
        double d4 = (double)viewSimple.rv.height / (viewSimple.getTailleDE() / ((PlanBG)viewSimple.pref).getPixelResolution()) / Math.sqrt(2.0);
        if (graphics != null && histItem != null && histItem.contains(d) && (point = viewSimple.getViewCoord(coord.x, coord.y)) != null) {
            graphics.setColor(Color.cyan);
            int n = (int)d4;
            if (n < 1) {
                n = 2;
            }
            Polygon polygon = new Polygon(new int[]{point.x, point.x + n, point.x, point.x - n}, new int[]{point.y - n, point.y, point.y + n, point.y}, 4);
            graphics.fillPolygon(polygon);
        }
        if (d4 > 4.0) {
            point = viewSimple.getViewCoord(coord.x, coord.y);
            if (Double.isNaN(d)) {
                graphics.setColor(Color.orange);
            } else {
                graphics.setColor(Color.red);
            }
            if (d4 > 8.0) {
                Util.fillCircle5(graphics, point.x, point.y);
            } else {
                Util.fillCircle2(graphics, point.x, point.y);
            }
        }
        graphics.setColor(color);
        return this.statPixel(d);
    }

    protected double statPixel(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        ++nombre;
        if (d < minimum) {
            minimum = d;
        }
        if (d > maximum) {
            maximum = d;
        }
        if (medianeArrayNb < 10000) {
            Position.medianeArray[Position.medianeArrayNb++] = d;
        }
        total += d;
        carre += d * d;
        return d;
    }

    protected boolean statCompute(Graphics graphics, ViewSimple viewSimple) {
        return false;
    }

    protected Rectangle getStatPosition(ViewSimple viewSimple) {
        Point point = viewSimple.getViewCoord(minx, miny);
        Point point2 = viewSimple.getViewCoord(maxx, maxy);
        if (point == null || point2 == null) {
            return null;
        }
        return new Rectangle(point2.x + 5, point.y, 120, 117);
    }

    protected void statDraw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        if (!viewSimple.flagPhotometry || !viewSimple.pref.hasAvailablePixels() || viewSimple.pref instanceof PlanImageRGB) {
            return;
        }
        if (!this.statCompute(graphics, viewSimple)) {
            return;
        }
        String string = Util.myRound(nombre);
        String string2 = Util.myRound(total);
        String string3 = Util.myRound(moyenne);
        String string4 = Double.isNaN(mediane) ? "" : Util.myRound(mediane);
        String string5 = Util.myRound(sigma);
        String string6 = Coord.getUnit(surface, false, true) + "\u00b2";
        String string7 = Util.myRound(minimum);
        String string8 = Util.myRound(maximum);
        if (this.isWithStat() || this.isWithLabel()) {
            Color color = graphics.getColor();
            Color color2 = color == Color.red || color == Color.blue ? Color.white : null;
            Rectangle rectangle = this.getStatPosition(viewSimple);
            if (rectangle != null && (this.isWithLabel() || viewSimple.aladin.view.isMultiView())) {
                Point point;
                rectangle.x += n;
                rectangle.y += n2;
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + 117);
                if (posx == -1.0) {
                    posx = minx + 3.0 * (maxx - minx) / 4.0;
                    posy = (maxy + miny) / 2.0;
                }
                if ((point = viewSimple.getViewCoord(posx, posy)) != null) {
                    graphics.drawLine(rectangle.x, rectangle.y + 58, point.x, point.y);
                    Util.fillCircle5(graphics, point.x, point.y);
                    rectangle.x += 2;
                    rectangle.y += 11;
                    graphics.setFont(Aladin.BOLD);
                    Util.drawStringOutline(graphics, "Cnt", rectangle.x, rectangle.y, color, color2);
                    Util.drawStringOutline(graphics, string, rectangle.x + 43, rectangle.y, color, color2);
                    rectangle.y += 13;
                    Util.drawStringOutline(graphics, "Sum", rectangle.x, rectangle.y, color, color2);
                    Util.drawStringOutline(graphics, string2, rectangle.x + 43, rectangle.y, color, color2);
                    rectangle.y += 13;
                    Util.drawStringOutline(graphics, "Sigma", rectangle.x, rectangle.y, color, color2);
                    Util.drawStringOutline(graphics, string5, rectangle.x + 43, rectangle.y, color, color2);
                    rectangle.y += 13;
                    Util.drawStringOutline(graphics, "Min", rectangle.x, rectangle.y, color, color2);
                    Util.drawStringOutline(graphics, string7, rectangle.x + 43, rectangle.y, color, color2);
                    rectangle.y += 13;
                    Util.drawStringOutline(graphics, "Avg", rectangle.x, rectangle.y, color, color2);
                    Util.drawStringOutline(graphics, string3, rectangle.x + 43, rectangle.y, color, color2);
                    rectangle.y += 13;
                    if (!Double.isNaN(mediane)) {
                        Util.drawStringOutline(graphics, "Med", rectangle.x, rectangle.y, color, color2);
                        Util.drawStringOutline(graphics, string4, rectangle.x + 43, rectangle.y, color, color2);
                        rectangle.y += 13;
                    }
                    Util.drawStringOutline(graphics, "max", rectangle.x, rectangle.y, color, color2);
                    Util.drawStringOutline(graphics, string8, rectangle.x + 43, rectangle.y, color, color2);
                    rectangle.y += 13;
                    if (this instanceof SourceStat) {
                        Util.drawStringOutline(graphics, "Rad", rectangle.x, rectangle.y, color, color2);
                        Util.drawStringOutline(graphics, Coord.getUnit(((SourceStat)this).getRadius()), rectangle.x + 43, rectangle.y, color, color2);
                        rectangle.y += 13;
                    }
                    Util.drawStringOutline(graphics, "Surf", rectangle.x, rectangle.y, color, color2);
                    Util.drawStringOutline(graphics, string6, rectangle.x + 43, rectangle.y, color, color2);
                    rectangle.y += 13;
                }
            }
        }
        if (viewSimple.pref == this.plan.aladin.calque.getPlanBase()) {
            if (!(this instanceof SourceStat)) {
                this.id = "Cnt " + string + " / Sum " + string2 + " / Sigma " + string5 + " / Min " + string7 + " / Avg " + string3 + (Double.isNaN(mediane) ? "" : " / Med " + string4) + " / Max " + string8 + (this instanceof SourceStat ? " / Rad " + Coord.getUnit(((SourceStat)this).getRadius()) : "") + " / Surf " + string6;
            }
            this.histOn();
        }
    }

    static {
        medianeArrayNb = 0;
        medianeArray = new double[10000];
    }
}

