/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.Projection;
import cds.aladin.Source;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

class Printer
implements Runnable {
    Thread thread;
    private Aladin aladin;
    static int MARGE = 22;

    Printer(Aladin aladin) {
        this.aladin = aladin;
        this.thread = new Thread((Runnable)this, "AladinPrinter");
        Util.decreasePriority(Thread.currentThread(), this.thread);
        this.thread.start();
    }

    @Override
    public void run() {
        this.aladin.setFlagPrint(true);
        try {
            String string = "VIEW";
            if (this.aladin.view.isMultiView()) {
                this.printMosaique();
                string = "MOSAIC";
            } else {
                this.printCurrentView();
            }
            this.aladin.log("print", string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.aladin.setFlagPrint(false);
    }

    private void adjustGraphics(Graphics2D graphics2D, PageFormat pageFormat, int n, int n2) {
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        double d3 = Math.max((double)MARGE, d);
        double d4 = Math.max((double)MARGE, d2);
        double d5 = pageFormat.getImageableWidth() - d3 - (double)(d == 0.0 ? MARGE : 0);
        double d6 = pageFormat.getImageableHeight() - d4 - (double)(d2 == 0.0 ? MARGE : 0);
        double d7 = d5 / (double)n;
        double d8 = d6 / (double)n2;
        double d9 = Math.min(d7, d8);
        graphics2D.translate(d3, d4);
        graphics2D.scale(d9, d9);
    }

    private void printCurrentView() throws Exception {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(new PrintCurrentView(this.aladin.view.getCurrentView()));
        if (printerJob.printDialog()) {
            printerJob.print();
        }
    }

    private void printMosaique() throws Exception {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(new printMosaique());
        if (printerJob.printDialog()) {
            printerJob.print();
        }
    }

    private int printCopyright(Graphics graphics, int n, int n2, int n3, boolean bl) {
        Font font = new Font("TimesRoman", 0, 7);
        graphics.setColor(Color.black);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = n;
        int n5 = n2 + fontMetrics.getAscent() + 2;
        graphics.drawString("Produced by Aladin (Centre de Donnees astronomiques de Strasbourg)", n4, n5);
        graphics.drawString("http://aladin.u-strasbg.fr", n4, n5 += fontMetrics.getHeight());
        Plan plan = this.aladin.calque.getPlanRef();
        if (bl && plan != null && plan.copyright != null) {
            n5 = n2 + fontMetrics.getAscent() + 2;
            n4 = n3 - fontMetrics.stringWidth(plan.copyright);
            graphics.drawString(plan.copyright, n4, n5);
        }
        return n5 + fontMetrics.getDescent() + fontMetrics.getLeading();
    }

    private int printTitre(Graphics graphics, int n, int n2, int n3) {
        int n4;
        char c;
        Font font = new Font("TimesRoman", 0, 20);
        Font font2 = new Font("TimesRoman", 0, 14);
        Plan plan = this.aladin.calque.getPlanRef();
        if (plan == null || !Projection.isOk(plan.projd)) {
            return 30;
        }
        String string = plan.objet == null ? null : ((c = plan.objet.charAt(0)) < '0' || c > '9' ? plan.objet : null);
        graphics.setColor(Color.black);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = n2 + fontMetrics.getHeight();
        if (plan.isImage()) {
            graphics.setFont(font2);
            fontMetrics = graphics.getFontMetrics();
            n4 = n3 - fontMetrics.stringWidth(plan.label) - 10;
            graphics.drawString(plan.label, n4, n5);
            graphics.setFont(font);
            fontMetrics = graphics.getFontMetrics();
        }
        n4 = n;
        if (string != null) {
            graphics.drawString(string, n4, n5);
            n5 += fontMetrics.getAscent();
        }
        return n5 + 2;
    }

    private void printLegende(Graphics graphics, int n, int n2, boolean bl) {
        Plan plan;
        Plan[] planArray = this.aladin.calque.plan;
        Font font = new Font("TimesRoman", 0, 12);
        Vector<Plan> vector = new Vector<Plan>(10);
        int n3 = 0;
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.getHeight();
        for (int i = 0; i < planArray.length; ++i) {
            plan = planArray[i];
            if (!plan.isCatalog() || !plan.flagOk || plan.error != null || !plan.active) continue;
            vector.addElement(plan);
            int n5 = fontMetrics.stringWidth(plan.getLabel());
            if (n5 <= n3) continue;
            n3 = n5;
        }
        if (vector.size() == 0) {
            return;
        }
        n3 += 28;
        int n6 = vector.size() * n4 + fontMetrics.getDescent();
        if (bl) {
            graphics.setColor(Color.white);
            graphics.fillRect(n - n3, n2, n3, n6);
            graphics.setColor(Color.black);
            graphics.drawRect(n - n3, n2, n3, n6);
        }
        int n7 = n2 + n4;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            plan = (Plan)enumeration.nextElement();
            if (!plan.isCatalog() || !plan.flagOk || plan.error != null || !plan.active) continue;
            Iterator<Obj> iterator = plan.iterator();
            Source source = null;
            while (iterator.hasNext()) {
                Obj obj = iterator.next();
                if (!(obj instanceof Source)) continue;
                source = (Source)obj;
                break;
            }
            int n8 = n - n3 + 10;
            if (source != null) {
                source.print(graphics, n8, n7 - n4 / 3);
            }
            graphics.setColor(Color.black);
            graphics.drawString(plan.getLabel(), n8 += 10, n7);
            n7 += n4;
        }
    }

    class printMosaique
    implements Printable {
        static final int GAP = 10;

        printMosaique() {
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            double d;
            if (n > 0) {
                return 1;
            }
            int n2 = MARGE;
            int n3 = 70;
            int n4 = 0;
            int n5 = ((Printer)Printer.this).aladin.viewControl.getNbCol();
            int n6 = ((Printer)Printer.this).aladin.view.getWidth() + 10 * (n5 - 1);
            int n7 = (int)pageFormat.getImageableWidth();
            int n8 = ((Printer)Printer.this).aladin.view.getWidth() + 10 * (n5 - 1);
            int n9 = (int)pageFormat.getImageableWidth();
            double d2 = (double)n7 / (double)n6;
            if (d2 > 1.0) {
                d2 = 1.0 + (d2 - 1.0) / 2.0;
            }
            if ((d = (double)n9 / (double)(n8 + 70)) > 1.0) {
                d = 1.0 + (d - 1.0) / 2.0;
            }
            double d3 = Math.min(d2, d);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.scale(d3, d3);
            for (int i = 0; i < ((Printer)Printer.this).aladin.view.getModeView(); ++i) {
                ViewSimple viewSimple = ((Printer)Printer.this).aladin.view.viewSimple[i];
                if (i > 0 && i % n5 == 0) {
                    n2 = MARGE;
                    n3 += n4;
                    n4 = 0;
                }
                if (!viewSimple.isFree()) {
                    try {
                        graphics2D.setClip(n2, n3, viewSimple.getWidth(), viewSimple.getHeight());
                        Image image = viewSimple.getImage(-1, -1);
                        graphics2D.drawImage(image, n2, n3, Printer.this.aladin);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n2, n3, viewSimple.getWidth(), viewSimple.getHeight());
                n2 += viewSimple.getWidth() + 10;
                if (viewSimple.getHeight() <= n4) continue;
                n4 = viewSimple.getHeight() + 10;
            }
            n2 = MARGE;
            graphics.setClip(n2, n3 += n4, n6, 200);
            Printer.this.printCopyright(graphics2D, n2, n3, n6, false);
            return 0;
        }
    }

    class PrintCurrentView
    implements Printable {
        private ViewSimple v;

        PrintCurrentView(ViewSimple viewSimple) {
            this.v = viewSimple;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            if (n > 0) {
                return 1;
            }
            int n2 = this.v.getWidth();
            int n3 = this.v.getHeight();
            Printer.this.adjustGraphics((Graphics2D)graphics, pageFormat, n2, n3);
            int n4 = 1;
            int n5 = 1;
            graphics.setClip(0, 0, n4 + n2, n5 + n3 + 200);
            n5 = Printer.this.printTitre(graphics, n4, n5, n2);
            graphics.setClip(n4, n5, n2, n3);
            if (this.v.pref.active) {
                Image image = this.v.getImage(-1, -1);
                graphics.drawImage(image, n4, n5, Printer.this.aladin);
            }
            graphics.setClip(0, 0, n4 + n2, n5 + n3 + 200);
            graphics.setColor(Color.black);
            graphics.drawRect(n4, n5, n2, n3);
            Printer.this.printLegende(graphics, n4 + n2, n5 + 20, true);
            n5 += n3;
            n5 = Printer.this.printCopyright(graphics, 0, n5, n2, true);
            return 0;
        }
    }

    class PrintTest
    implements Printable {
        private ViewSimple v;

        PrintTest(ViewSimple viewSimple) {
            this.v = viewSimple;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            if (n > 0) {
                return 1;
            }
            int n2 = this.v.getWidth();
            int n3 = this.v.getHeight();
            Printer.this.adjustGraphics((Graphics2D)graphics, pageFormat, n2, n3);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, n2, n3);
            graphics.setColor(Color.red);
            graphics.drawLine(0, 0, n2, n3);
            graphics.drawLine(0, n3, n2, 0);
            graphics.setColor(Color.blue);
            return 0;
        }
    }
}

