/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Localisation;
import cds.aladin.PlanBG;
import cds.aladin.ViewSimple;
import cds.fits.HeaderFits;
import cds.tools.Util;
import java.util.Enumeration;
import java.util.Vector;

public final class Projection {
    static final int NO = 0;
    static final int ALADIN = 1;
    static final int WCS = 2;
    static final int SIMPLE = 3;
    static final int QUADRUPLET = 4;
    static final int PLOT = 5;
    static final String[] NAME = new String[]{"-", "Aladin reduction", "WCS reduction", "Simple reduction", "Matching star red.", "Squattered plot"};
    protected int frame = 0;
    protected String label = null;
    protected double raj;
    protected double dej;
    protected double alphai;
    protected double deltai;
    protected double cx;
    protected double cy;
    protected double rm;
    protected double rm1;
    protected double r;
    protected double r1;
    protected double rot;
    protected boolean sym;
    protected int system;
    protected int t;
    protected int modeCalib;
    protected boolean toNorth;
    protected Calib c;
    protected Coord[] coo;
    static String[] alaProj = new String[]{"Sinus", "Tangential", "Aitoff", "Zenital equal area", "Stereographic", "Cartesian", "Mollweide", "Arc", "Fisheye"};
    static String[] alaProjToType = new String[]{"SIN", "TAN", "AIT", "ZEA", "STG", "CAR", "MOL", "ARC", "FEYE"};
    private double flipPlotX = 1.0;
    private double flipPlotY = 1.0;
    private boolean logPlotX = false;
    private boolean logPlotY = false;
    private Projection projNorth = null;
    private Coord cotmp = new Coord();

    public static int getProjType(String string) {
        int n = Util.indexInArrayOf(string, alaProj, true);
        if (n >= 0) {
            string = alaProjToType[n];
        }
        return Util.indexInArrayOf(string, Calib.projType, true);
    }

    public static int getAlaProjIndex(String string) {
        int n = Util.indexInArrayOf(string, alaProj, true);
        if (n >= 0) {
            return n;
        }
        return Util.indexInArrayOf(string, alaProjToType, true);
    }

    public static String[] getAlaProj() {
        return alaProj;
    }

    public static String getAlaProj(int n) {
        return alaProj[n];
    }

    protected Projection() {
        this.modeCalib = 0;
    }

    protected Projection(Projection projection) {
        this.c = projection.c;
        this.adjustParamByCalib(this.c);
    }

    protected double getRaMax() {
        return Projection.getRaMax(this.t);
    }

    protected static double getRaMax(int n) {
        return n == 1 || n == 2 || n == 12 || n == 16 ? 180.0 : 360.0;
    }

    protected double getDeMax() {
        return this.t == 16 ? 90.0 : (this.t == 1 || this.t == 2 || this.t == 12 || this.t == 4 || this.t == 7 || this.t == 11 || this.t == 5 || this.t == 3 ? 180.0 : 360.0);
    }

    protected Projection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.modeCalib = 5;
        this.raj = this.alphai = d;
        this.dej = this.deltai = d2;
        this.cx = d3;
        this.cy = d4;
        this.rm = d5;
        this.rm1 = d6;
        this.r = d7;
        this.r1 = d7;
        this.flipPlotX = bl ? -1.0 : 1.0;
        this.flipPlotY = bl2 ? -1.0 : 1.0;
        this.logPlotX = bl3;
        this.logPlotY = bl4;
    }

    private double log(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    private double exp(double d) {
        return Math.exp(d * Math.log(10.0));
    }

    protected double getFctXPlot() {
        return this.r / (this.logPlotX ? this.log(this.rm) : this.rm);
    }

    protected double getFctYPlot() {
        return this.r1 / (this.logPlotY ? this.log(this.rm1) : this.rm1);
    }

    protected Coord getXYPlot(Coord coord) {
        if (Double.isNaN(coord.al)) {
            coord.x = Double.NaN;
            coord.y = Double.NaN;
            return coord;
        }
        try {
            double d = this.logPlotX ? this.log(coord.al) : coord.al - this.alphai;
            double d2 = this.logPlotY ? this.log(coord.del) : coord.del - this.deltai;
            coord.x = d * this.r / (this.logPlotX ? this.log(this.rm - this.alphai) : this.rm) * this.flipPlotX + this.cx;
            coord.y = d2 * -this.r1 / (this.logPlotY ? this.log(this.rm1 - this.deltai) : this.rm1) * this.flipPlotY + this.cy;
            if (Double.isInfinite(coord.x) || Double.isInfinite(coord.y)) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            coord.x = Double.NaN;
            coord.y = Double.NaN;
        }
        return coord;
    }

    protected Coord getCoordPlot(Coord coord) {
        if (Double.isNaN(coord.x)) {
            coord.al = Double.NaN;
            coord.del = Double.NaN;
            return coord;
        }
        try {
            double d = coord.x - this.cx;
            double d2 = coord.y - this.cy;
            double d3 = d * (this.logPlotX ? this.log(this.rm - this.alphai) : this.rm) / this.r * this.flipPlotX;
            coord.al = (this.logPlotX ? this.exp(d3) : d3) + this.alphai;
            double d4 = d2 * -(this.logPlotY ? this.log(this.rm1 - this.deltai) : this.rm1) / this.r1 * this.flipPlotY;
            coord.del = (this.logPlotY ? this.exp(d4) : d4) + this.deltai;
            if (Double.isInfinite(coord.al) || Double.isInfinite(coord.del)) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            coord.al = Double.NaN;
            coord.del = Double.NaN;
        }
        return coord;
    }

    protected boolean isFlipXPlot() {
        return this.flipPlotX == -1.0;
    }

    protected boolean isFlipYPlot() {
        return this.flipPlotY == -1.0;
    }

    protected boolean isLogXPlot() {
        return this.logPlotX;
    }

    protected boolean isLogYPlot() {
        return this.logPlotY;
    }

    protected void flipPlot(int n, boolean bl) {
        if (n == 0) {
            this.flipPlotX = bl ? -1.0 : 1.0;
        } else {
            this.flipPlotY = bl ? -1.0 : 1.0;
        }
    }

    protected void logPlot(int n, boolean bl) {
        if (n == 0) {
            this.logPlotX = bl;
        } else {
            this.logPlotY = bl;
        }
    }

    protected Projection(String string, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, int n2, int n3) {
        this(string, n, d, d2, d3, d3, d4, d5, d6, d6, d7, bl, n2, n3);
    }

    protected Projection(String string, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, boolean bl, int n2, int n3) {
        this.c = new Calib(d, d2, d5, d6, d7, d8, d3, d4, d9, n2, bl, n3);
        this.adjustParamByCalib(this.c);
        this.modeCalib = n;
        this.label = string;
        if (this.label == null) {
            this.label = Projection.getName(n, n2);
        }
    }

    public Projection(int n, Calib calib) {
        this.c = calib;
        this.adjustParamByCalib(calib);
        this.modeCalib = n;
        this.label = Projection.getName(n, 0);
    }

    protected Projection copy() {
        Projection projection = new Projection();
        projection.frame = this.frame;
        projection.raj = this.raj;
        projection.dej = this.dej;
        projection.alphai = this.alphai;
        projection.deltai = this.deltai;
        projection.cx = this.cx;
        projection.cy = this.cy;
        projection.rm = this.rm;
        projection.r = this.r;
        projection.rm1 = this.rm1;
        projection.r1 = this.r1;
        projection.rot = this.rot;
        projection.sym = this.sym;
        projection.t = this.t;
        projection.system = this.system;
        projection.modeCalib = this.modeCalib;
        String string = projection.label = this.label == null ? null : new String(this.label);
        if (this.coo != null) {
            projection.coo = new Coord[this.coo.length];
            System.arraycopy(this.coo, 0, projection.coo, 0, this.coo.length);
        }
        projection.c = this.c == null ? null : Calib.copy(this.c);
        return projection;
    }

    protected Projection toNorth(double d) {
        if (this.rot == d) {
            return this;
        }
        if (this.projNorth == null || this.projNorth.c.getProjRot() != d) {
            this.projNorth = new Projection();
            this.projNorth.c = new Calib(this.alphai, this.deltai, this.cx, this.cy, this.r, this.r1, this.rm, this.rm1, d, this.t, false, this.system);
            this.projNorth.adjustParamByCalib(this.projNorth.c);
            this.projNorth.modeCalib = this.modeCalib;
            this.projNorth.label = Projection.getName(this.modeCalib, this.t);
            this.projNorth.coo = null;
        }
        return this.projNorth;
    }

    protected void crop(double d, double d2, double d3, double d4) {
        this.c.cropping(d, d2, d3, d4);
        this.adjustParamByCalib(this.c);
    }

    protected void cropAndZoom(double d, double d2, double d3, double d4, double d5) {
        this.c.cropAndZoom(d, d2, d3, d4, d5);
        this.adjustParamByCalib(this.c);
    }

    protected void modify(String string, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, boolean bl, int n2, int n3) {
        this.c = new Calib(d, d2, d5, d6, d7, d8, d3, d4, d9, n2, bl, n3);
        this.adjustParamByCalib(this.c);
        this.modeCalib = n;
        if (string == null) {
            this.label = Projection.getName(n, n2);
        }
        this.coo = null;
    }

    public void setProjSym(boolean bl) {
        this.modify(this.label, this.modeCalib, this.alphai, this.deltai, this.rm, this.rm1, this.cx, this.cy, this.r, this.r1, this.rot, bl, this.t, this.system);
    }

    protected void setProjCenter(double d, double d2) {
        Coord coord = new Coord(d, d2);
        if (this.frame != 0) {
            coord = Localisation.frameToFrame(coord, 0, this.frame);
        }
        this.modify(this.label, this.modeCalib, coord.al, coord.del, this.rm, this.rm1, this.cx, this.cy, this.r, this.r1, this.rot, this.sym, this.t, this.system);
    }

    protected void setProjRot(double d) {
        this.modify(this.label, this.modeCalib, this.alphai, this.deltai, this.rm, this.rm, this.cx, this.cy, this.r, this.r, d, this.sym, this.t, this.system);
    }

    protected void deltaProjRot(double d) {
        double d2 = this.rot + d;
        if (d2 > 360.0) {
            d2 -= 360.0;
        } else if (d2 < 0.0) {
            d2 += 360.0;
        }
        this.modify(this.label, this.modeCalib, this.alphai, this.deltai, this.rm, this.rm, this.cx, this.cy, this.r, this.r, d2, this.sym, this.t, this.system);
    }

    protected void deltaProjCenter(double d, double d2) {
        double d3 = this.alphai + d;
        double d4 = this.deltai + d2;
        double d5 = this.rot;
        if (d4 > 89.95) {
            d4 = 180.0 - d4;
            d3 += 180.0;
            d5 += 180.0;
        } else if (d4 < -89.95) {
            d4 = -d4 - 180.0;
            d3 += 180.0;
            d5 -= 180.0;
        }
        if (d3 > 360.0) {
            d3 -= 360.0;
        } else if (d3 < 0.0) {
            d3 += 360.0;
        }
        if (d5 > 360.0) {
            d5 -= 360.0;
        } else if (d5 < 0.0) {
            d5 += 360.0;
        }
        this.modify(this.label, this.modeCalib, d3, d4, this.rm, this.rm, this.cx, this.cy, this.r, this.r, d5, this.sym, this.t, this.system);
    }

    protected void deltaProjXYCenter(double d, double d2) {
        this.c.Xcen += d;
        this.c.Ycen += d2;
        this.adjustParamByCalib(this.c);
    }

    protected static boolean isOk(Projection projection) {
        return projection != null && projection.modeCalib != 0;
    }

    protected static int getDefaultType(double d) {
        return d < 2.0 ? 2 : (d < 60.0 ? 5 : 4);
    }

    protected void modify(String string, Coord[] coordArray) {
        if (string == null) {
            string = Projection.getName(this.modeCalib, this.t);
        }
        this.label = string;
        this.modeCalib = 4;
        this.coo = coordArray;
        this.c = this.c.recalibrate(coordArray);
        this.adjustParamByCalib(this.c);
    }

    protected void modify(String string, Calib calib) {
        if (string == null) {
            string = Projection.getName(this.modeCalib, this.t);
        }
        this.label = string;
        this.modeCalib = 2;
        this.coo = this.coo;
        this.c = calib;
        this.coo = null;
        this.adjustParamByCalib(calib);
    }

    protected void adjustParamByCalib(Calib calib) {
        block3: {
            try {
                Coord coord = calib.getProjCenter();
                this.cx = coord.x;
                this.cy = coord.y;
                this.alphai = coord.al;
                this.deltai = coord.del;
                coord = calib.getImgCenter();
                if (this.frame != 0) {
                    coord = Localisation.frameToFrame(coord, this.frame, 0);
                }
                this.raj = coord.al;
                this.dej = coord.del;
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block3;
                exception.printStackTrace();
            }
        }
        double d = calib.getImgWidth();
        double d2 = calib.getImgHeight();
        this.rm = d * 60.0;
        this.rm1 = d2 * 60.0;
        this.r = calib.getImgSize().width;
        this.r1 = calib.getImgSize().height;
        this.rot = calib.getProjRot();
        this.sym = calib.getProjSym();
        this.system = calib.getSystem();
        this.t = calib.getProj();
    }

    protected double getPixResAlpha() throws Exception {
        return this.c.getImgWidth() / (double)this.c.getImgSize().width;
    }

    protected double getPixResDelta() throws Exception {
        return this.c.getImgHeight() / (double)this.c.getImgSize().height;
    }

    protected void resize(int n) {
        try {
            this.c = this.c.resize(n);
        }
        catch (Exception exception) {
            return;
        }
        this.adjustParamByCalib(this.c);
    }

    protected void resize(int n, double d, double d2, int n2, int n3) {
        this.c = this.c.resize(n, d, d2, n2, n3);
        this.adjustParamByCalib(this.c);
    }

    protected void flip(int n) {
        if (n == 0 || n == 2) {
            this.c = this.c.flipBU();
        }
        if (n == 1 || n == 2) {
            this.c = this.c.flipRL();
        }
        this.adjustParamByCalib(this.c);
    }

    public String toString() {
        return (this.label == null ? "" : this.label + " ") + Projection.getName(this.modeCalib, this.t) + " " + Projection.round(this.alphai) + "," + Projection.round(this.deltai) + "=>" + (int)this.cx + "," + (int)this.cy + " (" + this.rm + "x" + this.rm1 + ")/(" + this.r + "x" + this.r1 + ") " + (this.rot != 0.0 ? "rot=" + this.rot + "deg " : "") + (this.sym ? "RA_symetry " : "") + "system=" + this.system + " " + Localisation.REPERE[this.frame];
    }

    protected boolean isLargeField() {
        return (this.rm > 2700.0 || this.rm1 > 2700.0) && !this.isXYLinear();
    }

    protected boolean isModifiable() {
        return this.modeCalib == 3 || this.modeCalib == 4 || this.modeCalib == 2;
    }

    protected boolean isXYLinear() {
        return this.modeCalib == 5 || this.c != null && this.c.system == 7;
    }

    protected static String getName(int n, int n2) {
        try {
            return n == 3 ? Calib.getProjName(n2) : NAME[n];
        }
        catch (Exception exception) {
            return "noname";
        }
    }

    protected String getName() {
        return Projection.getName(this.modeCalib, this.t);
    }

    protected String getWCS() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector(20);
        Vector vector2 = new Vector(20);
        try {
            this.getWCS(vector, vector2);
        }
        catch (Exception exception) {
            System.err.println("GetWCS error");
            return null;
        }
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)enumeration2.nextElement();
            stringBuffer.append(string + "= " + string2 + "\n");
        }
        return stringBuffer.toString();
    }

    protected void getWCS(Vector vector, Vector vector2) throws Exception {
        this.c.GetWCS(vector, vector2);
        if (this.isEquatorial()) {
            return;
        }
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = vector2.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)enumeration2.nextElement();
            if (string2.startsWith("CTYPE1")) {
                string = Localisation.CTYPE1[this.frame];
                string3 = string + string3.substring(string.length());
                vector2.setElementAt(string3, n);
            } else if (string2.startsWith("CTYPE2")) {
                string = Localisation.CTYPE2[this.frame];
                string3 = string + string3.substring(string.length());
                vector2.setElementAt(string3, n);
            } else if (string2.startsWith("RADECSYS")) {
                string = Localisation.RADECSYS[this.frame];
                if (string == null) {
                    vector.remove(n);
                    vector2.remove(n);
                } else {
                    vector2.setElementAt(string, n);
                }
            }
            ++n;
        }
    }

    protected static Projection getEquivalentProj(Projection projection) throws Exception {
        if (projection.isEquatorial() || projection.system != Calib.GALACTIC) {
            return projection;
        }
        projection.c = new Calib(new HeaderFits(projection.getWCS()));
        projection.adjustParamByCalib(projection.c);
        projection.frame = 0;
        return projection;
    }

    private boolean isEquatorial() {
        return this.frame == 0 || this.frame == 1 || this.frame == 5 || this.frame == 6 || this.frame == 7 || this.frame == 8 || this.frame == 9 || this.frame == 10;
    }

    protected static double round(double d) {
        return Math.ceil(d * 10.0) / 10.0;
    }

    protected boolean agree(Projection projection, ViewSimple viewSimple) {
        return this.agree(projection, viewSimple, true);
    }

    protected boolean agree(Projection projection, ViewSimple viewSimple, boolean bl) {
        if (projection == null) {
            return false;
        }
        if (this == projection) {
            return true;
        }
        if (projection.rm > 1800.0) {
            return true;
        }
        double d = 1.0;
        if (viewSimple != null) {
            if (bl && viewSimple.pref != null && viewSimple.pref instanceof PlanBG) {
                return true;
            }
            d = viewSimple.getZoom();
        }
        Coord coord = new Coord();
        coord.al = projection.raj;
        coord.del = projection.dej;
        Coord coord2 = new Coord();
        coord2.al = this.raj;
        coord2.del = this.dej;
        double d2 = Coord.getDist(coord, coord2);
        double d3 = (this.rm + projection.rm) * Math.sqrt(2.0) / 120.0;
        if (d < 1.0) {
            d3 /= d;
        }
        if (this.rm > 45.0 || projection.rm > 45.0) {
            return true;
        }
        return d2 <= d3;
    }

    public Coord getCoord(Coord coord) {
        Coord coord2 = this.getCoordNative(coord);
        if (this.modeCalib == 5 || this.isXYLinear()) {
            return coord2;
        }
        if (this.frame == 0 || coord.al == Double.NaN) {
            return coord2;
        }
        Localisation.frameToFrame(coord2, this.frame, 0);
        return coord2;
    }

    protected Coord getCoordNative(Coord coord) {
        if (this.modeCalib == 5) {
            return this.getCoordPlot(coord);
        }
        if (Double.isNaN(coord.x)) {
            coord.al = Double.NaN;
            coord.del = Double.NaN;
            return coord;
        }
        try {
            this.cotmp.x = coord.x + 0.5;
            this.cotmp.y = coord.y - 0.5;
            this.c.GetCoord(this.cotmp);
            coord.al = this.cotmp.al;
            coord.del = this.cotmp.del;
        }
        catch (Exception exception) {
            coord.al = Double.NaN;
            coord.del = Double.NaN;
        }
        return coord;
    }

    public Coord getXY(Coord coord) {
        if (this.modeCalib == 5) {
            return this.getXYPlot(coord);
        }
        if (Double.isNaN(coord.al)) {
            coord.x = Double.NaN;
            coord.y = Double.NaN;
            return coord;
        }
        try {
            if (this.frame == 0 || this.isXYLinear()) {
                this.c.GetXY(coord);
            } else {
                this.cotmp.al = coord.al;
                this.cotmp.del = coord.del;
                this.cotmp = Localisation.frameToFrame(this.cotmp, 0, this.frame);
                this.c.GetXY(this.cotmp);
                coord.x = this.cotmp.x;
                coord.y = this.cotmp.y;
            }
            if (!Double.isNaN(coord.x)) {
                coord.x -= 0.5;
                coord.y += 0.5;
            }
        }
        catch (Exception exception) {
            coord.x = Double.NaN;
            coord.y = Double.NaN;
        }
        return coord;
    }

    protected Coord getXYNative(Coord coord) {
        if (this.modeCalib == 5) {
            return this.getXYPlot(coord);
        }
        if (Double.isNaN(coord.al)) {
            coord.x = Double.NaN;
            coord.y = Double.NaN;
            return coord;
        }
        try {
            this.c.GetXY(coord);
            if (!Double.isNaN(coord.x)) {
                coord.x -= 0.5;
                coord.y += 0.5;
            }
        }
        catch (Exception exception) {
            coord.x = Double.NaN;
            coord.y = Double.NaN;
        }
        return coord;
    }

    protected Coord getProjCenter() {
        if (this.modeCalib == 5) {
            Coord coord = new Coord(this.alphai, this.deltai);
            coord.x = this.cx;
            coord.y = this.cy;
            return coord;
        }
        Coord coord = this.c.getProjCenter();
        return Localisation.frameToFrame(coord, this.frame, 0);
    }

    protected boolean sensDirect() {
        if (this.c == null) {
            return false;
        }
        return this.c.sensDirect();
    }
}

