/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Curseur;
import cds.aladin.FilterProperties;
import cds.aladin.FrameNewCalib;
import cds.aladin.Histogramme;
import cds.aladin.Legende;
import cds.aladin.Localisation;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGCat;
import cds.aladin.PlanBGProgen;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanContour;
import cds.aladin.PlanField;
import cds.aladin.PlanFolder;
import cds.aladin.PlanFree;
import cds.aladin.PlanHealpix;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageBlink;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanMoc;
import cds.aladin.PlanTool;
import cds.aladin.Projection;
import cds.aladin.ServerGlu;
import cds.aladin.Source;
import cds.aladin.bookmark.FrameBookmarks;
import cds.aladin.prop.PropPanel;
import cds.astro.Astrotime;
import cds.tools.Astrodate;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Properties
extends JFrame
implements ActionListener,
ChangeListener {
    String SEEFITS;
    String SEEHIPSPROP;
    String SEEPARSING;
    String TABLEINFO;
    String NEWCALIB;
    String MODCALIB;
    String SHOWFOVS;
    String HIDEFOVS;
    String TITLE;
    String BANNER;
    String APPLY;
    String BOOKMARK;
    String CLOSE;
    String NOFILTER;
    String LABEL;
    String COLOR;
    String ERROR;
    String STATE;
    String UNDER;
    String SHAPE;
    String IMG;
    String VIEWABLE;
    String LEVEL;
    String REFCOORD;
    String REFROTATE;
    String ANGLE;
    String COMPONENT;
    String SOURCE;
    String INF;
    String FMT;
    String EPOCH;
    String DATEOBS;
    String WCSEQ;
    String SIZE;
    String PIXMODE;
    String FRAME;
    String DELAY;
    String ORIGIN;
    String FILTER;
    String FILTERB;
    String ASTRED;
    String XYRED;
    String PROJ;
    String NONE;
    String METHOD;
    String CENTER;
    String SELECTFIELD;
    String DEFCATPROJ;
    String FLIPFLOP;
    String ASSFOV;
    String LOCAL;
    String GLOBAL;
    String SCOPE;
    String HSCOPE;
    String OPACITY;
    String OPACITYLEVEL;
    String DENSITY;
    String WHITE;
    String BLACK;
    String AUTO;
    String COLORBG;
    String POLA;
    String DISPLAYPOLA;
    String GENERATEPOLAAMP;
    String GENERATEPOLAANG;
    String CURRENTFIELD;
    String POLAOPTIONS;
    String SEGMENTLEN;
    String SEGMENTTHICK;
    String SEGMENTDENSITY;
    String SCALINGFACTOR;
    String POINTING;
    String POINTINGLABEL;
    String FULLDESCR;
    String ON = "On";
    String OFF = "Off";
    Aladin aladin;
    Plan plan;
    JPanel panel;
    JPanel propPanel;
    PlanFree pmemo = null;
    int hcmemo = 0;
    boolean flagHide = true;
    JTextField label;
    TextField blankField;
    Couleur couleur = null;
    JComboBox sourceType = null;
    ButtonGroup longitude;
    JRadioButton longitudeDescending;
    JRadioButton longitudeAscending;
    ButtonGroup scope;
    JRadioButton scopeGlobal;
    JRadioButton scopeLocal;
    ButtonGroup xyLock = null;
    JComboBox planRefChoice = null;
    JComboBox defCatProj = null;
    JComboBox defFrame = null;
    Plan[] planRef = null;
    JComboBox projsChoice = null;
    Projection[] projs = null;
    JButton modCalib = null;
    JButton toGenFilterButton = null;
    JRadioButton nofilter = null;
    JTextField centerField = null;
    String sField = null;
    JTextField rotateCenter = null;
    String rotateCenterField = null;
    JTextField url = null;
    JTextField rollField = null;
    JTextField epField = null;
    JTextField eqField = null;
    String sEquinox = null;
    String sRoll = null;
    JRadioButton cbT = null;
    JRadioButton cbS = null;
    JRadioButton cbG = null;
    JButton btnDisplayPola;
    JButton btnDisplayAmp;
    JButton btnDisplayAng;
    JCheckBox[] contoursCB;
    Couleur[] contoursCouleurs;
    Curseur curs = null;
    JButton[] filterButtons = null;
    JPanel panelCont;
    JPanel panelScroll;
    JScrollPane scroll;
    JSlider opacityLevel;
    JSlider gapOrder;
    JSlider epochSlider;
    JSlider scalingFactor;
    JSlider polaSegmentLen;
    JSlider polaSegmentThickness;
    JSlider polaSegmentDensity;
    private ButtonGroup cb;
    static Vector frameProp = new Vector(10);
    private ButtonGroup filterCB;
    private Border border = null;
    static boolean flagFullMaj = false;

    protected void createChaine() {
        if (this.SEEFITS != null) {
            return;
        }
        this.SEEFITS = Aladin.chaine.getString("PROPSEEFITS");
        this.SEEHIPSPROP = Aladin.chaine.getString("PROPSEEHIPSPROP");
        this.SEEPARSING = Aladin.chaine.getString("VWTABLEINFO");
        this.TABLEINFO = Aladin.chaine.getString("PROPTABLEINFO");
        this.NEWCALIB = Aladin.chaine.getString("PROPNEWCALIB");
        this.MODCALIB = Aladin.chaine.getString("PROPMODCALIB");
        this.SHOWFOVS = Aladin.chaine.getString("PROPSHOWFOVS");
        this.HIDEFOVS = Aladin.chaine.getString("PROPHIDEFOVS");
        this.TITLE = Aladin.chaine.getString("PROPTITLE");
        this.BANNER = Aladin.chaine.getString("PROPBANNER");
        this.APPLY = Aladin.chaine.getString("PROPAPPLY");
        this.BOOKMARK = Aladin.chaine.getString("PROPBOOKMARK");
        this.CLOSE = Aladin.chaine.getString("PROPCLOSE");
        this.NOFILTER = Aladin.chaine.getString("PROPNOFILTER");
        this.LABEL = Aladin.chaine.getString("PROPLABEL");
        this.COLOR = Aladin.chaine.getString("PROPCOLOR");
        this.ERROR = Aladin.chaine.getString("PROPERROR");
        this.STATE = Aladin.chaine.getString("PROPSTATE");
        this.UNDER = Aladin.chaine.getString("PROPUNDER");
        this.SHAPE = Aladin.chaine.getString("PROPSHAPE");
        this.IMG = Aladin.chaine.getString("PROPIMG");
        this.VIEWABLE = Aladin.chaine.getString("PROPVIEWABLE");
        this.LEVEL = Aladin.chaine.getString("PROPLEVEL");
        this.REFCOORD = Aladin.chaine.getString("PROPREFCOORD");
        this.REFROTATE = Aladin.chaine.getString("PROPREFROTATE");
        this.ANGLE = Aladin.chaine.getString("PROPANGLE");
        this.COMPONENT = Aladin.chaine.getString("PROPCOMPONENT");
        this.SOURCE = Aladin.chaine.getString("PROPSOURCE");
        this.INF = Aladin.chaine.getString("PROPINF");
        this.FMT = Aladin.chaine.getString("PROPFMT");
        this.EPOCH = Aladin.chaine.getString("PROPEPOCH");
        this.DATEOBS = Aladin.chaine.getString("PROPDATEOBS");
        this.WCSEQ = Aladin.chaine.getString("PROPWCSEQ");
        this.PIXMODE = Aladin.chaine.getString("PROPPIXMODE");
        this.SIZE = Aladin.chaine.getString("PROPSIZE");
        this.FRAME = Aladin.chaine.getString("PROPFRAME");
        this.DELAY = Aladin.chaine.getString("PROPDELAY");
        this.ORIGIN = Aladin.chaine.getString("PROPORIGIN");
        this.FILTER = Aladin.chaine.getString("PROPFILTER");
        this.FILTERB = Aladin.chaine.getString("PROPFILTERB");
        this.ASTRED = Aladin.chaine.getString("PROPASTRED");
        this.XYRED = Aladin.chaine.getString("PROPXYRED");
        this.PROJ = Aladin.chaine.getString("PROPPROJ");
        this.NONE = Aladin.chaine.getString("PROPNONE");
        this.METHOD = Aladin.chaine.getString("PROPMETHOD");
        this.FRAME = Aladin.chaine.getString("PROPFRAME");
        this.CENTER = Aladin.chaine.getString("PROPCENTER");
        this.SELECTFIELD = Aladin.chaine.getString("PROPSELECTFIELD");
        this.DEFCATPROJ = Aladin.chaine.getString("PROPDEFCATPROJ");
        this.FLIPFLOP = Aladin.chaine.getString("PROPFLIPFLOP");
        this.ASSFOV = Aladin.chaine.getString("PROPASSFOV");
        this.LOCAL = Aladin.chaine.getString("PROPLOCAL");
        this.GLOBAL = Aladin.chaine.getString("PROPGLOBAL");
        this.SCOPE = Aladin.chaine.getString("PROPSCOPE");
        this.HSCOPE = Aladin.chaine.getString("PROPHSCOPE");
        this.OPACITY = Aladin.chaine.getString("PROPOPACITY");
        this.OPACITYLEVEL = Aladin.chaine.getString("PROPOPACITYLEVEL");
        this.DENSITY = Aladin.chaine.getString("PROPDENSITY");
        this.AUTO = Aladin.chaine.getString("PROPAUTO");
        this.WHITE = Aladin.chaine.getString("PROPWHITE");
        this.BLACK = Aladin.chaine.getString("PROPBLACK");
        this.COLORBG = "Background";
        this.POLA = Aladin.chaine.getString("PROPPOLA");
        this.DISPLAYPOLA = Aladin.chaine.getString("PROPDISPLAYPOLA");
        this.GENERATEPOLAAMP = Aladin.chaine.getString("PROPGENERATEOPOLAAMP");
        this.GENERATEPOLAANG = Aladin.chaine.getString("PROPGENERATEOPOLAANG");
        this.CURRENTFIELD = Aladin.chaine.getString("PROPCURRENTFIELD");
        this.POLAOPTIONS = Aladin.chaine.getString("PROPPOLAOPTIONS");
        this.SEGMENTLEN = Aladin.chaine.getString("PROPSEGMENTLENGTH");
        this.SEGMENTTHICK = Aladin.chaine.getString("PROPSEGMENTTHICK");
        this.SEGMENTDENSITY = Aladin.chaine.getString("PROPSEGMENTDENSITY");
        this.SCALINGFACTOR = Aladin.chaine.getString("PROPSCALINGFACTOR");
        this.POINTING = Aladin.chaine.getString("PROPPOINTING");
        this.POINTINGLABEL = Aladin.chaine.getString("PROPPOINTINGLABEL");
        this.FULLDESCR = Aladin.chaine.getString("PROPFULLDESCR");
    }

    protected Properties(Plan plan) {
        this.aladin = plan.aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(this.TITLE);
        this.enableEvents(64L);
        Util.setCloseShortcut(this, true, this.aladin);
        this.plan = plan;
        Properties.addProperties(this);
        int n = frameProp.size();
        Point point = Aladin.computeLocation(this);
        point.x += n * 20;
        point.y += n * 20;
        this.setLocation(point);
    }

    void showProp() {
        this.showProp(false);
    }

    void showProp(boolean bl) {
        Plan plan = this.plan;
        this.flagHide = false;
        if (!bl && this.pmemo != null && this.hcmemo == plan.hashCode() && this.pmemo.equals(plan)) {
            if (this.isShowing()) {
                return;
            }
            this.setVisible(true);
            return;
        }
        boolean bl2 = this.pmemo != null && this.pmemo.type == plan.type && this.pmemo.flagOk == plan.flagOk && this.pmemo.projd == plan.projd;
        this.pmemo = new PlanFree(this.aladin);
        this.pmemo.objet = plan.objet == null ? null : new String(plan.objet);
        this.pmemo.type = plan.type;
        this.pmemo.param = plan.param == null ? null : new String(plan.param);
        this.pmemo.error = plan.error == null ? null : new String(plan.error);
        this.pmemo.flagOk = plan.flagOk;
        this.pmemo.projd = plan.projd;
        this.hcmemo = plan.hashCode();
        this.sourceType = null;
        this.couleur = null;
        this.sEquinox = null;
        this.sField = null;
        this.rollField = null;
        this.eqField = null;
        this.epField = null;
        this.rotateCenter = null;
        if (this.panel != null) {
            this.remove(this.panel);
        }
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(5, 5));
        this.propPanel = this.getPanelProperties();
        JScrollPane jScrollPane = new JScrollPane(this.propPanel, 20, 31);
        Aladin.makeAdd(this.panel, jScrollPane, "Center");
        this.setTitre(this.BANNER + " \"" + this.plan.label + "\"");
        Aladin.makeAdd(this.panel, this.getPanelValid(), "South");
        Aladin.makeAdd(this, this.panel, "Center");
        if (!bl2) {
            this.pack();
        }
        this.setVisible(true);
    }

    protected JPanel getPanelValid() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        JButton jButton = new JButton(this.APPLY);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setFont(jButton.getFont().deriveFont(1));
        if (this.plan.getBookmarkCode() != null) {
            jPanel.add(new JLabel(" "));
            jButton = new JButton(this.BOOKMARK);
            jPanel.add(jButton);
            jButton.addActionListener(this);
        }
        jButton = new JButton(this.CLOSE);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        return jPanel;
    }

    private JPanel getPanelFilter(Plan plan) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.filterCB = new ButtonGroup();
        JRadioButton jRadioButton = this.nofilter = new JRadioButton(this.NOFILTER);
        jRadioButton.setActionCommand(this.NOFILTER);
        jRadioButton.addActionListener(this);
        this.filterCB.add(jRadioButton);
        jRadioButton.setSelected(true);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jRadioButton);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        for (int i = 0; i < plan.filters.length; ++i) {
            String string = ServerGlu.getFilterDescription(plan.filters[i]);
            if (string == null) {
                string = ServerGlu.getFilterName(plan.filters[i]);
            }
            if (string == null) continue;
            jRadioButton = new JRadioButton(string);
            jRadioButton.setMargin(gridBagConstraints.insets);
            jRadioButton.setActionCommand(string);
            jRadioButton.addActionListener(this);
            this.filterCB.add(jRadioButton);
            if (plan.filterIndex == i) {
                jRadioButton.setSelected(true);
            }
            jPanel2 = new JPanel(new FlowLayout(0));
            jPanel2.add(jRadioButton);
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
        }
        return jPanel;
    }

    protected JPanel getPanelProperties() {
        Object object;
        Object object2;
        String string;
        int n;
        JButton jButton;
        Object object3;
        String string2;
        Object object4;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 0, 5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.label = new JTextField(this.plan.label, 15);
        this.label.setMinimumSize(this.label.getPreferredSize());
        PropPanel.addCouple(jPanel, this.LABEL, this.label, gridBagLayout, gridBagConstraints);
        if (this.plan.verboseDescr != null || this.plan.description != null) {
            PropPanel.addCouple(jPanel, "Description: ", new Anchor(this.plan.description, 50, this.plan.verboseDescr, null), gridBagLayout, gridBagConstraints);
        }
        if (this.plan.ack != null) {
            PropPanel.addCouple(jPanel, "Acknowledgment: ", new Anchor(null, 40, this.plan.ack, null), gridBagLayout, gridBagConstraints);
        }
        if (!(this.plan instanceof PlanBG) || ((PlanBG)this.plan).getProperty("obs_copyright") == null && ((PlanBG)this.plan).getProperty("obs_copyright_url") == null) {
            Object object5 = object4 = this.plan.copyright == null ? this.plan.copyrightUrl : this.plan.copyright;
            if (object4 != null) {
                PropPanel.addCouple(jPanel, this.ORIGIN, new Anchor((String)object4, 40, null, this.plan.copyrightUrl), gridBagLayout, gridBagConstraints);
            }
        }
        if (this.plan instanceof PlanBG) {
            object4 = (PlanBG)this.plan;
            string2 = ((PlanBG)object4).getProperty("bib_reference");
            object3 = ((PlanBG)object4).getProperty("bib_reference_url");
            if (string2 != null || object3 != null) {
                PropPanel.addCouple(jPanel, "Bib. reference", new Anchor(string2, 40, null, (String)object3), gridBagLayout, gridBagConstraints);
            }
            if (((PlanBG)this.plan).id != null) {
                PropPanel.addCouple(jPanel, "IVOID: ", new JLabel("ivo://" + ((PlanBG)this.plan).id), gridBagLayout, gridBagConstraints);
            }
            if ((string2 = ((PlanBG)object4).getProperty("hips_creator")) == null) {
                string2 = ((PlanBG)object4).getProperty("hips_publisher");
            }
            if (string2 == null) {
                string2 = ((PlanBG)object4).getProperty("creator_id");
            }
            if (string2 == null) {
                string2 = ((PlanBG)object4).getProperty("publisher_id");
            }
            if (string2 == null) {
                string2 = ((PlanBG)object4).getCreatorFromId();
            }
            if (string2 != null) {
                PropPanel.addCouple(jPanel, "HiPS creator", new JLabel(string2), gridBagLayout, gridBagConstraints);
            }
            if ((string2 = ((PlanBG)object4).getProperty("hips_release_date")) != null) {
                PropPanel.addCouple(jPanel, "Release date", new JLabel(string2), gridBagLayout, gridBagConstraints);
            }
        }
        if (!this.plan.isImage() && this.plan.type != 16 && this.plan.type != 11 && !(this.plan instanceof PlanContour)) {
            this.couleur = new Couleur(this.plan.c);
            PropPanel.addCouple(jPanel, this.COLOR, this.couleur, gridBagLayout, gridBagConstraints);
            this.couleur.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Properties.this.actionCouleur();
                }
            });
        }
        if (this.plan instanceof PlanContour) {
            this.couleur = new Couleur(PlanContour.couleursBase, this.plan.c, 25, 4);
            PropPanel.addCouple(jPanel, this.COLOR, this.couleur, gridBagLayout, gridBagConstraints);
        }
        if (!this.plan.flagOk) {
            object4 = new JLabel();
            ((JComponent)object4).setForeground(Color.red);
            ((JComponent)object4).setFont(((Component)object4).getFont().deriveFont(1));
            if (this.plan.error != null) {
                string2 = this.ERROR;
                ((JLabel)object4).setText(this.plan.error);
            } else {
                string2 = this.STATE;
                ((JLabel)object4).setText(this.UNDER);
            }
            PropPanel.addCouple(jPanel, string2, (Component)object4, gridBagLayout, gridBagConstraints);
        }
        if (this.plan.flagOk) {
            if (this.plan.isCatalog()) {
                this.sourceType = new JComboBox();
                for (int i = 0; i < Source.TYPENAME.length; ++i) {
                    this.sourceType.addItem(Source.TYPENAME[i]);
                }
                this.sourceType.setSelectedIndex(this.plan.sourceType);
                PropPanel.addCouple(jPanel, this.SHAPE, this.sourceType, gridBagLayout, gridBagConstraints);
                this.sourceType.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Properties.this.actionSourceType();
                    }
                });
            }
            if (this.plan.type == 11) {
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new FlowLayout(0));
                this.scope = new ButtonGroup();
                boolean bl = ((PlanFolder)this.plan).localScope;
                this.scopeGlobal = new JRadioButton(this.GLOBAL);
                this.scope.add(this.scopeGlobal);
                this.scopeGlobal.setSelected(!bl);
                this.scopeLocal = new JRadioButton(this.LOCAL);
                this.scope.add(this.scopeLocal);
                jPanel2.add(this.scopeGlobal);
                jPanel2.add(this.scopeLocal);
                jButton = new JButton(" ? ");
                jPanel2.add(jButton);
                jButton.addActionListener(this);
                PropPanel.addCouple(jPanel, this.SCOPE, jPanel2, gridBagLayout, gridBagConstraints);
            } else {
                this.scope = null;
            }
            if (this.plan instanceof PlanContour) {
                PlanContour planContour = (PlanContour)this.plan;
                PropPanel.addCouple(jPanel, this.IMG, new JLabel(planContour.p.label + " - " + planContour.p.objet), gridBagLayout, gridBagConstraints);
                int[] nArray = planContour.getIntLevels();
                this.contoursCB = new JCheckBox[nArray.length];
                this.contoursCouleurs = new Couleur[nArray.length];
                int n2 = 330;
                int n3 = 200;
                this.panelScroll = new JPanel();
                this.panelScroll.setLayout(gridBagLayout);
                for (int i = 0; i < nArray.length; ++i) {
                    this.contoursCB[i] = new JCheckBox(this.VIEWABLE, planContour.isViewable(i));
                    this.contoursCB[i].addActionListener(this);
                    this.panelCont = new JPanel();
                    this.panelCont.add(this.contoursCB[i]);
                    this.contoursCouleurs[i] = new Couleur(planContour.couleursContours[i], 15, 3, Couleur.getBrighterColors(planContour.c, 4));
                    this.panelCont.add(this.contoursCouleurs[i]);
                    String string3 = i == 0 ? "1st" : (i == 1 ? "2nd" : (i == 2 ? "3rd" : i + 1 + "th"));
                    PropPanel.addCouple(this.panelScroll, string3 + " level", this.panelCont, gridBagLayout, gridBagConstraints);
                }
                this.scroll = new JScrollPane(this.panelScroll);
                this.scroll.setSize(n2, n3);
                gridBagLayout.setConstraints(this.scroll, gridBagConstraints);
                jPanel.add(this.scroll);
                Histogramme histogramme = new Histogramme((PlanImage)planContour.p);
                PropPanel.addCouple(jPanel, this.LEVEL, histogramme, gridBagLayout, gridBagConstraints);
                this.curs = new Curseur(histogramme);
                this.curs.nbNiveaux = nArray.length;
                this.curs.couleurTriangle = planContour.couleursContours;
                for (n = 0; n < nArray.length; ++n) {
                    this.curs.niveaux[n] = nArray[n];
                }
                PropPanel.addCouple(jPanel, "", this.curs, gridBagLayout, gridBagConstraints);
            }
            if (this.plan.isCatalog() || this.plan.isImage()) {
                PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
            }
        }
        if (this.plan.type == 10) {
            JPanel jPanel3;
            final PlanField planField = (PlanField)this.plan;
            this.sField = planField.getProjCenter();
            this.centerField = new JTextField(this.sField, 25);
            if (!planField.isMovable()) {
                this.centerField.setEnabled(false);
            }
            PropPanel.addCouple(jPanel, this.REFCOORD, this.centerField, gridBagLayout, gridBagConstraints);
            if (Aladin.ROTATEFOVCENTER) {
                this.rotateCenterField = planField.getRotCenter();
                JPanel jPanel4 = new JPanel(new BorderLayout(0, 0));
                this.rotateCenter = new JTextField(this.rotateCenterField, 25);
                this.rotateCenter.setEnabled(planField.isRollable() & planField.isCenterRollable());
                jPanel4.add((Component)this.rotateCenter, "Center");
                object3 = new JCheckBox();
                ((AbstractButton)object3).setSelected(planField.isCenterRollable());
                ((AbstractButton)object3).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = !planField.isCenterRollable();
                        planField.setCenterRollable(bl);
                        if (!bl) {
                            planField.resetRotCenterObjet();
                            Properties.this.rotateCenter.setText(planField.getRotCenter());
                            Properties.this.rotateCenterField = "";
                            Properties.this.apply();
                        }
                        Properties.this.rotateCenter.setEnabled(planField.isRollable() & planField.isCenterRollable());
                    }
                });
                jPanel4.add((Component)object3, "East");
                PropPanel.addCouple(jPanel, this.REFROTATE, jPanel4, gridBagLayout, gridBagConstraints);
            }
            this.sRoll = planField.getRoll();
            this.rollField = new JTextField(this.sRoll, 4);
            if (!planField.isRollable()) {
                this.rollField.setEnabled(false);
            }
            PropPanel.addCouple(jPanel, this.ANGLE, this.rollField, gridBagLayout, gridBagConstraints);
            if (planField.isAlmaFP()) {
                JButton jButton2 = new JButton(this.POINTINGLABEL);
                jButton2.addActionListener(this);
                PropPanel.addCouple(jPanel, this.POINTING, jButton2, gridBagLayout, gridBagConstraints);
            }
            if ((jPanel3 = planField.getPanelSubFov(this)) != null) {
                PropPanel.addCouple(jPanel, this.COMPONENT, jPanel3, gridBagLayout, gridBagConstraints);
            }
        } else {
            this.centerField = null;
        }
        if (this.plan.isSimpleCatalog()) {
            PropPanel.addCouple(jPanel, this.SOURCE + ":", new JLabel("" + ((PlanCatalog)this.plan).getCounts()), gridBagLayout, gridBagConstraints);
        }
        if (this.plan instanceof PlanFolder && ((PlanFolder)this.plan).headerFits != null || this.plan instanceof PlanCatalog && ((PlanCatalog)this.plan).headerFits != null) {
            jButton = new JButton(this.SEEFITS);
            PropPanel.addCouple(jPanel, "Fits extension", jButton, gridBagLayout, gridBagConstraints);
            jButton.addActionListener(this);
        }
        if (this.plan.isImage() || this.plan instanceof PlanBG) {
            PlanImage planImage = (PlanImage)this.plan;
            String string4 = planImage.survey();
            if (string4 != null && string4.length() > 0) {
                PropPanel.addCouple(jPanel, this.INF, new JLabel(planImage.survey()), gridBagLayout, gridBagConstraints);
            }
            object3 = new JLabel(this.plan instanceof PlanHealpix ? "HEALPix map" : (this.plan instanceof PlanMoc ? "Multi-Order Coverage map (MOC)" : (this.plan instanceof PlanBG ? "HiPS" : PlanImage.describeFmtRes(planImage.dis, planImage.res))));
            if (planImage.headerFits != null) {
                JPanel jPanel5 = new JPanel();
                jPanel5.setLayout(new FlowLayout(0));
                jPanel5.add((Component)object3);
                jButton = new JButton(this.SEEFITS);
                jPanel5.add(jButton);
                jButton.addActionListener(this);
                PropPanel.addCouple(jPanel, this.FMT, jPanel5, gridBagLayout, gridBagConstraints);
            } else if (planImage instanceof PlanBG && ((PlanBG)planImage).prop != null) {
                JPanel jPanel6 = new JPanel();
                jPanel6.setLayout(new FlowLayout(0));
                jPanel6.add((Component)object3);
                jButton = new JButton(this.SEEHIPSPROP);
                jPanel6.add(jButton);
                jButton.addActionListener(this);
                PropPanel.addCouple(jPanel, this.FMT, jPanel6, gridBagLayout, gridBagConstraints);
            } else {
                PropPanel.addCouple(jPanel, this.FMT, (Component)object3, gridBagLayout, gridBagConstraints);
            }
            if (planImage.isImage()) {
                PropPanel.addCouple(jPanel, this.PIXMODE, new JLabel(planImage.getPixModeInfo()), gridBagLayout, gridBagConstraints);
                if (this.plan.flagOk && this.plan.projd != null) {
                    String string5 = Coord.getUnit(this.plan.projd.c.GetResol()[0]) + " x " + Coord.getUnit(this.plan.projd.c.GetResol()[1]);
                    PropPanel.addCouple(jPanel, "Pixel angular res.", new JLabel(string5), gridBagLayout, gridBagConstraints);
                    double d = this.plan.projd.c.GetEpoch();
                    if (!Double.isNaN(d)) {
                        PropPanel.addCouple(jPanel, this.EPOCH, new JLabel(Astrodate.JDToDate(Astrodate.YdToJD(d)) + " (" + d + ")"), gridBagLayout, gridBagConstraints);
                    } else {
                        String string6 = ((PlanImage)this.plan).getDateObs();
                        if (string6 != null) {
                            PropPanel.addCouple(jPanel, this.DATEOBS, new JLabel(string6), gridBagLayout, gridBagConstraints);
                        }
                    }
                    double d2 = this.plan.projd.c.GetEquinox();
                    if (d2 != 0.0) {
                        d2 = (double)((int)(d2 * 1000.0)) / 1000.0;
                        PropPanel.addCouple(jPanel, this.WCSEQ, new JLabel("" + d2), gridBagLayout, gridBagConstraints);
                    } else {
                        this.sEquinox = "2000.0";
                        this.eqField = new JTextField(this.sEquinox);
                        PropPanel.addCouple(jPanel, this.WCSEQ, this.eqField, gridBagLayout, gridBagConstraints);
                    }
                }
                if (planImage.width != 0 && !(planImage instanceof PlanBG)) {
                    PropPanel.addCouple(jPanel, this.SIZE, new JLabel(planImage.getSizeInfo()), gridBagLayout, gridBagConstraints);
                }
            }
        }
        if (this.plan.hasAvailablePixels()) {
            final PlanImage planImage = (PlanImage)this.plan;
            String string7 = planImage.getBlankString();
            this.blankField = new TextField(string7);
            this.blankField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Properties.this.actionBlank();
                    Properties.this.blankField.setText(planImage.getBlankString());
                    Properties.this.aladin.calque.repaintAll();
                }
            });
            PropPanel.addCouple(jPanel, "Transparency", this.blankField, gridBagLayout, gridBagConstraints);
        }
        if (this.plan.isCube()) {
            PropPanel.addCouple(jPanel, this.FRAME, new JLabel(this.plan.getDepth() + ""), gridBagLayout, gridBagConstraints);
        }
        if (this.plan instanceof PlanImageBlink) {
            final PlanImageBlink planImageBlink = (PlanImageBlink)this.plan;
            JPanel jPanel7 = new JPanel(new FlowLayout());
            object3 = new JButton("XxY->Z");
            ((AbstractButton)object3).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((JButton)actionEvent.getSource()).setEnabled(false);
                    planImageBlink.permutation(0);
                }
            });
            ((AbstractButton)object3).setEnabled(planImageBlink.getPermutation() != 0);
            jPanel7.add((Component)object3);
            object3 = new JButton("XxZ->Y");
            ((AbstractButton)object3).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((JButton)actionEvent.getSource()).setEnabled(false);
                    planImageBlink.permutation(1);
                }
            });
            ((AbstractButton)object3).setEnabled(planImageBlink.getPermutation() != 1);
            jPanel7.add((Component)object3);
            object3 = new JButton("ZxY->X");
            ((AbstractButton)object3).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((JButton)actionEvent.getSource()).setEnabled(false);
                    planImageBlink.permutation(2);
                }
            });
            ((AbstractButton)object3).setEnabled(planImageBlink.getPermutation() != 2);
            jPanel7.add((Component)object3);
            PropPanel.addCouple(jPanel, "Permutations", jPanel7, gridBagLayout, gridBagConstraints);
        }
        if ((string = this.plan.getUrl()) != null && (string.startsWith("http://") || string.startsWith("ftp://"))) {
            PropPanel.addCouple(jPanel, "Url: ", new Anchor(string, 50, null, string), gridBagLayout, gridBagConstraints);
        }
        if (this.plan.isCatalog()) {
            Vector<Legende> vector = this.plan.getLegende();
            jButton = new JButton(this.SEEPARSING);
            jButton.addActionListener(this);
            int n4 = vector.size();
            if (n4 == 1) {
                PropPanel.addCouple(jPanel, this.TABLEINFO, jButton, gridBagLayout, gridBagConstraints);
            } else {
                StringBuffer stringBuffer = new StringBuffer("<html>");
                for (int i = 0; i < vector.size(); ++i) {
                    stringBuffer.append((i > 0 ? "<br>" : "") + (i + 1) + ": " + vector.elementAt((int)i).name);
                }
                stringBuffer.append("</html>");
                PropPanel.addCouple(jPanel, this.TABLEINFO, new JLabel(stringBuffer.toString()), gridBagLayout, gridBagConstraints);
                PropPanel.addCouple(jPanel, "", jButton, gridBagLayout, gridBagConstraints);
            }
        }
        if (this.plan.filters != null) {
            PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
            JLabel jLabel = new JLabel(this.FILTER);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            gridBagConstraints.fill = 0;
            PropPanel.addCouple(jPanel, jLabel, this.getPanelFilter(this.plan), gridBagLayout, gridBagConstraints);
            gridBagConstraints.fill = 1;
            this.toGenFilterButton = jButton = new JButton("This filter on the stack for editing");
            jButton.addActionListener(this);
            if (!Aladin.OUTREACH) {
                PropPanel.addCouple(jPanel, "", this.toGenFilterButton, gridBagLayout, gridBagConstraints);
            }
            this.toGenFilterButton.setEnabled(this.plan.hasDedicatedFilter());
        }
        if (this.plan instanceof PlanHealpix) {
            final PlanHealpix planHealpix = (PlanHealpix)this.plan;
            if (planHealpix.type == 17) {
                PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
                PropPanel.addSectionTitle(jPanel, this.POLAOPTIONS, gridBagLayout, gridBagConstraints);
                this.polaSegmentLen = new JSlider(0, 200);
                this.polaSegmentLen.setValue((int)planHealpix.getSegmentLenFactor() * 200);
                this.polaSegmentLen.setPaintTicks(true);
                this.polaSegmentLen.addChangeListener(this);
                PropPanel.addCouple(jPanel, this.SEGMENTLEN, this.polaSegmentLen, gridBagLayout, gridBagConstraints);
                this.polaSegmentThickness = new JSlider(1, 5);
                this.polaSegmentThickness.setValue(planHealpix.getSegmentThickness());
                this.polaSegmentThickness.setMajorTickSpacing(1);
                this.polaSegmentThickness.setPaintTicks(true);
                this.polaSegmentThickness.setSnapToTicks(true);
                this.polaSegmentThickness.setPaintLabels(false);
                this.polaSegmentThickness.addChangeListener(this);
                PropPanel.addCouple(jPanel, this.SEGMENTTHICK, this.polaSegmentThickness, gridBagLayout, gridBagConstraints);
                this.polaSegmentDensity = new JSlider(0, 200);
                this.polaSegmentDensity.setValue(100);
                this.polaSegmentDensity.setMajorTickSpacing(25);
                this.polaSegmentDensity.setPaintTicks(true);
                this.polaSegmentDensity.setSnapToTicks(true);
                this.polaSegmentDensity.addChangeListener(this);
                PropPanel.addCouple(jPanel, this.SEGMENTDENSITY, this.polaSegmentDensity, gridBagLayout, gridBagConstraints);
            } else {
                if (planHealpix.tfieldNames != null && planHealpix.idxTFormToRead >= 0) {
                    PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
                    PropPanel.addCouple(jPanel, this.CURRENTFIELD, new JLabel(planHealpix.tfieldNames[planHealpix.idxTFormToRead]), gridBagLayout, gridBagConstraints);
                }
                if (planHealpix.hasPolarisationData() || planHealpix.tfieldNames.length > 1) {
                    PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
                }
                if (planHealpix.hasPolarisationData()) {
                    JPanel jPanel8 = new JPanel(new GridLayout(0, 1));
                    this.btnDisplayPola = new JButton(this.DISPLAYPOLA);
                    this.btnDisplayPola.addActionListener(this);
                    jPanel8.add(this.btnDisplayPola);
                    this.btnDisplayAmp = new JButton(this.GENERATEPOLAAMP);
                    this.btnDisplayAmp.addActionListener(this);
                    jPanel8.add(this.btnDisplayAmp);
                    this.btnDisplayAng = new JButton(this.GENERATEPOLAANG);
                    this.btnDisplayAng.addActionListener(this);
                    jPanel8.add(this.btnDisplayAng);
                    gridBagConstraints.fill = 0;
                    PropPanel.addCouple(null, jPanel, this.POLA, null, jPanel8, gridBagLayout, gridBagConstraints, 18);
                }
                if (planHealpix.tfieldNames.length > 1) {
                    JPanel jPanel9 = new JPanel(new GridLayout(0, 1));
                    JScrollPane jScrollPane = new JScrollPane(jPanel9, 20, 31);
                    jScrollPane.setPreferredSize(new Dimension(200, 300));
                    for (int i = 0; i < planHealpix.tfieldNames.length; ++i) {
                        if (i == planHealpix.idxTFormToRead) continue;
                        jButton = new JButton(planHealpix.tfieldNames[i]);
                        jPanel9.add(jButton);
                        n = i;
                        jButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                planHealpix.loadNewField(n);
                            }
                        });
                    }
                    PropPanel.addCouple(null, jPanel, this.SELECTFIELD, null, jPanel9, gridBagLayout, gridBagConstraints, 18);
                }
            }
        }
        if (this.plan.type == 16) {
            PlanBG planBG = (PlanBG)this.plan;
            PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
            long l = planBG.getMaxHealpixOrder();
            long l2 = planBG.getTileOrder();
            PropPanel.addSectionTitle(jPanel, "HiPS properties", gridBagLayout, gridBagConstraints);
            PropPanel.addCouple(jPanel, "Best pixel resolution", new JLabel(planBG.getMaxResolution()), gridBagLayout, gridBagConstraints);
            PropPanel.addCouple(jPanel, "HEALPix NSide:", new JLabel(CDSHealpix.pow2(l) + " (2^" + l + ")"), gridBagLayout, gridBagConstraints);
        }
        if (this.plan.type == 19) {
            final PlanMoc planMoc = (PlanMoc)this.plan;
            Properties properties = this;
            double d = planMoc.getMoc().getCoverage();
            double d3 = Math.toDegrees(1.0);
            double d4 = Math.PI * 4 * d3 * d3;
            long l = planMoc.getMoc().getSize();
            PropPanel.addCouple(jPanel, "Coverage: ", new JLabel(Util.round(d * 100.0, 3) + "% of sky => " + Coord.getUnit(d4 * d, false, true) + "^2"), gridBagLayout, gridBagConstraints);
            PropPanel.addCouple(jPanel, "Best MOC ang.res: ", new JLabel(Coord.getUnit(planMoc.getMoc().getAngularRes()) + " (moc order=" + planMoc.getMoc().getMocOrder() + ")"), gridBagLayout, gridBagConstraints);
            object2 = new JCheckBox("borders");
            ((AbstractButton)object2).setSelected(planMoc.isDrawingBorder());
            ((AbstractButton)object2).addActionListener(new ActionListener((JCheckBox)object2){
                final /* synthetic */ JCheckBox val$b1;
                {
                    this.val$b1 = jCheckBox;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    planMoc.setDrawingBorder(this.val$b1.isSelected());
                    Properties.this.aladin.calque.repaintAll();
                }
            });
            object = new JCheckBox("fill in");
            ((AbstractButton)object).setSelected(planMoc.isDrawingFillIn());
            ((AbstractButton)object).addActionListener(new ActionListener((JCheckBox)object){
                final /* synthetic */ JCheckBox val$b2a;
                {
                    this.val$b2a = jCheckBox;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    planMoc.setDrawingFillIn(this.val$b2a.isSelected());
                    Properties.this.aladin.calque.repaintAll();
                }
            });
            JPanel jPanel10 = new JPanel(new FlowLayout(0, 0, 0));
            jPanel10.add((Component)object2);
            jPanel10.add((Component)object);
            PropPanel.addCouple(jPanel, "Drawing method: ", jPanel10, gridBagLayout, gridBagConstraints);
        }
        if (this.plan instanceof PlanBG) {
            Object object6;
            String string8;
            final PlanBG planBG = (PlanBG)this.plan;
            PropPanel.addCouple(jPanel, "Coord.sys.:", new JLabel(Localisation.getFrameName(planBG.frameOrigin)), gridBagLayout, gridBagConstraints);
            if (this.plan.type == 16) {
                int n5 = planBG.getMaxFileOrder();
                PropPanel.addCouple(jPanel, "Number of levels", new JLabel(n5 + ""), gridBagLayout, gridBagConstraints);
                long l = planBG.getTileOrder();
                PropPanel.addCouple(jPanel, "Tile format", new JLabel(planBG.getFormat()), gridBagLayout, gridBagConstraints);
                if (l > 0L) {
                    PropPanel.addCouple(jPanel, "Tile width:", new JLabel((int)CDSHealpix.pow2(l) + " pix (2^" + l + ")"), gridBagLayout, gridBagConstraints);
                }
                if (planBG.inFits && (planBG.inJPEG || planBG.inPNG)) {
                    JButton jButton3 = new JButton(planBG.isTruePixels() ? Aladin.chaine.getString("ALLSKYSWJPEG") : Aladin.chaine.getString("ALLSKYSWFITS"));
                    jButton3.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            planBG.switchFormat();
                            Properties.this.showProp(true);
                            Properties.this.aladin.view.repaintAll();
                        }
                    });
                    PropPanel.addCouple(jPanel, "", jButton3, gridBagLayout, gridBagConstraints);
                }
            }
            String string9 = string8 = Aladin.BETA ? planBG.getNetSpeed() : null;
            if (string8 != null) {
                JLabel jLabel = new JLabel(string8);
                if (string8.indexOf("error") >= 0) {
                    jLabel.setForeground(Color.red);
                }
                PropPanel.addCouple(jPanel, "Avg net speed:", jLabel, gridBagLayout, gridBagConstraints);
            }
            String string10 = planBG.getProperty("t_min");
            String string11 = planBG.getProperty("t_max");
            String string12 = planBG.getProperty("em_min");
            String string13 = planBG.getProperty("em_max");
            String string14 = planBG.getProperty("obs_regime");
            String string15 = planBG.getProperty("moc_sky_fraction");
            boolean bl = planBG.hasMoc();
            if (string15 != null || string10 != null || string11 != null || string12 != null || string13 != null || string14 != null || string15 != null || bl) {
                PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
                PropPanel.addSectionTitle(jPanel, "Coverage", gridBagLayout, gridBagConstraints);
                if (string10 != null || string11 != null) {
                    PropPanel.addCouple(jPanel, "Time range", new JLabel(this.getCoverageTime(string10, string11)), gridBagLayout, gridBagConstraints);
                }
                if (string12 != null || string13 != null) {
                    PropPanel.addCouple(jPanel, "Energy range", new JLabel(this.getCoverageEnergy(string12, string13)), gridBagLayout, gridBagConstraints);
                }
                if (bl || string15 != null) {
                    if (string15 == null && planBG.moc != null) {
                        string15 = planBG.moc.getCoverage() + "";
                    }
                    object6 = new JPanel();
                    if (string15 != null) {
                        try {
                            string15 = Util.myRound(Double.parseDouble(string15) * 100.0);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ((Container)object6).add(new JLabel(string15 + " % of sky"));
                    }
                    if (bl) {
                        object2 = new JButton(this.aladin.MOC);
                        ((AbstractButton)object2).addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                planBG.loadMoc();
                            }
                        });
                        ((Container)object6).add((Component)object2);
                    }
                    PropPanel.addCouple(jPanel, "Space", (Component)object6, gridBagLayout, gridBagConstraints);
                }
            }
            object6 = planBG.getProperty("prov_progenitor");
            object2 = planBG.getProperty("obs_copyright");
            object = planBG.getProperty("obs_copyright_url");
            boolean bl2 = planBG.hasHpxFinder();
            if (object6 != null || object2 != null || object != null || bl2) {
                PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
                PropPanel.addSectionTitle(jPanel, "Original data", gridBagLayout, gridBagConstraints);
                if (object6 != null) {
                    PropPanel.addCouple(jPanel, "Provenance", new Anchor(null, 40, (String)object6, null), gridBagLayout, gridBagConstraints);
                }
                if (object2 != null || object != null) {
                    PropPanel.addCouple(jPanel, "Copyright", new Anchor((String)object2, 40, null, (String)object), gridBagLayout, gridBagConstraints);
                }
                if (bl2) {
                    JButton jButton4 = new JButton(Aladin.chaine.getString("PROGENITOR"));
                    jButton4.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            planBG.loadProgen();
                        }
                    });
                    JPanel jPanel11 = new JPanel();
                    jPanel11.add(jButton4);
                    PropPanel.addCouple(jPanel, "Access", jPanel11, gridBagLayout, gridBagConstraints);
                }
            }
        }
        if (this.plan.flagOk && (this.plan.isSimpleCatalog() || this.plan instanceof PlanBG)) {
            JPanel jPanel12 = this.aladin.view.getPlotControlPanelForPlan(this.plan);
            if (jPanel12 != null) {
                PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
                PropPanel.addCouple(jPanel, "Scatter plot", jPanel12, gridBagLayout, gridBagConstraints);
            } else if (this.plan.ref && Projection.isOk(this.plan.projd)) {
                this.defCatProj = new JComboBox<String>(Projection.getAlaProj());
                this.defCatProj.setSelectedIndex(Projection.getAlaProjIndex(Calib.getProjName(this.plan.projd.c.getProj())));
                this.defCatProj.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Properties.this.actionDefCatProj();
                    }
                });
                PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
                PropPanel.addSectionTitle(jPanel, this.DEFCATPROJ, gridBagLayout, gridBagConstraints);
                if (!(this.plan instanceof PlanBG)) {
                    PropPanel.addCouple(jPanel, this.CENTER, new JLabel(this.plan.projd.c.getProjCenter().getSexa()), gridBagLayout, gridBagConstraints);
                }
                PropPanel.addCouple(jPanel, this.METHOD, this.defCatProj, gridBagLayout, gridBagConstraints);
                if (this.plan.ref && this.plan instanceof PlanBG) {
                    this.defFrame = Localisation.createFrameCombo();
                    this.defFrame.setSelectedIndex(((PlanBG)this.plan).getFrameDrawing());
                    this.defFrame.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            Properties.this.actionFrameProj();
                        }
                    });
                    PropPanel.addCouple(jPanel, ".frame", this.defFrame, gridBagLayout, gridBagConstraints);
                    JPanel jPanel13 = new JPanel();
                    jPanel13.setBorder(BorderFactory.createEmptyBorder());
                    this.longitude = new ButtonGroup();
                    this.longitudeDescending = new JRadioButton("descending");
                    this.longitudeDescending.addActionListener(this);
                    this.longitude.add(this.longitudeDescending);
                    this.longitudeAscending = new JRadioButton("ascending");
                    this.longitudeAscending.addActionListener(this);
                    this.longitude.add(this.longitudeAscending);
                    jPanel13.add(this.longitudeAscending);
                    jPanel13.add(this.longitudeDescending);
                    this.longitudeAscending.setSelected(this.plan.projd.sym);
                    this.longitudeDescending.setSelected(!this.plan.projd.sym);
                    if (Aladin.BETA) {
                        PropPanel.addCouple(jPanel, ".longitude", jPanel13, gridBagLayout, gridBagConstraints);
                    }
                }
            }
        }
        boolean bl = false;
        if (this.plan.isCatalog()) {
            if (this.plan.flagOk && this.plan.projd != null && this.plan.hasPM()) {
                if (!bl) {
                    PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
                }
                bl = false;
                String string16 = this.plan.getEpoch().toString("J");
                JPanel jPanel14 = new JPanel();
                this.epField = new JTextField(string16, 10);
                this.epField.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                    }

                    @Override
                    public void keyReleased(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 10) {
                            Properties.this.apply();
                        }
                    }

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                    }
                });
                jPanel14.add(this.epField);
                jButton = new JButton("Img epoch");
                Plan plan = this.aladin.calque.getPlanBase();
                jButton.setEnabled(plan instanceof PlanImage && ((PlanImage)plan).getDateObs() != null);
                Insets insets = jButton.getMargin();
                jButton.setMargin(new Insets(insets.top, 3, insets.bottom, 3));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            Plan plan = Properties.this.aladin.calque.getPlanBase();
                            if (!(plan instanceof PlanImage)) {
                                return;
                            }
                            Astrotime astrotime = new Astrotime();
                            astrotime.set(((PlanImage)plan).getDateObs());
                            System.out.println("Epoch=" + astrotime + " => " + astrotime.toString("J"));
                            Properties.this.epField.setText(astrotime.toString("J"));
                            Properties.this.apply();
                        }
                        catch (ParseException parseException) {
                            parseException.printStackTrace();
                        }
                    }
                });
                jPanel14.add(jButton);
                jButton = new JButton("Reset");
                insets = jButton.getMargin();
                jButton.setMargin(new Insets(insets.top, 3, insets.bottom, 3));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Properties.this.epField.setText("J2000");
                        Properties.this.apply();
                    }
                });
                jPanel14.add(jButton);
                PropPanel.addCouple(jPanel, this.EPOCH, jPanel14, gridBagLayout, gridBagConstraints);
                double d = 2000.0;
                try {
                    d = Double.parseDouble(string16.substring(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.epochSlider = new JSlider(1700, 2300);
                this.epochSlider.setMinimumSize(this.epochSlider.getPreferredSize());
                this.epochSlider.setValue((int)d);
                this.epochSlider.setMajorTickSpacing(100);
                this.epochSlider.setPaintLabels(true);
                this.epochSlider.setPaintTicks(true);
                this.epochSlider.setPaintTrack(true);
                this.epochSlider.addChangeListener(this);
                PropPanel.addCouple(jPanel, "", this.epochSlider, gridBagLayout, gridBagConstraints);
            }
            if (!bl) {
                PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
            }
            bl = true;
            this.scalingFactor = new JSlider(0, 300);
            this.scalingFactor.setMinimumSize(this.scalingFactor.getPreferredSize());
            this.scalingFactor.setValue((int)this.plan.getScalingFactor() * 100);
            this.scalingFactor.setMajorTickSpacing(50);
            this.scalingFactor.setPaintLabels(true);
            this.scalingFactor.setPaintTicks(true);
            this.scalingFactor.setPaintTrack(true);
            this.scalingFactor.addChangeListener(this);
            PropPanel.addCouple(jPanel, this.SCALINGFACTOR, this.scalingFactor, gridBagLayout, gridBagConstraints);
        }
        if (this.aladin.calque.canBeTransparent(this.plan)) {
            if (!bl) {
                PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
            }
            bl = true;
            JPanel jPanel15 = new JPanel(new FlowLayout());
            this.opacityLevel = new JSlider(0, 100);
            this.opacityLevel.setValue((int)(100.0f * this.plan.getOpacityLevel()));
            this.opacityLevel.setMajorTickSpacing(20);
            this.opacityLevel.setPaintLabels(true);
            this.opacityLevel.setPaintTicks(true);
            this.opacityLevel.setPaintTrack(true);
            this.opacityLevel.setToolTipText(this.OPACITYLEVEL + " : " + this.opacityLevel.getValue());
            this.opacityLevel.addChangeListener(this);
            jPanel15.add(this.opacityLevel);
            PropPanel.addCouple(jPanel, this.OPACITY, jPanel15, gridBagLayout, gridBagConstraints);
        }
        if (this.plan instanceof PlanBGCat && !(this.plan instanceof PlanMoc)) {
            if (!bl) {
                PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
            }
            bl = true;
            JPanel jPanel16 = new JPanel(new FlowLayout());
            this.gapOrder = new JSlider(-3, 3);
            this.gapOrder.setValue(((PlanBGCat)this.plan).getGapOrder());
            this.gapOrder.setMajorTickSpacing(1);
            this.gapOrder.setPaintLabels(true);
            this.gapOrder.setPaintTicks(true);
            this.gapOrder.setPaintTrack(true);
            this.gapOrder.addChangeListener(this);
            jPanel16.add(this.gapOrder);
            PropPanel.addCouple(jPanel, this.DENSITY, jPanel16, gridBagLayout, gridBagConstraints);
        }
        if (this.plan instanceof PlanTool && !(this.plan instanceof PlanContour)) {
            this.cb = new ButtonGroup();
            JPanel jPanel17 = new JPanel();
            JRadioButton jRadioButton = new JRadioButton(this.ON);
            jRadioButton.setActionCommand(this.ON);
            this.cb.add(jRadioButton);
            jRadioButton.setSelected(this.plan.isMovable());
            jRadioButton.addActionListener(this);
            jPanel17.add(jRadioButton);
            jRadioButton = new JRadioButton(this.OFF);
            jRadioButton.setActionCommand(this.OFF);
            this.cb.add(jRadioButton);
            jRadioButton.setSelected(!this.plan.isMovable());
            jRadioButton.addActionListener(this);
            jPanel17.add(jRadioButton);
            PropPanel.addCouple(jPanel, "Movable:", jPanel17, gridBagLayout, gridBagConstraints);
        }
        if (this.plan.ref && !(this.plan instanceof PlanBG)) {
            this.cb = new ButtonGroup();
            JPanel jPanel18 = new JPanel();
            JRadioButton jRadioButton = new JRadioButton(this.WHITE);
            jRadioButton.setActionCommand(this.WHITE);
            this.cb.add(jRadioButton);
            jRadioButton.setSelected(this.plan.colorBackground == Color.white || this.plan instanceof PlanImageRGB && this.plan.colorBackground == null);
            jRadioButton.addActionListener(this);
            jPanel18.add(jRadioButton);
            jRadioButton = new JRadioButton(this.BLACK);
            jRadioButton.setActionCommand(this.BLACK);
            this.cb.add(jRadioButton);
            jRadioButton.setSelected(this.plan.colorBackground == Color.black);
            jRadioButton.addActionListener(this);
            jPanel18.add(jRadioButton);
            if (this.plan.type != 2) {
                jRadioButton = new JRadioButton(this.AUTO);
                jRadioButton.setActionCommand(this.AUTO);
                this.cb.add(jRadioButton);
                jRadioButton.setSelected(this.plan.colorBackground == null);
                jRadioButton.addActionListener(this);
                jPanel18.add(jRadioButton);
            }
            PropPanel.addCouple(jPanel, this.COLORBG, jPanel18, gridBagLayout, gridBagConstraints);
        }
        if (this.plan.flagOk && (this.plan.isImage() || this.plan.isSimpleCatalog() && this.plan.hasXYorig)) {
            PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
            String string17 = this.plan.isImage() ? this.ASTRED : (this.plan.hasXYorig ? this.XYRED : this.PROJ);
            PropPanel.addSectionTitle(jPanel, string17, gridBagLayout, gridBagConstraints);
            this.planRefChoice = null;
            this.majPlanRef();
            this.projsChoice = null;
            JButton jButton5 = jButton = new JButton(this.NEWCALIB);
            jButton.addActionListener(this);
            this.modCalib = jButton = new JButton(this.MODCALIB);
            jButton.addActionListener(this);
            this.majProjs();
            if (this.projsChoice.getItemCount() == 0) {
                this.projsChoice.addItem(this.NONE);
            }
            JPanel jPanel19 = new JPanel();
            jPanel19.add(this.projsChoice);
            jPanel19.add(jButton5);
            jPanel19.add(this.modCalib);
            PropPanel.addCouple(jPanel, "   " + this.METHOD, jPanel19, gridBagLayout, gridBagConstraints);
        }
        if (this.plan.flagOk && this.plan.isCatalog() && this.plan.hasAssociatedFootprints()) {
            PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
            PropPanel.addSectionTitle(jPanel, this.ASSFOV, gridBagLayout, gridBagConstraints);
            JPanel jPanel20 = new JPanel(new GridLayout(0, 1));
            JButton jButton6 = jButton = new JButton(this.SHOWFOVS);
            jButton.addActionListener(this);
            jPanel20.add(jButton6);
            JButton jButton7 = jButton = new JButton(this.HIDEFOVS);
            jButton.addActionListener(this);
            jPanel20.add(jButton7);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(jPanel20, gridBagConstraints);
            jPanel.add(jPanel20);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
        }
        return jPanel;
    }

    private String getCoverageTime(String string, String string2) {
        return "[ " + (string == null ? " " : Util.getDateFromMJD(string)) + " .. " + (string2 == null ? " " : Util.getDateFromMJD(string2)) + " ]";
    }

    private String getCoverageEnergy(String string, String string2) {
        return "[ " + (string == null ? " " : string) + " .. " + (string2 == null ? " " : string2) + " ]";
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.opacityLevel) {
            float f = (float)((double)this.opacityLevel.getValue() / 100.0);
            this.plan.setOpacityLevel(f);
            this.opacityLevel.setToolTipText(this.OPACITYLEVEL + " : " + (int)(f * 100.0f));
            this.aladin.calque.repaintAll();
        } else if (object == this.gapOrder) {
            int n = this.gapOrder.getValue();
            ((PlanBGCat)this.plan).setGapOrder(n);
            this.aladin.calque.repaintAll();
        } else if (object == this.polaSegmentLen) {
            float f = (float)((double)this.polaSegmentLen.getValue() / 100.0);
            ((PlanBG)this.plan).setSegmentLenFactor(f);
            this.aladin.calque.repaintAll();
        } else if (object == this.polaSegmentThickness) {
            int n;
            int n2 = this.polaSegmentThickness.getValue();
            if (n2 == (n = ((PlanBG)this.plan).getSegmentThickness())) {
                return;
            }
            ((PlanBG)this.plan).setSegmentThickness(n2);
            this.aladin.calque.repaintAll();
        } else if (object == this.polaSegmentDensity) {
            float f = (float)((double)(200 - this.polaSegmentDensity.getValue()) / 100.0);
            ((PlanBG)this.plan).setSegmentDensityFactor(f);
            this.aladin.calque.repaintAll();
        } else if (object == this.scalingFactor) {
            float f = (float)((double)this.scalingFactor.getValue() / 100.0);
            this.plan.setScalingFactor(f);
            this.aladin.calque.repaintAll();
        } else if (object == this.epochSlider) {
            try {
                this.plan.setEpoch(this.epochSlider.getValue() + "");
                this.epField.setText(this.plan.getEpoch().toString("J"));
                this.aladin.calque.repaintAll();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void majPlanRef() {
        if (!this.plan.isCatalog() && !this.plan.isImage()) {
            return;
        }
        int n = 0;
        this.planRef = this.plan.getAvailablePlanRef();
        if (this.planRefChoice == null) {
            this.planRefChoice = new JComboBox();
        }
        this.planRefChoice.removeAll();
        if (this.planRef.length > 0) {
            for (int i = 0; i < this.planRef.length; ++i) {
                String string = Plan.Tp[this.planRef[i].type] + " \"" + this.planRef[i].label + "\"";
                this.planRefChoice.addItem(string);
                if (!this.planRef[i].ref) continue;
                n = i;
            }
            this.planRefChoice.setSelectedIndex(n);
        }
    }

    protected void majProjInitCat() {
        if (!this.plan.isCatalog()) {
            return;
        }
    }

    protected void majProjs() {
        if (!this.plan.isCatalog() && !this.plan.isImage() || this.planRef == null) {
            return;
        }
        int n = 0;
        Plan plan = null;
        if (this.plan.hasXYorig) {
            this.projs = this.plan.getAvailableProj();
        } else if (this.planRefChoice.getSelectedIndex() >= 0) {
            plan = this.planRef[this.planRefChoice.getSelectedIndex()];
            this.projs = plan.getAvailableProj();
        }
        if (this.projsChoice == null) {
            this.projsChoice = new JComboBox();
        }
        this.projsChoice.removeAllItems();
        if (this.projs != null && this.projs.length > 0) {
            for (int i = 0; i < this.projs.length; ++i) {
                this.projsChoice.addItem(this.projs[i].label);
                if (this.plan.hasXYorig) {
                    if (this.plan.projd != this.projs[i]) continue;
                    n = i;
                    continue;
                }
                if (plan == null || plan.projd != this.projs[i]) continue;
                n = i;
            }
            this.projsChoice.setSelectedIndex(n);
            if (this.modCalib != null) {
                this.modCalib.setEnabled(n >= 0 && this.projs[n].isModifiable());
            }
            this.projsChoice.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Properties.this.actionDefCatProj();
                }
            });
        } else if (this.modCalib != null) {
            this.modCalib.setEnabled(false);
        }
    }

    private void actionBlank() {
        ((PlanImage)this.plan).setBlankString(this.blankField.getText());
        this.showProp(true);
    }

    private void actionDefCatProj() {
        if (this.defCatProj == null || this.plan.projd.c.getProj() == Calib.getProjType((String)this.defCatProj.getSelectedItem())) {
            return;
        }
        this.plan.modifyProj((String)this.defCatProj.getSelectedItem());
    }

    private void actionFrameProj() {
        if (!(this.plan instanceof PlanBG) || this.defFrame == null || ((PlanBG)this.plan).getFrameDrawing() == this.defFrame.getSelectedIndex()) {
            return;
        }
        ((PlanBG)this.plan).setFrameDrawing(this.defFrame.getSelectedIndex());
        if (this.defFrame.getSelectedIndex() != 0) {
            Aladin.info(this, Aladin.chaine.getString("PROPFRAMEINFO"));
        }
    }

    private void actionCouleur() {
        Color color;
        if (this.couleur == null) {
            return;
        }
        if (!(this.plan instanceof PlanContour) && this.plan.c != (color = this.couleur.getCouleur())) {
            this.plan.c = color;
            this.aladin.calque.repaintAll();
        }
    }

    private void actionSourceType() {
        if (this.sourceType == null) {
            return;
        }
        this.plan.setSourceType(this.sourceType.getSelectedIndex());
        this.aladin.calque.repaintAll();
    }

    private void actionPlanXYProjs() {
        if (this.projsChoice == null || this.projsChoice.getSelectedIndex() < 0) {
            return;
        }
        Projection projection = this.projs[this.projsChoice.getSelectedIndex()];
        this.plan.pcat.setCoord(projection);
        this.plan.setNewProjD(projection);
        this.plan.setHasSpecificCalib();
        this.aladin.view.newView(1);
        this.aladin.calque.repaintAll();
    }

    private void actionPlanRefProjs() {
        if (this.planRefChoice.getSelectedIndex() < 0 || this.projsChoice == null || this.projsChoice.getSelectedIndex() < 0) {
            return;
        }
        Plan plan = this.planRef[this.planRefChoice.getSelectedIndex()];
        boolean bl = false;
        if (this.projsChoice.getSelectedIndex() < 0 || this.projsChoice.getSelectedIndex() >= this.projs.length) {
            return;
        }
        Projection projection = this.projs[this.projsChoice.getSelectedIndex()];
        if (plan.projd != projection) {
            Aladin.trace(2, "New proj. method for plane " + plan.label + " => " + projection.label);
            plan.projd = projection;
            bl = true;
        }
        if (!bl) {
            return;
        }
        this.aladin.view.newView(1);
        this.aladin.calque.repaintAll();
        this.majPlanRef();
    }

    private void bookmark() {
        FrameBookmarks frameBookmarks = this.aladin.bookmarks.getFrameBookmarks();
        frameBookmarks.setVisibleEdit();
        String string = this.aladin.bookmarks.getUniqueName(this.plan.label);
        String string2 = this.plan.getBookmarkCode();
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 != null && string2.indexOf("$TARGET") >= 0) {
            stringBuffer.append("$TARGET");
        }
        if (string2 != null && string2.indexOf("$RADIUS") >= 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("$RADIUS");
        }
        String string3 = stringBuffer.length() > 0 ? stringBuffer.toString() : null;
        frameBookmarks.createNewBookmark(string, string3, "Load " + this.plan.label + (string3 != null ? "" : " on current position"), string2);
    }

    private void apply() {
        String string;
        String string2;
        Object object;
        PlanContour planContour;
        int n;
        Properties.setFlagFullMaj(true);
        if (this.label != null && !this.label.getText().equals(this.plan.label)) {
            this.plan.setLabel(this.label.getText());
            this.label.setText(this.plan.label);
            this.setTitre(this.BANNER + " \"" + this.plan.label + "\"");
        }
        if (this.blankField != null) {
            this.actionBlank();
        }
        if (this.longitude != null && this.plan.projd != null && this.plan.projd.sym != (n = this.longitudeAscending.isSelected())) {
            this.plan.projd.setProjSym(n != 0);
            this.aladin.view.newView();
        }
        this.actionDefCatProj();
        this.actionFrameProj();
        if (this.planRefChoice != null) {
            if (this.plan.hasXYorig) {
                this.actionPlanXYProjs();
            } else {
                this.actionPlanRefProjs();
            }
        }
        this.actionCouleur();
        if (this.scope != null && ((PlanFolder)this.plan).localScope != (n = this.scopeLocal.isSelected())) {
            ((PlanFolder)this.plan).localScope = n;
            this.aladin.calque.repaintAll();
        }
        if (this.plan instanceof PlanContour) {
            planContour = (PlanContour)this.plan;
            int n2 = planContour.getIntLevels().length;
            for (n = 0; n < n2; ++n) {
                planContour.setViewable(n, this.contoursCB[n].isSelected());
                planContour.adjustColor(this.contoursCouleurs[n].getCouleur(), n);
            }
            object = new double[this.curs.niveaux.length];
            for (n = 0; n < ((double[])object).length; ++n) {
                object[n] = this.curs.niveaux[n];
            }
            planContour.adjustContour((double[])object);
            this.curs.repaint();
            Color color = this.couleur.getCouleur();
            planContour.updateColorIfNeeded(color);
            this.pmemo = null;
            this.showProp();
        }
        if (this.centerField != null) {
            String string3;
            String string4 = this.centerField.getText();
            planContour = this.rollField != null ? this.rollField.getText() : null;
            String string5 = string3 = this.rotateCenter != null ? this.rotateCenter.getText() : null;
            if (!string4.equals(this.sField) || planContour != null && !((String)((Object)planContour)).equals(this.sRoll) || string3 != null && !string3.equals(this.rotateCenterField)) {
                try {
                    double d;
                    object = new Coord(this.aladin.localisation.getICRSCoord(string4));
                    double d2 = d = planContour == null ? 0.0 : Double.valueOf((String)((Object)planContour));
                    if ((string3 == null || string3.equals(this.rotateCenterField)) && planContour != null && ((String)((Object)planContour)).equals(this.sRoll)) {
                        ((PlanField)this.plan).changeTarget(object.al, object.del);
                    } else {
                        Coord coord = new Coord(this.aladin.localisation.getICRSCoord(string3 != null ? string3 : string4));
                        ((PlanField)this.plan).setParameters(object.al, object.del, coord.al, coord.del, d);
                    }
                    this.aladin.view.newView();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Aladin.warning(this, Aladin.chaine.getString("COORDERR"));
                }
            }
        }
        if (this.eqField != null && !(string2 = this.eqField.getText()).equals(this.sEquinox)) {
            ((PlanImage)this.plan).projd.c.SetEquinox(Double.valueOf(string2));
            this.aladin.view.newView(1);
        }
        if (this.epField != null && !(string = this.epField.getText()).equals(this.plan.getEpoch().getJyr())) {
            try {
                this.plan.setEpoch(string);
                this.epField.setText(this.plan.getEpoch().toString("J"));
                this.epField.setForeground(Color.black);
                this.aladin.view.newView(1);
            }
            catch (Exception exception) {
                Aladin.warning(this, "Proper motion adjustement error\n=>" + exception.getMessage());
                this.epField.setForeground(Color.red);
            }
        }
        this.actionSourceType();
        this.aladin.calque.repaintAll();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Object object = actionEvent.getSource();
        String string2 = string = object instanceof JButton ? ((JButton)object).getActionCommand() : "";
        if (object == this.toGenFilterButton) {
            this.plan.toGenericalFilter();
            this.nofilter.setSelected(true);
            return;
        }
        if (object == this.btnDisplayPola || object == this.btnDisplayAmp || object == this.btnDisplayAng) {
            int n = object == this.btnDisplayPola ? -42 : (object == this.btnDisplayAmp ? -41 : -40);
            ((PlanHealpix)this.plan).displayPolarisation(n);
        }
        if (object instanceof JCheckBox && this.plan instanceof PlanField && ((PlanField)this.plan).switchCheckbox((JCheckBox)object)) {
            return;
        }
        if (object instanceof JCheckBox && this.plan instanceof PlanContour) {
            this.apply();
            return;
        }
        if (object instanceof JRadioButton && this.plan.isCatalog() && this.filterCB != null) {
            String string3 = this.filterCB.getSelection().getActionCommand();
            int n = ServerGlu.getFilterIndex(this.plan.filters, string3);
            this.toGenFilterButton.setEnabled(n >= 0);
            this.plan.setFilter(n);
        } else if (object instanceof JRadioButton && this.plan instanceof PlanTool) {
            String string4 = ((JRadioButton)object).getActionCommand();
            try {
                ((PlanTool)this.plan).setMovable(string4);
            }
            catch (Exception exception) {}
        } else {
            if (object instanceof JRadioButton && this.plan instanceof PlanBG) {
                this.apply();
                return;
            }
            if (object instanceof JRadioButton && this.plan.ref) {
                Color color;
                String string5 = this.cb.getSelection().getActionCommand();
                Color color2 = string5 == this.WHITE ? Color.white : (color = string5 == this.BLACK ? Color.black : null);
                if (this.plan.colorBackground == color) {
                    return;
                }
                this.plan.colorBackground = color;
                this.aladin.view.repaintAll();
                return;
            }
        }
        if (this.CLOSE.equals(string)) {
            this.dispose();
        } else if (" ? ".equals(string)) {
            Aladin.info(this, this.HSCOPE);
        } else if (this.NEWCALIB.equals(string)) {
            Plan plan = this.plan;
            this.aladin.launchRecalibImg(plan);
        } else if (this.MODCALIB.equals(string)) {
            Plan plan = this.plan;
            if (this.aladin.frameNewCalib == null) {
                this.aladin.frameNewCalib = new FrameNewCalib(this.aladin, plan, this.projs[this.projsChoice.getSelectedIndex()]);
            } else {
                this.aladin.frameNewCalib.majFrameNewCalib(plan, this.projs[this.projsChoice.getSelectedIndex()]);
            }
        } else if (this.APPLY.equals(string)) {
            this.apply();
        } else if (this.BOOKMARK.equals(string)) {
            this.bookmark();
        } else if (this.SEEFITS.equals(string)) {
            this.aladin.header(this.plan);
        } else if (this.SEEHIPSPROP.equals(string)) {
            this.aladin.header(this.plan);
        } else if (this.SEEPARSING.equals(string)) {
            this.aladin.tableInfo(this.plan);
        } else if (this.SHOWFOVS.equals(string) || this.HIDEFOVS.equals(string)) {
            boolean bl = this.SHOWFOVS.equals(string);
            this.plan.showFootprints(bl);
            if (this.plan instanceof PlanBGProgen) {
                ((PlanBGProgen)this.plan).setShowFootprint(bl);
            }
        } else if (this.POINTINGLABEL.equals(string)) {
            ((PlanField)this.plan).exportAlmaPointings();
        }
    }

    void setTitre(String string) {
        if (this.border == null) {
            this.border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, string, 2, 2, Aladin.LBOLD), BorderFactory.createEmptyBorder(5, 5, 1, 5)));
        }
        this.propPanel.setBorder(this.border);
    }

    @Override
    public void dispose() {
        frameProp.removeElement(this);
        super.dispose();
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    protected static void addProperties(Properties properties) {
        frameProp.addElement(properties);
    }

    protected static void createProperties(Plan plan) {
        Properties properties = Properties.getProperties(plan);
        if (properties != null) {
            properties.toFront();
            return;
        }
        properties = plan.type == 12 ? new FilterProperties(plan) : new Properties(plan);
        properties.showProp();
    }

    protected static void disposeProperties(Plan plan) {
        Properties properties = Properties.getProperties(plan);
        if (properties != null) {
            properties.dispose();
        }
    }

    protected static Properties getProperties(Plan plan) {
        Enumeration enumeration = frameProp.elements();
        while (enumeration.hasMoreElements()) {
            Properties properties = (Properties)enumeration.nextElement();
            if (properties.plan != plan) continue;
            return properties;
        }
        return null;
    }

    protected static synchronized void setFlagFullMaj(boolean bl) {
        flagFullMaj = bl;
    }

    protected static void majProp(Plan plan) {
        Enumeration enumeration = frameProp.elements();
        while (enumeration.hasMoreElements()) {
            Properties properties = (Properties)enumeration.nextElement();
            if (properties.plan != plan) continue;
            properties.showProp(true);
        }
    }

    protected static void majProp() {
        Properties.majProp(0);
    }

    protected static void majProp(int n) {
        Enumeration enumeration = frameProp.elements();
        while (enumeration.hasMoreElements()) {
            Properties properties = (Properties)enumeration.nextElement();
            if (properties.plan.type == 12 || !flagFullMaj && n == 1 && properties.plan.flagOk) continue;
            properties.showProp(n == 2);
            properties.majPlanRef();
            properties.majProjs();
        }
        Properties.setFlagFullMaj(false);
    }

    class Anchor
    extends JLabel {
        String url;
        String more;
        int width;

        Anchor(String string, int n, String string2, final String string3) {
            if (string == null && string2 == null && string3 != null) {
                string = string3;
            }
            if (string == null && string2 != null) {
                if (string2.length() > n) {
                    int n2 = string2.lastIndexOf(32, n);
                    if (n2 <= 0) {
                        n2 = n;
                    }
                    string = string2.substring(0, n2) + "...";
                } else {
                    string = string2;
                    string2 = null;
                }
            }
            if (string == null) {
                string = "";
            }
            this.more = string2;
            this.url = string3;
            if (n > 0) {
                if ((string.startsWith("http://") || string.startsWith("ftp://")) && string.length() > n) {
                    string = string.substring(0, n) + "...";
                } else {
                    if (string3 != null) {
                        string = Util.fold(string, n, true);
                    }
                    string = Util.fold(string, n);
                }
            }
            if (string3 != null) {
                string = "<html><A HREF=\"\">" + string + "</A></html>";
                this.setToolTipText(string3);
            }
            if (string2 != null) {
                string = "<html>" + string + " <A HREF=\"\">(more...)</A></html>";
            }
            this.setText(string);
            this.setFont(this.getFont().deriveFont(2));
            final String string4 = string2;
            if (string3 != null || string2 != null) {
                final Anchor anchor = this;
                this.addMouseMotionListener(new MouseMotionListener(){

                    @Override
                    public void mouseMoved(MouseEvent mouseEvent) {
                        Aladin.makeCursor(anchor, 2);
                    }

                    @Override
                    public void mouseDragged(MouseEvent mouseEvent) {
                    }
                });
                this.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        if ((mouseEvent.getModifiers() & 4) != 0) {
                            return;
                        }
                        if (string3 != null) {
                            Properties.this.aladin.glu.showDocument(string3);
                        } else {
                            Aladin cfr_ignored_0 = Properties.this.aladin;
                            Aladin.info(anchor, string4.replace("\\n", "\n"));
                        }
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        if ((mouseEvent.getModifiers() & 4) != 0) {
                            Anchor.this.showPopMenu(mouseEvent.getX(), mouseEvent.getY());
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        Aladin.makeCursor(anchor, 0);
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                    }
                });
            }
        }

        private void showPopMenu(int n, int n2) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.setLightWeightPopupEnabled(false);
            Aladin cfr_ignored_0 = Properties.this.aladin;
            JMenuItem jMenuItem = new JMenuItem(Aladin.chaine.getString("MFCOPYURL"));
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Properties.this.aladin.copyToClipBoard(Anchor.this.url);
                }
            });
            jPopupMenu.show(this, n, n2);
        }
    }
}

