/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import javax.swing.JComponent;

public class Rainbow
extends JComponent
implements Widget {
    static final int IN = 0;
    static final int HG = 1;
    static final int HD = 2;
    static final int BD = 3;
    static final int BG = 4;
    static final int H = 5;
    static final int D = 6;
    static final int B = 7;
    static final int G = 8;
    static final int START = 9;
    static final int[] CURSOR = new int[]{12, 6, 4, 5, 7, 8, 11, 9, 10, 5};
    static final int W = 16;
    static final int CLOSE = 0;
    protected Aladin aladin;
    protected RectangleD r;
    private boolean visible = false;
    protected double lastPos;
    protected boolean isIn = false;
    protected boolean isSelected = false;
    protected int lastButton = -1;
    private int lastPoignee = -1;
    private int dragPoignee = -1;
    private double dragX = -1.0;
    private double dragY = -1.0;
    private RectangleD closeButton = null;
    protected ColorModel cm = null;
    protected double min = 0.0;
    protected double max = 255.0;
    protected String title = null;
    private int DS = 5;
    private BufferedImage img = null;
    private Graphics g = null;
    private int oCursor = -1;
    private WidgetControl voc = null;

    public Rainbow(Aladin aladin) {
        this.aladin = aladin;
        this.visible = true;
    }

    public Rainbow(Aladin aladin, ColorModel colorModel, double d, double d2) {
        this(aladin);
        this.r = new RectangleD(10.0, 40.0, 30.0, 300.0);
        this.setCM(colorModel);
        this.setMinMax(d, d2);
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setCM(ColorModel colorModel) {
        this.cm = colorModel;
    }

    public void setMinMax(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    private double getZoom() {
        double d = this.aladin.view.getModeView();
        return d == 16.0 ? 4.0 : (d == 9.0 ? 3.0 : (d == 4.0 ? 2.0 : 1.0));
    }

    public void reset() {
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public boolean isDragging() {
        return this.visible && this.dragPoignee != -1;
    }

    public boolean isUsed() {
        return this.isIn || this.isSelected;
    }

    public boolean mouseMove(double d, double d2) {
        if (!this.visible) {
            return false;
        }
        double d3 = this.getZoom();
        this.isIn = this.r.x - 4.0 <= (d *= d3) && d <= this.r.x + this.r.width + 4.0 && this.r.y - 4.0 <= (d2 *= d3) && d2 <= this.r.y + this.r.height + 4.0;
        this.lastButton = this.getButton(d, d2);
        this.lastPoignee = this.getPoignee(d, d2);
        this.lastPos = this.r.height > this.r.width ? (this.r.y + this.r.height - d2) / this.r.height : (d - this.r.x) / this.r.width;
        return this.isIn || this.isSelected;
    }

    public boolean startDrag(double d, double d2) {
        if (!this.visible) {
            return false;
        }
        double d3 = this.getZoom();
        PointD pointD = new PointD(d *= d3, d2 *= d3);
        this.dragPoignee = this.getPoignee(pointD.x, pointD.y);
        if (this.dragPoignee == -1) {
            this.dragY = -1.0;
            this.dragX = -1.0;
            return false;
        }
        this.dragX = pointD.x;
        this.dragY = pointD.y;
        return true;
    }

    public boolean isInside(double d, double d2) {
        return this.mouseMove(d, d2);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean mouseDrag(ViewSimple viewSimple, double d, double d2, boolean bl) {
        if (!this.visible || !this.isIn) {
            return false;
        }
        double d3 = this.getZoom();
        PointD pointD = new PointD(d *= d3, d2 *= d3);
        double d4 = pointD.x;
        double d5 = pointD.y;
        double d6 = d4 - this.dragX;
        double d7 = d5 - this.dragY;
        if (bl && (this.dragPoignee == 1 || this.dragPoignee == 2 || this.dragPoignee == 4 || this.dragPoignee == 3)) {
            if (this.r.width < this.r.height) {
                this.r.width = this.r.height;
            } else {
                this.r.height = this.r.width;
            }
            if (Math.abs(d6) < Math.abs(d7)) {
                d6 = d7;
            } else {
                d7 = d6;
            }
        }
        switch (this.dragPoignee) {
            case 0: {
                this.r.x += d6;
                this.r.y += d7;
                break;
            }
            case 1: {
                this.r.x += d6;
                this.r.y += d7;
                this.r.width -= d6;
                this.r.height -= d7;
                break;
            }
            case 2: {
                this.r.y += d7;
                this.r.width += d6;
                this.r.height -= d7;
                break;
            }
            case 3: 
            case 9: {
                this.r.width += d6;
                this.r.height += d7;
                break;
            }
            case 4: {
                this.r.x += d6;
                this.r.width -= d6;
                this.r.height += d7;
                break;
            }
            case 5: {
                this.r.y += d7;
                this.r.height -= d7;
                break;
            }
            case 6: {
                this.r.width += d6;
                break;
            }
            case 7: {
                this.r.height += d7;
                break;
            }
            case 8: {
                this.r.x += d6;
                this.r.width -= d6;
                break;
            }
            default: {
                return false;
            }
        }
        if (this.r.width * viewSimple.zoom < 1.0) {
            this.r.width = 1.0 / viewSimple.zoom;
        }
        if (this.r.height * viewSimple.zoom < 1.0) {
            this.r.height = 1.0 / viewSimple.zoom;
        }
        this.dragX = d4;
        this.dragY = d5;
        return true;
    }

    public boolean submit(ViewSimple viewSimple) {
        if (this.lastButton == 0) {
            if (this == viewSimple.rainbow) {
                viewSimple.rainbow = null;
            }
            if (this == viewSimple.rainbowF) {
                viewSimple.rainbowF = null;
            }
            return true;
        }
        boolean bl = this.isSelected;
        this.isSelected = this.isIn;
        if (bl != this.isSelected) {
            return !this.isSelected;
        }
        return false;
    }

    public boolean endDrag() {
        if (this.dragPoignee == -1) {
            return false;
        }
        this.dragPoignee = -1;
        this.dragY = -1.0;
        this.dragX = -1.0;
        return true;
    }

    protected int getButton(double d, double d2) {
        double d3 = this.getZoom();
        if (this.closeButton != null && this.closeButton.contains(d /= d3, d2 /= d3)) {
            return 0;
        }
        return -1;
    }

    private int getPoignee(double d, double d2) {
        if (!this.visible) {
            return -1;
        }
        if (this.r.width == 1.0 || this.r.height == 1.0) {
            return 3;
        }
        for (int i = 1; i <= 8; ++i) {
            RectangleD rectangleD = this.getRectPoignee(i);
            if (!rectangleD.contains(d, d2)) continue;
            return i;
        }
        return this.r.contains(d, d2) ? 0 : -1;
    }

    private RectangleD getRectPoignee(int n) {
        if (!this.visible) {
            return null;
        }
        double d = 16.0;
        double d2 = d / 2.0;
        switch (n) {
            case 1: {
                return new RectangleD(this.r.x - d2, this.r.y - d2, d, d);
            }
            case 2: {
                return new RectangleD(this.r.x + this.r.width - d2, this.r.y - d2, d, d);
            }
            case 3: {
                return new RectangleD(this.r.x + this.r.width - d2, this.r.y + this.r.height - d2, d, d);
            }
            case 4: {
                return new RectangleD(this.r.x - d2, this.r.y + this.r.height - d2, d, d);
            }
            case 5: {
                return new RectangleD(this.r.x + d, this.r.y - d2, this.r.width - 2.0 * d, d);
            }
            case 6: {
                return new RectangleD(this.r.x + this.r.width - d2, this.r.y + d, d, this.r.height - 2.0 * d);
            }
            case 8: {
                return new RectangleD(this.r.x - d2, this.r.y + d, d, this.r.height - 2.0 * d);
            }
            case 7: {
                return new RectangleD(this.r.x + d, this.r.y + this.r.height - d2, this.r.width - 2.0 * d, d);
            }
        }
        return null;
    }

    private void drawSelect(Graphics graphics) {
        double d = this.getZoom();
        for (int i = 0; i < 8; ++i) {
            int n = (int)((i == 0 || i >= 6 ? this.r.x : (i == 1 || i == 5 ? this.r.x + this.r.width / 2.0 : this.r.x + this.r.width)) / d) - this.DS / 2;
            int n2 = (int)((i <= 2 ? this.r.y : (i == 3 || i == 7 ? this.r.y + this.r.height / 2.0 : this.r.y + this.r.height)) / d) - this.DS / 2;
            this.drawPoignee(graphics, n, n2);
        }
    }

    protected void drawPoignee(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.green);
        graphics.fillRect(n + 1, n2 + 1, this.DS, this.DS);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, this.DS, this.DS);
    }

    private void drawClose(Graphics graphics) {
        double d = this.getZoom();
        int n = (int)((this.r.x + this.r.width - 2.0) / d);
        int n2 = (int)((this.r.y + 2.0) / d);
        int n3 = 5;
        graphics.setColor(Aladin.BKGD);
        graphics.fillRect(n - n3 - 4, n2 + 1, n3 + 4, n3 + 4);
        graphics.setColor(Color.red);
        graphics.drawLine(n - n3 - 3, n2 + 2, n - 3, n2 + n3 + 2);
        graphics.drawLine(n - n3 - 3, n2 + 3, n - 3, n2 + n3 + 3);
        graphics.drawLine(n - n3 - 3, n2 + n3 + 2, n - 3, n2 + 2);
        graphics.drawLine(n - n3 - 3, n2 + n3 + 3, n - 3, n2 + 3);
        this.closeButton = new RectangleD(n - n3 - 4, n2 + 1, n3 + 4, n3 + 4);
    }

    private void drawAxe(Graphics graphics, double d, double d2, boolean bl, boolean bl2, boolean bl3) {
        double d3;
        double d4 = this.getZoom();
        if (d4 >= 3.0) {
            graphics.setFont(Aladin.SBOLD);
            d3 = 1.8;
        } else {
            graphics.setFont(Aladin.BOLD);
            d3 = 1.0;
        }
        boolean bl4 = !bl;
        double d5 = (double)(bl4 ? 40 : 80) / d3;
        double d6 = bl4 ? this.r.height / d4 : this.r.width / d4;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (int)Math.max(d6 / d5, 1.0);
        double d7 = 0.0;
        int n2 = fontMetrics.getAscent();
        int n3 = fontMetrics.getHeight();
        int n4 = d4 > 2.0 ? 2 : 5;
        double d8 = this.getLastValue(d, d2);
        float f = 0.5f;
        double d9 = d2 - d;
        double d10 = Math.pow(10.0, (int)(0.5 + Math.log10(d9)));
        double d11 = Math.floor(d / d10) * d10;
        d10 = d9 / (d10 / 10.0) <= (double)n * 1.5 ? d10 / 10.0 : (d9 / (d10 / 4.0) < (double)n * 1.5 ? d10 / 4.0 : d10);
        d10 = d9 / d10 >= (double)(n / 2) ? d10 : d10 / 2.0;
        boolean bl5 = true;
        boolean bl6 = false;
        int n5 = 0;
        while (bl5) {
            double d12;
            double d13 = d12 = n5 > 30 ? d2 : d11;
            if (bl6) {
                bl5 = false;
                if (Double.isNaN(d8) || d8 < d || d8 > d2) break;
                d12 = d8;
                graphics.setColor(Color.blue);
                f = 0.8f;
            } else if (d12 < d) {
                d12 = d;
            } else if (d12 >= d2) {
                d12 = d2;
                bl6 = true;
            }
            double d14 = (d12 - d) / (d2 - d);
            d7 = d6 * d14;
            if (!(d12 != d8 && (d12 != d && d14 * d6 < (double)n3 || d12 != d2 && (1.0 - d14) * d6 < (double)n3))) {
                int n6 = (int)((!bl4 ? this.r.x : (bl3 ? this.r.x + this.r.width : this.r.x - (double)n4)) / d4);
                int n7 = (int)((bl4 ? this.r.y + this.r.height : (bl2 ? this.r.y + this.r.height : this.r.y - (double)n4)) / d4);
                if (bl4) {
                    n7 = (int)((double)n7 - d7);
                } else {
                    n6 = (int)((double)n6 + d7);
                }
                if (bl4) {
                    graphics.drawLine(n6, n7, n6 + n4, n7);
                } else {
                    graphics.drawLine(n6, n7, n6, n7 + n4);
                }
                String string = Util.myRound(d12);
                int n8 = fontMetrics.stringWidth(string);
                int n9 = !bl4 ? n6 - n8 / 2 : (n6 = bl3 ? n6 + n4 + 2 : n6 - (n8 + 2));
                n7 = bl4 ? n7 + n2 / 2 : (bl2 ? n7 + n2 + n4 + 2 : n7 - 2);
                Util.drawCartouche(graphics, n6, n7 - n2 + 2, n8, n2, f, null, Color.white);
                graphics.drawString(string, n6, n7);
            }
            ++n5;
            d11 += d10;
        }
    }

    private double getLastValue(double d, double d2) {
        if (this.lastPos == -1.0 || !this.isIn || this.isSelected) {
            return Double.NaN;
        }
        double d3 = d + this.lastPos * (d2 - d);
        return d3;
    }

    protected void drawTitle(Graphics graphics) {
        if (this.title == null) {
            return;
        }
        graphics.setFont(graphics.getFont().deriveFont(2));
        double d = this.getZoom();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(this.title);
        int n2 = fontMetrics.getDescent();
        int n3 = fontMetrics.getHeight();
        int n4 = (int)(this.r.x / d);
        int n5 = (int)(this.r.y / d - (double)(n2 * 2));
        Util.drawCartouche(graphics, n4, n5 - n3 + 2, n, n3, 0.5f, null, Color.white);
        graphics.drawString(this.title, n4, n5);
    }

    protected void drawOverlays(Graphics graphics) {
        if (this.isSelected) {
            this.drawSelect(graphics);
            this.drawClose(graphics);
        } else {
            this.closeButton = null;
        }
    }

    public void draw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        block13: {
            if (!this.visible) {
                return;
            }
            graphics.translate(n, n2);
            try {
                boolean bl;
                double d = this.getZoom();
                boolean bl2 = this.r.x / d > (double)(viewSimple.getWidth() / 2);
                boolean bl3 = this.r.y / d > (double)(viewSimple.getHeight() / 2);
                boolean bl4 = bl = this.r.width > this.r.height;
                if (bl && (this.r.y / d < 30.0 || (double)viewSimple.getHeight() - (this.r.y + this.r.height) / d < 30.0)) {
                    boolean bl5 = bl3 = !bl3;
                }
                if (!bl && (this.r.x / d < 60.0 || (double)viewSimple.getWidth() - (this.r.x + this.r.width) / d < 60.0)) {
                    bl2 = !bl2;
                }
                ColorModel colorModel = this.cm != null ? this.cm : ((PlanImage)viewSimple.pref).getCM();
                int n3 = (int)Math.ceil(this.r.width / d) + 1;
                int n4 = (int)Math.ceil(this.r.height / d) + 1;
                boolean bl6 = false;
                boolean bl7 = false;
                double d2 = 0.0;
                double d3 = (bl ? this.r.width / d : this.r.height / d) / 256.0;
                double d4 = bl ? this.r.height / d : this.r.width / d;
                int n5 = bl ? 255 : 0;
                graphics.setColor(new Color(colorModel.getRed(n5), colorModel.getGreen(n5), colorModel.getBlue(n5)));
                graphics.fillRect((int)(this.r.x / d), (int)(this.r.y / d), (int)(this.r.width / d), (int)(this.r.height / d));
                double d5 = d2;
                int n6 = 0;
                while (n6 < 256) {
                    n5 = bl ? n6 : 255 - n6;
                    graphics.setColor(new Color(colorModel.getRed(n5), colorModel.getGreen(n5), colorModel.getBlue(n5)));
                    if (bl) {
                        graphics.fillRect((int)(d2 + this.r.x / d), (int)((double)bl6 + this.r.y / d), (int)d3 + 2, (int)d4);
                        graphics.drawRect((int)(d2 + this.r.x / d), (int)((double)bl6 + this.r.y / d), (int)d3 + 2, (int)d4);
                    } else {
                        graphics.fillRect((int)((double)bl7 + this.r.x / d), (int)(d2 + this.r.y / d), (int)d4, (int)d3);
                        graphics.drawRect((int)((double)bl7 + this.r.x / d), (int)(d2 + this.r.y / d), (int)d4, (int)d3);
                    }
                    ++n6;
                    d2 += d3;
                }
                graphics.setColor(Color.black);
                graphics.drawRect((int)(this.r.x / d), (int)(this.r.y / d), (int)(this.r.width / d), (int)(this.r.height / d));
                graphics.setColor(Color.black);
                double d6 = this.cm != null ? this.min : ((PlanImage)viewSimple.pref).getPixelMin();
                double d7 = this.cm != null ? this.max : ((PlanImage)viewSimple.pref).getPixelMax();
                this.drawAxe(graphics, d6, d7, bl, bl3, bl2);
                this.drawTitle(graphics);
                this.drawOverlays(graphics);
                if (this.isSelected) {
                    int n7 = 0;
                    if (this.lastButton != -1) {
                        n7 = 12;
                    } else {
                        int n8;
                        int n9 = n8 = this.dragPoignee != -1 ? this.dragPoignee : this.lastPoignee;
                        if (n8 != -1) {
                            n7 = CURSOR[n8];
                        }
                    }
                    if (n7 != this.oCursor) {
                        this.oCursor = n7;
                        viewSimple.setCursor(new Cursor(n7));
                    }
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block13;
                exception.printStackTrace();
            }
        }
        graphics.translate(-n, -n2);
    }

    @Override
    public WidgetControl getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int n, int n2, int n3, int n4, float f, JComponent jComponent) {
        this.voc = new WidgetControl(this, n, n2, n3, n4, f, jComponent);
        this.voc.setResizable(true);
    }

    @Override
    public void paintCollapsed(Graphics graphics) {
    }
}

