/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CanvasColorMap;
import cds.aladin.PlanImage;
import cds.aladin.Rainbow;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import java.awt.Graphics;

public class RainbowPixel
extends Rainbow {
    private ViewSimple v;
    private boolean flagRedCM;
    private double oLastPos = -1.0;
    private long t0 = -1L;

    public RainbowPixel(Aladin aladin, ViewSimple viewSimple) {
        super(aladin);
        this.r = new RectangleD(10.0, viewSimple.getHeight() - 330, 30.0, 300.0);
        this.v = viewSimple;
        this.flagRedCM = false;
    }

    private PlanImage getPlan() {
        return (PlanImage)this.v.pref;
    }

    public void setRedCM() {
        double d;
        if (this.flagRedCM && this.lastPos == this.oLastPos) {
            return;
        }
        if (!this.flagRedCM) {
            if (this.t0 == -1L) {
                this.t0 = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - this.t0 < 200L) {
                return;
            }
        }
        if ((d = 256.0 * this.lastPos) > 255.0) {
            d = 255.0;
        }
        PlanImage planImage = this.getPlan();
        planImage.setCM(CanvasColorMap.getCMBand((int)d, this.getPlan().video == 1, true, planImage.isTransparent()));
        this.oLastPos = this.lastPos;
        this.flagRedCM = true;
    }

    public void restoreCM() {
        this.t0 = -1L;
        if (!this.flagRedCM) {
            return;
        }
        this.getPlan().restoreCM();
        this.flagRedCM = false;
    }

    public boolean isAvailable() {
        return this.v.pref.hasAvailablePixels();
    }

    @Override
    public boolean mouseMove(double d, double d2) {
        boolean bl = super.mouseMove(d, d2);
        if (this.isIn && !this.isSelected) {
            this.setRedCM();
        } else {
            this.restoreCM();
        }
        return bl;
    }

    @Override
    public boolean submit(ViewSimple viewSimple) {
        this.restoreCM();
        return super.submit(viewSimple);
    }

    @Override
    public void draw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        if (!this.isAvailable()) {
            return;
        }
        super.draw(graphics, viewSimple, n, n2);
    }
}

