/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Hist;
import cds.aladin.Localisation;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanField;
import cds.aladin.PlanImage;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Server;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import healpix.essentials.FastMath;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTextField;

public class Repere
extends Position {
    static final int DEFAULT = 0;
    static final int TARGET = 1;
    static final int TARGETL = 2;
    static final int ARROW = 3;
    static final int CENTER = 4;
    static final int ROTCENTER = 5;
    static final int CARTOUCHE = 6;
    protected int L = 5;
    private double radius;
    protected int dw;
    protected int dh;
    protected int type = 0;
    protected Color couleur = null;
    private static final String C = "|";
    Position rotcenter = null;
    static final Color JAUNEPALE = new Color(255, 255, 225);

    protected Repere(Plan plan, ViewSimple viewSimple, double d, double d2) {
        super(plan, viewSimple, d, d2, 0.0, 0.0, 5, null);
    }

    protected Repere(Plan plan) {
        super(plan);
    }

    protected Repere(Plan plan, Coord coord) {
        super(plan, null, 0.0, 0.0, coord.al, coord.del, 2, null);
    }

    protected Repere(Plan plan, ViewSimple viewSimple, double d, double d2, double d3, double d4) {
        super(plan, viewSimple, d, d2, d3, d4, 3, null);
        this.setId();
        this.setWithLabel(false);
    }

    public Vector getProp() {
        Object object;
        Object object2;
        Vector<Prop> vector = super.getProp();
        if (this.hasRayon()) {
            object2 = this;
            object = new JTextField(10);
            PropAction propAction = new PropAction((JTextField)object){
                final /* synthetic */ JTextField val$testRadius;
                {
                    this.val$testRadius = jTextField;
                }

                @Override
                public int action() {
                    this.val$testRadius.setText(Coord.getUnit(Repere.this.getRadius()));
                    return 1;
                }
            };
            PropAction propAction2 = new PropAction((JTextField)object, (Obj)object2, propAction){
                final /* synthetic */ JTextField val$testRadius;
                final /* synthetic */ Obj val$myself;
                final /* synthetic */ PropAction val$updateRadius;
                {
                    this.val$testRadius = jTextField;
                    this.val$myself = obj;
                    this.val$updateRadius = propAction;
                }

                @Override
                public int action() {
                    this.val$testRadius.setForeground(Color.black);
                    String string = Coord.getUnit(Repere.this.getRadius());
                    try {
                        String string2 = this.val$testRadius.getText();
                        if (string2.equals(string)) {
                            return -1;
                        }
                        ((Repere)this.val$myself).setRadius(string2);
                        return 1;
                    }
                    catch (Exception exception) {
                        this.val$updateRadius.action();
                        this.val$testRadius.setForeground(Color.red);
                        return 0;
                    }
                }
            };
            vector.add(Prop.propFactory("radius", "Radius", "", object, propAction, propAction2));
        }
        object2 = new Couleur(this.couleur, true);
        object = new PropAction((Couleur)object2){
            final /* synthetic */ Couleur val$col;
            {
                this.val$col = couleur;
            }

            @Override
            public int action() {
                Color color = this.val$col.getCouleur();
                if (color == Repere.this.couleur) {
                    return -1;
                }
                Repere.this.couleur = color;
                return 1;
            }
        };
        ((Couleur)object2).addActionListener(new ActionListener((PropAction)object){
            final /* synthetic */ PropAction val$changeCouleur;
            {
                this.val$changeCouleur = propAction;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.val$changeCouleur.action();
                Repere.this.plan.aladin.view.repaintAll();
            }
        });
        vector.add(Prop.propFactory("color", "Color", "Alternative color", object2, null, (PropAction)object));
        return vector;
    }

    @Override
    protected String getSpecificAJInfo() {
        return this.id + C + (this.hasRayon() ? Double.valueOf(this.getRadius()) : "");
    }

    @Override
    protected void setSpecificAJInfo(String string) {
        block3: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, C);
            String string2 = stringTokenizer.nextToken();
            String string3 = this.id = string2.length() == 0 ? null : string2;
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    this.radius = Double.parseDouble(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace != 3) break block3;
                    exception.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getObjType() {
        return "Phot";
    }

    protected void setType(int n) {
        this.type = n;
    }

    protected void setRotCenterType(Position position) {
        this.type = 5;
        this.rotcenter = position;
    }

    protected int getType() {
        return this.type;
    }

    protected boolean isLargeReticle() {
        return this.type == 2;
    }

    protected void setSize(int n) {
        this.L = n;
    }

    @Override
    protected void setCoord(ViewSimple viewSimple) {
        super.setCoord(viewSimple);
        this.setId();
    }

    @Override
    protected void setPosition(ViewSimple viewSimple, double d, double d2) {
        super.setPosition(viewSimple, d, d2);
        this.setId();
    }

    @Override
    protected void deltaPosition(ViewSimple viewSimple, double d, double d2) {
        super.deltaPosition(viewSimple, d, d2);
        this.setId();
    }

    @Override
    protected void deltaRaDec(double d, double d2) {
        super.deltaRaDec(d, d2);
        this.setId();
    }

    protected void reprojection(ViewSimple viewSimple) {
        super.projection(viewSimple);
    }

    void setD() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(DF);
        this.dw = fontMetrics.stringWidth(this.id) + 4;
        this.dh = HF;
    }

    @Override
    public void setColor(Color color) {
        this.couleur = color;
    }

    protected void setRadius(String string) {
        this.radius = Server.getAngleInArcmin(string, 1) / 60.0;
    }

    void setRayon(ViewSimple viewSimple, double d) {
        Coord coord = new Coord();
        Projection projection = viewSimple.getProj().copy();
        projection.setProjCenter(0.0, 0.0);
        double d2 = 0.0;
        coord.del = 0.0;
        coord.al = 0.0;
        projection.getXY(coord);
        if (Double.isNaN(coord.del)) {
            projection = viewSimple.getProj().copy();
            coord.al = this.raj;
            coord.del = this.dej;
            d2 = this.dej;
            projection.getXY(coord);
        }
        coord.y += d;
        projection.getCoord(coord);
        this.radius = Math.abs(d2 - coord.del);
    }

    protected void setId(String string) {
        this.id = string;
        this.setD();
    }

    void setId() {
        this.id = this.plan.aladin.localisation.J2000ToString(this.raj, this.dej);
        this.setD();
    }

    @Override
    protected boolean inside(ViewSimple viewSimple, double d, double d2) {
        if (!this.isVisible()) {
            return false;
        }
        double d3 = this.getRayon(viewSimple);
        if (d3 > 0.0) {
            return (d - this.xv[viewSimple.n]) * (d - this.xv[viewSimple.n]) + (d2 - this.yv[viewSimple.n]) * (d2 - this.yv[viewSimple.n]) <= d3 * d3;
        }
        double d4 = (double)this.L / viewSimple.getZoom();
        double d5 = this.xv[viewSimple.n];
        double d6 = this.yv[viewSimple.n];
        if (this.type == 6) {
            return d5 <= d + d4 + (double)(this.dw / 2) && d5 >= d - d4 - (double)(this.dw / 2) && d6 <= d2 + d4 + (double)(this.dh / 2) && d6 >= d2 - d4 - (double)(this.dh / 2);
        }
        return d5 <= d + d4 && d5 >= d - d4 && d6 <= d2 + d4 && d6 >= d2 - d4;
    }

    protected boolean inLabel(ViewSimple viewSimple, double d, double d2) {
        Point point = this.getViewCoord(viewSimple, this.L, this.L);
        if (point == null) {
            return false;
        }
        return d >= (double)(point.x - this.dw / 2) && d <= (double)(point.x + this.dw / 2) && d2 >= (double)(point.y - this.L - this.dh - 1) && d2 <= (double)(point.y - this.L + 5);
    }

    @Override
    protected Rectangle extendClip(ViewSimple viewSimple, Rectangle rectangle) {
        Point point;
        if (!this.isVisible()) {
            return rectangle;
        }
        int n = (int)Math.ceil(Math.max((double)this.L, this.getRayon(viewSimple) * viewSimple.getZoom()));
        Point point2 = this.getViewCoord(viewSimple, n, n);
        if (point2 == null) {
            return rectangle;
        }
        int n2 = n;
        if (this.type == 4 || this.type == 5) {
            n2 = (int)Math.min(Math.max(2.0, viewSimple.getZoom() * 3.0), 16.0);
        }
        rectangle = Repere.unionRect(rectangle, point2.x - n2, point2.y - n2, n2 * 2, n2 * 2);
        if (this.type == 5 && (point = viewSimple.getViewCoord(this.rotcenter.xv[viewSimple.n], this.rotcenter.yv[viewSimple.n])) != null) {
            rectangle = Repere.unionRect(rectangle, point.x - n2, point.y - n2, n2 * 2, n2 * 2);
        }
        if (this.isSelected()) {
            rectangle = Repere.unionRect(rectangle, point2.x - n - 4, point2.y - n - 4, n * 2 + 8, n * 2 + 8);
        }
        if (this.isWithLabel()) {
            rectangle = Repere.unionRect(rectangle, point2.x - this.dw / 2, point2.y - n - 1 - this.dh - 1, this.dw, this.dh);
        }
        if (this.hasRayon() && this.isSelected()) {
            rectangle = Repere.unionRect(rectangle, this.getStatPosition(viewSimple));
        }
        return rectangle;
    }

    protected Rectangle getClipRayon(ViewSimple viewSimple) {
        Rectangle rectangle = null;
        if (!this.isVisible()) {
            return null;
        }
        int n = (int)Math.ceil(this.getRayon(viewSimple) * viewSimple.getZoom());
        Point point = this.getViewCoord(viewSimple, n, n);
        if (point == null) {
            return null;
        }
        if (this.isSelected()) {
            rectangle = Repere.unionRect(rectangle, point.x - n - 4, point.y - n - 4, n * 2 + 8, n * 2 + 8);
        }
        return rectangle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Color getColor() {
        if (this.type == 1 || this.type == 2) {
            this.couleur = Color.magenta.darker();
        }
        if (this.couleur != null) {
            return this.couleur;
        }
        if (this.type == 6) {
            this.couleur = Color.blue;
            return this.couleur;
        } else if (this.type == 3) {
            this.couleur = Color.red;
            return this.couleur;
        } else {
            if (this.plan == null) return Color.black;
            if (this.plan.type != 10) return this.plan.c;
            this.couleur = ((PlanField)this.plan).getColor(this);
        }
        return this.couleur;
    }

    private void drawReticule(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        graphics.setColor(color);
        graphics.drawLine(n - n3, n2, n - n4, n2);
        graphics.drawLine(n + n4, n2, n + n3, n2);
        graphics.drawLine(n, n2 - n3, n, n2 - n4);
        graphics.drawLine(n, n2 + n3, n, n2 + n4);
    }

    @Override
    protected boolean statCompute(Graphics graphics, ViewSimple viewSimple) {
        boolean bl;
        boolean bl2 = bl = viewSimple == viewSimple.aladin.view.getCurrentView();
        if (viewSimple == null || viewSimple.isFree() || !this.hasPhot(viewSimple.pref)) {
            return false;
        }
        this.statInit();
        double d = this.xv[viewSimple.n] - 0.5;
        double d2 = this.yv[viewSimple.n] - 0.5;
        double d3 = this.getRayon(viewSimple);
        if (d3 > 100.0 && viewSimple.flagClicAndDrag) {
            return false;
        }
        minx = (int)Math.floor(d - d3);
        maxx = (int)Math.ceil(d + d3);
        miny = (int)Math.floor(d2 - d3);
        maxy = (int)Math.ceil(d2 + d3);
        double d4 = d3 * d3;
        double d5 = 0.0;
        Hist.HistItem histItem = null;
        if (bl) {
            Hist.HistItem histItem2 = histItem = viewSimple.aladin.view.zoomview.hist == null ? null : viewSimple.aladin.view.zoomview.hist.onMouse;
            if (histItem == null) {
                viewSimple.aladin.view.zoomview.initPixelHist();
            } else {
                bl = false;
            }
        }
        if (viewSimple.pref instanceof PlanBG) {
            try {
                PlanBG planBG = (PlanBG)viewSimple.pref;
                int n = planBG.getOrder();
                long l = CDSHealpix.pow2(n);
                long l2 = CDSHealpix.pow2(planBG.getTileOrder());
                long l3 = l * l2;
                d5 = CDSHealpix.pixRes(l3) / 3600.0;
                d5 *= d5;
                Coord coord = new Coord(this.raj, this.dej);
                coord = Localisation.frameToFrame(coord, 0, planBG.frameOrigin);
                double d6 = Math.toRadians(this.getRadius());
                long[] lArray = CDSHealpix.query_disc(l3, coord.al, coord.del, d6, false);
                for (int i = 0; i < lArray.length; ++i) {
                    long l4 = lArray[i] / (l2 * l2);
                    double d7 = planBG.getHealpixPixel(n, l4, lArray[i], 0);
                    if (Double.isNaN(d7)) continue;
                    d7 = d7 * planBG.bScale + planBG.bZero;
                    double[] dArray = CDSHealpix.pix2ang_nest(l3, lArray[i]);
                    dArray = CDSHealpix.polarToRadec(dArray);
                    coord.al = dArray[0];
                    coord.del = dArray[1];
                    coord = Localisation.frameToFrame(coord, planBG.frameOrigin, 0);
                    this.statPixel(graphics, d7, coord.al, coord.del, viewSimple, histItem);
                    if (!bl) continue;
                    viewSimple.aladin.view.zoomview.addPixelHist(d7);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                d5 = viewSimple.pref.projd.getPixResAlpha() * viewSimple.pref.projd.getPixResDelta();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (double d8 = miny; d8 <= maxy; d8 += 1.0) {
                for (double d9 = minx; d9 <= maxx; d9 += 1.0) {
                    double d10;
                    if ((d9 - d) * (d9 - d) + (d8 - d2) * (d8 - d2) > d4 || Double.isNaN(d10 = this.statPixel(graphics, (int)d9, (int)d8, viewSimple, histItem)) || !bl) continue;
                    viewSimple.aladin.view.zoomview.addPixelHist(d10);
                }
            }
        }
        if (bl) {
            viewSimple.aladin.view.zoomview.createPixelHist(viewSimple.pref.type == 16 ? "HEALPixels" : "Pixels");
        }
        d = this.xv[viewSimple.n];
        d2 = this.yv[viewSimple.n];
        minx = d - d3;
        maxx = d + d3;
        miny = d2 - d3;
        maxy = d2 + d3;
        try {
            surface = (double)nombre * d5;
            moyenne = total / (double)nombre;
            variance = carre / (double)nombre - moyenne * moyenne;
            sigma = Math.sqrt(variance);
            if (medianeArrayNb == 10000) {
                mediane = Double.NaN;
            } else {
                Arrays.sort(medianeArray, 0, medianeArrayNb);
                mediane = medianeArray[medianeArrayNb / 2];
            }
            this.setWithStat(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean hasSurface() {
        return this.radius > 0.0;
    }

    @Override
    public double[] getStatistics(Plan plan) throws Exception {
        double d;
        PlanImage planImage;
        Projection projection = plan.projd;
        if (!plan.hasAvailablePixels()) {
            throw new Exception("getStats error: image without pixel values");
        }
        if (!this.hasPhot(plan)) {
            throw new Exception("getStats error: not compatible image");
        }
        if (!Projection.isOk(projection)) {
            throw new Exception("getStats error: image without astrometrical calibration");
        }
        if (this.radius <= 0.0) {
            throw new Exception("getStats error: no radius");
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (plan.type == 16) {
            planImage = (PlanBG)plan;
            int n = ((PlanBG)planImage).getOrder();
            long l = CDSHealpix.pow2(n);
            long l2 = CDSHealpix.pow2(((PlanBG)planImage).getTileOrder());
            long l3 = l * l2;
            d = CDSHealpix.pixRes(l3) / 3600.0;
            d *= d;
            Coord coord = new Coord(this.raj, this.dej);
            coord = Localisation.frameToFrame(coord, 0, ((PlanBG)planImage).frameOrigin);
            double d5 = Math.toRadians(this.getRadius());
            long[] lArray = CDSHealpix.query_disc(l3, coord.al, coord.del, d5, false);
            for (int i = 0; i < lArray.length; ++i) {
                long l4 = lArray[i] / (l2 * l2);
                double d6 = ((PlanBG)planImage).getHealpixPixel(n, l4, lArray[i], 0);
                if (Double.isNaN(d6)) continue;
                d6 = d6 * ((PlanBG)planImage).bScale + ((PlanBG)planImage).bZero;
                d2 += 1.0;
                d4 += d6;
                d3 += d6 * d6;
            }
        } else {
            planImage = (PlanImage)plan;
            planImage.setLockCacheFree(true);
            planImage.pixelsOriginFromCache();
            d = projection.getPixResAlpha() * projection.getPixResDelta();
            Coord coord = new Coord(this.raj, this.dej);
            projection.getXY(coord);
            double d7 = coord.x - 0.5;
            double d8 = coord.y - 0.5;
            coord.del = this.dej + this.radius;
            projection.getXY(coord);
            double d9 = d8 + 0.5 - coord.y;
            double d10 = d7 + 0.5 - coord.x;
            double d11 = Math.sqrt(d10 * d10 + d9 * d9);
            double d12 = d11 * d11;
            int n = (int)Math.floor(d7 - d11);
            int n2 = (int)Math.ceil(d7 + d11);
            int n3 = (int)Math.floor(d8 - d11);
            int n4 = (int)Math.ceil(d8 + d11);
            for (int i = n3; i <= n4; ++i) {
                for (int j = n; j <= n2; ++j) {
                    double d13;
                    if (((double)j - d7) * ((double)j - d7) + ((double)i - d8) * ((double)i - d8) > d12 || Double.isNaN(d13 = planImage.getPixelInDouble(j, i))) continue;
                    d2 += 1.0;
                    d4 += d13;
                    d3 += d13 * d13;
                }
            }
            planImage.setLockCacheFree(false);
        }
        double d14 = d2 * d;
        double d15 = d4 / d2;
        double d16 = d3 / d2 - d15 * d15;
        double d17 = Math.sqrt(d16);
        return new double[]{d2, d4, d17, d14};
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    protected boolean hasRayon() {
        return this.radius > 0.0;
    }

    @Override
    public boolean hasPhot() {
        return this.hasRayon();
    }

    public boolean hasPhot(Plan plan) {
        if (!this.hasPhot()) {
            return false;
        }
        return plan.hasAvailablePixels();
    }

    @Override
    public String getCommand() {
        String string = this.plan.aladin.localisation.getFrame() == 11 ? Util.myRound(this.getRayon(this.plan.aladin.view.getCurrentView())) : Coord.getUnit(this.getRadius());
        return "draw phot(" + this.getLocalisation() + "," + string + ")";
    }

    protected double getRayon(ViewSimple viewSimple) {
        Coord coord = new Coord();
        Projection projection = viewSimple.getProj();
        if (this.radius == 0.0 || viewSimple.pref == null || !Projection.isOk(projection)) {
            return 0.0;
        }
        coord.al = this.raj;
        coord.del = this.dej + this.radius;
        projection.getXY(coord);
        double d = this.yv[viewSimple.n] - coord.y;
        double d2 = this.xv[viewSimple.n] - coord.x;
        return Math.sqrt(d2 * d2 + d * d);
    }

    protected void drawSpecialCircle(Graphics graphics, ViewSimple viewSimple) {
        Coord coord = new Coord();
        Point point = new Point(0, 0);
        Point point2 = new Point(0, 0);
        Projection projection = viewSimple.getProj().copy();
        for (double d = 0.0; d < 6.3; d += 0.1) {
            coord.del = this.dej + this.radius * FastMath.sin(d);
            coord.al = this.raj + this.radius * FastMath.cos(d);
            projection.getXY(coord);
            if (Double.isNaN(coord.x)) continue;
            point2 = viewSimple.getViewCoord(point2, coord.x, coord.y);
            if (d > 0.0) {
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
            point.x = point2.x;
            point.y = point2.y;
        }
    }

    protected boolean onPoignee(ViewSimple viewSimple, double d, double d2) {
        double d3 = this.getRayon(viewSimple) + 1.0;
        for (int i = 0; i < 4; ++i) {
            double d4 = this.xv[viewSimple.n];
            double d5 = this.yv[viewSimple.n];
            if (i == 0) {
                d5 += d3;
            } else if (i == 2) {
                d5 -= d3;
            } else {
                d4 = i == 1 ? (d4 += d3) : (d4 -= d3);
            }
            double d6 = d - d4;
            double d7 = d2 - d5;
            double d8 = (double)this.L / viewSimple.getZoom();
            if (d8 < 1.0) {
                d8 = 1.0;
            }
            if (!(d6 * d6 + d7 * d7 < d8 * d8)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean draw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        if (!this.isVisible()) {
            return false;
        }
        Point point = this.getViewCoord(viewSimple, this.L, this.L);
        if (point == null) {
            return false;
        }
        point.x += n;
        point.y += n2;
        graphics.setColor(this.getColor());
        switch (this.type) {
            case 1: 
            case 2: {
                int n3 = (int)Math.min(Math.max(8.0, viewSimple.getZoom() * 12.0), 32.0);
                int n4 = Math.max(Math.min(n3 - 7, n3 / 3), 2);
                if (n3 > 10) {
                    graphics.drawLine(point.x, point.y, point.x, point.y);
                }
                if (this.type == 2) {
                    n3 = 3000;
                }
                this.drawReticule(graphics, point.x, point.y, n3, n4, this.getColor());
                break;
            }
            case 4: {
                int n5 = (int)Math.min(Math.max(2.0, viewSimple.getZoom() * 3.0), 16.0);
                int n6 = 2 * n5 / 3;
                this.drawReticule(graphics, point.x, point.y, n5, n6, this.getColor());
                break;
            }
            case 5: {
                if (!Aladin.ROTATEFOVCENTER) {
                    return false;
                }
                Util.drawCircle7(graphics, point.x, point.y);
                Point point2 = viewSimple.getViewCoord(this.rotcenter.xv[viewSimple.n], this.rotcenter.yv[viewSimple.n]);
                if (point2 == null) {
                    return false;
                }
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
                break;
            }
            case 0: {
                if (!this.hasRayon()) {
                    graphics.drawLine(point.x - this.L, point.y, point.x + this.L, point.y);
                    graphics.drawLine(point.x, point.y - this.L, point.x, point.y + this.L);
                    if (this.isSelected() && this.plan.aladin.view.nbSelectedObjet() <= 2) {
                        this.cutOn();
                        break;
                    }
                    this.cutOff();
                    break;
                }
                int n7 = (int)(this.getRayon(viewSimple) * viewSimple.getZoom());
                if (this.hasPhot(viewSimple.pref)) {
                    Util.drawFillOval(graphics, point.x - n7, point.y - n7, n7 * 2, n7 * 2, 0.1f * this.plan.getOpacityLevel(), null);
                    if (!this.isSelected()) break;
                    this.statDraw(graphics, viewSimple, n, n2);
                    break;
                }
                graphics.drawOval(point.x - n7, point.y - n7, n7 * 2, n7 * 2);
                break;
            }
            case 3: {
                graphics.drawLine(point.x, point.y - this.L, point.x, point.y - 3);
                graphics.drawLine(point.x, point.y - 3, point.x - 3, point.y - 6);
                graphics.drawLine(point.x, point.y - 3, point.x + 3, point.y - 6);
                break;
            }
            case 6: {
                graphics.setColor(JAUNEPALE);
                graphics.drawLine(point.x - this.L + 1, point.y - this.L, point.x + 1, point.y);
                graphics.setColor(Color.black);
                graphics.drawLine(point.x - this.L, point.y - this.L, point.x, point.y);
                graphics.setColor(JAUNEPALE);
                Util.fillCircle5(graphics, point.x, point.y);
                graphics.setColor(Color.black);
                Util.drawCircle7(graphics, point.x, point.y);
            }
        }
        if (this.isWithLabel() && !this.hasRayon()) {
            if (this.id == null) {
                this.setId();
            }
            if (this.type == 6) {
                Util.drawCartouche(graphics, point.x - this.dw / 2, point.y - this.L - this.dh - 1, this.dw - 2, this.dh + 3, 1.0f, Color.black, JAUNEPALE);
                graphics.setColor(this.getColor());
                graphics.setFont(Aladin.SPLAIN);
                graphics.drawString(this.id, point.x - this.dw / 2, point.y - this.L - 1);
            } else {
                graphics.drawString(this.id, point.x - this.dw / 2, point.y - this.L - 1);
            }
        }
        if (this.isSelected()) {
            graphics.setColor(Color.green);
            this.drawSelect(graphics, viewSimple);
        }
        return true;
    }

    @Override
    protected void drawSelect(Graphics graphics, ViewSimple viewSimple) {
        if (this.type == 5) {
            this.drawRotCenterSelect(graphics, viewSimple);
        } else if (!this.hasRayon()) {
            super.drawSelect(graphics, viewSimple);
        } else {
            this.drawSelect1(graphics, viewSimple);
        }
    }

    protected void drawSelect1(Graphics graphics, ViewSimple viewSimple) {
        Rectangle rectangle = this.getClipRayon(viewSimple);
        int n = 0;
        int n2 = 0;
        Color color = graphics.getColor();
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    n = rectangle.x + rectangle.width / 2 - 4;
                    n2 = rectangle.y;
                    break;
                }
                case 1: {
                    n = rectangle.x + rectangle.width / 2 - 4;
                    n2 = rectangle.y + rectangle.height - 4;
                    break;
                }
                case 2: {
                    n = rectangle.x + rectangle.width - 4;
                    n2 = rectangle.y + rectangle.height / 2 - 4;
                    break;
                }
                case 3: {
                    n = rectangle.x;
                    n2 = rectangle.y + rectangle.height / 2 - 4;
                }
            }
            graphics.setColor(color);
            graphics.fillRect(n + 1, n2 + 1, 4, 4);
            graphics.setColor(Color.black);
            graphics.drawRect(n, n2, 4, 4);
        }
        graphics.setColor(color);
    }

    protected void drawRotCenterSelect(Graphics graphics, ViewSimple viewSimple) {
        Point point = this.getViewCoord(viewSimple, this.L, this.L);
        graphics.setColor(Color.green);
        Util.fillCircle5(graphics, point.x, point.y);
        graphics.setColor(Color.black);
        Util.drawCircle5(graphics, point.x, point.y);
    }

    @Override
    protected void remove() {
        this.cutOff();
    }

    protected void cutOff() {
        this.plan.aladin.calque.zoom.zoomView.stopHist();
        this.plan.aladin.calque.zoom.zoomView.cutOff(this);
    }

    @Override
    protected boolean cutOn() {
        ViewSimple viewSimple = this.plan.aladin.view.getCurrentView();
        if (viewSimple == null || this.plan.aladin.toolBox.getTool() == 8) {
            return false;
        }
        Plan plan = viewSimple.pref;
        if (!plan.isCube()) {
            return false;
        }
        double d = this.xv[viewSimple.n];
        double d2 = this.yv[viewSimple.n];
        int n = plan.getDepth();
        int[] nArray = new int[n];
        try {
            for (int i = 0; i < n; ++i) {
                nArray[i] = plan.getPixel8bit(i, d, d2) & 0xFF;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.plan.aladin.calque.zoom.zoomView.setCut(this, nArray, 0);
        return true;
    }
}

