/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AppMessagingInterface;
import cds.aladin.BasicNode;
import cds.aladin.Calib;
import cds.aladin.Fov;
import cds.aladin.MetaDataTree;
import cds.aladin.Server;
import cds.aladin.ServerAladin;
import cds.aladin.TreeBuilder;
import cds.tools.Util;
import java.awt.Color;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class ResourceNode
extends BasicNode
implements Cloneable {
    static final int VOID = 0;
    static final int IMAGE = 1;
    static final int CAT = 2;
    static final int SPECTRUM = 3;
    static final int CUBE = 4;
    static final int INFO = 5;
    static final int CHARAC = 6;
    static final int OTHER = 7;
    String format;
    int type = 0;
    String[] formats;
    String curFormat;
    boolean[] hidden;
    boolean hasData = false;
    private double distanceToCenter = Double.NaN;
    String[] axes;
    String[] units;
    String[] dimeq;
    String[] scaleq;
    String[] modes;
    String curMode;
    private String pixSize;
    private double pixSizeDeg;
    String obsDate;
    String origin;
    String wavelength;
    String wavelengthExpla;
    String indexing;
    String[] siapSortFields;
    String objet;
    String targetObjet;
    String refNumber;
    Color col;
    private Fov fov;
    int ra = -1;
    int de = -1;
    boolean cutout = false;
    private String cutoutTarget;
    private String mosaicTarget;
    String curImgNumber = "1";
    String maxImgNumber = "1";
    double beginVel = 0.0;
    double velStep = 0.0;
    Server server;
    String location;
    String gluLink;
    String resol;
    String survey;
    String bandPass;
    String epoch;
    String machine;
    String plateNumber;
    String[] description;
    String[] explanation;
    String[] originalExpla;
    String[] ucds;
    String[] utypes;
    String[] allUnits;
    String[] filterDesc;
    String[] filterExpla;
    String criteria;
    String valueCriteria;
    String desc;
    String dataOrga;
    String xPos;
    String yPos;
    String[] sortCriteria;
    Hashtable criteriaVal;
    Hashtable properties;
    Hashtable links;
    boolean isSIAPEvol = false;
    Hashtable propertiesUnits;

    ResourceNode(Aladin aladin) {
        super(aladin);
    }

    ResourceNode(Aladin aladin, ResourceNode resourceNode) {
        super(aladin, resourceNode);
        this.properties = resourceNode.properties;
        this.links = resourceNode.links;
        this.propertiesUnits = resourceNode.propertiesUnits;
        this.type = resourceNode.type;
        this.ra = resourceNode.ra;
        this.de = resourceNode.de;
        this.col = null;
        this.fov = resourceNode.fov;
        this.cutout = resourceNode.cutout;
        this.survey = resourceNode.survey;
        this.bandPass = resourceNode.bandPass;
        this.epoch = resourceNode.epoch;
        this.resol = resourceNode.resol;
        this.machine = resourceNode.machine;
        this.plateNumber = resourceNode.plateNumber;
        this.description = resourceNode.description;
        if (resourceNode.explanation != null) {
            this.explanation = new String[resourceNode.explanation.length];
            for (int i = 0; i < resourceNode.explanation.length; ++i) {
                this.explanation[i] = resourceNode.explanation[i];
            }
        }
        this.filterDesc = resourceNode.filterDesc;
        this.filterExpla = resourceNode.filterExpla;
        this.sortCriteria = resourceNode.sortCriteria;
        this.criteriaVal = resourceNode.criteriaVal;
        this.criteria = resourceNode.criteria;
        this.valueCriteria = resourceNode.valueCriteria;
        this.location = resourceNode.location;
        this.gluLink = resourceNode.gluLink;
        this.server = resourceNode.server;
        this.cutoutTarget = resourceNode.cutoutTarget;
        this.formats = resourceNode.formats;
        this.curFormat = resourceNode.curFormat;
        this.pixSize = resourceNode.pixSize;
        this.pixSizeDeg = resourceNode.pixSizeDeg;
        this.obsDate = resourceNode.obsDate;
        this.modes = resourceNode.modes;
        this.curMode = resourceNode.curMode;
        this.objet = resourceNode.objet;
        this.targetObjet = resourceNode.targetObjet;
        this.origin = resourceNode.origin;
        this.wavelengthExpla = resourceNode.wavelengthExpla;
        this.indexing = resourceNode.indexing;
        this.curImgNumber = resourceNode.curImgNumber;
        this.maxImgNumber = resourceNode.maxImgNumber;
        this.desc = resourceNode.desc;
        this.refNumber = resourceNode.refNumber;
        this.axes = resourceNode.axes;
        this.units = resourceNode.units;
        this.dimeq = resourceNode.dimeq;
        this.scaleq = resourceNode.scaleq;
        this.format = resourceNode.format;
        this.siapSortFields = resourceNode.siapSortFields;
        this.originalExpla = resourceNode.originalExpla;
        this.ucds = resourceNode.ucds;
        this.utypes = resourceNode.utypes;
        this.allUnits = resourceNode.allUnits;
        this.hidden = resourceNode.hidden;
        this.dataOrga = resourceNode.dataOrga;
        this.xPos = resourceNode.xPos;
        this.yPos = resourceNode.yPos;
        this.hasData = resourceNode.hasData;
        this.distanceToCenter = resourceNode.distanceToCenter;
    }

    ResourceNode(Aladin aladin, String string) {
        super(aladin, string);
    }

    ResourceNode(Aladin aladin, String string, boolean bl, boolean bl2) {
        super(aladin, string, bl, bl2);
    }

    public Object clone() {
        ResourceNode resourceNode = null;
        try {
            resourceNode = (ResourceNode)super.clone();
        }
        catch (Exception exception) {
            System.err.println("Can't clone !!");
            exception.printStackTrace();
        }
        resourceNode.children = new Vector();
        resourceNode.nbChildren = 0;
        for (int i = 0; i < this.children.size(); ++i) {
            resourceNode.addChild((ResourceNode)((ResourceNode)this.children.elementAt(i)).clone());
        }
        return resourceNode;
    }

    @Override
    public BasicNode createNode(String string) {
        return new ResourceNode(this.aladin, string);
    }

    public void setCutoutTarget(String string) {
        this.setCutoutTarget(string, true);
    }

    public void setCutoutTarget(String string, boolean bl) {
        if (string != null && string.length() > 0) {
            this.cutoutTarget = string;
            if (bl && this.aladin.getFrameInfo().getNode() != null && this.aladin.getFrameInfo().getNode().equals(this)) {
                this.aladin.getFrameInfo().setTargetTF(string);
            }
        }
    }

    public String getCutoutTarget() {
        return this.cutoutTarget;
    }

    public void setMosaicTarget(String string) {
        this.setMosaicTarget(string, true);
    }

    public void setMosaicTarget(String string, boolean bl) {
        if (string != null && string.length() > 0) {
            this.mosaicTarget = string;
            if (bl && this.aladin.getFrameInfo().getNode() != null && this.aladin.getFrameInfo().getNode().equals(this)) {
                this.aladin.getFrameInfo().setMosaicTargetTF(string);
            }
        }
    }

    public String getMosaicTarget() {
        return this.mosaicTarget;
    }

    public void setImagePosTarget(String string, String string2) {
        this.setImagePosTarget(string, string2, true);
    }

    public void setImagePosTarget(String string, String string2, boolean bl) {
        if (string != null && string.length() > 0) {
            this.xPos = string;
            this.yPos = string2;
            if (bl && this.aladin.getFrameInfo().getNode() != null && this.aladin.getFrameInfo().getNode().equals(this)) {
                this.aladin.getFrameInfo().setImagePosTargeTFt(string, string2);
            }
        }
    }

    public String[] getImagePosTarget() {
        return new String[]{this.xPos == null ? "" : this.xPos, this.yPos == null ? "" : this.yPos};
    }

    protected boolean isAvailableFormat(String string) {
        if (this.formats == null || string == null) {
            return false;
        }
        for (int i = 0; i < this.formats.length; ++i) {
            if (!string.equalsIgnoreCase(this.formats[i])) continue;
            return true;
        }
        return false;
    }

    protected Fov getFov() {
        if (this.modes != null && this.modes.length > 0 && this.curMode.equals("MOSAIC")) {
            Fov fov;
            try {
                fov = new Fov(MetaDataTree.resolveTarget(this.getMosaicTarget(), this.aladin), this.fov.x, this.fov.y, this.fov.angle);
            }
            catch (Exception exception) {
                return null;
            }
            return fov;
        }
        return this.fov;
    }

    protected void setFov(Fov fov) {
        this.fov = fov;
    }

    public String getFieldValFromUcd(String string, boolean bl) {
        int n = Util.indexInArrayOf(string, this.ucds);
        if (n < 0) {
            return null;
        }
        return bl ? this.originalExpla[n] : this.explanation[n];
    }

    public String getFieldValFromUcd(String string) {
        return this.getFieldValFromUcd(string, false);
    }

    public String getFieldValFromUtype(String string) {
        int n = Util.indexInArrayOf(string, this.utypes);
        if (n < 0) {
            return null;
        }
        return this.explanation[n];
    }

    public String getFieldValFromName(String string) {
        int n = Util.indexInArrayOf(string, this.description);
        if (n < 0) {
            return null;
        }
        return this.explanation[n];
    }

    public Calib getCalib() {
        double d;
        int n;
        int n2;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        Aladin.trace(3, "Trying to build a calibration for a color image");
        Aladin.trace(3, "Looking for CRPIX");
        String string = this.getFieldValFromUcd("VOX:WCS_CoordRefPixel", true);
        if (string == null || string.length() == 0) {
            string = this.getFieldValFromUcd("pos.wcs.crpix", true);
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = TreeBuilder.split(string, " ,");
        if (stringArray.length < 2) {
            return null;
        }
        try {
            d9 = Double.valueOf(stringArray[0]);
            d8 = Double.valueOf(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        Aladin.trace(3, "Looking for CRVAL");
        String string2 = this.getFieldValFromUcd("VOX:WCS_CoordRefValue", true);
        if (string2 == null || string2.length() == 0) {
            string2 = this.getFieldValFromUcd("pos.wcs.crval", true);
        }
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String[] stringArray2 = TreeBuilder.split(string2, " ,");
        if (stringArray2.length < 2) {
            return null;
        }
        try {
            d7 = Double.valueOf(stringArray2[0]);
            d6 = Double.valueOf(stringArray2[1]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        Aladin.trace(3, "Looking for CDMatrix");
        String string3 = this.getFieldValFromUcd("VOX:WCS_CDMatrix", true);
        if (string3 == null || string3.length() == 0) {
            string3 = this.getFieldValFromUcd("pos.wcs.cdmatrix", true);
        }
        if (string3 == null || string3.length() == 0) {
            return null;
        }
        String[] stringArray3 = TreeBuilder.split(string3, " ,");
        if (stringArray3.length < 4) {
            return null;
        }
        try {
            d5 = Double.valueOf(stringArray3[0]);
            d4 = Double.valueOf(stringArray3[1]);
            d3 = Double.valueOf(stringArray3[2]);
            d2 = Double.valueOf(stringArray3[3]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        Aladin.trace(3, "Looking for NAXIS");
        String string4 = this.getFieldValFromUcd("VOX:Image_Naxis", true);
        if (string4 == null || string4.length() == 0) {
            string4 = this.getFieldValFromUcd("pos.wcs.naxis", true);
        }
        if (string4 == null || string4.length() == 0) {
            return null;
        }
        String[] stringArray4 = TreeBuilder.split(string4, " ,");
        if (stringArray4.length < 2) {
            return null;
        }
        try {
            n2 = Integer.valueOf(stringArray4[0]);
            n = Integer.valueOf(stringArray4[1]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        Aladin.trace(3, "Looking for projection");
        String string5 = this.getFieldValFromUcd("VOX:WCS_CoordProjection", true);
        if (string5 == null || string5.length() == 0) {
            string5 = this.getFieldValFromUcd("pos.wcs.ctype", true);
        }
        if (string5 == null || string5.length() == 0) {
            return null;
        }
        int n3 = Calib.getProjType(string5);
        if (n3 < 0) {
            return null;
        }
        Aladin.trace(3, "Looking for equinox");
        String string6 = this.getFieldValFromUcd("VOX:STC_CoordEquinox", true);
        if (string6 == null || string6.length() == 0) {
            d = 2000.0;
        }
        try {
            d = Double.valueOf(string6);
        }
        catch (Exception exception) {
            d = 2000.0;
        }
        Aladin.trace(3, "Looking for coord ref frame");
        String string7 = this.getFieldValFromUcd("VOX:STC_CoordRefFrame", true);
        if (string7 == null || string7.length() == 0) {
            string7 = this.getFieldValFromUcd("pos.frame", true);
        }
        if (string7 == null || string7.length() == 0) {
            string7 = "ICRS";
        }
        return new Calib(d7, d6, d9, d8, n2, n, d5, d4, d3, d2, d, 2000.0, n3);
    }

    protected boolean isColorImage() {
        return this.curFormat != null && (this.curFormat.indexOf("png") >= 0 || this.curFormat.indexOf("jpeg") >= 0 || this.curFormat.indexOf("gif") >= 0 || this.curFormat.indexOf("tif") >= 0);
    }

    protected Map getMetadata() {
        Hashtable<String, String> hashtable;
        block4: {
            hashtable = new Hashtable<String, String>();
            try {
                for (int i = 0; i < this.ucds.length; ++i) {
                    String string = this.originalExpla[i];
                    if (this.ucds[i] != null && this.ucds[i].length() > 0) {
                        hashtable.put(this.ucds[i], string);
                    }
                    if (this.utypes[i] == null || this.utypes[i].length() <= 0) continue;
                    hashtable.put(this.utypes[i], string);
                }
            }
            catch (Exception exception) {
                System.out.println("problem while extracting metadata");
                if (Aladin.levelTrace < 3) break block4;
                exception.printStackTrace();
            }
        }
        return hashtable;
    }

    protected String getPixSize() {
        return this.pixSize;
    }

    protected void setPixSize(String string) {
        if (string != null && string.charAt(0) == '-') {
            string = string.substring(1);
        }
        this.pixSize = string;
    }

    protected double getPixSizeDeg() {
        return this.pixSizeDeg;
    }

    protected void setPixSizeDeg(double d) {
        this.pixSizeDeg = d = Math.abs(d);
    }

    protected AppMessagingInterface.AbstractMessage getPlasticMsg() {
        if (this.format != null && (this.format.equals("application/fits-euro3d") || this.format.equals("application/fits-flames-giraffe"))) {
            return AppMessagingInterface.ABSTRACT_MSG_LOAD_FITS;
        }
        if (this.type == 1) {
            return AppMessagingInterface.ABSTRACT_MSG_LOAD_FITS;
        }
        if (this.type == 2) {
            return AppMessagingInterface.ABSTRACT_MSG_LOAD_VOT_FROM_URL;
        }
        if (this.type == 3) {
            return AppMessagingInterface.ABSTRACT_MSG_LOAD_SPECTRUM_FROM_URL;
        }
        if (this.type == 6) {
            return AppMessagingInterface.ABSTRACT_MSG_LOAD_CHARAC_FROM_URL;
        }
        return null;
    }

    protected String getLocation() {
        if (this.curFormat != null && this.curFormat.indexOf("image/tif") >= 0 && this.location != null && this.location.startsWith("http")) {
            return this.getConvertProxyUrl(this.location);
        }
        return this.location;
    }

    protected boolean matchFreeConstraint(String string, boolean bl) {
        if (bl) {
            string = string.toLowerCase();
        }
        for (int i = 0; i < this.explanation.length; ++i) {
            String string2 = this.explanation[i];
            if (string2 != null && bl) {
                string2 = string2.toLowerCase();
            }
            if (string2 == null || string2.indexOf(string) < 0) continue;
            return true;
        }
        return false;
    }

    protected boolean matchFieldConstraint(String string, String string2, boolean bl) {
        if (bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        for (int i = 0; i < this.description.length; ++i) {
            String string3 = this.description[i];
            String string4 = this.ucds[i];
            String string5 = this.utypes[i];
            String string6 = this.explanation[i];
            if (bl) {
                if (string3 != null) {
                    string3 = string3.toLowerCase();
                }
                if (string4 != null) {
                    string4 = string4.toLowerCase();
                }
                if (string5 != null) {
                    string5 = string5.toLowerCase();
                }
                if (string6 != null) {
                    string6 = string6.toLowerCase();
                }
            }
            if (!(string3 != null && string3.indexOf(string) >= 0 || string4 != null && string4.indexOf(string) >= 0) && (string5 == null || string5.indexOf(string) < 0) || string6 == null || string6.indexOf(string2) < 0) continue;
            return true;
        }
        return false;
    }

    private String getConvertProxyUrl(String string) {
        URL uRL = this.aladin.glu.getURL("ConvertToJpg");
        if (string == null || uRL == null) {
            return null;
        }
        return uRL + URLEncoder.encode(string);
    }

    protected String getScriptCommand() {
        if (this.server == null || !(this.server instanceof ServerAladin)) {
            return null;
        }
        String string = "get aladin(";
        string = string + this.survey;
        if (this.bandPass != null) {
            string = string + "," + this.bandPass;
        }
        string = string + ") ";
        String string2 = this.cutoutTarget != null ? this.cutoutTarget : this.getFov().alpha + " " + this.getFov().delta;
        string = string + string2;
        return string;
    }

    public double getDistanceToCenter() {
        return this.distanceToCenter;
    }

    public void setDistanceToCenter(double d) {
        this.distanceToCenter = d;
    }
}

