/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyRobot;
import cds.aladin.ScriptFactory;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class RobotAction {
    public static RobotAction PUSH = new RobotAction();
    public static RobotAction TYPE = new RobotAction();
    public static RobotAction PAUSE = new RobotAction();
    public static RobotAction SELECT = new RobotAction();
    public static RobotAction TOFRONT = new RobotAction();
    public static RobotAction ADJUSTPOS = new RobotAction();
    public static RobotAction INFO = new RobotAction();
    private RobotAction action = null;
    private String comp;
    private String optParam;
    String paramSet;

    public RobotAction() {
    }

    public RobotAction(RobotAction robotAction, String string, String string2) {
        this.setAction(robotAction);
        this.setComp(string.trim());
        this.setParam(ScriptFactory.decode(string2));
    }

    public void doAction(Point point, Component component, Aladin aladin) {
        if (this.action == null) {
            return;
        }
        if (this.action == PUSH) {
            point.setLocation(point.x + 5, point.y + 2);
            Window window = SwingUtilities.getWindowAncestor(component);
            if (window != null) {
                window.toFront();
            }
            MyRobot.moveTo(point.x, point.y, aladin);
            MyRobot.press(point, component);
        } else if (this.action == TYPE) {
            point.setLocation(point.x + 5, point.y + 7);
            MyRobot.moveTo(point.x, point.y, aladin);
            MyRobot.press(point, component);
            MyRobot.type(this.paramSet, component);
        } else if (this.action == PAUSE) {
            int n = 1000;
            if (this.optParam != null) {
                try {
                    n = Integer.parseInt(this.optParam);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            MyRobot.pause(n);
        } else if (this.action == SELECT) {
            MyRobot.select(this.paramSet, component, point);
        } else if (this.action == TOFRONT) {
            MyRobot.toFront(component);
        } else if (this.action == ADJUSTPOS) {
            MyRobot.adjustPos(component);
        } else if (this.action == INFO) {
            MyRobot.info(this.optParam, aladin);
        }
    }

    public static RobotAction getActionFromString(String string) {
        if (string.equals("ADJUSTPOS")) {
            return ADJUSTPOS;
        }
        if (string.equals("PAUSE")) {
            return PAUSE;
        }
        if (string.equals("PUSH")) {
            return PUSH;
        }
        if (string.equals("SELECT")) {
            return SELECT;
        }
        if (string.equals("TOFRONT")) {
            return TOFRONT;
        }
        if (string.equals("TYPE")) {
            return TYPE;
        }
        if (string.equals("INFO")) {
            return INFO;
        }
        return null;
    }

    public RobotAction getAction() {
        return this.action;
    }

    public void setAction(RobotAction robotAction) {
        this.action = robotAction;
    }

    public String getComp() {
        return this.comp;
    }

    public void setComp(String string) {
        this.comp = string;
    }

    public String getParam() {
        return this.optParam;
    }

    public void setParam(String string) {
        this.optParam = string;
    }
}

