/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AppMessagingInterface;
import cds.aladin.Coord;
import cds.aladin.FrameServer;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanImage;
import cds.aladin.PlaneLoadEvent;
import cds.aladin.PlaneLoadListener;
import cds.aladin.PlasticWidget;
import cds.aladin.SAMPUtil;
import cds.aladin.Save;
import cds.aladin.Source;
import cds.aladin.VOResource;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.astrogrid.samp.hub.Hub;
import org.astrogrid.samp.hub.HubServiceMode;

public class SAMPManager
implements AppMessagingInterface,
XmlRpcHandler,
PlaneLoadListener {
    protected static final String NOTIFY = "samp.hub.notify";
    protected static final String NOTIFY_ALL = "samp.hub.notifyAll";
    protected static final String KEY_SELF_ID = "samp.self-id";
    protected static final String KEY_HUB_ID = "samp.hub-id";
    protected static final String KEY_PRIVATE_KEY = "samp.private-key";
    protected static final String KEY_MTYPE = "samp.mtype";
    protected static final String KEY_PARAMS = "samp.params";
    protected static final String METHOD_RECEIVE_NOTIFICATION = "samp.client.receiveNotification";
    protected static final String METHOD_RECEIVE_CALL = "samp.client.receiveCall";
    protected static final String METHOD_RECEIVE_RESPONSE = "samp.client.receiveResponse";
    protected static final String HUB_MSG_REGISTER = "samp.hub.register";
    protected static final String HUB_MSG_DECLARE_METADATA = "samp.hub.declareMetadata";
    protected static final String HUB_MSG_DECLARE_SUBSCRIPTIONS = "samp.hub.declareSubscriptions";
    protected static final String HUB_MSG_UNREGISTER = "samp.hub.unregister";
    protected static final String HUB_MSG_PING = "samp.hub.ping";
    protected static final String HUB_MSG_DISCONNECT = "samp.hub.disconnect";
    protected static final String HUB_MSG_REPLY = "samp.hub.reply";
    protected static final String HUB_MSG_GET_REGISTERED_CLIENTS = "samp.hub.getRegisteredClients";
    protected static final String HUB_MSG_GET_METADATA = "samp.hub.getMetadata";
    protected static final String HUB_MSG_GET_SUBSCRIBED_CLIENTS = "samp.hub.getSubscribedClients";
    protected static final String HUB_MSG_SHUTDOWN = "samp.hub.event.shutdown";
    protected static final String HUB_MSG_REGISTRATION = "samp.hub.event.register";
    protected static final String HUB_MSG_UNREGISTRATION = "samp.hub.event.unregister";
    protected static final String HUB_MSG_SUBSCRIPTIONS = "samp.hub.event.subscriptions";
    protected static final String MSG_LOAD_FITS_IMAGE = "image.load.fits";
    protected static final String MSG_POINT_AT_COORDS = "coord.pointAt.sky";
    protected static final String MSG_LOAD_VOT_FROM_URL = "table.load.votable";
    protected static final String MSG_LOAD_FITS_TABLE_FROM_URL = "table.load.fits";
    protected static final String MSG_LOAD_FITS_MOC_COVERAGE = "coverage.load.moc.fits";
    protected static final String MSG_HIGHLIGHT_OBJECT = "table.highlight.row";
    protected static final String MSG_SELECT_OBJECTS = "table.select.rowList";
    protected static final String MSG_LOAD_SPECTRUM = "spectrum.load.ssa-generic";
    protected static final String MSG_SEND_ALADIN_SCRIPT_CMD = "script.aladin.send";
    protected static final String MSG_GET_COORDS = "coord.get.sky";
    protected static final String MSG_GET_SNAPSHOT = "snapshot.get.jpg";
    protected static final String MSG_PING = "samp.app.ping";
    protected static final String[] SUPPORTED_MESSAGES = new String[]{"image.load.fits", "coord.pointAt.sky", "coord.get.sky", "snapshot.get.jpg", "table.load.votable", "table.load.fits", "table.highlight.row", "table.select.rowList", "samp.app.ping", "script.aladin.send", "samp.hub.event.shutdown", "samp.hub.event.register", "samp.hub.event.unregister", "samp.hub.event.subscriptions", "samp.hub.disconnect"};
    protected static final String MSG_REPLY_SAMP_STATUS = "samp.status";
    protected static final String MSG_REPLY_SAMP_STATUSOK = "samp.ok";
    protected static final String MSG_REPLY_SAMP_STATUSERROR = "samp.error";
    protected static final String MSG_REPLY_SAMP_RESULT = "samp.result";
    protected static final String MSG_REPLY_SAMP_ERROR = "samp.error";
    private Hashtable<Plan, String> planesToMsgIds = new Hashtable();
    protected static final String ALADIN_NAME = "Aladin";
    protected static final String ALADIN_IVORN = "ivo://CDS/Aladin";
    protected static final String SAMP_CONF_FILE = ".samp";
    private int curState = 0;
    private boolean updateAppsListNeeded = true;
    protected static final String ALADIN_DESC = "ALADIN is an interactive software sky atlas developed by the CDS, allowing one to visualize digitized imagesof any part of the sky, to superimpose entries from astronomical catalogs,and to interactively access related data and information.";
    static String LAUNCH_INTERNAL_HUB;
    static String CANT_CONNECT;
    static String CANT_LAUNCH_HUB;
    static String HUB_STOP;
    static String EXCEPTION;
    static String CONFIRM_STOP_HUB;
    private Aladin a;
    private boolean isRegistered = false;
    private PlasticWidget widget;
    private String hubUrl;
    private String sampSecret;
    private XmlRpcClient hubClient;
    private WebServer aladinXmlRpcServer;
    private static final String SAMP_SECRET_KEY = "samp.secret";
    private static final String SAMP_HUB_URL_KEY = "samp.hub.xmlrpc.url";
    private String selfId;
    private String hubId;
    private String myPrivateKey;
    static int startPort;
    private Hub internalHub;
    public static final String LOCALHOST_PROP = "samp.localhost";
    private Hashtable appNamesToURI;
    private Vector appNames;
    private static final Object VOID;
    private static final Object TRUE;
    private static final Object FALSE;
    Integer oidx;
    String oid;
    ResourceChooser resourceChooser;
    private Plan lastPlaneWithSelectedSrc;
    private boolean sampTrace = false;

    public SAMPManager(Aladin aladin) {
        this.a = aladin;
        this.createChaine();
    }

    private void createChaine() {
        String string = this.getProtocolName();
        LAUNCH_INTERNAL_HUB = Aladin.chaine.getString("PMLAUNCHHUB").replaceAll("SAMP", string);
        CANT_CONNECT = Aladin.chaine.getString("PMCANTCONNECT").replaceAll("SAMP", string);
        CANT_LAUNCH_HUB = Aladin.chaine.getString("PMCANTLAUNCHHUB").replaceAll("SAMP", string);
        HUB_STOP = Aladin.chaine.getString("PMHUBWILLSTOP").replaceAll("SAMP", string);
        EXCEPTION = Aladin.chaine.getString("PMEXCEPTION").replaceAll("SAMP", string);
        CONFIRM_STOP_HUB = Aladin.chaine.getString("PMCONFIRMSTOPHUB").replaceAll("SAMP", string);
    }

    @Override
    public boolean register(boolean bl, boolean bl2) {
        Object object;
        Hashtable<String, String> hashtable;
        this.trace("Try to register Aladin with the SAMP hub");
        if (this.isRegistered()) {
            this.trace("Aladin was already registered !");
            return true;
        }
        if (!this.getHubListener(bl, bl2)) {
            this.trace("Could not register to the SAMP hub");
            return false;
        }
        boolean bl3 = false;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.sampSecret);
        try {
            hashtable = (Hashtable<String, String>)this.hubClient.execute(HUB_MSG_REGISTER, vector);
            this.myPrivateKey = hashtable.get(KEY_PRIVATE_KEY).toString();
            this.selfId = hashtable.get(KEY_SELF_ID).toString();
            this.hubId = hashtable.get(KEY_HUB_ID).toString();
            this.trace("Aladin has registered, self-id=" + this.selfId);
        }
        catch (Exception exception) {
            bl3 = true;
        }
        if (bl3) {
            this.isRegistered = false;
        } else {
            this.isRegistered = true;
            Aladin.trace(3, "Successful registration with the SAMP hub");
        }
        vector = new Vector();
        hashtable = new Hashtable<String, String>();
        hashtable.put("samp.name", ALADIN_NAME);
        hashtable.put("samp.description.text", "The Aladin sky atlas and VO Portal");
        hashtable.put("samp.icon.url", "http://aladin.u-strasbg.fr/aladin_large.gif");
        hashtable.put("samp.documentation.url", "http://aladin.u-strasbg.fr/java/FAQ.htx");
        hashtable.put("author.name", "Pierre Fernique, Thomas Boch");
        hashtable.put("author.email", "pierre.fernique@astro.unistra.fr");
        hashtable.put("author.affiliation", "CDS, Observatoire astronomique de Strasbourg");
        hashtable.put("home.page", "http://aladin.u-strasbg.fr/");
        hashtable.put("aladin.version", "v9.033a");
        vector.add(this.myPrivateKey);
        vector.add(hashtable);
        try {
            object = this.hubClient.execute(HUB_MSG_DECLARE_METADATA, vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = SAMPManager.findFreePort();
        this.aladinXmlRpcServer = new WebServer(n);
        this.aladinXmlRpcServer.start();
        String string = "http://" + SAMPManager.getLocalhost() + ":" + n + "/";
        this.trace(" Aladin callback address is: " + string);
        this.aladinXmlRpcServer.addHandler("samp.client", this);
        vector = new Vector();
        vector.add(this.myPrivateKey);
        vector.add(string);
        try {
            this.trace("setting Aladin XMLRPC callback : " + string);
            object = this.hubClient.execute("samp.hub.setXmlrpcCallback", vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        vector = new Vector();
        vector.add(this.myPrivateKey);
        Hashtable hashtable2 = new Hashtable();
        for (int i = 0; i < SUPPORTED_MESSAGES.length; ++i) {
            Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
            hashtable3.put("x-samp.mostly-harmless", "1");
            hashtable2.put(SUPPORTED_MESSAGES[i], hashtable3);
        }
        vector.add(hashtable2);
        try {
            object = this.hubClient.execute(HUB_MSG_DECLARE_SUBSCRIPTIONS, vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.widget != null) {
            this.widget.updateStatus(this.isRegistered());
        }
        this.updateState();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object execute(String string, Vector vector) throws XmlRpcException {
        this.trace("Receiving XML request :\nmethod=" + string + "\nparams=" + vector);
        if (string.equals(METHOD_RECEIVE_NOTIFICATION) || string.equals(METHOD_RECEIVE_CALL)) {
            Object object = TRUE;
            String string2 = (String)vector.get(1);
            boolean bl = string.equals(METHOD_RECEIVE_CALL);
            String string3 = null;
            if (bl) {
                string3 = (String)vector.get(2);
            }
            int n = bl ? 3 : 2;
            Map map = (Map)vector.get(n);
            Object v = map.get(KEY_MTYPE);
            Map map2 = (Map)map.get(KEY_PARAMS);
            if (v == null || map2 == null) {
                System.err.println("mtype or msgParams is null");
                return null;
            }
            this.trace("msgParams is " + map2);
            this.trace("mType is " + v);
            if (v.equals(HUB_MSG_SHUTDOWN)) {
                this.trace("hub is shutting down");
                this.unregister(true);
                this.isRegistered = false;
                this.updateState();
            } else if (v.equals(HUB_MSG_DISCONNECT)) {
                this.trace("Hub wants us to disconnect ... proceed");
                this.unregister(true);
                this.isRegistered = false;
                this.a.dontReconnectAutomatically = true;
                this.updateState();
            } else if (v.equals(HUB_MSG_REGISTRATION)) {
                this.updateState();
            } else if (v.equals(HUB_MSG_UNREGISTRATION)) {
                this.updateState();
            } else if (v.equals(HUB_MSG_SUBSCRIPTIONS)) {
                this.updateState();
                this.updateAppsListNeeded = true;
            } else if (v.equals(MSG_PING)) {
                this.replyToMessage(string3, MSG_REPLY_SAMP_STATUSOK, null, null);
            } else if (v.equals(MSG_LOAD_VOT_FROM_URL) || v.equals(MSG_LOAD_FITS_TABLE_FROM_URL)) {
                String string4 = (String)map2.get("url");
                String string5 = (String)map2.get("table-id");
                String string6 = (String)map2.get("name");
                if (string4 == null) {
                    System.err.println("Missing URL !");
                    if (bl) {
                        this.replyToMessage(string3, "samp.error", null, "Could not load data, URL is missing !");
                    }
                    return FALSE;
                }
                String string7 = this.getNameForApp(string2);
                Plan plan = this.loadVOTFromURL(string4, string5, string6, string7);
                if (bl) {
                    if (plan == null) {
                        this.replyToMessage(string3, "samp.error", null, "Could not load VOTable !");
                    } else if (plan.flagOk) {
                        this.replyToMessage(string3, MSG_REPLY_SAMP_STATUSOK, null, null);
                    } else {
                        this.trace("Associating message ID " + string3 + " to catalogue plane " + plan.getLabel());
                        this.planesToMsgIds.put(plan, string3);
                        plan.addPlaneLoadListener(this);
                    }
                }
                Aladin.trace(3, "Receiving table " + string4);
                this.a.log("SAMP", "receiving table");
            } else if (v.equals(MSG_LOAD_FITS_IMAGE)) {
                String string8 = (String)map2.get("url");
                String string9 = (String)map2.get("image-id");
                String string10 = (String)map2.get("name");
                if (string8 == null) {
                    System.err.println("Missing URL !");
                    if (bl) {
                        this.replyToMessage(string3, "samp.error", null, "Could not load image, URL is missing !");
                    }
                    return FALSE;
                }
                if (string9 == null) {
                    string9 = string8;
                }
                String string11 = this.getNameForApp(string2);
                Plan plan = this.loadFitsImageFromURL(string8, string9, string10, string11);
                if (bl) {
                    if (plan == null) {
                        this.replyToMessage(string3, "samp.error", null, "Could not load image !");
                    } else if (plan.flagOk) {
                        this.replyToMessage(string3, MSG_REPLY_SAMP_STATUSOK, null, null);
                    } else {
                        this.trace("Associating message ID " + string3 + " to image plane " + plan.getLabel());
                        this.planesToMsgIds.put(plan, string3);
                        plan.addPlaneLoadListener(this);
                    }
                }
                Aladin.trace(3, "Receiving image " + string8);
                this.a.log("SAMP", "receiving image");
            } else if (v.equals(MSG_LOAD_FITS_MOC_COVERAGE)) {
                String string12 = (String)map2.get("url");
                String string13 = (String)map2.get("coverage-id");
                String string14 = (String)map2.get("name");
                if (string12 == null) {
                    System.err.println("Missing URL !");
                    if (bl) {
                        this.replyToMessage(string3, "samp.error", null, "Could not load MOC coverage, URL is missing !");
                    }
                    return FALSE;
                }
                if (string13 == null) {
                    string13 = string12;
                }
                String string15 = this.getNameForApp(string2);
                Plan plan = this.loadFitsImageFromURL(string12, string13, string14, string15);
                if (bl) {
                    if (plan == null) {
                        this.replyToMessage(string3, "samp.error", null, "Could not load MOC coverage !");
                    } else if (plan.flagOk) {
                        this.replyToMessage(string3, MSG_REPLY_SAMP_STATUSOK, null, null);
                    } else {
                        this.trace("Associating message ID " + string3 + " to MOC coverage plane " + plan.getLabel());
                        this.planesToMsgIds.put(plan, string3);
                        plan.addPlaneLoadListener(this);
                    }
                }
                Aladin.trace(3, "Receiving MOC " + string12);
                this.a.log("SAMP", "receiving MOC");
            } else if (v.equals(MSG_SEND_ALADIN_SCRIPT_CMD)) {
                String string16 = (String)map2.get("script");
                if (string16 == null) {
                    String string17 = "Missing script parameter !";
                    System.err.println(string17);
                    if (bl) {
                        this.replyToMessage(string3, "samp.error", null, string17);
                    }
                    return FALSE;
                }
                String string18 = this.a.execCommand(string16);
                if (bl) {
                    if (string18.startsWith("Error")) {
                        this.replyToMessage(string3, "samp.error", null, string18);
                    } else {
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        hashtable.put("script.result", string18);
                        this.replyToMessage(string3, MSG_REPLY_SAMP_STATUSOK, hashtable, null);
                    }
                }
            } else if (v.equals(MSG_POINT_AT_COORDS)) {
                block95: {
                    try {
                        double d = Double.parseDouble((String)map2.get("ra"));
                        double d2 = Double.parseDouble((String)map2.get("dec"));
                        this.a.view.gotoThere(new Coord(d, d2));
                    }
                    catch (Exception exception) {
                        String string19 = "Error while processing SAMP message coord.pointAt.sky:Missing 'ra' or 'dec' parameter or incorrect type for params";
                        this.a.command.println(string19);
                        object = FALSE;
                        exception.printStackTrace();
                        if (!bl) break block95;
                        this.replyToMessage(string3, "samp.error", null, string19);
                    }
                }
                if (bl) {
                    this.replyToMessage(string3, MSG_REPLY_SAMP_STATUSOK, null, null);
                }
            } else if (v.equals(MSG_HIGHLIGHT_OBJECT)) {
                boolean bl2;
                try {
                    bl2 = this.highlightObject((String)map2.get("table-id"), new Integer((String)map2.get("row")));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    bl2 = false;
                }
                if (bl) {
                    if (bl2) {
                        this.replyToMessage(string3, MSG_REPLY_SAMP_STATUSOK, null, null);
                    } else {
                        this.replyToMessage(string3, "samp.error", null, "Could not find object to highlight");
                    }
                }
            } else if (v.equals(MSG_SELECT_OBJECTS)) {
                String string20 = (String)map2.get("table-id");
                this.trace("id recu : " + string20);
                List list = (List)map2.get("row-list");
                int[] nArray = new int[list.size()];
                Iterator iterator = list.iterator();
                int n2 = 0;
                try {
                    while (iterator.hasNext()) {
                        nArray[n2] = Integer.parseInt((String)iterator.next());
                        ++n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    this.replyToMessage(string3, "samp.error", null, "Incorrect format for indices !");
                    return FALSE;
                }
                boolean bl3 = this.selectSources(string20, nArray);
                if (bl) {
                    if (bl3) {
                        this.replyToMessage(string3, MSG_REPLY_SAMP_STATUSOK, null, null);
                    } else {
                        this.replyToMessage(string3, "samp.error", null, "Could not find sources to select");
                    }
                }
            } else if (v.equals(MSG_GET_COORDS)) {
                if (this.a.view.repere == null || Double.isNaN(this.a.view.repere.raj) || Double.isNaN(this.a.view.repere.dej)) {
                    object = FALSE;
                    this.replyToMessage(string3, "samp.error", null, "no repere has been set");
                } else {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("ra", Double.toString(this.a.view.repere.raj));
                    hashtable.put("dec", Double.toString(this.a.view.repere.dej));
                    this.replyToMessage(string3, MSG_REPLY_SAMP_STATUSOK, hashtable, null);
                }
            } else if (v.equals(MSG_GET_SNAPSHOT)) {
                BufferedInputStream bufferedInputStream = null;
                StringBuffer stringBuffer = new StringBuffer("data:image/jpeg;base64,");
                try {
                    File file = File.createTempFile("samp", ".jpg");
                    file.deleteOnExit();
                    int n3 = 300;
                    int n4 = 300;
                    this.a.save.saveView(file.getAbsolutePath(), n4, n3, 4, 0.7f);
                    if (file.length() == 0L) {
                        this.replyToMessage(string3, "samp.error", null, "Unable to generate snapshot of current view");
                        Object object2 = FALSE;
                        return object2;
                    }
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    byte[] byArray = new byte[(int)file.length()];
                    int n5 = 0;
                    int n6 = bufferedInputStream.read(byArray, n5, byArray.length - n5);
                    while (n6 >= 0 && n5 < byArray.length) {
                        n6 = bufferedInputStream.read(byArray, n5 += n6, byArray.length - n5);
                    }
                    stringBuffer.append(Util.toB64(byArray));
                }
                catch (Exception exception) {
                    this.replyToMessage(string3, "samp.error", null, exception.getMessage());
                    Object object3 = FALSE;
                    return object3;
                }
                finally {
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("data", stringBuffer.toString().replaceAll("(\r\n|\n)", ""));
                this.replyToMessage(string3, MSG_REPLY_SAMP_STATUSOK, hashtable, null);
            } else {
                System.err.println("Unprocessed message " + v);
            }
            return object;
        }
        if (string.equals(METHOD_RECEIVE_RESPONSE)) {
            // empty if block
        }
        System.err.println("Unknown method " + string);
        return null;
    }

    static int findFreePort() {
        for (int i = startPort; i < startPort + 20; ++i) {
            try {
                Socket socket = new Socket(SAMPManager.getLocalhost(), i);
                if (socket.isClosed()) continue;
                socket.close();
                continue;
            }
            catch (ConnectException connectException) {
                startPort = i + 1;
                return i;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return -1;
            }
        }
        return -1;
    }

    protected boolean isSupporting(String string) {
        for (int i = 0; i < SUPPORTED_MESSAGES.length; ++i) {
            if (!SUPPORTED_MESSAGES[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean unregister() {
        return this.unregister(false);
    }

    @Override
    public boolean unregister(boolean bl) {
        return this.unregister(bl, false);
    }

    @Override
    public boolean unregister(boolean bl, boolean bl2) {
        block11: {
            this.trace("Try to unregister Aladin from the SAMP hub");
            if (!this.isRegistered()) {
                this.trace("Aladin is not registered with the hub, no need to unregister !");
                return true;
            }
            if (!this.getHubListener(false)) {
                this.trace("Could not unregister from the SAMP hub");
                if (bl) {
                    this.isRegistered = false;
                    this.selfId = null;
                    if (bl2) {
                        this.stopInternalHub(bl);
                    }
                    if (this.aladinXmlRpcServer != null) {
                        this.aladinXmlRpcServer.shutdown();
                    }
                    if (this.widget != null) {
                        this.widget.animateWidgetReceive(true, false);
                    }
                    this.updateState();
                }
                return false;
            }
            Vector<String> vector = new Vector<String>();
            vector.add(this.myPrivateKey);
            try {
                this.hubClient.execute(HUB_MSG_UNREGISTER, vector);
            }
            catch (Exception exception) {
                this.trace("Error while trying to unregister : " + exception.getMessage());
                if (bl) break block11;
                return false;
            }
        }
        this.isRegistered = false;
        this.selfId = null;
        if (bl2) {
            this.stopInternalHub(bl);
        }
        if (this.aladinXmlRpcServer != null) {
            this.aladinXmlRpcServer.shutdown();
        }
        if (this.widget != null) {
            this.widget.animateWidgetReceive(true, false);
        }
        this.updateState();
        Aladin.trace(3, "Successful unregistration from the SAMP hub");
        return true;
    }

    @Override
    public boolean isRegistered() {
        return this.isRegistered;
    }

    private static String getLocalhost() {
        String string = System.getProperty(LOCALHOST_PROP, "");
        if (string.length() == 0) {
            string = "127.0.0.1";
        }
        return string;
    }

    @Override
    public synchronized boolean startInternalHub() {
        Aladin.trace(1, "Starting an internal JSAMP hub");
        try {
            Logger.getLogger("org.astrogrid.samp").setLevel(Level.OFF);
            String string = SAMPManager.getLocalhost();
            System.setProperty(LOCALHOST_PROP, string);
            this.trace("Hub IP set to " + string);
            this.internalHub = Hub.runHub(HubServiceMode.NO_GUI);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        this.updateState();
        return true;
    }

    @Override
    public synchronized void stopInternalHub(boolean bl) {
        if (this.internalHub == null) {
            return;
        }
        String[] stringArray = this.getAppsConnected();
        if (!bl && stringArray.length > 0 && !Aladin.confirmation(this.widget, CONFIRM_STOP_HUB)) {
            return;
        }
        Aladin.trace(1, "Stopping internal PlasKit hub");
        this.internalHub.shutdown();
        this.internalHub = null;
        this.updateState();
    }

    private String createLabel(Plan plan) {
        return plan.label == null ? "Plane" : plan.label;
    }

    private boolean getHubListener(boolean bl) {
        return this.getHubListener(bl, false);
    }

    /*
     * Exception decompiling
     */
    private boolean getHubListener(boolean var1_1, boolean var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HashMap readKeysFromHubFile(File file) throws IOException {
        String string;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while ((string = dataInputStream.readLine()) != null) {
            int n;
            if (string.startsWith("#") || (n = string.indexOf(61)) < 0) continue;
            hashMap.put(string.substring(0, n), string.substring(n + 1));
        }
        dataInputStream.close();
        return hashMap;
    }

    @Override
    public Object getAppWithName(String string) {
        return this.appNamesToURI.get(string);
    }

    private String getNameForApp(String string) {
        if (this.appNamesToURI == null) {
            return "";
        }
        Enumeration enumeration = this.appNamesToURI.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!string.equals(this.appNamesToURI.get(k))) continue;
            return (String)k;
        }
        return "Unknown";
    }

    @Override
    public String getProtocolName() {
        return "SAMP";
    }

    @Override
    public void sendMessageLoadImage(String string, String string2, List list) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("url", string);
        hashtable.put("image-id", string);
        hashtable.put("name", string2);
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        hashtable2.put(KEY_MTYPE, MSG_LOAD_FITS_IMAGE);
        hashtable2.put(KEY_PARAMS, hashtable);
        this.sendNotification(hashtable2, list.toArray(new String[list.size()]));
    }

    public void sendMessageLoadMOC(String string, String string2, List list) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("url", string);
        hashtable.put("coverage-id", string);
        hashtable.put("name", string2);
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        hashtable2.put(KEY_MTYPE, MSG_LOAD_FITS_MOC_COVERAGE);
        hashtable2.put(KEY_PARAMS, hashtable);
        this.sendNotification(hashtable2, list.toArray(new String[list.size()]));
    }

    @Override
    public void sendMessageLoadVOTable(String string, String string2, String string3, Map map, List list) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("url", string);
        hashtable.put("table-id", string2);
        hashtable.put("meta", map);
        hashtable.put("name", string3);
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        hashtable2.put(KEY_MTYPE, MSG_LOAD_VOT_FROM_URL);
        hashtable2.put(KEY_PARAMS, hashtable);
        this.sendNotification(hashtable2, list == null ? null : list.toArray(new String[list.size()]));
    }

    @Override
    public void sendMessageLoadSpectrum(String string, String string2, String string3, Map map, List list) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("url", string);
        hashtable.put("spectrum-id", string);
        hashtable.put("meta", map);
        hashtable.put("name", string3);
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        hashtable2.put(KEY_MTYPE, MSG_LOAD_SPECTRUM);
        hashtable2.put(KEY_PARAMS, hashtable);
        this.sendNotification(hashtable2, list == null ? null : list.toArray(new String[list.size()]));
    }

    @Override
    public void sendMessageLoadCharac(String string, String string2, List list) {
        System.err.println("Not implemented yet");
    }

    public String getMessage(AppMessagingInterface.AbstractMessage abstractMessage) {
        if (abstractMessage == null) {
            return null;
        }
        if (abstractMessage.equals(ABSTRACT_MSG_LOAD_FITS)) {
            return MSG_LOAD_FITS_IMAGE;
        }
        if (abstractMessage.equals(ABSTRACT_MSG_LOAD_VOT_FROM_URL)) {
            return MSG_LOAD_VOT_FROM_URL;
        }
        if (abstractMessage.equals(ABSTRACT_MSG_LOAD_SPECTRUM_FROM_URL)) {
            return MSG_LOAD_SPECTRUM;
        }
        if (abstractMessage.equals(ABSTRACT_MSG_LOAD_CHARAC_FROM_URL)) {
            return null;
        }
        return null;
    }

    @Override
    public ArrayList<String> getAppsSupportingTables() {
        ArrayList<String> arrayList = this.getAppsSupporting(MSG_LOAD_VOT_FROM_URL);
        arrayList.addAll(this.getAppsSupporting(MSG_LOAD_FITS_TABLE_FROM_URL));
        return arrayList;
    }

    @Override
    public synchronized ArrayList<String> getAppsSupporting(AppMessagingInterface.AbstractMessage abstractMessage) {
        String string = this.getMessage(abstractMessage);
        return this.getAppsSupporting(string);
    }

    private synchronized ArrayList<String> getAppsSupporting(String string) {
        Map map;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        if (!this.isRegistered() || string == null) {
            return arrayList;
        }
        Vector<String> vector = new Vector<String>();
        vector.add(this.myPrivateKey);
        vector.add(string);
        try {
            map = (Map)this.hubClient.execute(HUB_MSG_GET_SUBSCRIBED_CLIENTS, vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return arrayList;
        }
        if (map.size() == 0) {
            return arrayList;
        }
        if (this.appNamesToURI == null) {
            this.appNamesToURI = new Hashtable();
        }
        if (this.appNames == null) {
            this.appNames = new Vector();
        }
        for (String string2 : map.keySet()) {
            if (string2.equals(this.selfId)) continue;
            String string3 = null;
            Enumeration enumeration = this.appNamesToURI.keys();
            while (string3 == null && enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                if (!this.appNamesToURI.get(string4).equals(string2)) continue;
                string3 = string4;
            }
            if (string3 == null) {
                string3 = this.getAppName(string2);
                if (string3 == null) {
                    string3 = "Unknown";
                }
                int n = 1;
                String string5 = new String(string3);
                while (this.appNames.contains(string3)) {
                    string3 = string5 + "-" + n++;
                }
                this.appNames.addElement(string3);
                this.appNamesToURI.put(string3, string2);
            }
            arrayList.add(string3);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    protected static File getLockFile() {
        String string;
        if (SAMPManager.windowsPlatform()) {
            try {
                string = System.getenv("USERPROFILE");
            }
            catch (Throwable throwable) {
                try {
                    String[] stringArray = new String[]{"cmd", "/c", "echo", "%USERPROFILE%"};
                    string = SAMPManager.exec(stringArray);
                }
                catch (Throwable throwable2) {
                    string = null;
                }
            }
            if (string == null) {
                string = System.getProperty("user.home");
            }
        } else {
            string = System.getProperty("user.home");
        }
        return new File(string, SAMP_CONF_FILE);
    }

    protected static boolean windowsPlatform() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().indexOf("windows") >= 0 || string.toLowerCase().indexOf("microsoft") >= 0;
    }

    private static String exec(String[] stringArray) throws IOException {
        String string;
        Process process;
        String string2 = Arrays.asList(stringArray).toString();
        try {
            process = Runtime.getRuntime().exec(stringArray);
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Execution failed: " + string2);
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("Execution failed: " + string2).initCause(iOException);
        }
        if (process.exitValue() == 0) {
            return SAMPManager.readStream(process.getInputStream());
        }
        try {
            string = SAMPManager.readStream(process.getErrorStream());
        }
        catch (IOException iOException) {
            string = "??";
        }
        throw new IOException("Execution failed: " + string2 + " - " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStream(InputStream inputStream) throws IOException {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = inputStream.read()) >= 0) {
                stringBuffer.append((char)n);
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean selectSources(String string, int[] nArray) {
        if (string == null) {
            this.trace("selectSources : argument is null, can't do anything !");
            return false;
        }
        Plan plan = this.findPlaneByPlasticID(string);
        if (plan == null) {
            this.trace("Could not find plane with plastic ID " + string);
            return false;
        }
        if (nArray == null) {
            this.trace("selectSources : second parameter is null, can't do anything !");
            return false;
        }
        this.a.view.selectSourcesByRowNumber((PlanCatalog)plan, nArray);
        return true;
    }

    @Override
    public void pointAtCoords(final double d, final double d2) {
        if (this.hubClient == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("ra", String.valueOf(d));
                hashtable.put("dec", String.valueOf(d2));
                Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                hashtable2.put(SAMPManager.KEY_MTYPE, SAMPManager.MSG_POINT_AT_COORDS);
                hashtable2.put(SAMPManager.KEY_PARAMS, hashtable);
                SAMPManager.this.sendNotification(hashtable2, null);
            }
        }.start();
    }

    private synchronized boolean highlightObject(String string, Integer n) {
        this.oid = string;
        this.oidx = n;
        Plan plan = this.findPlaneByPlasticID(string);
        if (plan == null) {
            this.trace("Could not find plane with plastic ID " + string);
            return false;
        }
        if (n >= plan.pcat.getCount()) {
            return false;
        }
        Source source = (Source)plan.pcat.getObj(n);
        if (this.a.mesure.findSrc(source) == -1) {
            this.a.view.setSelected(source, true);
        }
        this.a.mesure.mcanvas.show(source, 2);
        this.a.view.gotoThere(source);
        return true;
    }

    private synchronized Plan loadVOTFromURL(String string, String string2, String string3, String string4) {
        int n;
        String string5;
        MyInputStream myInputStream;
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.trace("The provided URL string is malformed, can not load VOTable file !");
            return null;
        }
        try {
            myInputStream = Util.openStream(uRL);
        }
        catch (IOException iOException) {
            this.trace("IOException occured when getting stream from VOTable URL, loading is aborted");
            return null;
        }
        catch (Exception exception) {
            this.trace("Exception occured when getting stream from VOTable URL, loading is aborted");
            return null;
        }
        String string6 = string5 = string3 == null ? "SAMP" : string3;
        if (string3 == null && string2 != null && !string2.startsWith("http")) {
            string5 = string2;
        }
        if ((n = this.a.calque.newPlan(myInputStream, string5, string4)) >= 0) {
            Plan plan = this.a.calque.plan[n];
            plan.addPlasticID(string2);
            return plan;
        }
        return null;
    }

    private synchronized Plan loadFitsImageFromURL(String string, String string2, String string3, String string4) {
        int n;
        String string5;
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.trace("The provided URL string is malformed, can not load FITS file !");
            return null;
        }
        String string6 = string5 = string3 == null ? "SAMP" : string3;
        if (string3 == null && string2 != null && !string2.startsWith("http")) {
            string5 = string2;
        }
        if ((n = this.a.calque.newPlan(string, string5, string4)) >= 0) {
            Plan plan = this.a.calque.plan[n];
            plan.addPlasticID(string2);
            return plan;
        }
        return null;
    }

    private synchronized Plan loadVOT(String string, String string2, URI uRI) {
        int n = this.a.calque.newPlan(new ByteArrayInputStream(string.getBytes()), "SAMP", uRI.toString());
        if (n >= 0) {
            Plan plan = this.a.calque.plan[n];
            plan.addPlasticID(string2);
            return plan;
        }
        return null;
    }

    protected boolean supportMessage(URI uRI) {
        return true;
    }

    protected boolean mustProcessMessage(URI uRI, URI uRI2) {
        return true;
    }

    protected Map getAppMetadata(String string) {
        try {
            Vector<String> vector = new Vector<String>();
            vector.add(this.myPrivateKey);
            vector.add(string);
            return (Map)this.hubClient.execute(HUB_MSG_GET_METADATA, vector);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getAppName(String string) {
        Map map = this.getAppMetadata(string);
        if (map == null) {
            return null;
        }
        Object v = map.get("samp.name");
        return v != null ? v.toString() : null;
    }

    private void sendNotification(Map map, String[] stringArray) {
        if (!this.isRegistered) {
            return;
        }
        if (stringArray == null) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(this.myPrivateKey);
            vector.add(map);
            try {
                this.hubClient.execute(NOTIFY_ALL, vector);
            }
            catch (Exception exception) {
                System.err.println("Problem when sending message " + map);
                exception.printStackTrace();
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                Vector<Object> vector = new Vector<Object>();
                vector.add(this.myPrivateKey);
                vector.add(stringArray[i]);
                vector.add(map);
                try {
                    this.hubClient.execute(NOTIFY, vector);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Problem when sending message " + map);
                    exception.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean broadcastTable(final Plan plan, final String[] stringArray) {
        File file;
        Aladin.trace(3, "Broadcasting table " + plan.getLabel() + " to " + (stringArray == null ? "everyone" : stringArray.length + " applications"));
        if (this.widget != null) {
            this.widget.animateWidgetSend();
        }
        if ((file = this.a.createTempFile("samp" + SAMPUtil.sanitizeFilename(plan.getLabel()), ".xml")) == null) {
            this.trace("Couldn't create temporary file, can't broadcast table !");
            return false;
        }
        new Thread("AladinSampSendTable"){

            @Override
            public void run() {
                if (((SAMPManager)SAMPManager.this).a.save == null) {
                    ((SAMPManager)SAMPManager.this).a.save = new Save(SAMPManager.this.a);
                }
                ((SAMPManager)SAMPManager.this).a.save.saveCatVOTable(file, plan, false);
                URL uRL = SAMPUtil.getURLForFile(file);
                String string = uRL.toString();
                String string2 = plan.getPlasticID();
                if (string2 == null) {
                    string2 = string;
                    plan.addPlasticID(string2);
                }
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put(SAMPManager.KEY_MTYPE, SAMPManager.MSG_LOAD_VOT_FROM_URL);
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                hashtable2.put("url", string);
                hashtable2.put("table-id", string2);
                SAMPManager.this.trace("id initial : " + string2);
                String string3 = SAMPManager.this.createLabel(plan);
                hashtable2.put("name", string3);
                hashtable.put(SAMPManager.KEY_PARAMS, hashtable2);
                SAMPManager.this.trace("Broadcast table with URL: " + string);
                ArrayList arrayList = null;
                if (stringArray != null) {
                    arrayList = new ArrayList();
                    for (int i = 0; i < stringArray.length; ++i) {
                        Object v = SAMPManager.this.appNamesToURI.get(stringArray[i]);
                        if (v != null) {
                            arrayList.add(v);
                            SAMPManager.this.trace("Adding " + v + " to list of recipients");
                            continue;
                        }
                        SAMPManager.this.trace("Couldn't find ID of application " + stringArray[i]);
                    }
                }
                SAMPManager.this.sendNotification(hashtable, stringArray == null ? null : arrayList.toArray(new String[arrayList.size()]));
                SAMPManager.this.a.log("SAMP", "broadcast table");
            }
        }.start();
        return true;
    }

    @Override
    public boolean broadcastImage(final Plan plan, final String[] stringArray) {
        File file;
        Aladin.trace(3, "Broadcasting image " + plan.getLabel() + " to " + (stringArray == null ? "everyone" : stringArray.length + " applications"));
        if (plan == null || !(plan instanceof PlanImage)) {
            return false;
        }
        if (this.widget != null) {
            this.widget.animateWidgetSend();
        }
        if ((file = this.a.createTempFile("samp" + SAMPUtil.sanitizeFilename(plan.getLabel()), ".fits")) == null) {
            this.trace("Couldn't create temporary file, can't broadcast image !");
            return false;
        }
        new Thread("AladinSAMPSendImage"){

            @Override
            public void run() {
                if (((SAMPManager)SAMPManager.this).a.save == null) {
                    ((SAMPManager)SAMPManager.this).a.save = new Save(SAMPManager.this.a);
                }
                ((SAMPManager)SAMPManager.this).a.save.saveImageFITS(file, (PlanImage)plan);
                URL uRL = SAMPUtil.getURLForFile(file);
                String string = uRL.toString();
                String string2 = plan.getPlasticID();
                if (string2 == null) {
                    string2 = string;
                    plan.addPlasticID(string2);
                }
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put(SAMPManager.KEY_MTYPE, SAMPManager.MSG_LOAD_FITS_IMAGE);
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                hashtable2.put("url", string);
                hashtable2.put("image-id", string2);
                String string3 = SAMPManager.this.createLabel(plan);
                hashtable2.put("name", string3);
                hashtable.put(SAMPManager.KEY_PARAMS, hashtable2);
                ArrayList arrayList = null;
                if (stringArray != null) {
                    arrayList = new ArrayList();
                    for (int i = 0; i < stringArray.length; ++i) {
                        Object v = SAMPManager.this.appNamesToURI.get(stringArray[i]);
                        if (v != null) {
                            arrayList.add(v);
                            SAMPManager.this.trace("Adding " + v + " to list of recipients");
                            continue;
                        }
                        SAMPManager.this.trace("Couldn't find ID of application " + stringArray[i]);
                    }
                }
                SAMPManager.this.sendNotification(hashtable, stringArray == null ? null : arrayList.toArray(new String[arrayList.size()]));
                SAMPManager.this.a.log("SAMP", "broadcast image");
            }
        }.start();
        return true;
    }

    private boolean loadVOResources(Object[] objectArray, String string) {
        if (this.resourceChooser == null) {
            this.resourceChooser = new ResourceChooser();
        }
        if (objectArray[0] == null) {
            this.trace("loadVOResources : first parameter is null, can't do anything !");
            return false;
        }
        if (!(objectArray[0] instanceof List)) {
            this.trace("loadVOResources : first parameter is not of type List, can't do anything !");
        }
        String[] stringArray = ((List)objectArray[0]).toArray(new String[((List)objectArray[0]).size()]);
        this.resourceChooser.updateFrame(stringArray, string);
        return true;
    }

    @Override
    public void sendSelectObjectsMsg() {
        if (!this.a.plasticPrefs.getBooleanValue("PlasticSelect")) {
            return;
        }
        if (!this.isRegistered()) {
            return;
        }
        new Thread("AladinSampSendSelect"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Plan plan;
                Source[] sourceArray;
                block12: {
                    sourceArray = ((SAMPManager)SAMPManager.this).a.view.getSelectedSources();
                    if (sourceArray == null) {
                        return;
                    }
                    ArrayList arrayList = SAMPManager.this.getAppsSupporting(SAMPManager.MSG_SELECT_OBJECTS);
                    if (arrayList == null || arrayList.size() == 0) {
                        SAMPManager.this.trace("None of the connected applications supports the 'select objects' message");
                        return;
                    }
                    SAMPManager.this.trace("Sending message table.select.rowList");
                    if (Aladin.levelTrace >= 3) {
                        for (int i = 0; i < sourceArray.length && i < 3; ++i) {
                            Aladin.trace(3, "select object : " + sourceArray[i]);
                        }
                    }
                    if ((plan = SAMPManager.this.findPlaneForSources(sourceArray)) == null) {
                        if (sourceArray.length == 0 && SAMPManager.this.lastPlaneWithSelectedSrc != null) {
                            SAMPManager.this.trace("0 object selected, will send a 'deselection' message");
                            plan = SAMPManager.this.lastPlaneWithSelectedSrc;
                            SAMPManager.this.lastPlaneWithSelectedSrc = null;
                            break block12;
                        } else {
                            SAMPManager.this.lastPlaneWithSelectedSrc = plan;
                            return;
                        }
                    }
                    SAMPManager.this.lastPlaneWithSelectedSrc = plan;
                }
                if (plan.getPlasticID() == null) {
                    return;
                }
                Vector vector = SAMPManager.this.getSequenceNumber(plan, sourceArray);
                String[] stringArray = new String[vector.size()];
                Enumeration enumeration = vector.elements();
                int n = 0;
                while (true) {
                    Integer n2;
                    if (!enumeration.hasMoreElements()) {
                        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                        hashtable.put(SAMPManager.KEY_MTYPE, SAMPManager.MSG_SELECT_OBJECTS);
                        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                        hashtable.put(SAMPManager.KEY_PARAMS, hashtable2);
                        hashtable2.put("table-id", plan.getPlasticID());
                        SAMPManager.this.trace("envoi id : " + plan.getPlasticID());
                        hashtable2.put("row-list", stringArray);
                        SAMPManager.this.sendNotification(hashtable, null);
                        return;
                    }
                    try {
                        n2 = (Integer)enumeration.nextElement();
                    }
                    catch (ClassCastException classCastException) {
                        ((SAMPManager)SAMPManager.this).a.command.println("Encountered bad format for SAMP int");
                        classCastException.printStackTrace();
                        continue;
                    }
                    stringArray[n] = n2.toString();
                    ++n;
                }
            }
        }.start();
    }

    private Plan findPlaneForSources(Source[] sourceArray) {
        return sourceArray == null || sourceArray.length == 0 ? null : sourceArray[0].plan;
    }

    private Plan findPlaneByPlasticID(String string) {
        Plan plan = null;
        Plan[] planArray = this.a.calque.plan;
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i] == null || !planArray[i].isSimpleCatalog() || !planArray[i].hasPlasticID(string)) continue;
            plan = planArray[i];
        }
        return plan;
    }

    private Vector getSequenceNumber(Plan plan, Source[] sourceArray) {
        Vector<Integer> vector = new Vector<Integer>();
        Iterator<Obj> iterator = plan.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            for (int i = 0; i < sourceArray.length; ++i) {
                Source source;
                if (obj == null || !(source = (Source)obj).equals(sourceArray[i])) continue;
                vector.addElement(new Integer(n));
                break;
            }
            ++n;
        }
        return vector;
    }

    @Override
    public boolean internalHubRunning() {
        return this.internalHub != null;
    }

    @Override
    public void updateState() {
        new Thread("AladinSAMPUpdate"){

            @Override
            public void run() {
                block9: {
                    try {
                        if (SAMPManager.this.isRegistered()) {
                            if (SAMPManager.this.getAppsConnected().length > 0) {
                                SAMPManager.this.curState = 3;
                            } else {
                                SAMPManager.this.curState = 2;
                            }
                        } else if (SAMPManager.getLockFile().exists()) {
                            SAMPManager.this.curState = 1;
                        } else {
                            SAMPManager.this.curState = 0;
                        }
                    }
                    catch (Exception exception) {
                        if (Aladin.levelTrace < 3) break block9;
                        exception.printStackTrace();
                    }
                }
                if (SAMPManager.this.widget != null) {
                    SAMPManager.this.widget.updateStatus(SAMPManager.this.curState);
                }
            }
        }.start();
    }

    protected String[] getAppsConnected() {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        try {
            objectArray = new Vector();
            objectArray.add(this.myPrivateKey);
            Iterator iterator = ((Vector)this.hubClient.execute(HUB_MSG_GET_REGISTERED_CLIENTS, (Vector)objectArray)).iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                if (string.equals(this.selfId.toString()) || string.equals(this.hubId)) continue;
                vector.addElement(string);
            }
        }
        catch (Exception exception) {
            return new String[0];
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        return objectArray;
    }

    @Override
    public void sendHighlightObjectsMsg(Source source) {
        if (!this.a.plasticPrefs.getBooleanValue("PlasticHighlight")) {
            return;
        }
        if (source == null) {
            return;
        }
        if (!this.isRegistered()) {
            return;
        }
        Source[] sourceArray = new Source[]{source};
        Plan plan = this.findPlaneForSources(sourceArray);
        if (plan == null) {
            this.trace("Could not find plane, can't send SAMP message");
            return;
        }
        Vector vector = this.getSequenceNumber(plan, sourceArray);
        if (vector.size() == 0) {
            this.trace("Could not find sequence number for source " + source);
            return;
        }
        Integer n = (Integer)vector.elementAt(0);
        if (this.oidx != null && this.oid != null && this.oid.equals(plan.getPlasticID()) && this.oidx.equals(n)) {
            return;
        }
        this.oidx = n;
        this.oid = plan.getPlasticID();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put(KEY_MTYPE, MSG_HIGHLIGHT_OBJECT);
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        hashtable2.put("table-id", plan.getPlasticID());
        hashtable2.put("row", n.toString());
        hashtable.put(KEY_PARAMS, hashtable2);
        this.sendNotification(hashtable, null);
    }

    @Override
    public boolean ping() {
        if (this.hubClient == null) {
            return false;
        }
        try {
            this.hubClient.execute(HUB_MSG_PING, new Vector());
        }
        catch (Exception exception) {
            this.unregister(true);
            this.isRegistered = false;
            this.updateState();
            return false;
        }
        if (this.updateAppsListNeeded) {
            this.getAppsSupporting(MSG_PING);
            this.updateAppsListNeeded = false;
        }
        return true;
    }

    private void replyToMessage(String string, String string2, Map map, String string3) {
        Cloneable cloneable;
        if (string == null) {
            this.trace("Can not reply to message because message-id has not been set in initial message !");
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put(MSG_REPLY_SAMP_STATUS, string2);
        hashtable.put(MSG_REPLY_SAMP_RESULT, map == null ? new Hashtable() : map);
        if (string3 != null) {
            cloneable = new Hashtable();
            cloneable.put("samp.errortxt", string3);
            hashtable.put("samp.error", cloneable);
        }
        cloneable = new Vector();
        ((Vector)cloneable).add(this.myPrivateKey);
        ((Vector)cloneable).add(string);
        ((Vector)cloneable).add(hashtable);
        new Thread((Vector)cloneable){
            final /* synthetic */ Vector val$params;
            {
                this.val$params = vector;
            }

            @Override
            public void run() {
                try {
                    SAMPManager.this.hubClient.execute(SAMPManager.HUB_MSG_REPLY, this.val$params);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.start();
    }

    @Override
    public void setPlasticWidget(PlasticWidget plasticWidget) {
        this.widget = plasticWidget;
    }

    @Override
    public PlasticWidget getPlasticWidget() {
        return this.widget;
    }

    @Override
    public void trace(String string) {
        if (!this.sampTrace) {
            return;
        }
        System.out.println("** SAMP : " + string);
    }

    @Override
    public boolean getPlasticTrace() {
        return this.sampTrace;
    }

    @Override
    public void setPlasticTrace(boolean bl) {
        this.sampTrace = bl;
        if (this.sampTrace) {
            Logger.getLogger("org.astrogrid.samp").setLevel(Level.ALL);
        } else {
            Logger.getLogger("org.astrogrid.samp").setLevel(Level.OFF);
        }
    }

    @Override
    public void planeLoaded(PlaneLoadEvent planeLoadEvent) {
        String string = this.planesToMsgIds.get(planeLoadEvent.plane);
        if (string == null) {
            System.err.println("Ohoh, something weird happened : could not find msgId for plane " + planeLoadEvent.plane.getLabel());
            return;
        }
        this.trace("Received PlaneLoadEvent from plane " + planeLoadEvent.plane.getLabel());
        if (planeLoadEvent.status == PlaneLoadEvent.SUCCESS) {
            this.replyToMessage(string, MSG_REPLY_SAMP_STATUSOK, null, null);
        } else {
            this.replyToMessage(string, "samp.error", null, planeLoadEvent.errorMsg);
        }
        planeLoadEvent.plane.removeListener(this);
        this.planesToMsgIds.remove(planeLoadEvent.plane);
    }

    static {
        startPort = 42195;
        VOID = "";
        TRUE = Boolean.TRUE;
        FALSE = Boolean.FALSE;
    }

    class ResourceChooser
    extends JFrame
    implements ActionListener {
        JList list;
        DefaultListModel model;
        private boolean firstShow;
        String[] uris;
        VOResource[] resources;

        ResourceChooser() {
            super("Choose resources to keep");
            this.firstShow = true;
            Util.setCloseShortcut(this, false);
            this.getContentPane().setLayout(new BorderLayout());
        }

        void updateFrame(final String[] stringArray, String string) {
            this.uris = stringArray;
            this.getContentPane().removeAll();
            ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel("<html><b>" + SAMPManager.this.getNameForApp(string) + "</b> has sent some registry resources.<br>Select resources you want to keep:<br></html>");
            jPanel.add(jLabel);
            this.getContentPane().add((Component)jPanel, "North");
            JPanel jPanel2 = new JPanel();
            DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
            this.list = new JList();
            this.list.setSelectionModel(defaultListSelectionModel);
            JScrollPane jScrollPane = new JScrollPane(this.list);
            this.model = new DefaultListModel();
            for (int i = 0; i < stringArray.length; ++i) {
                this.model.addElement(stringArray[i]);
            }
            this.list.setModel(this.model);
            jPanel2.add(jScrollPane);
            this.list.setPreferredSize(new Dimension(550, 200));
            jScrollPane.setPreferredSize(new Dimension(550, 200));
            this.getContentPane().add((Component)jPanel2, "Center");
            JPanel jPanel3 = new JPanel(new FlowLayout());
            JButton jButton = new JButton("OK");
            jButton.addActionListener(this);
            jButton.setFont(Aladin.BOLD);
            jPanel3.add(jButton);
            JButton jButton2 = new JButton("Close");
            jButton2.addActionListener(this);
            jPanel3.add(jButton2);
            this.getContentPane().add((Component)jPanel3, "South");
            this.pack();
            if (this.firstShow) {
                this.firstShow = false;
                this.setSize(new Dimension(600, 300));
                this.setLocation(200, 200);
            }
            this.setVisible(true);
            this.toFront();
            new Thread("SAMPManager:resolveIVORN"){

                @Override
                public void run() {
                    ResourceChooser.this.resolveIVORN(stringArray);
                }
            }.start();
        }

        private void resolveIVORN(String[] stringArray) {
            this.list.getSelectionModel().clearSelection();
            this.resources = new VOResource[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                VOResource vOResource;
                this.resources[i] = vOResource = FrameServer.getIvorn(stringArray[i]);
                if (vOResource == null) continue;
                this.model.setElementAt(stringArray[i] + " - " + (vOResource == null ? "" : vOResource.desc), i);
                if (vOResource == null || vOResource.type == null || !vOResource.type.equals("siap") && !vOResource.type.equals("ssap") && !vOResource.type.equals("cs")) continue;
                this.list.getSelectionModel().addSelectionInterval(i, i);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

