/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.Legende;
import cds.aladin.MyInputStream;
import cds.aladin.Pcat;
import cds.aladin.PlanCatalog;
import cds.aladin.Repere;
import cds.aladin.Source;
import cds.aladin.ZoomView;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;

class SED
extends JPanel {
    private static final String SEDGLUTAG = "VizieR.sed";
    static final int margeHaut = 20;
    static final int margeBas = 30;
    static final int margeDroite = 30;
    static final int margeGauche = 10;
    static final char MU = '\u03bc';
    static final char NU = '\u03bd';
    static final char TILDE = '\u223c';
    private static final double EPSILON = 0.1;
    private static final double WAVEMIN = 0.2;
    private static final double WAVEMAX = 30.0;
    private static final double FREQMIN = 10000.0;
    private static final double FREQMAX = 1000000.0;
    private static final double WAVEOPTMIN = 0.3;
    private static final double WAVEOPTMAX = 1.0;
    private static final double FREQOPTMIN = SED.wave2Freq(1.0);
    private static final double FREQOPTMAX = SED.wave2Freq(0.3);
    private static final Color LIGHTGRAY = new Color(125, 125, 125);
    private Aladin aladin;
    private PlanCatalog plan;
    private String source;
    private double radius;
    private Repere simRep;
    private String url;
    private float transparency;
    private double absMin;
    private double absMax;
    private double fluxMin;
    private double fluxMax;
    private double coefX;
    private double coefY;
    private boolean readyToDraw;
    private boolean planeAlreadyCreated;
    private boolean flagWavelength;
    private int xOptMin;
    private int xOptMax;
    private ArrayList<SEDItem> sedList;
    private Rectangle rCroix;
    private Rectangle rWave;
    private Rectangle rHelp;
    private Rectangle rMore;
    private double currentAbs = Double.NaN;
    private double currentFlux = Double.NaN;
    private int currentX;
    private int currentY;
    private SEDItem siIn;
    static boolean first = true;
    private static final Color COLOROPT = new Color(234, 234, 255);
    private static final String[] UNITFREQ = new String[]{"Hz", "kHz", "MHz", "GHz", "THz", "PHz", "EHz"};
    private static final String[] UNITWAVE = new String[]{"nm", "\u03bcm", "mm", "m", "km", "Mm", "Gm"};
    private static final String[] UNITJY = new String[]{"\u03bcJy", "mJy", "Jy", "kJy", "MJy", "GJy", "TJy", "PJy"};

    public SED(Aladin aladin) {
        this.aladin = aladin;
        this.transparency = 0.5f;
        this.flagWavelength = aladin.configuration.getSEDWave();
        this.radius = 5.0;
    }

    protected void setRepere(Repere repere) {
        this.simRep = repere;
    }

    protected void setSource(String string) {
        if (string == null && first) {
            System.out.println("SED.setSource(" + string + ")");
            first = false;
            try {
                throw new Exception("ICI");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.source = string;
    }

    protected void setRadius(double d) {
        this.radius = d;
    }

    public int getCount() {
        if (this.sedList == null) {
            return -1;
        }
        return this.sedList.size();
    }

    public void clear() {
        this.readyToDraw = false;
        this.planeAlreadyCreated = false;
        this.xOptMin = 0;
        this.xOptMax = 0;
        this.fluxMax = 0.0;
        this.fluxMin = 0.0;
        this.absMax = 0.0;
        this.absMin = 0.0;
        if (this.sedList != null) {
            this.sedList.clear();
        }
    }

    protected void addFromIterator(Iterator<Source> iterator) {
        block3: {
            this.planeAlreadyCreated = true;
            this.readyToDraw = false;
            try {
                if (this.plan == null) {
                    this.plan = new PlanCatalog(this.aladin);
                }
                this.createSEDlist(iterator);
                this.setPosition();
                this.aladin.calque.zoom.zoomView.flagSED = true;
                this.aladin.calque.repaintAll();
            }
            catch (Exception exception) {
                this.aladin.view.zoomview.setSED((String)null);
                this.aladin.command.printConsole("!!! VizieR photometry parsing error => " + exception.getMessage());
                if (Aladin.levelTrace < 3) break block3;
                exception.printStackTrace();
            }
        }
    }

    protected void setHighLight(Source source) {
        for (SEDItem sEDItem : this.sedList) {
            sEDItem.highLight = sEDItem.o == source;
        }
    }

    protected void loadFromSource(String string) {
        block2: {
            this.clear();
            this.source = string;
            try {
                Aladin.trace(2, "VizieR photometry loading around source \"" + string + "\"...");
                this.url = "" + this.aladin.glu.getURL(SEDGLUTAG, Glu.quote(string) + " " + this.radius);
                Aladin.trace(2, "Phot. loading: " + this.url);
                this.loadASync(Util.openAnyStream(this.url));
            }
            catch (Exception exception) {
                this.aladin.view.zoomview.setSED((String)null);
                this.aladin.command.printConsole("!!! VizieR photometry builder error [" + string + "] => " + exception.getMessage());
                if (Aladin.levelTrace < 3) break block2;
                exception.printStackTrace();
            }
        }
    }

    private void createStackPlane() {
        if (this.planeAlreadyCreated) {
            return;
        }
        this.planeAlreadyCreated = true;
        this.plan.label = "PHOT " + this.source;
        this.plan.objet = this.source;
        try {
            this.plan.u = new URL(this.url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.aladin.calque.newPlan(this.plan);
        this.plan.planReady(true);
        this.aladin.calque.selectPlan(this.plan);
    }

    private void loadASync(MyInputStream myInputStream) {
        this.readyToDraw = false;
        this.planeAlreadyCreated = false;
        final MyInputStream myInputStream2 = myInputStream;
        this.plan = new PlanCatalog(this.aladin);
        this.plan.pcat = new Pcat(this.plan, Color.black, this.aladin.calque, this.aladin.status, this.aladin);
        new Thread(){

            @Override
            public void run() {
                try {
                    ((SED)SED.this).plan.pcat.tableParsing(myInputStream2, "TABLE");
                    SED.this.clear();
                    SED.this.parseAndDraw();
                }
                catch (Exception exception) {
                    ((SED)SED.this).aladin.view.zoomview.setSED((String)null);
                    ((SED)SED.this).aladin.command.printConsole("!!! VizieR photometry parsing error => " + exception.getMessage());
                    SED.this.aladin;
                    if (Aladin.levelTrace >= 3) {
                        exception.printStackTrace();
                    }
                }
                finally {
                    if (myInputStream2 != null) {
                        try {
                            myInputStream2.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }.start();
    }

    private void parseAndDraw() throws Exception {
        this.createSEDlist(this.plan.iterator());
        this.setPosition();
        this.aladin.calque.zoom.zoomView.flagSED = true;
        this.aladin.calque.repaintAll();
    }

    protected double getFreq(Source source) {
        return this.getSEDValue(source, 1);
    }

    protected double getFlux(Source source) {
        return this.getSEDValue(source, 2);
    }

    protected double getFluxErr(Source source) {
        double d = this.getSEDValue(source, 3);
        if (Double.isNaN(d)) {
            return 0.0;
        }
        return d;
    }

    private double getSEDValue(Source source, int n) {
        Legende legende = source.leg;
        for (int i = 0; i < legende.field.length; ++i) {
            if (legende.field[i].sed != n) continue;
            String string = source.getValue(i);
            try {
                return Double.parseDouble(string.trim());
            }
            catch (Exception exception) {
                return Double.NaN;
            }
        }
        return Double.NaN;
    }

    protected String getSEDId(Source source) {
        Legende legende = source.leg;
        String string = null;
        for (int i = 0; i < legende.field.length; ++i) {
            if (legende.field[i].sed != 4) continue;
            string = source.getValue(i);
        }
        return string;
    }

    private void createSEDlist(Iterator<?> iterator) {
        if (this.sedList == null) {
            this.sedList = new ArrayList();
        }
        while (iterator.hasNext()) {
            Source source = (Source)iterator.next();
            double d = this.getFreq(source);
            double d2 = this.getFlux(source);
            if (Double.isNaN(d) || Double.isNaN(d2) || d <= 0.0 || d2 <= 0.0) continue;
            double d3 = this.getFluxErr(source);
            String string = this.getSEDId(source);
            source.setSelect(true);
            SEDItem sEDItem = new SEDItem(source, d, d2, d3, string);
            this.sedList.add(sEDItem);
        }
    }

    protected boolean getSEDWave() {
        return this.flagWavelength;
    }

    private void setPosition() {
        this.fluxMin = Double.MAX_VALUE;
        this.absMin = Double.MAX_VALUE;
        this.fluxMax = Double.MIN_VALUE;
        this.absMax = Double.MIN_VALUE;
        for (SEDItem sEDItem : this.sedList) {
            if (this.absMin > sEDItem.freq) {
                this.absMin = sEDItem.freq;
            }
            if (sEDItem.flux - sEDItem.fluxErr > 0.0) {
                if (this.fluxMin > sEDItem.flux - sEDItem.fluxErr) {
                    this.fluxMin = sEDItem.flux - sEDItem.fluxErr;
                }
            } else if (this.fluxMin > 0.1) {
                this.fluxMin = 0.1;
            }
            if (this.absMax < sEDItem.freq) {
                this.absMax = sEDItem.freq;
            }
            if (!(this.fluxMax < sEDItem.flux + sEDItem.fluxErr)) continue;
            this.fluxMax = sEDItem.flux + sEDItem.fluxErr;
        }
        if (this.flagWavelength) {
            double d = SED.freq2Wave(this.absMin);
            this.absMin = SED.freq2Wave(this.absMax);
            this.absMax = d;
            if (this.absMin > 0.2) {
                this.absMin = 0.2;
            }
            if (this.absMax < 30.0) {
                this.absMax = 30.0;
            }
        } else {
            if (this.absMin > 10000.0) {
                this.absMin = 10000.0;
            }
            if (this.absMax < 1000000.0) {
                this.absMax = 1000000.0;
            }
        }
        Dimension dimension = this.getDimension();
        dimension.width -= 40;
        dimension.height -= 50;
        double d = SED.LOG(this.absMax) - SED.LOG(this.absMin);
        double d2 = SED.LOG(this.fluxMax) - SED.LOG(this.fluxMin);
        this.coefX = (double)dimension.width / d;
        this.coefY = (double)dimension.height / d2;
        for (SEDItem sEDItem : this.sedList) {
            double d3 = this.flagWavelength ? SED.freq2Wave(sEDItem.freq) : sEDItem.freq;
            double d4 = (SED.LOG(d3) - SED.LOG(this.absMin)) * this.coefX;
            double d5 = (SED.LOG(sEDItem.flux) - SED.LOG(this.fluxMin)) * this.coefY;
            sEDItem.setBox((int)d4, (int)((double)dimension.height - d5));
            if (sEDItem.fluxErr == 0.0) continue;
            double d6 = 0.0;
            if (sEDItem.flux - sEDItem.fluxErr > 0.0) {
                d6 = (SED.LOG(sEDItem.flux - sEDItem.fluxErr) - SED.LOG(this.fluxMin)) * this.coefY;
            }
            double d7 = (SED.LOG(sEDItem.flux + sEDItem.fluxErr) - SED.LOG(this.fluxMin)) * this.coefY;
            sEDItem.setBoxErr((int)((double)dimension.height - d7), (int)((double)dimension.height - d6));
        }
        if (this.flagWavelength) {
            this.xOptMin = (int)((SED.LOG(SED.freq2Wave(FREQOPTMAX)) - SED.LOG(this.absMin)) * this.coefX);
            this.xOptMax = (int)((SED.LOG(SED.freq2Wave(FREQOPTMIN)) - SED.LOG(this.absMin)) * this.coefX);
        } else {
            this.xOptMin = (int)((SED.LOG(FREQOPTMIN) - SED.LOG(this.absMin)) * this.coefX);
            this.xOptMax = (int)((SED.LOG(FREQOPTMAX) - SED.LOG(this.absMin)) * this.coefX);
        }
        this.readyToDraw = true;
    }

    private double getCurrentAbs(double d) {
        if (!this.readyToDraw) {
            return Double.NaN;
        }
        return SED.POW(d / this.coefX + SED.LOG(this.absMin));
    }

    double getCurrentFlux(double d) {
        if (!this.readyToDraw) {
            return Double.NaN;
        }
        return SED.POW(d / this.coefY + SED.LOG(this.fluxMin));
    }

    public Dimension getDimension() {
        return new Dimension(ZoomView.SIZE, ZoomView.SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(Graphics graphics) {
        String string;
        Dimension dimension = this.getDimension();
        int n = 20;
        int n2 = dimension.height - 30;
        int n3 = 10;
        int n4 = dimension.width - 30;
        graphics.setColor(Color.white);
        graphics.clearRect(0, 0, dimension.width, dimension.height);
        if (this.xOptMin != this.xOptMax) {
            graphics.setColor(COLOROPT);
            graphics.fillRect(n3 + Math.min(this.xOptMin, this.xOptMax), n, Math.abs(this.xOptMax - this.xOptMin + 1), n2 - n);
        }
        int n5 = 3;
        graphics.setColor(Color.gray);
        graphics.drawLine(n3, n, n3, n2);
        graphics.drawLine(n3, n, n3 - n5, n + n5);
        graphics.drawLine(n3, n, n3 + n5, n + n5);
        graphics.drawLine(n3, n2, n4, n2);
        graphics.drawLine(n4, n2, n4 - n5, n2 - n5);
        graphics.drawLine(n4, n2, n4 - n5, n2 + n5);
        graphics.setColor(Color.black);
        graphics.setFont(Aladin.SSPLAIN);
        graphics.drawString("log f(\u03bd)", n3 - 2, n - 4);
        graphics.drawString(this.fluxMax == 0.0 ? "" : SED.getUnitJy(this.fluxMax), n3 + 4, n + 6);
        graphics.drawString("log " + (this.flagWavelength ? (char)'\u03bc' : '\u03bd'), n4 + 2, n2);
        graphics.setColor(LIGHTGRAY);
        if (!Double.isNaN(this.currentAbs)) {
            graphics.drawLine(this.currentX, n2, this.currentX, n2 - 5);
            graphics.setFont(Aladin.SSPLAIN);
            graphics.drawString(Util.myRound(SED.LOG(this.currentAbs) + "", 1), this.currentX, n2 - 8);
            if (this.siIn == null) {
                graphics.setFont(Aladin.BOLD);
                string = !this.flagWavelength ? SED.getUnitFreq(this.currentAbs) : SED.getUnitWave(this.currentAbs);
                graphics.drawString(string, 5, dimension.height - 3);
            }
        }
        if (!Double.isNaN(this.currentFlux)) {
            graphics.drawLine(n3, this.currentY, n3 + 5, this.currentY);
            graphics.setFont(Aladin.SSPLAIN);
            graphics.drawString(Util.myRound(SED.LOG(this.currentFlux) + "", 1), n3 + 10, this.currentY);
            if (this.siIn == null) {
                graphics.setFont(Aladin.BOLD);
                string = SED.getUnitJy(this.currentFlux);
                graphics.drawString(string, dimension.width - 5 - graphics.getFontMetrics().stringWidth(string), dimension.height - 3);
            }
        }
        this.drawCroix(graphics);
        this.drawWave(graphics);
        this.drawMore(graphics);
        this.drawHelp(graphics);
        SEDItem sEDItem = null;
        if (this.sedList == null || !this.readyToDraw) {
            graphics.setFont(Aladin.ITALIC);
            string = Aladin.chaine.getString("SEDLOADING");
            int n6 = (n + n2) / 2 - 20;
            graphics.drawString(string, dimension.width / 2 - graphics.getFontMetrics().stringWidth(string) / 2, n6 += 18);
            string = Coord.getUnit(this.radius / 3600.0) + " around";
            graphics.drawString(string, dimension.width / 2 - graphics.getFontMetrics().stringWidth(string) / 2, n6 += 18);
            string = this.source;
            graphics.drawString(string, dimension.width / 2 - graphics.getFontMetrics().stringWidth(string) / 2, n6 += 18);
            if (this.sedList == null || !this.readyToDraw) {
                return;
            }
        } else {
            graphics.setFont(Aladin.SPLAIN);
            Composite composite = ((Graphics2D)graphics).getComposite();
            try {
                ((Graphics2D)graphics).setComposite(Util.getImageComposite(this.transparency));
                for (SEDItem sEDItem2 : this.sedList) {
                    if (sEDItem2.highLight) {
                        sEDItem = sEDItem2;
                    }
                    sEDItem2.draw(graphics);
                }
            }
            finally {
                ((Graphics2D)graphics).setComposite(composite);
            }
            if (sEDItem != null) {
                sEDItem.draw(graphics);
            }
        }
        if (sEDItem == null) {
            graphics.setColor(Color.black);
            graphics.setFont(Aladin.SPLAIN);
            string = this.flagWavelength ? SED.getUnitWave(this.absMin) : SED.getUnitFreq(this.absMin);
            graphics.drawString(string, n3, n2 + 10);
            string = this.flagWavelength ? SED.getUnitWave(this.absMax) : SED.getUnitFreq(this.absMax);
            graphics.drawString(string, 20 + n4 - graphics.getFontMetrics().stringWidth(string), n2 + 10);
        }
        if (this.source != null) {
            graphics.setColor(Aladin.GREEN);
            graphics.setFont(Aladin.BOLD);
            String string2 = "VizieR Phot. at " + Coord.getUnit(this.radius / 3600.0);
            int n7 = graphics.getFontMetrics().stringWidth(string2);
            int n8 = dimension.width / 2 - n7 / 2;
            if (n8 < 50) {
                n8 = 50;
            }
            graphics.drawString(string2, n8, n - 4);
            if (Double.isNaN(this.currentFlux) && Double.isNaN(this.currentAbs) && sEDItem == null) {
                string2 = this.source;
                n7 = graphics.getFontMetrics().stringWidth(string2);
                n8 = dimension.width / 2 - n7 / 2;
                if (n8 < 50) {
                    n8 = 50;
                }
                graphics.drawString(string2, n8, dimension.height - 7);
            }
        }
    }

    static double freq2Wave(double d) {
        return 299800.0 / d;
    }

    static double wave2Freq(double d) {
        return 299800.0 / d;
    }

    private void drawCroix(Graphics graphics) {
        int n = 5;
        int n2 = this.getDimension().width;
        graphics.setColor(Aladin.BKGD);
        this.rCroix = new Rectangle(n2 - n - 4, 1, n + 4, n + 4);
        graphics.fillRect(this.rCroix.x, this.rCroix.y, this.rCroix.width, this.rCroix.height);
        graphics.setColor(Color.red);
        graphics.drawLine(n2 - n - 3, 2, n2 - 3, n + 2);
        graphics.drawLine(n2 - n - 3, 3, n2 - 3, n + 3);
        graphics.drawLine(n2 - n - 3, n + 2, n2 - 3, 2);
        graphics.drawLine(n2 - n - 3, n + 3, n2 - 3, 3);
    }

    private void drawMore(Graphics graphics) {
        int n = 5;
        Dimension dimension = this.getDimension();
        graphics.setColor(Aladin.BKGD);
        this.rMore = new Rectangle(dimension.width - n - 4, 16 + 3 * n, n + 4, n + 4);
        graphics.fillRect(this.rMore.x, this.rMore.y, this.rMore.width, this.rMore.height);
        graphics.setColor(this.flagWavelength ? Color.blue : Color.red);
        graphics.setFont(Aladin.SBOLD);
        graphics.drawString("+", this.rMore.x + 2, this.rMore.y + 8);
    }

    private void drawWave(Graphics graphics) {
        int n = 5;
        Dimension dimension = this.getDimension();
        graphics.setColor(Aladin.BKGD);
        this.rWave = new Rectangle(dimension.width - n - 4, 11 + 2 * n, n + 4, n + 4);
        graphics.fillRect(this.rWave.x, this.rWave.y, this.rWave.width, this.rWave.height);
        graphics.setColor(this.flagWavelength ? Color.blue : Color.red);
        graphics.setFont(Aladin.SBOLD);
        graphics.drawString("\u223c", this.rWave.x + 1, this.rWave.y + 8);
    }

    private void drawHelp(Graphics graphics) {
        int n = 5;
        Dimension dimension = this.getDimension();
        graphics.setColor(Aladin.BKGD);
        this.rHelp = new Rectangle(dimension.width - n - 4, 6 + n, n + 4, n + 4);
        graphics.fillRect(this.rHelp.x, this.rHelp.y, this.rHelp.width, this.rHelp.height);
        graphics.setColor(Color.blue);
        graphics.setFont(Aladin.SBOLD);
        graphics.drawString("?", this.rHelp.x + 2, this.rHelp.y + 8);
    }

    protected void mouseRelease(int n, int n2) {
        if (this.rCroix.contains(n, n2)) {
            this.aladin.view.zoomview.setSED((String)null);
        } else if (this.rMore.contains(n, n2)) {
            this.more();
        } else if (this.rHelp.contains(n, n2)) {
            this.help();
        } else if (this.rWave.contains(n, n2)) {
            this.flagWavelength = !this.flagWavelength;
            this.setPosition();
            this.aladin.view.zoomview.repaint();
        } else if (this.siIn != null) {
            int n3 = 1;
            if (!this.planeAlreadyCreated) {
                this.createStackPlane();
            } else {
                n3 = 2;
            }
            this.aladin.view.showSource(this.siIn.o, false, true);
            this.aladin.mesure.mcanvas.show(this.siIn.o, n3);
            this.aladin.calque.repaintAll();
        }
    }

    private void more() {
        if (this.source == null) {
            System.out.println("SED.more() source=null");
            return;
        }
        System.out.println("SED.more() source=" + this.source);
        this.aladin.glu.showDocument("Widget.VizPhot", Glu.quote(this.source) + " " + this.radius);
    }

    private void help() {
        Aladin.info(Aladin.chaine.getString("SEDHELP"));
    }

    protected void mouseExit() {
        this.currentFlux = Double.NaN;
        this.currentAbs = Double.NaN;
        this.aladin.view.simRep = null;
    }

    protected void mouseEnter() {
        this.aladin.view.simRep = this.simRep;
        if (this.simRep != null) {
            this.aladin.view.repaintAll();
        }
    }

    private void toolTip(String string) {
        String string2 = string == null ? null : Aladin.chaine.getString(string);
        Util.toolTip(this.aladin.view.zoomview, string2);
    }

    protected void mouseMove(int n, int n2) {
        if (this.rCroix.contains(n, n2)) {
            this.toolTip("SEDCLOSE");
            return;
        }
        if (this.rMore.contains(n, n2)) {
            this.toolTip("SEDMORE");
            return;
        }
        if (this.rWave.contains(n, n2)) {
            this.toolTip("SEDFREQWAVE");
            return;
        }
        if (this.rHelp.contains(n, n2)) {
            this.toolTip("SEDHELPTIP");
            return;
        }
        this.toolTip(null);
        this.siIn = null;
        if (this.sedList == null) {
            return;
        }
        for (SEDItem sEDItem : this.sedList) {
            sEDItem.highLight = false;
        }
        for (SEDItem sEDItem : this.sedList) {
            if (!sEDItem.contains(n, n2)) continue;
            sEDItem.highLight = true;
            this.siIn = sEDItem;
            break;
        }
        if (this.siIn != null) {
            this.aladin.view.showSource(this.siIn.o, false, true);
            this.aladin.mesure.mcanvas.show(this.siIn.o, 1);
        }
        Dimension dimension = this.getDimension();
        this.currentAbs = n > 10 && n < dimension.width - 30 ? this.getCurrentAbs(n - 10) : Double.NaN;
        this.currentFlux = n2 > 34 && n2 < dimension.height - 30 - (n > 40 ? 0 : 14) ? this.getCurrentFlux((double)(dimension.height - 50) - (double)(n2 - 20)) : Double.NaN;
        this.currentX = n;
        this.currentY = n2;
    }

    protected boolean mouseWheel(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (n == 0) {
            return false;
        }
        float f = this.transparency + (float)n * 0.1f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        if ((double)f < 0.2) {
            f = 0.2f;
        }
        if (f == this.transparency) {
            return false;
        }
        this.transparency = f;
        return true;
    }

    public static double LOG(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    public static double POW(double d) {
        return Math.exp(d * Math.log(10.0));
    }

    public static final String getUnitFreq(double d) {
        return SED.getUnit(d * 1.0E9, UNITFREQ);
    }

    public static final String getUnitJy(double d) {
        return SED.getUnit(d * 1000000.0, UNITJY);
    }

    public static final String getUnitWave(double d) {
        return SED.getUnit(d * 1000.0, UNITWAVE);
    }

    private static final String getUnit(double d, String[] stringArray) {
        int n;
        for (n = 0; d >= 1000.0 && n < stringArray.length - 1; ++n, d /= 1000.0) {
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(1);
        return numberFormat.format(d) + stringArray[n];
    }

    private class SEDItem {
        private double freq;
        private double flux;
        private double fluxErr;
        private String sedId;
        private Source o;
        private boolean highLight;
        private Rectangle r;
        private int by;
        private int hy;
        static final int W = 6;

        private SEDItem(Source source, double d, double d2, double d3, String string) {
            this.o = source;
            this.freq = d;
            this.flux = d2;
            this.fluxErr = d3;
            this.sedId = string;
            this.hy = 0;
            this.by = 0;
        }

        private void setBox(int n, int n2) {
            this.r = new Rectangle(10 + n - 3, 20 + n2 - 3, 6, 6);
        }

        private void setBoxErr(int n, int n2) {
            this.by = 20 + n;
            this.hy = 20 + n2;
        }

        private boolean contains(int n, int n2) {
            return this.r.contains(n, n2);
        }

        private void draw(Graphics graphics) {
            graphics.setColor(this.o.getColor());
            Util.fillCircle5(graphics, this.r.x + 3, this.r.y + 3);
            if (Math.abs(this.by - this.hy) > 5) {
                graphics.drawLine(this.r.x + 3, this.by, this.r.x + 3, this.hy);
                graphics.drawLine(this.r.x + 1, this.by, this.r.x + 6 - 1, this.by);
                graphics.drawLine(this.r.x + 1, this.hy, this.r.x + 6 - 1, this.hy);
            }
            if (this.highLight) {
                graphics.setColor(Aladin.GREEN);
                graphics.drawRect(this.r.x, this.r.y, this.r.width, this.r.height);
                graphics.setFont(Aladin.BOLD);
                Dimension dimension = SED.this.getDimension();
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = fontMetrics.getHeight();
                graphics.drawString(this.sedId, dimension.width / 2 - fontMetrics.stringWidth(this.sedId) / 2, dimension.height - n - 2);
                String string = !SED.this.flagWavelength ? SED.getUnitFreq(this.freq) : SED.getUnitWave(SED.freq2Wave(this.freq));
                graphics.drawString(string, 5, SED.this.getDimension().height - 3);
                string = SED.getUnitJy(this.flux);
                graphics.drawString(string, dimension.width - 5 - fontMetrics.stringWidth(string), SED.this.getDimension().height - 3);
            }
        }
    }
}

