/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FootprintBean;
import cds.aladin.FootprintParser;
import cds.aladin.Fov;
import cds.aladin.MetaDataTree;
import cds.aladin.PlanField;
import cds.aladin.ResourceNode;
import cds.aladin.TreeBuilder;
import cds.aladin.TreeView;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotField;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotVOTable;
import cds.savot.model.TDSet;
import cds.savot.model.TRSet;
import cds.savot.model.TableSet;
import cds.savot.pull.SavotPullParser;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SIAPExtBuilder
extends TreeBuilder {
    static final String UT_SIMPLEQUERY = "dal:SimpleQueryResponse";
    static final String UT_DALEXTENSIONS = "dal:QueryResponseExtensions";
    static final String UT_GENFEATURES = "Observation.DataID.Collection";
    static final String UT_GENFEATURES_DEPRECATED = "Observation/DataCollection";
    static final String UT_CHARACTERIZATION = "Observation/ivoa:Characterization";
    static final String UT_DATAACCESS = "Observation.Provenance.DataViewsAndAccess";
    static final String UT_DATAACCESS_DEPRECATED = "Observation/DataViewsAndAccess";
    static final String UT_COMPOSITION = "Observation/Provenance/Processing/Composition";
    static final String UT_RADEC = "ivoa:Characterization[ucd=pos]/Coverage/Location";
    static final String UT_MINRADEC = "ivoa:Characterization[ucd=pos]/Coverage/Bounds/min";
    static final String UT_MAXRADEC = "ivoa:Characterization[ucd=pos]/Coverage/Bounds/max";
    static final String UT_OBS_DATASET_ID = "Observation.DataID.DatasetID";
    static final String UT_OBS_DATASET_ID_DEPRECATED = "Observation/Identifier";
    static final String FOV_POS_ANGLE = "stc:AstroCoordSystem.CoordFrame.Cart2DRefFrame.Transform2.PosAngle";
    private SavotPullParser parser;
    private SavotVOTable votable;
    SavotResource orgSiapRes;
    SavotResource dalExtRes;
    SavotTable genFeatTab;
    SavotTable characTab;
    SavotTable dataAccessTab;
    SavotTable compositionTab;
    private Hashtable namesToNodes;
    private Hashtable altNamesToNodes;
    private int obsRefIndex;
    private int idxRefRelObs;
    private Vector alreadyAdded;
    private Vector otherTabs;
    private boolean isFootprintDoc = false;
    private Vector potentialKeys;
    private Hashtable keyToNodes;
    private String obsRefID;
    private String obsNameID;

    SIAPExtBuilder(Aladin aladin, String string) {
        super(aladin, string);
    }

    protected ResourceNode build(SavotPullParser savotPullParser) throws Exception {
        int n;
        Object object;
        int n2;
        Aladin.trace(3, "Begin parsing of SIAP extensions document");
        this.reset();
        this.parser = savotPullParser;
        if (this.parser == null) {
            throw new Exception("Null parser passed to SIAPExtBuilder class");
        }
        this.votable = this.parser.getVOTable();
        this.preCheck();
        this.searchSortOrder(this.votable);
        if (this.orgSiapRes == null) {
            throw new Exception("Could not find SIAP results section, parsing aborted !");
        }
        ResourceNode resourceNode = new ResourceNode(this.aladin, "root");
        resourceNode.type = 0;
        resourceNode.isSIAPEvol = true;
        SavotField[] savotFieldArray = this.createDescription(this.orgSiapRes.getFieldSet(0));
        Aladin.trace(3, "orgsiapres : " + this.orgSiapRes);
        Aladin.trace(3, "initFields.length : " + savotFieldArray.length);
        String[] stringArray = new String[savotFieldArray.length];
        for (n2 = 0; n2 < savotFieldArray.length; ++n2) {
            stringArray[n2] = savotFieldArray[n2].getId();
            if (!savotFieldArray[n2].getUtype().equals(UT_OBS_DATASET_ID) && !savotFieldArray[n2].getUtype().equals(UT_OBS_DATASET_ID_DEPRECATED)) continue;
            this.potentialKeys.addElement(savotFieldArray[n2].getId());
        }
        this.obsRefID = this.getObsRefID(savotFieldArray);
        this.obsNameID = this.getObsNameID(savotFieldArray);
        n2 = this.findFieldByUCD("VOX:BandPass_ID", savotFieldArray);
        Aladin.trace(3, "obsRefID : " + this.obsRefID);
        Aladin.trace(3, "obsNameID : " + this.obsNameID);
        this.obsRefIndex = this.findValIndex(stringArray, this.obsRefID);
        this.idxRefRelObs = this.findValIndex(stringArray, this.obsNameID);
        Vector<String> vector = new Vector<String>();
        this.namesToNodes = new Hashtable();
        this.altNamesToNodes = new Hashtable();
        ResourceNode[] resourceNodeArray = this.processSIAPEvolResource(this.orgSiapRes);
        this.registerKeyVal(savotFieldArray, resourceNodeArray);
        if (resourceNodeArray.length > 0) {
            resourceNode.siapSortFields = resourceNodeArray[0].description;
            object = resourceNodeArray[0];
            for (n = 0; n < ((ResourceNode)object).description.length; ++n) {
                vector.addElement(((ResourceNode)object).description[n]);
            }
        }
        if (this.isOnlyOrgSiap()) {
            Aladin.trace(3, "Processed as basic SIAP");
            for (int i = 0; i < resourceNodeArray.length; ++i) {
                resourceNode.addChild(resourceNodeArray[i]);
            }
        }
        if (this.dalExtRes != null) {
            Aladin.trace(3, "Entering processing of gen feat tab");
            this.processGenFeatTab(resourceNodeArray, vector);
        }
        this.alreadyAdded = new Vector();
        if (this.characTab != null) {
            Aladin.trace(3, "Entering processing of charac");
            this.processCharac();
        }
        if (this.compositionTab != null) {
            Aladin.trace(3, "Entering processing of composition table");
            this.processCompositionTab();
        }
        if (this.dataAccessTab != null) {
            Aladin.trace(3, "Entering processing of dataaccess table");
            this.processDataAccessTab();
        }
        object = this.otherTabs.elements();
        while (object.hasMoreElements()) {
            this.processGenericTable((SavotTable)object.nextElement());
        }
        if (!this.isOnlyOrgSiap()) {
            for (n = 0; n < resourceNodeArray.length; ++n) {
                if (this.alreadyAdded.contains(resourceNodeArray[n])) continue;
                resourceNode.addChild(resourceNodeArray[n]);
                resourceNodeArray[n].isLeaf = resourceNodeArray[n].getNbOfChildren() <= 0;
                this.alreadyAdded.addElement(resourceNodeArray[n]);
            }
        }
        Enumeration enumeration = resourceNode.getChildren();
        while (enumeration.hasMoreElements()) {
            ((ResourceNode)enumeration.nextElement()).isObs = true;
        }
        if (this.sortItems == null && n2 >= 0) {
            this.sortItems = new String[1];
            this.sortItems[0] = savotFieldArray[n2].getId();
            if (this.sortItems[0] == null || this.sortItems[0].length() == 0) {
                this.sortItems[0] = savotFieldArray[n2].getName();
            }
            if (this.sortItems[0] == null || this.sortItems[0].length() == 0) {
                this.sortItems = null;
            }
        }
        if (this.sortItems != null) {
            MetaDataTree.doSortSiapEvol(this.sortItems, resourceNode);
        }
        this.reset();
        return resourceNode;
    }

    private void processGenericTable(SavotTable savotTable) {
        String string = savotTable.getId();
        Hashtable<ResourceNode, ResourceNode> hashtable = new Hashtable<ResourceNode, ResourceNode>();
        SavotField[] savotFieldArray = this.createDescription(savotTable.getFields());
        int n = this.findKey(savotFieldArray);
        if (n < 0) {
            Aladin.trace(3, "Could not find key field when processing generic table");
            return;
        }
        Aladin.trace(3, string);
        Aladin.trace(3, "+++ : " + n);
        TRSet tRSet = savotTable.getData().getTableData().getTRs();
        if (tRSet.getItemCount() == 0) {
            return;
        }
        Enumeration<Object> enumeration = tRSet.getItems().elements();
        while (enumeration.hasMoreElements()) {
            ResourceNode resourceNode;
            SavotTR savotTR = (SavotTR)enumeration.nextElement();
            TDSet tDSet = savotTR.getTDs();
            String string2 = tDSet.getContent(n);
            ResourceNode resourceNode2 = this.getNodeFromKey(savotFieldArray[n], string2);
            if (resourceNode2 == null) {
                Aladin.trace(3, "Could not find an observation with key " + string2);
                continue;
            }
            if (hashtable.get(resourceNode2) == null) {
                resourceNode2.isLeaf = false;
                if (resourceNode2.location != null) {
                    resourceNode2.hasData = true;
                }
                resourceNode = new ResourceNode(this.aladin, string);
                resourceNode.isLeaf = false;
                resourceNode2.addChild(resourceNode);
                hashtable.put(resourceNode2, resourceNode);
            }
            ResourceNode resourceNode3 = (ResourceNode)hashtable.get(resourceNode2);
            resourceNode = this.createSIAPNode(savotTR, savotFieldArray);
            resourceNode3.addChild(resourceNode);
            this.setDatasetType(resourceNode);
            Aladin.trace(3, "key : " + string2);
            Aladin.trace(3, "***" + this.namesToNodes.get(string2));
        }
    }

    private void processDataAccessTab() {
        int n;
        int n2;
        SavotField[] savotFieldArray = this.createDescription(this.dataAccessTab.getFields());
        Hashtable<String, ResourceNode> hashtable = new Hashtable<String, ResourceNode>();
        TRSet tRSet = this.dataAccessTab.getData().getTableData().getTRs();
        if (tRSet.getItems() == null) {
            return;
        }
        Enumeration<Object> enumeration = tRSet.getItems().elements();
        int n3 = this.findFieldByID(this.obsRefID, savotFieldArray);
        int n4 = this.findFieldByUtype("Observation.Provenance.DataViewsAndAccess.AccessReference", savotFieldArray);
        if (n4 < 0) {
            n4 = this.findFieldByID("LinktoPixels", savotFieldArray);
        }
        if ((n2 = this.findFieldByUtype("Observation.Provenance.DataViewsAndAccess.ViewType", savotFieldArray)) < 0) {
            n2 = this.findFieldByID("DataOrganisation", savotFieldArray);
        }
        if ((n = this.findFieldByUtype("Observation.Provenance.DataViewsAndAccess.ViewDescription", savotFieldArray)) < 0) {
            n = this.findFieldByID("desc", savotFieldArray);
        }
        int n5 = this.findFieldByID("number", savotFieldArray);
        int n6 = this.findFieldByID("MapPare", savotFieldArray);
        String string = null;
        String string2 = null;
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            SavotTR savotTR = (SavotTR)enumeration.nextElement();
            TDSet tDSet = savotTR.getTDs();
            String string4 = tDSet.getContent(n3);
            ResourceNode resourceNode = (ResourceNode)this.namesToNodes.get(string4);
            if (resourceNode == null) continue;
            ResourceNode resourceNode2 = (ResourceNode)hashtable.get(string4);
            if (resourceNode2 == null) {
                resourceNode2 = new ResourceNode(this.aladin, "Data Access");
                hashtable.put(string4, resourceNode2);
                resourceNode.addChild(resourceNode2);
                resourceNode.isLeaf = false;
            }
            String string5 = "";
            if (n5 >= 0) {
                string5 = tDSet.getContent(n5).trim();
            }
            String string6 = "";
            if (n6 >= 0) {
                string6 = tDSet.getContent(n6).trim();
            }
            boolean bl = false;
            if (n4 >= 0) {
                string3 = tDSet.getContent(n4);
            }
            if (n2 >= 0) {
                string2 = tDSet.getContent(n2);
            }
            if (n >= 0) {
                string = tDSet.getContent(n);
            }
            bl = string2 != null && string2.equalsIgnoreCase("CUTOUTS");
            ResourceNode resourceNode3 = new ResourceNode(this.aladin, resourceNode);
            resourceNode3.name = "View";
            resourceNode3.isLeaf = true;
            resourceNode3.cutout = bl;
            resourceNode3.location = string3;
            if (resourceNode3.cutout) {
                stringArray = this.getRequestedPos() != null ? this.getRequestedPos() : resourceNode3.explanation[resourceNode3.ra] + " " + resourceNode3.explanation[resourceNode3.de];
                resourceNode3.setCutoutTarget((String)stringArray, false);
            }
            if (string2.equals("RETRIEVAL")) {
                resourceNode3.indexing = "HTML";
            }
            if (string != null && string.indexOf("characterization XML") >= 0) {
                resourceNode3.type = 6;
            }
            if (string5.length() > 0) {
                resourceNode3.maxImgNumber = string5;
            }
            if (string6.length() > 0 && (stringArray = SIAPExtBuilder.split(string6, ",")).length == 2) {
                try {
                    resourceNode3.beginVel = Double.valueOf(stringArray[0]);
                    resourceNode3.velStep = Double.valueOf(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            resourceNode3.dataOrga = string2.trim();
            if (string != null && string.length() > 0) {
                resourceNode3.name = string.trim();
            } else if (string2 != null && string2.length() > 0) {
                resourceNode3.name = string2.trim();
            }
            this.setDatasetType(resourceNode3);
            resourceNode2.addChild(resourceNode3);
        }
    }

    private void processCompositionTab() {
        SavotField[] savotFieldArray = this.createDescription(this.compositionTab.getFields());
        int n = this.findFieldByID(this.obsRefID, savotFieldArray);
        int n2 = this.findFieldByID("RelatedObservation", savotFieldArray);
        int n3 = this.findFieldByUtype("Observation/Provenance/Processing/Composition/description", savotFieldArray);
        Hashtable<String, ResourceNode> hashtable = new Hashtable<String, ResourceNode>();
        TRSet tRSet = this.compositionTab.getData().getTableData().getTRs();
        Enumeration<Object> enumeration = tRSet.getItems().elements();
        while (enumeration.hasMoreElements()) {
            String string;
            Vector vector;
            SavotTR savotTR = (SavotTR)enumeration.nextElement();
            String string2 = ((SavotTD)savotTR.getTDs().getItemAt(n)).getContent();
            ResourceNode resourceNode = (ResourceNode)this.namesToNodes.get(string2);
            if (resourceNode == null) continue;
            ResourceNode resourceNode2 = (ResourceNode)hashtable.get(string2);
            if (resourceNode2 == null) {
                resourceNode2 = n3 >= 0 ? new ResourceNode(this.aladin, ((SavotTD)savotTR.getTDs().getItemAt(n3)).getContent()) : new ResourceNode(this.aladin, "Members");
                hashtable.put(string2, resourceNode2);
                resourceNode.addChild(resourceNode2);
                resourceNode.isLeaf = false;
            }
            if ((vector = (Vector)this.altNamesToNodes.get(string = ((SavotTD)savotTR.getTDs().getItemAt(n2)).getContent())) == null) continue;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                ResourceNode resourceNode3 = (ResourceNode)enumeration2.nextElement();
                resourceNode2.addChild(resourceNode3);
                this.alreadyAdded.addElement(resourceNode3);
                if (resourceNode3.altName == null) continue;
                resourceNode3.name = resourceNode3.altName;
            }
        }
    }

    private void processCharac() {
        SavotField[] savotFieldArray = this.createDescription(this.characTab.getFields());
        int n = this.findFieldByID(this.obsRefID, savotFieldArray);
        Hashtable<String, ResourceNode> hashtable = new Hashtable<String, ResourceNode>();
        TRSet tRSet = this.characTab.getData().getTableData().getTRs();
        Enumeration<Object> enumeration = tRSet.getItems().elements();
        while (enumeration.hasMoreElements()) {
            Fov fov;
            SavotTR savotTR = (SavotTR)enumeration.nextElement();
            String string = ((SavotTD)savotTR.getTDs().getItemAt(n)).getContent();
            ResourceNode resourceNode = (ResourceNode)this.namesToNodes.get(string);
            if (resourceNode == null) continue;
            ResourceNode resourceNode2 = (ResourceNode)hashtable.get(string);
            if (resourceNode2 == null) {
                resourceNode2 = new ResourceNode(this.aladin, "Info/Metadata");
                hashtable.put(string, resourceNode2);
                resourceNode.addChild(resourceNode2);
                resourceNode.isLeaf = false;
            }
            if ((fov = this.getFovFromCharac(savotTR.getTDs(), savotFieldArray)) != null) {
                resourceNode.setFov(fov);
            }
            ResourceNode resourceNode3 = this.createSIAPNode(savotTR, savotFieldArray);
            resourceNode3.name = "CHARACTERIZATION";
            resourceNode3.type = 5;
            resourceNode2.addChild(resourceNode3);
        }
    }

    private void processGenFeatTab(ResourceNode[] resourceNodeArray, Vector vector) {
        this.processFov(resourceNodeArray, this.dalExtRes);
        if (this.idxRefRelObs < 0) {
            Aladin.trace(3, "idxRefRelObs is null, stop processing of genFeatTab");
            return;
        }
        Hashtable hashtable = new Hashtable();
        this.processGenFeat(this.dalExtRes, hashtable, vector);
        for (int i = 0; i < resourceNodeArray.length; ++i) {
            ResourceNode resourceNode = resourceNodeArray[i];
            ((Vector)this.altNamesToNodes.get(resourceNode.explanation[this.idxRefRelObs])).addElement(resourceNode);
            resourceNode.links = new Hashtable();
            block1: for (int j = 0; j < resourceNode.description.length; ++j) {
                String string = resourceNode.description[j] + resourceNode.explanation[j];
                ResourceNode resourceNode2 = (ResourceNode)hashtable.get(string);
                if (resourceNode2 == null) continue;
                resourceNode2.isLeaf = false;
                resourceNode.links.put(resourceNode.description[j], resourceNode2);
                for (int k = 0; k < resourceNode2.description.length; ++k) {
                    if (!resourceNode2.description[k].equals("Organisation")) continue;
                    resourceNode.origin = resourceNode2.explanation[k];
                    continue block1;
                }
            }
        }
    }

    private void preCheck() {
        ResourceSet resourceSet = this.votable.getResources();
        Aladin.trace(3, "nb rsources : " + resourceSet.getItemCount());
        for (int i = 0; i < resourceSet.getItemCount(); ++i) {
            SavotResource savotResource = (SavotResource)resourceSet.getItemAt(i);
            this.checkIfOrgSiap(savotResource);
            if (this.checkIfDalExt(savotResource)) continue;
            TableSet tableSet = savotResource.getTables();
            for (int j = 0; j < tableSet.getItemCount(); ++j) {
                Aladin.trace(3, "Process table " + j);
                SavotTable savotTable = (SavotTable)tableSet.getItemAt(j);
                if (this.genFeatTab == null && (savotTable.getUtype().trim().equalsIgnoreCase(this.getUType(UT_GENFEATURES)) || savotTable.getUtype().trim().equalsIgnoreCase(this.getUType(UT_GENFEATURES_DEPRECATED)))) {
                    this.genFeatTab = savotTable;
                    continue;
                }
                if (this.characTab == null && savotTable.getUtype().trim().equalsIgnoreCase(this.getUType(UT_CHARACTERIZATION))) {
                    this.characTab = savotTable;
                    continue;
                }
                if (this.dataAccessTab == null && (savotTable.getUtype().trim().equalsIgnoreCase(this.getUType(UT_DATAACCESS)) || savotTable.getUtype().trim().equalsIgnoreCase(this.getUType(UT_DATAACCESS_DEPRECATED)))) {
                    this.dataAccessTab = savotTable;
                    continue;
                }
                if (this.compositionTab == null && savotTable.getUtype().trim().equalsIgnoreCase(this.getUType(UT_COMPOSITION))) {
                    this.compositionTab = savotTable;
                    continue;
                }
                if (i == 0) continue;
                this.otherTabs.addElement(savotTable);
            }
        }
    }

    private boolean isOnlyOrgSiap() {
        return this.dalExtRes == null && this.characTab == null && this.compositionTab == null && this.dalExtRes == null && this.dataAccessTab == null && this.genFeatTab == null;
    }

    private ResourceNode[] processSIAPEvolResource(SavotResource savotResource) {
        Aladin.trace(3, "Processing original SIAP resource");
        SavotField[] savotFieldArray = this.createDescription(savotResource.getFieldSet(0));
        if (savotResource.getData(0) == null) {
            return null;
        }
        if (savotResource.getData(0).getTableData() == null) {
            return null;
        }
        TRSet tRSet = savotResource.getData(0).getTableData().getTRs();
        ResourceNode[] resourceNodeArray = new ResourceNode[tRSet.getItemCount()];
        for (int i = 0; i < resourceNodeArray.length; ++i) {
            resourceNodeArray[i] = this.createSIAPNode((SavotTR)tRSet.getItemAt(i), savotFieldArray);
            resourceNodeArray[i].isSIAPEvol = true;
            if (this.idxRefRelObs >= 0 && this.obsRefIndex >= 0) {
                resourceNodeArray[i].altName = resourceNodeArray[i].explanation[this.obsRefIndex];
            }
            if (this.obsRefIndex >= 0) {
                this.namesToNodes.put(resourceNodeArray[i].explanation[this.obsRefIndex], resourceNodeArray[i]);
            }
            if (this.idxRefRelObs < 0 || this.altNamesToNodes.get(resourceNodeArray[i].explanation[this.idxRefRelObs]) != null) continue;
            this.altNamesToNodes.put(resourceNodeArray[i].explanation[this.idxRefRelObs], new Vector());
        }
        return resourceNodeArray;
    }

    private void checkIfOrgSiap(SavotResource savotResource) {
        if (this.orgSiapRes != null) {
            return;
        }
        if (savotResource.getUtype().trim().equalsIgnoreCase(this.getUType(UT_SIMPLEQUERY)) || savotResource.getType().equalsIgnoreCase("results")) {
            this.orgSiapRes = savotResource;
        }
    }

    private boolean checkIfDalExt(SavotResource savotResource) {
        if (this.dalExtRes != null) {
            return false;
        }
        if (savotResource.getUtype().trim().equalsIgnoreCase(this.getUType(UT_DALEXTENSIONS)) || savotResource.getUtype().trim().equalsIgnoreCase("dal:footprint.geom")) {
            this.isFootprintDoc = true;
            this.dalExtRes = savotResource;
            return true;
        }
        return false;
    }

    private Fov getFovFromCharac(TDSet tDSet, SavotField[] savotFieldArray) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        Fov fov = null;
        int n = this.findFieldByUtype(this.getUType(UT_RADEC), savotFieldArray);
        int n2 = this.findFieldByUtype(this.getUType(UT_MINRADEC), savotFieldArray);
        int n3 = this.findFieldByUtype(this.getUType(UT_MAXRADEC), savotFieldArray);
        if (n < 0 || n2 < 0 || n3 < 0) {
            return null;
        }
        String string = tDSet.getContent(n);
        String string2 = tDSet.getContent(n2);
        String string3 = tDSet.getContent(n3);
        try {
            String[] stringArray = SIAPExtBuilder.split(string, " ");
            d6 = Double.valueOf(stringArray[0]);
            d5 = Double.valueOf(stringArray[1]);
            stringArray = SIAPExtBuilder.split(string2, " ");
            d4 = Double.valueOf(stringArray[0]);
            d3 = Double.valueOf(stringArray[1]);
            stringArray = SIAPExtBuilder.split(string3, " ");
            d2 = Double.valueOf(stringArray[0]);
            d = Double.valueOf(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        fov = new Fov(d6, d5, new double[]{d4, d3}, new double[]{d2, d}, 0.0);
        return fov;
    }

    private String getUType(String string) {
        return string;
    }

    private void reset() {
        this.parser = null;
        this.votable = null;
        this.orgSiapRes = null;
        this.dalExtRes = null;
        this.otherTabs = new Vector();
        this.potentialKeys = new Vector();
        this.keyToNodes = new Hashtable();
        this.sortItems = null;
        this.isFootprintDoc = false;
    }

    private String getObsRefID(SavotField[] savotFieldArray) {
        for (int i = 0; i < savotFieldArray.length; ++i) {
            Aladin.trace(3, "Reading field : " + savotFieldArray[i].getId());
            if (!savotFieldArray[i].getUtype().equals(UT_OBS_DATASET_ID) && !savotFieldArray[i].getUtype().equals(UT_OBS_DATASET_ID_DEPRECATED)) continue;
            return savotFieldArray[i].getId();
        }
        return null;
    }

    private String getObsNameID(SavotField[] savotFieldArray) {
        for (int i = 0; i < savotFieldArray.length; ++i) {
            if (!savotFieldArray[i].getUtype().equals("Observation/TargetName")) continue;
            return savotFieldArray[i].getId();
        }
        return null;
    }

    private void setDatasetType(ResourceNode resourceNode) {
        String string = resourceNode.getFieldValFromUtype("Observation.Provenance.DataViewsAndAccess.ViewType");
        if (string == null) {
            resourceNode.getFieldValFromUtype("DatasetType");
        }
        if (string == null) {
            string = resourceNode.dataOrga;
        }
        if (string == null) {
            string = resourceNode.getFieldValFromUtype("Access.Format");
        }
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("RETRIEVAL")) {
            resourceNode.indexing = "HTML";
        } else if (string.equalsIgnoreCase("IMAGE")) {
            resourceNode.type = 1;
        } else if (string.equalsIgnoreCase("CUBE")) {
            resourceNode.type = 4;
        } else if (string.equalsIgnoreCase("SPECTRUM") || string.startsWith("spectrum")) {
            resourceNode.type = 3;
        } else if (string.equalsIgnoreCase("CATALOGUE")) {
            resourceNode.type = 7;
        } else if (string.startsWith("text/xml")) {
            resourceNode.type = 2;
        }
    }

    private int findKey(SavotField[] savotFieldArray) {
        for (int i = 0; i < savotFieldArray.length; ++i) {
            if (!this.isPotentialKey(savotFieldArray[i])) continue;
            return i;
        }
        return -1;
    }

    private ResourceNode getNodeFromKey(SavotField savotField, String string) {
        return (ResourceNode)this.keyToNodes.get(savotField.getId() + "__" + string);
    }

    private boolean isPotentialKey(SavotField savotField) {
        String string = savotField.getId();
        if (string == null || string.length() == 0) {
            return false;
        }
        return this.potentialKeys.contains(string);
    }

    private void registerKeyVal(SavotField[] savotFieldArray, ResourceNode[] resourceNodeArray) {
        for (int i = 0; i < savotFieldArray.length; ++i) {
            if (!this.isPotentialKey(savotFieldArray[i])) continue;
            Aladin.trace(3, "Field " + savotFieldArray[i].getId() + " might be a key");
            String string = savotFieldArray[i].getId();
            for (int j = 0; j < resourceNodeArray.length; ++j) {
                ResourceNode resourceNode = resourceNodeArray[j];
                String string2 = resourceNode.explanation[i];
                this.keyToNodes.put(string + "__" + string2, resourceNode);
            }
        }
    }

    private void processFov(ResourceNode[] resourceNodeArray, SavotResource savotResource) {
        int n;
        Aladin.trace(3, "Entering processFov");
        ResourceSet resourceSet = savotResource.getResources();
        if (resourceSet == null || (n = resourceSet.getItemCount()) == 0) {
            return;
        }
        Vector<SavotResource> vector = new Vector<SavotResource>();
        for (int i = 0; i < n; ++i) {
            SavotResource savotResource2 = (SavotResource)resourceSet.getItemAt(i);
            if (!savotResource2.getUtype().equalsIgnoreCase("ivoa:characterization[ucd=pos]/coverage/support") && !savotResource2.getUtype().equalsIgnoreCase("char:SpatialAxis.coverage.support")) continue;
            vector.addElement(savotResource2);
        }
        if (vector.size() == 0) {
            Aladin.trace(3, "Did not find any FoV description !");
            return;
        }
        Object[] objectArray = new SavotResource[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        FootprintParser footprintParser = new FootprintParser((SavotResource[])objectArray);
        Hashtable<String, FootprintBean> hashtable = footprintParser.getFooprintHash();
        for (int i = 0; i < resourceNodeArray.length; ++i) {
            double d;
            double d2;
            double d3;
            FootprintBean footprintBean;
            ResourceNode resourceNode = resourceNodeArray[i];
            String string = resourceNode.getFieldValFromUtype("ivoa:characterization[ucd=pos]/coverage/support/@id");
            if (string == null) {
                string = resourceNode.getFieldValFromUtype("dal:footprint.geom.id");
            }
            if (string == null || string.length() == 0 || (footprintBean = hashtable.get(string)) == null) continue;
            try {
                int n2;
                String string2;
                String string3 = resourceNode.getFieldValFromUcd("POS_EQ_RA_MAIN");
                if (string3 == null) {
                    string3 = resourceNode.getFieldValFromUcd("pos.eq.ra;meta.main");
                }
                if ((string2 = resourceNode.getFieldValFromUcd("POS_EQ_DEC_MAIN")) == null) {
                    string2 = resourceNode.getFieldValFromUcd("pos.eq.dec;meta.main");
                }
                double[] dArray = TreeView.getDeciCoord(string3, string2);
                d3 = dArray[0];
                d2 = dArray[1];
                String string4 = resourceNode.getFieldValFromUtype(FOV_POS_ANGLE);
                if (string4 == null) {
                    string4 = resourceNode.getFieldValFromName("PA");
                }
                if (string4 == null) {
                    string4 = resourceNode.getFieldValFromName("Position Angle");
                }
                if (string4 == null) {
                    string4 = "0";
                }
                if ((n2 = string4.indexOf(176)) < 0) {
                    n2 = string4.indexOf("deg");
                }
                if (n2 < 0) {
                    n2 = string4.indexOf(" ");
                }
                if (n2 < 0) {
                    n2 = string4.indexOf("'");
                }
                if (n2 < 0) {
                    n2 = string4.indexOf(34);
                }
                if (n2 < 0) {
                    n2 = string4.indexOf("arc");
                }
                if (n2 > 0) {
                    string4 = string4.substring(0, n2);
                }
                try {
                    d = Double.valueOf(string4);
                }
                catch (Exception exception) {
                    Aladin.trace(3, "Could not find position angle field, assuming value is 0");
                    d = 0.0;
                }
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                continue;
            }
            PlanField planField = new PlanField(this.aladin, footprintBean, string);
            planField.make(d3, d2, d);
            resourceNode.setFov(new Fov(this.aladin, footprintBean, string, d3, d2, d));
        }
    }
}

