/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ResourceNode;
import cds.aladin.Tok;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;

public class SIAPruner {
    private ResourceNode[] nodesToPrune;
    private String[] constraints;

    public SIAPruner(ResourceNode[] resourceNodeArray, String[] stringArray) {
        this.setNodesToPrune(resourceNodeArray);
        this.setConstraints(stringArray);
    }

    public ResourceNode[] prune() {
        ResourceNode[] resourceNodeArray;
        if (this.nodesToPrune == null) {
            return null;
        }
        ArrayList<ResourceNode> arrayList = new ArrayList<ResourceNode>(Arrays.asList(this.nodesToPrune));
        SIAPrunerConstraint sIAPrunerConstraint = new SIAPrunerConstraintFactory().create(this.constraints);
        Aladin.trace(1, "Constraint is: " + sIAPrunerConstraint);
        if (sIAPrunerConstraint.orderBy > 0 && sIAPrunerConstraint.orderBy == sIAPrunerConstraint.ORDERBYDIST) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    double d;
                    ResourceNode resourceNode = (ResourceNode)object;
                    ResourceNode resourceNode2 = (ResourceNode)object2;
                    double d2 = resourceNode.getDistanceToCenter();
                    return d2 == (d = resourceNode2.getDistanceToCenter()) ? 0 : (d2 > d ? 1 : -1);
                }
            });
        }
        ArrayList<ResourceNode> arrayList2 = new ArrayList<ResourceNode>();
        for (ResourceNode resourceNode : arrayList) {
            Enumeration enumeration = sIAPrunerConstraint.fieldConstraints.keys();
            while (enumeration.hasMoreElements()) {
                resourceNodeArray = (ResourceNode[])enumeration.nextElement();
                String string = (String)sIAPrunerConstraint.fieldConstraints.get(resourceNodeArray);
                if (resourceNode.matchFieldConstraint((String)resourceNodeArray, string = Tok.unQuote(string), true)) continue;
                arrayList2.add(resourceNode);
            }
            for (String string : sIAPrunerConstraint.freeConstraints) {
                if (resourceNode.matchFreeConstraint(string, true)) continue;
                arrayList2.add(resourceNode);
            }
        }
        arrayList.removeAll(arrayList2);
        if (arrayList.size() == 0) {
            Aladin.warning("Could not find any data corresponding to your request");
            return null;
        }
        int n = Math.min(sIAPrunerConstraint.nbRequested, arrayList.size());
        resourceNodeArray = new ResourceNode[n];
        System.arraycopy(arrayList.subList(0, n).toArray(), 0, resourceNodeArray, 0, n);
        return resourceNodeArray;
    }

    public void setNodesToPrune(ResourceNode[] resourceNodeArray) {
        this.nodesToPrune = resourceNodeArray;
    }

    public void setConstraints(String[] stringArray) {
        this.constraints = stringArray;
    }

    class SIAPrunerConstraint {
        final int ORDERBYDIST = 1;
        int orderBy = -1;
        int nbRequested = 1;
        ArrayList freeConstraints = new ArrayList();
        Hashtable fieldConstraints = new Hashtable();

        SIAPrunerConstraint() {
        }

        public String toString() {
            String string = "";
            string = string + "orderBy=" + this.orderBy;
            string = string + ", nbRequested=" + this.nbRequested;
            string = string + ", freeConstraints=" + this.freeConstraints;
            string = string + ", fieldConstraints=" + this.fieldConstraints;
            return string;
        }
    }

    class SIAPrunerConstraintFactory {
        SIAPrunerConstraintFactory() {
        }

        private SIAPrunerConstraint create(String[] stringArray) {
            SIAPrunerConstraint sIAPrunerConstraint = new SIAPrunerConstraint();
            String string = null;
            String string2 = null;
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3 == null) continue;
                int n = (string3 = string3.trim()).indexOf(61);
                if (n >= 0) {
                    string2 = string3.substring(0, n).trim();
                    string = string3.substring(n + 1).trim();
                    if (!string2.toLowerCase().equals("keyword")) {
                        bl = true;
                    } else {
                        bl = false;
                        string3 = string;
                    }
                } else {
                    bl = false;
                }
                if (bl && string2.equalsIgnoreCase("sortby")) {
                    if (!string.equalsIgnoreCase("dist")) continue;
                    sIAPrunerConstraint.orderBy = sIAPrunerConstraint.ORDERBYDIST;
                    continue;
                }
                if (bl && string2.equalsIgnoreCase("number")) {
                    try {
                        int n2 = Integer.parseInt(string);
                        if (n2 <= 0) continue;
                        sIAPrunerConstraint.nbRequested = n2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Aladin.warning("Can't parse " + string + " as an integer !\nConstraint ignored");
                    }
                    continue;
                }
                if (bl) {
                    sIAPrunerConstraint.fieldConstraints.put(string2, string);
                    continue;
                }
                sIAPrunerConstraint.freeConstraints.add(string3);
            }
            return sIAPrunerConstraint;
        }
    }
}

