/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Cercle;
import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.FrameHeaderFits;
import cds.aladin.Legende;
import cds.aladin.Ligne;
import cds.aladin.Localisation;
import cds.aladin.MyButton;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyLabel;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanFilter;
import cds.aladin.PlanFolder;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageAlgo;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanMoc;
import cds.aladin.PlanRGBInterface;
import cds.aladin.PlanTool;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Repere;
import cds.aladin.ServerAladin;
import cds.aladin.Source;
import cds.aladin.SourceStat;
import cds.aladin.Tag;
import cds.aladin.Tok;
import cds.aladin.ViewMemo;
import cds.aladin.ViewMemoItem;
import cds.aladin.ViewSimple;
import cds.aladin.Words;
import cds.fits.Fits;
import cds.fits.HeaderFits;
import cds.image.BMPWriter;
import cds.image.EPSGraphics;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import cds.xml.Field;
import cds.xml.XMLParser;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.CRC32;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public final class Save
extends JFrame
implements ActionListener {
    static final String CR = cds.tools.Util.CR;
    static final String[] FORMAT = new String[]{"BMP", "EPS", "JPEG", "PNG", "PNG+LINK"};
    static final int BMP = 1;
    static final int EPS = 2;
    static final int JPEG = 4;
    static final int PNG = 8;
    static final int LK = 16;
    static final int LK_FLEX = 32;
    private static final int TSV = 0;
    private static final int JSON = 1;
    private static final int XML = 2;
    static final int CURRENTVIEW = 0;
    static final int ALLROIS = 2;
    static final int SAVEVIEW = 0;
    static final int EXPORTPLANS = 1;
    static final int BACKUPSTACK = 2;
    static final int ALLVIEWS = 3;
    Aladin aladin;
    JPanel p;
    static String[] INFOCHOICE;
    static String[] CHOICE;
    static String TITLE;
    static String INFO;
    static String FISTINFO;
    static String SECONDINFO;
    static String CLOSE;
    static String EXPORT;
    static String DIR;
    static String CANNOT;
    static String CANNOT1;
    static String INFOIMG;
    static String SAVEIN;
    static String SAVERGBIN;
    static String ENCODER;
    JTextField directory;
    JTextField[] fileSavePlan;
    Plan[] listPlan;
    int nbSavePlan;
    JComboBox format;
    JComboBox format1;
    JCheckBox[] cbPlan;
    JRadioButton tsvCb;
    JRadioButton votCb;
    JRadioButton jsonCb;
    JRadioButton jsonMocCb;
    JRadioButton fitsMocCb;
    JRadioButton fitsCb;
    JRadioButton jpgCb;
    JRadioButton pngCb;
    JLabel info;
    String errorFile = null;
    boolean first = true;
    private JFrame frameExport;
    boolean firstFlagFits = true;
    private static int MAXBUF;
    private static byte[] buf;
    private static int nbuf;
    private static FileOutputStream f;
    private static final String[] EXTENSIONS;
    private static String B64;
    static int[] b642a;
    private static final String BYALADIN = "This astrometrical calibration was computed via Aladin";
    byte[] nan;
    final String COMPNG = "tEXtComment";

    protected static String[] getFormat() {
        return FORMAT;
    }

    protected static String[] getFormatMenu() {
        String[] stringArray = new String[FORMAT.length - 1];
        int n = 0;
        for (int i = 0; i < FORMAT.length; ++i) {
            if (FORMAT[i].equals("EPS")) continue;
            stringArray[n++] = "%" + FORMAT[i];
        }
        return stringArray;
    }

    protected static int getCodedFormat(int n) {
        if (n < 4) {
            return (int)Math.pow(2.0, n);
        }
        return 24;
    }

    protected void createChaine() {
        TITLE = Aladin.chaine.getString("SFTITLE");
        INFO = Aladin.chaine.getString("SFINFO");
        SECONDINFO = Aladin.chaine.getString("SFSECONDINFO");
        CLOSE = Aladin.chaine.getString("CLOSE");
        EXPORT = Aladin.chaine.getString("SFEXPORT");
        DIR = Aladin.chaine.getString("SFDIR");
        CANNOT = Aladin.chaine.getString("SFCANNOT");
        CANNOT1 = Aladin.chaine.getString("SFCANNOT1");
        INFOIMG = Aladin.chaine.getString("SFINFOIMG");
        SAVEIN = Aladin.chaine.getString("SFSAVEIN");
        SAVERGBIN = Aladin.chaine.getString("SFSAVERGBIN");
        ENCODER = Aladin.chaine.getString("SFJPEGENCODER");
        if (Aladin.BETA) {
            String[] stringArray = new String[4];
            stringArray[0] = Aladin.chaine.getString("SFCH3");
            stringArray[1] = Aladin.chaine.getString("SFCH2");
            stringArray[2] = Aladin.chaine.getString("SFCH1");
            stringArray[3] = Aladin.chaine.getString("SFCH6");
            CHOICE = stringArray;
            String[] stringArray2 = new String[4];
            stringArray2[0] = Aladin.chaine.getString("SFHCH3");
            stringArray2[1] = Aladin.chaine.getString("SFHCH2");
            stringArray2[2] = Aladin.chaine.getString("SFHCH1");
            stringArray2[3] = Aladin.chaine.getString("SFHCH6");
            INFOCHOICE = stringArray2;
        } else {
            String[] stringArray = new String[3];
            stringArray[0] = Aladin.chaine.getString("SFCH3");
            stringArray[1] = Aladin.chaine.getString("SFCH2");
            stringArray[2] = Aladin.chaine.getString("SFCH1");
            CHOICE = stringArray;
            String[] stringArray3 = new String[3];
            stringArray3[0] = Aladin.chaine.getString("SFHCH3");
            stringArray3[1] = Aladin.chaine.getString("SFHCH2");
            stringArray3[2] = Aladin.chaine.getString("SFHCH1");
            INFOCHOICE = stringArray3;
        }
    }

    protected Save(Aladin aladin) {
        this(aladin, false);
    }

    protected Save(Aladin aladin, boolean bl) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(TITLE);
        this.p = this.getFirstPanel();
        Aladin.makeAdd(this, this.p, "Center");
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        cds.tools.Util.setCloseShortcut(this, false, aladin);
        this.setLocation(Aladin.computeLocation(this));
        this.pack();
        if (bl) {
            this.show();
        }
    }

    private JPanel getFirstPanel() {
        JComponent jComponent;
        JPanel jPanel;
        JComponent jComponent2;
        JPanel jPanel2 = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setFont(Aladin.BOLD);
        for (int i = 0; i < CHOICE.length; ++i) {
            int n;
            jComponent2 = new MyButton(this.aladin, CHOICE[i]);
            jComponent2.setRond();
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.insets = new Insets(4, 5, 0, 3);
            gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
            jPanel2.add(jComponent2);
            if (i == 0) {
                jPanel = new JPanel();
                jComponent = new MyLabel(INFOCHOICE[i], 0, Aladin.PLAIN);
                jPanel.add(jComponent);
                this.format = new JComboBox();
                for (n = 0; n < FORMAT.length; ++n) {
                    this.format.addItem(FORMAT[n] + " format");
                }
                this.format.setSelectedIndex(3);
                jPanel.add(this.format);
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints(jPanel, gridBagConstraints);
                jPanel2.add(jPanel);
                continue;
            }
            if (i == 3) {
                jPanel = new JPanel();
                jComponent = new MyLabel(INFOCHOICE[i], 0, Aladin.PLAIN);
                jPanel.add(jComponent);
                this.format1 = new JComboBox();
                for (n = 0; n < FORMAT.length; ++n) {
                    this.format1.addItem(FORMAT[n] + " format");
                }
                this.format1.setSelectedIndex(2);
                jPanel.add(this.format1);
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints(jPanel, gridBagConstraints);
                jPanel2.add(jPanel);
                continue;
            }
            jPanel = new MyLabel(INFOCHOICE[i], 0, Aladin.PLAIN);
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            jPanel2.add(jPanel);
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(5, 5));
        jComponent2 = new MyLabel(INFO, 1, Aladin.BOLD);
        Aladin.makeAdd(jPanel3, jComponent2, "North");
        Aladin.makeAdd(jPanel3, jPanel2, "Center");
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jComponent = new JButton(CLOSE);
        jComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Save.this.hide();
            }
        });
        this.info = new JLabel();
        this.info.setFont(this.info.getFont().deriveFont(2));
        Aladin.makeAdd(jPanel, this.info, "Center");
        Aladin.makeAdd(jPanel, jComponent, "East");
        Aladin.makeAdd(jPanel3, jPanel, "South");
        return jPanel3;
    }

    protected void exportPlans() {
        this.frameExport = new JFrame();
        Aladin.makeAdd(this.frameExport, new MyLabel(SECONDINFO, 1, Aladin.BOLD), "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1));
        JPanel jPanel2 = this.getPlanPanel();
        if (jPanel2 == null) {
            return;
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        int n = Math.min(400, this.aladin.calque.getNbUsedPlans() * 50 + 30);
        jScrollPane.setMaximumSize(new Dimension(200, n));
        jPanel.add(jScrollPane);
        Aladin.makeAdd(this.frameExport, jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(5, 5));
        JPanel jPanel4 = new JPanel();
        this.directory = new JTextField(this.aladin.getDefaultDirectory(), 30);
        jPanel4.add(new JLabel(DIR));
        jPanel4.add(this.directory);
        Aladin.makeAdd(jPanel3, jPanel4, "West");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1));
        JButton jButton = new JButton(EXPORT);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Save.this.actionExportPlans();
            }
        });
        jPanel5.add(jButton);
        jButton = new JButton(CLOSE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Save.this.frameExportClose();
            }
        });
        jPanel5.add(jButton);
        Aladin.makeAdd(jPanel3, jPanel5, "Center");
        Aladin.makeAdd(this.frameExport, jPanel3, "South");
        this.frameExport.pack();
        Point point = this.getLocation();
        point.translate(20, 40);
        this.frameExport.setLocation(point);
        this.frameExport.setVisible(true);
    }

    private void frameExportClose() {
        this.frameExport.dispose();
    }

    protected void actionExportPlans() {
        boolean bl = true;
        boolean bl2 = false;
        this.errorFile = "";
        block6: for (int i = 0; i < this.nbSavePlan; ++i) {
            if (!this.cbPlan[i].isSelected()) continue;
            Plan plan = this.listPlan[i];
            File file = new File(this.directory.getText(), this.fileSavePlan[i].getText());
            this.aladin.console.printCommand("export " + Tok.quote(plan.label) + " " + file.getAbsolutePath());
            switch (plan.type) {
                case 19: {
                    String string = this.directory.getText() + cds.tools.Util.FS + this.fileSavePlan[i].getText();
                    bl &= this.saveMoc(string, (PlanMoc)plan, this.jsonMocCb != null && this.jsonMocCb.isSelected() ? 2 : 0);
                    continue block6;
                }
                case 9: {
                    if (plan.isCatalog()) {
                        bl &= this.saveCatalog(file, plan, this.tsvCb.isSelected() ? 0 : (this.jsonCb != null && this.jsonCb.isSelected() ? 1 : 2));
                        continue block6;
                    }
                    bl &= this.saveToolTSV(file, plan);
                    continue block6;
                }
                case 8: 
                case 18: {
                    bl &= this.saveCatalog(file, plan, this.tsvCb.isSelected() ? 0 : (this.jsonCb != null && this.jsonCb.isSelected() ? 1 : 2));
                    continue block6;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    String string = this.directory.getText() + cds.tools.Util.FS + this.fileSavePlan[i].getText();
                    bl &= this.saveImage(string, plan, this.pngCb != null && this.pngCb.isSelected() ? 3 : (this.jpgCb != null && this.jpgCb.isSelected() ? 2 : 0));
                }
            }
        }
        if (!bl) {
            Aladin.warning(this, CANNOT + "\n " + this.errorFile, 1);
        } else {
            this.setVisible(false);
            if (bl2 && this.firstFlagFits) {
                this.firstFlagFits = false;
                Aladin.info(this, INFOIMG);
            }
            this.frameExportClose();
        }
        this.aladin.memoDefaultDirectory(this.directory.getText());
    }

    protected JPanel getPlanPanel() {
        Serializable serializable;
        JComponent jComponent;
        Object object;
        Object object2;
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        int n2 = this.aladin.calque.getNbUsedPlans();
        this.fileSavePlan = new JTextField[n2];
        this.cbPlan = new JCheckBox[n2];
        this.listPlan = new Plan[n2];
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        Plan[] planArray = this.aladin.calque.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            object2 = planArray[i];
            if (((Plan)object2).type == 0 || ((Plan)object2).type == 10 || ((Plan)object2).type == 11 || !((Plan)object2).flagOk || object2 instanceof PlanBG && ((Plan)object2).type != 19) continue;
            if (((Plan)object2).isSimpleCatalog() && bl) {
                bl = false;
            }
            if (((Plan)object2).isImage() && bl2) {
                bl2 = false;
            }
            if (object2 instanceof PlanMoc && bl3) {
                bl3 = false;
            }
            this.listPlan[n] = object2;
            this.cbPlan[n] = new JCheckBox(n + ".- ", ((Plan)object2).selected);
            object = ((Plan)object2).label;
            jComponent = new JLabel((String)object);
            jComponent.setForeground(((Plan)object2).c);
            serializable = new JLabel(Plan.Tp[((Plan)object2).type]);
            String string = ServerAladin.blankToUnderline((String)object);
            while (string.charAt(0) == '.') {
                string = string.substring(1);
            }
            string = string.replace('\\', '-');
            string = string.replace('/', '-');
            string = string.replace(':', '-');
            string = string.replace('[', '-');
            string = string.replace(']', '-');
            if (((Plan)object2).isImage() || ((Plan)object2).type == 19) {
                if (!string.endsWith(".fits")) {
                    string = string + ".fits";
                }
            } else {
                string = string + ".txt";
            }
            this.fileSavePlan[n] = new JTextField(string, 20);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.cbPlan[n], gridBagConstraints);
            jPanel.add(this.cbPlan[n]);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel.add(jComponent);
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.fileSavePlan[n], gridBagConstraints);
            jPanel.add(this.fileSavePlan[n]);
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints((Component)serializable, gridBagConstraints);
            jPanel.add((Component)serializable);
            ++n;
        }
        if (n == 0) {
            Aladin.warning(this, "There is no available plan to export !");
            return null;
        }
        if (!bl) {
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 13;
            object2 = new JLabel("");
            gridBagLayout.setConstraints((Component)object2, gridBagConstraints);
            jPanel.add((Component)object2);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            object = new JLabel(SAVEIN);
            ((JComponent)object).setFont(Aladin.BOLD);
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            jPanel.add((Component)object);
            jComponent = new JPanel();
            jComponent.setLayout(new FlowLayout(0));
            serializable = new ButtonGroup();
            this.tsvCb = new JRadioButton("TSV");
            this.tsvCb.setActionCommand("TSV");
            this.votCb = new JRadioButton("VOTABLE");
            this.votCb.setActionCommand("VOTABLE");
            this.jsonCb = new JRadioButton("JSON");
            this.jsonCb.setActionCommand("JSON");
            ((ButtonGroup)serializable).add(this.tsvCb);
            ((ButtonGroup)serializable).add(this.votCb);
            ((ButtonGroup)serializable).add(this.jsonCb);
            this.tsvCb.setSelected(true);
            jComponent.add(this.tsvCb);
            jComponent.add(this.votCb);
            jComponent.add(this.jsonCb);
            this.tsvCb.addActionListener(this);
            this.votCb.addActionListener(this);
            this.jsonCb.addActionListener(this);
            gridBagConstraints.gridwidth = 1;
            if (!bl2 || !bl3) {
                gridBagConstraints.gridwidth = 0;
            }
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel.add(jComponent);
        }
        if (!bl2) {
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 13;
            object2 = new JLabel("");
            gridBagLayout.setConstraints((Component)object2, gridBagConstraints);
            jPanel.add((Component)object2);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            object = new JLabel(SAVERGBIN);
            ((JComponent)object).setFont(Aladin.BOLD);
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            jPanel.add((Component)object);
            jComponent = new JPanel();
            jComponent.setLayout(new FlowLayout(0));
            serializable = new ButtonGroup();
            this.fitsCb = new JRadioButton("FITS");
            this.fitsCb.setActionCommand("FITS");
            this.jpgCb = new JRadioButton("JPEG");
            this.jpgCb.setActionCommand("JPEG");
            this.pngCb = new JRadioButton("PNG");
            this.pngCb.setActionCommand("PNG");
            ((ButtonGroup)serializable).add(this.fitsCb);
            ((ButtonGroup)serializable).add(this.jpgCb);
            ((ButtonGroup)serializable).add(this.pngCb);
            this.fitsCb.setSelected(true);
            jComponent.add(this.fitsCb);
            jComponent.add(this.jpgCb);
            jComponent.add(this.pngCb);
            this.fitsCb.addActionListener(this);
            this.jpgCb.addActionListener(this);
            this.pngCb.addActionListener(this);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets.top = 2;
            gridBagConstraints.insets.bottom = 2;
            if (!bl3) {
                gridBagConstraints.gridwidth = 0;
            }
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel.add(jComponent);
        }
        if (!bl3) {
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 13;
            object2 = new JLabel("");
            gridBagLayout.setConstraints((Component)object2, gridBagConstraints);
            jPanel.add((Component)object2);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            object = new JLabel(SAVEIN);
            ((JComponent)object).setFont(Aladin.BOLD);
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            jPanel.add((Component)object);
            jComponent = new JPanel();
            jComponent.setLayout(new FlowLayout(0));
            serializable = new ButtonGroup();
            this.fitsMocCb = new JRadioButton("FITS");
            this.fitsMocCb.setActionCommand("FITS");
            this.jsonMocCb = new JRadioButton("ASCII/JSON");
            this.jsonMocCb.setActionCommand("ASCII/JSON");
            ((ButtonGroup)serializable).add(this.fitsMocCb);
            ((ButtonGroup)serializable).add(this.jsonMocCb);
            this.fitsMocCb.setSelected(true);
            jComponent.add(this.fitsMocCb);
            jComponent.add(this.jsonMocCb);
            this.fitsMocCb.addActionListener(this);
            this.jsonMocCb.addActionListener(this);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel.add(jComponent);
        }
        this.nbSavePlan = n;
        return jPanel;
    }

    protected void saveFile(int n) {
        this.saveFile(n, 1, -1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFile(int n, int n2, float f) {
        boolean bl;
        FileDialog fileDialog = new FileDialog((Frame)this, "", 1);
        this.aladin.setDefaultDirectory(fileDialog);
        fileDialog.setVisible(true);
        this.aladin.memoDefaultDirectory(fileDialog);
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 == null) {
            return;
        }
        String string3 = (string == null ? "" : string) + (string2 == null ? "" : string2);
        Aladin.makeCursor(this, 1);
        try {
            if (n == 0) {
                if (!cds.tools.Util.toLower(string3).endsWith(".aj")) {
                    string3 = string3 + ".aj";
                }
                this.aladin.console.printCommand("backup " + string3);
                bl = this.saveAJ(string3);
                if (bl) {
                    this.aladin.log("backup", "");
                }
            } else if (n == 2) {
                this.aladin.console.printCommand("save -allviews " + string3);
                final String string4 = string3;
                final int n3 = n2;
                new Thread(){

                    @Override
                    public void run() {
                        boolean bl = Save.this.saveAllViews(string4, n3);
                        if (!bl) {
                            Save.this.info("Save error !!!");
                        } else {
                            Save.this.setVisible(false);
                        }
                    }
                }.start();
                bl = true;
            } else {
                String string5;
                String string6 = n2 == 1 ? ".bmp" : (n2 == 4 ? ".jpg" : (string5 = (n2 & 8) == 8 ? ".png" : ".eps"));
                if (!(cds.tools.Util.toLower(string3).endsWith(".jpeg") && n2 == 4 || cds.tools.Util.toLower(string3).endsWith(string5))) {
                    string3 = string3 + string5;
                }
                String string7 = (n2 & 0x10) == 16 ? " -lk" : "";
                this.aladin.console.printCommand("save " + string7 + string3);
                bl = this.saveView(string3, 0, 0, n2, f);
                if (bl) {
                    this.aladin.log("save", cds.tools.Util.toUpper(string5.substring(1) + string7));
                }
            }
        }
        finally {
            Aladin.makeCursor(this, 0);
        }
        if (!bl) {
            Aladin.warning(this, CANNOT + "\n" + string3 + "\n" + CANNOT1, 1);
        } else if (n != 2) {
            this.setVisible(false);
            this.aladin.memoLastFile(string3);
        }
    }

    private static void open(File file) throws IOException {
        f = new FileOutputStream(file);
        nbuf = 0;
    }

    private static void flush() throws IOException {
        f.write(buf, 0, nbuf);
        nbuf = 0;
    }

    private static void close() throws IOException {
        Save.flush();
        f.close();
    }

    private static void append(String string) throws IOException {
        Save.append(string.toCharArray());
    }

    private static void append(char[] cArray) throws IOException {
        for (int i = 0; i < cArray.length; ++i) {
            Save.buf[Save.nbuf++] = (byte)cArray[i];
            if (nbuf != MAXBUF) continue;
            Save.flush();
        }
    }

    protected boolean saveAJ(String string) {
        string = this.aladin.getFullFileName(string);
        File file = new File(string);
        Plan[] planArray = this.aladin.calque.getPlans();
        try {
            file.delete();
            Save.open(file);
            Save.append("<?xml version = \"1.0\"?>\n<!-- This file has been produced by the Aladin Java interface," + CR + "     Please do not modify it -->" + CR + CR + "<ALADINJAVA vers=\"1.0\">" + CR);
            block10: for (int i = planArray.length - 1; i >= 0; --i) {
                Plan plan = planArray[i];
                if (!plan.isReady()) continue;
                switch (plan.type) {
                    case 12: {
                        this.appendPlanFilterXML(plan);
                        continue block10;
                    }
                    case 11: {
                        this.appendPlanFolderXML(plan);
                        continue block10;
                    }
                    case 8: {
                        this.appendPlanCatalogXML(plan);
                        continue block10;
                    }
                    case 9: {
                        this.appendPlanToolXML(plan);
                        continue block10;
                    }
                    case 1: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.appendPlanImageXML(plan);
                        continue block10;
                    }
                    case 2: {
                        this.appendPlanImageRGBXML(plan);
                    }
                }
            }
            this.aladin.view.sauvegarde();
            Save.append("  <MODEVIEW");
            Save.append(CR + "    overlays=\"" + this.aladin.calque.getOverlayList() + "\"");
            Save.append(CR + "    overlay=\"" + this.aladin.calque.flagOverlay + "\"");
            Save.append(CR + "    mode=\"" + this.aladin.view.getModeView() + "\"");
            Save.append(CR + "    position=\"" + this.aladin.view.getScrollValue() + "\">" + CR);
            for (int i = 0; i < this.aladin.view.viewMemo.size(); ++i) {
                if (this.aladin.view.viewMemo.memo[i] == null || this.aladin.view.viewMemo.memo[i].pref == null) continue;
                Save.append("    <VIEW n=\"" + i + "\"");
                this.appendView(this.aladin.view.viewMemo.memo[i]);
                Save.append(">" + CR + "    </VIEW>" + CR);
            }
            Save.append("  </MODEVIEW>" + CR);
            Save.append("</ALADINJAVA>" + CR);
            Save.close();
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.warning(this, CANNOT + "\n" + file + "\n--> " + exception, 1);
            return false;
        }
        return true;
    }

    private void appendView(ViewMemoItem viewMemoItem) {
        try {
            Save.append(CR + "       zoom=\"" + viewMemoItem.zoom + "\"");
            Save.append(CR + "       xzoomView=\"" + viewMemoItem.xzoomView + "\"");
            Save.append(CR + "       yzoomView=\"" + viewMemoItem.yzoomView + "\"");
            Save.append(CR + "       rzoomWidth=\"" + viewMemoItem.rzoomWidth + "\"");
            Save.append(CR + "       rzoomHeight=\"" + viewMemoItem.rzoomHeight + "\"");
            Save.append(CR + "       rvWidth=\"" + viewMemoItem.rvWidth + "\"");
            Save.append(CR + "       rvHeight=\"" + viewMemoItem.rvHeight + "\"");
            Save.append(CR + "       pref=\"" + viewMemoItem.pref.label + "\"");
            Save.append(CR + "       locked=\"" + viewMemoItem.locked + "\"");
            Save.append(CR + "       northUp=\"" + viewMemoItem.northUp + "\"");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void changeMocFormat() {
        boolean bl = this.jsonMocCb.isSelected();
        String string = bl ? ".txt" : ".fits";
        String string2 = bl ? ".fits" : ".txt";
        for (int i = 0; i < this.listPlan.length; ++i) {
            String string3;
            Plan plan = this.listPlan[i];
            if (plan == null || !(plan instanceof PlanMoc) || !(string3 = this.fileSavePlan[i].getText()).endsWith(string2)) continue;
            int n = string3.lastIndexOf(46);
            this.fileSavePlan[i].setText(string3.substring(0, n) + string);
        }
    }

    private void changeCatFormat() {
        String string = this.tsvCb.isSelected() ? ".txt" : (this.jsonCb != null && this.jsonCb.isSelected() ? ".json" : ".xml");
        for (int i = 0; i < this.listPlan.length; ++i) {
            Plan plan = this.listPlan[i];
            if (plan == null || !plan.isCatalog()) continue;
            String string2 = this.fileSavePlan[i].getText();
            int n = string2.lastIndexOf(".");
            if (n == -1) {
                n = string2.length();
            }
            this.fileSavePlan[i].setText(string2.substring(0, n) + string);
        }
    }

    private void changeImgFormat() {
        String string = this.fitsCb.isSelected() ? ".fits" : (this.jpgCb.isSelected() ? ".jpg" : ".png");
        for (int i = 0; i < this.listPlan.length; ++i) {
            String string2;
            Plan plan = this.listPlan[i];
            if (plan == null || !plan.isImage()) continue;
            String string3 = this.fileSavePlan[i].getText();
            int n = string3.lastIndexOf(46);
            if (n > 0 && cds.tools.Util.indexInArrayOf(string2 = string3.substring(n), EXTENSIONS, false) >= 0) {
                string3 = string3.substring(0, n);
            }
            this.fileSavePlan[i].setText(string3 + string);
        }
    }

    private void appendPlanImageRGBXML(Plan plan) throws IOException {
        this.appendXMLHeadPlan(plan);
        Save.append("    <VALUE><![CDATA[" + CR);
        this.append64(((PlanImageRGB)plan).getByteRGB());
        Save.append("]]></VALUE>" + CR + "  </PLANE>" + CR);
    }

    private void appendPlanImageXML(Plan plan) throws IOException {
        this.appendXMLHeadPlan(plan);
        Save.append("    <VALUE><![CDATA[" + CR);
        this.append64(((PlanImage)plan).getBufPixels8());
        Save.append("]]></VALUE>" + CR + "  </PLANE>" + CR);
    }

    public static int get64(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        int n4;
        char[] cArray2 = B64.toCharArray();
        int n5 = byArray.length;
        if (b642a == null) {
            b642a = new int[256];
            for (n4 = 0; n4 < b642a.length; ++n4) {
                Save.b642a[n4] = 64;
            }
            for (n4 = 0; n4 < cArray2.length; ++n4) {
                Save.b642a[cArray2[n4]] = n4;
            }
            Save.b642a[61] = 255;
        }
        int n6 = 0;
        boolean bl = false;
        int n7 = 1;
        int n8 = n2;
        while (n8 < n3) {
            int n9 = cArray[n8++];
            ++n6;
            if (bl && Aladin.levelTrace >= 3) {
                System.err.print(n9);
            }
            if (n9 == 32 || n9 == 9 || n9 == 10 || n9 == 13) {
                if (n9 != 10 && n9 != 13) continue;
                ++n7;
                n6 = 0;
                bl = false;
                continue;
            }
            if (bl) continue;
            int n10 = b642a[n9 & 0xFF];
            if ((n10 & 0x40) != 0) {
                if (n6 == 1) {
                    bl = true;
                    if (Aladin.levelTrace < 3) continue;
                    System.err.println("++++Ignore line: " + n9);
                    continue;
                }
                if (Aladin.levelTrace < 3) continue;
                System.err.println("****Bad input char (1) " + (char)n9 + " line " + n7 + ", col " + n6);
                continue;
            }
            n10 <<= 6;
            n9 = cArray[n8++] & 0xFF;
            ++n6;
            n4 = b642a[n9 & 0xFF];
            if ((n4 & 0x40) != 0) {
                if (Aladin.levelTrace >= 3) {
                    System.err.println("****Bad input char (2) " + (char)n9 + " line " + n7 + ", col " + n6);
                }
                n10 >>>= 4;
                if (n >= n5) {
                    return n;
                }
                byArray[n++] = (byte)n10;
                continue;
            }
            n10 |= n4;
            n10 <<= 6;
            n9 = cArray[n8++] & 0xFF;
            ++n6;
            n4 = b642a[n9 & 0xFF];
            if ((n4 & 0x40) != 0) {
                if (n4 != 255 && Aladin.levelTrace >= 3) {
                    System.err.println("****Bad input char (3) " + (char)n9 + " line " + n7 + ", col " + n6);
                }
                n10 >>>= 2;
                if (n >= n5) {
                    return n;
                }
                byArray[n++] = (byte)(n10 >>> 8);
                if (n >= n5) {
                    return n;
                }
                byArray[n++] = (byte)n10;
                continue;
            }
            n10 |= n4;
            n10 <<= 6;
            n9 = cArray[n8++] & 0xFF;
            ++n6;
            n4 = b642a[n9 & 0xFF];
            if ((n4 & 0x40) != 0 && n4 != 255) {
                if (Aladin.levelTrace >= 3) {
                    System.err.println("****Bad input char (4) " + (char)n9 + " line " + n7 + ", col " + n6);
                }
            } else {
                n10 |= n4;
            }
            if (n >= n5) {
                return n;
            }
            byArray[n++] = (byte)(n10 >>> 16);
            if (n >= n5) {
                return n;
            }
            byArray[n++] = (byte)(n10 >>> 8);
            if (n >= n5) {
                return n;
            }
            byArray[n++] = (byte)n10;
        }
        return n;
    }

    private void append64(byte[] byArray) throws IOException {
        char[] cArray = B64.toCharArray();
        char[] cArray2 = new char[4];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            int n3 = byArray[n++] & 0xFF;
            int n4 = n3 << 16;
            cArray2[3] = 61;
            cArray2[2] = 61;
            if (n < byArray.length) {
                n3 = byArray[n++] & 0xFF;
                n4 |= n3 << 8;
                cArray2[2] = '\u0000';
                if (n < byArray.length) {
                    n3 = byArray[n++] & 0xFF;
                    n4 |= n3;
                    cArray2[3] = '\u0000';
                }
            }
            if (cArray2[3] == '\u0000') {
                cArray2[3] = cArray[n4 & 0x3F];
            }
            n4 >>= 6;
            if (cArray2[2] == '\u0000') {
                cArray2[2] = cArray[n4 & 0x3F];
            }
            cArray2[1] = cArray[(n4 >>= 6) & 0x3F];
            cArray2[0] = cArray[(n4 >>= 6) & 0x3F];
            Save.append(cArray2);
            if ((n2 += 4) % 76 != 0) continue;
            Save.append(CR);
        }
    }

    private void appendGenericCommand(Plan plan) throws IOException {
        String string = plan.getBookmarkCode();
        if (string == null || string.length() == 0) {
            return;
        }
        this.appendXMLHeadPlan(plan);
        Save.append("    <VALUE><![CDATA[" + string + "]]></VALUE>" + CR + "  </PLANE>" + CR);
    }

    private void appendPlanCatalogXML(Plan plan) throws IOException {
        this.appendXMLHeadPlan(plan);
        this.appendPCatXML(plan.pcat);
        Save.append("  </PLANE>" + CR);
    }

    private void appendPCatXML(Pcat pcat) throws IOException {
        Legende legende = null;
        Iterator<Obj> iterator = pcat.iterator();
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (!(obj instanceof Source)) continue;
            Source source = (Source)obj;
            if (source.leg != legende) {
                if (legende != null) {
                    Save.append(this.getXMLTailTable());
                }
                Save.append(this.getXMLHeadTable(source.leg));
                legende = source.leg;
            }
            Source source2 = source;
            Save.append(source2.raj + "\t" + source2.dej + "\t" + source2.id);
            Save.append("\t" + source.info + CR);
        }
        if (pcat.hasObj()) {
            Save.append(this.getXMLTailTable());
        }
    }

    protected void appendPlanFilterXML(Plan plan) throws IOException {
        this.appendXMLHeadPlan(plan);
        Save.append("    <SCRIPT>" + CR);
        Save.append(XMLParser.XMLEncode(((PlanFilter)plan).script.replaceAll("\n", "\\\\n")) + CR);
        Save.append("    </SCRIPT>" + CR);
        Save.append("  </PLANE>" + CR);
    }

    protected void appendPlanFolderXML(Plan plan) throws IOException {
        this.appendXMLHeadPlan(plan);
        Save.append("  </PLANE>" + CR);
    }

    protected void appendPlanToolXML(Plan plan) throws IOException {
        boolean bl = false;
        this.appendXMLHeadPlan(plan);
        Save.append("    <TABLE><VALUE><![CDATA[" + CR);
        Iterator<Obj> iterator = plan.pcat.iterator();
        while (iterator.hasNext()) {
            Position position = (Position)iterator.next();
            if (position instanceof Source) {
                bl = true;
                continue;
            }
            if (position instanceof Cercle) {
                Cercle cercle = (Cercle)position;
                Save.append(this.getInstance(cercle) + "\t.\t" + cercle.o[0].raj + "\t" + cercle.o[0].dej + "\t" + cercle.o[0].x + "\t" + cercle.o[0].y + "\t" + cercle.isWithLabel() + "\t" + cercle.getSpecificAJInfo() + CR);
                Save.append(this.getInstance(cercle) + "\t+\t" + cercle.o[1].raj + "\t" + cercle.o[1].dej + "\t" + cercle.o[1].x + "\t" + cercle.o[1].y + "\t" + cercle.isWithLabel() + "\t" + cercle.getSpecificAJInfo() + CR);
                continue;
            }
            Save.append(this.getInstance(position) + "\t" + this.suite(position) + "\t" + position.raj + "\t" + position.dej + "\t" + position.x + "\t" + position.y + "\t" + position.isWithLabel() + "\t" + position.getSpecificAJInfo() + CR);
        }
        Save.append(this.getXMLTailTable());
        if (bl) {
            this.appendPCatXML(plan.pcat);
        }
        Save.append("  </PLANE>" + CR);
    }

    protected String getToolName(Obj obj) {
        return "Undefined";
    }

    protected String getXMLTailTable() {
        return "]]></VALUE></TABLE>" + CR;
    }

    protected String getXMLHeadTable(Legende legende) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    <TABLE>" + CR);
        for (int i = 0; i < legende.field.length; ++i) {
            Field field = legende.field[i];
            stringBuffer.append("      <COLUMN");
            if (field.name != null) {
                stringBuffer.append(CR + "         name=\"" + XMLParser.XMLEncode(field.name) + "\"");
            }
            if (field.description != null) {
                stringBuffer.append(CR + "         description=\"" + XMLParser.XMLEncode(field.description) + "\"");
            }
            if (field.href != null) {
                stringBuffer.append(CR + "         href=\"" + XMLParser.XMLEncode(field.href) + "\"");
            }
            if (field.gref != null) {
                stringBuffer.append(CR + "         gref=\"" + XMLParser.XMLEncode(field.gref) + "\"");
            }
            if (field.ucd != null) {
                stringBuffer.append(CR + "         ucd=\"" + XMLParser.XMLEncode(field.ucd) + "\"");
            }
            if (field.unit != null) {
                stringBuffer.append(CR + "         unit=\"" + XMLParser.XMLEncode(field.unit) + "\"");
            }
            if (field.width != null) {
                stringBuffer.append(CR + "         width=\"" + XMLParser.XMLEncode(field.width) + "\"");
            }
            if (field.nullValue != null) {
                stringBuffer.append(CR + "         nullValue=\"" + XMLParser.XMLEncode(field.nullValue) + "\"");
            }
            if (field.arraysize != null) {
                stringBuffer.append(CR + "         arraysize=\"" + XMLParser.XMLEncode(field.arraysize) + "\"");
            }
            if (field.precision != null) {
                stringBuffer.append(CR + "         precision=\"" + XMLParser.XMLEncode(field.precision) + "\"");
            }
            if (field.utype != null) {
                stringBuffer.append(CR + "         arraysize=\"" + XMLParser.XMLEncode(field.utype) + "\"");
            }
            if (field.type != null) {
                stringBuffer.append(CR + "         type=\"" + XMLParser.XMLEncode(field.type) + "\"");
            }
            if (field.datatype != null) {
                stringBuffer.append(CR + "         datatype=\"" + XMLParser.XMLEncode(field.datatype) + "\"");
            }
            if (field.refText != null) {
                stringBuffer.append(CR + "         refText=\"" + XMLParser.XMLEncode(field.refText) + "\"");
            }
            if (field.refValue != null) {
                stringBuffer.append(CR + "         refValue=\"" + XMLParser.XMLEncode(field.refValue) + "\"");
            }
            if (field.sed != 0) {
                stringBuffer.append(CR + "         sed=\"" + XMLParser.XMLEncode(field.getSEDtag()) + "\"");
            }
            stringBuffer.append("/>" + CR);
        }
        stringBuffer.append("      <VALUE><![CDATA[" + CR);
        return stringBuffer.toString();
    }

    private void appendXMLHeadPlan(Plan plan) throws IOException {
        Object object;
        Object object2;
        Save.append("  <PLANE");
        Save.append(CR + "     type=\"" + XMLParser.XMLEncode(Plan.Tp[plan.type]) + "\"");
        Save.append(CR + "     depth=\"" + plan.folder + "\"");
        Save.append(CR + "     activated=\"" + plan.active + "\"");
        if (plan.label != null) {
            Save.append(CR + "     label=\"" + XMLParser.XMLEncode(plan.label) + "\"");
        }
        if (plan.objet != null) {
            Save.append(CR + "     object=\"" + XMLParser.XMLEncode(plan.objet) + "\"");
        }
        if (plan.param != null) {
            Save.append(CR + "     param=\"" + XMLParser.XMLEncode(plan.param) + "\"");
        }
        if (plan.type == 12 && ((PlanFilter)plan).plan != null) {
            Save.append(CR + "     dedicatedto=\"" + ((PlanFilter)plan).plan.label + "\"");
        }
        if (plan.type == 11) {
            Save.append(CR + "     localscope=\"" + ((PlanFolder)plan).localScope + "\"");
        }
        if (!plan.isImage() && plan.type != 11 && plan.type != 12) {
            Save.append(CR + "     color=\"" + Action.findColorName(plan.c) + "\"");
        }
        if (plan.type == 9 && ((PlanTool)plan).isCatalog()) {
            Save.append(CR + "     withsource=\"true\"");
        }
        if (!plan.isSelectable()) {
            Save.append(CR + "     selectable=\"false\"");
        }
        if (plan.isImage()) {
            object2 = (PlanImage)plan;
            object = PlanImage.getFormat(((PlanImage)object2).fmt);
            String string = PlanImage.getResolution(((PlanImage)object2).res);
            Save.append(CR + "     fmt=\"" + XMLParser.XMLEncode((String)object) + "\"");
            Save.append(CR + "     resolution=\"" + XMLParser.XMLEncode(string) + "\"");
        }
        if (plan.copyright != null) {
            Save.append(CR + "     from=\"" + XMLParser.XMLEncode(plan.copyright) + "\"");
        }
        if (plan.u != null) {
            Save.append(CR + "     url=\"" + XMLParser.XMLEncode(plan.u + "") + "\"");
        }
        if (Projection.isOk(plan.projd)) {
            Save.append(CR + "     RA=\"" + plan.projd.raj + "\"");
            Save.append(CR + "     DE=\"" + plan.projd.dej + "\"");
            Save.append(CR + "     radius=\"" + plan.projd.rm / 2.0 + "\"");
            Save.append(CR + "     proj=\"" + plan.projd.modeCalib + "\"");
            if (Projection.isOk(plan.projd)) {
                int n;
                object2 = plan.projd.c;
                Save.append(CR + "     calib=\"" + ((Calib)object2).aladin + "," + ((Calib)object2).epoch + "," + ((Calib)object2).alpha + "," + ((Calib)object2).delta + "," + ((Calib)object2).yz + "," + ((Calib)object2).xz + "," + ((Calib)object2).focale + "," + ((Calib)object2).Xorg + "," + ((Calib)object2).Yorg + "," + ((Calib)object2).incX + "," + ((Calib)object2).incY + "," + ((Calib)object2).alphai + "," + ((Calib)object2).deltai + "," + ((Calib)object2).incA + "," + ((Calib)object2).incD + "," + ((Calib)object2).Xcen + "," + ((Calib)object2).Ycen + "," + ((Calib)object2).widtha + "," + ((Calib)object2).widthd + "," + ((Calib)object2).xnpix + "," + ((Calib)object2).ynpix + "," + ((Calib)object2).rota + "," + ((Calib)object2).cdelz + "," + ((Calib)object2).sdelz + "," + ((Calib)object2).type1 + "," + ((Calib)object2).type2 + "," + ((Calib)object2).equinox + "," + ((Calib)object2).proj + "\"");
                Save.append(CR + "     projection=\"" + Calib.getProjName(((Calib)object2).proj) + "\"");
                Save.append(CR + "     system=\"" + ((Calib)object2).system + "\"");
                Save.append(CR + "     flagepoch=\"" + ((Calib)object2).flagepoc + "\"");
                Save.append(CR + "     adxpoly=\"" + ((Calib)object2).adxpoly[0]);
                for (n = 1; n < ((Calib)object2).adxpoly.length; ++n) {
                    Save.append("," + ((Calib)object2).adxpoly[n]);
                }
                Save.append("\"");
                Save.append(CR + "     adypoly=\"" + ((Calib)object2).adypoly[0]);
                for (n = 1; n < ((Calib)object2).adypoly.length; ++n) {
                    Save.append("," + ((Calib)object2).adypoly[n]);
                }
                Save.append("\"");
                Save.append(CR + "     xyapoly=\"" + ((Calib)object2).xyapoly[0]);
                for (n = 1; n < ((Calib)object2).xyapoly.length; ++n) {
                    Save.append("," + ((Calib)object2).xyapoly[n]);
                }
                Save.append("\"");
                Save.append(CR + "     xydpoly=\"" + ((Calib)object2).xydpoly[0]);
                for (n = 1; n < ((Calib)object2).xydpoly.length; ++n) {
                    Save.append("," + ((Calib)object2).xydpoly[n]);
                }
                Save.append("\"");
                Save.append(CR + "     CD=\"" + ((Calib)object2).CD[0][0] + "," + ((Calib)object2).CD[0][1] + "," + ((Calib)object2).CD[1][0] + "," + ((Calib)object2).CD[1][1] + "\"");
                Save.append(CR + "     ID=\"" + ((Calib)object2).ID[0][0] + "," + ((Calib)object2).ID[0][1] + "," + ((Calib)object2).ID[1][0] + "," + ((Calib)object2).ID[1][1] + "\"");
            }
        }
        if (plan instanceof PlanImage) {
            object2 = (PlanImage)plan;
            Save.append(CR + "     width=\"" + ((PlanImage)object2).width + "\"");
            Save.append(CR + "     height=\"" + ((PlanImage)object2).height + "\"");
            Save.append(CR + "     video=\"" + ((PlanImage)object2).video + "\"");
            Save.append(CR + "     transfertFct=\"" + ((PlanImage)object2).transfertFct + "\"");
            Save.append(CR + "     minPix=\"" + ((PlanImage)object2).dataMin + "\"");
            Save.append(CR + "     maxPix=\"" + ((PlanImage)object2).dataMax + "\"");
            Save.append(CR + "     minPixCut=\"" + ((PlanImage)object2).pixelMin + "\"");
            Save.append(CR + "     maxPixCut=\"" + ((PlanImage)object2).pixelMax + "\"");
            Save.append(CR + "     bZero=\"" + ((PlanImage)object2).bZero + "\"");
            Save.append(CR + "     bScale=\"" + ((PlanImage)object2).bScale + "\"");
            Save.append(CR + "     cm=\"" + ((PlanImage)object2).typeCM + "\"");
            Save.append(CR + "     colormap1=\"" + ((PlanImage)object2).cmControl[0] + "\"");
            Save.append(CR + "     colormap2=\"" + ((PlanImage)object2).cmControl[1] + "\"");
            Save.append(CR + "     colormap3=\"" + ((PlanImage)object2).cmControl[2] + "\"");
            Save.append(CR + "     bitpix=\"" + ((PlanImage)object2).bitpix + "\"");
            Save.append(CR + "     opacity=\"" + ((Plan)object2).getOpacityLevel() + "\"");
            if (((PlanImage)object2).cacheID != null && ((PlanImage)object2).cacheOffset != 0L) {
                Save.append(CR + "     cacheID=\"" + XMLParser.XMLEncode(((PlanImage)object2).cacheID) + "\"");
                Save.append(CR + "     cacheOffset=\"" + ((PlanImage)object2).cacheOffset + "\"");
            }
            if (plan instanceof PlanImageRGB) {
                object = (PlanImageRGB)object2;
                for (int i = 0; i < 9; ++i) {
                    Save.append(CR + "     RGBControl" + (i + 1) + "=\"" + ((PlanImageRGB)object).RGBControl[i] + "\"");
                }
                if (((PlanImageRGB)object).planRed != null && ((PlanImageRGB)object).planRed.type != 0) {
                    Save.append(CR + "     RGBRed=\"" + ((PlanImageRGB)object).planRed.label + "\"");
                }
                if (((PlanImageRGB)object).planGreen != null && ((PlanImageRGB)object).planGreen.type != 0) {
                    Save.append(CR + "     RGBGreen=\"" + ((PlanImageRGB)object).planGreen.label + "\"");
                }
                if (((PlanImageRGB)object).planBlue != null && ((PlanImageRGB)object).planBlue.type != 0) {
                    Save.append(CR + "     RGBBlue=\"" + ((PlanImageRGB)object).planBlue.label + "\"");
                }
            }
        }
        Save.append(" >" + CR);
        if (plan.filters != null) {
            Save.append("    <FILTERS filterIndex=\"" + plan.filterIndex + "\" nFilter=\"" + plan.filters.length + "\">" + CR);
            for (int i = 0; i < plan.filters.length; ++i) {
                Save.append("       <FILTER><![CDATA[");
                Save.append(plan.filters[i] + CR);
                Save.append("]]></FILTER>" + CR);
            }
            Save.append("    </FILTERS>" + CR);
        }
        if (plan instanceof PlanImage && ((PlanImage)plan).hasFitsHeader()) {
            Save.append("    <ORIRIGINALHEADERFITS>" + CR);
            Save.append("    <![CDATA[");
            Save.append(((PlanImage)plan).headerFits.getOriginalHeaderFits());
            Save.append("]]>" + CR);
            Save.append("    </ORIRIGINALHEADERFITS>" + CR);
        }
    }

    protected boolean saveCatalog(String string, Plan plan, boolean bl, boolean bl2) {
        string = this.aladin.getFullFileName(string);
        File file = new File(string);
        boolean bl3 = bl ? this.saveCatTSV(file, plan) : this.saveCatVOTable(file, plan, bl2);
        if (bl3) {
            this.aladin.memoLastFile(string);
        }
        return bl3;
    }

    protected boolean saveCatalog(File file, Plan plan, int n) {
        if (n == 0) {
            return this.saveCatTSV(file, plan);
        }
        if (n == 1) {
            return this.saveCatJSON(file, plan);
        }
        return this.saveCatVOTable(file, plan, false);
    }

    private File nextSuffixFile(File file, int n) {
        int n2;
        String string = file.getAbsolutePath();
        int n3 = string.lastIndexOf(46);
        string = n3 >= 0 ? ((n2 = string.lastIndexOf(45, n3)) > 0 ? string.substring(0, n2) + "-" + n + string.substring(n3) : string.substring(0, n3) + "-" + n + string.substring(n3)) : string + "-" + n;
        return new File(string);
    }

    private String getInstance(Object object) {
        if (object instanceof Tag) {
            return "taglabel";
        }
        if (object instanceof Cote) {
            return "arrow";
        }
        if (object instanceof Ligne) {
            return "line";
        }
        if (object instanceof Repere) {
            return "tag";
        }
        if (object instanceof SourceStat) {
            return "phot";
        }
        if (object instanceof Source) {
            return "source";
        }
        if (object instanceof Cercle) {
            return "circle";
        }
        return "unknown";
    }

    private String suite(Obj obj) {
        if (obj instanceof Ligne) {
            if (((Ligne)obj).finligne == null) {
                return ((Ligne)obj).bout == 3 ? "*" : ".";
            }
            return "+";
        }
        return ".";
    }

    protected boolean saveToolTSV(File file, Plan plan) {
        StringBuilder stringBuilder = new StringBuilder(MAXBUF);
        Pcat pcat = plan.pcat;
        FileOutputStream fileOutputStream = null;
        try {
            stringBuilder.append("Object\tCont_Flag\tRAJ2000\tDEJ2000\tX\tY\tLabel_Flag\tInfo" + CR);
            Iterator<Obj> iterator = pcat.iterator();
            int n = pcat.getCount();
            for (int i = 0; i <= n; ++i) {
                if (i < n) {
                    Position position = (Position)iterator.next();
                    if (position instanceof Cercle) {
                        Cercle cercle = (Cercle)position;
                        stringBuilder.append(this.getInstance(cercle) + "\t.\t" + cercle.o[0].raj + "\t" + cercle.o[0].dej + "\t" + cercle.o[0].x + "\t" + cercle.o[0].y + "\t" + cercle.isWithLabel() + "\t" + cercle.getSpecificAJInfo() + CR);
                        stringBuilder.append(this.getInstance(cercle) + "\t+\t" + cercle.o[1].raj + "\t" + cercle.o[1].dej + "\t" + cercle.o[1].x + "\t" + cercle.o[1].y + "\t" + cercle.isWithLabel() + "\t" + cercle.getSpecificAJInfo() + CR);
                    } else {
                        stringBuilder.append(this.getInstance(position) + "\t" + this.suite(position) + "\t" + position.raj + "\t" + position.dej + "\t" + position.x + "\t" + position.y + "\t" + position.isWithLabel() + "\t" + position.getSpecificAJInfo() + CR);
                    }
                }
                if (stringBuilder.length() <= MAXBUF - 100 && i != n) continue;
                fileOutputStream = this.writeByteTSV(fileOutputStream, file, 0, stringBuilder);
                stringBuilder = new StringBuilder(MAXBUF);
            }
        }
        catch (Exception exception) {
            this.errorFile = this.errorFile + "\n" + file;
            return false;
        }
        this.aladin.log("export", "tool TSV");
        return true;
    }

    protected boolean saveCatTSV(File file, Plan plan) {
        StringBuilder stringBuilder = new StringBuilder(MAXBUF);
        Pcat pcat = plan.pcat;
        int n = 0;
        FileOutputStream fileOutputStream = null;
        try {
            Legende legende = ((PlanCatalog)plan).getFirstLegende();
            stringBuilder.append(this.getShortHeader(legende));
            int n2 = pcat.getCount();
            Iterator<Obj> iterator = pcat.iterator();
            for (int i = 0; i <= n2; ++i) {
                Source source = (Source)(i < n2 ? iterator.next() : null);
                if (source == null || source.leg != legende) {
                    if (i < n2) {
                        stringBuilder.append(CR);
                    }
                    fileOutputStream = this.writeByteTSV(fileOutputStream, file, n, stringBuilder);
                    if (source == null) {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    ++n;
                    if (source != null) {
                        stringBuilder = new StringBuilder(MAXBUF);
                        legende = source.leg;
                        stringBuilder.append(this.getShortHeader(legende));
                    }
                }
                if (source != null) {
                    stringBuilder.append(Save.getTSV(source) + CR);
                }
                if (stringBuilder.length() <= MAXBUF) continue;
                fileOutputStream = this.writeByteTSV(fileOutputStream, file, n, stringBuilder);
                stringBuilder = new StringBuilder(MAXBUF);
            }
        }
        catch (Exception exception) {
            this.errorFile = this.errorFile + "\n" + file;
            return false;
        }
        this.aladin.log("export", "catalog TSV");
        return true;
    }

    protected boolean saveCatJSON(File file, Plan plan) {
        StringBuilder stringBuilder = new StringBuilder(MAXBUF);
        Pcat pcat = plan.pcat;
        int n = 0;
        FileOutputStream fileOutputStream = null;
        boolean bl = true;
        try {
            stringBuilder.append("[" + CR);
            Legende legende = ((PlanCatalog)plan).getFirstLegende();
            stringBuilder.append("[");
            int n2 = pcat.getCount();
            Iterator<Obj> iterator = pcat.iterator();
            for (int i = 0; i <= n2; ++i) {
                Source source = (Source)(i < n2 ? iterator.next() : null);
                if (source == null || source.leg != legende) {
                    stringBuilder.append(CR + "]" + CR);
                    if (source == null) {
                        stringBuilder.append("]" + CR);
                    }
                    fileOutputStream = this.writeByteTSV(fileOutputStream, file, n, stringBuilder);
                    if (source == null) {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    } else {
                        bl = true;
                    }
                    ++n;
                    if (source != null) {
                        stringBuilder = new StringBuilder(MAXBUF);
                        legende = source.leg;
                        stringBuilder.append("," + CR + "[");
                    }
                }
                if (source != null) {
                    if (!bl) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(CR);
                    stringBuilder.append("   " + Save.getJSON(legende, source));
                    bl = false;
                }
                if (stringBuilder.length() <= MAXBUF) continue;
                fileOutputStream = this.writeByteTSV(fileOutputStream, file, n, stringBuilder);
                stringBuilder = new StringBuilder(MAXBUF);
            }
        }
        catch (Exception exception) {
            this.errorFile = this.errorFile + "\n" + file;
            return false;
        }
        this.aladin.log("export", "catalog JSON");
        return true;
    }

    private FileOutputStream writeByteTSV(FileOutputStream fileOutputStream, File file, int n, StringBuilder stringBuilder) throws Exception {
        if (fileOutputStream == null) {
            if (n > 0) {
                file = this.nextSuffixFile(file, n);
            }
            file.delete();
            fileOutputStream = new FileOutputStream(file);
        }
        char[] cArray = stringBuilder.toString().toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        fileOutputStream.write(byArray);
        return fileOutputStream;
    }

    protected boolean saveCatVOTable(File file, Plan plan, boolean bl) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            this.aladin.writePlaneInVOTable(plan, dataOutputStream, bl);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.errorFile = this.errorFile + "\n" + file;
            return false;
        }
        this.aladin.log("export", "catalog VOTABLE");
        return true;
    }

    protected void ImageWriter(Image image, String string, float f, boolean bl, OutputStream outputStream) throws Exception {
        try {
            if (string.equals("jpg") || string.equals("jpeg")) {
                this.writeJPEG(image, f, bl, outputStream);
            } else {
                BufferedImage bufferedImage;
                if (image instanceof BufferedImage) {
                    bufferedImage = (BufferedImage)image;
                } else {
                    bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), bl ? 1 : 10);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.drawImage(image, 0, 0, this.aladin);
                    graphics2D.dispose();
                }
                this.aladin.waitImage(bufferedImage);
                ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
            }
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            throw new Exception(ENCODER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJPEG(Image image, float f, boolean bl, OutputStream outputStream) throws Exception {
        Object object;
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), bl ? 1 : 10);
            object = bufferedImage.createGraphics();
            ((Graphics)object).drawImage(image, 0, 0, this.aladin);
            ((Graphics)object).dispose();
        }
        this.aladin.waitImage(image);
        if (f < 0.0f || f > 1.0f) {
            f = 0.95f;
        }
        object = ImageIO.getImageWritersByFormatName("jpeg").next();
        ImageWriteParam imageWriteParam = ((ImageWriter)object).getDefaultWriteParam();
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(f);
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(outputStream);
            ((ImageWriter)object).setOutput(imageOutputStream);
            ((ImageWriter)object).write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
            ((ImageWriter)object).dispose();
        }
        finally {
            if (imageOutputStream != null) {
                imageOutputStream.close();
            }
        }
    }

    protected boolean saveView(String string, int n, int n2, int n3, float f) {
        return this.saveView(string, n, n2, n3, f, 0);
    }

    protected boolean saveView(String string, int n, int n2, int n3, float f, int n4) {
        if (n4 != 0) {
            System.err.println("Presently, only the current view can be saved");
            return false;
        }
        return this.saveOneView(string, n, n2, n3, f, this.aladin.view.getCurrentView());
    }

    protected boolean saveAllViews(String string, int n) {
        boolean bl = false;
        try {
            if (string == null || string.trim().length() == 0) {
                string = "ROI";
            }
            ViewSimple viewSimple = new ViewSimple(this.aladin, this.aladin.view, 0, 0, 0);
            this.aladin.view.sauvegarde();
            ViewMemo viewMemo = this.aladin.view.viewMemo.copy();
            Rectangle rectangle = new Rectangle(0, 0, this.aladin.view.viewSimple[0].rv.width, this.aladin.view.viewSimple[0].rv.height);
            int n2 = viewMemo.size();
            for (int i = 0; i < n2; ++i) {
                if (viewMemo.get(i, viewSimple) == null || viewSimple.isFree() || !viewSimple.pref.isPixel()) continue;
                viewSimple.rv = rectangle;
                viewSimple.setSize(rectangle.width, rectangle.height);
                if (viewSimple.pref instanceof PlanBG) {
                    viewSimple.pref.projd = viewSimple.projLocal;
                }
                viewSimple.setZoomXY(viewSimple.zoom, viewSimple.xzoomView, viewSimple.yzoomView);
                viewSimple.newView(1);
                String string2 = string + cds.tools.Util.align3(i + 1) + (n == 1 ? ".bmp" : (n == 8 ? ".png" : ".jpg"));
                this.info("Saving " + (i + 1) + "/" + n2 + " " + cds.tools.Util.getShortPath(string2, 40) + "...");
                bl = this.saveOneView(string2, -1, -1, n, -1.0f, viewSimple) || bl;
            }
            viewSimple.free();
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            bl = false;
        }
        return bl;
    }

    private void info(String string) {
        this.info.setText(string + " ");
    }

    protected boolean saveOneView(String string, int n, int n2, int n3, float f, ViewSimple viewSimple) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = this.saveOneView1(string, n, n2, n3, f, viewSimple);
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block2;
                exception.printStackTrace();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveOneView1(String string, int n, int n2, int n3, float f, ViewSimple viewSimple) throws Exception {
        boolean bl = false;
        OutputStream outputStream = null;
        try {
            OutputStream outputStream2 = outputStream = string == null ? System.out : new FileOutputStream(this.aladin.getFullFileName(string));
            if ((n3 & 2) == 2) {
                this.saveEPS(viewSimple, n, n2, outputStream);
            } else {
                String string2;
                Image image = viewSimple.getImage(n, n2);
                if ((n3 & 4) == 4) {
                    string2 = this.generateFitsHeaderString(viewSimple);
                    this.ImageWriter(image, "jpg", f, true, new JpegOutputFilter(outputStream, string2));
                } else if ((n3 & 8) == 8) {
                    string2 = this.generateFitsHeaderString(viewSimple);
                    this.ImageWriter(image, "png", -1.0f, true, new PNGOutputFilter(outputStream, string2));
                } else if ((n3 & 1) == 1) {
                    BMPWriter.write(image, outputStream);
                } else {
                    throw new Exception("Unsupported output image format !");
                }
            }
            bl = true;
        }
        catch (Exception exception) {
            if (string != null) {
                System.out.println("!!! image error [" + string + "]");
            }
            System.err.println(exception.getMessage());
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
        }
        finally {
            if (outputStream != null && outputStream != System.out) {
                outputStream.close();
            }
        }
        Aladin.trace(3, "Current view saved successfully " + this.aladin.getFullFileName(string));
        if (((n3 & 0x10) == 16 || (n3 & 0x20) == 32) && string != null) {
            boolean bl2 = (n3 & 0x20) == 32;
            try {
                int n4 = string.lastIndexOf(46);
                if (n4 >= 0) {
                    string = string.substring(0, n4);
                }
                String string3 = string + (bl2 ? ".lkflex" : ".lk");
                outputStream = new FileOutputStream(this.aladin.getFullFileName(string3));
                this.linkWriter(viewSimple, outputStream, bl2);
                Projection projection = viewSimple.pref.projd;
                if (bl2) {
                    String string4 = string + ".corners";
                    FileOutputStream fileOutputStream = new FileOutputStream(this.aladin.getFullFileName(string4));
                    PrintStream printStream = new PrintStream(fileOutputStream);
                    PointD pointD = viewSimple.getPosition(0.0, 0.0);
                    Coord coord = new Coord();
                    coord.x = pointD.x;
                    coord.y = pointD.y;
                    projection.getCoord(coord);
                    pointD = viewSimple.getPosition(0.0, (double)viewSimple.rv.height);
                    Coord coord2 = new Coord();
                    coord2.x = pointD.x;
                    coord2.y = pointD.y;
                    projection.getCoord(coord2);
                    pointD = viewSimple.getPosition((double)viewSimple.rv.width, (double)viewSimple.rv.height);
                    Coord coord3 = new Coord();
                    coord3.x = pointD.x;
                    coord3.y = pointD.y;
                    projection.getCoord(coord3);
                    pointD = viewSimple.getPosition((double)viewSimple.rv.width, 0.0);
                    Coord coord4 = new Coord();
                    coord4.x = pointD.x;
                    coord4.y = pointD.y;
                    projection.getCoord(coord4);
                    printStream.print("# C0 0.0 0.0 " + coord.al + " " + coord.del + "\n");
                    printStream.print("# C1 0.0 " + viewSimple.rv.height + " " + coord2.al + " " + coord2.del + "\n");
                    printStream.print("# C2 " + viewSimple.rv.width + " " + viewSimple.rv.height + " " + coord3.al + " " + coord3.del + "\n");
                    printStream.print("# C3 " + viewSimple.rv.width + " 0.0 " + coord4.al + " " + coord4.del + "\n");
                    printStream.flush();
                    printStream.close();
                }
                Aladin.trace(3, "HTTP link file generated [" + string3 + "]");
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                if (Aladin.levelTrace >= 3) {
                    exception.printStackTrace();
                }
            }
            finally {
                outputStream.close();
            }
        }
        return bl;
    }

    protected void linkWriter(ViewSimple viewSimple, OutputStream outputStream, boolean bl) throws Exception {
        PrintStream printStream = new PrintStream(outputStream);
        printStream.print("#PLANE\tID\tX\tY\tURL\n");
        Plan[] planArray = this.aladin.calque.getPlans();
        Plan plan = this.aladin.calque.getMyScopeFolder(planArray, viewSimple.pref);
        for (int i = planArray.length - 1; i >= 0; --i) {
            Plan plan2 = planArray[i];
            if (!plan2.isSimpleCatalog() || !plan2.flagOk) continue;
            boolean bl2 = i >= viewSimple.n;
            boolean bl3 = bl2 = bl2 && this.aladin.calque.getMyScopeFolder(planArray, plan2) == plan;
            if (plan2.pcat == null || !plan2.active && !bl) continue;
            if (!bl) {
                plan2.pcat.writeLink(printStream, viewSimple, bl2);
                continue;
            }
            plan2.pcat.writeLinkFlex(printStream, viewSimple, bl2);
        }
        printStream.flush();
        printStream.close();
    }

    protected void saveEPS(ViewSimple viewSimple, int n, int n2, OutputStream outputStream) throws Exception {
        PrintStream printStream = new PrintStream(outputStream);
        EPSGraphics ePSGraphics = new EPSGraphics(printStream, "Aladin-chart", null, 0, 0, viewSimple.rv.width, viewSimple.rv.height);
        if (viewSimple.pref.active) {
            ePSGraphics.drawImage(viewSimple.getImage(n, n2, false), 0, 0, viewSimple.aladin);
        }
        if (Projection.isOk(viewSimple.getProj())) {
            viewSimple.paintOverlays(ePSGraphics, null, 0, 0, true, 2);
        }
        viewSimple.drawCredit(ePSGraphics, 0, 0);
        ePSGraphics.end();
        printStream.close();
    }

    protected boolean saveMoc(String string, PlanMoc planMoc, int n) {
        try {
            HealpixMoc healpixMoc = (HealpixMoc)planMoc.getMoc().clone();
            healpixMoc.setMinLimitOrder(0);
            healpixMoc.write(string, n);
            this.aladin.memoLastFile(string);
        }
        catch (Exception exception) {
            if (Aladin.levelTrace > 3) {
                exception.printStackTrace();
            }
            return false;
        }
        return true;
    }

    protected boolean saveImageBMP(String string, Plan plan) {
        PlanImage planImage = (PlanImage)plan;
        try {
            BMPWriter.write24BitBMP(((PlanRGBInterface)((Object)planImage)).getPixelsRGB(), planImage.width, planImage.height, new FileOutputStream(string));
        }
        catch (Exception exception) {
            System.out.println("!!! BMP image failed for \"" + string + "\"");
            System.err.println(exception + "");
            return false;
        }
        this.aladin.log("export", "BMP");
        return true;
    }

    protected boolean saveImage(String string, Plan plan, int n) {
        string = this.aladin.getFullFileName(string);
        File file = new File(string);
        boolean bl = n >= 2 ? this.saveImageColor(string, (PlanImage)plan, n) : this.saveImageFITS(file, (PlanImage)plan, n);
        if (bl) {
            this.aladin.memoLastFile(string);
        }
        return bl;
    }

    public boolean saveImageColor(String string, PlanImage planImage, int n) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            boolean bl = this.saveImageColor(fileOutputStream, planImage, n);
            if (bl) {
                this.aladin.log("export", n == 3 ? "PNG" : "JPEG");
                this.aladin.memoLastFile(string);
            }
            return bl;
        }
        catch (Exception exception) {
            System.out.println("!!! " + (n == 3 ? "PNG" : "JPEG") + " image failed");
            System.err.println(exception + "");
            return false;
        }
    }

    protected boolean saveImageColor(OutputStream outputStream, PlanImage planImage, int n) {
        try {
            MemoryImageSource memoryImageSource = planImage.type == 2 ? new MemoryImageSource(planImage.width, planImage.height, planImage.cm, ((PlanRGBInterface)((Object)planImage)).getPixelsRGB(), 0, planImage.width) : new MemoryImageSource(planImage.width, planImage.height, planImage.cm, planImage.pixels, 0, planImage.width);
            String string = "Created by Aladin";
            if (!planImage.hasNoReduction()) {
                string = this.generateFitsHeaderStringForNativeImage(planImage);
            }
            this.ImageWriter(this.getToolkit().createImage(memoryImageSource), n == 3 ? "png" : "jpg", -1.0f, planImage.type == 2, n == 3 ? new PNGOutputFilter(outputStream, string) : new JpegOutputFilter(outputStream, string));
        }
        catch (Exception exception) {
            System.out.println("!!! JPEG image failed");
            System.err.println(exception + "");
            return false;
        }
        return true;
    }

    protected boolean saveImageFITS(File file, PlanImage planImage) {
        return this.saveImageFITS(file, planImage, 0);
    }

    protected boolean saveImageFITS(File file, PlanImage planImage, int n) {
        boolean bl = false;
        try {
            if (file.exists() && !file.delete()) {
                throw new Exception("File already existing and not overwritable !");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (n == 0) {
                this.saveImageFITS(fileOutputStream, planImage);
            } else {
                this.saveImageHPX((OutputStream)fileOutputStream, planImage);
            }
            fileOutputStream.close();
            bl = true;
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            this.errorFile = this.errorFile + "\n" + file;
        }
        this.aladin.log("export", "image FITS");
        return bl;
    }

    protected String generateFitsHeaderStringForNativeImage(PlanImage planImage) {
        Vector vector = this.generateFitsHeader1(planImage.projInit, planImage.projd, planImage.headerFits, false, planImage.hasSpecificCalib(), false, false, 8, planImage.bZero, planImage.bScale, planImage.width, planImage.height);
        return this.fitsHeaderVtoStrings(vector);
    }

    protected String generateFitsHeaderString(PlanImage planImage) {
        return this.fitsHeaderVtoStrings(this.generateFitsHeader(planImage));
    }

    protected String generateFitsHeaderString(ViewSimple viewSimple) {
        return this.fitsHeaderVtoStrings(this.generateFitsHeader(viewSimple));
    }

    private String fitsHeaderVtoStrings(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer(vector.size() * 80);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = (byte[])enumeration.nextElement();
            stringBuffer.append(new String(byArray).trim());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    protected Vector generateFitsHeader(ViewSimple viewSimple) {
        Plan plan = viewSimple.pref;
        Projection projection = Projection.isOk(plan.projd) ? plan.projd.copy() : null;
        int n = (int)Math.floor(viewSimple.rzoom.x);
        int n2 = (int)Math.floor(viewSimple.rzoom.y);
        int n3 = (int)Math.ceil(viewSimple.rzoom.width);
        int n4 = (int)Math.ceil(viewSimple.rzoom.height);
        double d = viewSimple.zoom;
        if (projection != null) {
            projection.cropAndZoom(n, n2, n3, n4, d);
        }
        n3 = (int)Math.round(d * (double)n3);
        n4 = (int)Math.round(d * (double)n4);
        if (plan instanceof PlanImage) {
            PlanImage planImage = (PlanImage)plan;
            return this.generateFitsHeader1(planImage.projInit, projection, planImage.headerFits, false, true, planImage instanceof PlanImageRGB, planImage instanceof PlanImageAlgo, planImage.bitpix, planImage.bZero, planImage.bScale, n3, n4);
        }
        return this.generateFitsHeader1(plan.projInit, projection, plan.headerFits, false, true, plan instanceof PlanImageRGB, plan instanceof PlanImageAlgo, 8, 0.0, 1.0, n3, n4);
    }

    protected Vector generateFitsHeader(PlanImage planImage) {
        boolean bl = planImage.headerFits != null && planImage.headerFits.hasKey("TTYPE1");
        return this.generateFitsHeader1(planImage.projInit, planImage.projd, bl ? null : planImage.headerFits, planImage.hasOriginalPixels(), planImage.hasSpecificCalib(), planImage instanceof PlanImageRGB, planImage instanceof PlanImageAlgo, planImage.bitpix, planImage.bZero, planImage.bScale, planImage.width, planImage.height);
    }

    private Vector generateFitsHeader1(Projection projection, Projection projection2, FrameHeaderFits frameHeaderFits, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, double d, double d2, int n2, int n3) {
        Object object;
        Object object2;
        boolean bl5;
        Vector<byte[]> vector = new Vector<byte[]>(100);
        Vector vector2 = null;
        Vector vector3 = null;
        Hashtable<String, String> hashtable = null;
        boolean bl6 = frameHeaderFits != null;
        boolean bl7 = bl3 && bl6 && frameHeaderFits.hasKey("NAXIS3");
        boolean bl8 = bl3 && bl6 && frameHeaderFits.hasKey("CTYPE3");
        boolean bl9 = bl6 && frameHeaderFits.hasKey("BITPIX");
        boolean bl10 = bl5 = bl6 && frameHeaderFits.hasKey("NAXIS");
        if (bl2) {
            vector2 = new Vector(20);
            vector3 = new Vector(20);
            try {
                projection2.getWCS(vector2, vector3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            hashtable = new Hashtable<String, String>(30);
            if (projection != null) {
                Projection projection3 = projection;
                String[] stringArray = projection3.c.getWCSKeys();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i].trim();
                    if (string.equals("NAXIS1") || string.equals("NAXIS2") || string.equals("EPOCH")) continue;
                    hashtable.put(string, "");
                }
            }
            hashtable.put("END", "");
        }
        if (!bl6) {
            vector.addElement(Save.getFitsLine("SIMPLE", "T", "Generated by Aladin (CDS)"));
            vector.addElement(Save.getFitsLine("BITPIX", (n == 0 ? 8 : n) + "", "Bits per pixel"));
            if (bl3) {
                vector.addElement(Save.getFitsLine("NAXIS", "3", "Number of dimensions"));
                vector.addElement(Save.getFitsLine("NAXIS1", "" + n2, "Length of x axis"));
                vector.addElement(Save.getFitsLine("NAXIS2", "" + n3, "Length of y axis"));
                vector.addElement(Save.getFitsLine("NAXIS3", "3", "Number of colors"));
            } else {
                vector.addElement(Save.getFitsLine("NAXIS", "2", "Number of dimensions"));
                vector.addElement(Save.getFitsLine("NAXIS1", "" + n2, "Length of x axis"));
                vector.addElement(Save.getFitsLine("NAXIS2", "" + n3, "Length of y axis"));
            }
        } else {
            String string;
            Object object3;
            int n4 = 2;
            try {
                n4 = frameHeaderFits.getIntFromHeader("NAXIS");
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl11 = false;
            object2 = new Hashtable<String, String>(100);
            object = new StringTokenizer(frameHeaderFits.getOriginalHeaderFits(), "\n");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2;
                object3 = ((StringTokenizer)object).nextToken();
                if (((String)object3).trim().length() == 0) {
                    vector.addElement(Save.getFitsLineBlank());
                    continue;
                }
                string = HeaderFits.getKey((String)object3);
                if (string != null) {
                    if (string.equals("COMMENT")) {
                        string2 = ((String)object3).substring(7).trim();
                        if (bl2 && string2.equals(BYALADIN)) continue;
                        vector.addElement(Save.getFitsLineComment(string2));
                        continue;
                    }
                    if (string.equals("HISTORY")) {
                        vector.addElement(Save.getFitsLineHistory(((String)object3).substring(7).trim()));
                        continue;
                    }
                    ((Hashtable)object2).put(string, "");
                    if (string.equals("END")) continue;
                    if (string.equals("XTENSION")) {
                        vector.addElement(Save.getFitsLine("SIMPLE", "T", "Generated by Aladin (CDS)"));
                        continue;
                    }
                    if (!(!string.equals("SIMPLE") || bl9 && bl5)) {
                        vector.addElement(Save.getFitsLine("SIMPLE", "T", "Generated by Aladin (CDS)"));
                        if (!bl9) {
                            vector.addElement(Save.getFitsLine("BITPIX", (n == 0 ? 8 : n) + "", "Bits per pixel"));
                        }
                        if (bl5) continue;
                        vector.addElement(Save.getFitsLine("NAXIS", "2", ""));
                        continue;
                    }
                    if (!bl3 && string.equals("CTYPE3") && frameHeaderFits.getStringFromHeader(string).equals("RGB")) continue;
                    if (!bl || bl3) {
                        if (string.equals("SIMPLE")) {
                            vector.addElement(Save.getFitsLine("SIMPLE", "T", "Generated by Aladin (CDS)"));
                            continue;
                        }
                        if (string.equals("BITPIX")) {
                            vector.addElement(Save.getFitsLine("BITPIX", "8", "Bits per pixel"));
                            continue;
                        }
                    }
                    if (bl4) {
                        if (string.equals("BZERO")) {
                            vector.addElement(Save.getFitsLine("BZERO", d + "", "Generated by Aladin (CDS)"));
                            continue;
                        }
                        if (string.equals("BSCALE")) {
                            vector.addElement(Save.getFitsLine("BSCALE", d2 + "", "Generated by Aladin (CDS)"));
                            continue;
                        }
                        if (string.equals("BITPIX")) {
                            vector.addElement(Save.getFitsLine("BITPIX", n + "", "Bits per pixel"));
                            continue;
                        }
                    }
                    if (string.equals("EXTEND")) {
                        bl11 = true;
                        continue;
                    }
                    if (bl3 && n4 != 3 && string.equals("NAXIS")) {
                        bl11 = true;
                        vector.addElement(Save.getFitsLine("NAXIS", "3", ""));
                        continue;
                    }
                    if (bl2) {
                        if (string.equals("NAXIS1") && n2 != frameHeaderFits.getIntFromHeader(string)) {
                            vector.addElement(Save.getFitsLine("NAXIS1", n2 + "", "Length of x axis"));
                            bl11 = true;
                            continue;
                        }
                        if (string.equals("NAXIS2") && n3 != frameHeaderFits.getIntFromHeader(string)) {
                            vector.addElement(Save.getFitsLine("NAXIS2", n3 + "", "Length of y axis"));
                            bl11 = true;
                            continue;
                        }
                        if (bl2 && hashtable.get(string) != null) continue;
                    }
                    if (!(!bl3 || bl7 && bl8)) {
                        if (!bl7 && string.equals("NAXIS2")) {
                            vector.addElement(this.getFullFitsLine((String)object3));
                            vector.addElement(Save.getFitsLine("NAXIS3", "3", "Number of colors"));
                            bl11 = true;
                            continue;
                        }
                        if (!bl8 && string.equals("CTYPE2")) {
                            vector.addElement(this.getFullFitsLine((String)object3));
                            vector.addElement(Save.getFitsLine("CTYPE3", "RGB", "Red Green Blue planes"));
                            bl11 = true;
                            bl8 = true;
                            continue;
                        }
                    }
                }
                string2 = HeaderFits.getValue((String)object3);
                String string3 = (String)frameHeaderFits.getHeaderFits().getHashHeader().get(string);
                if (string3 == null) continue;
                if (Tok.unQuote(string3).trim().equals(string2)) {
                    vector.addElement(this.getFullFitsLine((String)object3));
                    continue;
                }
                vector.addElement(Save.getFitsLine(string, string3, "Aladin modif"));
            }
            if (bl6) {
                object3 = frameHeaderFits.getHeaderFits().getHashHeader().keys();
                while (object3.hasMoreElements()) {
                    string = (String)object3.nextElement();
                    if (((Hashtable)object2).get(string) != null) continue;
                    vector.addElement(Save.getFitsLine(string, (String)frameHeaderFits.getHeaderFits().getHashHeader().get(string), "Aladin add"));
                }
            }
            if (bl11) {
                vector.addElement(Save.getFitsLineComment("Generated by Aladin (CDS)"));
            }
        }
        if (bl2) {
            vector.addElement(Save.getFitsLineComment(BYALADIN));
            Enumeration enumeration = vector2.elements();
            Enumeration enumeration2 = vector3.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = (String)enumeration2.nextElement();
                if (((String)object2).trim().equals("NAXIS1") || ((String)object2).trim().equals("NAXIS2") || ((String)object2).trim().equals("NAXIS3")) continue;
                vector.addElement(Save.getFitsLine((String)object2, (String)object, ""));
                if (!bl3 || bl8 || !((String)object2).trim().equals("CTYPE2")) continue;
                vector.addElement(Save.getFitsLine("CTYPE3", "RGB", "Red Green Blue planes"));
                bl8 = true;
            }
        }
        if (bl3 && !bl8) {
            vector.addElement(Save.getFitsLine("CTYPE3", "RGB", "Red Green Blue planes"));
        }
        return vector;
    }

    protected InputStream saveImageFITS(OutputStream outputStream, PlanImage planImage) throws Exception {
        byte[] byArray;
        OutputStream outputStream2;
        MyByteArrayStream myByteArrayStream = null;
        int n = 0;
        if (outputStream != null) {
            outputStream2 = outputStream;
        } else {
            myByteArrayStream = new MyByteArrayStream(10000);
            outputStream2 = myByteArrayStream;
        }
        boolean bl = planImage.hasOriginalPixels();
        boolean bl2 = planImage.hasFitsHeader();
        boolean bl3 = planImage.hasSpecificCalib();
        boolean bl4 = planImage instanceof PlanImageRGB;
        Aladin.trace(3, "Export " + planImage.label + " (orig. Fits header:" + bl2 + ", orig. pixels:" + bl + ", specif.calib:" + bl3 + ", RGB:" + bl4 + ")");
        Vector vector = this.generateFitsHeader(planImage);
        n = Save.writeFitsLines(outputStream2, vector, n);
        byte[] byArray2 = Save.getEndBourrage(n);
        outputStream2.write(byArray2);
        n += byArray2.length;
        if (bl4) {
            n = 0;
            PlanImageRGB planImageRGB = (PlanImageRGB)planImage;
            int n2 = planImageRGB.width * planImageRGB.height;
            byte[] byArray3 = new byte[n2];
            for (int i = 0; i < 3; ++i) {
                planImageRGB.getColor(byArray3, i);
                PlanImageRGB.invImageLine(planImageRGB.width, planImageRGB.height, byArray3);
                outputStream2.write(byArray3);
                n += n2;
            }
        } else {
            byArray = bl ? planImage.getFitsPixels() : planImage.getFits8Pixels();
            outputStream2.write(byArray);
            n = byArray.length;
        }
        if (n % 2880 != 0) {
            int n3 = 2880 - n % 2880;
            byArray = new byte[n3];
            outputStream2.write(byArray);
        }
        if (myByteArrayStream == null) {
            return null;
        }
        return myByteArrayStream.getInputStream();
    }

    public static Vector generateHealpixHDU0(boolean bl) {
        Vector<byte[]> vector = new Vector<byte[]>(100);
        vector.addElement(Save.getFitsLine("SIMPLE", "T", "conforms to FITS standard"));
        vector.addElement(Save.getFitsLine("BITPIX", "8", "array data type"));
        vector.addElement(Save.getFitsLine("NAXIS", "0", "number of array dimensions"));
        vector.addElement(Save.getFitsLine("EXTEND", "T", null));
        if (bl) {
            vector.addElement(Save.getFitsLine("COLORMOD", "ARGB", null));
        }
        return vector;
    }

    public static Vector generateHealpixHDU1(int n, int n2, boolean bl, int n3, int n4) {
        Vector<byte[]> vector = new Vector<byte[]>(100);
        long l = CDSHealpix.pow2(n);
        long l2 = 12L * l * l;
        int n5 = Math.abs(n2) / 8;
        n3 = 1;
        String string = n2 == 8 ? "XX" : (n2 == 16 ? "I" : (n2 == 32 ? "J" : (n2 == -32 ? "E" : "D")));
        vector.addElement(Save.getFitsLine("XTENSION", "BINTABLE", "binary table extension"));
        vector.addElement(Save.getFitsLine("BITPIX", "8", "array data type"));
        vector.addElement(Save.getFitsLine("NAXIS", "2", "2-dimensional binary table"));
        vector.addElement(Save.getFitsLine("NAXIS1", n3 * n5 + "", "width of table"));
        vector.addElement(Save.getFitsLine("NAXIS2", l2 / (long)n3 + "", "number of rows in table"));
        vector.addElement(Save.getFitsLine("PCOUNT", "0", "number of group parameters"));
        vector.addElement(Save.getFitsLine("GCOUNT", "1", "number of groups"));
        vector.addElement(Save.getFitsLine("TFIELDS", "1", "number of table fields"));
        vector.addElement(Save.getFitsLine("TTYPE1", "PIXVAL", "label for field   1"));
        vector.addElement(Save.getFitsLine("TFORM1", n3 + string, "data format of field"));
        vector.addElement(Save.getFitsLine("PIXTYPE", "HEALPIX", "Pixel algorithm"));
        vector.addElement(Save.getFitsLine("ORDERING", bl ? "RING" : "NESTED", "Ordering scheme"));
        vector.addElement(Save.getFitsLine("NSIDE", l + "", "Resolution parameter"));
        vector.addElement(Save.getFitsLine("FIRSTPIX", "0", "First pixel (0 based)"));
        vector.addElement(Save.getFitsLine("LASTPIX", l2 - 1L + "", "Last pixel (0 based)"));
        if (n4 != 3) {
            vector.addElement(Save.getFitsLine("COORDSYS", n4 == 2 ? "E" : (n4 == 3 ? "G" : "C"), "Coordinate system"));
        }
        return vector;
    }

    public static int writeFitsLines(OutputStream outputStream, Vector vector, int n) throws Exception {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = (byte[])enumeration.nextElement();
            outputStream.write(byArray);
            n += byArray.length;
        }
        return n;
    }

    protected InputStream saveImageHPX(OutputStream outputStream, PlanBG planBG) throws Exception {
        MyByteArrayStream myByteArrayStream = null;
        int n = 0;
        try {
            OutputStream outputStream2;
            if (outputStream != null) {
                outputStream2 = outputStream;
            } else {
                myByteArrayStream = new MyByteArrayStream(10000);
                outputStream2 = myByteArrayStream;
            }
            int n2 = 9;
            int n3 = Util.nside(n2);
            int n4 = n2 + 3;
            int n5 = planBG.bitpix;
            int n6 = Math.abs(n5) / 8;
            long l = CDSHealpix.pow2(n4);
            long l2 = 768L;
            boolean bl = false;
            int n7 = 1024;
            Aladin.trace(3, "Export " + planBG.label + "\" in healpix NSIDE=" + l + " [" + (bl ? "RING" : "NESTED") + "] bitpix=" + n5);
            Vector vector = Save.generateHealpixHDU0(false);
            n = Save.writeFitsLines(outputStream2, vector, n);
            byte[] byArray = Save.getEndBourrage(n);
            outputStream2.write(byArray);
            n += byArray.length;
            vector = Save.generateHealpixHDU1(n4, n5, bl, n7, planBG.getFrameOrigin());
            n = Save.writeFitsLines(outputStream2, vector, n);
            byArray = Save.getEndBourrage(n);
            outputStream2.write(byArray);
            n += byArray.length;
            Projection projection = planBG.projd;
            Coord coord = new Coord();
            byte[] byArray2 = new byte[n7 * n6];
            int n8 = 0;
            int n9 = n3 * n3;
            this.nan = new byte[n9 * n6];
            for (int i = 0; i < n9; ++i) {
                PlanImage.setPixVal(this.nan, n5, i, Double.NaN);
            }
            int[] nArray = Util.createHpx2xy(n2);
            int n10 = 0;
            while ((long)n10 < l2) {
                boolean bl2 = true;
                String string = Util.getFilePath(planBG.url, n4 - n2, (long)n10);
                Fits fits = new Fits();
                try {
                    fits.loadFITS(string + ".fits");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    bl2 = false;
                }
                if (!bl2) {
                    outputStream2.write(byArray2, 0, n8);
                    n += n8;
                    n8 = 0;
                    outputStream2.write(this.nan);
                    n8 = 0;
                    n += this.nan.length;
                    planBG.pourcent = 100.0 * (double)n10 / (double)l2;
                } else {
                    for (int i = 0; i < n9; ++i) {
                        int n11 = nArray[i];
                        int n12 = n11 / n3;
                        int n13 = n11 - n12 * n3;
                        double d = fits.getPixelDouble(n13, n12);
                        PlanImage.setPixVal(byArray2, n5, n8++, d);
                        if (n8 != n7) continue;
                        outputStream2.write(byArray2);
                        n8 = 0;
                        n += byArray2.length;
                        planBG.pourcent = 100.0 * (double)n10 / (double)l2;
                    }
                }
                ++n10;
            }
            if (n8 > 0) {
                outputStream2.write(byArray2, 0, n8);
                n += n8;
            }
            if (n % 2880 != 0) {
                n10 = 2880 - n % 2880;
                byte[] byArray3 = new byte[n10];
                outputStream2.write(byArray3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        planBG.pourcent = -1.0;
        planBG.setLockCacheFree(false);
        if (myByteArrayStream == null) {
            return null;
        }
        return myByteArrayStream.getInputStream();
    }

    protected InputStream saveImageHPX(OutputStream outputStream, PlanImage planImage) throws Exception {
        if (planImage instanceof PlanBG) {
            return this.saveImageHPX(outputStream, (PlanBG)planImage);
        }
        MyByteArrayStream myByteArrayStream = null;
        int n = 0;
        boolean bl = planImage instanceof PlanImageRGB;
        try {
            OutputStream outputStream2;
            if (outputStream != null) {
                outputStream2 = outputStream;
            } else {
                myByteArrayStream = new MyByteArrayStream(10000);
                outputStream2 = myByteArrayStream;
            }
            int n2 = 10;
            int n3 = bl ? 32 : (planImage.bitpix == 8 ? 16 : planImage.bitpix);
            int n4 = Math.abs(n3) / 8;
            long l = CDSHealpix.pow2(n2);
            long l2 = 12L * l * l;
            boolean bl2 = false;
            int n5 = 1024;
            Aladin.trace(3, "Export " + planImage.label + "\" in healpix NSIDE=" + l + " [" + (bl2 ? "RING" : "NESTED") + "] bitpix=" + n3 + (bl ? " ARGB" : ""));
            Vector vector = Save.generateHealpixHDU0(bl);
            n = Save.writeFitsLines(outputStream2, vector, n);
            byte[] byArray = Save.getEndBourrage(n);
            outputStream2.write(byArray);
            n += byArray.length;
            vector = Save.generateHealpixHDU1(n2, n3, bl2, n5, 0);
            n = Save.writeFitsLines(outputStream2, vector, n);
            byArray = Save.getEndBourrage(n);
            outputStream2.write(byArray);
            n += byArray.length;
            Projection projection = planImage.projd;
            Coord coord = new Coord();
            byte[] byArray2 = new byte[n5 * n4];
            int n6 = 0;
            planImage.pourcent = 1.0;
            planImage.setLockCacheFree(true);
            planImage.pixelsOriginFromCache();
            for (long i = 0L; i < l2; ++i) {
                double[] dArray = CDSHealpix.pix2ang_nest(l, i);
                double[] dArray2 = CDSHealpix.polarToRadec(dArray);
                coord.al = dArray2[0];
                coord.del = dArray2[1];
                coord = Localisation.frameToFrame(coord, planImage.projd.frame, 0);
                projection.getXY(coord);
                if (!bl) {
                    double d = Double.isNaN(coord.x) || coord.x < -1.0 || coord.x > (double)(planImage.width + 1) || coord.y < -1.0 || coord.y > (double)(planImage.height + 1) ? Double.NaN : planImage.getPixelInDouble((int)coord.x, (int)coord.y);
                    PlanImage.setPixVal(byArray2, n3, n6++, d);
                } else {
                    int n7 = Double.isNaN(coord.x) || coord.x < 0.0 || coord.x > (double)planImage.width || coord.y < 0.0 || coord.y > (double)planImage.height ? 0 : planImage.getPixel8((int)coord.x, (int)coord.y);
                    PlanImage.setInt(byArray2, n6 * 4, n7);
                    ++n6;
                }
                if (n6 != n5) continue;
                outputStream2.write(byArray2);
                n6 = 0;
                n += byArray2.length;
                planImage.pourcent = 100.0 * (double)i / (double)l2;
            }
            if (n6 > 0) {
                outputStream2.write(byArray2, 0, n6);
                n += n6;
            }
            if (n % 2880 != 0) {
                int n8 = 2880 - n % 2880;
                byte[] byArray3 = new byte[n8];
                outputStream2.write(byArray3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        planImage.pourcent = -1.0;
        planImage.setLockCacheFree(false);
        if (myByteArrayStream == null) {
            return null;
        }
        return myByteArrayStream.getInputStream();
    }

    public static byte[] getFitsLineBlank() {
        byte[] byArray = new byte[80];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 32;
        }
        return byArray;
    }

    public static byte[] getFitsLineComment(String string) {
        return Save.getFitsLine("COMMENT", null, string);
    }

    public static byte[] getFitsLineHistory(String string) {
        return Save.getFitsLine("HISTORY", null, string);
    }

    private static char[] formatFitsString(char[] cArray) {
        int n;
        if (cArray.length == 0) {
            return cArray;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = cArray[0] == '\'';
        stringBuffer.append('\'');
        for (n = bl ? 1 : 0; n < cArray.length - (bl ? 1 : 0); ++n) {
            if (!bl && cArray[n] == '\'') {
                stringBuffer.append('\'');
            }
            stringBuffer.append(cArray[n]);
        }
        while (n < (bl ? 9 : 8)) {
            stringBuffer.append(' ');
            ++n;
        }
        stringBuffer.append('\'');
        return stringBuffer.toString().toCharArray();
    }

    private static boolean isFitsString(String string) {
        if (string.length() == 0) {
            return true;
        }
        char c = string.charAt(0);
        if (string.length() == 1 && (c == 'T' || c == 'F')) {
            return false;
        }
        if (!Character.isDigit(c) && c != '.' && c != '-' && c != '+') {
            return true;
        }
        try {
            Double.valueOf(string);
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static byte[] getEndBourrage(int n) {
        int n2 = 2880 - n % 2880;
        if (n2 < 3) {
            n2 += 2880;
        }
        byte[] byArray = new byte[n2];
        byArray[0] = 69;
        byArray[1] = 78;
        byArray[2] = 68;
        for (int i = 3; i < byArray.length; ++i) {
            byArray[i] = 32;
        }
        return byArray;
    }

    public static byte[] getFitsLine(String string, String string2, String string3) {
        int n;
        byte[] byArray = new byte[80];
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (n = 0; n < 8; ++n) {
            byArray[n] = (byte)(n2 < cArray.length ? cArray[n2] : 32);
            ++n2;
        }
        if (string2 != null) {
            byArray[n++] = 61;
            byArray[n++] = 32;
            cArray = string2.toCharArray();
            if (!Save.isFitsString(string2)) {
                for (n2 = 0; n2 < 20 - cArray.length; ++n2) {
                    byArray[n++] = 32;
                }
                for (n2 = 0; n < 80 && n2 < cArray.length; ++n2, ++n) {
                    byArray[n] = (byte)cArray[n2];
                }
            } else {
                cArray = Save.formatFitsString(cArray);
                for (n2 = 0; n < 80 && n2 < cArray.length; ++n2, ++n) {
                    byArray[n] = (byte)cArray[n2];
                }
                while (n < 30) {
                    byArray[n++] = 32;
                }
            }
        }
        if (string3 != null && string3.length() > 0 && n < 77) {
            if (string2 != null) {
                byArray[n++] = 32;
                byArray[n++] = 47;
                byArray[n++] = 32;
            }
            cArray = string3.toCharArray();
            for (n2 = 0; n < 80 && n2 < cArray.length; ++n2, ++n) {
                byArray[n] = (byte)cArray[n2];
            }
        }
        while (n < 80) {
            byArray[n++] = 32;
        }
        return byArray;
    }

    protected byte[] getFullFitsLine(String string) {
        int n;
        byte[] byArray = new byte[80];
        char[] cArray = string.toCharArray();
        for (n = 0; n < cArray.length && n < 80; ++n) {
            byArray[n] = (byte)cArray[n];
        }
        while (n < 80) {
            byArray[n++] = 32;
        }
        return byArray;
    }

    protected static String getTSV(Source source) {
        return Save.getSourceInfo(source, "\t");
    }

    protected static String getInfo(Source source) {
        return Save.getSourceInfo(source, " / ");
    }

    protected static String getSourceInfo(Source source, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(source.info, "\t");
        stringTokenizer.nextElement();
        while (stringTokenizer.hasMoreTokens()) {
            Words words = new Words(stringTokenizer.nextToken());
            if (stringBuilder.length() != 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(words.getText());
        }
        return stringBuilder.toString();
    }

    protected static String getJSON(Legende legende, Source source) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        stringBuilder.append("{ ");
        String[] stringArray = source.getValues();
        for (int i = 0; i < legende.field.length; ++i) {
            Field field = legende.field[i];
            if (!field.visible) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("\"" + cds.tools.Util.escapeJSON(field.name) + "\": \"" + cds.tools.Util.escapeJSON(stringArray[i]) + "\"");
            bl = false;
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    protected String getShortHeader(Legende legende) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < legende.field.length; ++n) {
            if (n > 0) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(legende.field[n].name);
        }
        stringBuffer.append(CR);
        for (n = 0; n < legende.field.length; ++n) {
            int n2;
            if (n > 0) {
                stringBuffer.append("\t");
            }
            try {
                n2 = Integer.parseInt(legende.field[n].width);
            }
            catch (Exception exception) {
                n2 = 0;
            }
            if (n2 == 0) {
                n2 = 10;
            }
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append("-");
            }
        }
        stringBuffer.append(CR);
        return stringBuffer.toString();
    }

    @Override
    public boolean action(Event event, Object object) {
        if (CHOICE[0].equals(object)) {
            this.saveFile(1, Save.getCodedFormat(this.format.getSelectedIndex()), -1.0f);
        } else if (CHOICE[2].equals(object)) {
            this.saveFile(0);
        } else if (CHOICE[1].equals(object)) {
            this.exportPlans();
        } else if (Aladin.BETA && CHOICE[3].equals(object)) {
            this.saveFile(2, Save.getCodedFormat(this.format1.getSelectedIndex()), -1.0f);
        } else if (event.target instanceof Checkbox && this.tsvCb != null) {
            this.changeCatFormat();
        } else if (event.target instanceof Checkbox && this.fitsCb != null) {
            this.changeImgFormat();
        } else if (event.target instanceof Checkbox && this.fitsMocCb != null) {
            this.changeMocFormat();
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JRadioButton) {
            if (this.tsvCb != null) {
                this.changeCatFormat();
            }
            if (this.fitsCb != null) {
                this.changeImgFormat();
            }
            if (this.fitsMocCb != null) {
                this.changeMocFormat();
            }
        }
    }

    @Override
    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.hide();
        }
        return super.handleEvent(event);
    }

    static {
        MAXBUF = 8192;
        buf = new byte[MAXBUF];
        nbuf = 0;
        EXTENSIONS = new String[]{".png", ".jpg", ".jpeg", ".fits", ".fit"};
        B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        b642a = null;
    }

    class PNGOutputFilter
    extends OutputStream {
        OutputStream out;
        byte[] comment;
        boolean writeComment = false;
        CRC32 crc = new CRC32();
        private final byte[] buf = new byte[8];
        private int mode = 0;
        private int offset = 0;
        private int sizeHeader = 0;
        private int header = 0;

        PNGOutputFilter(OutputStream outputStream, String string) {
            this.out = outputStream;
            int n = string.length();
            this.comment = new byte[n + 12];
            for (int i = 0; i < "tEXtComment".length(); ++i) {
                this.comment[i] = (byte)"tEXtComment".charAt(i);
            }
            this.comment[11] = 0;
            System.arraycopy(string.getBytes(), 0, this.comment, 12, n);
        }

        private void insertComment() throws IOException {
            int n = this.comment.length - 4;
            this.buf[0] = (byte)(n >> 24 & 0xFF);
            this.buf[1] = (byte)(n >> 16 & 0xFF);
            this.buf[2] = (byte)(n >> 8 & 0xFF);
            this.buf[3] = (byte)(n & 0xFF);
            this.out.write(this.buf, 0, 4);
            this.out.write(this.comment, 0, this.comment.length);
            this.crc.reset();
            this.crc.update(this.comment);
            long l = this.crc.getValue();
            this.buf[0] = (byte)(l >> 24 & 0xFFL);
            this.buf[1] = (byte)(l >> 16 & 0xFFL);
            this.buf[2] = (byte)(l >> 8 & 0xFFL);
            this.buf[3] = (byte)(l & 0xFFL);
            this.out.write(this.buf, 0, 4);
        }

        private int endOfHeader(byte[] byArray, int n, int n2) {
            int n3 = 0;
            while (n3 < n2) {
                switch (this.mode) {
                    case 0: {
                        if (this.offset != 7) break;
                        this.mode = 1;
                        break;
                    }
                    case 1: {
                        this.sizeHeader = this.sizeHeader << 8 | byArray[n + n3] & 0xFF;
                        if (this.offset != 11) break;
                        this.mode = 2;
                        break;
                    }
                    case 2: {
                        ++this.header;
                        if (this.header != this.sizeHeader + 8) break;
                        return n3 + 1;
                    }
                }
                ++n3;
                ++this.offset;
            }
            return -1;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (!this.writeComment) {
                int n3 = this.endOfHeader(byArray, n, n2);
                if (n3 >= 0) {
                    this.out.write(byArray, n, n3);
                    this.insertComment();
                    this.out.write(byArray, n + n3, n2 - n3);
                    this.writeComment = true;
                } else {
                    this.out.write(byArray, n, n2);
                }
            } else {
                this.out.write(byArray, n, n2);
            }
        }

        @Override
        public void write(int n) throws IOException {
            this.buf[0] = (byte)(n >> 24 & 0xFF);
            this.buf[1] = (byte)(n >> 16 & 0xFF);
            this.buf[2] = (byte)(n >> 8 & 0xFF);
            this.buf[3] = (byte)(n & 0xFF);
            this.write(this.buf, 0, 4);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    class JpegOutputFilter
    extends OutputStream {
        OutputStream out;
        String comment;
        boolean first;
        private final byte[] buf = new byte[4];

        JpegOutputFilter(OutputStream outputStream, String string) {
            this.out = outputStream;
            this.comment = string;
            this.first = true;
        }

        private void insertComment() throws IOException {
            this.buf[0] = -1;
            this.buf[1] = -2;
            int n = this.comment.length();
            this.buf[2] = (byte)(n + 2 >> 8 & 0xFF);
            this.buf[3] = (byte)(n + 2 & 0xFF);
            this.out.write(this.buf, 0, 4);
            this.out.write(this.comment.getBytes(), 0, n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.first && n2 < 2) {
                this.first = false;
            }
            if (this.first) {
                this.out.write(byArray, n, 2);
                this.insertComment();
                this.first = false;
                if (n2 - 2 > 0) {
                    this.out.write(byArray, n + 2, n2 - 2);
                }
            } else {
                this.out.write(byArray, n, n2);
            }
        }

        @Override
        public void write(int n) throws IOException {
            this.buf[0] = (byte)(n >> 24 & 0xFF);
            this.buf[1] = (byte)(n >> 16 & 0xFF);
            this.buf[2] = (byte)(n >> 8 & 0xFF);
            this.buf[3] = (byte)(n & 0xFF);
            this.write(this.buf, 0, 4);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.out.close();
        }
    }
}

