/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MetaDataTree;
import cds.aladin.Plan;
import cds.aladin.RobotAction;
import cds.aladin.Server;
import cds.aladin.ServerDialog;
import cds.aladin.TranslationScript;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ScriptFactory {
    private Hashtable scripts = new Hashtable();
    private String[] args;
    private static String[] defaultScripts = new String[]{"PUSH toolbox.contour\nPAUSE toolbox.contour 2000\nADJUSTPOS frameContour\nPUSH frameContour.nbLevelsChoice\n SELECT frameContour.nbLevelsChoice $$1\nPUSH frameContour.submitBtn", "PUSH toolbox.filter\nPAUSE toolbox.filter 2000\nADJUSTPOS lastFilterCreated\nTYPE lastFilterCreated.label $$1\nTYPE lastFilterCreated.filterDef $$2\nPUSH lastFilterCreated.applyBtn\nTOFRONT f", "PUSH searchdata\nPAUSE searchdata 2000\nPUSH dialog.local\nTYPE dialog.localServer.file $$2\nPUSH dialog.submit\nTOFRONT f", "PUSH toolbox.rgb\nPAUSE toolbox.rgb 2000\nADJUSTPOS frameRGB\nPUSH frameRGB.cR\nSELECT frameRGB.cR $$1\nPUSH frameRGB.cG\nSELECT frameRGB.cG $$2\nPUSH frameRGB.cB\nSELECT frameRGB.cB $$3\nPUSH frameRGB.submitBtn\nTOFRONT f", "PUSH searchData\nPAUSE searchData 2000\nADJUSTPOS dialog\nPUSH dialog.$$1\nPAUSE dialog 2000\nTYPE dialog.curServer.target $$2\nPUSH dialog.submit\nTOFRONT f", "PUSH searchData\nPAUSE searchData 2000\nADJUSTPOS dialog\nPUSH dialog.aladin\nPAUSE dialog 2000\nTYPE dialog.curServer.target $$2\nPUSH dialog.submit\nPAUSE searchData 9000\nPUSH dialog.curServer.tree.$$3\nPUSH dialog.submit\nTOFRONT f", "PUSH searchData\nPAUSE searchData 2000\nADJUSTPOS dialog\nPUSH dialog.vizier\nPAUSE dialog 2000\nTYPE dialog.vizierServer.target $$2\nTYPE dialog.vizierServer.catalog $$3\nPUSH dialog.submit\nTOFRONT f", "INFO f $$1", "PUSH calque.select.$$1", "PUSH calque.select.ref$$1"};
    private static String[] defaultScriptsLabels = new String[]{"contour", "filter", "getlocal", "rgb", "getsimbadned", "getaladin", "getvizier", "info", "show", "ref"};

    public ScriptFactory() {
        this.addDefaultScripts();
    }

    public TranslationScript getScript(String string, String string2) {
        this.args = new String[3];
        String[] stringArray = ScriptFactory.split(string2, " ");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || i >= this.args.length) continue;
            this.args[i] = stringArray[i];
        }
        if (string.equals("get")) {
            return this.processGet(string, string2);
        }
        if (string.equals("filter")) {
            return this.processFilter(string, string2);
        }
        if (string.equals("rgb")) {
            return this.processRGB(string, string2);
        }
        if (string.equals("info")) {
            return this.processInfo(string, string2);
        }
        if (string.equals("hide") || string.equals("show")) {
            return this.processShow(string, string2);
        }
        TranslationScript translationScript = this.getScriptWithArgs(string);
        if (translationScript == null) {
            return null;
        }
        return translationScript;
    }

    public void addScript(TranslationScript translationScript) {
        this.scripts.put(translationScript.cmdName, translationScript);
    }

    private void addDefaultScripts() {
        for (int i = 0; i < defaultScripts.length; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(defaultScripts[i], "\n");
            Vector<RobotAction> vector = new Vector<RobotAction>();
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string, " ");
                String string2 = stringTokenizer2.nextToken();
                RobotAction robotAction = RobotAction.getActionFromString(string2);
                String string3 = stringTokenizer2.nextToken();
                String string4 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : null;
                vector.addElement(new RobotAction(robotAction, string3, string4));
            }
            Object[] objectArray = new RobotAction[vector.size()];
            vector.copyInto(objectArray);
            this.addScript(new TranslationScript(defaultScriptsLabels[i], (RobotAction[])objectArray));
        }
    }

    private TranslationScript processInfo(String string, String string2) {
        this.args[0] = string2;
        return this.getScriptWithArgs(string);
    }

    private TranslationScript processShow(String string, String string2) {
        boolean bl;
        Plan plan = Aladin.aladin.command.getNumber(string2, 1, false, false);
        if (plan == null) {
            return null;
        }
        boolean bl2 = bl = string.equals("show") && plan.active || string.equals("hide") && !plan.active;
        if (bl) {
            return null;
        }
        return this.getScriptWithArgs("show");
    }

    private TranslationScript processFilter(String string, String string2) {
        if (string2.length() < 7) {
            return null;
        }
        string2 = string2.trim().substring(6);
        int n = string2.indexOf(123);
        int n2 = string2.lastIndexOf(125);
        if (n < 0 || n2 < 0) {
            return null;
        }
        this.args[0] = string2.substring(0, n).trim();
        this.args[1] = string2.substring(n + 1, n2);
        return this.getScriptWithArgs(string);
    }

    private TranslationScript processRGB(String string, String string2) {
        string2 = string2.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        try {
            this.args[0] = this.getRGBLabel(Aladin.aladin.calque.plan[this.getNumber(stringTokenizer.nextToken(), 0)]);
            this.args[1] = this.getRGBLabel(Aladin.aladin.calque.plan[this.getNumber(stringTokenizer.nextToken(), 0)]);
            this.args[2] = this.getRGBLabel(Aladin.aladin.calque.plan[this.getNumber(stringTokenizer.nextToken(), 0)]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return this.getScriptWithArgs(string);
    }

    private TranslationScript processGet(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        if (!Aladin.aladin.command.splitGetCmd(stringBuffer, stringBuffer2, stringBuffer3, string2, true)) {
            return null;
        }
        String string3 = stringBuffer2.toString();
        String string4 = stringBuffer3.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), ",");
        Vector<RobotAction> vector = new Vector<RobotAction>();
        while (stringTokenizer.hasMoreTokens()) {
            TranslationScript translationScript = this.getScriptForServer(stringTokenizer.nextToken(), string3, string4);
            if (translationScript == null) {
                return null;
            }
            for (int i = 0; i < translationScript.actions.length; ++i) {
                vector.addElement(translationScript.actions[i]);
            }
        }
        Object[] objectArray = new RobotAction[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        return new TranslationScript("get", (RobotAction[])objectArray);
    }

    TranslationScript getScriptForServer(String string, String string2, String string3) {
        int n = string.indexOf(40);
        String string4 = string;
        String string5 = "";
        if (n >= 0) {
            string4 = string.substring(0, n);
            int n2 = string.lastIndexOf(41);
            if (n2 > 0) {
                string5 = string.substring(n + 1, n2);
            }
        }
        this.args[0] = string4 = string4.trim().toLowerCase();
        if (string4.equalsIgnoreCase("local") || string4.equalsIgnoreCase("mydata") || string4.equalsIgnoreCase("file")) {
            this.args[1] = string5;
            return this.getScriptWithArgs("getlocal");
        }
        if (string4.equals("aladin")) {
            this.args[1] = string2;
            this.args[2] = string5.length() > 0 ? string5 : "DSS";
            TranslationScript translationScript = this.getScriptWithArgs("getaladin");
            Server server = Aladin.aladin.dialog.server[ServerDialog.ALADIN];
            Aladin.aladin.dialog.setDefaultParameters(Aladin.aladin.dialog.current, 0);
            if (server.tree != null && !server.tree.isEmpty() && server.target.getText().equals(string2)) {
                for (int i = 5; i <= 7; ++i) {
                    translationScript.actions[i] = null;
                }
            }
            return translationScript;
        }
        if (string4.equals("simbad") || string4.equals("ned")) {
            this.args[1] = string2;
            return this.getScriptWithArgs("getsimbadned");
        }
        if (string4.equals("vizier")) {
            this.args[1] = string2;
            this.args[2] = string5.length() > 0 ? string5 : "GSC2";
            return this.getScriptWithArgs("getvizier");
        }
        return null;
    }

    private TranslationScript getScriptWithArgs(String string) {
        TranslationScript translationScript = (TranslationScript)this.scripts.get(string);
        if (translationScript == null) {
            return null;
        }
        RobotAction[] robotActionArray = new RobotAction[translationScript.actions.length];
        for (int i = 0; i < translationScript.actions.length; ++i) {
            RobotAction robotAction = translationScript.actions[i];
            robotActionArray[i] = new RobotAction(robotAction.getAction(), this.setArgs(robotAction.getComp()), this.setArgs(robotAction.getParam()));
        }
        return new TranslationScript(string, robotActionArray);
    }

    private String setArgs(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = new String(string);
        while ((n = string2.indexOf("$$")) >= 0) {
            int n2 = n + 3;
            int n3 = Integer.parseInt(string2.substring(n + 2, n2));
            if (this.args[n3 - 1] == null) {
                this.args[n3 - 1] = "null";
            }
            string2 = MetaDataTree.replace(string2, "$$" + n3, ScriptFactory.encode(this.args[n3 - 1]), -1);
        }
        return string2;
    }

    protected static String encode(String string) {
        return MetaDataTree.replace(string, ".", "@@", -1);
    }

    protected static String decode(String string) {
        return MetaDataTree.replace(string, "@@", ".", -1);
    }

    protected static String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    private int getNumber(String string, int n) {
        int n2 = 0;
        Aladin aladin = Aladin.aladin;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 < 1 || n2 > aladin.calque.plan.length) {
            if (n == 1) {
                n2 = aladin.calque.getIndexPlan(string);
                if (n2 < 0) {
                    System.out.println("!!! Plane \"" + string + "\" not found !");
                    return -1;
                }
                return n2;
            }
            System.out.println("!!! Error on plane number " + string);
            return -1;
        }
        n2 = aladin.calque.plan.length - n2;
        if (aladin.calque.plan[n2].type == 0) {
            System.out.println("!!! plane number " + string + " not assigned");
            return -1;
        }
        return n2;
    }

    private String getRGBLabel(Plan plan) {
        return plan.label + " - \"" + plan.objet + "\"";
    }
}

