/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Obj;
import cds.aladin.ViewSimple;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Segment {
    static final int NOLABEL = 0;
    static final int GAUCHE = 1;
    static final int HAUT = 2;
    static final int MILIEURA = 3;
    static final int MILIEUDE = 4;
    static final int ISOUNKNOWN = 0;
    static final int ISORA = 1;
    static final int ISODE = 2;
    protected double al1;
    protected double del1;
    protected double al2;
    protected double del2;
    protected int iso = 0;
    protected int x1;
    protected int y1;
    protected int x2;
    protected int y2;
    protected String label = null;
    protected int labelMode = 0;
    protected boolean horsChamp;
    private Rectangle clip = null;
    private Coord c = new Coord();
    static final int BETA = (int)(1.0 / Math.tan(0.08726646259971647));
    private static boolean col;

    protected Segment createNextSegment() {
        Segment segment = new Segment();
        segment.del1 = segment.del2 = this.del2;
        segment.al1 = segment.al2 = this.al2;
        segment.x1 = segment.x2 = this.x2;
        segment.y1 = segment.y2 = this.y2;
        return segment;
    }

    protected Segment copy(boolean bl) {
        Segment segment = new Segment();
        segment.al1 = this.al1;
        segment.al2 = this.al2;
        segment.del1 = this.del1;
        segment.del2 = this.del2;
        segment.x1 = this.x1;
        segment.x2 = this.x2;
        segment.y1 = this.y1;
        segment.y2 = this.y2;
        segment.iso = this.iso;
        segment.clip = this.clip;
        if (bl) {
            segment.labelMode = this.labelMode;
            segment.label = this.label;
        }
        return segment;
    }

    protected Segment[] subdivise(ViewSimple viewSimple) throws Exception {
        Segment[] segmentArray = new Segment[]{this.copy(true), this.copy(false)};
        double d = (this.al2 + this.al1 - (double)(Math.abs(this.al2 - this.al1) > 180.0 ? 360 : 0)) / 2.0;
        double d2 = (this.del2 + this.del1) / 2.0;
        segmentArray[0].al2 = segmentArray[1].al1 = d;
        segmentArray[0].del2 = segmentArray[1].del1 = d2;
        Point point = this.getXY(viewSimple, d, d2);
        if (point == null) {
            point = new Point(-1, -1);
        }
        segmentArray[0].x2 = segmentArray[1].x1 = point.x;
        segmentArray[0].y2 = segmentArray[1].y1 = point.y;
        return segmentArray;
    }

    private Point getXY(ViewSimple viewSimple, double d, double d2) {
        this.c.al = d;
        this.c.del = d2;
        this.c = viewSimple.aladin.localisation.frameToICRS(this.c);
        viewSimple.getProj().getXY(this.c);
        this.clip = null;
        if (Double.isNaN(this.c.x)) {
            return null;
        }
        return viewSimple.getViewCoord(this.c.x, this.c.y);
    }

    protected boolean projection(ViewSimple viewSimple) {
        Point point = this.getXY(viewSimple, this.al2, this.del2);
        if (point == null) {
            return false;
        }
        this.x2 = point.x;
        this.y2 = point.y;
        return true;
    }

    protected static boolean courbe(Segment segment, Segment segment2) {
        double d = segment.x2 - segment.x1;
        double d2 = segment2.y2 - segment2.y1;
        double d3 = segment2.x2 - segment2.x1;
        double d4 = segment.y2 - segment.y1;
        return Math.abs(d * d2 - d3 * d4) > 1.0 + Math.abs(d * d3 + d4 * d2) / (double)BETA;
    }

    protected double distXY() {
        return Math.sqrt((this.x2 - this.x1) * (this.x2 - this.x1) + (this.y2 - this.y1) * (this.y2 - this.y1));
    }

    protected boolean inClip(Rectangle rectangle) {
        if (rectangle == null) {
            return true;
        }
        return Obj.intersectRect(rectangle, Math.min(this.x1, this.x2) - 2, Math.min(this.y1, this.y2) - 2, Math.abs(this.x2 - this.x1) + 4, Math.abs(this.y2 - this.y1) + 4);
    }

    protected void draw(Graphics graphics, ViewSimple viewSimple, Rectangle rectangle, int n, int n2, int n3) {
        if (this.label == null && !this.inClip(rectangle)) {
            return;
        }
        graphics.drawLine(this.x1 + n2, this.y1 + n3, this.x2 + n2, this.y2 + n3);
        if (this.label == null) {
            return;
        }
        Color color = graphics.getColor();
        if (this.labelMode == 3 || this.labelMode == 1) {
            graphics.setColor(viewSimple.view.gridColorDEC);
        } else {
            graphics.setColor(viewSimple.view.gridColorRA);
        }
        if (this.labelMode == 3) {
            graphics.drawString(this.label, (this.x1 + this.x2) / 2 + n2, this.y1 + n3 - 5);
        } else if (this.labelMode == 4) {
            graphics.drawString(this.label, this.x1 - 30 + n2, (this.y1 + this.y2) / 2 + n3 - 2);
        } else if (this.labelMode == 1 && this.y2 > 30) {
            graphics.drawString(this.label, 5 + n2, (this.y1 + this.y2) / 2 + n3 - 2);
        } else if (this.labelMode == 2) {
            graphics.drawString(this.label, (this.x1 + this.x2) / 2 + n2, 25 + n3);
        }
        graphics.setColor(color);
    }
}

