/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Ball;
import cds.aladin.Coord;
import cds.aladin.Export;
import cds.aladin.FrameInfoServer;
import cds.aladin.MetaDataTree;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyInputStream;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.Projection;
import cds.aladin.Tok;
import cds.aladin.View;
import cds.tools.Astrodate;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class Server
extends JPanel
implements ActionListener,
KeyListener,
Comparator {
    static final int IMAGE = 1;
    static final int CATALOG = 2;
    static final int SPECTRUM = 4;
    static final int APPLI = 8;
    static final int APPLIIMG = 16;
    static final int STATUS_OK = 0;
    static final int STATUS_NORESULT = 1;
    static final int STATUS_ERROR = 2;
    static final int STATUS_QUERYING = 3;
    static final int STATUS_ABORT = 4;
    static int WIDTH = Aladin.OUTREACH ? 430 : 500;
    static int HEIGHT = Aladin.OUTREACH ? 300 : 400;
    static final int YOUTREACH = 60;
    static final int MAXSELECTEDPLANE = 10;
    protected String TARGET;
    protected String RAD;
    protected String GRABIT = "";
    protected String DEFAULT_METHODE;
    protected String TARGET_EX;
    protected String RADIUS_EX;
    protected String WNEEDOBJ;
    protected String WNEEDRAD;
    protected String WNEEDDATE;
    protected String WNEEDCAT;
    protected String WERROR;
    protected String WTOOLARGE;
    protected String WERRORDATE;
    protected String WDEJA;
    protected String HASFILTER1;
    protected String HASFILTER2;
    protected String NOINPUTITEM;
    protected String WNEEDCHECK;
    protected String UNKNOWNOBJ;
    protected String NOTTOOMANY;
    static final int XTAB1 = 10;
    static final int XTAB2 = 160;
    static final int XWIDTH = WIDTH - 10;
    String ordre = "X";
    MetaDataTree tree = null;
    JTextArea tap = null;
    static boolean message = true;
    JTextField target = null;
    JTextField radius;
    protected boolean DISCOVERY = false;
    protected boolean TESTSERVER = false;
    protected boolean HIDDEN = false;
    protected static final int MAXINPUT = 10;
    protected JTextField[] coo;
    protected JTextField[] rad;
    protected JTextField date;
    protected JComponent[] input;
    protected int nbInput = 0;
    protected JLabel targetLabel = null;
    protected int modeDate = 0;
    protected int modeRad = 0;
    protected int modeCoo = 0;
    protected int[] modeInput;
    static final int NOMODE = 0;
    static final int COO = 1;
    static final int COOb = 2;
    static final int SIMBAD = 4;
    static final int NED = 8;
    static final int RADEC = 16;
    static final int RADEd = 32;
    static final int RADEb = 64;
    static final int RADE6 = 128;
    static final int COOd = 256;
    static final int RADIUS = 1;
    static final int RADSQR = 2;
    static final int RADBOX = 4;
    static final int RADIUSd = 8;
    static final int RADIUSs = 16;
    static final int RADSQRd = 32;
    static final int RADBOXd = 64;
    static final int RADSQRs = 128;
    static final int RADBOXs = 256;
    static final int JD = 1;
    static final int MJD = 2;
    static final int YEARd = 4;
    static final int IMG = 1;
    static final int IMGs = 2;
    static final int CAT = 4;
    static final int CATs = 8;
    static final int ALLIMG = 16;
    static int ORDRE = 0;
    int type;
    protected double aladinMenuNumber = 0.0;
    protected String title;
    protected String aladinLabel = "";
    protected String description;
    protected String verboseDescr;
    protected String institute;
    protected String aladinLogo;
    protected String docUser = null;
    JToggleButton grab = null;
    String aladinMenu = null;
    boolean flagVerif = true;
    boolean flagToFront = true;
    protected String[] filters;
    JComboBox filtersChoice = null;
    private Component maxComp = null;
    protected JCheckBox cbAllVO = null;
    protected boolean filterAllVO = true;
    protected JLabel statusAllVO;
    protected JButton statusReport = null;
    protected String statusUrl = null;
    protected String statusError = null;
    protected Ball ball;
    public Aladin aladin;
    protected static int HAUT = 25;
    protected static int MARGE = 1;
    protected JCheckBox testServer = null;
    protected final int NOPICK = 1;
    protected final int NORADIUS = 2;
    protected final int NOTARGET = 4;
    protected final int FORVIZIER = 8;
    protected final int FORALADIN = 16;
    boolean initDone;
    private boolean maximizeInYOnly = false;
    private static String EXERGUE = ">>> ";

    protected String getTitle() {
        return this.aladinLabel;
    }

    protected String getOrigin() {
        return this.institute;
    }

    protected String getType() {
        return this.type == 1 ? "Image" : (this.type == 2 ? "Catalog" : (this.type == 4 ? "Spectra" : ""));
    }

    protected MyInputStream getMetaData(String string, String string2, StringBuffer stringBuffer) throws Exception {
        return null;
    }

    protected boolean isHidden() {
        return this.HIDDEN;
    }

    protected boolean isDiscovery() {
        return this.DISCOVERY;
    }

    protected boolean isAllVOChecked() {
        if (!this.filterAllVO) {
            return false;
        }
        if (this.cbAllVO == null) {
            return true;
        }
        return this.cbAllVO.isSelected();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getSize() {
        return new Dimension(WIDTH, HEIGHT);
    }

    protected void createChaine() {
        this.TARGET = Aladin.chaine.getString("TARGET");
        this.TARGET_EX = Aladin.chaine.getString("TARGET_EX");
        this.RAD = Aladin.chaine.getString("RADIUS");
        this.RADIUS_EX = Aladin.chaine.getString("RADIUS_EX");
        this.GRABIT = Aladin.chaine.getString("GRABIT");
        this.WNEEDCHECK = Aladin.chaine.getString("WNEEDCHECK");
        this.WNEEDOBJ = Aladin.chaine.getString("WNEEDOBJ");
        this.WNEEDDATE = Aladin.chaine.getString("WNEEDDATE");
        this.WNEEDRAD = Aladin.chaine.getString("WNEEDRAD");
        this.WNEEDCAT = Aladin.chaine.getString("WNEEDCAT");
        this.WERROR = Aladin.chaine.getString("WERROR");
        this.WTOOLARGE = Aladin.chaine.getString("WTOOLARGE");
        this.WERRORDATE = Aladin.chaine.getString("WERRORDATE");
        this.WDEJA = Aladin.chaine.getString("WDEJA");
        this.HASFILTER1 = Aladin.chaine.getString("HASFILTER1");
        this.HASFILTER2 = Aladin.chaine.getString("HASFILTER2");
        this.NOINPUTITEM = Aladin.chaine.getString("NOINPUTITEM");
        this.UNKNOWNOBJ = Aladin.chaine.getString("UNKNOWNOBJ");
        this.NOTTOOMANY = Aladin.chaine.getString("NOTTOOMANY");
        this.statusAllVO = new JLabel(" ");
    }

    protected void resumeTargetLabel() {
        if (this.targetLabel == null) {
            return;
        }
        String string = this.TARGET;
        try {
            String string2 = this.aladin.localisation.getFrameName();
            if (string2.length() > 0) {
                string = string + " (" + string2 + ", name)";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.targetLabel.setText(this.addDot(string));
    }

    protected boolean updateMetaData(MyInputStream myInputStream, Server server, String string, String string2, boolean bl) {
        boolean bl2 = bl ? this.aladin.treeView.appendToTree(myInputStream, this.tree, server, string, string2) : this.aladin.treeView.updateTree(myInputStream, this.tree, server, string, string2);
        this.aladin.setButtonMode();
        if (!this.aladin.dialog.isVisible()) {
            this.aladin.dialog.show();
        }
        return bl2;
    }

    protected boolean updateMetaData(MyInputStream myInputStream, Server server, String string, String string2) {
        return this.updateMetaData(myInputStream, server, string, string2, false);
    }

    protected void setStatusAllVO(int n, String string) {
        if (this.statusAllVO == null) {
            return;
        }
        this.statusAllVO.setText(n == 0 ? "Ok    " : (n == 1 ? "No result    " : (n == 3 ? "Querying...    " : (n == 2 ? "Error    " : (n == 4 ? "Abort    " : "-")))));
        this.statusAllVO.setForeground(n == 0 ? Aladin.GREEN : (n == 2 ? Color.red : (n == 1 ? Color.blue : Color.black)));
        this.statusAllVO.setFont(Aladin.BOLD);
        this.statusUrl = string;
    }

    protected MyInputStream getMetaDataForCat(URL uRL) {
        try {
            Plan plan = new Plan();
            Pcat pcat = new Pcat(plan, null, this.aladin.calque, null, this.aladin);
            int n = pcat.setPlanCat(plan, uRL, false);
            if (n <= 0) {
                return null;
            }
            MyByteArrayStream myByteArrayStream = null;
            MyByteArrayStream myByteArrayStream2 = myByteArrayStream = new MyByteArrayStream(10000);
            Aladin.writeBytes(myByteArrayStream2, "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE VOTABLE SYSTEM \"http://us-vo.org/xml/VOTable.dtd\"><VOTABLE version=\"v1.0\"><RESOURCE type=\"results\">   <INFO name=\"QUERY_STATUS\" value=\"OK\"/>   <TABLE><FIELD name=\"Resource\" datatype=\"char\" ucd=\"VOX:Image_Title\" arraysize=\"*\"/><FIELD name=\"Origin\" datatype=\"char\"/><FIELD name=\"url\" datatype=\"char\" ucd=\"VOX:Image_AccessReference\" arraysize=\"*\"/><FIELD ID=\"FORMAT\" datatype=\"char\" arraysize=\"*\"/><DATA><TABLEDATA>   <TR>      <TD>" + this.aladinLabel + ": " + n + " object" + (n > 1 ? "s" : "") + "</TD>      <TD>" + this.institute + "</TD>      <TD><![CDATA[" + uRL + "]]></TD>      <TD>CATALOG</TD>   </TR></TABLEDATA></DATA></TABLE></RESOURCE></VOTABLE>");
            return new MyInputStream(myByteArrayStream.getInputStream());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String sesameIfRequired(String string, String string2) throws Exception {
        Coord coord = !View.notCoord(string) ? new Coord(string) : this.aladin.view.sesame(string);
        return coord == null ? null : coord.getSexa(string2);
    }

    protected String resolveTarget(String string) throws Exception {
        string = this.aladin.localisation.getICRSCoord(string);
        if (this.coo != null) {
            if ((this.modeCoo & 4) != 0) {
                this.coo[0].setText(string);
                return string;
            }
            Coord coord = null;
            coord = !View.notCoord(string) ? new Coord(string) : this.aladin.view.sesame(string);
            if (coord == null) {
                return null;
            }
            if ((this.modeCoo & 1) != 0) {
                this.coo[0].setText(coord.getSexa(":"));
            } else if ((this.modeCoo & 2) != 0) {
                this.coo[0].setText(coord.getSexa(" "));
            } else if ((this.modeCoo & 0x100) != 0) {
                this.coo[0].setText(coord.al + " " + (coord.del >= 0.0 ? "+" : "") + coord.del);
            } else if ((this.modeCoo & 0x10) != 0) {
                this.coo[0].setText(coord.getRA());
                this.coo[1].setText(coord.getDE());
            } else if ((this.modeCoo & 0x80) != 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(coord.getRA(), ":");
                this.coo[0].setText(stringTokenizer.nextToken());
                this.coo[1].setText(stringTokenizer.nextToken());
                this.coo[2].setText(stringTokenizer.nextToken());
                stringTokenizer = new StringTokenizer(coord.getDE(), ":");
                this.coo[3].setText(stringTokenizer.nextToken());
                this.coo[4].setText(stringTokenizer.nextToken());
                this.coo[5].setText(stringTokenizer.nextToken());
            } else if ((this.modeCoo & 0x40) != 0) {
                this.coo[0].setText(coord.getRA(' '));
                this.coo[1].setText(coord.getDE(' '));
                System.out.println("c.getSexa=" + coord.getSexa() + " coo[0]= " + coord.getRA(' ') + " coo[1]=" + coord.getDE(' '));
            } else if ((this.modeCoo & 0x20) != 0) {
                this.coo[0].setText(coord.al + "");
                this.coo[1].setText(coord.del + "");
            }
            return coord.getSexa(":");
        }
        return string;
    }

    protected void resolveRadius(String string, boolean bl) {
        double d = Server.getRM(string);
        double d2 = Server.getWM(string);
        double d3 = Server.getHM(string);
        double d4 = Math.max(d2, d3);
        if (this.rad != null) {
            if ((this.modeRad & 4) != 0) {
                this.rad[0].setText(d2 + "");
                this.rad[1].setText(d3 + "");
            } else if ((this.modeRad & 0x40) != 0) {
                this.rad[0].setText(d2 / 60.0 + "");
                this.rad[1].setText(d3 / 60.0 + "");
            } else if ((this.modeRad & 0x100) != 0) {
                this.rad[0].setText(d2 * 60.0 + "");
                this.rad[1].setText(d3 * 60.0 + "");
            } else if ((this.modeRad & 2) != 0) {
                this.rad[0].setText(d4 + "");
            } else if ((this.modeRad & 0x20) != 0) {
                this.rad[0].setText(d4 / 60.0 + "");
            } else if ((this.modeRad & 0x80) != 0) {
                this.rad[0].setText(d4 * 60.0 + "");
            } else if ((this.modeRad & 1) != 0) {
                this.rad[0].setText(d + "");
            } else if ((this.modeRad & 8) != 0) {
                this.rad[0].setText(d / 60.0 + "");
            } else if ((this.modeRad & 0x10) != 0) {
                this.rad[0].setText(d * 60.0 + "");
            }
        }
        if (bl && this.modeRad != 0) {
            try {
                String string2 = Coord.getUnit(d / 60.0);
                this.radius.setText(string2);
                this.radius.setCaretPosition(Math.min(this.radius.getCaretPosition(), string2.length()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void resolveDate(String string) {
        this.setDate(string == null ? "" : string);
    }

    protected void waitCursor() {
        this.ball.setMode(4);
        this.makeCursor(1);
    }

    protected void defaultCursor() {
        this.ball.setMode(1);
        this.makeCursor(0);
    }

    protected void makeCursor(int n) {
        Aladin.makeCursor(this.aladin.dialog, n);
        Aladin.makeCursor(this.aladin, n);
        if (this.coo != null) {
            Aladin.makeCursor(this.coo[0], n);
            if (this.coo.length > 1) {
                Aladin.makeCursor(this.coo[1], n);
            }
        }
        if (this.rad != null) {
            Aladin.makeCursor(this.rad[0], n);
        }
        if (this.tree != null) {
            Aladin.makeCursor(this.tree, n);
        }
    }

    protected int stringSize(JLabel jLabel) {
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        int n = fontMetrics.stringWidth(jLabel.getText());
        return n + 60;
    }

    protected Dimension makeTitle(JPanel jPanel, String string) {
        jPanel.setLayout(new FlowLayout(1));
        this.ball = new Ball();
        jPanel.add(this.ball);
        JLabel jLabel = new JLabel(string.replace('\n', ' '));
        jLabel.setFont(Aladin.LBOLD);
        jPanel.add(jLabel);
        JButton jButton = new JButton(new ImageIcon(Aladin.aladin.getImagette("Help.gif")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Server.this.showStatusReport();
            }
        });
        Insets insets = jButton.getMargin();
        jButton.setMargin(new Insets(insets.top, 3, insets.bottom, 3));
        jButton.setOpaque(false);
        jButton.addActionListener(this);
        jPanel.add(jButton);
        int n = this.stringSize(jLabel) + 20;
        if (this.TESTSERVER) {
            this.testServer = new JCheckBox("test", true);
            this.testServer.setMargin(new Insets(insets.top, 10, insets.bottom, 3));
            this.testServer.setOpaque(false);
            this.testServer.setSelected(false);
            jPanel.add(this.testServer);
            n += 120;
        }
        return new Dimension(n, HAUT + 5);
    }

    protected String addDot(String string) {
        return string;
    }

    protected int makeTargetPanel(JPanel jPanel, int n) {
        Object object;
        JLabel jLabel;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 75;
        boolean bl = (n & 1) == 0;
        boolean bl2 = (n & 8) != 0;
        boolean bl3 = (n & 2) != 0;
        boolean bl4 = (n & 4) != 0;
        jPanel.setLayout(null);
        if (!bl4) {
            n2 = 150;
            if (bl2) {
                n2 = 100;
            }
            this.targetLabel = jLabel = new JLabel("");
            this.resumeTargetLabel();
            jLabel.setFont(Aladin.BOLD);
            jLabel.setBounds(10, n4, n2, HAUT);
            jPanel.add(jLabel);
            this.target = new JTextField(40);
            this.target.addKeyListener(this);
            this.target.addActionListener(this);
            n3 = 160;
            n2 = XWIDTH - 160;
            if (bl2) {
                n2 = XWIDTH - 180 - 30;
                n3 = 100;
            }
            if (bl) {
                n2 -= n5;
            }
            this.target.setBounds(n3, n4, n2, HAUT);
            jPanel.add(this.target);
            Util.toolTip(jLabel, this.TARGET_EX);
            Util.toolTip(this.target, this.TARGET_EX);
            if (bl) {
                this.grab = new JToggleButton(this.GRABIT);
                object = this.grab.getMargin();
                this.grab.setMargin(new Insets(((Insets)object).top, 2, ((Insets)object).bottom, 2));
                this.grab.setOpaque(false);
                this.grab.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Server.this.aladin.dialog.startGrabIt();
                    }
                });
                this.grab.setFont(Aladin.SBOLD);
                this.grab.setEnabled(false);
                this.grab.setBounds(n3 + n2 + 3, n4 + 2, n5 - 2, HAUT - 4);
                jPanel.add(this.grab);
            }
            n4 += HAUT + MARGE;
        }
        if (bl3 || bl2) {
            return n4;
        }
        n3 = 0;
        n2 = 55;
        object = this.RAD;
        if ((n & 0x10) != 0) {
            object = "Search cone";
        }
        jLabel = new JLabel(this.addDot((String)object));
        jLabel.setFont(Aladin.BOLD);
        jLabel.setBounds(10, n4, 150, HAUT);
        n3 += n2 + 5;
        jPanel.add(jLabel);
        this.radius = new JTextField(50);
        this.radius.addKeyListener(this);
        this.radius.addActionListener(this);
        n2 = XWIDTH - 160;
        if (bl) {
            n2 -= n5;
        }
        this.radius.setBounds(160, n4, n2, HAUT);
        jPanel.add(this.radius);
        Util.toolTip(jLabel, this.RADIUS_EX);
        Util.toolTip(this.radius, this.RADIUS_EX);
        return (n4 += HAUT + MARGE) + 3;
    }

    protected void setInitialFocus() {
        if (this.target != null && this.isVisible()) {
            this.target.requestFocusInWindow();
            this.target.setCaretPosition(this.target.getText().length());
        }
    }

    protected void initServer() {
        if (this.initDone) {
            return;
        }
        if (this.tree != null) {
            this.tree.traverseTree();
            this.repaint();
        }
        this.initDone = true;
    }

    protected void setMaxComp(Component component) {
        this.maxComp = component;
    }

    protected void setMaxComp(Component component, boolean bl) {
        this.maximizeInYOnly = bl;
        this.setMaxComp(component);
    }

    private synchronized void maximizeComp() {
        int n;
        int n2;
        if (this.maxComp == null || this.getBounds().height < 100) {
            return;
        }
        Component[] componentArray = this.getComponents();
        int n3 = 0;
        for (n2 = 0; n2 < componentArray.length; ++n2) {
            n = componentArray[n2].getBounds().y + componentArray[n2].getBounds().height;
            if (n <= n3) continue;
            n3 = n;
        }
        n2 = this.getBounds().height - n3;
        n = this.maxComp.getBounds().y;
        for (int i = 0; i < componentArray.length; ++i) {
            Rectangle rectangle = componentArray[i].getBounds();
            if (componentArray[i] == this.maxComp) {
                componentArray[i].setBounds(rectangle.x, rectangle.y, this.maximizeInYOnly ? componentArray[i].getBounds().width : this.getBounds().width - rectangle.x, rectangle.height + n2);
                continue;
            }
            if (rectangle.y <= n) continue;
            componentArray[i].setBounds(rectangle.x, rectangle.y + n2, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void layout() {
        this.maximizeComp();
        super.layout();
    }

    protected String resolveQueryField() throws Exception {
        if (this.radius != null) {
            this.resolveRadius(this.radius.getText().trim(), false);
        }
        if (this.target == null) {
            return null;
        }
        return this.resolveTarget(this.target.getText().trim());
    }

    protected String getTarget() {
        return this.getTarget(true);
    }

    protected String getTarget(boolean bl) {
        if (this.target == null) {
            return null;
        }
        String string = this.target.getText().trim();
        if (bl && string.length() == 0) {
            if (this.ball != null) {
                this.ball.setMode(3);
            }
            Aladin.warning(this, this.WNEEDOBJ);
            return null;
        }
        return this.aladin.localisation.getICRSCoord(string);
    }

    protected String getRadius() {
        return this.getRadius(true);
    }

    protected String getRadius(boolean bl) {
        if (this.radius == null) {
            return null;
        }
        String string = this.radius.getText().trim();
        if (!bl) {
            return string;
        }
        if (bl && (string.length() == 0 || Server.getRM(string) <= 0.0)) {
            this.ball.setMode(3);
            Aladin.warning(this, this.WNEEDRAD);
            return null;
        }
        return string;
    }

    protected String getDate(boolean bl) {
        if (this.date == null) {
            return null;
        }
        String string = this.date.getText().trim();
        if (string.length() == 0) {
            this.ball.setMode(3);
            if (bl) {
                Aladin.warning(this, this.WNEEDDATE);
            }
            return null;
        }
        return string;
    }

    protected static double getAngleInArcmin(String string, int n) {
        int n2;
        double d = 1.0;
        int n3 = string.indexOf(176);
        int n4 = string.indexOf(100);
        int n5 = string.indexOf(115);
        int n6 = string.indexOf(34);
        int n7 = string.indexOf(39);
        int n8 = string.indexOf(109);
        if (n3 > 0 || n4 > 0 && (n5 == -1 || n4 > n5)) {
            d = 60.0;
        } else if (n5 > 0 || n6 > 0) {
            d = 0.016666666666666666;
        } else if (n7 > 0 || n8 > 0) {
            d = 1.0;
        } else if (n == 8) {
            d = 60.0;
        } else if (n == 16) {
            d = 0.016666666666666666;
        }
        string = new StringTokenizer(string).nextToken();
        char[] cArray = string.toCharArray();
        for (n2 = 0; n2 < cArray.length && (cArray[n2] >= '0' && cArray[n2] <= '9' || cArray[n2] == '.' || cArray[n2] == '-'); ++n2) {
        }
        string = new String(cArray, 0, n2);
        return Double.valueOf(string) * d;
    }

    protected static double getRM(String string) {
        return Server.getRWM(string, 0);
    }

    protected static double getWM(String string) {
        return Server.getRWM(string, 1);
    }

    protected static double getHM(String string) {
        return Server.getRWM(string, 2);
    }

    private static double getRWM(String string, int n) {
        double d;
        double d2;
        double d3;
        if (string.length() == 0) {
            return 0.0;
        }
        int n2 = string.indexOf(44);
        if (n2 < 0) {
            n2 = string.trim().indexOf(120);
        }
        if (n2 < 0) {
            d3 = Server.getAngleInArcmin(string, 1);
            d = d2 = 2.0 * d3;
        } else {
            d2 = Server.getAngleInArcmin(string.substring(0, n2), 1);
            d = Server.getAngleInArcmin(string.substring(n2 + 1), 1);
            d3 = Math.sqrt(d2 * d2 / 4.0 + d * d / 4.0);
        }
        switch (n) {
            case 0: {
                return d3;
            }
            case 1: {
                return d2;
            }
            case 2: {
                return d;
            }
        }
        return 0.0;
    }

    protected void clear() {
        this.ball.setMode(0);
        this.resolveRadius("14", true);
        if (this.target != null) {
            this.target.setText("");
        }
        this.aladin.dialog.setDefaultTarget("");
    }

    protected void setStepColor(JLabel jLabel, JLabel jLabel2) {
        JLabel jLabel3;
        JLabel jLabel4;
        if (this.tree == null) {
            return;
        }
        if (this.tree.isEmpty()) {
            jLabel4 = jLabel;
            jLabel3 = jLabel2;
        } else {
            jLabel3 = jLabel;
            jLabel4 = jLabel2;
        }
        jLabel4.setForeground(Color.blue);
        jLabel3.setForeground(Color.black);
        String string = jLabel3.getText();
        if (string.startsWith(EXERGUE)) {
            jLabel3.setText(string.substring(EXERGUE.length()));
        }
        if (!(string = jLabel4.getText()).startsWith(EXERGUE)) {
            jLabel4.setText(EXERGUE + string);
        }
    }

    protected void reset() {
        this.ball.setMode(0);
        this.aladin.dialog.setDefaultParameters(this.aladin.dialog.getCurrent(), 5);
    }

    protected void setTarget(String string) {
        if (this.target == null || string.equals(this.aladin.GETOBJ)) {
            return;
        }
        this.target.setText(string);
    }

    protected boolean updateWidgets() {
        if (this.aladin.dialog == null) {
            return false;
        }
        if (!this.aladin.dialog.isGrabIt() && this.grab != null) {
            Plan plan = this.aladin.calque.getPlanRef();
            boolean bl = plan != null && Projection.isOk(plan.projd);
            this.grab.setEnabled(bl);
        }
        return true;
    }

    protected void setDate(String string) {
        if (this.date == null) {
            return;
        }
        try {
            double d = Double.valueOf(string);
            string = Astrodate.JDToDate(Astrodate.YdToJD(d));
            this.date.setText(string);
        }
        catch (Exception exception) {
            this.date.setText(string);
        }
        try {
            this.date.setCaretPosition(Math.min(this.date.getCaretPosition(), string.length()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setSelectedItem(Component component, String string) {
        if (component instanceof TextField) {
            ((TextField)component).setText(string);
            return;
        }
        this.resumeInputChoice();
        ((JComboBox)component).setSelectedItem(string);
    }

    protected Plan[] getInputPlane(JComponent jComponent) {
        Object[] objectArray;
        String string;
        int n = this.getFieldInput(jComponent);
        if (n == -1) {
            return null;
        }
        if ((this.modeInput[n] & 0x15) != 0 ? (string = (String)((JComboBox)jComponent).getSelectedItem()).equals(this.NOINPUTITEM) : (string = ((JTextField)jComponent).getText().trim()).length() == 0) {
            return null;
        }
        Vector vector = this.aladin.calque.getPlans(string);
        if (vector == null) {
            return null;
        }
        Vector<Object[]> vector2 = new Vector<Object[]>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (!objectArray.flagOk || (this.modeInput[n] & 0xC) != 0 && !objectArray.isSimpleCatalog() || (this.modeInput[n] & 0x13) != 0 && !objectArray.isImage()) continue;
            vector2.addElement(objectArray);
            if ((this.modeInput[n] & 0x15) == 0) continue;
            break;
        }
        if (vector2.size() == 0) {
            return null;
        }
        objectArray = new Plan[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    protected String getInputPlaneName(JComponent jComponent) {
        Plan[] planArray = this.getInputPlane(jComponent);
        if (planArray == null) {
            return "";
        }
        StringBuffer stringBuffer = null;
        for (int i = 0; i < planArray.length; ++i) {
            String string = planArray[i].getLabel();
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string);
                continue;
            }
            stringBuffer.append(" " + string);
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }

    protected String getInputUrl(JComponent jComponent) {
        Plan[] planArray = this.getInputPlane(jComponent);
        if (planArray == null) {
            return "";
        }
        StringBuffer stringBuffer = null;
        for (int i = 0; i < planArray.length; ++i) {
            String string = planArray[i].getUrl();
            if (string == null || string.startsWith("file:")) {
                string = Export.export(planArray[i]);
            }
            if (string == null) continue;
            string = Server.backSlashPipe(string);
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string);
                continue;
            }
            stringBuffer.append("|" + string);
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }

    protected static String backSlashPipe(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(100);
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '|') {
                stringBuffer.append("\\|");
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    protected boolean isFieldTargetOrRadius(JComponent jComponent) {
        if (this.coo != null) {
            if (this.coo[0] == jComponent) {
                return true;
            }
            if (this.coo.length > 1 && this.coo[1] == jComponent) {
                return true;
            }
        }
        if (this.rad != null) {
            if (this.rad[0] == jComponent) {
                return true;
            }
            if (this.rad.length > 1 && this.rad[1] == jComponent) {
                return true;
            }
        }
        return false;
    }

    protected boolean isFieldDate(JComponent jComponent) {
        return this.date != null;
    }

    protected boolean isFieldInput(JComponent jComponent) {
        return this.getFieldInput(jComponent) >= 0;
    }

    protected int getFieldInput(JComponent jComponent) {
        if (this.input == null) {
            return -1;
        }
        for (int i = 0; i < this.nbInput; ++i) {
            if (this.input[i] != jComponent) continue;
            return i;
        }
        return -1;
    }

    protected void resumeInputChoice() {
        if (this.input == null) {
            return;
        }
        Vector<Plan> vector = this.aladin.calque.getPlanCat();
        Vector<Plan> vector2 = this.aladin.calque.getPlanImg();
        Vector<Plan> vector3 = this.aladin.calque.getPlanAllImg();
        for (int i = 0; i < this.nbInput; ++i) {
            if ((this.modeInput[i] & 0x15) == 0) continue;
            this.adjustInputChoice((JComboBox)this.input[i], (this.modeInput[i] & 1) != 0 ? vector2 : ((this.modeInput[i] & 0x10) != 0 ? vector3 : vector), 0);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.resumeTargetLabel();
            this.resumeInputChoice();
        }
        super.setVisible(bl);
    }

    protected void adjustInputChoice(JComboBox jComboBox, Vector vector, int n) {
        int n2 = jComboBox.getSelectedIndex();
        String string = n2 >= 0 ? (String)jComboBox.getItemAt(n2) : null;
        jComboBox.removeAllItems();
        jComboBox.addItem(this.NOINPUTITEM);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                jComboBox.addItem(((Plan)enumeration.nextElement()).label);
            }
        }
        if (n > 0) {
            jComboBox.setSelectedIndex(n);
        } else if (string == null || string.equals(this.NOINPUTITEM)) {
            jComboBox.setSelectedIndex(jComboBox.getItemCount() > 1 ? 1 : 0);
        } else {
            jComboBox.setSelectedItem(string);
        }
    }

    protected boolean is(String string) {
        if (string.endsWith("s")) {
            string = string.substring(0, string.length() - 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.aladinLabel, " .");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken(" ()");
            if (string2.endsWith("s")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    protected int createPlane(String string, String string2, String string3, String string4, String string5) {
        return -1;
    }

    protected boolean verif(int n, String string, String string2) {
        return this.verif(n, string, string2, null);
    }

    protected boolean verif(int n, String string, String string2, String string3) {
        return true;
    }

    static String specialUnQuoteCriteria(String string) {
        if (string == null || string.length() < 2) {
            return string;
        }
        StringBuffer stringBuffer = null;
        Tok tok = new Tok(string, " ,");
        while (tok.hasMoreTokens()) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(tok.nextToken());
                continue;
            }
            stringBuffer.append("," + tok.nextToken());
        }
        return stringBuffer.toString();
    }

    protected boolean tooManyChecked() {
        int n = this.tree.nbSelected();
        if (n > 0 && n < 10) {
            return false;
        }
        return !Aladin.confirmation(this, this.NOTTOOMANY + " (" + n + ")");
    }

    public void submit() {
    }

    protected String getDefaultTarget() {
        return this.aladin.dialog.getDefaultTarget();
    }

    protected String getDefaultTaille() {
        return this.aladin.dialog.getDefaultTaille();
    }

    protected String getDefaultDate() {
        return this.aladin.dialog.getDefaultDate();
    }

    protected void memTarget() {
        if (this.target != null && this.modeCoo != 0) {
            this.aladin.dialog.setDefaultTarget(this.target.getText().trim());
        }
        if (this.radius != null && this.modeRad != 0) {
            this.aladin.dialog.setDefaultTaille(this.radius.getText().trim());
        }
    }

    protected void showStatusReport() {
        if (this.aladin.frameInfoServer == null) {
            this.aladin.frameInfoServer = new FrameInfoServer(this.aladin);
        }
        this.aladin.frameInfoServer.show(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JComboBox && this.tree != null && !this.tree.isEmpty()) {
            this.tree.clear();
        }
        this.updateWidgets();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() instanceof JTextField) {
            if (this.tree != null && !this.tree.isEmpty() && !keyEvent.isActionKey() && (keyEvent.getModifiers() == 0 || keyEvent.isShiftDown() && keyEvent.getKeyCode() != 16)) {
                this.tree.clear();
            }
            if (this.ball != null) {
                this.ball.setMode(0);
            }
            if (keyEvent.getKeyCode() == 10) {
                this.flagVerif = !keyEvent.isShiftDown();
                this.submit();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.updateWidgets();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    protected String[] getNomPaths() {
        char c;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.aladinMenu != null) {
            for (n = 0; n < this.aladinMenu.length(); ++n) {
                c = this.aladinMenu.charAt(n);
                if (c == '/') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
            while (stringBuffer.charAt(n = stringBuffer.length() - 1) == '.') {
                stringBuffer.deleteCharAt(n);
            }
            stringBuffer.append('/');
        }
        for (n = 0; n < this.aladinLabel.length(); ++n) {
            c = this.aladinLabel.charAt(n);
            if (c == '/') {
                stringBuffer.append('\\');
            }
            if (c == '\n') {
                c = ' ';
            }
            stringBuffer.append(c);
        }
        return new String[]{stringBuffer.toString()};
    }

    protected boolean sameNom(String string) {
        return Server.sameNom(this.aladinLabel, string);
    }

    protected static boolean sameNom(String string, String string2) {
        int n = string.length();
        if (string2.length() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = string.charAt(i);
            int n3 = string2.charAt(i);
            if (n2 == 10) {
                n2 = 32;
            }
            if (n3 == 10) {
                n3 = 32;
            }
            if (n2 == n3) continue;
            return false;
        }
        return true;
    }

    protected boolean setParam(String string) {
        return false;
    }

    protected String getNom() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.aladinLabel);
        return stringTokenizer.nextToken();
    }

    protected Frame getFrame(Component component) {
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    protected static String getFilterDescription(String string) {
        if (string.charAt(0) != '#') {
            return null;
        }
        int n = string.indexOf(10);
        if (n < 0) {
            return null;
        }
        return string.substring(1, n).trim();
    }

    protected static String getFilterName(String string) {
        int n = string.indexOf((string.charAt(0) == '#' ? "\n" : "") + "filter ");
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(123, n);
        String string2 = string.substring(n + 7, n2).trim();
        return string2;
    }

    protected static String getFilter(String string) {
        int n = string.indexOf((string.charAt(0) == '#' ? "\n" : "") + "filter ");
        if (n < 0) {
            return null;
        }
        return string.substring(n).trim();
    }

    protected static int getFilterIndex(String[] stringArray, String string) {
        String string2;
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            string2 = Server.getFilterName(stringArray[n]);
            if (string2 == null || !string2.equals(string)) continue;
            return n;
        }
        for (n = 0; n < stringArray.length; ++n) {
            string2 = Server.getFilterDescription(stringArray[n]);
            if (string2 == null || !string2.equals(string)) continue;
            return n;
        }
        return -1;
    }

    protected static String getFilterScript(String string) {
        int n = string.indexOf(123);
        int n2 = string.lastIndexOf(125);
        if (n < 0 || n2 < 0) {
            return null;
        }
        return string.substring(n + 1, n2).trim();
    }

    protected JComboBox createFilterChoice() {
        this.filtersChoice = new JComboBox();
        this.populateFilterChoice(this.filtersChoice);
        return this.filtersChoice;
    }

    protected void modifyFilterChoice(String[] stringArray) {
        this.filters = stringArray;
        if (this.filtersChoice == null) {
            this.filtersChoice = this.createFilterChoice();
        } else {
            this.filtersChoice.removeAll();
            this.populateFilterChoice(this.filtersChoice);
        }
    }

    private void populateFilterChoice(JComboBox jComboBox) {
        jComboBox.addItem(" - no filter -");
        for (int i = 0; i < this.filters.length; ++i) {
            String string = Server.getFilterDescription(this.filters[i]);
            if (string == null) {
                string = Server.getFilterName(this.filters[i]);
            }
            if (string == null) continue;
            jComboBox.addItem(string);
        }
        jComboBox.setSelectedIndex(this.aladin.configuration.getFilter() + 1);
    }

    protected void getGluFilters(String string) {
        Object v;
        if (this.aladin.glu.aladinDicFilters != null && (v = this.aladin.glu.aladinDicFilters.get(string)) != null) {
            this.filters = (String[])v;
        }
    }

    protected int getFilterChoiceIndex() {
        int n = -1;
        if (this.filtersChoice != null) {
            n = Server.getFilterIndex(this.filters, (String)this.filtersChoice.getSelectedItem());
        }
        return n;
    }

    protected void setStatus() {
        Plan[] planArray = this.aladin.calque.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan = planArray[i];
            if (plan.server != this || plan.type == 0) continue;
            if (!plan.flagOk && plan.error == null) {
                this.ball.setMode(4);
            } else if (plan.error != null && !plan.hasNoReduction()) {
                this.ball.setMode(5);
            } else if (plan.error != null) {
                this.ball.setMode(3);
            } else {
                this.ball.setMode(1);
            }
            return;
        }
        if (this.ball.isBlinking()) {
            this.ball.setMode(0);
        }
    }

    protected int addFilterComment(int n, int n2) {
        JLabel jLabel = new JLabel(this.HASFILTER1);
        jLabel.setFont(Aladin.ITALIC);
        jLabel.setBounds(n, n2, 455 - n, 20);
        n2 += 18;
        jLabel.setForeground(Color.blue);
        this.add(jLabel);
        jLabel = new JLabel(this.HASFILTER2);
        jLabel.setFont(Aladin.ITALIC);
        jLabel.setBounds(n, n2, 455 - n, 20);
        jLabel.setForeground(Color.blue);
        this.add(jLabel);
        return n2 += 18;
    }

    protected static Comparator getComparator() {
        return new Server();
    }

    public int compare(Object object, Object object2) {
        Server server = (Server)object;
        Server server2 = (Server)object2;
        if (server.ordre == server2.ordre) {
            return 0;
        }
        if (server.ordre == null) {
            return -1;
        }
        if (server2.ordre == null) {
            return 1;
        }
        return server.ordre.compareTo(server2.ordre);
    }
}

